package com.chenyang.nse.bussiness.service.core.impl;

import cn.hutool.core.util.ObjectUtil;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDataAreaDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreDesensitizationRuleDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataArea;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreDesensitizationRule;
import com.chenyang.nse.bussiness.service.core.DesensitizationRuleService;
import com.chenyang.nse.bussiness.tools.expression.ExpressionTool;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DesensitizationRuleServiceImpl implements DesensitizationRuleService {
   @Autowired
   TCoreDesensitizationRuleDao tCoreDesensitizationRuleDao;
   @Autowired
   TCoreDataAreaDao tCoreDataAreaDao;

   public String save(TCoreDesensitizationRule rule) {
      String ruleId = rule.getId();
      String defaluttype = rule.getDefaluttype();
      if ("1".equals(defaluttype)) {
         TCoreDesensitizationRule temp = (TCoreDesensitizationRule)this.tCoreDesensitizationRuleDao.queryUnique(new Criterion[]{Restrictions.eq("dataarea_id", rule.getDataarea_id()), Restrictions.eq("defaluttype", "1")});
         if (temp != null && !ruleId.equals(temp.getId())) {
            temp.setDefaluttype("0");
            this.tCoreDesensitizationRuleDao.saveOrUpdate(temp);
         }
      }

      if (!"".equals(ruleId) && ruleId != null) {
         this.tCoreDesensitizationRuleDao.getSession().merge(rule);
      } else {
         if (!"1".equals(this.checkName(rule))) {
            return "0";
         }

         this.tCoreDesensitizationRuleDao.save(rule);
      }

      return "1";
   }

   public void delete(String ruleId) {
      TCoreDesensitizationRule rule = (TCoreDesensitizationRule)this.tCoreDesensitizationRuleDao.get(ruleId);
      String dataarea_id = rule.getDataarea_id();
      List<TCoreDesensitizationRule> list = this.tCoreDesensitizationRuleDao.queryAll(new Criterion[]{Restrictions.eq("dataarea_id", dataarea_id)});
      if (list != null && list.size() > 0) {
         ((TCoreDesensitizationRule)list.get(0)).setDefaluttype("1");
         this.tCoreDesensitizationRuleDao.update(list.get(0));
      }

      this.tCoreDesensitizationRuleDao.removeById(ruleId);
   }

   public List<TCoreDataArea> queryRuleList(String dataarea) {
      List<TCoreDataArea> arealist;
      if (ObjectUtil.isEmpty(dataarea)) {
         arealist = this.tCoreDataAreaDao.queryAll(Order.asc("areatype"), Order.desc("createtime"));
      } else {
         arealist = this.tCoreDataAreaDao.queryAll(Order.asc("areatype"), Order.desc("createtime"), new Criterion[]{Restrictions.like("dataarea", dataarea, MatchMode.ANYWHERE)});
      }

      for (TCoreDataArea dataArea : arealist) {
         List<TCoreDesensitizationRule> rulelist = this.tCoreDesensitizationRuleDao.queryAll(new Criterion[]{Restrictions.eq("dataarea_id", dataArea.getId())});
         dataArea.setRuleList(rulelist);
      }

      return arealist;
   }

   public String test(String param, String expression) {
      ExpressionTool et = new ExpressionTool();
      et.init();
      String newExp = expression.replace("$(value)", "'" + param + "'");
      Object o = null;
      String var11 = null;
      try {
         var11 = ExpressionTool.execExpress(newExp, (Object)et);
      } catch (Exception exception) {
         try {
            newExp = expression.replace("$(value)", "" + param + "");
            var11 = ExpressionTool.execExpress(newExp, (Object)et);
         } catch (Exception var8) {
            exception.printStackTrace();
            return "表达式错误!";
         }
      }

      return var11.toString();
   }

   public void setdefault(String ruleId) {
      TCoreDesensitizationRule rule = (TCoreDesensitizationRule)this.tCoreDesensitizationRuleDao.get(ruleId);
      List<TCoreDesensitizationRule> list = this.tCoreDesensitizationRuleDao.queryAll(new Criterion[]{Restrictions.eq("dataarea_id", rule.getDataarea_id()), Restrictions.eq("defaluttype", "1")});
      if (list != null && list.size() > 0) {
         for(TCoreDesensitizationRule tCoreDesensitizationRule : list) {
            tCoreDesensitizationRule.setDefaluttype("0");
            this.tCoreDesensitizationRuleDao.update(tCoreDesensitizationRule);
         }
      }

      rule.setDefaluttype("1");
      this.tCoreDesensitizationRuleDao.update(rule);
   }

   public String checkName(TCoreDesensitizationRule rule) {
      if (!ObjectUtil.isEmpty(rule.getDataarea_id())) {
         String dataareaId = rule.getDataarea_id();

         for(TCoreDesensitizationRule tCoreDesensitizationRule : this.tCoreDesensitizationRuleDao.queryAll(new Criterion[]{Restrictions.eq("dataarea_id", dataareaId)})) {
            if (tCoreDesensitizationRule.getRulename().equals(rule.getRulename())) {
               return "0";
            }
         }

         return "1";
      } else {
         return "0";
      }
   }
}
