package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationMonitorDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationMonitorInfoDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationMonitor;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationMonitorInfo;
import com.chenyang.nse.bussiness.service.core.DesensitizationtaskLogService;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DesensitizationtaskLogServiceImpl implements DesensitizationtaskLogService {
   @Autowired
   private DesensitizationMonitorDao desensitizationMonitorDao;
   @Autowired
   private DesensitizationMonitorInfoDao desensitizationMonitorInfoDao;

   public List readFileToPage(String taskName, String taskTableName, String logType, Long groupid) {
      String engineLog = "D:/";
      String fileUrl = "";
      SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
      String groupiddate = simpleDateFormat.format(groupid);
      if (logType != "R" && !logType.equals("R")) {
         fileUrl = engineLog + StringTool.hanziToPinyinFirst(taskName) + "/" + groupiddate + "/ProgressLog/" + taskTableName + ".txt";
      } else {
         fileUrl = engineLog + StringTool.hanziToPinyinFirst(taskName) + "/" + groupiddate + "/RunningLog/" + taskTableName + ".txt";
      }

      System.out.println(fileUrl);
      InputStream inputStream = null;
      BufferedReader br = null;

      try {
         inputStream = new FileInputStream(fileUrl);
         br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
         List list = new ArrayList();

         String line;
         while((line = br.readLine()) != null) {
            System.out.println(line);
            if (logType != "R" && !logType.equals("R")) {
               String[] p = line.split("#\\|\\|#");
               list.add(p);
            } else {
               String logstr = line.replaceAll("#\\|\\|#", " : ");
               list.add(logstr);
            }
         }

         System.out.println("读取完毕!");
         Object var35 = list;
         return (List)var35;
      } catch (FileNotFoundException e) {
         e.printStackTrace();
      } catch (IOException e) {
         e.printStackTrace();
      } finally {
         if (inputStream != null) {
            try {
               inputStream.close();
            } catch (IOException e) {
               e.printStackTrace();
            }
         }

         if (br != null) {
            try {
               br.close();
            } catch (IOException e) {
               e.printStackTrace();
            }
         }

      }

      return null;
   }

   public List<DesensitizationMonitor> queryImportData() {
      return this.desensitizationMonitorDao.queryMonitorByIsimport();
   }

   public void saveMonitorInfo(DesensitizationMonitorInfo desensitizationMonitorInfo) {
      this.desensitizationMonitorInfoDao.save(desensitizationMonitorInfo);
   }
}
