package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.table.core.DgDefineRuleDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.DgDefineRule;
import com.chenyang.nse.bussiness.service.core.DgDefinedRuleService;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DgDefinedRuleServiceImpl implements DgDefinedRuleService {
   @Autowired
   private DgDefineRuleDao dgDefineRuleDao;

   public List<DgDefineRule> queryAll(String type, String user) {
      return this.dgDefineRuleDao.queryAll(Order.desc("operationtime"), new Criterion[]{Restrictions.eq("module", type), Restrictions.like("operationUser", user, MatchMode.ANYWHERE), Restrictions.eq("flag", "1")});
   }

   public List<DgDefineRule> queryAll(String user) {
      return this.dgDefineRuleDao.queryAll(Order.desc("operationtime"), new Criterion[]{Restrictions.like("operationUser", user, MatchMode.ANYWHERE), Restrictions.eq("flag", "1")});
   }

   public List<DgDefineRule> queryLogByProjectId(String projectid) {
      return this.dgDefineRuleDao.queryAll(Order.desc("operationtime"), new Criterion[]{Restrictions.eq("flag", "2"), Restrictions.eq("projectId", projectid)});
   }
}
