package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.core.EngineDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreConfigDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreEngineDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationFileDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationMonitorDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationTablecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationsourceDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationtableDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationtargetDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationtaskDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructureDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructurespliterDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingRuleinfoDao;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.LoginWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.LogoutWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.MultiGetSessionStatisticsWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.SessionBean;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.StartWorkFlowWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.DIServiceInfo;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.DataIntegrationInterface;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.DataIntegrationService;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.ETaskRunMode;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.Fault;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.SessionHeader;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.TypeStartWorkflowExRequest;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.TypeStartWorkflowExResponse;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.WorkflowRequest;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.ModifyImportFile;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.InfoExecUtil;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.ToObjutil;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUser;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreConfig;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationFile;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationTable;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationTablecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationsource;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationtarget;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationtask;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TCoreFieldSensitiveMemory;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructure;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurespliter;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRuleinfo;
import com.chenyang.nse.bussiness.entity.redis.TCoreMaskingTaskTableInfo;
import com.chenyang.nse.bussiness.entity.redis.TCoreMaskingTaskTableSchema;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingType;
import com.chenyang.nse.bussiness.service.console.DesensitizationDataMappingService;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.DmpDesensitizationService;
import com.chenyang.nse.bussiness.thread.ExecuteParam;
import com.chenyang.nse.bussiness.tools.command.CommandTool;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.io.PipeTool;
import com.chenyang.nse.bussiness.tools.jdbc.DB2LoadTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.jdbc.MysqlLoadTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.SqlServerBcpTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.SybaseBcpTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.SybaseIQLoadTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.TeradataLoadTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.TeradataTool;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import com.chenyang.nse.bussiness.tools.redis.RedisClient;
import com.chenyang.nse.bussiness.tools.redis.RedisTool;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import com.power.xml.entity.ColumnInfo;
import com.power.xml.entity.Config;
import com.power.xml.entity.FlatFile;
import com.power.xml.entity.Info;
import com.power.xml.entity.SourceInfo;
import com.power.xml.entity.TargetInfo;
import com.power.xml.entity.externalcall.DataBaseType;
import com.power.xml.external.PowerXml;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.Jedis;

@Service
@Repository
@EnableAsync
@Transactional
public class DmpDesensitizationServiceImpl implements DmpDesensitizationService {
   private static final String Link_character = "_";
   private static final String FILE_PATH = "/data/infa_file/";
   private static final boolean isteststate = false;
   @Autowired
   private TCoreEngineDao tCoreEngineDao;
   @Autowired
   private EngineDao engineDao;
   @Autowired
   private DesensitizationtaskDao desensitizationtaskDao;
   @Autowired
   private DesensitizationsourceDao desensitizationsourceDao;
   @Autowired
   private DesensitizationtargetDao desensitizationtargetDao;
   @Autowired
   private DesensitizationtableDao desensitizationTableDao;
   @Autowired
   private DesensitizationTablecolumnDao desensitizationTablecolumnDao;
   @Autowired
   private DesensitizationDataMappingService desensitizationdataMappingService;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   private TCoreMaskingRuleinfoDao tCoreMaskingRuleinfoDao;
   @Autowired
   private HttpServletRequest request;
   @Autowired
   private ToObjutil to;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private ThreadPoolTaskExecutor taskExecutor;
   @Autowired
   private OperationService operationService;
   @Autowired
   private DesensitizationMonitorDao desensitizationMonitorDao;
   @Autowired
   private DesensitizationFileDao desensitizationFileDao;
   @Autowired
   private TCoreFileStructureDao tCoreFileStructureDao;
   @Autowired
   private TCoreFileStructurespliterDao tCoreFileStructurespliterDao;
   @Autowired
   private TCoreConfigDao tCoreConfigDao;

   public List<Desensitizationtask> queryTask(String taskname, PageInfo pageInfo) {
      List<Desensitizationtask> list = this.desensitizationtaskDao.queryByPageInfo(pageInfo, Order.desc("updatatime"), new Criterion[]{Restrictions.like("taskname", "%" + taskname + "%"), Restrictions.eq("flag", "2")});
      return list;
   }

   public void saveDesensitizationtask(String tasknamereal, Jedis jedis, Desensitizationtask desensitizationtask, LoginUser loginUser) {
      byte[] byt_task = jedis.get((tasknamereal + "_" + desensitizationtask.getClass().getSimpleName()).getBytes());
      if (byt_task != null) {
         Object obj = RedisTool.unserizlize(byt_task);
         desensitizationtask = (Desensitizationtask)obj;
      }

      desensitizationtask.setCreatetime(new Date());
      desensitizationtask.setUpdatatime(new Date());
      TBaseUser user = loginUser.getTsysUser();
      desensitizationtask.setUserid(user.getId());
      desensitizationtask.setUsername(user.getUsername());
      this.desensitizationtaskDao.save(desensitizationtask);
   }

   public Desensitizationtarget saveDesensitizationtarget(String tasknamereal, String taskid, Jedis jedis, Desensitizationtarget desensitizationtarget, String state) {
      switch (state) {
         case "3":
            byte[] byt_target = jedis.get((tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName()).getBytes());
            if (byt_target != null) {
               Object obj = RedisTool.unserizlize(byt_target);
               desensitizationtarget = (Desensitizationtarget)obj;
            }

            desensitizationtarget.setTaskid(taskid);
            this.desensitizationtargetDao.save(desensitizationtarget);
            break;
         case "2":
            desensitizationtarget = (Desensitizationtarget)this.desensitizationtargetDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
      }

      return desensitizationtarget;
   }

   public Desensitizationsource saveDesensitizationsource(String tasknamereal, String taskid, Jedis jedis, Desensitizationsource desensitizationsource, String state) {
      switch (state) {
         case "3":
            byte[] byt_source = jedis.get((tasknamereal + "_" + desensitizationsource.getClass().getSimpleName()).getBytes());
            if (byt_source != null) {
               Object obj = RedisTool.unserizlize(byt_source);
               desensitizationsource = (Desensitizationsource)obj;
            }

            desensitizationsource.setTaskid(taskid);
            this.desensitizationsourceDao.save(desensitizationsource);
            break;
         case "2":
            desensitizationsource = (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
      }

      return desensitizationsource;
   }

   public DesensitizationFile saveDesensitizationFile(String tasknamereal, String taskid, Jedis jedis, DesensitizationFile desensitizationFile, String state) {
      switch (state) {
         case "3":
            byte[] byt_source = jedis.get((tasknamereal + "_" + desensitizationFile.getClass().getSimpleName()).getBytes());
            if (byt_source != null) {
               Object obj = RedisTool.unserizlize(byt_source);
               desensitizationFile = (DesensitizationFile)obj;
            }

            desensitizationFile.setTaskid(taskid);
            this.desensitizationFileDao.save(desensitizationFile);
            break;
         case "2":
            desensitizationFile = (DesensitizationFile)this.desensitizationFileDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
      }

      return desensitizationFile;
   }

   public void getDesensitizationTable(List<Map<String, String>> tCoreMaskingTaskTableList) {
      tCoreMaskingTaskTableList = (List)tCoreMaskingTaskTableList.stream().filter((s) -> "1".equals(s.get("status")) || "3".equals(s.get("status"))).collect(Collectors.toList());
   }

   public Map<String, String> EdataMappingType() {
      Map<String, String> map = new HashMap();

      for(EdataMappingType em : EdataMappingType.values()) {
         map.put(em.getName(), em.getFlag());
      }

      return map;
   }

   public Map<String, Object> saveDesensitizationTable(Desensitizationtask desensitizationtask, String taskid, Jedis jedis, List<DesensitizationTable> desensitizationTableList, Desensitizationsource desensitizationsource, Desensitizationtarget desensitizationtarget, List<Map<String, String>> tablelistmap, String state, DesensitizationFile desensitizationfile, Map<String, String> map_table_filterConditions) throws Exception {
      String save_state = "0";
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String tasknamereal = desensitizationtask.getTasknamereal();
      String mappletDir = props.getProperty("mappletDir");
      InfoProperty infoProperty = this.getInfoProperty();
      String xml_folder_path = "";
      xml_folder_path = infoProperty.getXmldir() + File.separator + "masking_task" + File.separator;
      String xml_file_path = xml_folder_path + tasknamereal + ".xml";
      Map<String, Object> map_xml = new HashMap();
      map_xml.put("createtable", true);
      List<Info> infoList = new ArrayList();
      if (!FileTool.isFileExit(xml_folder_path)) {
         FileTool.createFolder(xml_folder_path);
      }

      TCoreDatasystem datasystemdesensitizationtarget = (TCoreDatasystem)this.tCoreDatasystemDao.get(desensitizationtarget.getDatasourceid());
      TCoreDatasystem datasystemdesensitizationsource = null;
      if (desensitizationsource.getDatasourceid() != null) {
         datasystemdesensitizationsource = (TCoreDatasystem)this.tCoreDatasystemDao.get(desensitizationsource.getDatasourceid());
      }

      String baseType = this.returnBaseType(datasystemdesensitizationtarget, datasystemdesensitizationsource);
      desensitizationtask.setTasktype(baseType);
      String getDbtype_t = datasystemdesensitizationtarget == null ? "FILE" : datasystemdesensitizationtarget.getDbtype();
      String getDbtype_s = datasystemdesensitizationsource == null ? "FILE" : datasystemdesensitizationsource.getDbtype();
      String targettype = "";
      String sourcetype = "";
      Boolean targetisfile = false;
      switch (getDbtype_t) {
         case "FILE":
            targettype = "FILE";
            break;
         case "FTP":
            targettype = "FILE";
            break;
         case "SFTP":
            targettype = "FILE";
            break;
         default:
            targettype = "DB";
      }

      switch (getDbtype_s) {
         case "FILE":
            sourcetype = "FILE";
            break;
         case "FTP":
            sourcetype = "FILE";
            break;
         case "SFTP":
            sourcetype = "FILE";
            break;
         default:
            sourcetype = "DB";
      }

      if ("FILE".equals(targettype)) {
         targetisfile = true;
      }

      Map<String, String> mapparam = new HashMap();
      mapparam.put("folderName", desensitizationtask.getFoldername());
      mapparam.put("execution_type_s", desensitizationsource.getExecution_type());
      mapparam.put("execution_type_t", desensitizationtarget.getExecution_type());
      mapparam.put("domainName", infoProperty.getDomainname());
      mapparam.put("mappletDir", mappletDir);
      mapparam.put("repository", infoProperty.getRepository());
      mapparam.put("xmlLocation", xml_file_path);
      mapparam.put("serverName", infoProperty.getInteservicename());
      mapparam.put("target_type", targettype);
      mapparam.put("source_type", sourcetype);
      mapparam.put("isrecover", desensitizationtask.getIsrecover());
      mapparam.put("hdfsDir", props.getProperty("hdfs_dir"));
      Config pwc_config = this.pwc_config(mapparam);
      switch (state) {
         case "2":
            this.desensitizationTableDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
            this.desensitizationTablecolumnDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
            this.updateTask(tasknamereal, "0");
         default:
            boolean issomedb = true;
            if (getDbtype_t.equals(getDbtype_s)) {
               issomedb = true;
            } else {
               issomedb = false;
            }

            Connection tconn = null;
            if (!targetisfile) {
               tconn = this.getConnectionByDataSystemId(datasystemdesensitizationtarget);
            }

            Map<String, String> datamap = this.EdataMappingType();
            List<Map<String, String>> map_t = this.desensitizationdataMappingService.getDatamappingInfo((String)datamap.get(targetisfile ? "FILESYSTEM" : datasystemdesensitizationtarget.getDbtype().toUpperCase()), "10");
            List<Map<String, String>> map_s = this.desensitizationdataMappingService.getDatamappingInfo((String)datamap.get("ORACLE"), "10");
            Map<String, String> data_rule = this.getDataRuleMap();
            Map<String, String> data_s = new HashMap();
            Map<String, Map<String, String>> data_t = new HashMap();
            Map<String, Map<String, String>> data_s_length = new HashMap();
            Map<String, Map<String, String>> data_t_length = new HashMap();
            Map<String, Map<String, String>> data_t_x_length = new HashMap();

            for(Map<String, String> map : map_s) {
               if ("1".equals(map.get("sourcedefault"))) {
                  data_s_length.put(((String)map.get("sourcefieldname")).toLowerCase(), map);
               }
            }

            for(Map<String, String> map : map_s) {
               if ("1".equals(map.get("sourcedefault"))) {
                  data_s.put(((String)map.get("sourcefieldname")).toLowerCase(), map.get("targetfieldname"));
               }
            }

            for(Map<String, String> map : map_t) {
               if (map.get("isdefault") != null && "1".equals(map.get("isdefault"))) {
                  data_t.put(map.get("targetfieldname"), map);
               }

               if ("1".equals(map.get("sourcedefault"))) {
                  data_t_length.put(((String)map.get("sourcefieldname")).toLowerCase(), map);
               }

               data_t_x_length.put((map.get("sourcefieldname") == null ? "" : (String)map.get("sourcefieldname")).toLowerCase() + (map.get("targetfieldname") == null ? "" : (String)map.get("targetfieldname")).toLowerCase(), map);
            }

            StringBuilder sb_sql_t = new StringBuilder();
            StringBuilder sb_sql_c = new StringBuilder();
            List<String> list_table = JdbcTool.sql_insert_q(new DesensitizationTable());
            list_table.add("id");
            String sb_sql_table = JdbcTool.sql_insert_z(list_table, "desensitization_table");
            sb_sql_t.append(sb_sql_table);
            List<String> list_column = JdbcTool.sql_insert_q(new DesensitizationTablecolumn());
            list_column.add("id");
            String sb_sql_column = JdbcTool.sql_insert_z(list_column, "desensitization_tablecolumn");
            sb_sql_c.append(sb_sql_column);
            int i = 0;
            jedis.set(tasknamereal + "_zcount", tablelistmap.size() + (tablelistmap.size() / 10 == 0 ? 1 : tablelistmap.size() / 10) + (tablelistmap.size() / 10 == 0 ? 1 : tablelistmap.size() / 10) + "");
            List<String> ttablenamelist = new ArrayList();
            if (!targetisfile) {
               ttablenamelist = JdbcTool.getAllTableName(tconn, desensitizationtarget.getDataschema());
            }

            for(Map<String, String> tCoreMaskingTaskTable : tablelistmap) {
               StringBuffer sql_all = new StringBuffer();
               sql_all.append("select ");
               boolean iskeycolumn = false;
               ++i;
               DesensitizationTable desensitizationTable = new DesensitizationTable();
               String tableName = (String)tCoreMaskingTaskTable.get("tableName");
               String schemaName_dmp = tableName.substring(0, tableName.lastIndexOf("-"));
               String tableName_dmp = tableName.substring(tableName.lastIndexOf("-") + 1, tableName.length());
               String status = (String)tCoreMaskingTaskTable.get("status");
               desensitizationTable.setStatus((String)tCoreMaskingTaskTable.get("status"));
               desensitizationTable.setTablename(tableName);
               desensitizationTable.setTaskid(taskid);
               desensitizationTable.setId(UUID.randomUUID().toString());
               desensitizationTable.setFilename(tCoreMaskingTaskTable.get("filename") != null ? (String)tCoreMaskingTaskTable.get("filename") + (String)tCoreMaskingTaskTable.get("extension") : "");
               desensitizationTable.setFilepath(tCoreMaskingTaskTable.get("filedir") != null ? (String)tCoreMaskingTaskTable.get("filedir") : "");
               desensitizationTable.setFilestructureid(tCoreMaskingTaskTable.get("structureid") != null ? (String)tCoreMaskingTaskTable.get("structureid") : "");
               desensitizationTable.setSqlFilter(map_table_filterConditions != null ? (map_table_filterConditions.get(tableName) != null ? ((String)map_table_filterConditions.get(tableName)).replaceAll("\"", "'") : "") : "");
               SourceInfo pwc_sourceInfo = new SourceInfo();
               TargetInfo pwc_targetInfo = new TargetInfo();
               List<ColumnInfo> sourcecolumnInfoList = new ArrayList();
               List<ColumnInfo> targetcolumnInfoList = new ArrayList();
               byte[] byt_table_columinfo = jedis.get((tasknamereal + "_" + "TCoreMaskingTaskTableInfo_" + tableName).getBytes());
               List<TCoreMaskingTaskTableInfo> tCoreMaskingTaskTableInfoList = new ArrayList();
               if (byt_table_columinfo != null) {
                  Object obj = RedisTool.unserizlize(byt_table_columinfo);
                  tCoreMaskingTaskTableInfoList = (List)obj;
                  int sortnum = 0;

                  for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : tCoreMaskingTaskTableInfoList) {
                     ++sortnum;
                     String qualifierType = (String)data_s.get(this.delparentheses(tCoreMaskingTaskTableInfo.getSourceType().toLowerCase()));
                     String source_hq = tCoreMaskingTaskTableInfo.getSourceType();
                     switch (getDbtype_s) {
                        case "MSSQLSERVER":
                           List<ColumnInfoVO> queryColumnInfo = this.queryColumnInfoDmp(schemaName_dmp, tableName_dmp, tasknamereal, jedis);
                           Map<String, String> mapdatatype = new HashMap();

                           for(ColumnInfoVO columnInfoVO : queryColumnInfo) {
                              mapdatatype.put(columnInfoVO.getColumnname(), columnInfoVO.getDatatype());
                           }

                           String source = JdbcTool.sqlServerTypeTran(tCoreMaskingTaskTableInfo.getSourceType(), (String)mapdatatype.get(tCoreMaskingTaskTableInfo.getColumnName()));
                           qualifierType = (String)data_s.get(source.toLowerCase());
                           source_hq = tCoreMaskingTaskTableInfo.getSourceType();
                           tCoreMaskingTaskTableInfo.setTruesearchType(source_hq);
                           tCoreMaskingTaskTableInfo.setSourceType(source);
                           break;
                        default:
                           source_hq = tCoreMaskingTaskTableInfo.getSourceType();
                           tCoreMaskingTaskTableInfo.setTruesearchType(source_hq);
                           tCoreMaskingTaskTableInfo.setSourceType(source_hq);
                     }

                     if (issomedb) {
                        tCoreMaskingTaskTableInfo.setTargetType(tCoreMaskingTaskTableInfo.getSourceType());
                     }

                     System.out.println(">>>>sourcefieldname:" + (String)((Map)data_t.get(qualifierType)).get("sourcefieldname"));
                     if (tCoreMaskingTaskTableInfo.getTargetType() == null) {
                        tCoreMaskingTaskTableInfo.setTargetType((String)((Map)data_t.get(qualifierType)).get("sourcefieldname"));
                     }

                     Map<String, String> maptarget = (Map)data_t_x_length.get(tCoreMaskingTaskTableInfo.getTargetType().toLowerCase() + qualifierType);
                     if (maptarget == null) {
                        System.out.println("error:请取后台配置脱敏任务对应关系" + tableName + ":" + qualifierType + "_" + tCoreMaskingTaskTableInfo.getSourceType());
                     }

                     tCoreMaskingTaskTableInfo = this.gettCoreMaskingTaskTableInfoByUpdate(sortnum, issomedb, targetisfile, maptarget, tCoreMaskingTaskTableInfo);
                     String colType = tCoreMaskingTaskTableInfo.getTargetType();
                     switch (getDbtype_t) {
                        case "GREENPLUM":
                           if ("bigserial".equalsIgnoreCase(colType) || "serial".equalsIgnoreCase(colType)) {
                              tCoreMaskingTaskTableInfo.setIsnullable("NO");
                           }
                           break;
                        case "INFORMIX":
                           if ("bigserial".equalsIgnoreCase(colType) || "serial".equalsIgnoreCase(colType)) {
                              tCoreMaskingTaskTableInfo.setIsnullable("NO");
                           }
                           break;
                        case "SYBASE":
                           if ("BIT".equalsIgnoreCase(colType)) {
                              tCoreMaskingTaskTableInfo.setIsnullable("NO");
                           }
                     }

                     if ("SYSDATE".equalsIgnoreCase(tCoreMaskingTaskTableInfo.getColumnName())) {
                        iskeycolumn = true;
                        sql_all.append(tableName_dmp + "." + tCoreMaskingTaskTableInfo.getColumnName() + " " + tCoreMaskingTaskTableInfo.getColumnName() + "1");
                        sql_all.append(",");
                     } else {
                        sql_all.append(tableName_dmp + "." + tCoreMaskingTaskTableInfo.getColumnName());
                        sql_all.append(",");
                     }

                     ColumnInfo pwc_columnInfo_source = this.getPwc_columnInfo_source(tCoreMaskingTaskTableInfo, qualifierType, data_rule, data_s, data_s_length, pwc_config);
                     sourcecolumnInfoList.add(pwc_columnInfo_source);
                     ColumnInfo pwc_columnInfo_target = this.getPwc_columnInfo_target(1, tCoreMaskingTaskTableInfo, qualifierType, data_rule, data_t, data_t_length, pwc_config, data_s, issomedb, targetisfile, data_t_x_length);
                     targetcolumnInfoList.add(pwc_columnInfo_target);
                  }
               } else {
                  String sourceschema = desensitizationsource.getDataschema();
                  HashMap<String, TCoreFieldSensitiveMemory> map_rule = this.getTCoreFieldSensitiveMemory(jedis, tableName_dmp, schemaName_dmp);
                  List<ColumnInfoVO> queryColumnInfo = this.queryColumnInfoDmp(schemaName_dmp, tableName_dmp, tasknamereal, jedis);
                  int sortnum = 0;

                  for(ColumnInfoVO columnInfoVO : queryColumnInfo) {
                     ++sortnum;
                     String qualifierType = (String)data_s.get(this.delparentheses(columnInfoVO.getTypename().toLowerCase()));
                     String source_hq = columnInfoVO.getTypename();
                     switch (getDbtype_s) {
                        case "MSSQLSERVER":
                           String source = JdbcTool.sqlServerTypeTran(columnInfoVO.getTypename(), columnInfoVO.getDatatype()).toLowerCase();
                           qualifierType = (String)data_s.get(source.toLowerCase());
                           columnInfoVO.setTypename(source);
                     }

                     Map<String, String> maptarget = (Map)data_t.get(qualifierType);
                     if (maptarget == null) {
                        System.out.println("error:请取后台配置脱敏任务对应关系" + tableName + ":" + qualifierType + "_" + columnInfoVO.getTypename());
                     }

                     TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo = this.gettCoreMaskingTaskTableInfoByInsert(source_hq, sortnum, issomedb, targetisfile, maptarget, map_rule, columnInfoVO);
                     String colType = tCoreMaskingTaskTableInfo.getTargetType();
                     switch (getDbtype_t) {
                        case "GREENPLUM":
                           if ("bigserial".equalsIgnoreCase(colType) || "serial".equalsIgnoreCase(colType)) {
                              tCoreMaskingTaskTableInfo.setIsnullable("NO");
                           }
                           break;
                        case "INFORMIX":
                           if ("bigserial".equalsIgnoreCase(colType) || "serial".equalsIgnoreCase(colType)) {
                              tCoreMaskingTaskTableInfo.setIsnullable("NO");
                           }
                     }

                     if (issomedb) {
                        tCoreMaskingTaskTableInfo.setLengthruletype((String)((Map)data_s_length.get(tCoreMaskingTaskTableInfo.getSourceType().toLowerCase())).get("flag"));
                     }

                     if ("SYSDATE".equalsIgnoreCase(tCoreMaskingTaskTableInfo.getColumnName())) {
                        iskeycolumn = true;
                        sql_all.append(tableName_dmp + "." + tCoreMaskingTaskTableInfo.getColumnName() + " " + tCoreMaskingTaskTableInfo.getColumnName() + "1");
                        sql_all.append(",");
                     } else {
                        sql_all.append(tableName_dmp + "." + tCoreMaskingTaskTableInfo.getColumnName());
                        sql_all.append(",");
                     }

                     ColumnInfo pwc_columnInfo_source = this.getPwc_columnInfo_source(tCoreMaskingTaskTableInfo, qualifierType, data_rule, data_s, data_s_length, pwc_config);
                     sourcecolumnInfoList.add(pwc_columnInfo_source);
                     ColumnInfo pwc_columnInfo_target = this.getPwc_columnInfo_target(0, tCoreMaskingTaskTableInfo, qualifierType, data_rule, data_t, data_t_length, pwc_config, data_s, issomedb, targetisfile, data_t_x_length);
                     targetcolumnInfoList.add(pwc_columnInfo_target);
                     tCoreMaskingTaskTableInfoList.add(tCoreMaskingTaskTableInfo);
                  }
               }

               sql_all.deleteCharAt(sql_all.length() - 1);
               sql_all.append(" from " + schemaName_dmp + "." + tableName_dmp);
               if (!targetisfile) {
                  boolean isNamesake = false;

                  for(String table : ttablenamelist) {
                     if (tableName_dmp.equalsIgnoreCase(table)) {
                        isNamesake = true;
                        break;
                     }
                  }

                  if (("isrebuild".equals(desensitizationtarget.getIsrebuild()) || getDbtype_t.equals("HIVE")) && isNamesake) {
                     JdbcTool.dropTable(tconn, desensitizationtarget.getDataschema(), tableName_dmp);
                     isNamesake = false;
                  }

                  if (!isNamesake) {
                     boolean isallownull = true;
                     if (getDbtype_t.equals("HIVE") || getDbtype_t.equals("DB2")) {
                        isallownull = false;
                     }

                     boolean ischar = false;
                     if (getDbtype_t.equals("ORACLE") && getDbtype_s.equals("ORACLE") && datasystemdesensitizationsource.getPagecode().equals("GBK") && datasystemdesensitizationtarget.getPagecode().equals("UTF-8")) {
                        ischar = true;
                     }

                     TCoreConfig tcoreConfig1 = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", desensitizationtarget.getDatasourceid())});
                     String sql = JdbcTool.getGenerateDDL_new(desensitizationtarget.getDataschema(), tableName_dmp, tCoreMaskingTaskTableInfoList, isallownull, getDbtype_t, getDbtype_s, ischar, tcoreConfig1);
                     if (!getDbtype_t.equals("HIVE")) {
                        boolean result = JdbcTool.createTable(tconn, sql);
                        map_xml.put("createtable", result);
                     }
                  }
               }

               sb_sql_t.append(JdbcTool.sql_insert_h(desensitizationTable, list_table));

               for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : tCoreMaskingTaskTableInfoList) {
                  DesensitizationTablecolumn desensitizationTablecolumn = this.getDesensitizationTablecolumn(tCoreMaskingTaskTableInfo, desensitizationTable.getId(), taskid);
                  sb_sql_c.append(JdbcTool.sql_insert_h(desensitizationTablecolumn, list_column));
               }

               String taskname = tasknamereal + "_" + schemaName_dmp + "_" + tableName_dmp;
               pwc_sourceInfo.setColumnInfoList(sourcecolumnInfoList);
               pwc_sourceInfo.setConnectName(sourcetype.equals("FILE") ? "" : datasystemdesensitizationsource.getDblinkname());
               pwc_sourceInfo.setDataBaseType(DataBaseType.ORACLE);
               FlatFile sourceflatFile = new FlatFile();
               if (pwc_config.getReadMode() == 1) {
                  String key = desensitizationtask.getTasktype().split("to")[0];
                  new TCoreFileStructure();
                  new TCoreFileStructurespliter();
                  switch (key) {
                     case "FILE":
                        sourceflatFile = this.getflatFile(desensitizationTable, key, jedis, tasknamereal);
                        break;
                     case "FTP":
                        sourceflatFile = this.getflatFile(desensitizationTable, key, jedis, tasknamereal);
                        break;
                     case "SFTP":
                        sourceflatFile = this.getflatFile(desensitizationTable, key, jedis, tasknamereal);
                        break;
                     default:
                        String pagecode = datasystemdesensitizationsource.getPagecode();
                        String dataBaseType = pwc_sourceInfo.getDataBaseType();
                        sourceflatFile = this.getflatFile("source", pagecode, dataBaseType, tableName, tasknamereal);
                  }
               }

               pwc_sourceInfo.setFlatFile(sourceflatFile);
               pwc_sourceInfo.setName(tableName_dmp);
               pwc_sourceInfo.setSchema(schemaName_dmp);
               pwc_sourceInfo.setSqlFilter(desensitizationTable.getSqlFilter());
               if (iskeycolumn) {
                  pwc_sourceInfo.setSqlQuery(sql_all.toString());
               } else {
                  pwc_sourceInfo.setSqlQuery("");
               }

               pwc_targetInfo.setColumnInfoList(targetcolumnInfoList);
               if (!targetisfile) {
                  pwc_targetInfo.setConnectName(datasystemdesensitizationtarget.getDblinkname());
                  pwc_targetInfo.setDataBaseType(datasystemdesensitizationtarget.getDbtype().toUpperCase());
               } else {
                  pwc_targetInfo.setConnectName("");
                  pwc_targetInfo.setDataBaseType(DataBaseType.FLATFILE);
               }

               FlatFile targetflatFile = new FlatFile();
               pwc_targetInfo.setFlatFile(targetflatFile);
               pwc_targetInfo.setName(tableName_dmp);
               pwc_targetInfo.setSchema(desensitizationtarget.getDataschema());
               pwc_targetInfo.setIsTruncate(desensitizationtarget.getIsclear() != null && desensitizationtarget.getIsclear().equals("isclear") ? 1 : 0);
               pwc_targetInfo.setIsTruncate(desensitizationtarget.getIsrebuild() != null && desensitizationtarget.getIsrebuild().equals("isrebuild") ? 1 : pwc_targetInfo.getIsTruncate());
               HashMap<String, Integer> writeType = new HashMap();
               writeType.put("insertorupdate", 2);
               writeType.put("insert", 0);
               writeType.put("delete", 3);
               writeType.put("update", 1);
               if (desensitizationtarget.getInserttype() != null) {
                  pwc_targetInfo.setWriteType((Integer)writeType.get(desensitizationtarget.getInserttype()));
               }

               Info info = this.pwc_Info(pwc_sourceInfo, pwc_targetInfo, taskname);
               infoList.add(info);
               jedis.set(tasknamereal + "_ncount", i + "");
            }

            if (tconn != null) {
               tconn.close();
            }

            this.desensitizationTableDao.saveDesensitizationtable(sb_sql_t.deleteCharAt(sb_sql_t.length() - 1));
            this.desensitizationTablecolumnDao.saveDesensitizationTablecolumn(sb_sql_c.deleteCharAt(sb_sql_c.length() - 1));
            int pwc_state = PowerXml.generatePowerXml(infoList, pwc_config);
            map_xml.put("pwc_state", pwc_state == 1);
            i += tablelistmap.size() / 10 == 0 ? 1 : tablelistmap.size() / 10;
            jedis.set(tasknamereal + "_ncount", i + "");
            String con_file = DmpDesensitizationServiceImpl.class.getResource("/").getPath().replaceAll("%20", " ") + "infofile" + File.separator + "con_import.xml";
            String foldername = desensitizationtask.getFoldername();
            String repository = infoProperty.getRepository();
            this.updateImportFile(con_file, foldername, repository);
            String importlog = InfoExecUtil.executImport(infoProperty.getPmrepexepath(), xml_file_path, con_file, infoProperty.getXmldir() + File.separator + "log.txt");
            map_xml.put("importlog", importlog.contains("已成功完成") || importlog.contains("successfully"));
            i += tablelistmap.size() / 10 == 0 ? 1 : tablelistmap.size() / 10;
            jedis.set(tasknamereal + "_ncount", i + "");
            map_xml.put("tasktype", desensitizationtask.getTasktype());
            return map_xml;
      }
   }

   public ColumnInfo getPwc_columnInfo_source(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo, String qualifierType, Map<String, String> data_rule, Map<String, String> data_s, Map<String, Map<String, String>> data_s_length, Config pwc_config) {
      String sourcetype = this.delparentheses(tCoreMaskingTaskTableInfo.getSourceType().toUpperCase());
      String source = this.delparentheses(tCoreMaskingTaskTableInfo.getSourceType().toLowerCase());
      ColumnInfo pwc_columnInfo_source = new ColumnInfo();
      pwc_columnInfo_source.setColumnName(tCoreMaskingTaskTableInfo.getColumnName());
      if ("SYSDATE".equalsIgnoreCase(pwc_columnInfo_source.getColumnName())) {
         pwc_columnInfo_source.setColumnName(tCoreMaskingTaskTableInfo.getColumnName() + "1");
      }

      pwc_columnInfo_source.setDataType(sourcetype);
      pwc_columnInfo_source.setKeyType("1".equals(tCoreMaskingTaskTableInfo.getIsPrimaryKey()) ? 1 : (tCoreMaskingTaskTableInfo.getIsForeignKey() != null ? ("1".equals(tCoreMaskingTaskTableInfo.getIsForeignKey()) ? 2 : 0) : 0));
      pwc_columnInfo_source.setMaskingRule((String)data_rule.get(tCoreMaskingTaskTableInfo.getRegexRuleId()));
      pwc_columnInfo_source.setNullable(pwc_columnInfo_source.getKeyType() != 0 ? 1 : 0);
      pwc_columnInfo_source.setQualifierType(qualifierType.toLowerCase());
      String sourcelength = (String)((Map)data_s_length.get(source)).get("sourcelength");
      String sourcescancale = (String)((Map)data_s_length.get(source)).get("sourcescancale");
      String pwcsqlength = (String)((Map)data_s_length.get(source)).get("pwcsqlength");
      String pwcsqscale = (String)((Map)data_s_length.get(source)).get("pwcsqscale");
      String pwcdateformat = "YYYY-MM-DD HH24:MI:SS";
      pwc_columnInfo_source.setScale(sourcescancale != null && !sourcescancale.equals("") ? sourcescancale : tCoreMaskingTaskTableInfo.getColumnPrecision());
      pwc_columnInfo_source.setPrecision(sourcelength != null && !sourcelength.equals("") ? sourcelength : tCoreMaskingTaskTableInfo.getColumnLength());
      if (pwcsqlength != null && !pwcsqlength.equals("")) {
         pwc_columnInfo_source.setSqprecision(pwcsqlength);
         pwc_columnInfo_source.setSqscale(pwcsqscale);
      }

      if (pwcdateformat != null && !pwcdateformat.equals("") && pwc_config.getReadMode() == 1) {
         pwc_columnInfo_source.setDateTimeFormat(pwcdateformat);
      }

      return pwc_columnInfo_source;
   }

   public ColumnInfo getPwc_columnInfo_target(int type, TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo, String qualifierType, Map<String, String> data_rule, Map<String, Map<String, String>> data_t, Map<String, Map<String, String>> data_t_length, Config pwc_config, Map<String, String> data_s, Boolean issomedb, Boolean targetisfile, Map<String, Map<String, String>> data_t_x_length) {
      ColumnInfo pwc_columnInfo_target = new ColumnInfo();
      String source = this.delparentheses(tCoreMaskingTaskTableInfo.getSourceType().toLowerCase());
      String pwc_type = (String)data_s.get(source);
      String targetype = "";
      String targetlength = "";
      String targetscancale = "";
      String targetpwcsqlength = "";
      String targetpwcsqscale = "";
      String targetpwcdateformat = "";
      if (type == 0) {
         targetype = ((String)((Map)data_t.get(pwc_type)).get("sourcefieldname")).toLowerCase();
         targetlength = (String)((Map)data_t_length.get(targetype)).get("sourcelength");
         targetscancale = (String)((Map)data_t_length.get(targetype)).get("sourcescancale");
         targetpwcsqlength = (String)((Map)data_t_length.get(targetype)).get("pwcsqlength");
         targetpwcsqscale = (String)((Map)data_t_length.get(targetype)).get("pwcsqscale");
         targetpwcdateformat = (String)((Map)data_t_length.get(targetype)).get("pwcdateformat");
         if (issomedb) {
            targetpwcdateformat = (String)((Map)data_t_length.get(source)).get("pwcdateformat");
         }
      } else {
         targetype = tCoreMaskingTaskTableInfo.getTargetType().toLowerCase();
         targetlength = (String)((Map)data_t_x_length.get(targetype + pwc_type)).get("sourcelength");
         targetscancale = (String)((Map)data_t_x_length.get(targetype + pwc_type)).get("sourcescancale");
         targetpwcsqlength = (String)((Map)data_t_x_length.get(targetype + pwc_type)).get("pwcsqlength");
         targetpwcsqscale = (String)((Map)data_t_x_length.get(targetype + pwc_type)).get("pwcsqscale");
         targetpwcdateformat = (String)((Map)data_t_x_length.get(targetype + pwc_type)).get("pwcdateformat");
      }

      pwc_columnInfo_target.setColumnName(tCoreMaskingTaskTableInfo.getColumnName());
      if ("SYSDATE".equalsIgnoreCase(pwc_columnInfo_target.getColumnName())) {
         pwc_columnInfo_target.setColumnName(tCoreMaskingTaskTableInfo.getColumnName() + "1");
      }

      pwc_columnInfo_target.setDataType(this.delparentheses(targetype.toUpperCase()));
      pwc_columnInfo_target.setKeyType("1".equals(tCoreMaskingTaskTableInfo.getIsPrimaryKey()) ? 1 : (tCoreMaskingTaskTableInfo.getIsForeignKey() != null ? ("1".equals(tCoreMaskingTaskTableInfo.getIsForeignKey()) ? 2 : 0) : 0));
      pwc_columnInfo_target.setMaskingRule((String)data_rule.get(tCoreMaskingTaskTableInfo.getRegexRuleId()));
      pwc_columnInfo_target.setNullable(pwc_columnInfo_target.getKeyType() != 0 ? 1 : 0);
      pwc_columnInfo_target.setQualifierType(qualifierType.toLowerCase());
      pwc_columnInfo_target.setScale(targetscancale != null && !targetscancale.equals("") ? targetscancale : tCoreMaskingTaskTableInfo.getColumnPrecision());
      pwc_columnInfo_target.setPrecision(targetlength != null && !targetlength.equals("") ? targetlength : tCoreMaskingTaskTableInfo.getColumnLength());
      if (pwc_columnInfo_target.getPrecision() == null || "".equals(pwc_columnInfo_target.getPrecision())) {
         pwc_columnInfo_target.setPrecision(tCoreMaskingTaskTableInfo.getColumnLength());
      }

      if (targetpwcsqlength != null && !targetpwcsqlength.equals("")) {
         pwc_columnInfo_target.setSqprecision(targetpwcsqlength);
         pwc_columnInfo_target.setSqscale(targetpwcsqscale);
      }

      if (targetpwcdateformat != null && !targetpwcdateformat.equals("") && pwc_config.getWriteMode() == 1) {
         pwc_columnInfo_target.setDateTimeFormat(targetpwcdateformat);
      }

      return pwc_columnInfo_target;
   }

   public TCoreMaskingTaskTableInfo gettCoreMaskingTaskTableInfoByUpdate(int sortnum, boolean issomedb, boolean targetisfile, Map<String, String> maptarget, TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo) {
      tCoreMaskingTaskTableInfo.setSortnum(sortnum);
      tCoreMaskingTaskTableInfo.setTargetType(issomedb ? tCoreMaskingTaskTableInfo.getSourceType() : (String)maptarget.get("sourcefieldname"));
      tCoreMaskingTaskTableInfo.setTargetLength(!issomedb && !targetisfile ? (String)maptarget.get("targetlength") : tCoreMaskingTaskTableInfo.getColumnLength());
      tCoreMaskingTaskTableInfo.setTargetPrecision(!issomedb && !targetisfile ? (String)maptarget.get("targetdecimal") : tCoreMaskingTaskTableInfo.getColumnPrecision());
      tCoreMaskingTaskTableInfo.setLengthruletype((String)maptarget.get("flag"));
      tCoreMaskingTaskTableInfo.setIsnullable("");
      return tCoreMaskingTaskTableInfo;
   }

   public TCoreMaskingTaskTableInfo gettCoreMaskingTaskTableInfoByInsert(String source_hq, int sortnum, boolean issomedb, boolean isfile, Map<String, String> maptarget, HashMap<String, TCoreFieldSensitiveMemory> map, ColumnInfoVO columnInfoVO) {
      TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo = new TCoreMaskingTaskTableInfo();
      tCoreMaskingTaskTableInfo.setTruesearchType(source_hq);
      tCoreMaskingTaskTableInfo.setSortnum(sortnum);
      tCoreMaskingTaskTableInfo.setIsPrimaryKey(columnInfoVO.getPrimarykey());
      tCoreMaskingTaskTableInfo.setIsForeignKey(columnInfoVO.getForeignkey());
      tCoreMaskingTaskTableInfo.setColumnName(columnInfoVO.getColumnname());
      tCoreMaskingTaskTableInfo.setSearchType(map.get(columnInfoVO.getColumnname()) == null ? "确认非敏感字段" : ((TCoreFieldSensitiveMemory)map.get(columnInfoVO.getColumnname())).getRegextype());
      tCoreMaskingTaskTableInfo.setSourceType(columnInfoVO.getTypename());
      tCoreMaskingTaskTableInfo.setTargetType(issomedb ? columnInfoVO.getTypename() : (String)maptarget.get("sourcefieldname"));
      tCoreMaskingTaskTableInfo.setTargetLength(!issomedb && !isfile ? (String)maptarget.get("targetlength") : columnInfoVO.getColumnsize());
      tCoreMaskingTaskTableInfo.setTargetPrecision(!issomedb && !isfile ? (String)maptarget.get("targetdecimal") : columnInfoVO.getDecimaldigits());
      tCoreMaskingTaskTableInfo.setLengthruletype((String)maptarget.get("flag"));
      tCoreMaskingTaskTableInfo.setColumnLength(columnInfoVO.getColumnsize());
      tCoreMaskingTaskTableInfo.setColumnPrecision(columnInfoVO.getDecimaldigits());
      tCoreMaskingTaskTableInfo.setRegexRuleId(map.get(columnInfoVO.getColumnname()) == null ? "" : ((TCoreFieldSensitiveMemory)map.get(columnInfoVO.getColumnname())).getRuleid());
      tCoreMaskingTaskTableInfo.setRegexRuleName(map.get(columnInfoVO.getColumnname()) == null ? "" : ((TCoreFieldSensitiveMemory)map.get(columnInfoVO.getColumnname())).getRuie());
      tCoreMaskingTaskTableInfo.setIsnullable("");
      return tCoreMaskingTaskTableInfo;
   }

   public void updateImportFile(String filepath, String foldername, String repository) throws Exception {
      File file = new File(filepath);
      ModifyImportFile mi = new ModifyImportFile();
      ModifyImportFile.updateConfigFileXML("TARGETFOLDERNAME", file, foldername);
      ModifyImportFile.updateConfigFileXML("SOURCEFOLDERNAME", file, foldername);
      ModifyImportFile.updateConfigFileXML("TARGETREPOSITORYNAME", file, repository);
      ModifyImportFile.updateConfigFileXML("SOURCEREPOSITORYNAME", file, repository);
   }

   @Async
   public Desensitizationtask savetask_info(String tasknamereal, Map<String, Object> map) {
      RedisClient redisClient = new RedisClient();
      Jedis jedis = redisClient.getJedis();
      String state = (String)map.get("state");
      System.out.println("state:" + state);
      new Desensitizationtask();
      Desensitizationtask desensitizationtask = (Desensitizationtask)this.desensitizationtaskDao.queryUnique(new Criterion[]{Restrictions.eq("tasknamereal", tasknamereal)});
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      desensitizationtarget = this.saveDesensitizationtarget(tasknamereal, desensitizationtask.getId(), jedis, desensitizationtarget, state);
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      desensitizationsource = this.saveDesensitizationsource(tasknamereal, desensitizationtask.getId(), jedis, desensitizationsource, state);
      DesensitizationFile desensitizationfile = new DesensitizationFile();
      desensitizationfile = this.saveDesensitizationFile(tasknamereal, desensitizationtask.getId(), jedis, desensitizationfile, state);
      List<DesensitizationTable> desensitizationTable = new ArrayList();
      new ArrayList();
      Map<String, String> map_table_filterConditions = (Map)map.get("map_table_filterConditions");
      List<Map<String, String>> tCoreMaskingTaskTablemapList = (List)map.get("tableList");
      tCoreMaskingTaskTablemapList = (List)tCoreMaskingTaskTablemapList.stream().filter((s) -> "1".equals(s.get("status")) || "3".equals(s.get("status"))).collect(Collectors.toList());
      String save_state = "1";
      Map<String, Object> save_map = new HashMap();

      try {
         save_map = this.saveDesensitizationTable(desensitizationtask, desensitizationtask.getId(), jedis, desensitizationTable, desensitizationsource, desensitizationtarget, tCoreMaskingTaskTablemapList, state, desensitizationfile, map_table_filterConditions);
         save_state = "2";
      } catch (Exception e) {
         save_state = "1";
         e.printStackTrace();
         StringWriter sw = new StringWriter();
         e.printStackTrace(new PrintWriter(sw, true));
         String strs = sw.toString();
         System.out.println("--------------------------美丽的分割线----------------------");
         TConsoleLog record = new TConsoleLog();
         record.setNote(strs);
         record.setModule("新建脱敏任务+导入");
         record.setUser(desensitizationtask.getUsername());
         record.setLogno(tasknamereal);
         record.setOperationtime(new Date());
         this.operationService.add(record);
         System.out.println(strs);
         System.out.println("-------------------------美丽的收割线----------------------");
      }

      new ArrayList();
      String tasktype = (String)save_map.get("tasktype");
      Boolean pwc_state = (Boolean)save_map.get("pwc_state");
      Boolean importlog = (Boolean)save_map.get("importlog");
      Boolean createtable = (Boolean)save_map.get("createtable");
      if (pwc_state && importlog && createtable) {
         save_state = "2";
      } else {
         save_state = "1";
      }

      desensitizationtask.setTasktype(tasktype);
      desensitizationtask.setSave_state(save_state);
      desensitizationtask.setTaskstatus("0");
      desensitizationtask.setCount_exe("0%");
      this.desensitizationtaskDao.saveOrUpdate(desensitizationtask);
      this.updateTask(tasknamereal, save_state);
      jedis.close();
      return desensitizationtask;
   }

   public Connection getConnectionByDataSystemId(TCoreDatasystem datasystem) {
      String dbcode = datasystem.getDbtype();
      String ip = datasystem.getDbip();
      String port = datasystem.getDbport();
      String servername = datasystem.getDbservername();
      String server = datasystem.getServername();
      String url = "";
      switch (datasystem.getDbtype()) {
         case "INFORMIX":
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername, server);
            break;
         case "TERADATA":
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername, server, datasystem.getPagecode());
            break;
         default:
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername);
      }

      String username = datasystem.getUsername();
      String password = "1".equals(datasystem.getFlag()) ? AesTool.decrypt(datasystem.getPassword(), "ghca") : datasystem.getPassword();
      String driver = EdbType.getEdbTypeByDbcode(dbcode).getDbdriver();
      Connection conn = JdbcTool.getConnection(driver, url, username, password);
      return conn;
   }

   public List<ColumnInfoVO> queryColumnInfo(String datasystemid, String schema, String tableName) {
      TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(datasystemid);
      if (datasystem == null) {
         return null;
      } else {
         Connection conn = this.getConnectionByDataSystemId(datasystem);
         List<ColumnInfoVO> list = JdbcTool.getColumnInfoVO(conn, schema, tableName);
         List<ColumnInfoVO> list1 = new ArrayList();
         if (datasystem.getDbtype().equals("SYBASE_IQ")) {
            for(ColumnInfoVO civ : list) {
               if (civ.getTypename().equals("varchar") || civ.getTypename().equals("char")) {
                  civ.setDecimaldigits("");
               }

               list1.add(civ);
            }
         }

         try {
            if (conn != null) {
               conn.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return datasystem.getDbtype().equals("SYBASE_IQ") ? list1 : list;
      }
   }

   public List<ColumnInfoVO> queryColumnInfoDmp(String schema, String tableName, String tasknamereal, Jedis jedis) {
      List<ColumnInfoVO> list = new ArrayList();
      byte[] bs = jedis.get(("dmpTransTask_Info_" + tasknamereal).getBytes());
      new ArrayList();
      if (bs != null) {
         List<TCoreMaskingTaskTableSchema> listNew = (List)RedisTool.unserizlize(bs);
         for(TCoreMaskingTaskTableSchema tCoreMaskingTaskTableSchema : listNew) {
            if (schema.equals(tCoreMaskingTaskTableSchema.getSchema())) {
               for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : tCoreMaskingTaskTableSchema.gettCoreMaskingTaskTableInfoList()) {
                  if (tableName.equals(tCoreMaskingTaskTableInfo.getTableName())) {
                     ColumnInfoVO columnInfoVO = new ColumnInfoVO();
                     columnInfoVO.setColumnname(tCoreMaskingTaskTableInfo.getColumnName());
                     columnInfoVO.setRemarks(tCoreMaskingTaskTableInfo.getRemark());
                     columnInfoVO.setTypename(tCoreMaskingTaskTableInfo.getSourceType());
                     columnInfoVO.setColumnsize(tCoreMaskingTaskTableInfo.getColumnLength());
                     columnInfoVO.setDecimaldigits(tCoreMaskingTaskTableInfo.getColumnPrecision());
                     list.add(columnInfoVO);
                  }
               }
            }
         }
      }

      return list;
   }

   public String gettaskBytasknamereal(String tasknamereal) {
      Desensitizationtask desensitizationtask = (Desensitizationtask)this.desensitizationtaskDao.queryUnique(new Criterion[]{Restrictions.eq("tasknamereal", tasknamereal)});
      if (desensitizationtask != null) {
         return "2";
      } else {
         desensitizationtask = new Desensitizationtask();
         new LoginUser();
         LoginUser loginUser = (LoginUser)this.request.getSession().getAttribute("loginUser");
         RedisClient redisClient = new RedisClient();
         Jedis jedis = redisClient.getJedis();
         byte[] byt_task = jedis.get((tasknamereal + "_" + desensitizationtask.getClass().getSimpleName()).getBytes());
         if (byt_task != null) {
            Object obj = RedisTool.unserizlize(byt_task);
            desensitizationtask = (Desensitizationtask)obj;
         }

         desensitizationtask.setCreatetime(new Date());
         desensitizationtask.setUpdatatime(new Date());
         desensitizationtask.setSave_state("0");
         TBaseUser user = loginUser.getTsysUser();
         desensitizationtask.setUserid(user.getId());
         desensitizationtask.setUsername(user.getUsername());
         desensitizationtask.setFlag("2");
         this.desensitizationtaskDao.save(desensitizationtask);
         jedis.close();
         return "3";
      }
   }

   public Desensitizationsource querySourceInfo(String taskid) {
      return (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
   }

   public Desensitizationtarget queryTargetInfo(String taskid) {
      return (Desensitizationtarget)this.desensitizationtargetDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
   }

   public List<DesensitizationTable> queryTableList(String taskid) {
      return this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid)});
   }

   public DesensitizationTable queryTableByTableName(String taskid, String tableName) {
      return (DesensitizationTable)this.desensitizationTableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("tablename", tableName)});
   }

   public Desensitizationtask queryTaskById(String taskid) {
      return (Desensitizationtask)this.desensitizationtaskDao.queryUnique(new Criterion[]{Restrictions.eq("id", taskid)});
   }

   public void removeTask(String taskid) {
      this.desensitizationtaskDao.removeById(taskid);
      this.desensitizationtargetDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
      this.desensitizationsourceDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
      this.desensitizationTableDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
      this.desensitizationTableDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
      this.desensitizationTablecolumnDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
   }

   public Info pwc_Info(SourceInfo sourceInfo, TargetInfo targetInfo, String taskname) {
      Info info = new Info();
      info.setSourceInfo(sourceInfo);
      info.setTargetInfo(targetInfo);
      info.setTaskname(taskname);
      return info;
   }

   public Config pwc_config(Map<String, String> mapparam) {
      Config config = new Config();
      int readMode = 0;
      int writeMode = 0;
      if (((String)mapparam.get("execution_type_s")).equals("normal")) {
         readMode = 0;
         if (((String)mapparam.get("execution_type_t")).equals("normal")) {
            writeMode = 0;
         } else {
            writeMode = 1;
         }
      } else {
         readMode = 1;
         if (((String)mapparam.get("execution_type_t")).equals("normal")) {
            writeMode = 0;
         } else {
            writeMode = 1;
         }
      }

      readMode = ((String)mapparam.get("source_type")).equals("FILE") ? 1 : readMode;
      writeMode = ((String)mapparam.get("target_type")).equals("FILE") ? 1 : writeMode;
      config.setDomainName((String)mapparam.get("domainName"));
      config.setFolderName((String)mapparam.get("folderName"));
      config.setMappletDir((String)mapparam.get("mappletDir"));
      config.setReadMode(readMode);
      config.setRepositoryName((String)mapparam.get("repository"));
      config.setServerName((String)mapparam.get("serverName"));
      config.setWriteMode(writeMode);
      config.setHdfsDir((String)mapparam.get("hdfsDir"));
      config.setIsrecover(Integer.parseInt((String)mapparam.get("isrecover")));
      config.setXmlLocation((String)mapparam.get("xmlLocation"));
      return config;
   }

   public DesensitizationTablecolumn getDesensitizationTablecolumn(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo, String tableid, String taskid) {
      DesensitizationTablecolumn desensitizationTablecolumn = new DesensitizationTablecolumn();
      desensitizationTablecolumn.setColumnindex(0);
      desensitizationTablecolumn.setColumnlength(tCoreMaskingTaskTableInfo.getColumnLength());
      desensitizationTablecolumn.setColumnname(tCoreMaskingTaskTableInfo.getColumnName());
      desensitizationTablecolumn.setColumnscale(tCoreMaskingTaskTableInfo.getColumnPrecision());
      desensitizationTablecolumn.setColumntype(tCoreMaskingTaskTableInfo.getTruesearchType());
      desensitizationTablecolumn.setId(UUID.randomUUID().toString());
      desensitizationTablecolumn.setJudgenull(tCoreMaskingTaskTableInfo.getIsnullable());
      desensitizationTablecolumn.setMappingkey("");
      desensitizationTablecolumn.setColumntartype(tCoreMaskingTaskTableInfo.getTargetType());
      desensitizationTablecolumn.setPrimarykey(tCoreMaskingTaskTableInfo.getIsPrimaryKey());
      desensitizationTablecolumn.setRegextype(tCoreMaskingTaskTableInfo.getRegexType());
      desensitizationTablecolumn.setRuleid(tCoreMaskingTaskTableInfo.getRegexRuleId());
      desensitizationTablecolumn.setRulename(tCoreMaskingTaskTableInfo.getRegexRuleName());
      desensitizationTablecolumn.setTableid(tableid);
      desensitizationTablecolumn.setTaskid(taskid);
      desensitizationTablecolumn.setSortnum(tCoreMaskingTaskTableInfo.getSortnum());
      return desensitizationTablecolumn;
   }

   public Desensitizationtarget queryTargetById(String taskid) {
      return (Desensitizationtarget)this.desensitizationtargetDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
   }

   public InfoProperty getInfoProperty() {
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(props.getProperty("engineid"));
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      return engine;
   }

   public List<Desensitizationtask> queryTaskList(String taskid) {
      List<Desensitizationtask> list = this.desensitizationtaskDao.queryAll(new Criterion[]{Restrictions.eq("id", taskid)});
      return list;
   }

   public int saveDesensitizationMonitor(StringBuilder sql) {
      return this.desensitizationMonitorDao.saveDesensitizationMonitor(sql);
   }

   @Async
   public void executeDB_pwc_FILE_batchwrite_DB(final ExecuteParam executeParam) throws Exception {
      System.out.println(">>>>>>>>>>>>>>>>>DB_pwc_FILE_batchwrite_DB<<<<<<<<<<<<<<<<<<");
      final Runtime rn = Runtime.getRuntime();
      List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
      final Connection targetConn = this.dataSystemService.getConnectionByDataSystemId(executeParam.getDataTargetId());
      final CountDownLatch countDownLatch = new CountDownLatch(tableList.size());
      final TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(executeParam.getDataTargetId());
      final Map<String, List<DesensitizationTablecolumn>> map = new HashMap();

      for(DesensitizationTable desensitizationTable : tableList) {
         List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
         List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
         map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
      }

      final Desensitizationtask desensitizationTask = (Desensitizationtask)this.desensitizationtaskDao.get(executeParam.getTaskid());
      desensitizationTask.setTaskstatus("1");
      this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
      this.desensitizationtaskDao.getSession().getTransaction().commit();

      for(final DesensitizationTable desensitizationTable : tableList) {
         this.taskExecutor.execute(new Runnable() {
            public void run() {
               String sessionId = "";
               String status = "4";
               String workflowName = "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename();

               try {
                  Properties props = new Properties();

                  try {
                     props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                  } catch (IOException e) {
                     e.printStackTrace();
                  }

                  if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
                     System.out.println("---进入启动预计运行时间方法！");
                     String dataCount = "";
                     dataCount = DmpDesensitizationServiceImpl.this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
                     System.out.println("数据源表" + desensitizationTable.getTablename() + "总行数：" + dataCount);
                     RedisClient redisClient = new RedisClient();
                     Jedis jedis = redisClient.getJedis();
                     jedis.set("dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename(), dataCount);
                     System.out.println("预计运行时间，key=dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename() + "，dataCount=" + dataCount);
                     jedis.close();
                  }

                  DmpDesensitizationServiceImpl.this.updateMonitorRunStatus(desensitizationTable.getTablename(), executeParam.getTableMap());
                  System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
                  sessionId = LoginWebService.returnStatus(executeParam.getInfoProperty());
                  System.out.println("获取sessionId结束！sessionId=" + sessionId + ",tableName=" + desensitizationTable.getTablename());
                  System.out.println("删除主外键开始！tableName=" + desensitizationTable.getTablename());
                  JdbcTool.delPrimaryForeignKeyAndIndex(targetConn, executeParam.getTargetSchemaName(), desensitizationTable.getTablename());
                  System.out.println("创建执行脚本开始！tableName=" + desensitizationTable.getTablename());
                  DmpDesensitizationServiceImpl.this.createScriptFiletotarget(executeParam, desensitizationTable, executeParam.getTargetDataSystem().getDbtype(), tCoreDatasystemTarget, (List)map.get(desensitizationTable.getTablename()), rn);
                  System.out.println("调用启动工作流方法开始！tableName=" + desensitizationTable.getTablename());
                  int runId = DmpDesensitizationServiceImpl.this.startWorkFlowEx(workflowName, executeParam.getInfoProperty(), executeParam.getFolderName(), sessionId);
                  String dbType = executeParam.getTargetDataSystem().getDbtype();
                  System.out.println("启动脚本开始！dbType=" + dbType + ",tableName=" + desensitizationTable.getTablename());
                  if ("SYBASE_IQ".equals(dbType)) {
                     CommandTool.commandRtn("/data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh /data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".pipe");
                  } else if ("MSSQLSERVER".equals(dbType)) {
                     CommandTool.command("chmod -R 777 /data/infa_sqlserver/");
                     String completeStatus = DmpDesensitizationServiceImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
                     if ("1".equals(completeStatus)) {
                        CommandTool.commandRtn("/data/infa_sqlserver/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                     }
                  } else if ("SYBASE".equals(dbType)) {
                     CommandTool.command("chmod -R 777 /data/infa_sybase/");
                     CommandTool.commandRtn("/data/infa_sybase/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                  } else if ("MYSQL".equals(dbType)) {
                     CommandTool.commandRtn("/data/infa_mysqlload/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                  } else if ("TERADATA".equals(dbType)) {
                     CommandTool.commandRtn("/data/infa_teradata/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                  } else if ("DB2".equals(dbType)) {
                     CommandTool.commandRtn("/data/infa_db2/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                  }

                  String completeStatus = "0";
                  System.out.println("》》》》》》》》》》》》》》》runId=" + runId);
                  if (runId >= 0) {
                     completeStatus = DmpDesensitizationServiceImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
                  }

                  if ("1".equals(completeStatus)) {
                     System.out.println("表" + desensitizationTable.getTablename() + ",执行完成,通过阻塞方法！");
                     SessionBean sessionBean = DmpDesensitizationServiceImpl.this.getLogForTaskMapping(executeParam.getFolderName(), executeParam.getInfoProperty(), executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
                     System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
                     if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                        status = "1";
                     } else if ("FAILED".equals(sessionBean.getStatus())) {
                        status = "2";
                     } else if ("STOPPED".equals(sessionBean.getStatus())) {
                        status = "3";
                     } else {
                        status = "4";
                     }

                     System.out.println("执行更新监控表开始！tableName=" + desensitizationTable.getTablename());
                     DmpDesensitizationServiceImpl.this.updateMonitor(desensitizationTable.getTablename(), executeParam.getTableMap(), status, runId);
                  }

                  LogoutWebService.returnStatus(sessionId, executeParam.getInfoProperty());
               } catch (Exception e) {
                  e.printStackTrace();
               } finally {
                  countDownLatch.countDown();
               }

            }
         });
      }

      try {
         System.out.println(">>>>>>>>>>>>>>>当前活动线程数：" + this.taskExecutor.getActiveCount());
         System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + countDownLatch.getCount());
         countDownLatch.await();
         JdbcTool.closeConnection(targetConn);
         this.desensitizationtaskDao.getSession().getTransaction().begin();
         desensitizationTask.setTaskstatus("0");
         this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
         this.desensitizationtaskDao.getSession().getTransaction().commit();
         System.out.println(">>>>>>>>>>>>>>>任务已全部执行完成！同步表信息开始！");
         this.synTableParam(tableList, executeParam);
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @Async
   public void executeFILE_pwc_FILE_batchwrite_DB(final ExecuteParam executeParam) throws Exception {
      System.out.println(">>>>>>>>>>>>>>>>>FILE_pwc_FILE_batchwrite_DB<<<<<<<<<<<<<<<<<<");
      List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
      final TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(executeParam.getDataTargetId());
      final Runtime rn = Runtime.getRuntime();
      final Map<String, List<DesensitizationTablecolumn>> map = new HashMap();
      final CountDownLatch countDownLatch = new CountDownLatch(tableList.size());

      for(DesensitizationTable desensitizationTable : tableList) {
         List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
         List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
         map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
      }

      final Desensitizationtask desensitizationTask = (Desensitizationtask)this.desensitizationtaskDao.get(executeParam.getTaskid());
      desensitizationTask.setTaskstatus("1");
      this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
      this.desensitizationtaskDao.getSession().getTransaction().commit();

      for(final DesensitizationTable desensitizationTable : tableList) {
         this.taskExecutor.execute(new Runnable() {
            public void run() {
               String sessionId = "";
               String status = "4";
               String workflowName = "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename();

               try {
                  Properties props = new Properties();

                  try {
                     props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                  } catch (IOException e) {
                     e.printStackTrace();
                  }

                  if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
                     System.out.println("---进入启动预计运行时间方法！");
                     String dataCount = "";
                     LineNumberReader lineNumberReader = new LineNumberReader(new FileReader("/data/infa_file/" + executeParam.getSourceFileDir() + "/" + desensitizationTable.getFilename()));
                     lineNumberReader.skip(Long.MAX_VALUE);
                     int lineNumber = lineNumberReader.getLineNumber() + 1;
                     dataCount = lineNumber + "";
                     System.out.println("数据源表" + desensitizationTable.getTablename() + "总行数：" + dataCount);
                     RedisClient redisClient = new RedisClient();
                     Jedis jedis = redisClient.getJedis();
                     jedis.set("dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename(), dataCount);
                     System.out.println("预计运行时间，key=dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename() + "，dataCount=" + dataCount);
                     jedis.close();
                  }

                  DmpDesensitizationServiceImpl.this.updateMonitorRunStatus(desensitizationTable.getTablename(), executeParam.getTableMap());
                  System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
                  sessionId = LoginWebService.returnStatus(executeParam.getInfoProperty());
                  System.out.println("创建执行脚本开始！tableName=" + desensitizationTable.getTablename());
                  DmpDesensitizationServiceImpl.this.createScriptFiletotarget(executeParam, desensitizationTable, executeParam.getTargetDataSystem().getDbtype(), tCoreDatasystemTarget, (List)map.get(desensitizationTable.getTablename()), rn);
                  System.out.println("调用启动工作流方法开始！tableName=" + desensitizationTable.getTablename());
                  int runId = DmpDesensitizationServiceImpl.this.startWorkFlowEx(workflowName, executeParam.getInfoProperty(), executeParam.getFolderName(), sessionId);
                  String dbType = executeParam.getTargetDataSystem().getDbtype();
                  System.out.println("启动脚本开始！dbType=" + dbType + ",tableName=" + desensitizationTable.getTablename());
                  if ("SYBASE_IQ".equals(dbType)) {
                     CommandTool.commandRtn("/data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh /data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".pipe");
                  } else if ("MSSQLSERVER".equals(dbType)) {
                     CommandTool.command("chmod -R 777 /data/infa_sqlserver/");
                     String completeStatus = DmpDesensitizationServiceImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
                     if ("1".equals(completeStatus)) {
                        CommandTool.commandRtn("/data/infa_sqlserver/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                     }
                  } else if ("SYBASE".equals(dbType)) {
                     System.out.println("执行SYBASE目标的脚本");
                     CommandTool.commandRtn("/data/infa_sybase/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                     System.out.println("执行目标的脚本:完成");
                  } else if ("MYSQL".equals(dbType)) {
                     System.out.println("执行目标的脚本");
                     CommandTool.commandRtn("/data/infa_mysqlload/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                     System.out.println("执行目标的脚本:完成");
                  } else if ("TERADATA".equals(dbType)) {
                     System.out.println("执行目标的脚本");
                     CommandTool.commandRtn2("/data/infa_teradata/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                     System.out.println("执行目标的脚本:完成");
                  } else if ("DB2".equals(dbType)) {
                     CommandTool.commandRtn("/data/infa_db2/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                  }

                  String completeStatus = "0";
                  if (runId >= 0) {
                     completeStatus = DmpDesensitizationServiceImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
                  }

                  if ("1".equals(completeStatus)) {
                     System.out.println("表" + desensitizationTable.getTablename() + ",执行完成,通过阻塞方法！");
                     SessionBean sessionBean = DmpDesensitizationServiceImpl.this.getLogForTaskMapping(executeParam.getFolderName(), executeParam.getInfoProperty(), executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
                     System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
                     if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                        status = "1";
                     } else if ("FAILED".equals(sessionBean.getStatus())) {
                        status = "2";
                     } else if ("STOPPED".equals(sessionBean.getStatus())) {
                        status = "3";
                     } else {
                        status = "4";
                     }

                     System.out.println("执行更新监控表开始！tableName=" + desensitizationTable.getTablename());
                     DmpDesensitizationServiceImpl.this.updateMonitor(desensitizationTable.getTablename(), executeParam.getTableMap(), status, runId);
                  }

                  LogoutWebService.returnStatus(sessionId, executeParam.getInfoProperty());
               } catch (Exception e) {
                  e.printStackTrace();
               } finally {
                  countDownLatch.countDown();
               }

            }
         });
      }

      try {
         System.out.println(">>>>>>>>>>>>>>>当前活动线程数：" + this.taskExecutor.getActiveCount());
         System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + countDownLatch.getCount());
         countDownLatch.await();
         this.desensitizationtaskDao.getSession().getTransaction().begin();
         desensitizationTask.setTaskstatus("0");
         this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
         this.desensitizationtaskDao.getSession().getTransaction().commit();
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @Async
   public void executeTaskNormal(final ExecuteParam executeParam) throws Exception {
      System.out.println(">>>>>>>>>>>>>>>>>TaskNormal<<<<<<<<<<<<<<<<<<");
      List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
      final CountDownLatch countDownLatch = new CountDownLatch(tableList.size());
      final Desensitizationtask desensitizationTask = (Desensitizationtask)this.desensitizationtaskDao.get(executeParam.getTaskid());
      desensitizationTask.setTaskstatus("1");
      this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
      this.desensitizationtaskDao.getSession().getTransaction().commit();

      for(final DesensitizationTable desensitizationTable : tableList) {
         String filename = desensitizationTable.getTablename();
         final String schemaName = filename.substring(0, filename.lastIndexOf("-"));
         final String tableName = filename.substring(filename.lastIndexOf("-") + 1, filename.length());
         this.taskExecutor.execute(new Runnable() {
            public void run() {
               String sessionId = "";
               String status = "4";
               String workflowName = "wf_" + executeParam.getTaskNameReal() + "_" + schemaName + "_" + tableName;

               try {
                  Properties props = new Properties();

                  try {
                     props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                  } catch (IOException e) {
                     e.printStackTrace();
                  }

                  if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
                     System.out.println("---进入启动预计运行时间方法！");
                     String dataCount = "";
                     LineNumberReader lineNumberReader = new LineNumberReader(new FileReader("/data/infa_dmp/text/" + schemaName + "_" + tableName + ".txt"));
                     lineNumberReader.skip(Long.MAX_VALUE);
                     int lineNumber = lineNumberReader.getLineNumber() + 1;
                     dataCount = lineNumber + "";
                     System.out.println("数据源表" + desensitizationTable.getTablename() + "总行数：" + dataCount);
                     RedisClient redisClient = new RedisClient();
                     Jedis jedis = redisClient.getJedis();
                     jedis.set("dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename(), dataCount);
                     System.out.println("预计运行时间，key=dataCount:" + desensitizationTask.getTasknamereal() + "_" + schemaName + "_" + tableName + "，dataCount=" + dataCount);
                     jedis.close();
                  }

                  DmpDesensitizationServiceImpl.this.updateMonitorRunStatus(desensitizationTable.getTablename(), executeParam.getTableMap());
                  System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
                  sessionId = LoginWebService.returnStatus(executeParam.getInfoProperty());
                  System.out.println("调用启动工作流方法开始！tableName=" + desensitizationTable.getTablename());
                  int runId = DmpDesensitizationServiceImpl.this.startWorkFlowEx(workflowName, executeParam.getInfoProperty(), executeParam.getFolderName(), sessionId);
                  String completeStatus = "0";
                  if (runId >= 0) {
                     completeStatus = DmpDesensitizationServiceImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + schemaName + "_" + tableName, sessionId);
                  }

                  if ("1".equals(completeStatus)) {
                     System.out.println("表" + desensitizationTable.getTablename() + ",执行完成,通过阻塞方法！");
                     SessionBean sessionBean = DmpDesensitizationServiceImpl.this.getLogForTaskMapping(executeParam.getFolderName(), executeParam.getInfoProperty(), executeParam.getTaskNameReal() + "_" + schemaName + "_" + tableName, sessionId);
                     System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
                     if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                        status = "1";
                     } else if ("FAILED".equals(sessionBean.getStatus())) {
                        status = "2";
                     } else if ("STOPPED".equals(sessionBean.getStatus())) {
                        status = "3";
                     } else {
                        status = "4";
                     }

                     System.out.println("执行更新监控表开始！tableName=" + desensitizationTable.getTablename());
                     DmpDesensitizationServiceImpl.this.updateMonitor(desensitizationTable.getTablename(), executeParam.getTableMap(), status, runId);
                  }

                  LogoutWebService.returnStatus(sessionId, executeParam.getInfoProperty());
               } catch (Exception e) {
                  e.printStackTrace();
               } finally {
                  countDownLatch.countDown();
               }

            }
         });
      }

      try {
         System.out.println(">>>>>>>>>>>>>>>当前活动线程数：" + this.taskExecutor.getActiveCount());
         System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + countDownLatch.getCount());
         countDownLatch.await();
         this.desensitizationtaskDao.getSession().getTransaction().begin();
         desensitizationTask.setTaskstatus("0");
         this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
         this.desensitizationtaskDao.getSession().getTransaction().commit();
         System.out.println(">>>>>>>>>>>>>>>任务已全部执行完成！同步表信息开始！");
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   private void createScriptFiletotarget(ExecuteParam executeParam, DesensitizationTable desensitizationTable, String dbType, TCoreDatasystem tCoreDatasystemTarget, List<DesensitizationTablecolumn> desensitizationTablecolumnList, Runtime rn) throws Exception {
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String tableName = desensitizationTable.getTablename();
      String type = "target";
      if (executeParam.getTargettype() == null || !executeParam.getTargettype().equals("normal")) {
         TCoreConfig tcoreConfig = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", executeParam.getDataSourceId())});
         if (tcoreConfig != null) {
            String filepath = tcoreConfig.getFileDir();
            if (filepath == null || filepath.equals("")) {
               filepath = XmlTool.getFileValue(dbType + "/db-fileDir");
            }

            System.out.println("创建目标脚本开始！____" + dbType);
            if ("SYBASE_IQ".equals(dbType)) {
               Process process = rn.exec("mkfifo " + filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator + tableName + ".pipe");
               process.waitFor();
               Map<String, String> lm = new HashMap();
               lm.put("user", tCoreDatasystemTarget.getUsername());
               lm.put("pwd", "1".equals(tCoreDatasystemTarget.getFlag()) ? AesTool.decrypt(tCoreDatasystemTarget.getPassword(), "ghca") : tCoreDatasystemTarget.getPassword());
               lm.put("ip", tCoreDatasystemTarget.getDbip());
               lm.put("port", tCoreDatasystemTarget.getDbport());
               lm.put("table", tableName);
               lm.put("schema", executeParam.getTargetSchemaName());
               lm.put("path", filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator + tableName + ".sh");
               String col = "";

               for(int i = 0; i < desensitizationTablecolumnList.size(); ++i) {
                  if (i != desensitizationTablecolumnList.size() - 1) {
                     col = col + ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(i)).getColumnname() + "|" + ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(i)).getColumntartype() + ",";
                  } else {
                     col = col + ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(i)).getColumnname() + "|" + ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(i)).getColumntartype();
                  }
               }

               lm.put("lm", col);
               lm.put("loadscripttype", executeParam.getLoadscripttype());
               SybaseIQLoadTableTool.executeLoadTable(lm);
            } else if ("MSSQLSERVER".equals(dbType)) {
               FileTool.createFolder(filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator);
               Map<String, String> bcpProperties = new HashMap();
               bcpProperties.put("user", tCoreDatasystemTarget.getUsername());
               bcpProperties.put("pwd", "1".equals(tCoreDatasystemTarget.getFlag()) ? AesTool.decrypt(tCoreDatasystemTarget.getPassword(), "ghca") : tCoreDatasystemTarget.getPassword());
               bcpProperties.put("ip", tCoreDatasystemTarget.getDbip());
               bcpProperties.put("dbschema", executeParam.getTargetSchemaName());
               bcpProperties.put("tablename", tableName);
               bcpProperties.put("database", tCoreDatasystemTarget.getDbservername());
               bcpProperties.put("taskname", executeParam.getTaskNameReal());
               bcpProperties.put("path", filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator + tableName + ".sh");
               TCoreConfig tcoreConfig1 = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", executeParam.getDataSourceId())});
               SqlServerBcpTableTool.createBcpScript(bcpProperties, tcoreConfig1);
            } else if ("SYBASE".equals(dbType)) {
               String sybase_file_path = filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator;
               FileTool.createFolder(filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator);
               Map<String, String> bcpProperties = new HashMap();
               bcpProperties.put("user", tCoreDatasystemTarget.getUsername());
               bcpProperties.put("pwd", "1".equals(tCoreDatasystemTarget.getFlag()) ? AesTool.decrypt(tCoreDatasystemTarget.getPassword(), "ghca") : tCoreDatasystemTarget.getPassword());
               bcpProperties.put("ip", tCoreDatasystemTarget.getDbip());
               bcpProperties.put("servername", tCoreDatasystemTarget.getServername());
               bcpProperties.put("dbschema", executeParam.getTargetSchemaName());
               bcpProperties.put("tablename", tableName);
               bcpProperties.put("database", tCoreDatasystemTarget.getDbservername());
               bcpProperties.put("taskname", executeParam.getTaskNameReal());
               bcpProperties.put("path", filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator + tableName + ".sh");
               bcpProperties.put("pagecode", tCoreDatasystemTarget.getPagecode());
               CommandTool.command("mkfifo  " + sybase_file_path + tableName + ".pipe");
               CommandTool.command("chmod -R 777 " + sybase_file_path + tableName + ".pipe");
               System.out.println(">>>>>>>>>>>>>>SqlServerBcpTableTool.createBcpScript(bcpProperties,executeParam.getTaskid()); start");
               SybaseBcpTableTool.createBcpInScript(bcpProperties);
            } else if ("MYSQL".equals(dbType)) {
               String mysql_file_path = filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator;
               if (!FileTool.isFileExit(mysql_file_path)) {
                  FileTool.createFolder(mysql_file_path);
               }

               Map<String, String> mysqlloadparam = new HashMap();
               mysqlloadparam.put("username", tCoreDatasystemTarget.getUsername());
               mysqlloadparam.put("password", "1".equals(tCoreDatasystemTarget.getFlag()) ? AesTool.decrypt(tCoreDatasystemTarget.getPassword(), "ghca") : tCoreDatasystemTarget.getPassword());
               mysqlloadparam.put("hostname", tCoreDatasystemTarget.getDbip());
               mysqlloadparam.put("filepath", mysql_file_path + tableName + ".pipe");
               mysqlloadparam.put("path", mysql_file_path);
               mysqlloadparam.put("database", executeParam.getTargetSchemaName());
               mysqlloadparam.put("tablename", tableName);
               mysqlloadparam.put("taskname", executeParam.getTaskNameReal());
               mysqlloadparam.put("delimiter", props.getProperty("mysql_load_col_split"));
               CommandTool.command("mkfifo  " + mysql_file_path + tableName + ".pipe");
               MysqlLoadTableTool.executeLoadTable_new(mysqlloadparam);
            } else if ("TERADATA".equals(dbType)) {
               String teradata_file_path = filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator;
               if (!FileTool.isFileExit(teradata_file_path)) {
                  FileTool.createFolder(teradata_file_path);
               }

               List<String> nameList = new ArrayList();
               List<String> lengthList = new ArrayList();
               List<String> typeList = new ArrayList();

               for(DesensitizationTablecolumn sourceTableCol : desensitizationTablecolumnList) {
                  nameList.add(sourceTableCol.getColumnname());
                  lengthList.add(sourceTableCol.getColumnlength());
                  typeList.add(sourceTableCol.getColumntartype());
               }

               StringBuffer definesb = new StringBuffer();
               StringBuffer sqlsb = new StringBuffer();
               StringBuffer sqlvalue = new StringBuffer();
               Map<String, String> paramMapload = new HashMap();
               paramMapload.put("ip", tCoreDatasystemTarget.getDbip());
               paramMapload.put("port", tCoreDatasystemTarget.getDbport());
               paramMapload.put("user", tCoreDatasystemTarget.getUsername());
               paramMapload.put("pwd", "1".equals(tCoreDatasystemTarget.getFlag()) ? AesTool.decrypt(tCoreDatasystemTarget.getPassword(), "ghca") : tCoreDatasystemTarget.getPassword());
               paramMapload.put("schema", executeParam.getTargetSchemaName());
               paramMapload.put("table", desensitizationTable.getTablename());
               paramMapload.put("path", teradata_file_path);
               paramMapload.put("in_type", "1");
               String dbcode = tCoreDatasystemTarget.getDbtype();
               String servername = tCoreDatasystemTarget.getDbservername();
               String url = EdbType.getUrlByEdbcode(dbcode, tCoreDatasystemTarget.getDbip(), tCoreDatasystemTarget.getDbport(), servername, tCoreDatasystemTarget.getPagecode());
               String driver = EdbType.getEdbTypeByDbcode(dbcode).getDbdriver();
               paramMapload.put("driver", driver);
               paramMapload.put("url", url);
               paramMapload.put("create_sql", desensitizationTable.getCreate_sql());
               CommandTool.command("mkfifo " + teradata_file_path + desensitizationTable.getTablename() + ".pipe");
               switch (executeParam.getTargettype()) {
                  case "multiload":
                     sqlsb.append("(");
                     sqlvalue.append("values(");

                     for(int i = 0; i < nameList.size(); ++i) {
                        definesb.append("\n.FIELD in_" + (String)nameList.get(i) + " * varchar(" + TeradataLoadTableTool.getcolumNumber((String)typeList.get(i), (String)lengthList.get(i)) + ");");
                        sqlsb.append((String)nameList.get(i) + ",");
                        sqlvalue.append(":in_" + (String)nameList.get(i) + ",");
                     }

                     sqlsb.deleteCharAt(sqlsb.length() - 1);
                     sqlvalue.deleteCharAt(sqlvalue.length() - 1);
                     sqlvalue.append(");");
                     sqlsb.append(")");
                     paramMapload.put("define", definesb.toString());
                     paramMapload.put("sql", sqlsb.toString() + sqlvalue.toString());
                     Connection tconn = this.getConnectionByDataSystemId(executeParam.getTargetDataSystem());
                     JdbcTool.dropTable(tconn, executeParam.getTargetSchemaName(), "ET_" + tableName);
                     JdbcTool.dropTable(tconn, executeParam.getTargetSchemaName(), "WT_" + tableName);
                     JdbcTool.dropTable(tconn, executeParam.getTargetSchemaName(), "UV_" + tableName);
                     JdbcTool.dropTable(tconn, executeParam.getTargetSchemaName(), tableName + "_log");
                     TeradataLoadTableTool.createmultiLoadTableSh(paramMapload);
                     break;
                  case "fastload":
                     for(int i = 0; i < nameList.size(); ++i) {
                        definesb.append((String)nameList.get(i) + "(varchar(" + TeradataLoadTableTool.getcolumNumber((String)typeList.get(i), (String)lengthList.get(i)) + ")),");
                     }

                     paramMapload.put("define", definesb.substring(0, definesb.length() - 1));
                     TeradataLoadTableTool.createfastLoadTableSh(paramMapload);
               }
            } else if ("DB2".equals(dbType)) {
               FileTool.createFolder(filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator);
               Map<String, String> db2Properties = new HashMap();
               db2Properties.put("user", tCoreDatasystemTarget.getUsername());
               db2Properties.put("pwd", "1".equals(tCoreDatasystemTarget.getFlag()) ? AesTool.decrypt(tCoreDatasystemTarget.getPassword(), "ghca") : tCoreDatasystemTarget.getPassword());
               db2Properties.put("ip", tCoreDatasystemTarget.getDbip());
               db2Properties.put("port", tCoreDatasystemTarget.getDbport());
               db2Properties.put("dbschema", executeParam.getTargetSchemaName());
               db2Properties.put("tablename", tableName);
               db2Properties.put("database", tCoreDatasystemTarget.getDbservername());
               db2Properties.put("taskname", executeParam.getTaskNameReal());
               db2Properties.put("path", filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator);
               db2Properties.put("linkname", tCoreDatasystemTarget.getDblinkname());
               DB2LoadTableTool.executeLoadTable(db2Properties);
            }
         }
      }

   }

   private void createScriptFiletoSource(ExecuteParam executeParam, DesensitizationTable desensitizationTable, String dbType, TCoreDatasystem tCoreDatasystemSource, List<DesensitizationTablecolumn> desensitizationTablecolumnList, Runtime rn) throws Exception {
      String tableName = desensitizationTable.getTablename();
      String type = "source";
      if (executeParam.getSourcetype() == null || !executeParam.getSourcetype().equals("normal")) {
         TCoreConfig tcoreConfig = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", executeParam.getDataSourceId())});
         if (tcoreConfig != null) {
            String filepath = tcoreConfig.getFileDir();
            if (filepath == null || filepath.equals("")) {
               filepath = XmlTool.getFileValue(dbType + "/db-fileDir");
            }

            System.out.println("创建源脚本开始！____" + dbType);
            if (!"SYBASE_IQ".equals(dbType)) {
               if ("MSSQLSERVER".equals(dbType)) {
                  List<Map<String, String>> columns = new ArrayList();

                  for(int j = 0; j < desensitizationTablecolumnList.size(); ++j) {
                     Map<String, String> columnMap = new HashMap();
                     String colName = ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumnname();
                     String colType = ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumntype();
                     columnMap.put("name", colName);
                     columnMap.put("type", colType);
                     columns.add(columnMap);
                  }

                  FileTool.createFolder(filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator);
                  Map<String, Object> bcpProperties = new HashMap();
                  bcpProperties.put("user", tCoreDatasystemSource.getUsername());
                  bcpProperties.put("pwd", "1".equals(tCoreDatasystemSource.getFlag()) ? AesTool.decrypt(tCoreDatasystemSource.getPassword(), "ghca") : tCoreDatasystemSource.getPassword());
                  bcpProperties.put("ip", tCoreDatasystemSource.getDbip());
                  bcpProperties.put("dbschema", executeParam.getSourceSchemaName());
                  bcpProperties.put("tablename", tableName);
                  bcpProperties.put("database", tCoreDatasystemSource.getDbservername());
                  bcpProperties.put("taskname", executeParam.getTaskNameReal());
                  bcpProperties.put("path", filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator + tableName + ".sh");
                  bcpProperties.put("columns", columns);
                  SqlServerBcpTableTool.createBcpExportScript(bcpProperties);
               } else if ("TERADATA".equals(dbType)) {
                  List<String> colNameLst = new ArrayList();
                  Integer totalLen = 0;

                  for(int j = 0; j < desensitizationTablecolumnList.size(); ++j) {
                     totalLen = totalLen + 3;
                     String colName = ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumnname();
                     String colType = ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumntype();
                     String colLength = ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumnlength();
                     String colScale = ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumnscale() == null ? "" : ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumnscale();
                     colName = TeradataTool.teradataTypetoVarchar(colName, colType, colLength);
                     String realColLength = TeradataTool.teradataTypeLength(colType, colLength, colScale);
                     if (StringUtils.isNotBlank(realColLength)) {
                        totalLen = totalLen + Integer.valueOf(realColLength);
                     }

                     colNameLst.add(colName);
                  }

                  String colNamesStr = StringUtils.join(colNameLst.toArray(), "||'|'||");
                  colNamesStr = "(cast(" + colNamesStr + " as char(" + totalLen + ")))";
                  Map<String, String> paramMap = new HashMap();
                  paramMap.put("schema", executeParam.getSourceSchemaName());
                  paramMap.put("tablename", desensitizationTable.getTablename());
                  paramMap.put("colNamesStr", colNamesStr);
                  String source_pipe_path = filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator;
                  if (!FileTool.isFileExit(source_pipe_path)) {
                     FileTool.createFolder(source_pipe_path);
                  }

                  paramMap.put("source_pipe_path", source_pipe_path);
                  paramMap.put("teradataServersIp", tCoreDatasystemSource.getDbip());
                  paramMap.put("teradataServersUser", tCoreDatasystemSource.getUsername());
                  paramMap.put("teradataServerspwd", "1".equals(tCoreDatasystemSource.getFlag()) ? AesTool.decrypt(tCoreDatasystemSource.getPassword(), "ghca") : tCoreDatasystemSource.getPassword());
                  paramMap.put("taskname", executeParam.getTaskNameReal());
                  Connection tconn = this.getConnectionByDataSystemId(executeParam.getSourceDataSystem());
                  JdbcTool.dropTable(tconn, executeParam.getSourceSchemaName(), tableName + "_log");
                  CommandTool.command("mkfifo  " + source_pipe_path + tableName + ".pipe");
                  System.out.println("创建Teradata_source_pipe");
                  TeradataTool.createTerdataExportScript_new(paramMap);
               } else if ("HIVE".equals(dbType)) {
                  String source_pipe_path = filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator;
                  if (!FileTool.isFileExit(source_pipe_path)) {
                     FileTool.createFolder(source_pipe_path);
                  }

                  CommandTool.commandRtn2("mkfifo  " + source_pipe_path + tableName + ".pipe");
               } else if ("MYSQL".equals(dbType)) {
                  String mysql_file_path = filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator;
                  if (!FileTool.isFileExit(mysql_file_path)) {
                     FileTool.createFolder(mysql_file_path);
                  }

                  Map<String, String> mysqlloadparam = new HashMap();
                  mysqlloadparam.put("username", tCoreDatasystemSource.getUsername());
                  mysqlloadparam.put("password", "1".equals(tCoreDatasystemSource.getFlag()) ? AesTool.decrypt(tCoreDatasystemSource.getPassword(), "ghca") : tCoreDatasystemSource.getPassword());
                  mysqlloadparam.put("hostname", tCoreDatasystemSource.getDbip());
                  mysqlloadparam.put("filepath", mysql_file_path + tableName + ".pipe");
                  mysqlloadparam.put("path", mysql_file_path);
                  mysqlloadparam.put("database", executeParam.getSourceSchemaName());
                  mysqlloadparam.put("tablename", tableName);
                  mysqlloadparam.put("taskname", executeParam.getTaskNameReal());
                  List<String> columnNameList = new ArrayList();

                  for(DesensitizationTablecolumn desensitizationTablecolumn : desensitizationTablecolumnList) {
                     String colName = desensitizationTablecolumn.getColumnname();
                     columnNameList.add(colName);
                  }

                  mysqlloadparam.put("columnNameList", columnNameList.toString().replace("[", "").replace("]", ""));
                  CommandTool.command("mkfifo  " + mysql_file_path + tableName + ".pipe");
                  MysqlLoadTableTool.executeExportFileTable(mysqlloadparam);
               } else if ("SYBASE".equals(dbType)) {
                  String sybase_file_path = filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator;
                  FileTool.createFolder(filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator);
                  Map<String, String> bcpProperties = new HashMap();
                  bcpProperties.put("user", tCoreDatasystemSource.getUsername());
                  bcpProperties.put("pwd", "1".equals(tCoreDatasystemSource.getFlag()) ? AesTool.decrypt(tCoreDatasystemSource.getPassword(), "ghca") : tCoreDatasystemSource.getPassword());
                  bcpProperties.put("ip", tCoreDatasystemSource.getDbip());
                  bcpProperties.put("servername", tCoreDatasystemSource.getServername());
                  bcpProperties.put("charset", tCoreDatasystemSource.getPagecode());
                  bcpProperties.put("dbschema", executeParam.getSourceSchemaName());
                  bcpProperties.put("tablename", tableName);
                  bcpProperties.put("database", tCoreDatasystemSource.getDbservername());
                  bcpProperties.put("taskname", executeParam.getTaskNameReal());
                  bcpProperties.put("path", filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator + tableName + ".sh");
                  CommandTool.command("mkfifo  " + sybase_file_path + tableName + ".pipe");
                  CommandTool.command("chmod -R 777 " + sybase_file_path + tableName + ".pipe");
                  System.out.println(">>>>>>>>>>>>>>SqlServerBcpTableTool.createBcpOutScript(bcpProperties); start");
                  SybaseBcpTableTool.createBcpOutScript(bcpProperties);
               }
            }
         }
      }

   }

   public String startWorkFlow(ExecuteParam executeParam, String tableName, String sessionId) {
      String workFlowName = "wf_" + executeParam.getTaskNameReal() + "_" + tableName;
      String returnStatus = "FAIL";

      try {
         if (StringUtils.isNoneBlank(new CharSequence[]{workFlowName}) && !workFlowName.startsWith("wf_")) {
            workFlowName = "wf_" + workFlowName;
         }

         returnStatus = StartWorkFlowWebService.returnStatus(sessionId, executeParam.getInfoProperty(), workFlowName, executeParam.getFolderName());
         return returnStatus;
      } catch (Fault e) {
         e.printStackTrace();
         return "FAIL";
      } catch (Exception e) {
         e.printStackTrace();
         return "FAIL";
      }
   }

   public int startWorkFlowEx(String workflowName, InfoProperty engine, String folderName, String sessionId) {
      if (StringUtils.isNoneBlank(new CharSequence[]{workflowName}) && !workflowName.startsWith("wf_")) {
         workflowName = "wf_" + workflowName;
      }

      int runId = -1;
      DataIntegrationInterface webService = (new DataIntegrationService()).getDataIntegration();
      DIServiceInfo dIServiceInfo = new DIServiceInfo();
      dIServiceInfo.setDomainName(engine.getDomainname());
      dIServiceInfo.setServiceName(engine.getInteservicename());
      TypeStartWorkflowExRequest typeStartWorkflowExRequest = new TypeStartWorkflowExRequest();
      typeStartWorkflowExRequest.setDIServiceInfo(dIServiceInfo);
      typeStartWorkflowExRequest.setFolderName(folderName);
      typeStartWorkflowExRequest.setWorkflowName(workflowName);
      typeStartWorkflowExRequest.setRequestMode(ETaskRunMode.RECOVERY);

      try {
         SessionHeader sessionHeader = new SessionHeader();
         sessionHeader.setSessionId(sessionId);
         TypeStartWorkflowExResponse startWorkflowEx = webService.startWorkflowEx(typeStartWorkflowExRequest, sessionHeader);
         runId = startWorkflowEx.getRunId();
      } catch (Exception e) {
         e.printStackTrace();
      }

      return runId;
   }

   public void updateMonitor(String tableNane, Map<String, String> tableMap, String status, int runid) {
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String sqlurl = props.get("jdbc.url").toString();
         String username = props.get("jdbc.user").toString();
         String password = props.get("jdbc.password").toString();
         String driver = props.get("jdbc.driver").toString();
         Connection connection = JdbcTool.getConnection(driver, sqlurl, username, password);
         Statement statement = connection.createStatement();
         String sql = "UPDATE desensitization_monitor SET flag = '" + status + "',runid = '" + runid + "' WHERE id = '" + (String)tableMap.get(tableNane) + "'";
         System.out.println("update:desensitization_monitor=" + sql);
         statement.executeUpdate(sql.toString());
         statement.close();
         connection.close();
      } catch (IOException e) {
         e.printStackTrace();
      } catch (SQLException e) {
         e.printStackTrace();
      }

   }

   public void updateMonitorRunStatus(String tableName, Map<String, String> tableMap) {
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String sqlurl = props.get("jdbc.url").toString();
         String username = props.get("jdbc.user").toString();
         String password = props.get("jdbc.password").toString();
         String driver = props.get("jdbc.driver").toString();
         Connection connection = JdbcTool.getConnection(driver, sqlurl, username, password);
         Statement statement = connection.createStatement();
         String sql = "UPDATE desensitization_monitor SET runstatus = 1,executetime = now() WHERE id = '" + (String)tableMap.get(tableName) + "'";
         System.out.println("updateStatus:desensitization_monitor=" + sql);
         statement.executeUpdate(sql.toString());
         statement.close();
         connection.close();
      } catch (IOException e) {
         e.printStackTrace();
      } catch (SQLException e) {
         e.printStackTrace();
      }

   }

   public String workflowTaskCompleteMonitor(InfoProperty engine, String folderName, String workflowName, String sessionId) {
      if (StringUtils.isNoneBlank(new CharSequence[]{workflowName}) && !workflowName.startsWith("wf_")) {
         workflowName = "wf_" + workflowName;
      }

      String completeStatus = "0";
      DataIntegrationInterface webService = (new DataIntegrationService()).getDataIntegration();
      DIServiceInfo dIServiceInfo = new DIServiceInfo();
      dIServiceInfo.setDomainName(engine.getDomainname());
      dIServiceInfo.setServiceName(engine.getInteservicename());
      WorkflowRequest workflowRequest = new WorkflowRequest();
      workflowRequest.setDIServiceInfo(dIServiceInfo);
      workflowRequest.setFolderName(folderName);
      workflowRequest.setWorkflowName(workflowName);

      try {
         SessionHeader sessionHeader = new SessionHeader();
         sessionHeader.setSessionId(sessionId);
         webService.waitTillWorkflowComplete(workflowRequest, sessionHeader);
      } catch (Exception var10) {
         System.out.println("该工作流未运行，或者已完成！");
      }

      completeStatus = "1";
      return completeStatus;
   }

   public String returnBaseType(TCoreDatasystem targettype, TCoreDatasystem sourcetype) {
      String type = "";
      if (sourcetype == null) {
         type = "FILE";
      } else if (sourcetype.getFlag().equals("1")) {
         type = "DB";
      } else if (sourcetype.getFlag().equals("2")) {
         type = sourcetype.getDbtype();
      } else if (sourcetype.getFlag().equals("3")) {
         type = "HIVE";
      }

      if (targettype == null) {
         type = type + "toFILE";
      } else if (targettype.getFlag().equals("1")) {
         type = type + "toDB";
      } else if (targettype.getFlag().equals("2")) {
         type = type + "to" + sourcetype.getDbtype();
      } else if (targettype.getFlag().equals("3")) {
         type = type + "toHIVE";
      }

      return type;
   }

   public void synTableParam(List<DesensitizationTable> tableList, ExecuteParam executeParam) {
      try {
         Connection srcconn = this.dataSystemService.getConnectionByDataSystemId(executeParam.getDataSourceId());
         Connection tarconn = this.dataSystemService.getConnectionByDataSystemId(executeParam.getDataTargetId());

         for(DesensitizationTable desensitizationTable : tableList) {
            if ("isprimary".equalsIgnoreCase(executeParam.getIsPrimary())) {
               JdbcTool.synchronizePrimaryKey(srcconn, executeParam.getSourceSchemaName(), desensitizationTable.getTablename(), tarconn, executeParam.getTargetSchemaName(), desensitizationTable.getTablename());
            }

            if ("isindex".equalsIgnoreCase(executeParam.getIsIndex())) {
               JdbcTool.synchronizeIndex(srcconn, executeParam.getSourceSchemaName(), desensitizationTable.getTablename(), tarconn, executeParam.getTargetSchemaName(), desensitizationTable.getTablename());
            }
         }

         for(DesensitizationTable desensitizationTable : tableList) {
            JdbcTool.synchronizeForeignKey(srcconn, executeParam.getSourceSchemaName(), desensitizationTable.getTablename(), tarconn, executeParam.getTargetSchemaName(), desensitizationTable.getTablename());
         }

         JdbcTool.closeConnection(srcconn);
         JdbcTool.closeConnection(tarconn);
      } catch (Exception e) {
         e.printStackTrace();
      }
   }

   public SessionBean getLogForTaskMapping(String folerName, InfoProperty engine, String name, String sessionId) {
      SessionBean se = new SessionBean();

      try {
         se = MultiGetSessionStatisticsWebService.returnStatus(sessionId, engine, "wf_" + name, "mp_" + name, folerName);
      } catch (Exception e) {
         se.setStatus("EXCEPTION");
         e.printStackTrace();
      }

      return se;
   }

   public boolean updateTask(String tasknamereal, String save_state) {
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String sqlurl = props.get("jdbc.url").toString();
         String username = props.get("jdbc.user").toString();
         String password = props.get("jdbc.password").toString();
         String driver = props.get("jdbc.driver").toString();
         Connection connection = JdbcTool.getConnection(driver, sqlurl, username, password);
         Statement statement = connection.createStatement();
         String sql = "update desensitizationtask set save_state = '" + save_state + "' , taskstatus = '0'  where tasknamereal = '" + tasknamereal + "'";
         System.out.println(sql);
         statement.executeUpdate(sql.toString());
         statement.close();
         connection.close();
         return true;
      } catch (IOException e) {
         e.printStackTrace();
         return false;
      } catch (SQLException e) {
         e.printStackTrace();
         return false;
      }
   }

   public boolean updateTask_taskstatus(String taskid, String taskstatus) {
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String sqlurl = props.get("jdbc.url").toString();
         String username = props.get("jdbc.user").toString();
         String password = props.get("jdbc.password").toString();
         String driver = props.get("jdbc.driver").toString();
         Connection connection = JdbcTool.getConnection(driver, sqlurl, username, password);
         Statement statement = connection.createStatement();
         String sql = "update desensitizationtask set taskstatus = '" + taskstatus + "'  where id = '" + taskid + "'";
         System.out.println(sql);
         statement.executeUpdate(sql.toString());
         statement.close();
         connection.close();
         return true;
      } catch (IOException e) {
         e.printStackTrace();
         return false;
      } catch (SQLException e) {
         e.printStackTrace();
         return false;
      }
   }

   public void updateTask(Desensitizationtask desensitizationtask) {
      this.desensitizationtaskDao.saveOrUpdate(desensitizationtask);
   }

   public String pageCode(String pageCode) {
      if (pageCode == null) {
         pageCode = "";
      }

      Map<String, String> mappage = new HashMap();
      mappage.put("GBK", "MS936");
      mappage.put("UTF-8", "UTF-8");
      mappage.put("UTF8", "UTF-8");
      mappage.put("", "");
      return (String)mappage.get(pageCode);
   }

   public String pageCode(int pageCode) {
      Map<Integer, String> mappage = new HashMap();
      mappage.put(1, "MS936");
      mappage.put(0, "UTF-8");
      mappage.put(2, "MS950");
      return (String)mappage.get(pageCode);
   }

   public String pageCode_dbf(int pageCode) {
      Map<Integer, String> mappage = new HashMap();
      mappage.put(1, "GBK");
      mappage.put(0, "UTF-8");
      mappage.put(2, "MS950");
      return (String)mappage.get(pageCode);
   }

   public Map<String, String> getDataRuleMap() {
      Map<String, String> data_rule = new HashMap();
      new ArrayList();

      for(TCoreMaskingRuleinfo tCoreMaskingRuleinfo : this.tCoreMaskingRuleinfoDao.queryAll()) {
         data_rule.put(tCoreMaskingRuleinfo.getRuleid(), tCoreMaskingRuleinfo.getMappletname());
      }

      return data_rule;
   }

   public HashMap<String, TCoreFieldSensitiveMemory> getTCoreFieldSensitiveMemory(Jedis jedis, String tableName, String sourceschema) {
      HashMap<String, TCoreFieldSensitiveMemory> map = new HashMap();
      if (jedis.exists((tableName + "+" + sourceschema).getBytes())) {
         byte[] mebyt = jedis.get((tableName + "+" + sourceschema).getBytes());
         if (mebyt != null) {
            Object obj = RedisTool.unserizlize(mebyt);
            new ArrayList();

            List<TCoreFieldSensitiveMemory> listNew = (List)obj;
            for(TCoreFieldSensitiveMemory tCoreFieldSensitiveMemory : listNew) {
               map.put(tCoreFieldSensitiveMemory.getColumnname(), tCoreFieldSensitiveMemory);
            }
         }
      }

      return map;
   }

   public FlatFile getflatFile(String type, String pagecode, String dataBaseType, String tableName, String tasknamereal) {
      FlatFile flatFile = new FlatFile();
      flatFile.setCodePage("MSSQLSERVER".equals(dataBaseType) ? "UTF-8" : this.pageCode(pagecode));
      flatFile.setDelimiter(XmlTool.getFileValue(dataBaseType + "/db-" + type + "delimiter"));
      flatFile.setFilename(tableName + XmlTool.getFileValue(dataBaseType + "/db-suffix"));
      flatFile.setFileType(Integer.parseInt(XmlTool.getFileValue(dataBaseType + "/db-" + type + "fileType")));
      flatFile.setQuoteCharacter(Integer.parseInt(XmlTool.getFileValue(dataBaseType + "/db-" + type + "quoteCharacter")));
      flatFile.setSkipRows(Integer.parseInt(XmlTool.getFileValue(dataBaseType + "/db-" + type + "skipRows")));
      String filepath = XmlTool.getFileValue(dataBaseType + "/db-fileDir") + type + "/" + tasknamereal + "/";
      flatFile.setCommand("cat " + filepath + flatFile.getFilename());
      flatFile.setFileDir(filepath);
      if (!FileTool.isFileExit(filepath)) {
         FileTool.createFolder(filepath);
      }

      return flatFile;
   }

   public FlatFile getflatFile(DesensitizationTable desensitizationTable, String filetype, Jedis jedis, String tasknamereal) {
      DesensitizationFile desensitizationfile = new DesensitizationFile();
      byte[] bs = jedis.get(("dmpTransTask" + tasknamereal + "_" + desensitizationfile.getClass().getSimpleName()).getBytes());
      FlatFile sourceflatFile = new FlatFile();
      if (bs != null) {
         desensitizationfile = (DesensitizationFile)RedisTool.unserizlize(bs);
         sourceflatFile.setCodePage(this.pageCode(Integer.parseInt(desensitizationfile.getCodepage())));
         sourceflatFile.setCommand("");
         sourceflatFile.setDelimiter(desensitizationfile.getDelimiters());
         String filename = desensitizationTable.getTablename();
         String schemaName = filename.substring(0, filename.lastIndexOf("-"));
         String tableName = filename.substring(filename.lastIndexOf("-") + 1, filename.length());
         sourceflatFile.setFilename(schemaName + "_" + tableName + ".txt");
         sourceflatFile.setFileType(0);
         sourceflatFile.setQuoteCharacter(this.getQuoteCharacter(desensitizationfile.getQuotecharacter()));
         sourceflatFile.setSkipRows(0);
         String filepath = "";
         switch (filetype) {
            case "FILE":
               filepath = desensitizationfile.getFiledir();
               break;
            case "FTP":
               Desensitizationsource desensitizationsource1 = (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", desensitizationTable.getTaskid())});
               TCoreConfig tcoreConfig = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", desensitizationsource1.getDatasourceid())});
               if (tcoreConfig == null) {
                  break;
               }

               filepath = tcoreConfig.getLocaldir() + desensitizationTable.getFilepath();
               if (filepath == null || filepath.equals("")) {
                  filepath = XmlTool.getFileValue(filetype + "/localdir") + desensitizationTable.getFilepath();
               }
               break;
            case "SFTP":
               Desensitizationsource desensitizationsource11 = (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", desensitizationTable.getTaskid())});
               TCoreConfig tcoreConfig1 = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", desensitizationsource11.getDatasourceid())});
               if (tcoreConfig1 != null) {
                  filepath = tcoreConfig1.getLocaldir() + desensitizationTable.getFilepath();
                  if (filepath == null || filepath.equals("")) {
                     filepath = XmlTool.getFileValue(filetype + "/localdir") + desensitizationTable.getFilepath();
                  }
               }
         }

         sourceflatFile.setFileDir(filepath);
         if (!FileTool.isFileExit("/data/infa_file/")) {
            FileTool.createFolder("/data/infa_file/");
         }
      }

      return sourceflatFile;
   }

   public List<Desensitizationtask> queryTaskAll() {
      return this.desensitizationtaskDao.queryAll("createtime", false);
   }

   public long getExeTaskNum() {
      return this.desensitizationtaskDao.getExeTaskNum();
   }

   public long getTableNum(String taskid) {
      return this.desensitizationtaskDao.getTableNum(taskid);
   }

   public String getRunid(ExecuteParam executeParam, String sessionId, String tableName) {
      SessionBean se = new SessionBean();
      String name = executeParam.getTaskNameReal() + "_" + tableName;

      try {
         se = MultiGetSessionStatisticsWebService.returnStatus(sessionId, executeParam.getInfoProperty(), "wf_" + name, "mp_" + name, executeParam.getFolderName());
      } catch (Exception e) {
         e.printStackTrace();
      }

      String run_id = se.getWf_run_id();
      return run_id;
   }

   public int getQuoteCharacter(String param) {
      int pa = 0;
      switch (param) {
         case "none":
            pa = 0;
            break;
         case "double":
            pa = 2;
            break;
         case "single":
            pa = 1;
      }

      return pa;
   }

   public List<DesensitizationTablecolumn> queryColumInfo(String taskid, String table) {
      DesensitizationTable desensitizationTable = (DesensitizationTable)this.desensitizationTableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("tablename", table)});
      List<DesensitizationTablecolumn> list = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", desensitizationTable.getId())});
      return list;
   }

   public DesensitizationFile queryDesensitizationfileBytaskid(String taskid) {
      new DesensitizationFile();
      return (DesensitizationFile)this.desensitizationFileDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
   }

   @Async
   public void executeDB_batchread_FILE_pwc_FILE_batchwrite_DB(final ExecuteParam executeParam) throws Exception {
      System.out.println(">>>>>>>>>>>>>>>>>DB_batchread_FILE_pwc_FILE_batchwrite_DB<<<<<<<<<<<<<<<<<<");
      List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
      final TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(executeParam.getDataTargetId());
      final TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(executeParam.getDataSourceId());
      final Runtime rn = Runtime.getRuntime();
      final Map<String, List<DesensitizationTablecolumn>> map = new HashMap();
      final CountDownLatch countDownLatch = new CountDownLatch(tableList.size());

      for(DesensitizationTable desensitizationTable : tableList) {
         List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
         List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
         map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
      }

      final Desensitizationtask desensitizationTask = (Desensitizationtask)this.desensitizationtaskDao.get(executeParam.getTaskid());
      desensitizationTask.setTaskstatus("1");
      this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
      this.desensitizationtaskDao.getSession().getTransaction().commit();

      for(final DesensitizationTable desensitizationTable : tableList) {
         this.taskExecutor.execute(new Runnable() {
            public void run() {
               String sessionId = "";
               String status = "4";
               String workflowName = "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename();

               try {
                  Properties props = new Properties();

                  try {
                     props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                  } catch (IOException e) {
                     e.printStackTrace();
                  }

                  if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
                     System.out.println("---进入启动预计运行时间方法！");
                     String dataCount = "";
                     dataCount = DmpDesensitizationServiceImpl.this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
                     System.out.println("数据源表" + desensitizationTable.getTablename() + "总行数：" + dataCount);
                     RedisClient redisClient = new RedisClient();
                     Jedis jedis = redisClient.getJedis();
                     jedis.set("dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename(), dataCount);
                     System.out.println("预计运行时间，key=dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename() + "，dataCount=" + dataCount);
                     jedis.close();
                  }

                  DmpDesensitizationServiceImpl.this.updateMonitorRunStatus(desensitizationTable.getTablename(), executeParam.getTableMap());
                  System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
                  sessionId = LoginWebService.returnStatus(executeParam.getInfoProperty());
                  System.out.println("创建执行脚本开始！tableName=" + desensitizationTable.getTablename());
                  DmpDesensitizationServiceImpl.this.createScriptFiletotarget(executeParam, desensitizationTable, executeParam.getTargetDataSystem().getDbtype(), tCoreDatasystemTarget, (List)map.get(desensitizationTable.getTablename()), rn);
                  System.out.println("创建目标脚本开始！");
                  DmpDesensitizationServiceImpl.this.createScriptFiletoSource(executeParam, desensitizationTable, executeParam.getSourceDataSystem().getDbtype(), tCoreDatasystemSource, (List)map.get(desensitizationTable.getTablename()), rn);
                  System.out.println("创建源脚本开始！");
                  String targetdbType = executeParam.getTargetDataSystem().getDbtype();
                  String sourcedbType = executeParam.getSourceDataSystem().getDbtype();
                  System.out.println("启动脚本开始！dbType=" + targetdbType + ",tableName=" + desensitizationTable.getTablename());
                  System.out.println("调用启动工作流方法开始！tableName=" + desensitizationTable.getTablename());
                  int runId = DmpDesensitizationServiceImpl.this.startWorkFlowEx(workflowName, executeParam.getInfoProperty(), executeParam.getFolderName(), sessionId);
                  if ("TERADATA".equals(sourcedbType)) {
                     System.out.println("执行源的脚本：/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                     CommandTool.commandRtn2("/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                     System.out.println("执行源的脚本:完成");
                  } else if ("MSSQLSERVER".equals(sourcedbType)) {
                     CommandTool.commandRtn("/data/infa_sqlserver/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                     System.out.println("SQLSERVER执行源的脚本:完成");
                  } else if ("HIVE".equals(sourcedbType)) {
                     System.out.println("执行源的脚本：/data/hive/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                     TCoreConfig tcoreConfig = (TCoreConfig)DmpDesensitizationServiceImpl.this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", executeParam.getDataSourceId())});
                     if (tcoreConfig != null) {
                        String filepath = tcoreConfig.getFileDir();
                        String delimiter = tcoreConfig.getSourcedelimiter();
                        String charset = tcoreConfig.getCodePage();
                        if (filepath == null || filepath.equals("") || delimiter == null || delimiter.equals("") || charset == null || charset.equals("")) {
                           filepath = XmlTool.getFileValue(sourcedbType + "/db-fileDir");
                           delimiter = XmlTool.getFileValue(sourcedbType + "/db-sourcedelimiter");
                           charset = XmlTool.getFileValue(sourcedbType + "/db-codePage");
                        }

                        DmpDesensitizationServiceImpl.this.iskeberos(tCoreDatasystemSource);
                        Connection conn = JdbcTool.getConnection(tCoreDatasystemSource);
                        PipeTool pipe = new PipeTool(conn, executeParam.getSourceSchemaName() + "." + desensitizationTable.getTablename(), filepath + "/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".pipe", delimiter, charset);
                        pipe.writeFile();
                        System.out.println("HIVE执行源的脚本:完成");
                     }
                  } else if ("MYSQL".equals(sourcedbType)) {
                     System.out.println("执行MySql源的脚本：/data/infa_mysqlload/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                     CommandTool.commandRtn2("/data/infa_mysqlload/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                  } else if ("SYBASE".equals(sourcedbType)) {
                     CommandTool.commandRtn2("/data/infa_sybase/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                     System.out.println("SYBASE执行源的脚本:完成");
                  }

                  if ("TERADATA".equals(targetdbType)) {
                     System.out.println("执行目标的脚本");
                     CommandTool.commandRtn2("/data/infa_teradata/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                     System.out.println("执行目标的脚本:完成");
                  } else if ("MSSQLSERVER".equals(targetdbType)) {
                     CommandTool.command("chmod -R 777 /data/infa_sqlserver/");
                     String completeStatus = DmpDesensitizationServiceImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
                     if ("1".equals(completeStatus)) {
                        CommandTool.commandRtn("/data/infa_sqlserver/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                     }

                     System.out.println("SQLSERVER执行目标的脚本:完成");
                  } else if ("MYSQL".equals(targetdbType)) {
                     System.out.println("MySql执行目标的脚本!");
                     CommandTool.commandRtn2("/data/infa_mysqlload/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                  } else if ("SYBASE".equals(targetdbType)) {
                     CommandTool.command("chmod -R 777 /data/infa_sybase/");
                     CommandTool.commandRtn2("/data/infa_sybase/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                  }

                  String completeStatus = "0";
                  if (runId >= 0) {
                     completeStatus = DmpDesensitizationServiceImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
                  }

                  if ("1".equals(completeStatus)) {
                     System.out.println("表" + desensitizationTable.getTablename() + ",执行完成,通过阻塞方法！");
                     SessionBean sessionBean = DmpDesensitizationServiceImpl.this.getLogForTaskMapping(executeParam.getFolderName(), executeParam.getInfoProperty(), executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
                     System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
                     if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                        status = "1";
                     } else if ("FAILED".equals(sessionBean.getStatus())) {
                        status = "2";
                     } else if ("STOPPED".equals(sessionBean.getStatus())) {
                        status = "3";
                     } else {
                        status = "4";
                     }

                     System.out.println("执行更新监控表开始！tableName=" + desensitizationTable.getTablename());
                     DmpDesensitizationServiceImpl.this.updateMonitor(desensitizationTable.getTablename(), executeParam.getTableMap(), status, runId);
                  }

                  LogoutWebService.returnStatus(sessionId, executeParam.getInfoProperty());
               } catch (Exception e) {
                  e.printStackTrace();
               } finally {
                  countDownLatch.countDown();
               }

            }
         });
      }

      try {
         System.out.println(">>>>>>>>>>>>>>>当前活动线程数：" + this.taskExecutor.getActiveCount());
         System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + countDownLatch.getCount());
         countDownLatch.await();
         this.desensitizationtaskDao.getSession().getTransaction().begin();
         desensitizationTask.setTaskstatus("0");
         this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
         this.desensitizationtaskDao.getSession().getTransaction().commit();
         System.out.println(">>>>>>>>>>>>>>>任务已全部执行完成！同步表信息开始！");
         this.synTableParam(tableList, executeParam);
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public void createTeradataExport(List<DesensitizationTablecolumn> colLst, DesensitizationTable desensitizationTable, ExecuteParam executeParam, TCoreDatasystem tCoreDatasystemSource) {
      List<String> colNameLst = new ArrayList();
      Integer totalLen = 0;

      for(int j = 0; j < colLst.size(); ++j) {
         totalLen = totalLen + 3;
         String colName = ((DesensitizationTablecolumn)colLst.get(j)).getColumnname();
         String colType = ((DesensitizationTablecolumn)colLst.get(j)).getColumntype();
         String colLength = ((DesensitizationTablecolumn)colLst.get(j)).getColumnlength();
         String colScale = ((DesensitizationTablecolumn)colLst.get(j)).getColumnscale() == null ? "" : ((DesensitizationTablecolumn)colLst.get(j)).getColumnscale();
         colName = TeradataTool.teradataTypetoVarchar(colName, colType, colLength);
         String realColLength = TeradataTool.teradataTypeLength(colType, colLength, colScale);
         if (StringUtils.isNotBlank(realColLength)) {
            totalLen = totalLen + Integer.valueOf(realColLength);
         }

         colNameLst.add(colName);
      }

      String colNamesStr = StringUtils.join(colNameLst.toArray(), "||'|'||");
      colNamesStr = "(cast(" + colNamesStr + " as char(" + totalLen + ")))";
      Map<String, String> paramMap = new HashMap();
      paramMap.put("schema", executeParam.getSourceSchemaName());
      paramMap.put("tablename", desensitizationTable.getTablename());
      paramMap.put("colNamesStr", colNamesStr);
      paramMap.put("teradataServersIp", tCoreDatasystemSource.getDbip());
      paramMap.put("teradataServersUser", tCoreDatasystemSource.getUsername());
      paramMap.put("teradataServerspwd", "1".equals(tCoreDatasystemSource.getFlag()) ? AesTool.decrypt(tCoreDatasystemSource.getPassword(), "ghca") : tCoreDatasystemSource.getPassword());
      paramMap.put("taskname", executeParam.getTaskNameReal());
      TeradataTool.createTerdataExportScript(paramMap);
   }

   public void createTeradataLoad(List<DesensitizationTablecolumn> colLst, TCoreDatasystem tCoreDatasystemTarget, DesensitizationTable desensitizationTable, ExecuteParam executeParam) {
      List<String> nameList = new ArrayList();
      List<String> lengthList = new ArrayList();

      for(DesensitizationTablecolumn sourceTableCol : colLst) {
         nameList.add(sourceTableCol.getColumnname());
         lengthList.add(sourceTableCol.getColumnlength());
      }

      StringBuffer definesb = new StringBuffer();

      for(int i = 0; i < nameList.size(); ++i) {
         definesb.append((String)nameList.get(i) + "(varchar(" + (String)lengthList.get(i) + ")),");
      }

      Map<String, String> paramMapload = new HashMap();
      paramMapload.put("ip", tCoreDatasystemTarget.getDbip());
      paramMapload.put("port", tCoreDatasystemTarget.getDbport());
      paramMapload.put("user", tCoreDatasystemTarget.getUsername());
      paramMapload.put("pwd", "1".equals(tCoreDatasystemTarget.getFlag()) ? AesTool.decrypt(tCoreDatasystemTarget.getPassword(), "ghca") : tCoreDatasystemTarget.getPassword());
      paramMapload.put("schema", executeParam.getTargetSchemaName());
      paramMapload.put("table", desensitizationTable.getTablename());
      paramMapload.put("path", TeradataTool.STR_PIPEFILE_TAR_PATH + executeParam.getTaskNameReal() + "/");
      paramMapload.put("define", definesb.substring(0, definesb.length() - 1));
      paramMapload.put("in_type", "1");
      String dbcode = tCoreDatasystemTarget.getDbtype();
      String servername = tCoreDatasystemTarget.getDbservername();
      String url = EdbType.getUrlByEdbcode(dbcode, tCoreDatasystemTarget.getDbip(), tCoreDatasystemTarget.getDbport(), servername, tCoreDatasystemTarget.getPagecode());
      String driver = EdbType.getEdbTypeByDbcode(dbcode).getDbdriver();
      paramMapload.put("driver", driver);
      paramMapload.put("url", url);
      paramMapload.put("create_sql", desensitizationTable.getCreate_sql());
      TeradataLoadTableTool.executeLoadTable(paramMapload);
   }

   public String delparentheses(String type) {
      if (type.indexOf("(") == -1) {
         return type;
      } else {
         type = type.indexOf("(") == -1 ? type : type.substring(0, type.indexOf("(")) + type.substring(type.indexOf(")") + 1, type.length());
         return this.delparentheses(type);
      }
   }

   public String getDataCount(String dbType, TCoreDatasystem dataSystem, DesensitizationTable desensitizationTable, String schemaName) {
      String url = "";
      String driver = EdbType.getEdbTypeByDbcode(dbType).getDbdriver();
      switch (dbType) {
         case "INFORMIX":
            url = EdbType.getUrlByEdbcode(dbType, dataSystem.getDbip(), dataSystem.getDbport(), dataSystem.getDbservername(), dataSystem.getServername());
            break;
         case "AS400":
            url = EdbType.getUrlByEdbcode(dbType, dataSystem.getDbip(), dataSystem.getDbservername(), dataSystem.getServername());
            break;
         default:
            url = EdbType.getUrlByEdbcode(dbType, dataSystem.getDbip(), dataSystem.getDbport(), dataSystem.getDbservername());
      }

      long count = 0L;

      try {
         Connection connection = JdbcTool.getConnection(driver, url, dataSystem.getUsername(), "1".equals(dataSystem.getFlag()) ? AesTool.decrypt(dataSystem.getPassword(), "ghca") : dataSystem.getPassword());
         Statement statement = connection.createStatement();
         String sqlFilter = desensitizationTable.getSqlFilter();
         String sql = "";
         if (!"".equals(sqlFilter) && sqlFilter != null) {
            sql = "select count(*) from " + schemaName + "." + desensitizationTable.getTablename() + " where " + sqlFilter;
         } else {
            sql = "select count(*) from " + schemaName + "." + desensitizationTable.getTablename();
         }

         System.out.println("" + sql);

         for(ResultSet rs = statement.executeQuery(sql); rs.next(); count = rs.getLong(1)) {
         }

         statement.close();
         connection.close();
      } catch (SQLException e) {
         e.printStackTrace();
      }

      return count + "";
   }

   @Async
   public void executeDB_batchread_FILE_pwc_FILE(final ExecuteParam executeParam) throws Exception {
      System.out.println(">>>>>>>>>>>>>>>>>DB_batchread_FILE_pwc_FILE<<<<<<<<<<<<<<<<<<");
      List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
      final TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(executeParam.getDataSourceId());
      final Runtime rn = Runtime.getRuntime();
      final Map<String, List<DesensitizationTablecolumn>> map = new HashMap();
      final CountDownLatch countDownLatch = new CountDownLatch(tableList.size());

      for(DesensitizationTable desensitizationTable : tableList) {
         List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
         List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
         map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
      }

      final Desensitizationtask desensitizationTask = (Desensitizationtask)this.desensitizationtaskDao.get(executeParam.getTaskid());
      desensitizationTask.setTaskstatus("1");
      this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
      this.desensitizationtaskDao.getSession().getTransaction().commit();

      for(final DesensitizationTable desensitizationTable : tableList) {
         this.taskExecutor.execute(new Runnable() {
            public void run() {
               String sessionId = "";
               String status = "4";
               String workflowName = "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename();

               try {
                  Properties props = new Properties();

                  try {
                     props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                  } catch (IOException e) {
                     e.printStackTrace();
                  }

                  if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
                     System.out.println("---进入启动预计运行时间方法！");
                     String dataCount = "";
                     dataCount = DmpDesensitizationServiceImpl.this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
                     System.out.println("数据源表" + desensitizationTable.getTablename() + "总行数：" + dataCount);
                     RedisClient redisClient = new RedisClient();
                     Jedis jedis = redisClient.getJedis();
                     jedis.set("dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename(), dataCount);
                     System.out.println("预计运行时间，key=dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename() + "，dataCount=" + dataCount);
                     jedis.close();
                  }

                  DmpDesensitizationServiceImpl.this.updateMonitorRunStatus(desensitizationTable.getTablename(), executeParam.getTableMap());
                  System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
                  sessionId = LoginWebService.returnStatus(executeParam.getInfoProperty());
                  System.out.println("创建执行脚本开始！tableName=" + desensitizationTable.getTablename());
                  DmpDesensitizationServiceImpl.this.createScriptFiletoSource(executeParam, desensitizationTable, executeParam.getSourceDataSystem().getDbtype(), tCoreDatasystemSource, (List)map.get(desensitizationTable.getTablename()), rn);
                  System.out.println("调用启动工作流方法开始！tableName=" + desensitizationTable.getTablename());
                  int runId = DmpDesensitizationServiceImpl.this.startWorkFlowEx(workflowName, executeParam.getInfoProperty(), executeParam.getFolderName(), sessionId);
                  String dbType = executeParam.getSourceDataSystem().getDbtype();
                  System.out.println("启动脚本开始！dbType=" + dbType + ",tableName=" + desensitizationTable.getTablename());
                  if (!"SYBASE_IQ".equals(dbType) && !"MSSQLSERVER".equals(dbType)) {
                     if ("MYSQL".equals(dbType)) {
                        System.out.println("执行MySql源的脚本：/data/infa_mysqlload/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                        CommandTool.commandRtn2("/data/infa_mysqlload/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                     } else if ("SYBASE".equals(dbType)) {
                        CommandTool.commandRtn2("/data/infa_sybase/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                        System.out.println("SYBASE执行源的脚本:完成");
                     } else if ("TERADATA".equals(dbType)) {
                        System.out.println("执行源的脚本：/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                        CommandTool.commandRtn("/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                        System.out.println("执行源的脚本:完成");
                     }
                  }

                  String completeStatus = "0";
                  if (runId >= 0) {
                     completeStatus = DmpDesensitizationServiceImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
                  }

                  if ("1".equals(completeStatus)) {
                     System.out.println("表" + desensitizationTable.getTablename() + ",执行完成,通过阻塞方法！");
                     SessionBean sessionBean = DmpDesensitizationServiceImpl.this.getLogForTaskMapping(executeParam.getFolderName(), executeParam.getInfoProperty(), executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
                     System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
                     if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                        status = "1";
                     } else if ("FAILED".equals(sessionBean.getStatus())) {
                        status = "2";
                     } else if ("STOPPED".equals(sessionBean.getStatus())) {
                        status = "3";
                     } else {
                        status = "4";
                     }

                     System.out.println("执行更新监控表开始！tableName=" + desensitizationTable.getTablename());
                     DmpDesensitizationServiceImpl.this.updateMonitor(desensitizationTable.getTablename(), executeParam.getTableMap(), status, runId);
                  }

                  LogoutWebService.returnStatus(sessionId, executeParam.getInfoProperty());
               } catch (Exception e) {
                  e.printStackTrace();
               } finally {
                  countDownLatch.countDown();
               }

            }
         });
      }

      try {
         System.out.println(">>>>>>>>>>>>>>>当前活动线程数：" + this.taskExecutor.getActiveCount());
         System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + countDownLatch.getCount());
         countDownLatch.await();
         this.desensitizationtaskDao.getSession().getTransaction().begin();
         desensitizationTask.setTaskstatus("0");
         this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
         this.desensitizationtaskDao.getSession().getTransaction().commit();
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @Async
   public void executeDB_batchread_FILE_pwc_DB(final ExecuteParam executeParam) throws Exception {
      System.out.println(">>>>>>>>>>>>>>>>>executeDB_batchread_FILE_pwc_DB<<<<<<<<<<<<<<<<<<");
      List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
      final TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(executeParam.getDataSourceId());
      final Runtime rn = Runtime.getRuntime();
      final Map<String, List<DesensitizationTablecolumn>> map = new HashMap();
      final CountDownLatch countDownLatch = new CountDownLatch(tableList.size());

      for(DesensitizationTable desensitizationTable : tableList) {
         List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
         List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
         map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
      }

      final Desensitizationtask desensitizationTask = (Desensitizationtask)this.desensitizationtaskDao.get(executeParam.getTaskid());
      desensitizationTask.setTaskstatus("1");
      this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
      this.desensitizationtaskDao.getSession().getTransaction().commit();

      for(final DesensitizationTable desensitizationTable : tableList) {
         this.taskExecutor.execute(new Runnable() {
            public void run() {
               String sessionId = "";
               String status = "4";
               String workflowName = "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename();

               try {
                  Properties props = new Properties();

                  try {
                     props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                  } catch (IOException e) {
                     e.printStackTrace();
                  }

                  if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
                     System.out.println("---进入启动预计运行时间方法！");
                     String dataCount = "";
                     dataCount = DmpDesensitizationServiceImpl.this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
                     System.out.println("数据源表" + desensitizationTable.getTablename() + "总行数：" + dataCount);
                     RedisClient redisClient = new RedisClient();
                     Jedis jedis = redisClient.getJedis();
                     jedis.set("dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename(), dataCount);
                     System.out.println("预计运行时间，key=dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename() + "，dataCount=" + dataCount);
                     jedis.close();
                  }

                  DmpDesensitizationServiceImpl.this.updateMonitorRunStatus(desensitizationTable.getTablename(), executeParam.getTableMap());
                  System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
                  sessionId = LoginWebService.returnStatus(executeParam.getInfoProperty());
                  System.out.println("创建执行脚本开始！tableName=" + desensitizationTable.getTablename());
                  DmpDesensitizationServiceImpl.this.createScriptFiletoSource(executeParam, desensitizationTable, executeParam.getSourceDataSystem().getDbtype(), tCoreDatasystemSource, (List)map.get(desensitizationTable.getTablename()), rn);
                  System.out.println("调用启动工作流方法开始！tableName=" + desensitizationTable.getTablename());
                  int runId = DmpDesensitizationServiceImpl.this.startWorkFlowEx(workflowName, executeParam.getInfoProperty(), executeParam.getFolderName(), sessionId);
                  String dbType = executeParam.getTargetDataSystem().getDbtype();
                  System.out.println("启动脚本开始！dbType=" + dbType + ",tableName=" + desensitizationTable.getTablename());
                  if (!"SYBASE_IQ".equals(dbType)) {
                     if ("MSSQLSERVER".equals(dbType)) {
                        CommandTool.commandRtn("/data/infa_sqlserver/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                        System.out.println("SQLSERVER执行源的脚本:完成");
                     } else if ("SYBASE".equals(dbType)) {
                        CommandTool.commandRtn2("/data/infa_sybase/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                        System.out.println("SYBASE执行源的脚本:完成");
                     } else if ("MYSQL".equals(dbType)) {
                        System.out.println("执行MySql源的脚本：/data/infa_mysqlload/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                        CommandTool.commandRtn2("/data/infa_mysqlload/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                     } else if ("TERADATA".equals(dbType)) {
                        System.out.println("执行源的脚本：/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                        CommandTool.commandRtn("/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                        System.out.println("执行源的脚本:完成");
                     }
                  }

                  String completeStatus = "0";
                  if (runId >= 0) {
                     completeStatus = DmpDesensitizationServiceImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
                  }

                  if ("1".equals(completeStatus)) {
                     System.out.println("表" + desensitizationTable.getTablename() + ",执行完成,通过阻塞方法！");
                     SessionBean sessionBean = DmpDesensitizationServiceImpl.this.getLogForTaskMapping(executeParam.getFolderName(), executeParam.getInfoProperty(), executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
                     System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
                     if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                        status = "1";
                     } else if ("FAILED".equals(sessionBean.getStatus())) {
                        status = "2";
                     } else if ("STOPPED".equals(sessionBean.getStatus())) {
                        status = "3";
                     } else {
                        status = "4";
                     }

                     System.out.println("执行更新监控表开始！tableName=" + desensitizationTable.getTablename());
                     DmpDesensitizationServiceImpl.this.updateMonitor(desensitizationTable.getTablename(), executeParam.getTableMap(), status, runId);
                  }

                  LogoutWebService.returnStatus(sessionId, executeParam.getInfoProperty());
               } catch (Exception e) {
                  e.printStackTrace();
               } finally {
                  countDownLatch.countDown();
               }

            }
         });
      }

      try {
         System.out.println(">>>>>>>>>>>>>>>当前活动线程数：" + this.taskExecutor.getActiveCount());
         System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + countDownLatch.getCount());
         countDownLatch.await();
         this.desensitizationtaskDao.getSession().getTransaction().begin();
         desensitizationTask.setTaskstatus("0");
         this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
         this.desensitizationtaskDao.getSession().getTransaction().commit();
         System.out.println(">>>>>>>>>>>>>>>任务已全部执行完成！同步表信息开始！");
         this.synTableParam(tableList, executeParam);
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public long getTableNumByAll(String sql) {
      return this.desensitizationtaskDao.getTableNumByAll(sql);
   }

   @Async
   public void executeTask(final ExecuteParam executeParam) throws Exception {
      System.out.println(">>>>>>>>>>>>>>>>>执行开始<<<<<<<<<<<<<<<<<<");
      List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
      final Desensitizationsource desensitizationsource = (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", executeParam.getTaskid())});
      final Desensitizationtarget desensitizationtarget = (Desensitizationtarget)this.desensitizationtargetDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", executeParam.getTaskid())});
      executeParam.setSourcetype(desensitizationsource.getExecution_type());
      executeParam.setTargettype(desensitizationtarget.getExecution_type());
      final TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(executeParam.getDataTargetId() != null ? executeParam.getDataTargetId() : "ghca");
      final TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(executeParam.getDataSourceId() != null ? executeParam.getDataSourceId() : "ghca");
      final Runtime rn = Runtime.getRuntime();
      final Map<String, List<DesensitizationTablecolumn>> map = new HashMap();
      final CountDownLatch countDownLatch = new CountDownLatch(tableList.size());

      for(DesensitizationTable desensitizationTable : tableList) {
         List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
         List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
         map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
      }

      final Desensitizationtask desensitizationTask = (Desensitizationtask)this.desensitizationtaskDao.get(executeParam.getTaskid());
      this.updateTask_taskstatus(desensitizationTask.getId(), "1");

      for(final DesensitizationTable desensitizationTable : tableList) {
         this.taskExecutor.execute(new Runnable() {
            public void run() {
               String sessionId = "";
               String status = "4";
               String workflowName = "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename();

               try {
                  Properties props = new Properties();

                  try {
                     props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                  } catch (IOException e) {
                     e.printStackTrace();
                  }

                  if ("startup".equals(props.getProperty("Forecast_Run_Time")) && tCoreDatasystemSource != null && !tCoreDatasystemSource.getFlag().equals("2")) {
                     System.out.println("---进入启动预计运行时间方法！");
                     String dataCount = "";
                     dataCount = DmpDesensitizationServiceImpl.this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
                     System.out.println("数据源表" + desensitizationTable.getTablename() + "总行数：" + dataCount);
                     RedisClient redisClient = new RedisClient();
                     Jedis jedis = redisClient.getJedis();
                     jedis.set("dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename(), dataCount);
                     System.out.println("预计运行时间，key=dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename() + "，dataCount=" + dataCount);
                     jedis.close();
                  }

                  DmpDesensitizationServiceImpl.this.updateMonitorRunStatus(desensitizationTable.getTablename(), executeParam.getTableMap());
                  System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
                  sessionId = LoginWebService.returnStatus(executeParam.getInfoProperty());
                  System.out.println("创建执行脚本开始！tableName=" + desensitizationTable.getTablename());
                  DmpDesensitizationServiceImpl.this.createScriptFiletoSource(executeParam, desensitizationTable, executeParam.getSourceDataSystem().getDbtype(), tCoreDatasystemSource, (List)map.get(desensitizationTable.getTablename()), rn);
                  DmpDesensitizationServiceImpl.this.createScriptFiletotarget(executeParam, desensitizationTable, executeParam.getTargetDataSystem().getDbtype(), tCoreDatasystemTarget, (List)map.get(desensitizationTable.getTablename()), rn);
                  String targetdbType = executeParam.getTargetDataSystem().getDbtype();
                  String sourcedbType = executeParam.getSourceDataSystem().getDbtype();
                  System.out.println("启动脚本开始！dbType=" + targetdbType + ",tableName=" + desensitizationTable.getTablename());
                  System.out.println("调用启动工作流方法开始！tableName=" + desensitizationTable.getTablename());
                  int runId = DmpDesensitizationServiceImpl.this.startWorkFlowEx(workflowName, executeParam.getInfoProperty(), executeParam.getFolderName(), sessionId);
                  if (!"normal".equals(desensitizationsource.getExecution_type())) {
                     switch (sourcedbType) {
                        case "TERADATA":
                           System.out.println("执行源的脚本：/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                           CommandTool.commandRtn2("/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                           System.out.println("执行源的脚本:完成");
                           break;
                        case "MSSQLSERVER":
                           CommandTool.commandRtn2("/data/infa_sqlserver/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                           System.out.println("SQLSERVER执行源的脚本:完成");
                     }
                  }

                  if (!"normal".equals(desensitizationtarget.getExecution_type())) {
                     switch (targetdbType) {
                        case "TERADATA":
                           System.out.println("执行目标的脚本");
                           CommandTool.commandRtn2("/data/infa_teradata/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                           System.out.println("执行目标的脚本:完成");
                           break;
                        case "MSSQLSERVER":
                           CommandTool.command("chmod -R 777 /data/infa_sqlserver/");
                           if (!"normal".equals(desensitizationsource.getExecution_type()) && sourcedbType.equals("HIVE")) {
                              System.out.println("执行源的脚本：/data/hive/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                              TCoreConfig tcoreConfig = (TCoreConfig)DmpDesensitizationServiceImpl.this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", executeParam.getDataSourceId())});
                              if (tcoreConfig != null) {
                                 String filepath = tcoreConfig.getFileDir();
                                 String delimiter = tcoreConfig.getSourcedelimiter();
                                 String charset = tcoreConfig.getCodePage();
                                 if (filepath == null || filepath.equals("") || delimiter == null || delimiter.equals("") || charset == null || charset.equals("")) {
                                    filepath = XmlTool.getFileValue(sourcedbType + "/db-fileDir");
                                    delimiter = XmlTool.getFileValue(sourcedbType + "/db-sourcedelimiter");
                                    charset = XmlTool.getFileValue(sourcedbType + "/db-codePage");
                                 }

                                 DmpDesensitizationServiceImpl.this.iskeberos(tCoreDatasystemSource);
                                 Connection conn = JdbcTool.getConnection(tCoreDatasystemSource);
                                 PipeTool pipe = new PipeTool(conn, executeParam.getSourceSchemaName() + "." + desensitizationTable.getTablename(), filepath + "/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".pipe", delimiter, charset);
                                 pipe.writeFile();
                                 System.out.println("HIVE执行源的脚本:完成");
                              }
                           }

                           String completeStatus = DmpDesensitizationServiceImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
                           if ("1".equals(completeStatus)) {
                              CommandTool.commandRtn2("/data/infa_sqlserver/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                           }

                           System.out.println("SQLSERVER执行目标的脚本:完成");
                           break;
                        case "SYBASE_IQ":
                           CommandTool.commandRtn2("/data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh /data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".pipe");
                           break;
                        case "MYSQL":
                           System.out.println("执行目标的脚本");
                           CommandTool.commandRtn2("/data/infa_mysqlload/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                           System.out.println("执行目标的脚本:完成");
                     }
                  }

                  if (sourcedbType.equals("HIVE") && !targetdbType.equals("MSSQLSERVER")) {
                     System.out.println("执行源的脚本：/data/hive/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                     TCoreConfig tcoreConfig = (TCoreConfig)DmpDesensitizationServiceImpl.this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", executeParam.getDataSourceId())});
                     if (tcoreConfig != null) {
                        String filepath = tcoreConfig.getFileDir();
                        String delimiter = tcoreConfig.getSourcedelimiter();
                        String charset = tcoreConfig.getCodePage();
                        if (filepath == null || filepath.equals("") || delimiter == null || delimiter.equals("") || charset == null || charset.equals("")) {
                           filepath = XmlTool.getFileValue(sourcedbType + "/db-fileDir");
                           delimiter = XmlTool.getFileValue(sourcedbType + "/db-sourcedelimiter");
                           charset = XmlTool.getFileValue(sourcedbType + "/db-codePage");
                        }

                        DmpDesensitizationServiceImpl.this.iskeberos(tCoreDatasystemSource);
                        Connection conn = JdbcTool.getConnection(tCoreDatasystemSource);
                        PipeTool pipe = new PipeTool(conn, executeParam.getSourceSchemaName() + "." + desensitizationTable.getTablename(), filepath + "/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".pipe", delimiter, charset);
                        pipe.writeFile();
                        System.out.println("HIVE执行源的脚本:完成");
                     }
                  }

                  String completeStatus = "0";
                  if (runId >= 0) {
                     completeStatus = DmpDesensitizationServiceImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
                  }

                  if ("1".equals(completeStatus)) {
                     System.out.println("表" + desensitizationTable.getTablename() + ",执行完成,通过阻塞方法！");
                     SessionBean sessionBean = DmpDesensitizationServiceImpl.this.getLogForTaskMapping(executeParam.getFolderName(), executeParam.getInfoProperty(), executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
                     System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
                     if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                        status = "1";
                     } else if ("FAILED".equals(sessionBean.getStatus())) {
                        status = "2";
                     } else if ("STOPPED".equals(sessionBean.getStatus())) {
                        status = "3";
                     } else {
                        status = "4";
                     }

                     System.out.println("执行更新监控表开始！tableName=" + desensitizationTable.getTablename());
                     DmpDesensitizationServiceImpl.this.updateMonitor(desensitizationTable.getTablename(), executeParam.getTableMap(), status, runId);
                  }

                  LogoutWebService.returnStatus(sessionId, executeParam.getInfoProperty());
               } catch (Exception e) {
                  e.printStackTrace();
               } finally {
                  countDownLatch.countDown();
               }

            }
         });
      }

      try {
         System.out.println(">>>>>>>>>>>>>>>当前活动线程数：" + this.taskExecutor.getActiveCount());
         System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + countDownLatch.getCount());
         countDownLatch.await();
         this.updateTask_taskstatus(desensitizationTask.getId(), "0");
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public boolean generate_xml(Map map) throws Exception {
      Map<String, String> mapparam = new HashMap();
      InfoProperty infoProperty = this.getInfoProperty();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String codepage = (String)map.get("codepage");
      String folder = (String)map.get("folder");
      String cb_title = (String)map.get("cb_title");
      String fix = (String)map.get("fix");
      String stamp = "s" + (String)map.get("stamp");
      String limit = (String)map.get("limit");
      String separate = (String)map.get("separate");
      String xml_folder_up_path = props.getProperty("file_up_path");
      String xml_folder_down_path = props.getProperty("file_down_path");
      String xml_file_path = props.getProperty("file_up_path") + stamp + ".xml";
      List<DesensitizationTablecolumn> colum = (List)map.get("colum");
      Map<String, String> data_rule = this.getDataRuleMap();
      String mappletDir = props.getProperty("mappletDir");
      mapparam.put("folderName", folder);
      mapparam.put("execution_type_s", "FILE");
      mapparam.put("execution_type_t", "FILE");
      mapparam.put("domainName", infoProperty.getDomainname());
      mapparam.put("mappletDir", mappletDir);
      mapparam.put("repository", infoProperty.getRepository());
      mapparam.put("xmlLocation", xml_file_path);
      mapparam.put("serverName", infoProperty.getInteservicename());
      mapparam.put("target_type", "FILE");
      mapparam.put("source_type", "FILE");
      mapparam.put("isrecover", "0");
      mapparam.put("hdfsDir", props.getProperty("hdfs_dir"));
      Config pwc_config = this.pwc_config(mapparam);
      List<Info> infoList = new ArrayList();
      SourceInfo pwc_sourceInfo = new SourceInfo();
      TargetInfo pwc_targetInfo = new TargetInfo();
      List<ColumnInfo> sourcecolumnInfoList = new ArrayList();
      List<ColumnInfo> targetcolumnInfoList = new ArrayList();

      for(DesensitizationTablecolumn desensitizationTablecolumn : colum) {
         ColumnInfo pwc_columnInfo_source = new ColumnInfo();
         pwc_columnInfo_source.setColumnName(desensitizationTablecolumn.getColumnname());
         pwc_columnInfo_source.setDataType("string".toUpperCase());
         pwc_columnInfo_source.setKeyType(0);
         pwc_columnInfo_source.setMaskingRule((String)data_rule.get(desensitizationTablecolumn.getRuleid()));
         pwc_columnInfo_source.setNullable(0);
         pwc_columnInfo_source.setQualifierType("string".toLowerCase());
         pwc_columnInfo_source.setScale("");
         pwc_columnInfo_source.setPrecision(desensitizationTablecolumn.getColumnlength());
         sourcecolumnInfoList.add(pwc_columnInfo_source);
         targetcolumnInfoList.add(pwc_columnInfo_source);
      }

      pwc_sourceInfo.setColumnInfoList(sourcecolumnInfoList);
      pwc_sourceInfo.setConnectName("");
      pwc_sourceInfo.setDataBaseType(DataBaseType.FLATFILE);
      FlatFile sourceflatFile = new FlatFile();
      sourceflatFile.setCodePage(this.pageCode(codepage));
      sourceflatFile.setCommand("");
      sourceflatFile.setDelimiter(separate);
      sourceflatFile.setFilename(stamp + "." + fix);
      sourceflatFile.setFileType(0);
      sourceflatFile.setFileDir(xml_folder_up_path);
      sourceflatFile.setQuoteCharacter(Integer.parseInt(limit));
      sourceflatFile.setSkipRows("".equals(cb_title) ? 0 : 1);
      pwc_sourceInfo.setFlatFile(sourceflatFile);
      pwc_sourceInfo.setName(stamp);
      pwc_sourceInfo.setSchema("");
      pwc_sourceInfo.setSqlFilter("");
      pwc_sourceInfo.setSqlQuery("");
      pwc_targetInfo.setConnectName("");
      pwc_targetInfo.setDataBaseType(DataBaseType.FLATFILE);
      FlatFile targetflatFile = new FlatFile();
      targetflatFile.setCodePage(this.pageCode(codepage));
      targetflatFile.setCommand("");
      targetflatFile.setDelimiter(separate);
      targetflatFile.setFilename(stamp + "." + fix);
      targetflatFile.setFileType(0);
      targetflatFile.setFileDir(xml_folder_down_path);
      sourceflatFile.setQuoteCharacter(Integer.parseInt(limit));
      sourceflatFile.setSkipRows("".equals(cb_title) ? 0 : 1);
      pwc_targetInfo.setFlatFile(targetflatFile);
      pwc_targetInfo.setName(stamp);
      pwc_targetInfo.setSchema("");
      pwc_targetInfo.setIsTruncate(0);
      pwc_targetInfo.setWriteType(0);
      pwc_targetInfo.setColumnInfoList(targetcolumnInfoList);
      Info info = this.pwc_Info(pwc_sourceInfo, pwc_targetInfo, stamp);
      infoList.add(info);
      int pwc_state = PowerXml.generatePowerXml(infoList, pwc_config);
      String con_file = DmpDesensitizationServiceImpl.class.getResource("/").getPath().replaceAll("%20", " ") + "infofile" + File.separator + "con_import.xml";
      String foldername = pwc_config.getFolderName();
      String repository = infoProperty.getRepository();
      this.updateImportFile(con_file, foldername, repository);
      if (pwc_state != 1) {
         return false;
      } else {
         String importlog = InfoExecUtil.executImport(infoProperty.getPmrepexepath(), xml_file_path, con_file, infoProperty.getXmldir() + File.separator + "log.txt");
         if (!importlog.contains("已成功完成") && !importlog.contains("successfully")) {
            return false;
         } else {
            String sessionId = LoginWebService.returnStatus(infoProperty);
            int runId = this.startWorkFlowEx("wf_" + stamp, infoProperty, foldername, sessionId);
            String completeStatus = "0";
            if (runId >= 0) {
               completeStatus = this.workflowTaskCompleteMonitor(infoProperty, foldername, "wf_" + stamp, sessionId);
            }

            if ("1".equals(completeStatus)) {
               System.out.println("执行完成,通过阻塞方法！");
               SessionBean sessionBean = this.getLogForTaskMapping(foldername, infoProperty, stamp, sessionId);
               System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
               return "SUCCEEDED".equals(sessionBean.getStatus());
            } else {
               LogoutWebService.returnStatus(sessionId, infoProperty);
               return true;
            }
         }
      }
   }

   public List<Desensitizationtask> queryTaskByPage(PageInfo pageInfo) {
      List<Desensitizationtask> list = this.desensitizationtaskDao.queryByPageInfo(pageInfo, Order.desc("createtime"));
      return list;
   }

   public void iskeberos(TCoreDatasystem datasystem) {
      if ("HIVE".equals(datasystem.getDbtype()) && "on".equals(datasystem.getIskerberos())) {
         System.setProperty("java.security.krb5.conf", datasystem.getXmlpath() + "/krb5.conf");
      }

   }
}
