package com.chenyang.nse.bussiness.service.core.impl;

import com.alibaba.fastjson.JSONObject;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.core.EngineDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreConfigDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreEngineDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreSecretkeyDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationFileDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationMonitorDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationMonitorInfoDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationTablecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationsourceDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationtableDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationtargetDao;
import com.chenyang.nse.bussiness.dao.table.core.encryptionmasking.EncryptionMaskingDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructureDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructurespliterDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructurewidthDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingRuleinfoDao;
import com.chenyang.nse.bussiness.engine.ghca.webservice.DesensitizationEngineInterfaceImpl;
import com.chenyang.nse.bussiness.engine.ghca.webservice.DesensitizationEngineInterfaceImplService;
import com.chenyang.nse.bussiness.engine.ghca.webservice.EngineParameter;
import com.chenyang.nse.bussiness.engine.ghca.webservice.EngineResult;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.LoginWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.LogoutWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.MultiGetSessionStatisticsWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.MultiGetSessionTimeWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.SessionBean;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.SessionBeanDetail;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.StartWorkFlowWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.DIServiceInfo;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.DataIntegrationInterface;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.DataIntegrationService;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.ETaskRunMode;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.Fault;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.SessionHeader;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.TypeStartWorkflowExRequest;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.TypeStartWorkflowExResponse;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.WorkflowRequest;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.ModifyImportFile;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.DateUtil;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.InfoExecUtil;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.ToObjutil;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUser;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreConfig;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.batchmanage.BatchManage;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreSecretkey;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationFile;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationMonitor;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationMonitorInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationTable;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationTablecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationsource;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationtarget;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.EncryptionMasking;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TCoreFieldSensitiveMemory;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructure;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurespliter;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurewidth;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRuleinfo;
import com.chenyang.nse.bussiness.entity.redis.TCoreMaskingTaskTableInfo;
import com.chenyang.nse.bussiness.entity.vo.ProgressVO;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingType;
import com.chenyang.nse.bussiness.service.console.DesensitizationDataMappingService;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.DesensitizationMonitorService;
import com.chenyang.nse.bussiness.service.core.EncryptionMaskingService;
import com.chenyang.nse.bussiness.service.core.FileSystemService;
import com.chenyang.nse.bussiness.service.info.db.DatabaseTool;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import com.chenyang.nse.bussiness.thread.ExecuteParam;
import com.chenyang.nse.bussiness.tools.command.CommandTool;
import com.chenyang.nse.bussiness.tools.dmp.DmpDpGenerateTool;
import com.chenyang.nse.bussiness.tools.dmp.DmpDpTool;
import com.chenyang.nse.bussiness.tools.dmp.DmpGenerateTool;
import com.chenyang.nse.bussiness.tools.dmp.DmpTool;
import com.chenyang.nse.bussiness.tools.dmp.MultipleDmpDpGenerateTool;
import com.chenyang.nse.bussiness.tools.dmp.MultipleDmpDpTool;
import com.chenyang.nse.bussiness.tools.dmp.MultipleDmpGenerateTool;
import com.chenyang.nse.bussiness.tools.dmp.MultipleDmpTool;
import com.chenyang.nse.bussiness.tools.excel.ExcelTool;
import com.chenyang.nse.bussiness.tools.filesystem.JarUtilTool;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.io.PipeTool;
import com.chenyang.nse.bussiness.tools.io.SocketTool;
import com.chenyang.nse.bussiness.tools.jdbc.DB2LoadTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.GreenplumLoadTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.jdbc.MysqlLoadTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.RapidsdbLoadTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.SqlServerBcpTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.SybaseBcpTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.SybaseIQLoadTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.TeradataLoadTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.TeradataTool;
import com.chenyang.nse.bussiness.tools.net.FtpTool;
import com.chenyang.nse.bussiness.tools.net.SFTPUtil;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import com.chenyang.nse.bussiness.tools.xml.TxtTool;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import com.jcraft.jsch.SftpException;
import com.power.xml.entity.ColumnInfo;
import com.power.xml.entity.Config;
import com.power.xml.entity.FlatFile;
import com.power.xml.entity.Info;
import com.power.xml.entity.SourceInfo;
import com.power.xml.entity.TargetInfo;
import com.power.xml.entity.externalcall.DataBaseType;
import com.power.xml.external.PowerXml;
import com.chenyang.nse.bussiness.interfaces.IHiveRMI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.rmi.Naming;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import transdbf.transdbf;

@Service
@Repository
@EnableAsync
@Transactional
public class EncryptionMaskingImpl implements EncryptionMaskingService {
   private static final String Link_character = "_";
   private static final String FILE_PATHa = "/data/infa_file/";
   private boolean isteststate = false;
   private static final String LOG_TYPE = "新建脱敏任务+导入";
   private static final String ALL_BACK = "1";
   private static final String SINGLE_BACK = "0";
   String os = System.getProperty("os.name");
   @Autowired
   private TCoreEngineDao tCoreEngineDao;
   @Autowired
   private EngineDao engineDao;
   @Autowired
   private EncryptionMaskingDao encryptionmaskingDao;
   @Autowired
   private DesensitizationsourceDao desensitizationsourceDao;
   @Autowired
   private DesensitizationtargetDao desensitizationtargetDao;
   @Autowired
   private DesensitizationtableDao desensitizationTableDao;
   @Autowired
   private DesensitizationTablecolumnDao desensitizationTablecolumnDao;
   @Autowired
   private DesensitizationDataMappingService desensitizationdataMappingService;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   private TCoreMaskingRuleinfoDao tCoreMaskingRuleinfoDao;
   @Autowired
   private HttpServletRequest request;
   @Autowired
   private ToObjutil to;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private ThreadPoolTaskExecutor taskExecutor;
   @Autowired
   private OperationService operationService;
   @Autowired
   private DesensitizationMonitorDao desensitizationMonitorDao;
   @Autowired
   private DesensitizationMonitorInfoDao desensitizationMonitorInfoDao;
   @Autowired
   private DesensitizationFileDao desensitizationFileDao;
   @Autowired
   private TCoreFileStructureDao tCoreFileStructureDao;
   @Autowired
   private TCoreFileStructurespliterDao tCoreFileStructurespliterDao;
   @Autowired
   private TCoreFileStructurewidthDao tCoreFileStructurewidthDao;
   @Autowired
   private RedisService redisService;
   @Autowired
   @Lazy
   private DesensitizationMonitorService desensitizationMonitorService;
   @Autowired
   private TCoreConfigDao tCoreConfigDao;
   @Autowired
   private FileSystemService fileSystemService;
   @Autowired
   private TCoreSecretkeyDao tCoreSecretkeyDao;

   public List<EncryptionMasking> queryTask(String taskname, PageInfo pageInfo) {
      List<EncryptionMasking> list = this.encryptionmaskingDao.queryByPageInfo(pageInfo, Order.desc("updatatime"), new Criterion[]{Restrictions.like("taskname", "%" + taskname + "%"), Restrictions.eq("flag", "0")});
      return list;
   }

   public void saveEncryptionmaskingDao(String tasknamereal, EncryptionMasking encryptionmasking, LoginUser loginUser) {
      encryptionmasking = (EncryptionMasking)this.redisService.get(tasknamereal + "_" + encryptionmasking.getClass().getSimpleName());
      if (encryptionmasking != null) {
         encryptionmasking.setCreatetime(new Date());
         encryptionmasking.setUpdatatime(new Date());
         TBaseUser user = loginUser.getTsysUser();
         encryptionmasking.setUserid(user.getId());
         encryptionmasking.setUsername(user.getUsername());
         this.encryptionmaskingDao.save(encryptionmasking);
      }

   }

   public Desensitizationtarget saveDesensitizationtarget(String tasknamereal, String taskid, Desensitizationtarget desensitizationtarget, String state) {
      switch (state) {
         case "3":
            desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
            if (desensitizationtarget != null) {
               if ("1".equals(desensitizationtarget.getDmpimport())) {
                  desensitizationtarget.setExecution_type("oracledmp");
               }

               desensitizationtarget.setTaskid(taskid);
               this.desensitizationtargetDao.save(desensitizationtarget);
            }
            break;
         case "2":
            desensitizationtarget = (Desensitizationtarget)this.desensitizationtargetDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
      }

      return desensitizationtarget;
   }

   public Desensitizationsource saveDesensitizationsource(String tasknamereal, String taskid, Desensitizationsource desensitizationsource, String state) {
      switch (state) {
         case "3":
            desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
            if (desensitizationsource != null) {
               desensitizationsource.setTaskid(taskid);
               if ("1".equals(desensitizationsource.getIsdmpfile())) {
                  desensitizationsource.setExecution_type("oracledmp");
               }

               this.desensitizationsourceDao.save(desensitizationsource);
            }
            break;
         case "2":
            desensitizationsource = (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
      }

      return desensitizationsource;
   }

   public DesensitizationFile saveDesensitizationFile(String tasknamereal, String taskid, DesensitizationFile desensitizationFile, String state) {
      switch (state) {
         case "3":
            desensitizationFile = (DesensitizationFile)this.redisService.get(tasknamereal + "_" + desensitizationFile.getClass().getSimpleName());
            if (desensitizationFile != null) {
               desensitizationFile.setTaskid(taskid);
               this.desensitizationFileDao.save(desensitizationFile);
            }
            break;
         case "2":
            desensitizationFile = (DesensitizationFile)this.desensitizationFileDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
      }

      return desensitizationFile;
   }

   public void getDesensitizationTable(List<Map<String, String>> tCoreMaskingTaskTableList) {
      tCoreMaskingTaskTableList = (List)tCoreMaskingTaskTableList.stream().filter((s) -> "1".equals(s.get("status")) || "3".equals(s.get("status"))).collect(Collectors.toList());
   }

   public Map<String, String> EdataMappingType() {
      Map<String, String> map = new HashMap();

      for(EdataMappingType em : EdataMappingType.values()) {
         map.put(em.getName(), em.getFlag());
      }

      return map;
   }

   public Map<String, Object> saveDesensitizationTable(EncryptionMasking encryptionmasking, String taskid, List<DesensitizationTable> desensitizationTableList, Desensitizationsource desensitizationsource, Desensitizationtarget desensitizationtarget, List<Map<String, String>> tablelistmap, String state, DesensitizationFile desensitizationfile, Map<String, String> map_table_filterConditions) throws Exception {
      String tasknamereal = encryptionmasking.getTasknamereal();

      for(Map<String, String> map : tablelistmap) {
         String content = "{\"datasource\":{";
         FileOutputStream fileOutputStream = null;
         new Properties();
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String jarPath = props.get("jdbc_jar_path").toString();
         Map<String, Object> list = (Map)this.tCoreDatasystemDao.queryById(desensitizationsource.getDatasourceid()).get(0);
         String fileName = list.get("dbip") + "_" + list.get("dbport") + "_" + list.get("dbservername").toString().toUpperCase() + "_" + desensitizationsource.getDataschema().toUpperCase() + "." + ((String)map.get("tableName")).toUpperCase() + ".txt";
         content = content + "\"dbport\":\"" + list.get("dbport") + "\", ";
         content = content + "\"sysname\":\"" + list.get("sysname") + "\", ";
         content = content + "\"dbtype\":\"" + list.get("dbtype") + "\", ";
         content = content + "\"servername\":\"" + list.get("servername") + "\", ";
         content = content + "\"id\":\"" + list.get("id") + "\", ";
         content = content + "\"dbip\":\"" + list.get("dbip") + "\", ";
         content = content + "\"dbservername\":\"" + list.get("dbservername") + "\", ";
         content = content + "\"pagecode\":\"" + list.get("pagecode") + "\", ";
         content = content + "\"dblinkname\":\"" + list.get("dblinkname") + "\", ";
         content = content + "\"username\":\"" + list.get("username") + "\"}";
         content = content + ", \"schema\":\"" + desensitizationsource.getDataschema() + "\", \"table\":\"" + (String)map.get("tableName") + "\", \"column\":[";
         List<TCoreMaskingTaskTableInfo> tCoreMaskingTaskTableInfoList = (List)this.redisService.get(tasknamereal + "_" + "TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"));
         int flag = 0;
         if (tCoreMaskingTaskTableInfoList != null) {
            for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : tCoreMaskingTaskTableInfoList) {
               if (tCoreMaskingTaskTableInfo.getSecretkeyId() != null) {
                  content = content + "{\"columnName\":\"" + tCoreMaskingTaskTableInfo.getColumnName() + "\", ";
                  content = content + "\"regexRuleId\":\"" + tCoreMaskingTaskTableInfo.getRegexRuleId() + "\", ";
                  content = content + "\"regexRuleName\":\"" + tCoreMaskingTaskTableInfo.getRegexRuleName() + "\", ";
                  content = content + "\"secretkeyId\":\"" + tCoreMaskingTaskTableInfo.getSecretkeyId() + "\", ";
                  content = content + "\"secretkeyName\":\"" + tCoreMaskingTaskTableInfo.getSecretkeyName() + "\"}, ";
                  ++flag;
               }
            }

            content = content.substring(0, content.length() - 2);
         }

         content = content + "]}";
         if (flag > 0) {
            JarUtilTool.writeJarFile(jarPath, fileName, content.getBytes());
         }
      }

      return null;
   }

   private void synViewParam(Desensitizationsource desensitizationsource, Desensitizationtarget desensitizationtarget, String getDbtype_s, String t_tableName) throws Exception {
      Connection srcconn = this.dataSystemService.getConnectionByDataSystemId(desensitizationsource.getDatasourceid());
      Connection tarconn = this.dataSystemService.getConnectionByDataSystemId(desensitizationtarget.getDatasourceid());
      new ArrayList();
      Class c = Class.forName("com.chenyang.nse.bussiness.service.info.db." + getDbtype_s);
      DatabaseTool base = (DatabaseTool)c.newInstance();
      Map map = new HashMap();
      map.put("targetSchemaName", desensitizationtarget.getDataschema());
      map.put("sourceSchema", desensitizationsource.getDataschema());
      map.put("tableName", t_tableName);
      List<StringBuffer> listFunction = base.SynViewParam(srcconn, map);
      if (listFunction != null) {
         for(StringBuffer stringBuffer : listFunction) {
            JdbcTool.executeSql(tarconn, stringBuffer.toString());
         }
      }

      JdbcTool.closeConnection(srcconn);
      JdbcTool.closeConnection(tarconn);
   }

   private void synProcedureParam(Desensitizationsource desensitizationsource, Desensitizationtarget desensitizationtarget, String getDbtype_s, String t_tableName) throws Exception {
      Connection srcconn = this.dataSystemService.getConnectionByDataSystemId(desensitizationsource.getDatasourceid());
      Connection tarconn = this.dataSystemService.getConnectionByDataSystemId(desensitizationtarget.getDatasourceid());
      new ArrayList();
      Class c = Class.forName("com.chenyang.nse.bussiness.service.info.db." + getDbtype_s);
      DatabaseTool base = (DatabaseTool)c.newInstance();
      Map map = new HashMap();
      map.put("targetSchemaName", desensitizationtarget.getDataschema());
      map.put("sourceSchema", desensitizationsource.getDataschema());
      map.put("tableName", t_tableName);
      List<StringBuffer> listFunction = base.SynProcedureParam(srcconn, map);
      if (listFunction != null) {
         for(StringBuffer stringBuffer : listFunction) {
            JdbcTool.executeSql(tarconn, stringBuffer.toString());
         }
      }

      JdbcTool.closeConnection(srcconn);
      JdbcTool.closeConnection(tarconn);
   }

   private void synFunctionParam(Desensitizationsource desensitizationsource, Desensitizationtarget desensitizationtarget, String getDbtype_s, String t_tableName) throws Exception {
      Connection srcconn = this.dataSystemService.getConnectionByDataSystemId(desensitizationsource.getDatasourceid());
      Connection tarconn = this.dataSystemService.getConnectionByDataSystemId(desensitizationtarget.getDatasourceid());
      new ArrayList();
      Class c = Class.forName("com.chenyang.nse.bussiness.service.info.db." + getDbtype_s);
      DatabaseTool base = (DatabaseTool)c.newInstance();
      Map map = new HashMap();
      map.put("targetSchemaName", desensitizationtarget.getDataschema());
      map.put("sourceSchema", desensitizationsource.getDataschema());
      map.put("tableName", t_tableName);
      List<StringBuffer> listFunction = base.SynFunctionParam(srcconn, map);
      if (listFunction != null) {
         for(StringBuffer stringBuffer : listFunction) {
            JdbcTool.executeSql(tarconn, stringBuffer.toString());
         }
      }

      JdbcTool.closeConnection(srcconn);
      JdbcTool.closeConnection(tarconn);
   }

   private void synTriggersParam(Desensitizationsource desensitizationsource, Desensitizationtarget desensitizationtarget, String getDbtype_s, String t_tableName) throws Exception {
      Connection srcconn = this.dataSystemService.getConnectionByDataSystemId(desensitizationsource.getDatasourceid());
      Connection tarconn = this.dataSystemService.getConnectionByDataSystemId(desensitizationtarget.getDatasourceid());
      new ArrayList();
      Class c = Class.forName("com.chenyang.nse.bussiness.service.info.db." + getDbtype_s);
      DatabaseTool base = (DatabaseTool)c.newInstance();
      Map map = new HashMap();
      map.put("targetSchemaName", desensitizationtarget.getDataschema());
      map.put("sourceSchema", desensitizationsource.getDataschema());
      map.put("tableName", t_tableName);
      List<StringBuffer> listTriggers = base.SynTriggersParam(srcconn, map);
      if (listTriggers != null) {
         for(StringBuffer stringBuffer : listTriggers) {
            JdbcTool.executeSql(tarconn, stringBuffer.toString());
         }
      }

      JdbcTool.closeConnection(srcconn);
      JdbcTool.closeConnection(tarconn);
   }

   public ColumnInfo getPwc_columnInfo_source(String dbtype, TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo, String qualifierType, Map<String, String> data_rule, Map<String, String> data_s, Map<String, Map<String, String>> data_s_length, Config pwc_config) {
      Map map = new HashMap();
      ColumnInfo pwc_columnInfo_source = new ColumnInfo();
      map.put("tCoreMaskingTaskTableInfo", tCoreMaskingTaskTableInfo);
      map.put("data_by_source", data_s);
      map.put("data_source_length", data_s_length);
      map.put("data_rule", data_rule);
      map.put("qualifierType", qualifierType);
      map.put("pwc_config", pwc_config);

      try {
         Class c = Class.forName("com.chenyang.nse.bussiness.service.info.db." + dbtype);
         DatabaseTool base = (DatabaseTool)c.newInstance();
         pwc_columnInfo_source = base.getPwc_columnInfo_source(map);
      } catch (ClassNotFoundException e) {
         e.printStackTrace();
      } catch (InstantiationException e) {
         e.printStackTrace();
      } catch (IllegalAccessException e) {
         e.printStackTrace();
      }

      return pwc_columnInfo_source;
   }

   public ColumnInfo getPwc_columnInfo_target(String dbtype, boolean typeFlag, int type, TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo, String qualifierType, Map<String, String> data_rule, Map<String, Map<String, String>> data_t, Map<String, Map<String, String>> data_t_length, Config pwc_config, Map<String, String> data_s, Boolean issomedb, Boolean targetisfile, Map<String, Map<String, String>> data_t_x_length) {
      Map map = new HashMap();
      ColumnInfo pwc_columnInfo_target = new ColumnInfo();
      map.put("tCoreMaskingTaskTableInfo", tCoreMaskingTaskTableInfo);
      map.put("type", type);
      map.put("data_by_source", data_s);
      map.put("issomedb", issomedb);
      map.put("data_target_length", data_t_length);
      map.put("data_target", data_t);
      map.put("data_rule", data_rule);
      map.put("qualifierType", qualifierType);
      map.put("pwc_config", pwc_config);
      map.put("data_t_x_length", data_t_x_length);

      try {
         Class c = Class.forName("com.chenyang.nse.bussiness.service.info.db." + dbtype);
         DatabaseTool base = (DatabaseTool)c.newInstance();
         pwc_columnInfo_target = base.getPwc_columnInfo_target(map);
      } catch (ClassNotFoundException e) {
         e.printStackTrace();
      } catch (InstantiationException e) {
         e.printStackTrace();
      } catch (IllegalAccessException e) {
         e.printStackTrace();
      }

      return pwc_columnInfo_target;
   }

   public TCoreMaskingTaskTableInfo gettCoreMaskingTaskTableInfoByUpdate(int sortnum, boolean issomedb, boolean targetisfile, Map<String, String> maptarget, TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo) {
      tCoreMaskingTaskTableInfo.setSortnum(sortnum);
      tCoreMaskingTaskTableInfo.setTargetType(issomedb ? tCoreMaskingTaskTableInfo.getSourceType() : (String)maptarget.get("sourcefieldname"));
      tCoreMaskingTaskTableInfo.setTargetLength(!issomedb && !targetisfile ? (String)maptarget.get("targetlength") : tCoreMaskingTaskTableInfo.getColumnLength());
      tCoreMaskingTaskTableInfo.setTargetPrecision(!issomedb && !targetisfile ? (String)maptarget.get("targetdecimal") : tCoreMaskingTaskTableInfo.getColumnPrecision());
      tCoreMaskingTaskTableInfo.setLengthruletype((String)maptarget.get("flag"));
      tCoreMaskingTaskTableInfo.setIsnullable("");
      return tCoreMaskingTaskTableInfo;
   }

   public TCoreMaskingTaskTableInfo gettCoreMaskingTaskTableInfoByInsert(String source_hq, int sortnum, boolean issomedb, boolean isfile, Map<String, String> maptarget, HashMap<String, TCoreFieldSensitiveMemory> map, ColumnInfoVO columnInfoVO) {
      TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo = new TCoreMaskingTaskTableInfo();
      tCoreMaskingTaskTableInfo.setTruesearchType(source_hq);
      tCoreMaskingTaskTableInfo.setSortnum(sortnum);
      tCoreMaskingTaskTableInfo.setIsPrimaryKey(columnInfoVO.getPrimarykey());
      tCoreMaskingTaskTableInfo.setIsForeignKey(columnInfoVO.getForeignkey());
      tCoreMaskingTaskTableInfo.setColumnName(columnInfoVO.getColumnname());
      tCoreMaskingTaskTableInfo.setSearchType(map.get(columnInfoVO.getColumnname()) == null ? "确认非敏感字段" : ((TCoreFieldSensitiveMemory)map.get(columnInfoVO.getColumnname())).getRegextype());
      tCoreMaskingTaskTableInfo.setSourceType(columnInfoVO.getTypename());
      tCoreMaskingTaskTableInfo.setTargetType(issomedb ? columnInfoVO.getTypename() : (String)maptarget.get("sourcefieldname"));
      String targetlength = !issomedb && !isfile ? (String)maptarget.get("targetlength") : columnInfoVO.getColumnsize();
      if (targetlength.equals("")) {
         targetlength = "";
      }

      tCoreMaskingTaskTableInfo.setTargetLength(targetlength);
      tCoreMaskingTaskTableInfo.setTargetPrecision(!issomedb && !isfile ? (String)maptarget.get("targetdecimal") : columnInfoVO.getDecimaldigits());
      tCoreMaskingTaskTableInfo.setLengthruletype(maptarget == null ? "" : (String)maptarget.get("flag"));
      String columnlength = columnInfoVO.getColumnsize();
      if (columnlength.equals("")) {
         columnlength = "";
      }

      tCoreMaskingTaskTableInfo.setColumnLength(columnlength);
      tCoreMaskingTaskTableInfo.setColumnPrecision(columnInfoVO.getDecimaldigits());
      tCoreMaskingTaskTableInfo.setRegexRuleId(map.get(columnInfoVO.getColumnname()) == null ? "" : ((TCoreFieldSensitiveMemory)map.get(columnInfoVO.getColumnname())).getRuleid());
      tCoreMaskingTaskTableInfo.setRegexRuleName(map.get(columnInfoVO.getColumnname()) == null ? "" : ((TCoreFieldSensitiveMemory)map.get(columnInfoVO.getColumnname())).getRuie());
      tCoreMaskingTaskTableInfo.setIsnullable("");
      return tCoreMaskingTaskTableInfo;
   }

   public void updateImportFile(String filepath, String foldername, String repository) throws Exception {
      if (foldername == null) {
         foldername = "ghca";
      }

      File file = new File(filepath);
      ModifyImportFile mi = new ModifyImportFile();
      ModifyImportFile.updateConfigFileXML("TARGETFOLDERNAME", file, foldername);
      ModifyImportFile.updateConfigFileXML("SOURCEFOLDERNAME", file, foldername);
      ModifyImportFile.updateConfigFileXML("TARGETREPOSITORYNAME", file, repository);
      ModifyImportFile.updateConfigFileXML("SOURCEREPOSITORYNAME", file, repository);
   }

   @Async
   public EncryptionMasking savetask_info(String tasknamereal, Map<String, Object> map) {
      String state = (String)map.get("state");
      System.out.println("state:" + state);
      String projectid = (String)map.get("projectid");
      new EncryptionMasking();
      EncryptionMasking encryptionmasking = (EncryptionMasking)this.encryptionmaskingDao.queryUnique(new Criterion[]{Restrictions.eq("tasknamereal", tasknamereal)});
      String batchmanage = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
      if (batchmanage != null) {
         encryptionmasking.setBatchnumber(batchmanage);
      }

      String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
      if (tableprefix != null) {
         encryptionmasking.setTableprefix(tableprefix);
      } else {
         encryptionmasking.setTableprefix("");
      }

      String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
      if (tablesuffix != null) {
         encryptionmasking.setTablesuffix(tablesuffix);
      } else {
         encryptionmasking.setTablesuffix("");
      }

      String version = (String)this.redisService.get(tasknamereal + "_" + "version");
      if (version != null) {
         encryptionmasking.setVersion(version);
      } else {
         encryptionmasking.setVersion("");
      }

      this.redisService.remove(tasknamereal + "_" + "version", tasknamereal + "_" + "tablesuffix", tasknamereal + "_" + "tableprefix");
      if (this.redisService.get(tasknamereal + "ghcaotd") != null && this.redisService.get(tasknamereal + "ghcaotd").equals("ghcaotd")) {
         this.updateTask(tasknamereal, "0");
         Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
         desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
         Desensitizationsource desensitizationsource = new Desensitizationsource();
         desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
         String str = "";
         TCoreDatasystem datasystemdesensitizationsource = (TCoreDatasystem)this.tCoreDatasystemDao.get(desensitizationsource.getDatasourceid());

         List<Map<String, String>> listNew = (List)map.get("tableList");
         for(Map<String, String> map2 : listNew) {
            if (((String)map2.get("status")).equals("1") || ((String)map2.get("status")).equals("3")) {
               str = str + (String)map2.get("tableName") + ",";
            }
         }

         str = str.substring(0, str.length() - 1);
         String oracleConnInfo = desensitizationsource.getDataschema();
         Connection conn = JdbcTool.getConnection("oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin:@192.168.2.90:1521:orcl", oracleConnInfo, oracleConnInfo);
         if (conn == null) {
            if (Character.isUpperCase(oracleConnInfo.charAt(0))) {
               oracleConnInfo = oracleConnInfo.toLowerCase();
            } else {
               oracleConnInfo = oracleConnInfo.toUpperCase();
            }
         }

         CommandTool.command("mkdir /data/infa_dmp/midfile/" + tasknamereal);
         CommandTool.command("exp " + oracleConnInfo + "/" + oracleConnInfo + "@" + datasystemdesensitizationsource.getDbip() + "/" + datasystemdesensitizationsource.getDbservername() + " file=/data/infa_dmp/midfile/" + tasknamereal + "/" + desensitizationsource.getDataschema() + ".dmp tables=" + str);
         this.dataSystemService.getAllTableNameList("0", "/data/infa_dmp/midfile/" + tasknamereal + "/" + desensitizationsource.getDataschema() + ".dmp", "1", tasknamereal);
         desensitizationsource.setDmptype("1");
         desensitizationsource.setExecution_type("oracledmp");
         desensitizationsource.setIsdmpfile("1");
         desensitizationsource.setMultiDempFile("0");
         desensitizationsource.setSourcefiledir("/data/infa_dmp/midfile/" + tasknamereal + "/" + desensitizationsource.getDataschema() + ".dmp");
         desensitizationsource.setFilelist(desensitizationsource.getDataschema() + ".dmp");
         this.redisService.set(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName(), desensitizationsource);
         desensitizationtarget.setDatasourceid("");
         desensitizationtarget.setDmpimport("1");
         desensitizationtarget.setExecution_type("oracledmp");
         this.redisService.set(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName(), desensitizationtarget);
      }

      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      desensitizationtarget = this.saveDesensitizationtarget(tasknamereal, encryptionmasking.getId(), desensitizationtarget, state);
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      desensitizationsource = this.saveDesensitizationsource(tasknamereal, encryptionmasking.getId(), desensitizationsource, state);
      DesensitizationFile desensitizationfile = new DesensitizationFile();
      desensitizationfile = this.saveDesensitizationFile(tasknamereal, encryptionmasking.getId(), desensitizationfile, state);
      List<DesensitizationTable> desensitizationTable = new ArrayList();
      new ArrayList();
      Map<String, String> map_table_filterConditions = (Map)map.get("map_table_filterConditions");
      List<Map<String, String>> var33 = (List)map.get("tableList");
      var33 = (List)var33.stream().filter((s) -> "1".equals(s.get("status")) || "3".equals(s.get("status"))).collect(Collectors.toList());
      String save_state = "1";
      new HashMap();

      try {
         this.saveDesensitizationTable(encryptionmasking, encryptionmasking.getId(), desensitizationTable, desensitizationsource, desensitizationtarget, var33, state, desensitizationfile, map_table_filterConditions);
         save_state = "2";
      } catch (Exception e) {
         save_state = "1";
         e.printStackTrace();
         StringWriter sw = new StringWriter();
         e.printStackTrace(new PrintWriter(sw, true));
         String strs = sw.toString();
         this.addErrLog(strs, tasknamereal, encryptionmasking.getUsername());
      }

      String tasktype = "";
      if (!this.isteststate) {
         Boolean pwc_state = true;
         Boolean importlog = true;
         Boolean createtable = true;
         pwc_state = pwc_state == null ? false : pwc_state;
         importlog = importlog == null ? false : importlog;
         createtable = createtable == null ? false : createtable;
         System.out.println("pwc_state:" + pwc_state);
         System.out.println("importlog:" + importlog);
         System.out.println("createtable:" + createtable);
         if (pwc_state && importlog && createtable) {
            save_state = "2";
         } else {
            save_state = "1";
         }
      }

      encryptionmasking.setTasktype(tasktype);
      encryptionmasking.setSave_state(save_state);
      encryptionmasking.setTaskstatus("0");
      encryptionmasking.setCount_exe("0%");
      encryptionmasking.setBatchnumber(batchmanage);
      encryptionmasking.setProjectid(projectid);
      this.encryptionmaskingDao.saveOrUpdate(encryptionmasking);
      this.updateTask(tasknamereal, save_state);
      return encryptionmasking;
   }

   public Connection getConnectionByDataSystemId(TCoreDatasystem datasystem) {
      String dbcode = datasystem.getDbtype();
      String ip = datasystem.getDbip();
      String port = datasystem.getDbport();
      String servername = datasystem.getDbservername();
      String server = datasystem.getServername();
      String url = "";
      switch (datasystem.getDbtype()) {
         case "INFORMIX":
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername, server);
            break;
         case "TERADATA":
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername, server, datasystem.getPagecode());
            break;
         default:
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername);
      }

      String username = datasystem.getUsername();
      String password = "1".equals(datasystem.getFlag()) ? AesTool.decrypt(datasystem.getPassword(), "ghca") : datasystem.getPassword();
      String driver = EdbType.getEdbTypeByDbcode(dbcode).getDbdriver();
      if ("HIVE".equals(datasystem.getDbtype()) && "on".equals(datasystem.getIskerberos())) {
         System.setProperty("java.security.krb5.conf", datasystem.getXmlpath() + "/krb5.conf");
         Connection conn = JdbcTool.getKerberosConn(url + ";principal=" + datasystem.getPrincipal(), driver, datasystem.getLoginprincipal(), datasystem.getXmlpath());
         return conn;
      } else if (dbcode.equals("RAPIDSDB")) {
         Connection conn = JdbcTool.getConnection(driver, url, username, "");
         return conn;
      } else {
         Connection conn = JdbcTool.getConnection(driver, url, username, password);
         return conn;
      }
   }

   public List<ColumnInfoVO> queryColumnInfo(String datasystemid, String schema, String tableName) {
      TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(datasystemid);
      if (datasystem == null) {
         return null;
      } else {
         Connection conn = this.getConnectionByDataSystemId(datasystem);
         List<ColumnInfoVO> list = JdbcTool.getColumnInfoVO(conn, schema, tableName);
         List<ColumnInfoVO> list1 = new ArrayList();
         if (datasystem.getDbtype().equals("SYBASE_IQ")) {
            for(ColumnInfoVO civ : list) {
               if (civ.getTypename().equals("varchar") || civ.getTypename().equals("char")) {
                  civ.setDecimaldigits("");
               }

               list1.add(civ);
            }
         }

         try {
            if (conn != null) {
               conn.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return datasystem.getDbtype().equals("SYBASE_IQ") ? list1 : list;
      }
   }

   public String gettaskBytasknamereal(String tasknamereal, String projectId) {
      EncryptionMasking encryptionmasking = (EncryptionMasking)this.encryptionmaskingDao.queryUnique(new Criterion[]{Restrictions.eq("tasknamereal", tasknamereal)});
      if (encryptionmasking != null) {
         return "2";
      } else {
         encryptionmasking = new EncryptionMasking();
         new LoginUser();
         LoginUser loginUser = (LoginUser)this.request.getSession().getAttribute("loginUser");
         encryptionmasking = (EncryptionMasking)this.redisService.get(tasknamereal + "_" + encryptionmasking.getClass().getSimpleName());
         encryptionmasking.setCreatetime(new Date());
         encryptionmasking.setUpdatatime(new Date());
         encryptionmasking.setSave_state("0");
         TBaseUser user = loginUser.getTsysUser();
         encryptionmasking.setUserid(user.getId());
         encryptionmasking.setUsername(user.getUsername());
         encryptionmasking.setFlag("0");
         encryptionmasking.setProjectid(projectId);
         this.encryptionmaskingDao.save(encryptionmasking);
         return "3";
      }
   }

   public Desensitizationsource querySourceInfo(String taskid) {
      return (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
   }

   public Desensitizationtarget queryTargetInfo(String taskid) {
      return (Desensitizationtarget)this.desensitizationtargetDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
   }

   public List<DesensitizationTable> queryTableList(String taskid) {
      return this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid)});
   }

   public DesensitizationTable queryTableByTableName(String taskid, String tableName) {
      return (DesensitizationTable)this.desensitizationTableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("tablename", tableName)});
   }

   public EncryptionMasking queryTaskById(String taskid) {
      return (EncryptionMasking)this.encryptionmaskingDao.queryUnique(new Criterion[]{Restrictions.eq("id", taskid)});
   }

   public EncryptionMasking queryTaskByIdRedis(String taskid) {
      return this.encryptionmaskingDao.getById(taskid);
   }

   @Async
   public void removeTask(String taskid) {
      EncryptionMasking encryptionmasking = (EncryptionMasking)this.encryptionmaskingDao.get(taskid);
      Process process = null;
      String osType = "Linux";
      if (encryptionmasking != null) {
         try {
            String os = System.getProperty("os.name");
            if (os.toLowerCase().startsWith("win")) {
               osType = "Windows";
            }

            String removeRedisKey = "removePercent_" + encryptionmasking.getTasknamereal();
            this.redisService.set(removeRedisKey, "0");
            String taskType = encryptionmasking.getTasktype();
            System.out.println(encryptionmasking.getTasknamereal() + "，删除xml开始！");
            if ("Linux".equals(osType)) {
               FileTool.removeFile("/data/infa_work_report/masking_task/" + encryptionmasking.getTasknamereal() + ".xml");
               Desensitizationsource desensitizationsource = (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
               if (null != desensitizationsource && "1".equals(desensitizationsource.getIsdmpfile())) {
                  new Properties();

                  try {
                     Properties desensitizationtarget = PropertiesLoaderUtils.loadAllProperties("config.properties");
                     String dmppath = desensitizationtarget.getProperty("dmp_exp_table_file_path");
                     String rmFileCmd = "rm -rf " + dmppath + encryptionmasking.getTasknamereal();
                     CommandTool.command(rmFileCmd);
                  } catch (IOException e) {
                     e.printStackTrace();
                  }
               }
            }

            this.redisService.set(removeRedisKey, "3");
            Desensitizationsource desensitizationsource = (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
            if (desensitizationsource != null && !"".equals(desensitizationsource.getDatasourceid()) && desensitizationsource.getDatasourceid() != null) {
               TCoreDatasystem datasystem_s = (TCoreDatasystem)this.tCoreDatasystemDao.get(desensitizationsource.getDatasourceid());
               String sourceFolderName = "";
               if (datasystem_s != null) {
                  if ("MYSQL".equals(datasystem_s.getDbtype())) {
                     sourceFolderName = "infa_mysqlload";
                  } else if ("RAPIDSDB".equals(datasystem_s.getDbtype())) {
                     sourceFolderName = "infa_rapidsdbload";
                  } else if ("MSSQLSERVER".equals(datasystem_s.getDbtype())) {
                     sourceFolderName = "infa_sqlserver";
                  } else if ("SYBASE_IQ".equals(datasystem_s.getDbtype())) {
                     sourceFolderName = "infa_sybaseiq";
                  } else if ("TERADATA".equals(datasystem_s.getDbtype())) {
                     sourceFolderName = "infa_teradata";
                  }

                  if (!"".equals(sourceFolderName) && "Linux".equals(osType)) {
                     FileTool.delFolder("/data/" + sourceFolderName + "/source/" + encryptionmasking.getTasknamereal());
                  }
               }
            }

            this.redisService.set(removeRedisKey, "5");
            Desensitizationtarget desensitizationtarget = (Desensitizationtarget)this.desensitizationtargetDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
            if (desensitizationtarget != null && !"".equals(desensitizationtarget.getDatasourceid()) && desensitizationtarget.getDatasourceid() != null) {
               TCoreDatasystem datasystem_t = (TCoreDatasystem)this.tCoreDatasystemDao.get(desensitizationtarget.getDatasourceid());
               String targetFolderName = "";
               if (datasystem_t != null) {
                  if ("MYSQL".equals(datasystem_t.getDbtype())) {
                     targetFolderName = "infa_mysqlload";
                  } else if ("RAPIDSDB".equals(datasystem_t.getDbtype())) {
                     targetFolderName = "infa_rapidsdbload";
                  } else if ("MSSQLSERVER".equals(datasystem_t.getDbtype())) {
                     targetFolderName = "infa_sqlserver";
                  } else if ("SYBASE_IQ".equals(datasystem_t.getDbtype())) {
                     targetFolderName = "infa_sybaseiq";
                  } else if ("TERADATA".equals(datasystem_t.getDbtype())) {
                     targetFolderName = "infa_teradata";
                  }

                  if (!"".equals(targetFolderName) && "Linux".equals(osType)) {
                     FileTool.delFolder("/data/" + targetFolderName + "/target/" + encryptionmasking.getTasknamereal());
                  }
               }
            }

            this.redisService.set(removeRedisKey, "10");
            if (!"".equals(taskType) && taskType != null) {
               String type = taskType.substring(taskType.length() - 4, taskType.length());
               if ("FILE".equals(type)) {
                  System.out.println(encryptionmasking.getTasknamereal() + "，删除目标文件开始！");
                  this.desensitizationFileDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
               }
            }

            List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid)});
            String masking_engine_type = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("masking_engine_type");
            if (!"1".equals(masking_engine_type)) {
               System.out.println(encryptionmasking.getTasknamereal() + "，删除workflow、mapping开始！");
               double removePercent = (double)10.0F;
               if ("Linux".equals(osType)) {
                  for(DesensitizationTable desensitizationTable : list) {
                     int size = list.size();
                     BigDecimal bg = new BigDecimal((double)85.0F / (double)size);
                     removePercent += bg.setScale(2, 4).doubleValue();
                     System.out.println("-----------------removePercent=" + removePercent);
                     this.redisService.set(removeRedisKey, removePercent + "");
                     InfoProperty infoProperty = this.getInfoProperty();
                     System.out.println(String.format("删除 %s 表的workflow开始！", desensitizationTable.getTablename()));
                     Process var26 = Runtime.getRuntime().exec(infoProperty.getPmrepexepath() + " deleteObject -o workflow -f " + encryptionmasking.getFoldername() + " -n wf_" + encryptionmasking.getTasknamereal() + "_" + desensitizationTable.getTablename());
                     System.out.println(String.format("删除 %s 表的mapping开始！", desensitizationTable.getTablename()));
                     process = Runtime.getRuntime().exec(infoProperty.getPmrepexepath() + " deleteObject -o mapping -f " + encryptionmasking.getFoldername() + " -n mp_" + encryptionmasking.getTasknamereal() + "_" + desensitizationTable.getTablename());
                     process.waitFor();
                  }
               }
            }

            this.redisService.set(removeRedisKey, "95");
            System.out.println(encryptionmasking.getTasknamereal() + "，删除redis开始！");
            this.redisService.removeLikePrefix(encryptionmasking.getTasknamereal());
            System.out.println(encryptionmasking.getTasknamereal() + "，删除数据库开始！");
            this.desensitizationtargetDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
            this.desensitizationsourceDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
            this.desensitizationTableDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
            this.desensitizationMonitorDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
            this.desensitizationTablecolumnDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
            this.redisService.set(removeRedisKey, "100");
            this.encryptionmaskingDao.removeById(taskid);
         } catch (Exception e) {
            e.printStackTrace();
         } finally {
            if (process != null) {
               process.destroy();
            }

         }
      }

   }

   public Info pwc_Info(SourceInfo sourceInfo, TargetInfo targetInfo, String taskname) {
      Info info = new Info();
      info.setSourceInfo(sourceInfo);
      info.setTargetInfo(targetInfo);
      info.setTaskname(taskname);
      return info;
   }

   public Config pwc_config(Map<String, String> mapparam) {
      Config config = new Config();
      int readMode = 0;
      int writeMode = 0;
      if (((String)mapparam.get("execution_type_s")).equals("normal")) {
         readMode = 0;
         if (((String)mapparam.get("execution_type_t")).equals("normal")) {
            writeMode = 0;
         } else {
            writeMode = 1;
         }
      } else {
         readMode = 1;
         if (((String)mapparam.get("execution_type_t")).equals("normal")) {
            writeMode = 0;
         } else {
            writeMode = 1;
         }
      }

      readMode = ((String)mapparam.get("source_type")).equals("FILE") ? 1 : readMode;
      writeMode = ((String)mapparam.get("target_type")).equals("FILE") ? 1 : writeMode;
      config.setDomainName((String)mapparam.get("domainName"));
      config.setFolderName((String)mapparam.get("folderName"));
      config.setMappletDir((String)mapparam.get("mappletDir"));
      config.setReadMode(readMode);
      config.setRepositoryName((String)mapparam.get("repository"));
      config.setServerName((String)mapparam.get("serverName"));
      config.setWriteMode(writeMode);
      config.setHdfsDir((String)mapparam.get("hdfsDir"));
      config.setIsrecover(Integer.parseInt((String)mapparam.get("isrecover")));
      config.setXmlLocation((String)mapparam.get("xmlLocation"));
      if (mapparam.get("batchnumber") != null) {
         config.setBatchnumber(Integer.parseInt((String)mapparam.get("batchnumber")));
      }

      return config;
   }

   public DesensitizationTablecolumn getDesensitizationTablecolumn(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo, String tableid, String taskid) {
      DesensitizationTablecolumn desensitizationTablecolumn = new DesensitizationTablecolumn();
      desensitizationTablecolumn.setColumnindex(0);
      desensitizationTablecolumn.setColumnlength(tCoreMaskingTaskTableInfo.getColumnLength());
      desensitizationTablecolumn.setColumnname(tCoreMaskingTaskTableInfo.getColumnName());
      desensitizationTablecolumn.setColumnscale(tCoreMaskingTaskTableInfo.getColumnPrecision());
      desensitizationTablecolumn.setColumntype(tCoreMaskingTaskTableInfo.getTruesearchType());
      desensitizationTablecolumn.setId(UUID.randomUUID().toString());
      desensitizationTablecolumn.setJudgenull(tCoreMaskingTaskTableInfo.getIsnullable());
      desensitizationTablecolumn.setMappingkey("");
      desensitizationTablecolumn.setColumntartype(tCoreMaskingTaskTableInfo.getTargetType());
      desensitizationTablecolumn.setPrimarykey(tCoreMaskingTaskTableInfo.getIsPrimaryKey());
      desensitizationTablecolumn.setRegextype(tCoreMaskingTaskTableInfo.getRegexType());
      desensitizationTablecolumn.setRuleid(tCoreMaskingTaskTableInfo.getRegexRuleId());
      desensitizationTablecolumn.setRulename(tCoreMaskingTaskTableInfo.getRegexRuleName());
      desensitizationTablecolumn.setTableid(tableid);
      desensitizationTablecolumn.setTaskid(taskid);
      desensitizationTablecolumn.setSecretkeyId(tCoreMaskingTaskTableInfo.getSecretkeyId());
      desensitizationTablecolumn.setSecretkeyName(tCoreMaskingTaskTableInfo.getSecretkeyName());
      desensitizationTablecolumn.setSortnum(tCoreMaskingTaskTableInfo.getSortnum());
      return desensitizationTablecolumn;
   }

   public Desensitizationtarget queryTargetById(String taskid) {
      return (Desensitizationtarget)this.desensitizationtargetDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
   }

   public InfoProperty getInfoProperty() {
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(props.getProperty("engineid"));
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      return engine;
   }

   public List<EncryptionMasking> queryTaskList(String taskid) {
      List<EncryptionMasking> list = this.encryptionmaskingDao.queryAll(new Criterion[]{Restrictions.eq("id", taskid)});
      return list;
   }

   public int saveDesensitizationMonitor(StringBuilder sql) {
      return this.desensitizationMonitorDao.saveDesensitizationMonitor(sql);
   }

   @Async
   public void executeDB_pwc_FILE_batchwrite_DB(final ExecuteParam executeParam) throws Exception {
      System.out.println(">>>>>>>>>>>>>>>>>DB_pwc_FILE_batchwrite_DB<<<<<<<<<<<<<<<<<<");
      new Properties();
      Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      String engineType = props.getProperty("masking_engine_type");
      if ("1".equals(engineType)) {
         this.executeDB_pwc_FILE_batchwrite_DB(executeParam, "1");
      } else {
         final Runtime rn = Runtime.getRuntime();
         List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
         final Connection targetConn = this.dataSystemService.getConnectionByDataSystemId(executeParam.getDataTargetId());
         final CountDownLatch countDownLatch = new CountDownLatch(tableList.size());
         final TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(executeParam.getDataTargetId());
         final Map<String, List<DesensitizationTablecolumn>> map = new HashMap();

         for(DesensitizationTable desensitizationTable : tableList) {
            List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
            List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
            map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
         }

         final EncryptionMasking encryptionmasking = (EncryptionMasking)this.encryptionmaskingDao.get(executeParam.getTaskid());
         encryptionmasking.setTaskstatus("1");
         this.encryptionmaskingDao.saveOrUpdate(encryptionmasking);
         this.encryptionmaskingDao.getSession().getTransaction().commit();

         for(final DesensitizationTable desensitizationTable : tableList) {
            this.taskExecutor.execute(new Runnable() {
               public void run() {
                  String sessionId = "";
                  String status = "4";
                  String t_tableName = (encryptionmasking.getTableprefix() == null ? "" : encryptionmasking.getTableprefix()) + desensitizationTable.getT_tablename() + (encryptionmasking.getTablesuffix() == null ? "" : encryptionmasking.getTablesuffix());
                  String s_tableName = desensitizationTable.getTablename();
                  String workflowName = "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName;

                  try {
                     Properties props = new Properties();

                     try {
                        props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                     } catch (IOException e) {
                        e.printStackTrace();
                     }

                     if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
                        System.out.println("---进入启动预计运行时间方法！");
                        String dataCount = "";
                        dataCount = EncryptionMaskingImpl.this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
                        System.out.println("数据源表" + s_tableName + "总行数：" + dataCount);
                        EncryptionMaskingImpl.this.redisService.set("dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName, dataCount);
                        System.out.println("预计运行时间，key=dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName + "，dataCount=" + dataCount);
                     }

                     EncryptionMaskingImpl.this.updateMonitorRunStatus(s_tableName, executeParam.getTableMap());
                     System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
                     sessionId = LoginWebService.returnStatus(executeParam.getInfoProperty());
                     System.out.println("获取sessionId结束！sessionId=" + sessionId + ",tableName=" + s_tableName);
                     System.out.println("删除主外键开始！tableName=" + t_tableName);
                     JdbcTool.delPrimaryForeignKeyAndIndex(targetConn, executeParam.getTargetSchemaName(), t_tableName);
                     System.out.println("创建执行脚本开始！tableName=" + desensitizationTable.getTablename() + ",t_tableName" + t_tableName);
                     EncryptionMaskingImpl.this.createScriptFiletotarget(executeParam, desensitizationTable, executeParam.getTargetDataSystem().getDbtype(), tCoreDatasystemTarget, (List)map.get(s_tableName), rn);
                     System.out.println("调用启动工作流方法开始！tableName=" + s_tableName);
                     int runId = EncryptionMaskingImpl.this.startWorkFlowEx(workflowName, executeParam.getInfoProperty(), executeParam.getFolderName(), sessionId);
                     String dbType = executeParam.getTargetDataSystem().getDbtype();
                     System.out.println("启动脚本开始！dbType=" + dbType + ",tableName=" + s_tableName + ",t_tableName=" + t_tableName);
                     if ("SYBASE_IQ".equals(dbType)) {
                        CommandTool.commandRtn("/data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh /data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".pipe");
                     } else if ("MSSQLSERVER".equals(dbType)) {
                        CommandTool.command("chmod -R 777 /data/infa_sqlserver/");
                        String completeStatus = EncryptionMaskingImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                        if ("1".equals(completeStatus)) {
                           CommandTool.commandRtn("/data/infa_sqlserver/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                        }
                     } else if ("SYBASE".equals(dbType)) {
                        CommandTool.command("chmod -R 777 /data/infa_sybase/");
                        CommandTool.commandRtn("/data/infa_sybase/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     } else if ("MYSQL".equals(dbType)) {
                        CommandTool.commandRtn("/data/infa_mysqlload/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     } else if ("RAPIDSDB".equals(dbType)) {
                        CommandTool.commandRtn("/data/infa_rapidsdbload/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     } else if ("TERADATA".equals(dbType)) {
                        CommandTool.commandRtn("/data/infa_teradata/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     } else if ("DB2".equals(dbType)) {
                        CommandTool.commandRtn("/data/infa_db2/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     } else if ("GREENPLUM".equals(dbType)) {
                        CommandTool.commandRtn("/data/infa_greenplum/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     }

                     String completeStatus = "0";
                     System.out.println("》》》》》》》》》》》》》》》runId=" + runId);
                     if (runId >= 0) {
                        completeStatus = EncryptionMaskingImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                     }

                     if ("1".equals(completeStatus)) {
                        System.out.println("表" + desensitizationTable.getTablename() + ",执行完成,通过阻塞方法！");
                        SessionBean sessionBean = EncryptionMaskingImpl.this.getLogForTaskMapping(executeParam.getFolderName(), executeParam.getInfoProperty(), executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
                        if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                           status = "1";
                        } else if ("FAILED".equals(sessionBean.getStatus())) {
                           status = "2";
                        } else if ("STOPPED".equals(sessionBean.getStatus())) {
                           status = "3";
                        } else {
                           status = "4";
                        }

                        if ("TERADATA".equals(dbType)) {
                           Connection tconn = EncryptionMaskingImpl.this.getConnectionByDataSystemId(executeParam.getTargetDataSystem());
                           EncryptionMaskingImpl.this.droptable(t_tableName, tconn, executeParam.getTargetSchemaName());
                        }

                        System.out.println("执行更新监控表开始！tableName=" + s_tableName + "t_tableName=" + t_tableName);
                        EncryptionMaskingImpl.this.updateMonitor(s_tableName, executeParam.getTableMap(), status, runId);
                     }

                     LogoutWebService.returnStatus(sessionId, executeParam.getInfoProperty());
                  } catch (Exception e) {
                     e.printStackTrace();
                  } finally {
                     countDownLatch.countDown();
                  }

               }
            });
         }

         try {
            System.out.println(">>>>>>>>>>>>>>>当前活动线程数：" + this.taskExecutor.getActiveCount());
            System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + countDownLatch.getCount());
            countDownLatch.await();
            System.out.println(">>>>>>>>>>>>>>>插入监控详细信息表开始！");
            this.insertMonitorInfo(tableList, executeParam.getInfoProperty(), executeParam.getFolderName(), executeParam.getTaskid(), executeParam.getTaskNameReal());
            JdbcTool.closeConnection(targetConn);
            this.updateTask_taskstatus(encryptionmasking.getId(), "3");
            System.out.println(">>>>>>>>>>>>>>>任务已全部执行完成！同步表信息开始！");
            this.synTableParam(tableList, executeParam);
         } catch (Exception e) {
            e.printStackTrace();
         }

      }
   }

   public void executeDB_pwc_FILE_batchwrite_DB(final ExecuteParam executeParam, String engineFlg) throws Exception {
      System.out.println(">>>>>>>>>>>>>>>>>DB_pwc_FILE_batchwrite_DB<<<<<<<<<<<<<<<<<<");
      Runtime rn = Runtime.getRuntime();
      List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
      final Connection targetConn = this.dataSystemService.getConnectionByDataSystemId(executeParam.getDataTargetId());
      TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(executeParam.getDataTargetId());
      Map<String, List<DesensitizationTablecolumn>> map = new HashMap();

      for(DesensitizationTable desensitizationTable : tableList) {
         List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
         List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
         map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
      }

      final EncryptionMasking encryptionmasking = (EncryptionMasking)this.encryptionmaskingDao.get(executeParam.getTaskid());
      encryptionmasking.setTaskstatus("1");
      this.encryptionmaskingDao.saveOrUpdate(encryptionmasking);
      this.encryptionmaskingDao.getSession().getTransaction().commit();

      for(int i = 0; i < tableList.size(); ++i) {
         DesensitizationTable desensitizationTable = (DesensitizationTable)tableList.get(i);
         String s_tableName = desensitizationTable.getTablename();
         this.createScriptFiletotarget(executeParam, desensitizationTable, executeParam.getTargetDataSystem().getDbtype(), tCoreDatasystemTarget, (List)map.get(s_tableName), rn);
      }

      final CountDownLatch engineCountDownLatch = new CountDownLatch(1);

      try {
         this.taskExecutor.execute(new Runnable() {
            public void run() {
               try {
                  String xmlFileName = executeParam.getTaskNameReal();
                  System.out.println("xmlFileName is :" + xmlFileName);
                  System.out.println(">>>>>>>The client call engine start>>>>>>>>>>>>>>>>>>>>>");
                  DesensitizationEngineInterfaceImplService engineInterfaceImplService = new DesensitizationEngineInterfaceImplService();
                  DesensitizationEngineInterfaceImpl engineInterfaceImpl = (DesensitizationEngineInterfaceImpl)engineInterfaceImplService.getPort(DesensitizationEngineInterfaceImpl.class);
                  EngineParameter eParameter = new EngineParameter();
                  eParameter.setWorkflowName(xmlFileName);
                  eParameter.setGroupId(executeParam.getGroupId());
                  eParameter.setDataProcessType("DB_pwc_FILE_batchwrite_DB");
                  EngineResult er = engineInterfaceImpl.startWorkflowEx(eParameter);
                  System.out.println("result is " + er.getReStatus());
                  System.out.println(">>>>>>>The client call engine end>>>>>>>>>>>>>>>>>>>>>");
               } catch (Exception e) {
                  e.printStackTrace();
                  String taskid = encryptionmasking.getId();
                  EncryptionMaskingImpl.updataRunstatus(taskid);
                  System.out.println(executeParam.getTaskNameReal() + "任务 调用引擎失败!");
               } finally {
                  engineCountDownLatch.countDown();
               }

            }
         });
         System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + engineCountDownLatch.getCount());
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         this.updateTask_taskstatus(encryptionmasking.getId(), "3");
      }

      final CountDownLatch countDownLatch = new CountDownLatch(tableList.size());

      for(final DesensitizationTable desensitizationTable : tableList) {
         this.taskExecutor.execute(new Runnable() {
            public void run() {
               String t_tableName = (encryptionmasking.getTableprefix() == null ? "" : encryptionmasking.getTableprefix()) + desensitizationTable.getT_tablename() + (encryptionmasking.getTablesuffix() == null ? "" : encryptionmasking.getTablesuffix());
               String s_tableName = desensitizationTable.getTablename();

               try {
                  Properties props = new Properties();

                  try {
                     props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                  } catch (IOException e) {
                     e.printStackTrace();
                  }

                  if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
                     System.out.println("---进入启动预计运行时间方法！");
                     String dataCount = "";
                     dataCount = EncryptionMaskingImpl.this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
                     System.out.println("数据源表" + s_tableName + "总行数：" + dataCount);
                     EncryptionMaskingImpl.this.redisService.set("dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName, dataCount);
                     System.out.println("预计运行时间，key=dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName + "，dataCount=" + dataCount);
                  }

                  EncryptionMaskingImpl.this.updateMonitorRunStatus(s_tableName, executeParam.getTableMap());
                  System.out.println("删除主外键开始！tableName=" + t_tableName);
                  JdbcTool.delPrimaryForeignKeyAndIndex(targetConn, executeParam.getTargetSchemaName(), t_tableName);
                  System.out.println("创建执行脚本开始！tableName=" + desensitizationTable.getTablename() + ",t_tableName" + t_tableName);
                  System.out.println("调用启动工作流方法开始！tableName=" + s_tableName);
                  String dbType = executeParam.getTargetDataSystem().getDbtype();
                  System.out.println("启动脚本开始！dbType=" + dbType + ",tableName=" + s_tableName + ",t_tableName=" + t_tableName);
                  if ("SYBASE_IQ".equals(dbType)) {
                     CommandTool.commandRtn("/data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh /data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".pipe");
                  } else if (!"MSSQLSERVER".equals(dbType)) {
                     if ("SYBASE".equals(dbType)) {
                        CommandTool.command("chmod -R 777 /data/infa_sybase/");
                        CommandTool.commandRtn("/data/infa_sybase/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     } else if ("MYSQL".equals(dbType)) {
                        CommandTool.commandRtn("/data/infa_mysqlload/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     } else if ("RAPIDSDB".equals(dbType)) {
                        CommandTool.commandRtn("/data/infa_rapidsdbload/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     } else if ("TERADATA".equals(dbType)) {
                        CommandTool.commandRtn("/data/infa_teradata/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     } else if ("DB2".equals(dbType)) {
                        CommandTool.commandRtn("/data/infa_db2/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     } else if ("GREENPLUM".equals(dbType)) {
                        CommandTool.commandRtn("/data/infa_greenplum/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     }
                  } else {
                     CommandTool.command("chmod -R 777 /data/infa_sqlserver/");
                     boolean notChange = true;

                     while(notChange) {
                        File f1 = new File("/data/infa_sqlserver/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".txt");
                        Long f1length = f1.length();
                        Thread.sleep(1000L);
                        File f2 = new File("/data/infa_sqlserver/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".txt");
                        Long f2length = f2.length();
                        if (f1length.equals(f2length) && f1length != 0L) {
                           notChange = false;
                        }
                     }

                     CommandTool.commandRtn("/data/infa_sqlserver/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                  }

                  if ("TERADATA".equals(dbType)) {
                     Connection tconn = EncryptionMaskingImpl.this.getConnectionByDataSystemId(executeParam.getTargetDataSystem());
                     EncryptionMaskingImpl.this.droptable(t_tableName, tconn, executeParam.getTargetSchemaName());
                  }
               } catch (Exception e) {
                  e.printStackTrace();
               } finally {
                  countDownLatch.countDown();
               }

            }
         });
      }

   }

   @Async
   public void executeFILE_pwc_FILE_batchwrite_DB(final ExecuteParam executeParam) throws Exception {
      new Properties();
      Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      String engineType = props.getProperty("masking_engine_type");
      if ("1".equals(engineType)) {
         this.executeFILE_pwc_FILE_batchwrite_DB(executeParam, "1");
      } else {
         System.out.println(">>>>>>>>>>>>>>>>>FILE_pwc_FILE_batchwrite_DB<<<<<<<<<<<<<<<<<<");
         List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
         final TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(executeParam.getDataTargetId());
         final Runtime rn = Runtime.getRuntime();
         final Map<String, List<DesensitizationTablecolumn>> map = new HashMap();
         final CountDownLatch countDownLatch = new CountDownLatch(tableList.size());

         for(DesensitizationTable desensitizationTable : tableList) {
            String delimit = "";
            if (desensitizationTable.getFilename() != null && desensitizationTable.getFilename().contains(".xl")) {
               new TCoreFileStructurespliter();
               TCoreFileStructurespliter list = (TCoreFileStructurespliter)this.tCoreFileStructurespliterDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", desensitizationTable.getFilestructureid())});
               delimit = list.getDelimiters();
            }

            desensitizationTable.setNote(delimit);
            List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
            List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
            map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
         }

         final EncryptionMasking encryptionmasking = (EncryptionMasking)this.encryptionmaskingDao.get(executeParam.getTaskid());
         encryptionmasking.setTaskstatus("1");
         this.encryptionmaskingDao.saveOrUpdate(encryptionmasking);
         this.encryptionmaskingDao.getSession().getTransaction().commit();

         for(final DesensitizationTable desensitizationTable : tableList) {
            this.taskExecutor.execute(new Runnable() {
               public void run() {
                  String sessionId = "";
                  String status = "4";
                  String t_tableName = (encryptionmasking.getTableprefix() == null ? "" : encryptionmasking.getTableprefix()) + desensitizationTable.getT_tablename() + (encryptionmasking.getTablesuffix() == null ? "" : encryptionmasking.getTablesuffix());
                  String s_tableName = desensitizationTable.getTablename();
                  String workflowName = "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName;

                  try {
                     Properties props = new Properties();

                     try {
                        props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                     } catch (IOException e) {
                        e.printStackTrace();
                     }

                     if (!desensitizationTable.getFilename().contains(".xls") && desensitizationTable.getFilename().contains(".xlsx")) {
                     }

                     if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
                        System.out.println("---进入启动预计运行时间方法！");
                        String dataCount = "";
                        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader("/data/infa_file/" + executeParam.getSourceFileDir() + "/" + desensitizationTable.getFilename()));
                        lineNumberReader.skip(Long.MAX_VALUE);
                        int lineNumber = lineNumberReader.getLineNumber() + 1;
                        dataCount = lineNumber + "";
                        System.out.println("数据源表" + s_tableName + "总行数：" + dataCount);
                        EncryptionMaskingImpl.this.redisService.set("dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName, dataCount);
                        System.out.println("预计运行时间，key=dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName + "，dataCount=" + dataCount);
                     }

                     EncryptionMaskingImpl.this.updateMonitorRunStatus(desensitizationTable.getTablename(), executeParam.getTableMap());
                     System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
                     sessionId = LoginWebService.returnStatus(executeParam.getInfoProperty());
                     System.out.println("创建执行脚本开始！tableName=" + s_tableName + "t_s_tableName" + t_tableName);
                     EncryptionMaskingImpl.this.createScriptFiletotarget(executeParam, desensitizationTable, executeParam.getTargetDataSystem().getDbtype(), tCoreDatasystemTarget, (List)map.get(s_tableName), rn);
                     System.out.println("调用启动工作流方法开始！tableName=" + s_tableName);
                     int runId = EncryptionMaskingImpl.this.startWorkFlowEx(workflowName, executeParam.getInfoProperty(), executeParam.getFolderName(), sessionId);
                     String dbType = executeParam.getTargetDataSystem().getDbtype();
                     System.out.println("启动脚本开始！dbType=" + dbType + ",tableName=" + s_tableName + ",t_tableName=" + t_tableName);
                     if ("SYBASE_IQ".equals(dbType)) {
                        CommandTool.commandRtn("/data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh /data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".pipe");
                     } else if ("MSSQLSERVER".equals(dbType)) {
                        CommandTool.command("chmod -R 777 /data/infa_sqlserver/");
                        String completeStatus = EncryptionMaskingImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                        if ("1".equals(completeStatus)) {
                           CommandTool.commandRtn("/data/infa_sqlserver/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                        }
                     } else if ("SYBASE".equals(dbType)) {
                        System.out.println("执行SYBASE目标的脚本");
                        CommandTool.commandRtn("/data/infa_sybase/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                        System.out.println("执行目标的脚本:完成");
                     } else if ("MYSQL".equals(dbType)) {
                        System.out.println("执行目标的脚本");
                        CommandTool.commandRtn("/data/infa_mysqlload/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                        System.out.println("执行目标的脚本:完成");
                     } else if ("RAPIDSDB".equals(dbType)) {
                        System.out.println("执行目标的脚本");
                        CommandTool.commandRtn("/data/infa_rapidsdbload/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                        System.out.println("执行目标的脚本:完成");
                     } else if ("TERADATA".equals(dbType)) {
                        System.out.println("执行目标的脚本");
                        CommandTool.commandRtn2("/data/infa_teradata/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                        System.out.println("执行目标的脚本:完成");
                     } else if ("DB2".equals(dbType)) {
                        CommandTool.commandRtn("/data/infa_db2/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     }

                     String completeStatus = "0";
                     if (runId >= 0) {
                        completeStatus = EncryptionMaskingImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                     }

                     if ("1".equals(completeStatus)) {
                        System.out.println("表" + desensitizationTable.getTablename() + ",执行完成,通过阻塞方法！");
                        SessionBean sessionBean = EncryptionMaskingImpl.this.getLogForTaskMapping(executeParam.getFolderName(), executeParam.getInfoProperty(), executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
                        if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                           status = "1";
                        } else if ("FAILED".equals(sessionBean.getStatus())) {
                           status = "2";
                        } else if ("STOPPED".equals(sessionBean.getStatus())) {
                           status = "3";
                        } else {
                           status = "4";
                        }

                        if ("TERADATA".equals(dbType)) {
                           Connection tconn = EncryptionMaskingImpl.this.getConnectionByDataSystemId(executeParam.getTargetDataSystem());
                           EncryptionMaskingImpl.this.droptable(t_tableName, tconn, executeParam.getTargetSchemaName());
                        }

                        System.out.println("执行更新监控表开始！tableName=" + s_tableName);
                        EncryptionMaskingImpl.this.updateMonitor(s_tableName, executeParam.getTableMap(), status, runId);
                     }

                     LogoutWebService.returnStatus(sessionId, executeParam.getInfoProperty());
                  } catch (Exception e) {
                     e.printStackTrace();
                  } finally {
                     countDownLatch.countDown();
                  }

               }
            });
         }

         try {
            System.out.println(">>>>>>>>>>>>>>>当前活动线程数：" + this.taskExecutor.getActiveCount());
            System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + countDownLatch.getCount());
            countDownLatch.await();
            System.out.println(">>>>>>>>>>>>>>>插入监控详细信息表开始！");
            this.insertMonitorInfo(tableList, executeParam.getInfoProperty(), executeParam.getFolderName(), executeParam.getTaskid(), executeParam.getTaskNameReal());
            this.updateTask_taskstatus(encryptionmasking.getId(), "3");
         } catch (Exception e) {
            e.printStackTrace();
         }

      }
   }

   public void executeFILE_pwc_FILE_batchwrite_DB(final ExecuteParam executeParam, String engineFlg) throws Exception {
      System.out.println(">>>>>>>>>>>>>>>>>FILE_pwc_FILE_batchwrite_DB<<<<<<<<<<<<<<<<<<");
      List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
      TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(executeParam.getDataTargetId());
      Runtime rn = Runtime.getRuntime();
      Map<String, List<DesensitizationTablecolumn>> map = new HashMap();

      for(DesensitizationTable desensitizationTable : tableList) {
         List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
         List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
         map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
      }

      final EncryptionMasking encryptionmasking = (EncryptionMasking)this.encryptionmaskingDao.get(executeParam.getTaskid());
      encryptionmasking.setTaskstatus("1");
      this.encryptionmaskingDao.saveOrUpdate(encryptionmasking);
      this.encryptionmaskingDao.getSession().getTransaction().commit();

      for(int i = 0; i < tableList.size(); ++i) {
         DesensitizationTable desensitizationTable = (DesensitizationTable)tableList.get(i);
         String s_tableName = desensitizationTable.getTablename();
         this.createScriptFiletotarget(executeParam, desensitizationTable, executeParam.getTargetDataSystem().getDbtype(), tCoreDatasystemTarget, (List)map.get(s_tableName), rn);
      }

      final CountDownLatch engineCountDownLatch = new CountDownLatch(1);

      try {
         this.taskExecutor.execute(new Runnable() {
            public void run() {
               try {
                  String xmlFileName = executeParam.getTaskNameReal();
                  System.out.println("xmlFileName is :" + xmlFileName);
                  System.out.println(">>>>>>>The client call engine start>>>>>>>>>>>>>>>>>>>>>");
                  DesensitizationEngineInterfaceImplService engineInterfaceImplService = new DesensitizationEngineInterfaceImplService();
                  DesensitizationEngineInterfaceImpl engineInterfaceImpl = (DesensitizationEngineInterfaceImpl)engineInterfaceImplService.getPort(DesensitizationEngineInterfaceImpl.class);
                  EngineParameter eParameter = new EngineParameter();
                  eParameter.setWorkflowName(xmlFileName);
                  eParameter.setGroupId(executeParam.getGroupId());
                  eParameter.setDataProcessType("FILE_pwc_FILE_batchwrite_DB");
                  EngineResult er = engineInterfaceImpl.startWorkflowEx(eParameter);
                  System.out.println("result is " + er.getReStatus());
                  System.out.println(">>>>>>>The client call engine end>>>>>>>>>>>>>>>>>>>>>");
               } catch (Exception e) {
                  e.printStackTrace();
                  String taskid = encryptionmasking.getId();
                  EncryptionMaskingImpl.updataRunstatus(taskid);
                  System.out.println(executeParam.getTaskNameReal() + "任务 调用引擎失败!");
               } finally {
                  engineCountDownLatch.countDown();
               }

            }
         });
         System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + engineCountDownLatch.getCount());
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         this.updateTask_taskstatus(encryptionmasking.getId(), "3");
      }

      final CountDownLatch countDownLatch = new CountDownLatch(tableList.size());

      for(final DesensitizationTable desensitizationTable : tableList) {
         this.taskExecutor.execute(new Runnable() {
            public void run() {
               String sessionId = "";
               String status = "4";
               String t_tableName = (encryptionmasking.getTableprefix() == null ? "" : encryptionmasking.getTableprefix()) + desensitizationTable.getT_tablename() + (encryptionmasking.getTablesuffix() == null ? "" : encryptionmasking.getTablesuffix());
               String s_tableName = desensitizationTable.getTablename();

               try {
                  Properties props = new Properties();

                  try {
                     props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                  } catch (IOException e) {
                     e.printStackTrace();
                  }

                  if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
                     System.out.println("---进入启动预计运行时间方法！");
                     String dataCount = "";
                     LineNumberReader lineNumberReader = new LineNumberReader(new FileReader("/data/infa_file/" + executeParam.getSourceFileDir() + "/" + desensitizationTable.getFilename()));
                     lineNumberReader.skip(Long.MAX_VALUE);
                     int lineNumber = lineNumberReader.getLineNumber() + 1;
                     dataCount = lineNumber + "";
                     System.out.println("数据源表" + s_tableName + "总行数：" + dataCount);
                     EncryptionMaskingImpl.this.redisService.set("dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName, dataCount);
                     System.out.println("预计运行时间，key=dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName + "，dataCount=" + dataCount);
                  }

                  EncryptionMaskingImpl.this.updateMonitorRunStatus(desensitizationTable.getTablename(), executeParam.getTableMap());
                  String dbType = executeParam.getTargetDataSystem().getDbtype();
                  System.out.println("启动脚本开始！dbType=" + dbType + ",tableName=" + s_tableName + ",t_tableName=" + t_tableName);
                  if ("SYBASE_IQ".equals(dbType)) {
                     CommandTool.commandRtn("/data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh /data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".pipe");
                  } else if ("MSSQLSERVER".equals(dbType)) {
                     CommandTool.command("chmod -R 777 /data/infa_sqlserver/");
                     String completeStatus = EncryptionMaskingImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                     if ("1".equals(completeStatus)) {
                        CommandTool.commandRtn("/data/infa_sqlserver/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     }
                  } else if ("SYBASE".equals(dbType)) {
                     System.out.println("执行SYBASE目标的脚本");
                     CommandTool.commandRtn("/data/infa_sybase/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     System.out.println("执行目标的脚本:完成");
                  } else if ("MYSQL".equals(dbType)) {
                     System.out.println("执行目标的脚本");
                     CommandTool.commandRtn("/data/infa_mysqlload/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     System.out.println("执行目标的脚本:完成");
                  } else if ("RAPIDSDB".equals(dbType)) {
                     System.out.println("执行目标的脚本");
                     CommandTool.commandRtn("/data/infa_rapidsdbload/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     System.out.println("执行目标的脚本:完成");
                  } else if ("TERADATA".equals(dbType)) {
                     System.out.println("执行目标的脚本");
                     CommandTool.commandRtn2("/data/infa_teradata/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     System.out.println("执行目标的脚本:完成");
                  } else if ("DB2".equals(dbType)) {
                     CommandTool.commandRtn("/data/infa_db2/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                  }

                  if ("TERADATA".equals(dbType)) {
                     Connection tconn = EncryptionMaskingImpl.this.getConnectionByDataSystemId(executeParam.getTargetDataSystem());
                     EncryptionMaskingImpl.this.droptable(t_tableName, tconn, executeParam.getTargetSchemaName());
                  }
               } catch (Exception e) {
                  e.printStackTrace();
               } finally {
                  countDownLatch.countDown();
               }

            }
         });
      }

   }

   public void executeTaskNormal(final ExecuteParam executeParam, String engineFlg) throws Exception {
      String taskid = executeParam.getTaskid();
      System.out.println(">>>>>>>>>>>>>>>>>TaskNormal<<<<<<<<<<<<<<<<<<");
      List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
      final EncryptionMasking encryptionmasking = (EncryptionMasking)this.encryptionmaskingDao.get(executeParam.getTaskid());
      Desensitizationtarget desensitizationtarget = executeParam.getDesensitizationtarget();
      this.updateTask_taskstatus(encryptionmasking.getId(), "1");
      final CountDownLatch engineCountDownLatch = new CountDownLatch(1);
      this.updateTask_taskstatus(encryptionmasking.getId(), "1");
      TCoreDatasystem datasystem = executeParam.getSourceDataSystem();
      String dbtype = datasystem.getDbtype();
      if ("FTP".equalsIgnoreCase(dbtype) || "SFTP".equalsIgnoreCase(dbtype) || "FILE".equalsIgnoreCase(dbtype) || "LOCALFILE".equalsIgnoreCase(dbtype)) {
         for(DesensitizationTable desensitizationTable : tableList) {
            this.downFile(encryptionmasking, desensitizationTable, executeParam);
            this.excelToFile(encryptionmasking, desensitizationTable, executeParam);
         }
      }

      try {
         this.taskExecutor.execute(new Runnable() {
            public void run() {
               try {
                  String xmlFileName = executeParam.getTaskNameReal();
                  System.out.println("xmlFileName is :" + xmlFileName);
                  System.out.println(">>>>>>>The client call engine start>>>>>>>>>>>>>>>>>>>>>");
                  DesensitizationEngineInterfaceImplService engineInterfaceImplService = new DesensitizationEngineInterfaceImplService();
                  DesensitizationEngineInterfaceImpl engineInterfaceImpl = (DesensitizationEngineInterfaceImpl)engineInterfaceImplService.getPort(DesensitizationEngineInterfaceImpl.class);
                  EngineParameter eParameter = new EngineParameter();
                  eParameter.setWorkflowName(xmlFileName);
                  eParameter.setGroupId(executeParam.getGroupId());
                  eParameter.setDataProcessType("DB_pwc_DB");
                  EngineResult er = engineInterfaceImpl.startWorkflowEx(eParameter);
                  System.out.println("result is " + er.getReStatus());
                  System.out.println(">>>>>>>The client call engine end>>>>>>>>>>>>>>>>>>>>>");
               } catch (Exception e) {
                  e.printStackTrace();
                  String taskid = encryptionmasking.getId();
                  EncryptionMaskingImpl.updataRunstatus(taskid);
                  System.out.println(executeParam.getTaskNameReal() + "任务 调用引擎失败!");
               } finally {
                  engineCountDownLatch.countDown();
               }

            }
         });
         System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + engineCountDownLatch.getCount());
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         this.updateTask_taskstatus(encryptionmasking.getId(), "3");
      }

      for(DesensitizationTable var18 : tableList) {
         ;
      }

      System.out.println(">>>>>>>>>>>>>>>插入监控详细信息表开始！");
      this.updateTask_taskstatus(encryptionmasking.getId(), "3");
      System.out.println(">>>>>>>>>>>>>>>任务已全部执行完成！同步表信息开始！");
      this.synTableParam(tableList, executeParam);
   }

   @Async
   public void executeTaskNormal(final ExecuteParam executeParam) throws Exception {
      String taskid = executeParam.getTaskid();
      EncryptionMasking encryptionmasking = this.queryTaskById(taskid);
      String taskname = encryptionmasking.getTaskname();
      new Properties();
      Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      String engineType = props.getProperty("masking_engine_type");
      if ("1".equals(engineType)) {
         this.executeTaskNormal(executeParam, "1");
      } else {
         System.out.println(">>>>>>>>>>>>>>>>>TaskNormal<<<<<<<<<<<<<<<<<<");
         List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
         final CountDownLatch countDownLatch = new CountDownLatch(tableList.size());
         final EncryptionMasking encryptionMasking = (EncryptionMasking)this.encryptionmaskingDao.get(executeParam.getTaskid());
         Desensitizationtarget desensitizationtarget = executeParam.getDesensitizationtarget();
         this.updateTask_taskstatus(encryptionMasking.getId(), "1");
         String[] typeSplit1 = encryptionMasking.getTasktype().split("to");
         String targetType1 = typeSplit1[1];

         for(final DesensitizationTable desensitizationTable : tableList) {
            String delimit = "";
            if (desensitizationTable.getFilename() != null && desensitizationTable.getFilename().contains(".xl")) {
               new TCoreFileStructurespliter();
               TCoreFileStructurespliter tCoreFileStructurespliter = (TCoreFileStructurespliter)this.tCoreFileStructurespliterDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", desensitizationTable.getFilestructureid())});
               delimit = tCoreFileStructurespliter.getDelimiters();
            }

            desensitizationTable.setNote(delimit);
            this.taskExecutor.execute(new Runnable() {
               public void run() {
                  String sessionId = "";
                  String status = "4";
                  String t_tableName = (encryptionMasking.getTableprefix() == null ? "" : encryptionMasking.getTableprefix()) + desensitizationTable.getT_tablename() + (encryptionMasking.getTablesuffix() == null ? "" : encryptionMasking.getTablesuffix());
                  String s_tableName = desensitizationTable.getTablename();
                  String workflowName = "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName;
                  DesensitizationFile desensitizationFile = executeParam.getDesensitizationFile();

                  try {
                     Properties props = new Properties();

                     try {
                        props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                     } catch (IOException e) {
                        e.printStackTrace();
                     }

                     if (!desensitizationTable.getFilename().contains(".xls") && desensitizationTable.getFilename().contains(".xlsx")) {
                     }

                     if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
                        System.out.println("---进入启动预计运行时间方法！");
                        String dataCount = "";
                        String tasktype = encryptionMasking.getTasktype();
                        if (!tasktype.startsWith("DB") && !tasktype.startsWith("HADOOP")) {
                           LineNumberReader lineNumberReader = new LineNumberReader(new FileReader("/data/infa_file/" + executeParam.getSourceFileDir() + "/" + desensitizationTable.getFilename()));
                           lineNumberReader.skip(Long.MAX_VALUE);
                           int lineNumber = lineNumberReader.getLineNumber() + 1;
                           dataCount = lineNumber + "";
                           System.out.println("数据源表" + s_tableName + "总行数：" + dataCount);
                        } else {
                           dataCount = EncryptionMaskingImpl.this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
                           System.out.println("数据源表" + s_tableName + "总行数：" + dataCount);
                        }

                        EncryptionMaskingImpl.this.redisService.set("dataCount:" + encryptionMasking.getTasknamereal() + "_" + s_tableName, dataCount);
                        System.out.println("预计运行时间，key=dataCount:" + encryptionMasking.getTasknamereal() + "_" + s_tableName + "，dataCount=" + dataCount);
                     }

                     EncryptionMaskingImpl.this.updateMonitorRunStatus(s_tableName, executeParam.getTableMap());
                     System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
                     sessionId = LoginWebService.returnStatus(executeParam.getInfoProperty());
                     System.out.println("调用启动工作流方法开始！tableName=" + s_tableName);
                     String dir = "d" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss") + ".txt";
                     TCoreDatasystem datasystem = executeParam.getSourceDataSystem();
                     if (datasystem != null) {
                        String dbtype = datasystem.getDbtype();
                        String username = "";
                        String password = "";
                        String host = "";
                        Integer port = 0;
                        String localpath = "";
                        String path = "";
                        String filename = desensitizationTable.getFilename();
                        switch (dbtype) {
                           case "FTP":
                              if ("".equals(filename) && desensitizationFile != null) {
                                 filename = t_tableName + desensitizationFile.getSuffix();
                              }

                              username = datasystem.getUsername();
                              password = datasystem.getPassword();
                              host = datasystem.getDbip();
                              port = Integer.parseInt(datasystem.getDbport());
                              localpath = XmlTool.getFileValue(dbtype + "/localdir") + "s_" + filename;
                              path = desensitizationTable.getFilepath();
                              boolean flag = false;
                              FtpTool.downFile(host, port, username, password, path, filename, localpath);
                              System.out.println("ftp:下载");
                              break;
                           case "SFTP":
                              if ("".equals(filename) && desensitizationFile != null) {
                                 filename = t_tableName + desensitizationFile.getSuffix();
                              }

                              username = datasystem.getUsername();
                              password = datasystem.getPassword();
                              host = datasystem.getDbip();
                              port = Integer.parseInt(datasystem.getDbport());
                              path = desensitizationTable.getFilepath();
                              localpath = XmlTool.getFileValue(dbtype + "/localdir") + "s_" + filename;
                              SFTPUtil sftp = new SFTPUtil(username, password, host, port);
                              ResultVO resultvo = SFTPUtil.login();
                              if (resultvo.getResult()) {
                                 try {
                                    sftp.download(path, filename, localpath);
                                 } catch (Exception var31) {
                                 }
                              }

                              sftp.logout();
                        }
                     }

                     int runId = EncryptionMaskingImpl.this.startWorkFlowEx(workflowName, executeParam.getInfoProperty(), executeParam.getFolderName(), sessionId);
                     String completeStatus = "0";
                     if (runId >= 0) {
                        completeStatus = EncryptionMaskingImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                     }

                     if ("1".equals(completeStatus)) {
                        System.out.println("表" + s_tableName + ",执行完成,通过阻塞方法！");
                        SessionBean sessionBean = EncryptionMaskingImpl.this.getLogForTaskMapping(executeParam.getFolderName(), executeParam.getInfoProperty(), executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
                        if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                           status = "1";
                        } else if ("FAILED".equals(sessionBean.getStatus())) {
                           status = "2";
                        } else if ("STOPPED".equals(sessionBean.getStatus())) {
                           status = "3";
                        } else {
                           status = "4";
                        }

                        System.out.println("执行更新监控表开始！tableName=" + s_tableName);
                        EncryptionMaskingImpl.this.updateMonitor(s_tableName, executeParam.getTableMap(), status, runId);
                        String[] typeSplit = encryptionMasking.getTasktype().split("to");
                        String targetType = typeSplit[1];
                        if ("FTP".equals(targetType) || "SFTP".equals(targetType)) {
                           System.out.println(">>>>>>>>>>>>>>>>>>>>上传类型为=" + encryptionMasking.getTasktype());
                           String fileDir = XmlTool.getFileValue(targetType + "/localdir");
                           System.out.println("fileDir=" + fileDir + "t_" + desensitizationTable.getTablename() + desensitizationFile.getSuffix());
                           String t_filepath = fileDir + "t_" + desensitizationTable.getTablename() + desensitizationFile.getSuffix();
                           String s_filepath = fileDir + "s_" + desensitizationTable.getFilename();
                           File file = new File(t_filepath);
                           String username = desensitizationFile.getUsername();
                           String password = desensitizationFile.getUserpassword();
                           String host = desensitizationFile.getIp();
                           Integer port = Integer.parseInt(desensitizationFile.getPort());
                           String filename = desensitizationTable.getFilename();
                           if ("".equals(filename)) {
                              filename = t_tableName + desensitizationFile.getSuffix();
                           }

                           if (desensitizationFile.getFiletype() == 2) {
                              System.out.println("上传文件类型为SFTP");
                              System.out.println("上传文件类型为FTP");
                              System.out.println("Filedir:" + desensitizationFile.getFiledir());
                              System.out.println("Filename" + filename);
                              filename = t_tableName + desensitizationFile.getSuffix();
                              SFTPUtil sftp = new SFTPUtil(username, password, host, port);
                              SFTPUtil.login();
                              InputStream is = new FileInputStream(file);
                              sftp.upload(desensitizationFile.getFiledir(), filename, is);
                              is.close();
                              sftp.logout();
                           } else if (desensitizationFile.getFiletype() == 1) {
                              filename = t_tableName + desensitizationFile.getSuffix();
                              System.out.println("上传文件类型为FTP");
                              System.out.println("Filedir:" + desensitizationFile.getFiledir());
                              System.out.println("Filename" + filename);
                              InputStream is = new FileInputStream(file);
                              FtpTool.uploadFile(host, port, username, password, desensitizationFile.getFiledir(), filename, is);
                              is.close();
                           }

                           FileTool.removeFile(s_filepath);
                           FileTool.removeFile(t_filepath);
                        }
                     }

                     LogoutWebService.returnStatus(sessionId, executeParam.getInfoProperty());
                  } catch (Exception e) {
                     e.printStackTrace();
                  } finally {
                     countDownLatch.countDown();
                     EncryptionMaskingImpl.this.updateTask_taskstatus(encryptionMasking.getId(), "0");
                  }

               }
            });
         }

         try {
            System.out.println(">>>>>>>>>>>>>>>当前活动线程数：" + this.taskExecutor.getActiveCount());
            System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + countDownLatch.getCount());
            countDownLatch.await();
            Boolean overFlg = true;
            List<Map<String, Object>> DesensitizationMonitorList = null;
            if (null != targetType1 && targetType1.contains("FILE")) {
            }

            System.out.println(">>>>>>>>>>>>>>>插入监控详细信息表开始！");
            this.insertMonitorInfo(tableList, executeParam.getInfoProperty(), executeParam.getFolderName(), executeParam.getTaskid(), executeParam.getTaskNameReal());
            this.updateTask_taskstatus(encryptionMasking.getId(), "3");
            System.out.println(">>>>>>>>>>>>>>>任务已全部执行完成！同步表信息开始！");
            this.synTableParam(tableList, executeParam);
         } catch (Exception e) {
            e.printStackTrace();
         }

      }
   }

   private void insertMonitorInfo(List<DesensitizationTable> desensitizationTableList, InfoProperty engine, String folderName, String taskid, String taskNameReal) {
      String mappingName = "";
      String workflowName = "";

      try {
         String sessionID = LoginWebService.returnStatus(engine);

         for(DesensitizationTable desensitizationTable : desensitizationTableList) {
            List<DesensitizationMonitor> desensitizationMonitorList = this.desensitizationMonitorDao.queryAll(Order.desc("groupid"), new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("sourcename", desensitizationTable.getTablename())});
            DesensitizationMonitor desensitizationMonitor = desensitizationMonitorList.size() > 0 ? (DesensitizationMonitor)desensitizationMonitorList.get(0) : null;
            workflowName = "wf_" + taskNameReal + "_" + desensitizationTable.getTablename();
            mappingName = "mp_" + taskNameReal + "_" + desensitizationTable.getTablename();
            SessionBean sb = MultiGetSessionStatisticsWebService.returnStatus(sessionID, engine, workflowName, mappingName, folderName, 0L);
            SessionBean sb1 = MultiGetSessionTimeWebService.returnStatus(sessionID, engine, workflowName, mappingName, folderName);
            List<SessionBeanDetail> sessionBeanDetailList = sb.getSessionBeanDetail();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

            for(SessionBeanDetail sessionBeanDetail : sessionBeanDetailList) {
               DesensitizationMonitorInfo desensitizationMonitorInfo = new DesensitizationMonitorInfo();
               desensitizationMonitorInfo.setInstancename(sessionBeanDetail.getWidgetInstanceName());
               desensitizationMonitorInfo.setMonitorid(desensitizationMonitor.getId());
               desensitizationMonitorInfo.setTaskid(taskid);
               desensitizationMonitorInfo.setStarttime(sdf.parse(sb1.getStart_time()));
               desensitizationMonitorInfo.setEndtime(sdf.parse(sb1.getEnd_time()));
               desensitizationMonitorInfo.setCreatetime(new Date());
               desensitizationMonitorInfo.setRunstatus(sb.getStatus());
               desensitizationMonitorInfo.setNumappliedrows(sessionBeanDetail.getApplied_rows() + "");
               desensitizationMonitorInfo.setNumaffectedrows(sessionBeanDetail.getAffected_rows() + "");
               desensitizationMonitorInfo.setNumrejectedrows(sessionBeanDetail.getRejected_rows() + "");
               desensitizationMonitorInfo.setThroughput(sessionBeanDetail.getThroughput());
               desensitizationMonitorInfo.setWidgettype(sessionBeanDetail.getTabletype());
               this.desensitizationMonitorInfoDao.save(desensitizationMonitorInfo);
            }
         }

         LogoutWebService.returnStatus(sessionID, engine);
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   private void createScriptFiletotarget(ExecuteParam executeParam, DesensitizationTable desensitizationTable, String dbType, TCoreDatasystem tCoreDatasystemTarget, List<DesensitizationTablecolumn> desensitizationTablecolumnList, Runtime rn) throws Exception {
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String tableName = (executeParam.getTableprefix() == null ? "" : executeParam.getTableprefix()) + desensitizationTable.getT_tablename() + (executeParam.getTablesuffix() == null ? "" : executeParam.getTablesuffix());
      String type = "target";
      if (executeParam.getTargettype() == null || !executeParam.getTargettype().equals("normal")) {
         TCoreConfig tcoreConfig = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", executeParam.getDataSourceId())});
         if (tcoreConfig != null || "oracledmp".equals(executeParam.getSourcetype())) {
            String filepath = "";
            if (tcoreConfig == null) {
               filepath = null;
            } else {
               filepath = tcoreConfig.getLocaldir();
            }

            if (filepath == null || filepath.equals("")) {
               filepath = XmlTool.getFileValue(dbType + "/db-fileDir");
            }

            System.out.println("创建目标脚本开始！____" + dbType);
            if ("SYBASE_IQ".equals(dbType)) {
               Process process = rn.exec("mkfifo " + filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator + tableName + ".pipe");
               process.waitFor();
               Map<String, String> lm = new HashMap();
               lm.put("user", tCoreDatasystemTarget.getUsername());
               lm.put("pwd", "1".equals(tCoreDatasystemTarget.getFlag()) ? AesTool.decrypt(tCoreDatasystemTarget.getPassword(), "ghca") : tCoreDatasystemTarget.getPassword());
               lm.put("ip", tCoreDatasystemTarget.getDbip());
               lm.put("port", tCoreDatasystemTarget.getDbport());
               lm.put("table", tableName);
               lm.put("schema", executeParam.getTargetSchemaName());
               lm.put("path", filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator + tableName + ".sh");
               String col = "";

               for(int i = 0; i < desensitizationTablecolumnList.size(); ++i) {
                  if (i != desensitizationTablecolumnList.size() - 1) {
                     col = col + ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(i)).getColumnname() + "|" + ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(i)).getColumntartype() + ",";
                  } else {
                     col = col + ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(i)).getColumnname() + "|" + ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(i)).getColumntartype();
                  }
               }

               lm.put("lm", col);
               lm.put("loadscripttype", executeParam.getLoadscripttype());
               SybaseIQLoadTableTool.executeLoadTable(lm);
            } else if ("MSSQLSERVER".equals(dbType)) {
               FileTool.createFolder(filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator);
               Map<String, String> bcpProperties = new HashMap();
               bcpProperties.put("user", tCoreDatasystemTarget.getUsername());
               bcpProperties.put("pwd", "1".equals(tCoreDatasystemTarget.getFlag()) ? AesTool.decrypt(tCoreDatasystemTarget.getPassword(), "ghca") : tCoreDatasystemTarget.getPassword());
               bcpProperties.put("ip", tCoreDatasystemTarget.getDbip());
               bcpProperties.put("dbschema", executeParam.getTargetSchemaName());
               bcpProperties.put("tablename", tableName);
               bcpProperties.put("database", tCoreDatasystemTarget.getDbservername());
               bcpProperties.put("taskname", executeParam.getTaskNameReal());
               bcpProperties.put("path", filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator + tableName + ".sh");
               TCoreConfig tcoreConfig1 = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", executeParam.getDataSourceId())});
               SqlServerBcpTableTool.createBcpScript(bcpProperties, tcoreConfig1);
            } else if ("SYBASE".equals(dbType)) {
               String sybase_file_path = filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator;
               FileTool.createFolder(filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator);
               Map<String, String> bcpProperties = new HashMap();
               bcpProperties.put("user", tCoreDatasystemTarget.getUsername());
               bcpProperties.put("pwd", "1".equals(tCoreDatasystemTarget.getFlag()) ? AesTool.decrypt(tCoreDatasystemTarget.getPassword(), "ghca") : tCoreDatasystemTarget.getPassword());
               bcpProperties.put("ip", tCoreDatasystemTarget.getDbip());
               bcpProperties.put("servername", tCoreDatasystemTarget.getServername());
               bcpProperties.put("dbschema", executeParam.getTargetSchemaName());
               bcpProperties.put("tablename", tableName);
               bcpProperties.put("database", tCoreDatasystemTarget.getDbservername());
               bcpProperties.put("taskname", executeParam.getTaskNameReal());
               bcpProperties.put("path", filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator + tableName + ".sh");
               bcpProperties.put("pagecode", tCoreDatasystemTarget.getPagecode());
               CommandTool.command("mkfifo  " + sybase_file_path + tableName + ".pipe");
               CommandTool.command("chmod -R 777 " + sybase_file_path + tableName + ".pipe");
               System.out.println(">>>>>>>>>>>>>>SqlServerBcpTableTool.createBcpScript(bcpProperties,executeParam.getTaskid()); start");
               SybaseBcpTableTool.createBcpInScript(bcpProperties);
            } else if ("MYSQL".equals(dbType)) {
               String mysql_file_path = filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator;
               String formatSet = "";
               String columnNameStr = "(";
               String columnName = "";
               String nullIf = "";

               for(DesensitizationTablecolumn desensitizationTablecolumn : desensitizationTablecolumnList) {
                  columnName = desensitizationTablecolumn.getColumnname();
                  if (!"NUMBER".equals(desensitizationTablecolumn.getColumntype()) && !"SMALLINT".equals(desensitizationTablecolumn.getColumntype()) && !"MEDIUMINT".equals(desensitizationTablecolumn.getColumntype()) && !"INT".equals(desensitizationTablecolumn.getColumntype()) && !"INTEGER".equals(desensitizationTablecolumn.getColumntype()) && !"BIGINT".equals(desensitizationTablecolumn.getColumntype()) && !"BIT".equals(desensitizationTablecolumn.getColumntype()) && !"DOUBLE".equals(desensitizationTablecolumn.getColumntype()) && !"FLOAT".equals(desensitizationTablecolumn.getColumntype()) && !"DECIMAL".equals(desensitizationTablecolumn.getColumntype()) && !"TINYINT".equals(desensitizationTablecolumn.getColumntype()) && !"DATE".equals(desensitizationTablecolumn.getColumntype()) && !"TIME".equals(desensitizationTablecolumn.getColumntype()) && !"YEAR".equals(desensitizationTablecolumn.getColumntype()) && !"TIMESTAMP".equals(desensitizationTablecolumn.getColumntype()) && !"DATETIME".equals(desensitizationTablecolumn.getColumntype()) && !"TINYBLOB".equals(desensitizationTablecolumn.getColumntype()) && !"BLOB".equals(desensitizationTablecolumn.getColumntype()) && !"MEDIUMBLOB".equals(desensitizationTablecolumn.getColumntype()) && !"LONGBLOB".equals(desensitizationTablecolumn.getColumntype()) && !"TEXT".equals(desensitizationTablecolumn.getColumntype()) && !"MEDIUMTEXT".equals(desensitizationTablecolumn.getColumntype()) && !"LONGTEXT".equals(desensitizationTablecolumn.getColumntype()) && !"BINARY".equals(desensitizationTablecolumn.getColumntype()) && !"VARBINARY".equals(desensitizationTablecolumn.getColumntype())) {
                     columnNameStr = columnNameStr + columnName + ", ";
                  } else {
                     columnNameStr = columnNameStr + "@" + columnName + ", ";
                     nullIf = nullIf + columnName + " = nullif(@" + columnName + ",''),\n";
                  }
               }

               columnNameStr = columnNameStr.substring(0, columnNameStr.length() - 2);
               if (!"".equals(nullIf) && nullIf != null) {
                  nullIf = nullIf.substring(0, nullIf.length() - 2);
                  formatSet = columnNameStr + ")\nset\n" + nullIf + "\n;";
               }

               if (!FileTool.isFileExit(mysql_file_path)) {
                  FileTool.createFolder(mysql_file_path);
               }

               Map<String, String> mysqlloadparam = new HashMap();
               mysqlloadparam.put("username", tCoreDatasystemTarget.getUsername());
               mysqlloadparam.put("password", "1".equals(tCoreDatasystemTarget.getFlag()) ? AesTool.decrypt(tCoreDatasystemTarget.getPassword(), "ghca") : tCoreDatasystemTarget.getPassword());
               mysqlloadparam.put("hostname", tCoreDatasystemTarget.getDbip());
               mysqlloadparam.put("filepath", mysql_file_path + tableName + ".pipe");
               mysqlloadparam.put("path", mysql_file_path);
               mysqlloadparam.put("database", executeParam.getTargetSchemaName());
               mysqlloadparam.put("tablename", tableName);
               mysqlloadparam.put("taskname", executeParam.getTaskNameReal());
               mysqlloadparam.put("delimiter", props.getProperty("mysql_load_col_split"));
               mysqlloadparam.put("formatSet", formatSet);
               CommandTool.command("mkfifo  " + mysql_file_path + tableName + ".pipe");
               MysqlLoadTableTool.executeLoadTable_new(mysqlloadparam);
            } else if ("RAPIDSDB".equals(dbType)) {
               String rapidsdb_file_path = filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator;
               String formatSet = "";
               String columnNameStr = "(";
               String columnName = "";
               String nullIf = "";

               for(DesensitizationTablecolumn desensitizationTablecolumn : desensitizationTablecolumnList) {
                  columnName = desensitizationTablecolumn.getColumnname();
                  if (!"NUMBER".equals(desensitizationTablecolumn.getColumntype()) && !"SMALLINT".equals(desensitizationTablecolumn.getColumntype()) && !"MEDIUMINT".equals(desensitizationTablecolumn.getColumntype()) && !"INT".equals(desensitizationTablecolumn.getColumntype()) && !"INTEGER".equals(desensitizationTablecolumn.getColumntype()) && !"BIGINT".equals(desensitizationTablecolumn.getColumntype()) && !"BIT".equals(desensitizationTablecolumn.getColumntype()) && !"DOUBLE".equals(desensitizationTablecolumn.getColumntype()) && !"FLOAT".equals(desensitizationTablecolumn.getColumntype()) && !"DECIMAL".equals(desensitizationTablecolumn.getColumntype())) {
                     columnNameStr = columnNameStr + columnName + ", ";
                  } else {
                     columnNameStr = columnNameStr + "@" + columnName + ", ";
                     nullIf = nullIf + columnName + " = nullif(@" + columnName + ",''),\n";
                  }
               }

               columnNameStr = columnNameStr.substring(0, columnNameStr.length() - 2);
               if (!"".equals(nullIf) && nullIf != null) {
                  nullIf = nullIf.substring(0, nullIf.length() - 2);
                  formatSet = columnNameStr + ")\nset\n" + nullIf + "\n;";
               }

               if (!FileTool.isFileExit(rapidsdb_file_path)) {
                  FileTool.createFolder(rapidsdb_file_path);
               }

               Map<String, String> rapidsdbloadparam = new HashMap();
               rapidsdbloadparam.put("username", tCoreDatasystemTarget.getUsername());
               rapidsdbloadparam.put("password", "");
               rapidsdbloadparam.put("hostname", tCoreDatasystemTarget.getDbip());
               rapidsdbloadparam.put("filepath", rapidsdb_file_path + tableName + ".pipe");
               rapidsdbloadparam.put("path", rapidsdb_file_path);
               rapidsdbloadparam.put("database", executeParam.getTargetSchemaName());
               rapidsdbloadparam.put("tablename", tableName);
               rapidsdbloadparam.put("taskname", executeParam.getTaskNameReal());
               rapidsdbloadparam.put("delimiter", props.getProperty("rapidsdb_load_col_split"));
               rapidsdbloadparam.put("formatSet", formatSet);
               CommandTool.command("mkfifo  " + rapidsdb_file_path + tableName + ".pipe");
               RapidsdbLoadTableTool.executeLoadTable_new(rapidsdbloadparam);
            } else if ("TERADATA".equals(dbType)) {
               String teradata_file_path = filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator;
               if (!FileTool.isFileExit(teradata_file_path)) {
                  FileTool.createFolder(teradata_file_path);
               }

               List<String> nameList = new ArrayList();
               List<String> lengthList = new ArrayList();
               List<String> typeList = new ArrayList();

               for(DesensitizationTablecolumn sourceTableCol : desensitizationTablecolumnList) {
                  nameList.add(sourceTableCol.getColumnname());
                  lengthList.add(sourceTableCol.getColumnlength());
                  typeList.add(sourceTableCol.getColumntartype());
               }

               StringBuffer definesb = new StringBuffer();
               StringBuffer sqlsb = new StringBuffer();
               StringBuffer sqlvalue = new StringBuffer();
               Map<String, String> paramMapload = new HashMap();
               paramMapload.put("ip", tCoreDatasystemTarget.getDbip());
               paramMapload.put("port", tCoreDatasystemTarget.getDbport());
               paramMapload.put("user", tCoreDatasystemTarget.getUsername());
               paramMapload.put("pwd", "1".equals(tCoreDatasystemTarget.getFlag()) ? AesTool.decrypt(tCoreDatasystemTarget.getPassword(), "ghca") : tCoreDatasystemTarget.getPassword());
               paramMapload.put("schema", executeParam.getTargetSchemaName());
               paramMapload.put("table", tableName);
               paramMapload.put("path", teradata_file_path);
               paramMapload.put("in_type", "1");
               String dbcode = tCoreDatasystemTarget.getDbtype();
               String servername = tCoreDatasystemTarget.getDbservername();
               String url = EdbType.getUrlByEdbcode(dbcode, tCoreDatasystemTarget.getDbip(), tCoreDatasystemTarget.getDbport(), servername, tCoreDatasystemTarget.getPagecode());
               String driver = EdbType.getEdbTypeByDbcode(dbcode).getDbdriver();
               paramMapload.put("driver", driver);
               paramMapload.put("url", url);
               StringBuffer create_sql = FileTool.readFileContent(teradata_file_path + tableName + "create_sql.txt");
               paramMapload.put("create_sql", create_sql.toString());
               CommandTool.command("mkfifo " + teradata_file_path + tableName + ".pipe");
               switch (executeParam.getTargettype()) {
                  case "multiload":
                     sqlsb.append("(");
                     sqlvalue.append("values(");

                     for(int i = 0; i < nameList.size(); ++i) {
                        definesb.append("\n.FIELD in_" + (String)nameList.get(i) + " * varchar(" + TeradataLoadTableTool.getcolumNumber((String)typeList.get(i), (String)lengthList.get(i)) + ");");
                        sqlsb.append((String)nameList.get(i) + ",");
                        sqlvalue.append(":in_" + (String)nameList.get(i) + ",");
                     }

                     sqlsb.deleteCharAt(sqlsb.length() - 1);
                     sqlvalue.deleteCharAt(sqlvalue.length() - 1);
                     sqlvalue.append(");");
                     sqlsb.append(")");
                     paramMapload.put("define", definesb.toString());
                     paramMapload.put("sql", sqlsb.toString() + sqlvalue.toString());
                     Connection tconn = this.getConnectionByDataSystemId(executeParam.getTargetDataSystem());
                     JdbcTool.dropTable(tconn, executeParam.getTargetSchemaName(), "ET_" + tableName);
                     JdbcTool.dropTable(tconn, executeParam.getTargetSchemaName(), "WT_" + tableName);
                     JdbcTool.dropTable(tconn, executeParam.getTargetSchemaName(), "UV_" + tableName);
                     JdbcTool.dropTable(tconn, executeParam.getTargetSchemaName(), tableName + "_log");
                     TeradataLoadTableTool.createmultiLoadTableSh(paramMapload);
                     break;
                  case "fastload":
                     for(int i = 0; i < nameList.size(); ++i) {
                        definesb.append((String)nameList.get(i) + "(varchar(" + TeradataLoadTableTool.getcolumNumber((String)typeList.get(i), (String)lengthList.get(i)) + ")),");
                     }

                     paramMapload.put("define", definesb.substring(0, definesb.length() - 1));
                     TeradataLoadTableTool.createfastLoadTableSh(paramMapload);
               }
            } else if ("DB2".equals(dbType)) {
               FileTool.createFolder(filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator);
               Map<String, String> db2Properties = new HashMap();
               db2Properties.put("user", tCoreDatasystemTarget.getUsername());
               db2Properties.put("pwd", "1".equals(tCoreDatasystemTarget.getFlag()) ? AesTool.decrypt(tCoreDatasystemTarget.getPassword(), "ghca") : tCoreDatasystemTarget.getPassword());
               db2Properties.put("ip", tCoreDatasystemTarget.getDbip());
               db2Properties.put("port", tCoreDatasystemTarget.getDbport());
               db2Properties.put("dbschema", executeParam.getTargetSchemaName());
               db2Properties.put("tablename", tableName);
               db2Properties.put("database", tCoreDatasystemTarget.getDbservername());
               db2Properties.put("taskname", executeParam.getTaskNameReal());
               db2Properties.put("path", filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator);
               db2Properties.put("linkname", tCoreDatasystemTarget.getDblinkname());
               DB2LoadTableTool.executeLoadTable(db2Properties);
            } else if ("ORACLE".equals(dbType)) {
               DmpTool.createTarPipeFile(executeParam.getTaskNameReal(), tableName);
            } else if ("GREENPLUM".equals(dbType)) {
               String greenplum_file_path = filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator;
               if (!FileTool.isFileExit(greenplum_file_path)) {
                  FileTool.createFolder(greenplum_file_path);
               }

               TCoreConfig tcoreConfig1 = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", executeParam.getDataSourceId())});
               if (tcoreConfig1 != null) {
                  String loadTableColSplit = tcoreConfig1.getTargetdelimiter();
                  if (loadTableColSplit == null || filepath.equals("")) {
                     loadTableColSplit = XmlTool.getFileValue(dbType + "/db-targetdelimiter");
                  }
               }

               Map<String, String> greenplumloadparam = new HashMap();
               greenplumloadparam.put("!VERSION", "1.0.0.1");
               greenplumloadparam.put("!DATABASE", tCoreDatasystemTarget.getDbservername());
               greenplumloadparam.put("!USER", tCoreDatasystemTarget.getUsername());
               greenplumloadparam.put("!HOST", tCoreDatasystemTarget.getDbip());
               greenplumloadparam.put("!TARGETPORT", tCoreDatasystemTarget.getDbport());
               greenplumloadparam.put("!LOCAL_HOSTNAME", getIpAddress());
               greenplumloadparam.put("!SOURCEPORT", "8081");
               greenplumloadparam.put("!FILE", greenplum_file_path + tableName + ".pipe");
               greenplumloadparam.put("!FORMAT", "text");
               greenplumloadparam.put("!DELIMITER", "#");
               greenplumloadparam.put("!TABLE", executeParam.getTargetSchemaName() + "." + tableName);
               greenplumloadparam.put("table", tableName);
               greenplumloadparam.put("tablename", tableName);
               greenplumloadparam.put("outfilepath", greenplum_file_path + tableName + ".yml");
               greenplumloadparam.put("path", greenplum_file_path);
               CommandTool.command("mkfifo  " + greenplum_file_path + tableName + ".pipe");
               GreenplumLoadTableTool.readYamlFile(greenplumloadparam);
            }
         }
      }

   }

   private void createScriptFiletoSource(ExecuteParam executeParam, DesensitizationTable desensitizationTable, String dbType, TCoreDatasystem tCoreDatasystemSource, List<DesensitizationTablecolumn> desensitizationTablecolumnList, Runtime rn) throws Exception {
      String tableName = desensitizationTable.getTablename();
      String type = "source";
      if (executeParam.getSourcetype() == null || !executeParam.getSourcetype().equals("normal")) {
         TCoreConfig tcoreConfig = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", executeParam.getDataSourceId())});
         if (tcoreConfig != null) {
            String filepath = tcoreConfig.getFileDir();
            if (filepath == null || filepath.equals("")) {
               filepath = XmlTool.getFileValue(dbType + "/db-fileDir");
            }

            System.out.println("创建源脚本开始！____" + dbType);
            if (!"SYBASE_IQ".equals(dbType)) {
               if ("MSSQLSERVER".equals(dbType)) {
                  List<Map<String, String>> columns = new ArrayList();

                  for(int j = 0; j < desensitizationTablecolumnList.size(); ++j) {
                     Map<String, String> columnMap = new HashMap();
                     String colName = ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumnname();
                     String colType = ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumntype();
                     columnMap.put("name", colName);
                     columnMap.put("type", colType);
                     columns.add(columnMap);
                  }

                  FileTool.createFolder(filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator);
                  Map<String, Object> bcpProperties = new HashMap();
                  bcpProperties.put("user", tCoreDatasystemSource.getUsername());
                  bcpProperties.put("pwd", "1".equals(tCoreDatasystemSource.getFlag()) ? AesTool.decrypt(tCoreDatasystemSource.getPassword(), "ghca") : tCoreDatasystemSource.getPassword());
                  bcpProperties.put("ip", tCoreDatasystemSource.getDbip());
                  bcpProperties.put("dbschema", executeParam.getSourceSchemaName());
                  bcpProperties.put("tablename", tableName);
                  bcpProperties.put("database", tCoreDatasystemSource.getDbservername());
                  bcpProperties.put("taskname", executeParam.getTaskNameReal());
                  bcpProperties.put("path", filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator + tableName + ".sh");
                  bcpProperties.put("columns", columns);
                  SqlServerBcpTableTool.createBcpExportScript(bcpProperties);
               } else if ("TERADATA".equals(dbType)) {
                  List<String> colNameLst = new ArrayList();
                  Integer totalLen = 0;

                  for(int j = 0; j < desensitizationTablecolumnList.size(); ++j) {
                     totalLen = totalLen + 3;
                     String colName = ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumnname();
                     String colType = ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumntype();
                     String colLength = ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumnlength();
                     String colScale = ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumnscale() == null ? "" : ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumnscale();
                     colName = TeradataTool.teradataTypetoVarchar(colName, colType, colLength);
                     String realColLength = TeradataTool.teradataTypeLength(colType, colLength, colScale);
                     if (StringUtils.isNotBlank(realColLength)) {
                        totalLen = totalLen + Integer.valueOf(realColLength);
                     }

                     colNameLst.add(colName);
                  }

                  String colNamesStr = StringUtils.join(colNameLst.toArray(), "||'|'||");
                  colNamesStr = "(cast(" + colNamesStr + " as char(" + totalLen + ")))";
                  Map<String, String> paramMap = new HashMap();
                  paramMap.put("schema", executeParam.getSourceSchemaName());
                  paramMap.put("tablename", desensitizationTable.getTablename());
                  paramMap.put("colNamesStr", colNamesStr);
                  String source_pipe_path = filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator;
                  if (!FileTool.isFileExit(source_pipe_path)) {
                     FileTool.createFolder(source_pipe_path);
                  }

                  paramMap.put("source_pipe_path", source_pipe_path);
                  paramMap.put("teradataServersIp", tCoreDatasystemSource.getDbip());
                  paramMap.put("teradataServersUser", tCoreDatasystemSource.getUsername());
                  paramMap.put("teradataServerspwd", "1".equals(tCoreDatasystemSource.getFlag()) ? AesTool.decrypt(tCoreDatasystemSource.getPassword(), "ghca") : tCoreDatasystemSource.getPassword());
                  paramMap.put("taskname", executeParam.getTaskNameReal());
                  Connection tconn = this.getConnectionByDataSystemId(executeParam.getSourceDataSystem());
                  JdbcTool.dropTable(tconn, executeParam.getSourceSchemaName(), tableName + "_log");
                  CommandTool.command("mkfifo  " + source_pipe_path + tableName + ".pipe");
                  System.out.println("创建Teradata_source_pipe");
                  TeradataTool.createTerdataExportScript_new(paramMap);
               } else if ("HIVE".equals(dbType)) {
                  String source_pipe_path = filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator;
                  if (!FileTool.isFileExit(source_pipe_path)) {
                     FileTool.createFolder(source_pipe_path);
                  }

                  CommandTool.commandRtn2("mkfifo  " + source_pipe_path + tableName + ".pipe");
               } else if ("MYSQL".equals(dbType)) {
                  String mysql_file_path = filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator;
                  if (!FileTool.isFileExit(mysql_file_path)) {
                     FileTool.createFolder(mysql_file_path);
                  }

                  Map<String, String> mysqlloadparam = new HashMap();
                  mysqlloadparam.put("username", tCoreDatasystemSource.getUsername());
                  mysqlloadparam.put("password", "1".equals(tCoreDatasystemSource.getFlag()) ? AesTool.decrypt(tCoreDatasystemSource.getPassword(), "ghca") : tCoreDatasystemSource.getPassword());
                  mysqlloadparam.put("hostname", tCoreDatasystemSource.getDbip());
                  mysqlloadparam.put("filepath", mysql_file_path + tableName + ".pipe");
                  mysqlloadparam.put("path", mysql_file_path);
                  mysqlloadparam.put("database", executeParam.getSourceSchemaName());
                  mysqlloadparam.put("tablename", tableName);
                  mysqlloadparam.put("taskname", executeParam.getTaskNameReal());
                  List<String> columnNameList = new ArrayList();

                  for(DesensitizationTablecolumn desensitizationTablecolumn : desensitizationTablecolumnList) {
                     String colName = desensitizationTablecolumn.getColumnname();
                     String sourceColName = desensitizationTablecolumn.getColumntype();
                     String targetDbtype = executeParam.getTargetDataSystem().getDbtype();
                     String columnType = desensitizationTablecolumn.getColumntartype();
                     Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                     String engineType = props.getProperty("masking_engine_type");
                     if ("1".equals(engineType)) {
                        if ("bit".equalsIgnoreCase(sourceColName)) {
                           StringBuffer buffer = new StringBuffer();
                           buffer.append("(case when " + colName + " = 0 then '0' ");
                           buffer.append("when " + colName + " > 0 then '1' ");
                           buffer.append("else null end) as " + colName);
                           columnNameList.add(buffer.toString());
                        } else if ("bit".equalsIgnoreCase(sourceColName)) {
                           StringBuffer buffer = new StringBuffer();
                           buffer.append("(case when " + colName + " = 0 then 0 ");
                           buffer.append("when " + colName + " > 0 then 1 ");
                           buffer.append("else null end) as " + colName);
                           columnNameList.add(buffer.toString());
                        } else if (!"TINYBLOB".equalsIgnoreCase(sourceColName) && !"BLOB".equalsIgnoreCase(sourceColName) && !"LONGBLOB".equalsIgnoreCase(sourceColName) && !"MEDIUMBLOB".equalsIgnoreCase(sourceColName)) {
                           columnNameList.add(colName);
                        } else {
                           columnNameList.add("null as " + colName);
                        }
                     } else {
                        columnNameList.add(colName);
                     }
                  }

                  mysqlloadparam.put("columnNameList", columnNameList.toString().replace("[", "").replace("]", ""));
                  CommandTool.command("mkfifo  " + mysql_file_path + tableName + ".pipe");
                  MysqlLoadTableTool.executeExportFileTable(mysqlloadparam);
               } else if ("RAPIDSDB".equals(dbType)) {
                  String rapidsdb_file_path = filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator;
                  if (!FileTool.isFileExit(rapidsdb_file_path)) {
                     FileTool.createFolder(rapidsdb_file_path);
                  }

                  Map<String, String> rapidsdbloadparam = new HashMap();
                  rapidsdbloadparam.put("username", tCoreDatasystemSource.getUsername());
                  rapidsdbloadparam.put("password", "");
                  rapidsdbloadparam.put("hostname", tCoreDatasystemSource.getDbip());
                  rapidsdbloadparam.put("filepath", rapidsdb_file_path + tableName + ".pipe");
                  rapidsdbloadparam.put("path", rapidsdb_file_path);
                  rapidsdbloadparam.put("database", executeParam.getSourceSchemaName());
                  rapidsdbloadparam.put("tablename", tableName);
                  rapidsdbloadparam.put("taskname", executeParam.getTaskNameReal());
                  List<String> columnNameList = new ArrayList();

                  for(DesensitizationTablecolumn desensitizationTablecolumn : desensitizationTablecolumnList) {
                     String colName = desensitizationTablecolumn.getColumnname();
                     String targetDbtype = executeParam.getTargetDataSystem().getDbtype();
                     String columnType = desensitizationTablecolumn.getColumntartype();
                     String sourceColName = desensitizationTablecolumn.getColumntype();
                     Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                     String engineType = props.getProperty("masking_engine_type");
                     if ("1".equals(engineType)) {
                        if ("bit".equalsIgnoreCase(sourceColName)) {
                           StringBuffer buffer = new StringBuffer();
                           buffer.append("(case when " + colName + " = 0 then '0' ");
                           buffer.append("when " + colName + " > 0 then '1' ");
                           buffer.append("else null end) as " + colName);
                           columnNameList.add(buffer.toString());
                        } else if ("bit".equalsIgnoreCase(sourceColName)) {
                           StringBuffer buffer = new StringBuffer();
                           buffer.append("(case when " + colName + " = 0 then 0 ");
                           buffer.append("when " + colName + " > 0 then 1 ");
                           buffer.append("else null end) as " + colName);
                           columnNameList.add(buffer.toString());
                        } else if (!"TINYBLOB".equalsIgnoreCase(sourceColName) && !"BLOB".equalsIgnoreCase(sourceColName) && !"LONGBLOB".equalsIgnoreCase(sourceColName) && !"MEDIUMBLOB".equalsIgnoreCase(sourceColName)) {
                           columnNameList.add(colName);
                        } else {
                           columnNameList.add("null as " + colName);
                        }
                     } else {
                        columnNameList.add(colName);
                     }
                  }

                  rapidsdbloadparam.put("columnNameList", columnNameList.toString().replace("[", "").replace("]", ""));
                  CommandTool.command("mkfifo  " + rapidsdb_file_path + tableName + ".pipe");
                  RapidsdbLoadTableTool.executeExportFileTable(rapidsdbloadparam);
               } else if ("SYBASE".equals(dbType)) {
                  StringBuilder sqlsb = new StringBuilder();
                  sqlsb.append("create or replace view " + executeParam.getSourceSchemaName() + ".v_" + tableName);
                  sqlsb.append(" as ");
                  sqlsb.append(" select ");

                  for(int i = 0; i < desensitizationTablecolumnList.size(); ++i) {
                     String columnName = ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(i)).getColumnname();
                     String columnType = ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(i)).getColumntartype();
                     if ("date".equalsIgnoreCase(columnType)) {
                        sqlsb.append("convert(varchar(4),year(" + columnName + ")) + '-' +convert(varchar(2),month(" + columnName + ")) + '-' + convert(varchar(2),day(" + columnName + ")) + ' ' +convert(varchar(24)," + columnName + ",108) as " + columnName);
                     } else {
                        sqlsb.append(columnName);
                     }

                     if (i != desensitizationTablecolumnList.size() - 1) {
                        sqlsb.append(",");
                     }
                  }

                  sqlsb.append(" from  " + executeParam.getSourceSchemaName() + "." + tableName);
                  Connection tconn = this.getConnectionByDataSystemId(executeParam.getSourceDataSystem());
                  JdbcTool.createTable(tconn, sqlsb.toString());
                  String sybase_file_path = filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator;
                  FileTool.createFolder(filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator);
                  Map<String, String> bcpProperties = new HashMap();
                  bcpProperties.put("user", tCoreDatasystemSource.getUsername());
                  bcpProperties.put("pwd", "1".equals(tCoreDatasystemSource.getFlag()) ? AesTool.decrypt(tCoreDatasystemSource.getPassword(), "ghca") : tCoreDatasystemSource.getPassword());
                  bcpProperties.put("ip", tCoreDatasystemSource.getDbip());
                  bcpProperties.put("servername", tCoreDatasystemSource.getServername());
                  bcpProperties.put("charset", tCoreDatasystemSource.getPagecode());
                  bcpProperties.put("dbschema", executeParam.getSourceSchemaName());
                  bcpProperties.put("tablename", tableName);
                  bcpProperties.put("database", tCoreDatasystemSource.getDbservername());
                  bcpProperties.put("taskname", executeParam.getTaskNameReal());
                  bcpProperties.put("path", filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator + tableName + ".sh");
                  CommandTool.command("mkfifo  " + sybase_file_path + tableName + ".pipe");
                  CommandTool.command("chmod -R 777 " + sybase_file_path + tableName + ".pipe");
                  System.out.println(">>>>>>>>>>>>>>SqlServerBcpTableTool.createBcpOutScript(bcpProperties); start");
                  SybaseBcpTableTool.createBcpOutScript(bcpProperties);
               }
            }
         } else if ("ORACLE".equals(dbType)) {
            DmpTool.createPipeFile(executeParam.getTaskNameReal(), tableName);
         }
      }

   }

   public String startWorkFlow(ExecuteParam executeParam, String tableName, String sessionId) {
      String workFlowName = "wf_" + executeParam.getTaskNameReal() + "_" + tableName;
      String returnStatus = "FAIL";

      try {
         if (!"".equals(workFlowName) && workFlowName != null && !workFlowName.startsWith("wf_")) {
            workFlowName = "wf_" + workFlowName;
         }

         returnStatus = StartWorkFlowWebService.returnStatus(sessionId, executeParam.getInfoProperty(), workFlowName, executeParam.getFolderName());
         return returnStatus;
      } catch (Fault e) {
         e.printStackTrace();
         return "FAIL";
      } catch (Exception e) {
         e.printStackTrace();
         return "FAIL";
      }
   }

   public int startWorkFlowEx(String workflowName, InfoProperty engine, String folderName, String sessionId) {
      if (!"".equals(workflowName) && workflowName != null && !workflowName.startsWith("wf_")) {
         workflowName = "wf_" + workflowName;
      }

      int runId = -1;
      DataIntegrationInterface webService = (new DataIntegrationService()).getDataIntegration();
      DIServiceInfo dIServiceInfo = new DIServiceInfo();
      dIServiceInfo.setDomainName(engine.getDomainname());
      dIServiceInfo.setServiceName(engine.getInteservicename());
      TypeStartWorkflowExRequest typeStartWorkflowExRequest = new TypeStartWorkflowExRequest();
      typeStartWorkflowExRequest.setDIServiceInfo(dIServiceInfo);
      typeStartWorkflowExRequest.setFolderName(folderName);
      typeStartWorkflowExRequest.setWorkflowName(workflowName);
      typeStartWorkflowExRequest.setRequestMode(ETaskRunMode.RECOVERY);

      try {
         SessionHeader sessionHeader = new SessionHeader();
         sessionHeader.setSessionId(sessionId);
         TypeStartWorkflowExResponse startWorkflowEx = webService.startWorkflowEx(typeStartWorkflowExRequest, sessionHeader);
         runId = startWorkflowEx.getRunId();
      } catch (Exception e) {
         e.printStackTrace();
      }

      return runId;
   }

   public void updateMonitor(String tableNane, Map<String, String> tableMap, String status, int runid) {
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String sqlurl = props.get("jdbc.url").toString();
         String username = props.get("jdbc.user").toString();
         String password = props.get("jdbc.password").toString();
         String driver = props.get("jdbc.driver").toString();
         Connection connection = JdbcTool.getConnection(driver, sqlurl, username, password);
         Statement statement = connection.createStatement();
         String sql = "UPDATE desensitization_monitor SET flag = '" + status + "',runid = '" + runid + "' WHERE id = '" + (String)tableMap.get(tableNane) + "'";
         System.out.println("update:desensitization_monitor=" + sql);
         statement.executeUpdate(sql.toString());
         statement.close();
         connection.close();
      } catch (IOException e) {
         e.printStackTrace();
      } catch (SQLException e) {
         e.printStackTrace();
      }

   }

   public void updateMonitorRunStatus(String tableNane, Map<String, String> tableMap) {
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String sqlurl = props.get("jdbc.url").toString();
         String username = props.get("jdbc.user").toString();
         String password = props.get("jdbc.password").toString();
         String driver = props.get("jdbc.driver").toString();
         Connection connection = JdbcTool.getConnection(driver, sqlurl, username, password);
         Statement statement = connection.createStatement();
         String sql = "UPDATE desensitization_monitor SET runstatus = 1,executetime = now() WHERE id = '" + (String)tableMap.get(tableNane) + "'";
         System.out.println("updateStatus:desensitization_monitor=" + sql);
         statement.executeUpdate(sql.toString());
         statement.close();
         connection.close();
      } catch (IOException e) {
         e.printStackTrace();
      } catch (SQLException e) {
         e.printStackTrace();
      }

   }

   public void updateEngineMonitor(String taskid, String groupid, String status) {
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String sqlurl = props.get("jdbc.url").toString();
         String username = props.get("jdbc.user").toString();
         String password = props.get("jdbc.password").toString();
         String driver = props.get("jdbc.driver").toString();
         Connection connection = JdbcTool.getConnection(driver, sqlurl, username, password);
         Statement statement = connection.createStatement();
         String sql = "UPDATE desensitization_monitor SET flag = '" + status + "' WHERE taskid = '" + taskid + "' and groupid = '" + groupid + "' and flag not in ('1','2')";
         System.out.println("update:desensitization_monitor=" + sql);
         statement.executeUpdate(sql.toString());
         statement.close();
         connection.close();
      } catch (IOException e) {
         e.printStackTrace();
      } catch (SQLException e) {
         e.printStackTrace();
      }

   }

   public String workflowTaskCompleteMonitor(InfoProperty engine, String folderName, String workflowName, String sessionId) {
      if (!"".equals(workflowName) && workflowName != null && !workflowName.startsWith("wf_")) {
         workflowName = "wf_" + workflowName;
      }

      String completeStatus = "0";
      DataIntegrationInterface webService = (new DataIntegrationService()).getDataIntegration();
      DIServiceInfo dIServiceInfo = new DIServiceInfo();
      dIServiceInfo.setDomainName(engine.getDomainname());
      dIServiceInfo.setServiceName(engine.getInteservicename());
      WorkflowRequest workflowRequest = new WorkflowRequest();
      workflowRequest.setDIServiceInfo(dIServiceInfo);
      workflowRequest.setFolderName(folderName);
      workflowRequest.setWorkflowName(workflowName);

      try {
         SessionHeader sessionHeader = new SessionHeader();
         sessionHeader.setSessionId(sessionId);
         webService.scheduleWorkflow(workflowRequest, sessionHeader);
         webService.waitTillWorkflowComplete(workflowRequest, sessionHeader);
      } catch (Exception var10) {
         System.out.println("该工作流未运行，或者已完成！");
      }

      completeStatus = "1";
      return completeStatus;
   }

   public String returnBaseType(TCoreDatasystem targettype, TCoreDatasystem sourcetype) {
      String type = "";
      if (sourcetype == null) {
         type = "FILE";
      } else if (sourcetype.getFlag().equals("1")) {
         type = "DB";
      } else if (sourcetype.getFlag().equals("2")) {
         type = sourcetype.getDbtype();
      } else if (sourcetype.getFlag().equals("3")) {
         type = "HIVE";
      }

      if (targettype == null) {
         type = type + "toFILE";
      } else if (targettype.getFlag().equals("1")) {
         type = type + "toDB";
      } else if (targettype.getFlag().equals("2")) {
         type = type + "to" + targettype.getDbtype();
      } else if (targettype.getFlag().equals("3")) {
         type = type + "toHIVE";
      }

      return type;
   }

   public void synTableParam(List<DesensitizationTable> tableList, ExecuteParam executeParam) {
      try {
         Connection srcconn = this.dataSystemService.getConnectionByDataSystemId(executeParam.getDataSourceId());
         Connection tarconn = this.dataSystemService.getConnectionByDataSystemId(executeParam.getDataTargetId());
         Map<String, String> pktableMap = new HashMap();

         for(DesensitizationTable desensitizationTable : tableList) {
            String t_tableName = (executeParam.getTableprefix() == null ? "" : executeParam.getTableprefix()) + desensitizationTable.getT_tablename() + (executeParam.getTablesuffix() == null ? "" : executeParam.getTablesuffix());
            pktableMap.put(desensitizationTable.getTablename(), t_tableName);
            if ("isprimary".equalsIgnoreCase(executeParam.getIsPrimary())) {
               JdbcTool.synchronizePrimaryKey(srcconn, executeParam.getSourceSchemaName(), desensitizationTable.getTablename(), tarconn, executeParam.getTargetSchemaName(), t_tableName);
            }

            if ("isindex".equalsIgnoreCase(executeParam.getIsIndex())) {
               JdbcTool.synchronizeIndex(srcconn, executeParam.getSourceSchemaName(), desensitizationTable.getTablename(), tarconn, executeParam.getTargetSchemaName(), t_tableName);
            }
         }

         JdbcTool.closeConnection(srcconn);
         JdbcTool.closeConnection(tarconn);
      } catch (Exception e) {
         e.printStackTrace();
      }
   }

   public SessionBean getLogForTaskMapping(String folerName, InfoProperty engine, String name, String sessionId) {
      SessionBean se = new SessionBean();

      try {
         se = MultiGetSessionStatisticsWebService.returnStatus(sessionId, engine, "wf_" + name, "mp_" + name, folerName);
      } catch (Exception e) {
         se.setStatus("EXCEPTION");
         e.printStackTrace();
      }

      return se;
   }

   public boolean delTablecolumn(String taskid) {
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String sqlurl = props.get("jdbc.url").toString();
         String username = props.get("jdbc.user").toString();
         String password = props.get("jdbc.password").toString();
         String driver = props.get("jdbc.driver").toString();
         Connection connection = JdbcTool.getConnection(driver, sqlurl, username, password);
         Statement statement = connection.createStatement();
         String sql = "delete from  DESENSITIZATION_TABLECOLUMN where taskid = '" + taskid + "'";
         System.out.println(sql);
         statement.executeUpdate(sql.toString());
         statement.close();
         connection.close();
         return true;
      } catch (IOException e) {
         e.printStackTrace();
         return false;
      } catch (SQLException e) {
         e.printStackTrace();
         return false;
      }
   }

   public static boolean updataRunstatus(String taskid) {
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String sqlurl = props.get("jdbc.url").toString();
         String username = props.get("jdbc.user").toString();
         String password = props.get("jdbc.password").toString();
         String driver = props.get("jdbc.driver").toString();
         Connection connection = JdbcTool.getConnection(driver, sqlurl, username, password);
         Statement statement = connection.createStatement();
         String sql = "update ghca.DESENSITIZATION_MONITOR a set a.runstatus=4 where taskid  = '" + taskid + "'";
         System.out.println(sql);
         statement.executeUpdate(sql.toString());
         statement.close();
         connection.close();
         return true;
      } catch (IOException e) {
         e.printStackTrace();
         return false;
      } catch (SQLException e) {
         e.printStackTrace();
         return false;
      }
   }

   public boolean updateTask(String tasknamereal, String save_state) {
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String sqlurl = props.get("jdbc.url").toString();
         String username = props.get("jdbc.user").toString();
         String password = props.get("jdbc.password").toString();
         String driver = props.get("jdbc.driver").toString();
         Connection connection = JdbcTool.getConnection(driver, sqlurl, username, password);
         Statement statement = connection.createStatement();
         String sql = "update encryptionmasking set save_state = '" + save_state + "' , taskstatus = '0'  where tasknamereal = '" + tasknamereal + "'";
         System.out.println(sql);
         statement.executeUpdate(sql.toString());
         statement.close();
         connection.close();
         return true;
      } catch (IOException e) {
         e.printStackTrace();
         return false;
      } catch (SQLException e) {
         e.printStackTrace();
         return false;
      }
   }

   public boolean insertLog(TConsoleLog tConsoleLog) {
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String sqlurl = props.get("jdbc.url").toString();
         String username = props.get("jdbc.user").toString();
         String password = props.get("jdbc.password").toString();
         String driver = props.get("jdbc.driver").toString();
         Connection connection = JdbcTool.getConnection(driver, sqlurl, username, password);
         Statement statement = connection.createStatement();
         String id = UUID.randomUUID().toString();
         String note = tConsoleLog.getNote();
         String module = tConsoleLog.getModule();
         String user = tConsoleLog.getOperationUser();
         String logno = tConsoleLog.getLogno();
         if (note != null) {
            note = note.replace("'", "\"");
         }

         String flag = tConsoleLog.getFlag();
         String sql = "insert into t_console_log(id,note,module,user,logno,operationtime,flag) values('" + id + "','" + note + "','" + module + "','" + user + "','" + logno + "',now(),'" + flag + "')";
         statement.executeUpdate(sql.toString());
         statement.close();
         connection.close();
         return true;
      } catch (IOException e) {
         e.printStackTrace();
         return false;
      } catch (SQLException e) {
         e.printStackTrace();
         return false;
      }
   }

   public boolean updateTask_taskstatus(String taskid, String taskstatus) {
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String sqlurl = props.get("jdbc.url").toString();
         String username = props.get("jdbc.user").toString();
         String password = props.get("jdbc.password").toString();
         String driver = props.get("jdbc.driver").toString();
         Connection connection = JdbcTool.getConnection(driver, sqlurl, username, password);
         Statement statement = connection.createStatement();
         String sql = "update encryptionmasking set taskstatus = '" + taskstatus + "'  where id = '" + taskid + "'";
         System.out.println(sql);
         statement.executeUpdate(sql.toString());
         statement.close();
         connection.close();
         return true;
      } catch (IOException e) {
         e.printStackTrace();
         return false;
      } catch (SQLException e) {
         e.printStackTrace();
         return false;
      }
   }

   public boolean updateTask_isengine(ExecuteParam executeParam, String isengine) {
      EncryptionMasking encryptionmasking = (EncryptionMasking)this.encryptionmaskingDao.get(executeParam.getTaskid());
      String taskid = encryptionmasking.getId();
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String sqlurl = props.get("jdbc.url").toString();
         String username = props.get("jdbc.user").toString();
         String password = props.get("jdbc.password").toString();
         String driver = props.get("jdbc.driver").toString();
         Connection connection = JdbcTool.getConnection(driver, sqlurl, username, password);
         Statement statement = connection.createStatement();
         String sql = "update encryptionmasking set isengine = '" + isengine + "'  where id = '" + taskid + "'";
         System.out.println(sql);
         statement.executeUpdate(sql.toString());
         statement.close();
         connection.close();
         return true;
      } catch (IOException e) {
         e.printStackTrace();
         return false;
      } catch (SQLException e) {
         e.printStackTrace();
         return false;
      }
   }

   public void updateTask(EncryptionMasking encryptionmasking) {
      this.encryptionmaskingDao.saveOrUpdate(encryptionmasking);
   }

   public String pageCode(String pageCode) {
      if (pageCode == null) {
         pageCode = "";
      }

      Map<String, String> mappage = new HashMap();
      mappage.put("GBK", "MS936");
      mappage.put("UTF-8", "UTF-8");
      mappage.put("UTF8", "UTF-8");
      mappage.put("", "");
      return (String)mappage.get(pageCode);
   }

   public String pageCode(int pageCode) {
      Map<Integer, String> mappage = new HashMap();
      mappage.put(0, "UTF-8");
      mappage.put(1, "GBK");
      return (String)mappage.get(pageCode);
   }

   public String pageCode_dbf(int pageCode) {
      Map<Integer, String> mappage = new HashMap();
      mappage.put(1, "GBK");
      mappage.put(0, "UTF-8");
      mappage.put(2, "MS950");
      return (String)mappage.get(pageCode);
   }

   public Map<String, String> getDataRuleMap() {
      Map<String, String> data_rule = new HashMap();
      new ArrayList();

      for(TCoreMaskingRuleinfo tCoreMaskingRuleinfo : this.tCoreMaskingRuleinfoDao.queryAll()) {
         data_rule.put(tCoreMaskingRuleinfo.getId(), tCoreMaskingRuleinfo.getMappletname());
      }

      return data_rule;
   }

   public HashMap<String, TCoreFieldSensitiveMemory> getTCoreFieldSensitiveMemory(String tableName, String sourceschema, HashMap<String, List<TCoreFieldSensitiveMemory>> allField) {
      HashMap<String, TCoreFieldSensitiveMemory> map = new HashMap();
      new ArrayList();
      List<TCoreFieldSensitiveMemory> memory = (List)allField.get(tableName);
      if (memory != null) {
         for(TCoreFieldSensitiveMemory tCoreFieldSensitiveMemory : memory) {
            map.put(tCoreFieldSensitiveMemory.getColumnname(), tCoreFieldSensitiveMemory);
         }
      }

      return map;
   }

   public FlatFile getflatFile(String type, String pagecode, String dataBaseType, String tableName, String tasknamereal, String loadscripttype) {
      FlatFile flatFile = new FlatFile();
      flatFile.setCodePage("MSSQLSERVER".equals(dataBaseType) ? "UTF-8" : this.pageCode(pagecode));
      flatFile.setDelimiter(XmlTool.getFileValue(dataBaseType + "/db-" + type + "delimiter"));
      flatFile.setFilename(tableName + XmlTool.getFileValue(dataBaseType + "/db-suffix"));
      flatFile.setFileType(Integer.parseInt(XmlTool.getFileValue(dataBaseType + "/db-" + type + "fileType")));
      if (DataBaseType.SYBASE_IQ.equals(dataBaseType) && "2".equals(loadscripttype) && "target".equals(type)) {
         flatFile.setQuoteCharacter(2);
      } else if (DataBaseType.SYBASE_IQ.equals(dataBaseType) && !"2".equals(loadscripttype) && "target".equals(type)) {
         flatFile.setQuoteCharacter(0);
      } else {
         flatFile.setQuoteCharacter(Integer.parseInt(XmlTool.getFileValue(dataBaseType + "/db-" + type + "quoteCharacter")));
      }

      flatFile.setSkipRows(Integer.parseInt(XmlTool.getFileValue(dataBaseType + "/db-" + type + "skipRows")));
      String filepath = XmlTool.getFileValue(dataBaseType + "/db-fileDir") + type + "/" + tasknamereal + "/";
      flatFile.setCommand("cat " + filepath + flatFile.getFilename());
      flatFile.setFileDir(filepath);
      if (!FileTool.isFileExit(filepath)) {
         FileTool.createFolder(filepath);
      }

      return flatFile;
   }

   public FlatFile getflatFile(DesensitizationFile desensitizationFile, String tablename, String filetype) {
      FlatFile sourceflatFile = new FlatFile();
      sourceflatFile.setCodePage(this.pageCode(Integer.parseInt(desensitizationFile.getCodepage())));
      sourceflatFile.setCommand("");
      sourceflatFile.setDelimiter(desensitizationFile.getDelimiters());
      sourceflatFile.setQuoteCharacter(Integer.parseInt(desensitizationFile.getQuotecharacter()));
      sourceflatFile.setSkipRows(0);
      String filepath = "";
      String suffix = desensitizationFile.getSuffix();
      switch (filetype) {
         case "FILE":
            sourceflatFile.setFileType(0);
            filepath = desensitizationFile.getFiledir();
            sourceflatFile.setFileDir(filepath);
            sourceflatFile.setFilename(tablename + suffix);
            break;
         case "FTP":
            sourceflatFile.setFileType(0);
            filepath = XmlTool.getFileValue(filetype + "/localdir");
            sourceflatFile.setFileDir(filepath);
            sourceflatFile.setFilename("t_" + tablename + suffix);
            break;
         case "SFTP":
            filepath = XmlTool.getFileValue(filetype + "/localdir");
            sourceflatFile.setFileDir(filepath);
            sourceflatFile.setFileType(0);
            sourceflatFile.setFilename("t_" + tablename + suffix);
      }

      if (!FileTool.isFileExit(filepath)) {
         FileTool.createFolder(filepath);
      }

      return sourceflatFile;
   }

   public FlatFile getflatFile(DesensitizationTable desensitizationTable, String filetype) {
      FlatFile sourceflatFile = new FlatFile();
      new TCoreFileStructure();
      new TCoreFileStructurespliter();
      new TCoreFileStructurewidth();
      TCoreFileStructure tCoreFileStructure = (TCoreFileStructure)this.tCoreFileStructureDao.get(desensitizationTable.getFilestructureid());
      TCoreFileStructurespliter tCoreFileStructurespliter = (TCoreFileStructurespliter)this.tCoreFileStructurespliterDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", desensitizationTable.getFilestructureid())});
      TCoreFileStructurewidth tCoreFileStructurewidth = (TCoreFileStructurewidth)this.tCoreFileStructurewidthDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", desensitizationTable.getFilestructureid())});
      String filepath = "";
      String filename = "";
      String splitertype = tCoreFileStructure.getSplitertype();
      boolean isdbf;
      if ("0".endsWith(splitertype)) {
         sourceflatFile.setCodePage(this.pageCode(Integer.parseInt(tCoreFileStructure.getCodepage())));
         sourceflatFile.setCommand("");
         sourceflatFile.setDelimiter(tCoreFileStructurespliter.getDelimiters());
         filename = desensitizationTable.getFilename();
         isdbf = filename.substring(filename.length() - 4, filename.length()).contains("dbf");
         sourceflatFile.setFileType(0);
         sourceflatFile.setQuoteCharacter(this.getQuoteCharacter(tCoreFileStructurespliter.getQuotecharacter()));
         sourceflatFile.setSkipRows(Integer.parseInt(tCoreFileStructure.getSkiprows()));
         sourceflatFile.setFilename(isdbf ? filename.substring(0, filename.length() - 4) + ".txt" : filename);
         sourceflatFile.setSplitertype("0");
      } else {
         sourceflatFile.setCodePage(this.pageCode(Integer.parseInt(tCoreFileStructure.getCodepage())));
         sourceflatFile.setCommand("");
         filename = desensitizationTable.getFilename();
         isdbf = filename.substring(filename.length() - 4, filename.length()).contains("dbf");
         sourceflatFile.setFileType(0);
         sourceflatFile.setSkipRows(Integer.parseInt(tCoreFileStructure.getSkiprows()));
         sourceflatFile.setFilename(isdbf ? filename.substring(0, filename.length() - 4) + ".txt" : filename);
         sourceflatFile.setSplitertype("1");
         sourceflatFile.setNullchartype(tCoreFileStructurewidth.getNullchartype());
         sourceflatFile.setNullcharacter(tCoreFileStructurewidth.getNullcharacter());
         sourceflatFile.setRepeatable(tCoreFileStructurewidth.getRepeatable());
         sourceflatFile.setPadbytes(tCoreFileStructurewidth.getPadbytes());
         sourceflatFile.setLinesequential(tCoreFileStructurewidth.getLinesequential());
         sourceflatFile.setShiftsensitivedata(tCoreFileStructurewidth.getShiftsensitivedata());
         sourceflatFile.setStriptrailingblanks(tCoreFileStructurewidth.getStriptrailingblanks());
      }

      switch (filetype) {
         case "FILE":
            filepath = desensitizationTable.getFilepath() + File.separator;
            if (isdbf) {
               if (FileTool.isFileExit(filepath + sourceflatFile.getFilename())) {
                  FileTool.removeFile(filepath + sourceflatFile.getFilename());
               }

               transdbf.transdbf(this.pageCode_dbf(Integer.parseInt(tCoreFileStructure.getCodepage())), filepath + filename, sourceflatFile.getDelimiter(), filepath + sourceflatFile.getFilename());
            }
            break;
         case "FTP":
            filepath = XmlTool.getFileValue(filetype + "/localdir");
            sourceflatFile.setFilename("s_" + filename);
            break;
         case "SFTP":
            filepath = XmlTool.getFileValue(filetype + "/localdir");
            sourceflatFile.setFilename("s_" + filename);
      }

      sourceflatFile.setFileDir(filepath);
      if (!FileTool.isFileExit(filepath)) {
         FileTool.createFolder(filepath);
      }

      return sourceflatFile;
   }

   public List<EncryptionMasking> queryEngineTaskAll() {
      return this.encryptionmaskingDao.queryTaskAll();
   }

   public List<EncryptionMasking> queryTaskAllbyprojectid(String projectid) {
      return StringUtils.isNotBlank(projectid) ? this.encryptionmaskingDao.queryTaskAllbyprojectid(projectid) : this.encryptionmaskingDao.queryTaskAll();
   }

   public List<EncryptionMasking> queryTaskAll() {
      return this.encryptionmaskingDao.queryAll("createtime", false, new Criterion[]{Restrictions.ne("isengine", "1")});
   }

   public List<EncryptionMasking> queryTaskByPage(PageInfo pageInfo) {
      List<EncryptionMasking> list = this.encryptionmaskingDao.queryByPageInfo(pageInfo, Order.desc("createtime"));
      return list;
   }

   public long getExeTaskNum() {
      return this.encryptionmaskingDao.getExeTaskNum();
   }

   public long getTableNum(String taskid) {
      return this.encryptionmaskingDao.getTableNum(taskid);
   }

   public String getRunid(ExecuteParam executeParam, String sessionId, String tableName) {
      SessionBean se = new SessionBean();
      String name = executeParam.getTaskNameReal() + "_" + tableName;

      try {
         se = MultiGetSessionStatisticsWebService.returnStatus(sessionId, executeParam.getInfoProperty(), "wf_" + name, "mp_" + name, executeParam.getFolderName());
      } catch (Exception e) {
         e.printStackTrace();
      }

      String run_id = se.getWf_run_id();
      return run_id;
   }

   public int getQuoteCharacter(String param) {
      int pa = 0;
      switch (param) {
         case "none":
            pa = 0;
            break;
         case "double":
            pa = 2;
            break;
         case "single":
            pa = 1;
      }

      return pa;
   }

   public List<DesensitizationTablecolumn> queryColumInfo(String taskid, String table) {
      DesensitizationTable desensitizationTable = (DesensitizationTable)this.desensitizationTableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("tablename", table)});
      List<DesensitizationTablecolumn> list = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", desensitizationTable.getId())});
      return list;
   }

   public DesensitizationFile queryDesensitizationfileBytaskid(String taskid) {
      new DesensitizationFile();
      return (DesensitizationFile)this.desensitizationFileDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
   }

   @Async
   public void executeDB_batchread_FILE_pwc_FILE_batchwrite_DB(final ExecuteParam executeParam) throws Exception {
      new Properties();
      Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      String engineType = props.getProperty("masking_engine_type");
      if ("1".equals(engineType)) {
         this.executeDB_batchread_FILE_pwc_FILE_batchwrite_DB(executeParam, "1");
      } else {
         System.out.println(">>>>>>>>>>>>>>>>>DB_batchread_FILE_pwc_FILE_batchwrite_DB<<<<<<<<<<<<<<<<<<");
         List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
         final TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(executeParam.getDataTargetId());
         final Desensitizationsource desensitizationsource = (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", executeParam.getTaskid())});
         final TCoreDatasystem tCoreDatasystemSource;
         if ("1".equals(desensitizationsource.getIsdmpfile())) {
            tCoreDatasystemSource = null;
         } else {
            tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(executeParam.getDataSourceId());
         }

         final Runtime rn = Runtime.getRuntime();
         final Map<String, List<DesensitizationTablecolumn>> map = new HashMap();
         final CountDownLatch countDownLatch = new CountDownLatch(tableList.size());

         for(DesensitizationTable desensitizationTable : tableList) {
            List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
            List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
            map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
         }

         final EncryptionMasking encryptionmasking = (EncryptionMasking)this.encryptionmaskingDao.get(executeParam.getTaskid());
         encryptionmasking.setTaskstatus("1");
         this.encryptionmaskingDao.saveOrUpdate(encryptionmasking);
         this.encryptionmaskingDao.getSession().getTransaction().commit();
         final String targetdbType = executeParam.getTargetDataSystem().getDbtype();
         final String sourcedbType = executeParam.getSourceDataSystem().getDbtype();
         final List<String> t_tableName_list = new ArrayList();
         if ("ORACLE".equals(targetdbType) && "1".equals(desensitizationsource.getIsdmpfile())) {
            for(int i = 0; i < tableList.size(); ++i) {
               DesensitizationTable desensitizationTable = (DesensitizationTable)tableList.get(i);
               String t_tableName = (encryptionmasking.getTableprefix() == null ? "" : encryptionmasking.getTableprefix()) + desensitizationTable.getT_tablename() + (encryptionmasking.getTablesuffix() == null ? "" : encryptionmasking.getTablesuffix());
               t_tableName_list.add(t_tableName);
               DmpTool.createTarPipeFile(executeParam.getTaskNameReal(), t_tableName);
            }
         }

         if ("ORACLE".equals(targetdbType)) {
            if ("1".equals(desensitizationsource.getIsdmpfile())) {
               System.out.println("ORACLE-dmp:根据传入的DMP文件、任务名和表名,解析DMP数据，将该表的数据插入到PIPE文件中");
               this.taskExecutor.execute(new Runnable() {
                  public void run() {
                     String multiDempFile = desensitizationsource.getMultiDempFile();
                     if ("0".equals(multiDempFile)) {
                        if ("0".equals(desensitizationsource.getDmptype())) {
                           DmpDpGenerateTool.prasingDataByTableName(desensitizationsource.getSourcefiledir(), executeParam.getTaskNameReal(), t_tableName_list, executeParam.getTragetFileDir());
                        } else {
                           DmpGenerateTool.prasingDataByTableName(desensitizationsource.getSourcefiledir(), executeParam.getTaskNameReal(), t_tableName_list, executeParam.getTragetFileDir());
                        }
                     } else {
                        List<String> sourcefilelist = new ArrayList();
                        String filelist = desensitizationsource.getFilelist();
                        String filepath = desensitizationsource.getSourcefiledir();
                        String[] sourcefiledirlist = filelist.split(",");

                        for(String string : sourcefiledirlist) {
                           sourcefilelist.add(filepath + "/" + string);
                        }

                        if ("0".equals(desensitizationsource.getDmptype())) {
                           MultipleDmpDpGenerateTool.prasingDataByTableName(sourcefilelist, executeParam.getTaskNameReal(), t_tableName_list, executeParam.getTragetFileDir());
                        } else {
                           MultipleDmpGenerateTool.prasingDataByTableName(sourcefilelist, executeParam.getTaskNameReal(), t_tableName_list, executeParam.getTragetFileDir());
                        }
                     }

                  }
               });
            }

            System.out.println("ORACLE-dmp： 执行源的脚本:完成");
         }

         for(final DesensitizationTable desensitizationTable : tableList) {
            final String t_tableName = (encryptionmasking.getTableprefix() == null ? "" : encryptionmasking.getTableprefix()) + desensitizationTable.getT_tablename() + (encryptionmasking.getTablesuffix() == null ? "" : encryptionmasking.getTablesuffix());
            this.taskExecutor.execute(new Runnable() {
               public void run() {
                  String sessionId = "";
                  String status = "4";
                  final String s_tableName = desensitizationTable.getTablename();
                  String workflowName = "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName;

                  try {
                     Properties props = new Properties();

                     try {
                        props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                     } catch (IOException e) {
                        e.printStackTrace();
                     }

                     if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
                        System.out.println("---进入启动预计运行时间方法！");
                        String dataCount = "";
                        dataCount = EncryptionMaskingImpl.this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
                        System.out.println("数据源表" + s_tableName + "总行数：" + dataCount);
                        EncryptionMaskingImpl.this.redisService.set("dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName, dataCount);
                        System.out.println("预计运行时间，key=dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName + "，dataCount=" + dataCount);
                     }

                     EncryptionMaskingImpl.this.updateMonitorRunStatus(s_tableName, executeParam.getTableMap());
                     System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
                     sessionId = LoginWebService.returnStatus(executeParam.getInfoProperty());
                     System.out.println("创建执行脚本开始！tableName=" + s_tableName + "t_tableName=" + t_tableName);
                     EncryptionMaskingImpl.this.createScriptFiletotarget(executeParam, desensitizationTable, executeParam.getTargetDataSystem().getDbtype(), tCoreDatasystemTarget, (List)map.get(s_tableName), rn);
                     System.out.println("创建目标脚本开始！");
                     EncryptionMaskingImpl.this.createScriptFiletoSource(executeParam, desensitizationTable, executeParam.getSourceDataSystem().getDbtype(), tCoreDatasystemSource, (List)map.get(s_tableName), rn);
                     System.out.println("创建源脚本开始！");
                     System.out.println("启动脚本开始！dbType=" + targetdbType + ",tableName=" + s_tableName);
                     System.out.println("调用启动工作流方法开始！tableName=" + s_tableName);
                     int runId = EncryptionMaskingImpl.this.startWorkFlowEx(workflowName, executeParam.getInfoProperty(), executeParam.getFolderName(), sessionId);
                     if ("TERADATA".equals(sourcedbType)) {
                        System.out.println("执行源的脚本：/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                        CommandTool.commandRtn2("/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                        System.out.println("执行源的脚本:完成");
                     } else if ("MSSQLSERVER".equals(sourcedbType)) {
                        CommandTool.commandRtn("/data/infa_sqlserver/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                        System.out.println("SQLSERVER执行源的脚本:完成");
                     } else if ("HIVE".equals(sourcedbType)) {
                        System.out.println("执行源的脚本：/data/hive/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                        TCoreConfig tcoreConfig = (TCoreConfig)EncryptionMaskingImpl.this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", executeParam.getDataSourceId())});
                        if (tcoreConfig != null) {
                           String filepath = tcoreConfig.getFileDir();
                           String delimiter = tcoreConfig.getSourcedelimiter();
                           String charset = tcoreConfig.getCodePage();
                           if (filepath == null || filepath.equals("") || delimiter == null || delimiter.equals("") || charset == null || charset.equals("")) {
                              filepath = XmlTool.getFileValue(sourcedbType + "/db-fileDir");
                              delimiter = XmlTool.getFileValue(sourcedbType + "/db-sourcedelimiter");
                              charset = XmlTool.getFileValue(sourcedbType + "/db-codePage");
                           }

                           EncryptionMaskingImpl.this.iskeberos(tCoreDatasystemSource);
                           Connection conn = JdbcTool.getConnection(tCoreDatasystemSource);
                           PipeTool pipe = new PipeTool(conn, executeParam.getSourceSchemaName() + "." + s_tableName, filepath + "/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".pipe", delimiter, charset);
                           pipe.writeFile();
                           System.out.println("HIVE执行源的脚本:完成");
                        }
                     } else if ("MYSQL".equals(sourcedbType)) {
                        System.out.println("执行MySql源的脚本：/data/infa_mysqlload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                        CommandTool.commandRtn2("/data/infa_mysqlload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                     } else if ("SYBASE".equals(sourcedbType)) {
                        CommandTool.commandRtn2("/data/infa_sybase/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                        System.out.println("SYBASE执行源的脚本:完成");
                     } else if ("ORACLE".equals(sourcedbType)) {
                        System.out.println("ORACLE-dmp:根据传入的DMP文件、任务名和表名,解析DMP数据，将该表的数据插入到PIPE文件中");
                        if ("1".equals(desensitizationsource.getIsdmpfile())) {
                           EncryptionMaskingImpl.this.taskExecutor.execute(new Runnable() {
                              public void run() {
                                 String multiDempFile = desensitizationsource.getMultiDempFile();
                                 if ("0".equals(multiDempFile)) {
                                    if ("0".equals(desensitizationsource.getDmptype())) {
                                       Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "Dmpdp_tableInfoMap_masking");
                                       DmpDpTool.prasingDataByTableName(desensitizationsource.getSourcefiledir(), executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                    } else {
                                       Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "Dmp_tableInfoMap_masking");
                                       DmpTool.prasingDataByTableName(desensitizationsource.getSourcefiledir(), executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                    }
                                 } else {
                                    List<String> sourcefilelist = new ArrayList();
                                    String filelist = desensitizationsource.getFilelist();
                                    String filepath = desensitizationsource.getSourcefiledir();
                                    String[] sourcefiledirlist = filelist.split(",");

                                    for(String string : sourcefiledirlist) {
                                       sourcefilelist.add(filepath + "/" + string);
                                    }

                                    if ("0".equals(desensitizationsource.getDmptype())) {
                                       Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "multiDmpdp_tableInfoMap_masking");
                                       MultipleDmpDpTool.prasingDataByTableName(sourcefilelist, executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                    } else {
                                       Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "multiDmp_tableInfoMap_masking");
                                       MultipleDmpTool.prasingDataByTableName(sourcefilelist, executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                    }
                                 }

                              }
                           });
                        }

                        System.out.println("ORACLE-dmp： 执行源的脚本:完成");
                     }

                     if ("TERADATA".equals(targetdbType)) {
                        System.out.println("执行目标的脚本");
                        CommandTool.commandRtn2("/data/infa_teradata/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                        System.out.println("执行目标的脚本:完成");
                     } else if ("MSSQLSERVER".equals(targetdbType)) {
                        CommandTool.command("chmod -R 777 /data/infa_sqlserver/");
                        String completeStatus = EncryptionMaskingImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                        if ("1".equals(completeStatus)) {
                           CommandTool.commandRtn("/data/infa_sqlserver/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                        }

                        System.out.println("SQLSERVER执行目标的脚本:完成");
                     } else if ("MYSQL".equals(targetdbType)) {
                        System.out.println("MySql执行目标的脚本!");
                        CommandTool.commandRtn2("/data/infa_mysqlload/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     } else if ("RAPIDSDB".equals(targetdbType)) {
                        System.out.println("RAPIDSDB执行目标的脚本!");
                        CommandTool.commandRtn2("/data/infa_rapidsdbload/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     } else if ("SYBASE".equals(targetdbType)) {
                        CommandTool.command("chmod -R 777 /data/infa_sybase/");
                        CommandTool.commandRtn2("/data/infa_sybase/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     }

                     String completeStatus = "0";
                     if (runId >= 0) {
                        completeStatus = EncryptionMaskingImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                     }

                     if ("1".equals(completeStatus)) {
                        System.out.println("表" + s_tableName + ",执行完成,通过阻塞方法！");
                        SessionBean sessionBean = EncryptionMaskingImpl.this.getLogForTaskMapping(executeParam.getFolderName(), executeParam.getInfoProperty(), executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
                        if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                           status = "1";
                        } else if ("FAILED".equals(sessionBean.getStatus())) {
                           status = "2";
                        } else if ("STOPPED".equals(sessionBean.getStatus())) {
                           status = "3";
                        } else {
                           status = "4";
                        }

                        if ("TERADATA".equals(targetdbType)) {
                           String table = t_tableName;
                           Connection tconn = EncryptionMaskingImpl.this.getConnectionByDataSystemId(executeParam.getTargetDataSystem());
                           EncryptionMaskingImpl.this.droptable(table, tconn, executeParam.getTargetSchemaName());
                        }

                        System.out.println("执行更新监控表开始！tableName=" + s_tableName + ",t_tableName=" + t_tableName);
                        EncryptionMaskingImpl.this.updateMonitor(desensitizationTable.getTablename(), executeParam.getTableMap(), status, runId);
                     }

                     LogoutWebService.returnStatus(sessionId, executeParam.getInfoProperty());
                  } catch (Exception e) {
                     e.printStackTrace();
                  } finally {
                     countDownLatch.countDown();
                  }

               }
            });
         }

         try {
            System.out.println(">>>>>>>>>>>>>>>当前活动线程数：" + this.taskExecutor.getActiveCount());
            System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + countDownLatch.getCount());
            countDownLatch.await();
            System.out.println(">>>>>>>>>>>>>>>插入监控详细信息表开始！");
            this.insertMonitorInfo(tableList, executeParam.getInfoProperty(), executeParam.getFolderName(), executeParam.getTaskid(), executeParam.getTaskNameReal());
            this.updateTask_taskstatus(encryptionmasking.getId(), "3");
            System.out.println(">>>>>>>>>>>>>>>任务已全部执行完成！同步表信息开始！");
            if (!"1".equals(desensitizationsource.getIsdmpfile())) {
               this.synTableParam(tableList, executeParam);
            }
         } catch (Exception e) {
            e.printStackTrace();
         }

      }
   }

   public void executeDB_batchread_FILE_pwc_FILE_batchwrite_DB(final ExecuteParam executeParam, String engineFlg) throws Exception {
      System.out.println(">>>>>>>>>>>>>>>>>DB_batchread_FILE_pwc_FILE_batchwrite_DB<<<<<<<<<<<<<<<<<<");
      List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
      final List<String> t_tableName_list = new ArrayList();
      String targetdbType = executeParam.getTargetDataSystem().getDbtype();
      final Desensitizationsource desensitizationsource = (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", executeParam.getTaskid())});
      Desensitizationtarget desensitizationtarget = (Desensitizationtarget)this.desensitizationtargetDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", executeParam.getTaskid())});
      final TCoreDatasystem tCoreDatasystemSource;
      if ("1".equals(desensitizationsource.getIsdmpfile())) {
         tCoreDatasystemSource = null;
      } else {
         tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(executeParam.getDataSourceId());
      }

      TCoreDatasystem tCoreDatasystemTarget;
      if ("1".equals(desensitizationtarget.getDmpimport())) {
         tCoreDatasystemTarget = null;
      } else {
         tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(executeParam.getDataTargetId());
      }

      Runtime rn = Runtime.getRuntime();
      Map<String, List<DesensitizationTablecolumn>> map = new HashMap();

      for(DesensitizationTable desensitizationTable : tableList) {
         List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
         List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
         map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
      }

      for(int i = 0; i < tableList.size(); ++i) {
         DesensitizationTable desensitizationTable = (DesensitizationTable)tableList.get(i);
         String s_tableName = desensitizationTable.getTablename();
         t_tableName_list.add(s_tableName);
         this.createScriptFiletotarget(executeParam, desensitizationTable, executeParam.getTargetDataSystem().getDbtype(), tCoreDatasystemTarget, (List)map.get(s_tableName), rn);
         System.out.println("创建目标脚本开始！");
         this.createScriptFiletoSource(executeParam, desensitizationTable, executeParam.getSourceDataSystem().getDbtype(), tCoreDatasystemSource, (List)map.get(s_tableName), rn);
         System.out.println("创建源脚本开始！");
      }

      if ("ORACLE".equals(targetdbType)) {
         if ("1".equals(desensitizationsource.getIsdmpfile())) {
            System.out.println("ORACLE-dmp:根据传入的DMP文件、任务名和表名,解析DMP数据，将该表的数据插入到PIPE文件中");
            this.taskExecutor.execute(new Runnable() {
               public void run() {
                  String multiDempFile = desensitizationsource.getMultiDempFile();
                  if ("0".equals(multiDempFile)) {
                     if ("0".equals(desensitizationsource.getDmptype())) {
                        DmpDpGenerateTool.prasingDataByTableName(desensitizationsource.getSourcefiledir(), executeParam.getTaskNameReal(), t_tableName_list, executeParam.getTragetFileDir());
                     } else {
                        DmpGenerateTool.prasingDataByTableName(desensitizationsource.getSourcefiledir(), executeParam.getTaskNameReal(), t_tableName_list, executeParam.getTragetFileDir());
                     }
                  } else {
                     List<String> sourcefilelist = new ArrayList();
                     String filelist = desensitizationsource.getFilelist();
                     String filepath = desensitizationsource.getSourcefiledir();
                     String[] sourcefiledirlist = filelist.split(",");

                     for(String string : sourcefiledirlist) {
                        sourcefilelist.add(filepath + "/" + string);
                     }

                     if ("0".equals(desensitizationsource.getDmptype())) {
                        MultipleDmpDpGenerateTool.prasingDataByTableName(sourcefilelist, executeParam.getTaskNameReal(), t_tableName_list, executeParam.getTragetFileDir());
                     } else {
                        MultipleDmpGenerateTool.prasingDataByTableName(sourcefilelist, executeParam.getTaskNameReal(), t_tableName_list, executeParam.getTragetFileDir());
                     }
                  }

               }
            });
         }

         System.out.println("ORACLE-dmp： 执行源的脚本:完成");
      }

      final EncryptionMasking encryptionmasking = (EncryptionMasking)this.encryptionmaskingDao.get(executeParam.getTaskid());
      encryptionmasking.setTaskstatus("1");
      this.encryptionmaskingDao.saveOrUpdate(encryptionmasking);
      this.encryptionmaskingDao.getSession().getTransaction().commit();
      final CountDownLatch engineCountDownLatch = new CountDownLatch(1);

      try {
         this.taskExecutor.execute(new Runnable() {
            public void run() {
               try {
                  String xmlFileName = executeParam.getTaskNameReal();
                  System.out.println("xmlFileName is :" + xmlFileName);
                  System.out.println(">>>>>>>The client call engine start>>>>>>>>>>>>>>>>>>>>>");
                  DesensitizationEngineInterfaceImplService engineInterfaceImplService = new DesensitizationEngineInterfaceImplService();
                  DesensitizationEngineInterfaceImpl engineInterfaceImpl = (DesensitizationEngineInterfaceImpl)engineInterfaceImplService.getPort(DesensitizationEngineInterfaceImpl.class);
                  EngineParameter eParameter = new EngineParameter();
                  eParameter.setWorkflowName(xmlFileName);
                  eParameter.setGroupId(executeParam.getGroupId());
                  String targetdbType = executeParam.getTargetDataSystem().getDbtype();
                  String sourcedbType = executeParam.getSourceDataSystem().getDbtype();
                  if ("ORACLE".equals(sourcedbType) && "HIVE".equals(targetdbType)) {
                     eParameter.setDataProcessType("DB_batchread_FILE_pwc_Hive");
                  } else {
                     eParameter.setDataProcessType("DB_batchread_FILE_pwc_FILE_batchwrite_DB");
                  }

                  EngineResult er = engineInterfaceImpl.startWorkflowEx(eParameter);
                  System.out.println("result is " + er.getReStatus());
                  System.out.println(">>>>>>>The client call engine end>>>>>>>>>>>>>>>>>>>>>");
               } catch (Exception e) {
                  e.printStackTrace();
                  String taskid = encryptionmasking.getId();
                  EncryptionMaskingImpl.updataRunstatus(taskid);
                  System.out.println(executeParam.getTaskNameReal() + "任务 调用引擎失败!");
               } finally {
                  engineCountDownLatch.countDown();
               }

            }
         });
         System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + engineCountDownLatch.getCount());
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         this.updateTask_taskstatus(encryptionmasking.getId(), "3");
      }

      final CountDownLatch countDownLatch = new CountDownLatch(tableList.size());

      for(final DesensitizationTable desensitizationTable : tableList) {
         this.taskExecutor.execute(new Runnable() {
            public void run() {
               String sessionId = "";
               String status = "4";
               String t_tableName = (encryptionmasking.getTableprefix() == null ? "" : encryptionmasking.getTableprefix()) + desensitizationTable.getT_tablename() + (encryptionmasking.getTablesuffix() == null ? "" : encryptionmasking.getTablesuffix());
               final String s_tableName = desensitizationTable.getTablename();

               try {
                  Properties props = new Properties();

                  try {
                     props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                  } catch (IOException e) {
                     e.printStackTrace();
                  }

                  if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
                     System.out.println("---进入启动预计运行时间方法！");
                     String dataCount = "";
                     dataCount = EncryptionMaskingImpl.this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
                     System.out.println("数据源表" + s_tableName + "总行数：" + dataCount);
                     EncryptionMaskingImpl.this.redisService.set("dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName, dataCount);
                     System.out.println("预计运行时间，key=dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName + "，dataCount=" + dataCount);
                  }

                  EncryptionMaskingImpl.this.updateMonitorRunStatus(s_tableName, executeParam.getTableMap());
                  System.out.println("创建执行脚本开始！tableName=" + s_tableName + "t_tableName=" + t_tableName);
                  String targetdbType = executeParam.getTargetDataSystem().getDbtype();
                  String sourcedbType = executeParam.getSourceDataSystem().getDbtype();
                  System.out.println("启动脚本开始！dbType=" + targetdbType + ",tableName=" + s_tableName);
                  System.out.println("调用启动工作流方法开始！tableName=" + s_tableName);
                  if ("TERADATA".equals(sourcedbType)) {
                     System.out.println("执行源的脚本：/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                     CommandTool.commandRtn2("/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                     System.out.println("执行源的脚本:完成");
                  } else if ("MSSQLSERVER".equals(sourcedbType)) {
                     CommandTool.commandRtn("/data/infa_sqlserver/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                     System.out.println("SQLSERVER执行源的脚本:完成");
                  } else if ("HIVE".equals(sourcedbType)) {
                     System.out.println("执行源的脚本：/data/hive/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                     TCoreConfig tcoreConfig = (TCoreConfig)EncryptionMaskingImpl.this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", executeParam.getDataSourceId())});
                     if (tcoreConfig != null) {
                        String filepath = tcoreConfig.getFileDir();
                        String delimiter = tcoreConfig.getSourcedelimiter();
                        String charset = tcoreConfig.getCodePage();
                        if (filepath == null || filepath.equals("") || delimiter == null || delimiter.equals("") || charset == null || charset.equals("")) {
                           filepath = XmlTool.getFileValue(sourcedbType + "/db-fileDir");
                           delimiter = XmlTool.getFileValue(sourcedbType + "/db-sourcedelimiter");
                           charset = XmlTool.getFileValue(sourcedbType + "/db-codePage");
                        }

                        EncryptionMaskingImpl.this.iskeberos(tCoreDatasystemSource);
                        Connection conn = JdbcTool.getConnection(tCoreDatasystemSource);
                        PipeTool pipe = new PipeTool(conn, executeParam.getSourceSchemaName() + "." + s_tableName, filepath + "/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".pipe", delimiter, charset);
                        pipe.writeFile();
                        System.out.println("HIVE执行源的脚本:完成");
                     }
                  } else if ("MYSQL".equals(sourcedbType)) {
                     System.out.println("执行MySql源的脚本：/data/infa_mysqlload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                     CommandTool.commandRtn2("/data/infa_mysqlload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                  } else if ("RAPIDSDB".equals(sourcedbType)) {
                     System.out.println("执行RAPIDSDB源的脚本：/data/infa_rapidsdb/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                     CommandTool.commandRtn2("/data/infa_rapidsdbload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                  } else if ("SYBASE".equals(sourcedbType)) {
                     CommandTool.commandRtn2("/data/infa_sybase/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                     System.out.println("SYBASE执行源的脚本:完成");
                  } else if ("ORACLE".equals(sourcedbType)) {
                     System.out.println("ORACLE-dmp:根据传入的DMP文件、任务名和表名,解析DMP数据，将该表的数据插入到PIPE文件中");
                     if ("1".equals(desensitizationsource.getIsdmpfile())) {
                        EncryptionMaskingImpl.this.taskExecutor.execute(new Runnable() {
                           public void run() {
                              String multiDempFile = desensitizationsource.getMultiDempFile();
                              if ("0".equals(multiDempFile)) {
                                 if ("0".equals(desensitizationsource.getDmptype())) {
                                    Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "Dmpdp_tableInfoMap_masking");
                                    DmpDpTool.prasingDataByTableName(desensitizationsource.getSourcefiledir(), executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                 } else {
                                    Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "Dmp_tableInfoMap_masking");
                                    DmpTool.prasingDataByTableName(desensitizationsource.getSourcefiledir(), executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                 }
                              } else {
                                 List<String> sourcefilelist = new ArrayList();
                                 String filelist = desensitizationsource.getFilelist();
                                 String filepath = desensitizationsource.getSourcefiledir();
                                 String[] sourcefiledirlist = filelist.split(",");

                                 for(String string : sourcefiledirlist) {
                                    sourcefilelist.add(filepath + "/" + string);
                                 }

                                 if ("0".equals(desensitizationsource.getDmptype())) {
                                    Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "multiDmpdp_tableInfoMap_masking");
                                    MultipleDmpDpTool.prasingDataByTableName(sourcefilelist, executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                 } else {
                                    Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "multiDmp_tableInfoMap_masking");
                                    MultipleDmpTool.prasingDataByTableName(sourcefilelist, executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                 }
                              }

                           }
                        });
                     }

                     System.out.println("ORACLE-dmp： 执行源的脚本:完成");
                  }

                  if ("TERADATA".equals(targetdbType)) {
                     System.out.println("执行目标的脚本");
                     CommandTool.commandRtn2("/data/infa_teradata/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     System.out.println("执行目标的脚本:完成");
                  } else if (!"MSSQLSERVER".equals(targetdbType)) {
                     if ("MYSQL".equals(targetdbType)) {
                        System.out.println("MySql执行目标的脚本!");
                        CommandTool.commandRtn2("/data/infa_mysqlload/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     } else if ("RAPIDSDB".equals(targetdbType)) {
                        System.out.println("RAPIDSDB执行目标的脚本!");
                        CommandTool.commandRtn2("/data/infa_rapidsdbload/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     } else if ("SYBASE".equals(targetdbType)) {
                        CommandTool.command("chmod -R 777 /data/infa_sybase/");
                        CommandTool.commandRtn2("/data/infa_sybase/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     } else if ("DB2".equals(targetdbType)) {
                        CommandTool.commandRtn("/data/infa_db2/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     } else if ("SYBASE_IQ".equals(targetdbType)) {
                        CommandTool.commandRtn("/data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh /data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".pipe");
                     } else if ("GREENPLUM".equals(targetdbType)) {
                        CommandTool.commandRtn("/data/infa_greenplum/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     }
                  } else {
                     CommandTool.command("chmod -R 777 /data/infa_sqlserver/");
                     boolean notChange = true;

                     while(notChange) {
                        File f1 = new File("/data/infa_sqlserver/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".txt");
                        Long f1length = f1.length();
                        Thread.sleep(1000L);
                        File f2 = new File("/data/infa_sqlserver/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".txt");
                        Long f2length = f2.length();
                        if (f1length.equals(f2length) && f1length != 0L) {
                           notChange = false;
                        }
                     }

                     String completeStatus = EncryptionMaskingImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                     if ("1".equals(completeStatus)) {
                        CommandTool.commandRtn("/data/infa_sqlserver/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                     }

                     System.out.println("SQLSERVER执行目标的脚本:完成");
                  }

                  if ("TERADATA".equals(targetdbType)) {
                     Connection tconn = EncryptionMaskingImpl.this.getConnectionByDataSystemId(executeParam.getTargetDataSystem());
                     EncryptionMaskingImpl.this.droptable(t_tableName, tconn, executeParam.getTargetSchemaName());
                  }
               } catch (Exception e) {
                  e.printStackTrace();
               } finally {
                  countDownLatch.countDown();
               }

            }
         });
      }

   }

   public void createTeradataExport(List<DesensitizationTablecolumn> colLst, DesensitizationTable desensitizationTable, ExecuteParam executeParam, TCoreDatasystem tCoreDatasystemSource) {
      List<String> colNameLst = new ArrayList();
      Integer totalLen = 0;

      for(int j = 0; j < colLst.size(); ++j) {
         totalLen = totalLen + 3;
         String colName = ((DesensitizationTablecolumn)colLst.get(j)).getColumnname();
         String colType = ((DesensitizationTablecolumn)colLst.get(j)).getColumntype();
         String colLength = ((DesensitizationTablecolumn)colLst.get(j)).getColumnlength();
         String colScale = ((DesensitizationTablecolumn)colLst.get(j)).getColumnscale() == null ? "" : ((DesensitizationTablecolumn)colLst.get(j)).getColumnscale();
         colName = TeradataTool.teradataTypetoVarchar(colName, colType, colLength);
         String realColLength = TeradataTool.teradataTypeLength(colType, colLength, colScale);
         if (StringUtils.isNotBlank(realColLength)) {
            totalLen = totalLen + Integer.valueOf(realColLength);
         }

         colNameLst.add(colName);
      }

      String colNamesStr = StringUtils.join(colNameLst.toArray(), "||'|'||");
      colNamesStr = "(cast(" + colNamesStr + " as char(" + totalLen + ")))";
      Map<String, String> paramMap = new HashMap();
      paramMap.put("schema", executeParam.getSourceSchemaName());
      paramMap.put("tablename", desensitizationTable.getTablename());
      paramMap.put("colNamesStr", colNamesStr);
      paramMap.put("teradataServersIp", tCoreDatasystemSource.getDbip());
      paramMap.put("teradataServersUser", tCoreDatasystemSource.getUsername());
      paramMap.put("teradataServerspwd", "1".equals(tCoreDatasystemSource.getFlag()) ? AesTool.decrypt(tCoreDatasystemSource.getPassword(), "ghca") : tCoreDatasystemSource.getPassword());
      paramMap.put("taskname", executeParam.getTaskNameReal());
      TeradataTool.createTerdataExportScript(paramMap);
   }

   public void createTeradataLoad(List<DesensitizationTablecolumn> colLst, TCoreDatasystem tCoreDatasystemTarget, DesensitizationTable desensitizationTable, ExecuteParam executeParam) {
      List<String> nameList = new ArrayList();
      List<String> lengthList = new ArrayList();

      for(DesensitizationTablecolumn sourceTableCol : colLst) {
         nameList.add(sourceTableCol.getColumnname());
         lengthList.add(sourceTableCol.getColumnlength());
      }

      StringBuffer definesb = new StringBuffer();

      for(int i = 0; i < nameList.size(); ++i) {
         definesb.append((String)nameList.get(i) + "(varchar(" + (String)lengthList.get(i) + ")),");
      }

      Map<String, String> paramMapload = new HashMap();
      paramMapload.put("ip", tCoreDatasystemTarget.getDbip());
      paramMapload.put("port", tCoreDatasystemTarget.getDbport());
      paramMapload.put("user", tCoreDatasystemTarget.getUsername());
      paramMapload.put("pwd", "1".equals(tCoreDatasystemTarget.getFlag()) ? AesTool.decrypt(tCoreDatasystemTarget.getPassword(), "ghca") : tCoreDatasystemTarget.getPassword());
      paramMapload.put("schema", executeParam.getTargetSchemaName());
      paramMapload.put("table", desensitizationTable.getTablename());
      paramMapload.put("path", TeradataTool.STR_PIPEFILE_TAR_PATH + executeParam.getTaskNameReal() + "/");
      paramMapload.put("define", definesb.substring(0, definesb.length() - 1));
      paramMapload.put("in_type", "1");
      String dbcode = tCoreDatasystemTarget.getDbtype();
      String servername = tCoreDatasystemTarget.getDbservername();
      String url = EdbType.getUrlByEdbcode(dbcode, tCoreDatasystemTarget.getDbip(), tCoreDatasystemTarget.getDbport(), servername, tCoreDatasystemTarget.getPagecode());
      String driver = EdbType.getEdbTypeByDbcode(dbcode).getDbdriver();
      paramMapload.put("driver", driver);
      paramMapload.put("url", url);
      paramMapload.put("create_sql", desensitizationTable.getCreate_sql());
      TeradataLoadTableTool.executeLoadTable(paramMapload);
   }

   public String delparentheses(String type) {
      if (type.indexOf("(") == -1) {
         if (StringUtils.isNotBlank(type)) {
            type = type.trim();
         }

         return type;
      } else {
         type = type.indexOf("(") == -1 ? type : type.substring(0, type.indexOf("(")) + type.substring(type.indexOf(")") + 1, type.length());
         return this.delparentheses(type);
      }
   }

   public String getDataCount(String dbType, TCoreDatasystem dataSystem, DesensitizationTable desensitizationTable, String schemaName) {
      String url = "";
      String driver = EdbType.getEdbTypeByDbcode(dbType).getDbdriver();
      switch (dbType) {
         case "INFORMIX":
            url = EdbType.getUrlByEdbcode(dbType, dataSystem.getDbip(), dataSystem.getDbport(), dataSystem.getDbservername(), dataSystem.getServername());
            break;
         case "AS400":
            url = EdbType.getUrlByEdbcode(dbType, dataSystem.getDbip(), dataSystem.getDbservername(), dataSystem.getServername());
            break;
         default:
            url = EdbType.getUrlByEdbcode(dbType, dataSystem.getDbip(), dataSystem.getDbport(), dataSystem.getDbservername());
      }

      long count = 0L;

      try {
         Connection connection = JdbcTool.getConnection(driver, url, dataSystem.getUsername(), "1".equals(dataSystem.getFlag()) ? AesTool.decrypt(dataSystem.getPassword(), "ghca") : dataSystem.getPassword());
         Statement statement = connection.createStatement();
         String sqlFilter = desensitizationTable.getSqlFilter();
         String sql = "";
         if (!"".equals(sqlFilter) && sqlFilter != null) {
            sql = "select count(*) from " + schemaName + "." + desensitizationTable.getTablename() + " where " + sqlFilter;
         } else {
            sql = "select count(*) from " + schemaName + "." + desensitizationTable.getTablename();
         }

         System.out.println("" + sql);

         for(ResultSet rs = statement.executeQuery(sql); rs.next(); count = rs.getLong(1)) {
         }

         statement.close();
         connection.close();
      } catch (SQLException e) {
         e.printStackTrace();
      }

      return count + "";
   }

   public void executeDB_batchread_FILE_pwc_FILE(final ExecuteParam executeParam, String engineFlg) throws Exception {
      System.out.println(">>>>>>>>>>>>>>>>>DB_batchread_FILE_pwc_FILE<<<<<<<<<<<<<<<<<<");
      final Desensitizationsource desensitizationsource = (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", executeParam.getTaskid())});
      List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
      TCoreDatasystem tCoreDatasystemSource;
      if ("oracledmp".equals(executeParam.getSourcetype())) {
         tCoreDatasystemSource = null;
      } else {
         tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(executeParam.getDataSourceId());
      }

      Runtime rn = Runtime.getRuntime();
      Map<String, List<DesensitizationTablecolumn>> map = new HashMap();

      for(DesensitizationTable desensitizationTable : tableList) {
         List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
         List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
         map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
      }

      final EncryptionMasking encryptionmasking = (EncryptionMasking)this.encryptionmaskingDao.get(executeParam.getTaskid());
      encryptionmasking.setTaskstatus("1");
      this.encryptionmaskingDao.saveOrUpdate(encryptionmasking);
      this.encryptionmaskingDao.getSession().getTransaction().commit();

      for(int i = 0; i < tableList.size(); ++i) {
         DesensitizationTable desensitizationTable = (DesensitizationTable)tableList.get(i);
         String s_tableName = desensitizationTable.getTablename();
         this.createScriptFiletoSource(executeParam, desensitizationTable, executeParam.getSourceDataSystem().getDbtype(), tCoreDatasystemSource, (List)map.get(s_tableName), rn);
      }

      final CountDownLatch engineCountDownLatch = new CountDownLatch(1);

      try {
         this.taskExecutor.execute(new Runnable() {
            public void run() {
               try {
                  String xmlFileName = executeParam.getTaskNameReal();
                  System.out.println("xmlFileName is :" + xmlFileName);
                  System.out.println(">>>>>>>The client call engine start>>>>>>>>>>>>>>>>>>>>>");
                  DesensitizationEngineInterfaceImplService engineInterfaceImplService = new DesensitizationEngineInterfaceImplService();
                  DesensitizationEngineInterfaceImpl engineInterfaceImpl = (DesensitizationEngineInterfaceImpl)engineInterfaceImplService.getPort(DesensitizationEngineInterfaceImpl.class);
                  EngineParameter eParameter = new EngineParameter();
                  eParameter.setWorkflowName(xmlFileName);
                  eParameter.setGroupId(executeParam.getGroupId());
                  eParameter.setDataProcessType("DB_batchread_FILE_pwc_FILE");
                  EngineResult er = engineInterfaceImpl.startWorkflowEx(eParameter);
                  System.out.println("result is " + er.getReStatus());
                  System.out.println(">>>>>>>The client call engine end>>>>>>>>>>>>>>>>>>>>>");
               } catch (Exception e) {
                  e.printStackTrace();
                  String taskid = encryptionmasking.getId();
                  EncryptionMaskingImpl.updataRunstatus(taskid);
                  System.out.println(executeParam.getTaskNameReal() + "任务 调用引擎失败!");
               } finally {
                  engineCountDownLatch.countDown();
               }

            }
         });
         System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + engineCountDownLatch.getCount());
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         this.updateTask_taskstatus(encryptionmasking.getId(), "3");
      }

      final CountDownLatch countDownLatch = new CountDownLatch(tableList.size());

      for(final DesensitizationTable desensitizationTable : tableList) {
         this.taskExecutor.execute(new Runnable() {
            public void run() {
               final String s_tableName = desensitizationTable.getTablename();

               try {
                  Properties props = new Properties();

                  try {
                     props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                  } catch (IOException e) {
                     e.printStackTrace();
                  }

                  if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
                     System.out.println("---进入启动预计运行时间方法！");
                     String dataCount = "";
                     dataCount = EncryptionMaskingImpl.this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
                     System.out.println("数据源表" + s_tableName + "总行数：" + dataCount);
                     EncryptionMaskingImpl.this.redisService.set("dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName, dataCount);
                     System.out.println("预计运行时间，key=dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName + "，dataCount=" + dataCount);
                  }

                  EncryptionMaskingImpl.this.updateMonitorRunStatus(s_tableName, executeParam.getTableMap());
                  System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
                  System.out.println("创建执行脚本开始！tableName=" + s_tableName);
                  System.out.println("调用启动工作流方法开始！tableName=" + s_tableName);
                  String dbType = executeParam.getSourceDataSystem().getDbtype();
                  System.out.println("启动脚本开始！dbType=" + dbType + ",tableName=" + s_tableName);
                  if (!"SYBASE_IQ".equals(dbType) && !"MSSQLSERVER".equals(dbType)) {
                     if ("MYSQL".equals(dbType)) {
                        System.out.println("执行MySql源的脚本：/data/infa_mysqlload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                        CommandTool.commandRtn2("/data/infa_mysqlload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                     } else if ("RAPIDSDB".equals(dbType)) {
                        System.out.println("执行RAPIDSDB源的脚本：/data/infa_rapidsdbload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                        CommandTool.commandRtn2("/data/infa_rapidsdbload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                     } else if ("SYBASE".equals(dbType)) {
                        CommandTool.commandRtn2("/data/infa_sybase/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                        System.out.println("SYBASE执行源的脚本:完成");
                     } else if ("TERADATA".equals(dbType)) {
                        System.out.println("执行源的脚本：/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                        CommandTool.commandRtn("/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                        System.out.println("执行源的脚本:完成");
                     } else if ("ORACLE".equals(dbType)) {
                        System.out.println("ORACLE-dmp:根据传入的DMP文件、任务名和表名,解析DMP数据，将该表的数据插入到PIPE文件中");
                        if ("1".equals(desensitizationsource.getIsdmpfile())) {
                           EncryptionMaskingImpl.this.taskExecutor.execute(new Runnable() {
                              public void run() {
                                 String multiDempFile = desensitizationsource.getMultiDempFile();
                                 if ("0".equals(multiDempFile)) {
                                    if ("0".equals(desensitizationsource.getDmptype())) {
                                       Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "Dmpdp_tableInfoMap_masking");
                                       DmpDpTool.prasingDataByTableName(desensitizationsource.getSourcefiledir(), executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                    } else {
                                       Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "Dmp_tableInfoMap_masking");
                                       DmpTool.prasingDataByTableName(desensitizationsource.getSourcefiledir(), executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                    }
                                 } else {
                                    List<String> sourcefilelist = new ArrayList();
                                    String filelist = desensitizationsource.getFilelist();
                                    String filepath = desensitizationsource.getSourcefiledir();
                                    String[] sourcefiledirlist = filelist.split(",");

                                    for(String string : sourcefiledirlist) {
                                       sourcefilelist.add(filepath + "/" + string);
                                    }

                                    if ("0".equals(desensitizationsource.getDmptype())) {
                                       Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "multiDmpdp_tableInfoMap_masking");
                                       MultipleDmpDpTool.prasingDataByTableName(sourcefilelist, executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                    } else {
                                       Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "multiDmp_tableInfoMap_masking");
                                       MultipleDmpTool.prasingDataByTableName(sourcefilelist, executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                    }
                                 }

                              }
                           });
                        }

                        System.out.println("ORACLE-dmp： 执行源的脚本:完成");
                     }
                  }
               } catch (Exception e) {
                  e.printStackTrace();
               } finally {
                  countDownLatch.countDown();
               }

            }
         });
      }

   }

   @Async
   public void executeDB_batchread_FILE_pwc_FILE(final ExecuteParam executeParam) throws Exception {
      new Properties();
      Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      String engineType = props.getProperty("masking_engine_type");
      if ("1".equals(engineType)) {
         this.executeDB_batchread_FILE_pwc_FILE(executeParam, "1");
      } else {
         System.out.println(">>>>>>>>>>>>>>>>>DB_batchread_FILE_pwc_FILE<<<<<<<<<<<<<<<<<<");
         List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
         final Desensitizationsource desensitizationsource = (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", executeParam.getTaskid())});
         final TCoreDatasystem tCoreDatasystemSource;
         if ("1".equals(desensitizationsource.getIsdmpfile())) {
            tCoreDatasystemSource = null;
         } else {
            tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(executeParam.getDataSourceId());
         }

         final Runtime rn = Runtime.getRuntime();
         final Map<String, List<DesensitizationTablecolumn>> map = new HashMap();
         final CountDownLatch countDownLatch = new CountDownLatch(tableList.size());

         for(DesensitizationTable desensitizationTable : tableList) {
            List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
            List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
            map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
         }

         final EncryptionMasking encryptionmasking = (EncryptionMasking)this.encryptionmaskingDao.get(executeParam.getTaskid());
         encryptionmasking.setTaskstatus("1");
         this.encryptionmaskingDao.saveOrUpdate(encryptionmasking);
         this.encryptionmaskingDao.getSession().getTransaction().commit();

         for(final DesensitizationTable desensitizationTable : tableList) {
            this.taskExecutor.execute(new Runnable() {
               public void run() {
                  String sessionId = "";
                  String status = "4";
                  final String s_tableName = desensitizationTable.getTablename();
                  String workflowName = "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName;

                  try {
                     Properties props = new Properties();

                     try {
                        props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                     } catch (IOException e) {
                        e.printStackTrace();
                     }

                     if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
                        System.out.println("---进入启动预计运行时间方法！");
                        String dataCount = "";
                        dataCount = EncryptionMaskingImpl.this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
                        System.out.println("数据源表" + s_tableName + "总行数：" + dataCount);
                        EncryptionMaskingImpl.this.redisService.set("dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName, dataCount);
                        System.out.println("预计运行时间，key=dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName + "，dataCount=" + dataCount);
                     }

                     EncryptionMaskingImpl.this.updateMonitorRunStatus(s_tableName, executeParam.getTableMap());
                     System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
                     sessionId = LoginWebService.returnStatus(executeParam.getInfoProperty());
                     System.out.println("创建执行脚本开始！tableName=" + s_tableName);
                     if ("1".equals(desensitizationsource.getIsdmpfile())) {
                        executeParam.getSourceDataSystem().setDbtype("ORACLE");
                     }

                     EncryptionMaskingImpl.this.createScriptFiletoSource(executeParam, desensitizationTable, executeParam.getSourceDataSystem().getDbtype(), tCoreDatasystemSource, (List)map.get(s_tableName), rn);
                     System.out.println("调用启动工作流方法开始！tableName=" + s_tableName);
                     int runId = EncryptionMaskingImpl.this.startWorkFlowEx(workflowName, executeParam.getInfoProperty(), executeParam.getFolderName(), sessionId);
                     String dbType = executeParam.getSourceDataSystem().getDbtype();
                     System.out.println("启动脚本开始！dbType=" + dbType + ",tableName=" + s_tableName);
                     if (!"SYBASE_IQ".equals(dbType) && !"MSSQLSERVER".equals(dbType)) {
                        if ("MYSQL".equals(dbType)) {
                           System.out.println("执行MySql源的脚本：/data/infa_mysqlload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           CommandTool.commandRtn2("/data/infa_mysqlload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                        } else if ("RAPIDSDB".equals(dbType)) {
                           System.out.println("执行RAPIDSDB源的脚本：/data/infa_rapidsdbload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           CommandTool.commandRtn2("/data/infa_rapidsdbload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                        } else if ("SYBASE".equals(dbType)) {
                           CommandTool.commandRtn2("/data/infa_sybase/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           System.out.println("SYBASE执行源的脚本:完成");
                        } else if ("TERADATA".equals(dbType)) {
                           System.out.println("执行源的脚本：/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           CommandTool.commandRtn("/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           System.out.println("执行源的脚本:完成");
                        } else if ("ORACLE".equals(dbType)) {
                           System.out.println("ORACLE-dmp:根据传入的DMP文件、任务名和表名,解析DMP数据，将该表的数据插入到PIPE文件中");
                           if ("1".equals(desensitizationsource.getIsdmpfile())) {
                              EncryptionMaskingImpl.this.taskExecutor.execute(new Runnable() {
                                 public void run() {
                                    String multiDempFile = desensitizationsource.getMultiDempFile();
                                    if ("0".equals(multiDempFile)) {
                                       if ("0".equals(desensitizationsource.getDmptype())) {
                                          Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "Dmpdp_tableInfoMap_masking");
                                          DmpDpTool.prasingDataByTableName(desensitizationsource.getSourcefiledir(), executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                       } else {
                                          Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "Dmp_tableInfoMap_masking");
                                          DmpTool.prasingDataByTableName(desensitizationsource.getSourcefiledir(), executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                       }
                                    } else {
                                       List<String> sourcefilelist = new ArrayList();
                                       String filelist = desensitizationsource.getFilelist();
                                       String filepath = desensitizationsource.getSourcefiledir();
                                       String[] sourcefiledirlist = filelist.split(",");

                                       for(String string : sourcefiledirlist) {
                                          sourcefilelist.add(filepath + "/" + string);
                                       }

                                       if ("0".equals(desensitizationsource.getDmptype())) {
                                          Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "multiDmpdp_tableInfoMap_masking");
                                          MultipleDmpDpTool.prasingDataByTableName(sourcefilelist, executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                       } else {
                                          Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "multiDmp_tableInfoMap_masking");
                                          MultipleDmpTool.prasingDataByTableName(sourcefilelist, executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                       }
                                    }

                                 }
                              });
                           }

                           System.out.println("ORACLE-dmp： 执行源的脚本:完成");
                        }
                     }

                     String completeStatus = "0";
                     if (runId >= 0) {
                        completeStatus = EncryptionMaskingImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                     }

                     if ("1".equals(completeStatus)) {
                        System.out.println("表" + s_tableName + ",执行完成,通过阻塞方法！");
                        SessionBean sessionBean = EncryptionMaskingImpl.this.getLogForTaskMapping(executeParam.getFolderName(), executeParam.getInfoProperty(), executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
                        if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                           status = "1";
                        } else if ("FAILED".equals(sessionBean.getStatus())) {
                           status = "2";
                        } else if ("STOPPED".equals(sessionBean.getStatus())) {
                           status = "3";
                        } else {
                           status = "4";
                        }

                        System.out.println("执行更新监控表开始！tableName=" + s_tableName);
                        EncryptionMaskingImpl.this.updateMonitor(desensitizationTable.getTablename(), executeParam.getTableMap(), status, runId);
                     }

                     LogoutWebService.returnStatus(sessionId, executeParam.getInfoProperty());
                  } catch (Exception e) {
                     e.printStackTrace();
                  } finally {
                     countDownLatch.countDown();
                  }

               }
            });
         }

         try {
            System.out.println(">>>>>>>>>>>>>>>当前活动线程数：" + this.taskExecutor.getActiveCount());
            System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + countDownLatch.getCount());
            countDownLatch.await();
            System.out.println(">>>>>>>>>>>>>>>插入监控详细信息表开始！");
            this.insertMonitorInfo(tableList, executeParam.getInfoProperty(), executeParam.getFolderName(), executeParam.getTaskid(), executeParam.getTaskNameReal());
            this.updateTask_taskstatus(encryptionmasking.getId(), "3");
         } catch (Exception e) {
            e.printStackTrace();
         }

      }
   }

   public void executeDB_batchread_FILE_pwc_DB(final ExecuteParam executeParam, String engineFlg) throws Exception {
      System.out.println(">>>>>>>>>>>>>>>>>executeDB_batchread_FILE_pwc_DB<<<<<<<<<<<<<<<<<<");
      List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
      final Desensitizationsource desensitizationsource = (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", executeParam.getTaskid())});
      Map<String, List<DesensitizationTablecolumn>> map = new HashMap();

      for(DesensitizationTable desensitizationTable : tableList) {
         List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
         List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
         map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
      }

      final EncryptionMasking encryptionmasking = (EncryptionMasking)this.encryptionmaskingDao.get(executeParam.getTaskid());
      this.updateTask_taskstatus(encryptionmasking.getId(), "1");
      TCoreDatasystem tCoreDatasystemSource;
      if ("oracledmp".equals(executeParam.getSourcetype())) {
         tCoreDatasystemSource = null;
      } else {
         tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(executeParam.getDataSourceId());
      }

      Runtime rn = Runtime.getRuntime();

      for(int i = 0; i < tableList.size(); ++i) {
         DesensitizationTable desensitizationTable = (DesensitizationTable)tableList.get(i);
         String s_tableName = desensitizationTable.getTablename();
         this.createScriptFiletoSource(executeParam, desensitizationTable, executeParam.getSourceDataSystem().getDbtype(), tCoreDatasystemSource, (List)map.get(s_tableName), rn);
      }

      final CountDownLatch engineCountDownLatch = new CountDownLatch(1);

      try {
         this.taskExecutor.execute(new Runnable() {
            public void run() {
               try {
                  String xmlFileName = executeParam.getTaskNameReal();
                  System.out.println("xmlFileName is :" + xmlFileName);
                  System.out.println(">>>>>>>The client call engine start>>>>>>>>>>>>>>>>>>>>>");
                  DesensitizationEngineInterfaceImplService engineInterfaceImplService = new DesensitizationEngineInterfaceImplService();
                  DesensitizationEngineInterfaceImpl engineInterfaceImpl = (DesensitizationEngineInterfaceImpl)engineInterfaceImplService.getPort(DesensitizationEngineInterfaceImpl.class);
                  EngineParameter eParameter = new EngineParameter();
                  eParameter.setWorkflowName(xmlFileName);
                  eParameter.setGroupId(executeParam.getGroupId());
                  eParameter.setDataProcessType("DB_batchread_FILE_pwc_DB");
                  EngineResult er = engineInterfaceImpl.startWorkflowEx(eParameter);
                  System.out.println("result is " + er.getReStatus());
                  System.out.println(">>>>>>>The client call engine end>>>>>>>>>>>>>>>>>>>>>");
               } catch (Exception e) {
                  e.printStackTrace();
                  String taskid = encryptionmasking.getId();
                  EncryptionMaskingImpl.updataRunstatus(taskid);
                  System.out.println(executeParam.getTaskNameReal() + "任务 调用引擎失败!");
               } finally {
                  engineCountDownLatch.countDown();
               }

            }
         });
         System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + engineCountDownLatch.getCount());
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         this.updateTask_taskstatus(encryptionmasking.getId(), "3");
      }

      new CountDownLatch(tableList.size());

      for(int i = 0; i < tableList.size(); ++i) {
         final DesensitizationTable desensitizationTable = (DesensitizationTable)tableList.get(i);
         this.taskExecutor.execute(new Runnable() {
            public void run() {
               final String s_tableName = desensitizationTable.getTablename();

               try {
                  try {
                     Properties props = new Properties();

                     try {
                        props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                     } catch (IOException e) {
                        e.printStackTrace();
                     }

                     if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
                        System.out.println("---进入启动预计运行时间方法！");
                        String dataCount = "";
                        dataCount = EncryptionMaskingImpl.this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
                        System.out.println("数据源表" + desensitizationTable.getTablename() + "总行数：" + dataCount);
                        EncryptionMaskingImpl.this.redisService.set("dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName, dataCount);
                        System.out.println("预计运行时间，key=dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName + "，dataCount=" + dataCount);
                     }

                     System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
                     System.out.println("创建执行脚本开始！tableName=" + s_tableName);
                     String dbType = executeParam.getSourceDataSystem().getDbtype();
                     System.out.println("启动脚本开始！dbType=" + dbType + ",tableName=" + s_tableName);
                     if (!"SYBASE_IQ".equals(dbType)) {
                        if ("MSSQLSERVER".equals(dbType)) {
                           CommandTool.commandRtn("/data/infa_sqlserver/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           System.out.println("SQLSERVER执行源的脚本:完成");
                        } else if ("SYBASE".equals(dbType)) {
                           CommandTool.commandRtn2("/data/infa_sybase/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           System.out.println("SYBASE执行源的脚本:完成");
                        } else if ("MYSQL".equals(dbType)) {
                           System.out.println("执行MySql源的脚本：/data/infa_mysqlload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           CommandTool.commandRtn2("/data/infa_mysqlload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                        } else if ("RAPIDSDB".equals(dbType)) {
                           System.out.println("执行RAPIDSDB源的脚本：/data/infa_rapidsdbload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           CommandTool.commandRtn2("/data/infa_rapidsdbload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                        } else if ("TERADATA".equals(dbType)) {
                           System.out.println("执行源的脚本：/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           CommandTool.commandRtn("/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           System.out.println("执行源的脚本:完成");
                        } else if ("ORACLE".equals(dbType)) {
                           System.out.println("ORACLE-dmp:根据传入的DMP文件、任务名和表名,解析DMP数据，将该表的数据插入到PIPE文件中");
                           if ("1".equals(desensitizationsource.getIsdmpfile())) {
                              EncryptionMaskingImpl.this.taskExecutor.execute(new Runnable() {
                                 public void run() {
                                    String multiDempFile = desensitizationsource.getMultiDempFile();
                                    if ("0".equals(multiDempFile)) {
                                       if ("0".equals(desensitizationsource.getDmptype())) {
                                          Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "Dmpdp_tableInfoMap_masking");
                                          DmpDpTool.prasingDataByTableName(desensitizationsource.getSourcefiledir(), executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                       } else {
                                          Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "Dmp_tableInfoMap_masking");
                                          DmpTool.prasingDataByTableName(desensitizationsource.getSourcefiledir(), executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                       }
                                    } else {
                                       List<String> sourcefilelist = new ArrayList();
                                       String filelist = desensitizationsource.getFilelist();
                                       String filepath = desensitizationsource.getSourcefiledir();
                                       String[] sourcefiledirlist = filelist.split(",");

                                       for(String string : sourcefiledirlist) {
                                          sourcefilelist.add(filepath + "/" + string);
                                       }

                                       if ("0".equals(desensitizationsource.getDmptype())) {
                                          Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "multiDmpdp_tableInfoMap_masking");
                                          MultipleDmpDpTool.prasingDataByTableName(sourcefilelist, executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                       } else {
                                          Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "multiDmp_tableInfoMap_masking");
                                          MultipleDmpTool.prasingDataByTableName(sourcefilelist, executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                       }
                                    }

                                 }
                              });
                           }

                           System.out.println("ORACLE-dmp： 执行源的脚本:完成");
                        }
                     }
                  } catch (Exception e) {
                     e.printStackTrace();
                  }

               } finally {
                  ;
               }
            }
         });
      }

   }

   @Async
   public void executeDB_batchread_FILE_pwc_DB(final ExecuteParam executeParam) throws Exception {
      new Properties();
      Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      String engineType = props.getProperty("masking_engine_type");
      if ("1".equals(engineType)) {
         this.executeDB_batchread_FILE_pwc_DB(executeParam, "1");
      } else {
         System.out.println(">>>>>>>>>>>>>>>>>executeDB_batchread_FILE_pwc_DB<<<<<<<<<<<<<<<<<<");
         List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
         final Desensitizationsource desensitizationsource = (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", executeParam.getTaskid())});
         final TCoreDatasystem tCoreDatasystemSource;
         if ("1".equals(desensitizationsource.getIsdmpfile())) {
            tCoreDatasystemSource = null;
         } else {
            tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(executeParam.getDataSourceId());
         }

         final Runtime rn = Runtime.getRuntime();
         final Map<String, List<DesensitizationTablecolumn>> map = new HashMap();
         final CountDownLatch countDownLatch = new CountDownLatch(tableList.size());

         for(DesensitizationTable desensitizationTable : tableList) {
            List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
            List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
            map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
         }

         final EncryptionMasking encryptionmasking = (EncryptionMasking)this.encryptionmaskingDao.get(executeParam.getTaskid());
         encryptionmasking.setTaskstatus("1");
         this.encryptionmaskingDao.saveOrUpdate(encryptionmasking);
         this.encryptionmaskingDao.getSession().getTransaction().commit();

         for(final DesensitizationTable desensitizationTable : tableList) {
            this.taskExecutor.execute(new Runnable() {
               public void run() {
                  String sessionId = "";
                  String status = "4";
                  String t_tableName = (encryptionmasking.getTableprefix() == null ? "" : encryptionmasking.getTableprefix()) + desensitizationTable.getT_tablename() + (encryptionmasking.getTablesuffix() == null ? "" : encryptionmasking.getTablesuffix());
                  final String s_tableName = desensitizationTable.getTablename();
                  String workflowName = "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName;

                  try {
                     Properties props = new Properties();

                     try {
                        props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                     } catch (IOException e) {
                        e.printStackTrace();
                     }

                     if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
                        System.out.println("---进入启动预计运行时间方法！");
                        String dataCount = "";
                        dataCount = EncryptionMaskingImpl.this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
                        System.out.println("数据源表" + desensitizationTable.getTablename() + "总行数：" + dataCount);
                        EncryptionMaskingImpl.this.redisService.set("dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName, dataCount);
                        System.out.println("预计运行时间，key=dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName + "，dataCount=" + dataCount);
                     }

                     EncryptionMaskingImpl.this.updateMonitorRunStatus(s_tableName, executeParam.getTableMap());
                     System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
                     sessionId = LoginWebService.returnStatus(executeParam.getInfoProperty());
                     System.out.println("创建执行脚本开始！tableName=" + s_tableName);
                     if ("1".equals(desensitizationsource.getIsdmpfile())) {
                        executeParam.getSourceDataSystem().setDbtype("ORACLE");
                     }

                     EncryptionMaskingImpl.this.createScriptFiletoSource(executeParam, desensitizationTable, executeParam.getSourceDataSystem().getDbtype(), tCoreDatasystemSource, (List)map.get(s_tableName), rn);
                     System.out.println("调用启动工作流方法开始！tableName=" + s_tableName);
                     int runId = EncryptionMaskingImpl.this.startWorkFlowEx(workflowName, executeParam.getInfoProperty(), executeParam.getFolderName(), sessionId);
                     String dbType = executeParam.getTargetDataSystem().getDbtype();
                     System.out.println("启动脚本开始！dbType=" + dbType + ",tableName=" + s_tableName);
                     if (!"SYBASE_IQ".equals(dbType)) {
                        if ("MSSQLSERVER".equals(dbType)) {
                           CommandTool.commandRtn("/data/infa_sqlserver/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           System.out.println("SQLSERVER执行源的脚本:完成");
                        } else if ("SYBASE".equals(dbType)) {
                           CommandTool.commandRtn2("/data/infa_sybase/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           System.out.println("SYBASE执行源的脚本:完成");
                        } else if ("MYSQL".equals(dbType)) {
                           System.out.println("执行MySql源的脚本：/data/infa_mysqlload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           CommandTool.commandRtn2("/data/infa_mysqlload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                        } else if ("RAPIDSDB".equals(dbType)) {
                           System.out.println("执行RAPIDSDB源的脚本：/data/infa_rapidsdbload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           CommandTool.commandRtn2("/data/infa_rapidsdbload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                        } else if ("TERADATA".equals(dbType)) {
                           System.out.println("执行源的脚本：/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           CommandTool.commandRtn("/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           System.out.println("执行源的脚本:完成");
                        } else if ("ORACLE".equals(dbType)) {
                           System.out.println("ORACLE-dmp:根据传入的DMP文件、任务名和表名,解析DMP数据，将该表的数据插入到PIPE文件中");
                           if ("1".equals(desensitizationsource.getIsdmpfile())) {
                              EncryptionMaskingImpl.this.taskExecutor.execute(new Runnable() {
                                 public void run() {
                                    String multiDempFile = desensitizationsource.getMultiDempFile();
                                    if ("0".equals(multiDempFile)) {
                                       if ("0".equals(desensitizationsource.getDmptype())) {
                                          Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "Dmpdp_tableInfoMap_masking");
                                          DmpDpTool.prasingDataByTableName(desensitizationsource.getSourcefiledir(), executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                       } else {
                                          Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "Dmp_tableInfoMap_masking");
                                          DmpTool.prasingDataByTableName(desensitizationsource.getSourcefiledir(), executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                       }
                                    } else {
                                       List<String> sourcefilelist = new ArrayList();
                                       String filelist = desensitizationsource.getFilelist();
                                       String filepath = desensitizationsource.getSourcefiledir();
                                       String[] sourcefiledirlist = filelist.split(",");

                                       for(String string : sourcefiledirlist) {
                                          sourcefilelist.add(filepath + "/" + string);
                                       }

                                       if ("0".equals(desensitizationsource.getDmptype())) {
                                          Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "multiDmpdp_tableInfoMap_masking");
                                          MultipleDmpDpTool.prasingDataByTableName(sourcefilelist, executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                       } else {
                                          Map<String, Object> dmpTableInfoMap = (Map)EncryptionMaskingImpl.this.redisService.get(executeParam.getTaskNameReal() + "_" + "multiDmp_tableInfoMap_masking");
                                          MultipleDmpTool.prasingDataByTableName(sourcefilelist, executeParam.getTaskNameReal(), s_tableName, dmpTableInfoMap);
                                       }
                                    }

                                 }
                              });
                           }

                           System.out.println("ORACLE-dmp： 执行源的脚本:完成");
                        }
                     }

                     String completeStatus = "0";
                     if (runId >= 0) {
                        completeStatus = EncryptionMaskingImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                     }

                     if ("1".equals(completeStatus)) {
                        System.out.println("表" + s_tableName + ",执行完成,通过阻塞方法！");
                        SessionBean sessionBean = EncryptionMaskingImpl.this.getLogForTaskMapping(executeParam.getFolderName(), executeParam.getInfoProperty(), executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
                        if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                           status = "1";
                        } else if ("FAILED".equals(sessionBean.getStatus())) {
                           status = "2";
                        } else if ("STOPPED".equals(sessionBean.getStatus())) {
                           status = "3";
                        } else {
                           status = "4";
                        }

                        System.out.println("执行更新监控表开始！tableName=" + s_tableName);
                        EncryptionMaskingImpl.this.updateMonitor(s_tableName, executeParam.getTableMap(), status, runId);
                     }

                     LogoutWebService.returnStatus(sessionId, executeParam.getInfoProperty());
                  } catch (Exception e) {
                     e.printStackTrace();
                  } finally {
                     countDownLatch.countDown();
                  }

               }
            });
         }

         try {
            System.out.println(">>>>>>>>>>>>>>>当前活动线程数：" + this.taskExecutor.getActiveCount());
            System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + countDownLatch.getCount());
            countDownLatch.await();
            System.out.println(">>>>>>>>>>>>>>>插入监控详细信息表开始！");
            this.insertMonitorInfo(tableList, executeParam.getInfoProperty(), executeParam.getFolderName(), executeParam.getTaskid(), executeParam.getTaskNameReal());
            this.updateTask_taskstatus(encryptionmasking.getId(), "3");
            System.out.println(">>>>>>>>>>>>>>>任务已全部执行完成！同步表信息开始！");
            if (!"1".equals(desensitizationsource.getIsdmpfile())) {
               this.synTableParam(tableList, executeParam);
            }
         } catch (Exception e) {
            e.printStackTrace();
         }

      }
   }

   public long getTableNumByAll(String sql) {
      return this.encryptionmaskingDao.getTableNumByAll(sql);
   }

   public void executeTask(final ExecuteParam executeParam, String engineFlg) throws Exception {
      System.out.println(">>>>>>>>>>>>>>>>>执行开始<<<<<<<<<<<<<<<<<<");
      List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
      final Desensitizationsource desensitizationsource = (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", executeParam.getTaskid())});
      final Desensitizationtarget desensitizationtarget = (Desensitizationtarget)this.desensitizationtargetDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", executeParam.getTaskid())});
      executeParam.setSourcetype(desensitizationsource.getExecution_type());
      executeParam.setTargettype(desensitizationtarget.getExecution_type());
      TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(executeParam.getDataTargetId() != null ? executeParam.getDataTargetId() : "ghca");
      final TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(executeParam.getDataSourceId() != null ? executeParam.getDataSourceId() : "ghca");
      Runtime rn = Runtime.getRuntime();
      Map<String, List<DesensitizationTablecolumn>> map = new HashMap();

      for(DesensitizationTable desensitizationTable : tableList) {
         List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
         List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
         map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
      }

      for(int i = 0; i < tableList.size(); ++i) {
         DesensitizationTable desensitizationTable = (DesensitizationTable)tableList.get(i);
         String s_tableName = desensitizationTable.getTablename();
         this.createScriptFiletotarget(executeParam, desensitizationTable, executeParam.getTargetDataSystem().getDbtype(), tCoreDatasystemTarget, (List)map.get(s_tableName), rn);
         System.out.println("创建目标脚本开始！");
         this.createScriptFiletoSource(executeParam, desensitizationTable, executeParam.getSourceDataSystem().getDbtype(), tCoreDatasystemSource, (List)map.get(s_tableName), rn);
         System.out.println("创建源脚本开始！");
      }

      final EncryptionMasking encryptionmasking = (EncryptionMasking)this.encryptionmaskingDao.get(executeParam.getTaskid());
      encryptionmasking.setTaskstatus("1");
      this.encryptionmaskingDao.saveOrUpdate(encryptionmasking);
      this.encryptionmaskingDao.getSession().getTransaction().commit();
      final CountDownLatch engineCountDownLatch = new CountDownLatch(1);

      try {
         this.taskExecutor.execute(new Runnable() {
            public void run() {
               try {
                  String xmlFileName = executeParam.getTaskNameReal();
                  System.out.println("xmlFileName is :" + xmlFileName);
                  System.out.println(">>>>>>>The client call engine start>>>>>>>>>>>>>>>>>>>>>");
                  DesensitizationEngineInterfaceImplService engineInterfaceImplService = new DesensitizationEngineInterfaceImplService();
                  DesensitizationEngineInterfaceImpl engineInterfaceImpl = (DesensitizationEngineInterfaceImpl)engineInterfaceImplService.getPort(DesensitizationEngineInterfaceImpl.class);
                  EngineParameter eParameter = new EngineParameter();
                  eParameter.setWorkflowName(xmlFileName);
                  eParameter.setGroupId(executeParam.getGroupId());
                  String targetdbType = executeParam.getTargetDataSystem().getDbtype();
                  if ("normal".equals(desensitizationsource.getExecution_type()) && "HIVE".equals(targetdbType)) {
                     eParameter.setDataProcessType("normal_pwc_Hive");
                  } else if (!"normal".equals(desensitizationsource.getExecution_type()) && "HIVE".equals(targetdbType)) {
                     eParameter.setDataProcessType("DB_batchread_FILE_pwc_Hive");
                  } else if (!"normal".equals(desensitizationtarget.getExecution_type())) {
                     eParameter.setDataProcessType("DB_batchread_FILE_pwc_FILE_batchwrite_DB");
                  } else {
                     eParameter.setDataProcessType("DB_batchread_FILE_pwc_xxx");
                  }

                  EngineResult er = engineInterfaceImpl.startWorkflowEx(eParameter);
                  System.out.println("result is " + er.getReStatus());
                  System.out.println(">>>>>>>The client call engine end>>>>>>>>>>>>>>>>>>>>>");
               } catch (Exception e) {
                  e.printStackTrace();
                  String taskid = encryptionmasking.getId();
                  EncryptionMaskingImpl.updataRunstatus(taskid);
                  System.out.println(executeParam.getTaskNameReal() + "任务 调用引擎失败!");
               } finally {
                  engineCountDownLatch.countDown();
               }

            }
         });
         System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + engineCountDownLatch.getCount());
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         this.updateTask_taskstatus(encryptionmasking.getId(), "3");
      }

      final CountDownLatch countDownLatch = new CountDownLatch(tableList.size());

      for(final DesensitizationTable desensitizationTable : tableList) {
         this.taskExecutor.execute(new Runnable() {
            public void run() {
               String sessionId = "";
               String status = "4";
               String t_tableName = (encryptionmasking.getTableprefix() == null ? "" : encryptionmasking.getTableprefix()) + desensitizationTable.getT_tablename() + (encryptionmasking.getTablesuffix() == null ? "" : encryptionmasking.getTablesuffix());
               final String s_tableName = desensitizationTable.getTablename();

               try {
                  Properties props = new Properties();

                  try {
                     props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                  } catch (IOException e) {
                     e.printStackTrace();
                  }

                  final String hdfs_path = props.getProperty("hdfs_path") + "/tmp";
                  if ("startup".equals(props.getProperty("Forecast_Run_Time")) && tCoreDatasystemSource != null && !tCoreDatasystemSource.getFlag().equals("2")) {
                     System.out.println("---进入启动预计运行时间方法！");
                     String dataCount = "";
                     dataCount = EncryptionMaskingImpl.this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
                     System.out.println("数据源表" + s_tableName + "总行数：" + dataCount);
                     EncryptionMaskingImpl.this.redisService.set("dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName, dataCount);
                     System.out.println("预计运行时间，key=dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName + "，dataCount=" + dataCount);
                  }

                  EncryptionMaskingImpl.this.updateMonitorRunStatus(s_tableName, executeParam.getTableMap());
                  System.out.println("创建执行脚本开始！tableName=" + s_tableName);
                  String targetdbType = executeParam.getTargetDataSystem().getDbtype();
                  String sourcedbType = executeParam.getSourceDataSystem().getDbtype();
                  System.out.println("启动脚本开始！dbType=" + targetdbType + ",tableName=" + s_tableName);
                  System.out.println("调用启动工作流方法开始！tableName=" + s_tableName);
                  if (!"normal".equals(desensitizationsource.getExecution_type())) {
                     switch (sourcedbType) {
                        case "TERADATA":
                           System.out.println("执行源的脚本：/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           CommandTool.commandRtn2("/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           System.out.println("执行源的脚本:完成");
                           break;
                        case "MSSQLSERVER":
                           CommandTool.commandRtn2("/data/infa_sqlserver/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           System.out.println("SQLSERVER执行源的脚本:完成");
                           break;
                        case "MYSQL":
                           CommandTool.commandRtn2("/data/infa_mysqlload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           System.out.println("MYSQL执行源的脚本:完成");
                           break;
                        case "RAPIDSDB":
                           CommandTool.commandRtn2("/data/infa_rapidsdbload/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                           System.out.println("RAPIDSDB执行源的脚本:完成");
                     }
                  }

                  if (!"normal".equals(desensitizationtarget.getExecution_type())) {
                     switch (targetdbType) {
                        case "TERADATA":
                           System.out.println("执行目标的脚本");
                           CommandTool.commandRtn2("/data/infa_teradata/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                           System.out.println("执行目标的脚本:完成");
                           break;
                        case "MSSQLSERVER":
                           CommandTool.command("chmod -R 777 /data/infa_sqlserver/");
                           if (!"normal".equals(desensitizationsource.getExecution_type()) && sourcedbType.equals("HIVE")) {
                              System.out.println("执行源的脚本：/data/hive/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                              String filepath = XmlTool.getFileValue(sourcedbType + "/db-fileDir");
                              String delimiter = XmlTool.getFileValue(sourcedbType + "/db-sourcedelimiter");
                              String charset = XmlTool.getFileValue(sourcedbType + "/db-codePage");
                              Connection conn = JdbcTool.getConnection(tCoreDatasystemSource);
                              PipeTool pipe = new PipeTool(conn, executeParam.getSourceSchemaName() + "." + s_tableName, filepath + "/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".pipe", delimiter, charset);
                              pipe.writeFile();
                              System.out.println("HIVE执行源的脚本:完成");
                           }

                           String completeStatus = EncryptionMaskingImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                           if ("1".equals(completeStatus)) {
                              CommandTool.commandRtn2("/data/infa_sqlserver/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                           }

                           System.out.println("SQLSERVER执行目标的脚本:完成");
                           break;
                        case "SYBASE_IQ":
                           CommandTool.commandRtn2("/data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh /data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".pipe");
                           break;
                        case "MYSQL":
                           System.out.println("执行目标的脚本");
                           CommandTool.commandRtn2("/data/infa_mysqlload/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                           System.out.println("执行目标的脚本:完成");
                           break;
                        case "RAPIDSDB":
                           System.out.println("执行目标的脚本");
                           CommandTool.commandRtn2("/data/infa_rapidsdbload/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                           System.out.println("执行目标的脚本:完成");
                           break;
                        case "DB2":
                           System.out.println("执行目标的脚本");
                           CommandTool.commandRtn2("/data/infa_db2/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                           System.out.println("执行目标的脚本:完成");
                           break;
                        case "GREENPLUM":
                           System.out.println("执行目标的脚本");
                           CommandTool.commandRtn2("/data/infa_greenplum/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                           System.out.println("执行目标的脚本:完成");
                     }
                  }

                  if (sourcedbType.equals("HIVE") && !targetdbType.equals("MSSQLSERVER")) {
                     System.out.println("执行源的脚本：/data/hive/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                     final String filepath = XmlTool.getFileValue(sourcedbType + "/db-fileDir");
                     String delimiter = XmlTool.getFileValue(sourcedbType + "/db-sourcedelimiter");
                     final String charset = XmlTool.getFileValue(sourcedbType + "/db-codePage");
                     Connection conn = JdbcTool.getConnection(tCoreDatasystemSource);
                     System.out.println("s+:" + executeParam.getSourcetype() + "：：：" + "hdfsexport");
                     if (executeParam.getSourcetype().equals("hdfsexport")) {
                        EncryptionMaskingImpl.this.taskExecutor.execute(new Runnable() {
                           public void run() {
                              try {
                                 Thread.sleep(3000L);
                              } catch (InterruptedException e1) {
                                 e1.printStackTrace();
                              }

                              System.out.println(">>>>>>正要查看：hdfs文件个数");
                              System.out.println(hdfs_path + "/ghca/" + executeParam.getTaskNameReal() + "/" + s_tableName);
                              List<String> list_hdfs = new ArrayList();

                              try {
                                 Process process = null;
                                 int port = SocketTool.getPort();
                                 process = SocketTool.start(process, port, executeParam.getTaskid());
                                 IHiveRMI iRmi = (IHiveRMI)Naming.lookup("rmi://127.0.0.1:" + port + "/My_RMI");
                                 String user = tCoreDatasystemSource.getLoginprincipal();
                                 user = "hive";
                                 String xmlPath = tCoreDatasystemSource.getXmlpath();
                                 String pathStr = hdfs_path + "/ghca/" + executeParam.getTaskNameReal() + "/" + s_tableName;
                                 List<HashMap<String, String>> listfile = iRmi.getHdfsList(xmlPath, user, pathStr);
                                 System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                                 if (listfile != null) {
                                    for(HashMap<String, String> listmap : listfile) {
                                       if (!"".equals(listmap.get("path"))) {
                                          list_hdfs.add(listmap.get("path"));
                                       }
                                    }

                                    System.out.println(">>>>>>hdfs文件个数：" + listfile.size());
                                    iRmi.readHdfsToPipe(list_hdfs, tCoreDatasystemSource.getXmlpath(), user, filepath + "/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".pipe", charset);
                                    process.destroy();
                                 } else {
                                    System.out.println(">getHdfsList");
                                 }
                              } catch (Exception e) {
                                 e.printStackTrace();
                              }

                           }
                        });
                     } else if (executeParam.getSourcetype().equals("fastexport")) {
                        PipeTool pipe = new PipeTool(conn, executeParam.getSourceSchemaName() + "." + s_tableName, filepath + "/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".pipe", delimiter, charset, desensitizationTable.getSqlFilter(), "");
                        pipe.writeFile();
                     }
                  }
               } catch (Exception e) {
                  e.printStackTrace();
               } finally {
                  countDownLatch.countDown();
               }

            }
         });
      }

   }

   @Async
   public void executeTask(final ExecuteParam executeParam) throws Exception {
      new Properties();
      Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      String engineType = props.getProperty("masking_engine_type");
      if ("1".equals(engineType)) {
         this.executeTask(executeParam, "1");
      } else {
         System.out.println(">>>>>>>>>>>>>>>>>执行开始<<<<<<<<<<<<<<<<<<");
         List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
         final Desensitizationsource desensitizationsource = (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", executeParam.getTaskid())});
         final Desensitizationtarget desensitizationtarget = (Desensitizationtarget)this.desensitizationtargetDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", executeParam.getTaskid())});
         executeParam.setSourcetype(desensitizationsource.getExecution_type());
         executeParam.setTargettype(desensitizationtarget.getExecution_type());
         final TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(executeParam.getDataTargetId() != null ? executeParam.getDataTargetId() : "ghca");
         final TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(executeParam.getDataSourceId() != null ? executeParam.getDataSourceId() : "ghca");
         final Runtime rn = Runtime.getRuntime();
         final Map<String, List<DesensitizationTablecolumn>> map = new HashMap();
         final CountDownLatch countDownLatch = new CountDownLatch(tableList.size());

         for(DesensitizationTable desensitizationTable : tableList) {
            List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
            List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
            map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
         }

         final EncryptionMasking encryptionmasking = (EncryptionMasking)this.encryptionmaskingDao.get(executeParam.getTaskid());
         this.updateTask_taskstatus(encryptionmasking.getId(), "1");

         for(final DesensitizationTable desensitizationTable : tableList) {
            this.taskExecutor.execute(new Runnable() {
               public void run() {
                  String sessionId = "";
                  String status = "4";
                  String t_tableName = (encryptionmasking.getTableprefix() == null ? "" : encryptionmasking.getTableprefix()) + desensitizationTable.getT_tablename() + (encryptionmasking.getTablesuffix() == null ? "" : encryptionmasking.getTablesuffix());
                  String s_tableName = desensitizationTable.getTablename();
                  String workflowName = "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName;

                  try {
                     Properties props = new Properties();

                     try {
                        props = PropertiesLoaderUtils.loadAllProperties("config.properties");
                     } catch (IOException e) {
                        e.printStackTrace();
                     }

                     if ("startup".equals(props.getProperty("Forecast_Run_Time")) && tCoreDatasystemSource != null && !tCoreDatasystemSource.getFlag().equals("2")) {
                        System.out.println("---进入启动预计运行时间方法！");
                        String dataCount = "";
                        dataCount = EncryptionMaskingImpl.this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
                        System.out.println("数据源表" + s_tableName + "总行数：" + dataCount);
                        EncryptionMaskingImpl.this.redisService.set("dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName, dataCount);
                        System.out.println("预计运行时间，key=dataCount:" + encryptionmasking.getTasknamereal() + "_" + s_tableName + "，dataCount=" + dataCount);
                     }

                     EncryptionMaskingImpl.this.updateMonitorRunStatus(s_tableName, executeParam.getTableMap());
                     System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
                     sessionId = LoginWebService.returnStatus(executeParam.getInfoProperty());
                     System.out.println("创建执行脚本开始！tableName=" + s_tableName);
                     EncryptionMaskingImpl.this.createScriptFiletoSource(executeParam, desensitizationTable, executeParam.getSourceDataSystem().getDbtype(), tCoreDatasystemSource, (List)map.get(s_tableName), rn);
                     EncryptionMaskingImpl.this.createScriptFiletotarget(executeParam, desensitizationTable, executeParam.getTargetDataSystem().getDbtype(), tCoreDatasystemTarget, (List)map.get(s_tableName), rn);
                     String targetdbType = executeParam.getTargetDataSystem().getDbtype();
                     String isKerberos = executeParam.getTargetDataSystem().getIskerberos();
                     String sourcedbType = executeParam.getSourceDataSystem().getDbtype();
                     System.out.println("启动脚本开始！dbType=" + targetdbType + ",tableName=" + s_tableName);
                     System.out.println("调用启动工作流方法开始！tableName=" + s_tableName);
                     int runId = EncryptionMaskingImpl.this.startWorkFlowEx(workflowName, executeParam.getInfoProperty(), executeParam.getFolderName(), sessionId);
                     if (!"normal".equals(desensitizationsource.getExecution_type())) {
                        switch (sourcedbType) {
                           case "TERADATA":
                              System.out.println("执行源的脚本：/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                              CommandTool.commandRtn2("/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                              System.out.println("执行源的脚本:完成");
                              break;
                           case "MSSQLSERVER":
                              CommandTool.commandRtn2("/data/infa_sqlserver/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                              System.out.println("SQLSERVER执行源的脚本:完成");
                        }
                     }

                     if (!"normal".equals(desensitizationtarget.getExecution_type())) {
                        switch (targetdbType) {
                           case "TERADATA":
                              System.out.println("执行目标的脚本");
                              CommandTool.commandRtn2("/data/infa_teradata/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                              System.out.println("执行目标的脚本:完成");
                              break;
                           case "MSSQLSERVER":
                              CommandTool.command("chmod -R 777 /data/infa_sqlserver/");
                              if (!"normal".equals(desensitizationsource.getExecution_type()) && sourcedbType.equals("HIVE")) {
                                 System.out.println("执行源的脚本：/data/hive/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                                 TCoreConfig tcoreConfig = (TCoreConfig)EncryptionMaskingImpl.this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", executeParam.getDataSourceId())});
                                 if (tcoreConfig != null) {
                                    String filepath = tcoreConfig.getFileDir();
                                    String delimiter = tcoreConfig.getSourcedelimiter();
                                    String charset = tcoreConfig.getCodePage();
                                    if (filepath == null || filepath.equals("") || delimiter == null || delimiter.equals("") || charset == null || charset.equals("")) {
                                       filepath = XmlTool.getFileValue(sourcedbType + "/db-fileDir");
                                       delimiter = XmlTool.getFileValue(sourcedbType + "/db-sourcedelimiter");
                                       charset = XmlTool.getFileValue(sourcedbType + "/db-codePage");
                                    }

                                    EncryptionMaskingImpl.this.iskeberos(tCoreDatasystemSource);
                                    Connection conn = JdbcTool.getConnection(tCoreDatasystemSource);
                                    PipeTool pipe = new PipeTool(conn, executeParam.getSourceSchemaName() + "." + s_tableName, filepath + "/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".pipe", delimiter, charset);
                                    pipe.writeFile();
                                    System.out.println("HIVE执行源的脚本:完成");
                                 }
                              }

                              String completeStatus = EncryptionMaskingImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                              if ("1".equals(completeStatus)) {
                                 CommandTool.commandRtn2("/data/infa_sqlserver/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                              }

                              System.out.println("SQLSERVER执行目标的脚本:完成");
                              break;
                           case "SYBASE_IQ":
                              CommandTool.commandRtn2("/data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh /data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".pipe");
                              break;
                           case "MYSQL":
                              System.out.println("执行目标的脚本");
                              CommandTool.commandRtn2("/data/infa_mysqlload/target/" + executeParam.getTaskNameReal() + "/" + t_tableName + ".sh");
                              System.out.println("执行目标的脚本:完成");
                        }
                     }

                     if (sourcedbType.equals("HIVE") && !targetdbType.equals("MSSQLSERVER")) {
                        System.out.println("执行源的脚本：/data/hive/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".sh");
                        TCoreConfig tcoreConfig = (TCoreConfig)EncryptionMaskingImpl.this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", executeParam.getDataSourceId())});
                        if (tcoreConfig != null) {
                           String filepath = tcoreConfig.getFileDir();
                           String delimiter = tcoreConfig.getSourcedelimiter();
                           String charset = tcoreConfig.getCodePage();
                           if (filepath == null || filepath.equals("") || delimiter == null || delimiter.equals("") || charset == null || charset.equals("")) {
                              filepath = XmlTool.getFileValue(sourcedbType + "/db-fileDir");
                              delimiter = XmlTool.getFileValue(sourcedbType + "/db-sourcedelimiter");
                              charset = XmlTool.getFileValue(sourcedbType + "/db-codePage");
                           }

                           EncryptionMaskingImpl.this.iskeberos(tCoreDatasystemSource);
                           Connection conn = JdbcTool.getConnection(tCoreDatasystemSource);
                           PipeTool pipe = new PipeTool(conn, executeParam.getSourceSchemaName() + "." + s_tableName, filepath + "/source/" + executeParam.getTaskNameReal() + "/" + s_tableName + ".pipe", delimiter, charset, desensitizationTable.getSqlFilter(), "");
                           pipe.writeFile();
                           System.out.println("HIVE执行源的脚本:完成");
                        }
                     }

                     String completeStatus = "0";
                     if (runId >= 0) {
                        completeStatus = EncryptionMaskingImpl.this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                     }

                     if ("1".equals(completeStatus)) {
                        System.out.println("表" + s_tableName + ",执行完成,通过阻塞方法！");
                        SessionBean sessionBean = EncryptionMaskingImpl.this.getLogForTaskMapping(executeParam.getFolderName(), executeParam.getInfoProperty(), executeParam.getTaskNameReal() + "_" + s_tableName, sessionId);
                        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
                        if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                           if (targetdbType.equals("HIVE") && "on".equals(isKerberos)) {
                           }

                           status = "1";
                        } else if ("FAILED".equals(sessionBean.getStatus())) {
                           status = "2";
                        } else if ("STOPPED".equals(sessionBean.getStatus())) {
                           status = "3";
                        } else {
                           status = "4";
                        }

                        System.out.println("执行更新监控表开始！tableName=" + s_tableName);
                        EncryptionMaskingImpl.this.updateMonitor(s_tableName, executeParam.getTableMap(), status, runId);
                     }

                     LogoutWebService.returnStatus(sessionId, executeParam.getInfoProperty());
                  } catch (Exception e) {
                     e.printStackTrace();
                  } finally {
                     countDownLatch.countDown();
                  }

               }
            });
         }

         try {
            System.out.println(">>>>>>>>>>>>>>>当前活动线程数：" + this.taskExecutor.getActiveCount());
            System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + countDownLatch.getCount());
            countDownLatch.await();
            System.out.println(">>>>>>>>>>>>>>>插入监控详细信息表开始！");
            this.insertMonitorInfo(tableList, executeParam.getInfoProperty(), executeParam.getFolderName(), executeParam.getTaskid(), executeParam.getTaskNameReal());
            this.updateTask_taskstatus(encryptionmasking.getId(), "3");
         } catch (Exception e) {
            e.printStackTrace();
         }

      }
   }

   public boolean generate_xml(Map map, HttpServletRequest request) throws Exception {
      String progressid = (String)map.get("progressid");
      Map<String, String> mapparam = new HashMap();
      InfoProperty infoProperty = this.getInfoProperty();
      Properties props = new Properties();
      ProgressVO pogress = new ProgressVO();
      pogress.setProgressState(true);
      pogress.setProgresscontent("正在执行脱敏任务.........");
      pogress.setProgressValue(new Double((double)55.0F));
      request.getSession().setAttribute("progress", pogress);

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String codepage = (String)map.get("codepage");
      String folder = (String)map.get("folder");
      if (folder == null) {
         folder = "ghca";
      }

      String cb_title = (String)map.get("cb_title");
      String fix = (String)map.get("fix");
      String stamp = "s" + (String)map.get("stamp");
      String limit = (String)map.get("limit");
      String separate = (String)map.get("separate");
      String xml_folder_up_path = request.getSession().getServletContext().getRealPath("") + props.getProperty("file_up_path");
      String xml_folder_down_path = request.getSession().getServletContext().getRealPath("") + props.getProperty("file_down_path");
      String xml_file_path = xml_folder_up_path + stamp + ".xml";
      List<DesensitizationTablecolumn> colum = (List)map.get("colum");
      Map<String, String> data_rule = this.getDataRuleMap();
      String mappletDir = props.getProperty("mappletDir");
      mapparam.put("folderName", folder);
      mapparam.put("execution_type_s", "FILE");
      mapparam.put("execution_type_t", "FILE");
      mapparam.put("domainName", infoProperty.getDomainname());
      mapparam.put("mappletDir", mappletDir);
      mapparam.put("repository", infoProperty.getRepository());
      mapparam.put("xmlLocation", xml_file_path);
      mapparam.put("serverName", infoProperty.getInteservicename());
      mapparam.put("target_type", "FILE");
      mapparam.put("source_type", "FILE");
      mapparam.put("isrecover", "0");
      mapparam.put("hdfsDir", props.getProperty("hdfs_dir"));
      Config pwc_config = this.pwc_config(mapparam);
      List<Info> infoList = new ArrayList();
      SourceInfo pwc_sourceInfo = new SourceInfo();
      TargetInfo pwc_targetInfo = new TargetInfo();
      List<ColumnInfo> sourcecolumnInfoList = new ArrayList();
      List<ColumnInfo> targetcolumnInfoList = new ArrayList();

      for(DesensitizationTablecolumn desensitizationTablecolumn : colum) {
         ColumnInfo pwc_columnInfo_source = new ColumnInfo();
         pwc_columnInfo_source.setColumnName(desensitizationTablecolumn.getColumnname());
         pwc_columnInfo_source.setDataType("string".toUpperCase());
         pwc_columnInfo_source.setKeyType(0);
         pwc_columnInfo_source.setMaskingRule((String)data_rule.get(desensitizationTablecolumn.getRuleid()));
         pwc_columnInfo_source.setNullable(0);
         pwc_columnInfo_source.setQualifierType("string".toLowerCase());
         pwc_columnInfo_source.setScale("");
         pwc_columnInfo_source.setPrecision(desensitizationTablecolumn.getColumnlength());
         sourcecolumnInfoList.add(pwc_columnInfo_source);
         targetcolumnInfoList.add(pwc_columnInfo_source);
      }

      pwc_sourceInfo.setColumnInfoList(sourcecolumnInfoList);
      pwc_sourceInfo.setConnectName("");
      pwc_sourceInfo.setDataBaseType(DataBaseType.FLATFILE);
      FlatFile sourceflatFile = new FlatFile();
      sourceflatFile.setCodePage(this.pageCode(Integer.parseInt(codepage)));
      sourceflatFile.setCommand("");
      sourceflatFile.setDelimiter(separate);
      sourceflatFile.setFilename(stamp + "." + fix);
      sourceflatFile.setFileType(0);
      sourceflatFile.setFileDir(xml_folder_up_path);
      sourceflatFile.setQuoteCharacter(Integer.parseInt(limit));
      sourceflatFile.setSkipRows("".equals(cb_title) ? 0 : 1);
      pwc_sourceInfo.setFlatFile(sourceflatFile);
      pwc_sourceInfo.setName(stamp);
      pwc_sourceInfo.setSchema("");
      pwc_sourceInfo.setSqlFilter("");
      pwc_sourceInfo.setSqlQuery("");
      pwc_targetInfo.setConnectName("");
      pwc_targetInfo.setDataBaseType(DataBaseType.FLATFILE);
      FlatFile targetflatFile = new FlatFile();
      targetflatFile.setCodePage(this.pageCode(Integer.parseInt(codepage)));
      targetflatFile.setCommand("");
      targetflatFile.setDelimiter(separate);
      targetflatFile.setFilename(stamp + "." + fix);
      targetflatFile.setFileType(0);
      targetflatFile.setFileDir(xml_folder_down_path);
      targetflatFile.setQuoteCharacter(Integer.parseInt(limit));
      targetflatFile.setSkipRows("".equals(cb_title) ? 0 : 1);
      pwc_targetInfo.setFlatFile(targetflatFile);
      pwc_targetInfo.setName(stamp);
      pwc_targetInfo.setSchema("");
      pwc_targetInfo.setIsTruncate(0);
      pwc_targetInfo.setWriteType(0);
      pwc_targetInfo.setColumnInfoList(targetcolumnInfoList);
      Info info = this.pwc_Info(pwc_sourceInfo, pwc_targetInfo, stamp);
      infoList.add(info);
      int pwc_state = PowerXml.generatePowerXml(infoList, pwc_config);
      if (pwc_state != 1) {
         pogress.setProgressid(progressid);
         pogress.setProgresscontent("执行脱敏任务失败");
         pogress.setProgressState(false);
         request.getSession().setAttribute("progress", pogress);
         return false;
      } else {
         pogress.setProgressid(progressid);
         pogress.setProgressState(true);
         pogress.setProgresscontent("正在执行脱敏任务.........");
         pogress.setProgressValue(new Double((double)55.0F));
         request.getSession().setAttribute("progress", pogress);
         String con_file = EncryptionMaskingImpl.class.getResource("/").getPath().replaceAll("%20", " ") + "infofile" + File.separator + "con_import.xml";
         String foldername = pwc_config.getFolderName();
         String repository = infoProperty.getRepository();
         this.updateImportFile(con_file, foldername, repository);
         if (!this.isteststate) {
            String importlog = InfoExecUtil.executImport(infoProperty.getPmrepexepath(), xml_file_path, con_file, infoProperty.getXmldir() + File.separator + "log.txt");
            if (!importlog.contains("已成功完成") && !importlog.contains("successfully")) {
               pogress.setProgressid(progressid);
               pogress.setProgressState(false);
               pogress.setProgresscontent("导入脱敏任务失败");
               request.getSession().setAttribute("progress", pogress);
               return false;
            }

            pogress.setProgressid(progressid);
            pogress.setProgressState(true);
            pogress.setProgresscontent("正在执行脱敏任务.........");
            pogress.setProgressValue(new Double((double)60.0F));
            request.getSession().setAttribute("progress", pogress);
            String sessionId = LoginWebService.returnStatus(infoProperty);
            int runId = this.startWorkFlowEx("wf_" + stamp, infoProperty, foldername, sessionId);
            String completeStatus = "0";
            if (runId >= 0) {
               completeStatus = this.workflowTaskCompleteMonitor(infoProperty, foldername, "wf_" + stamp, sessionId);
            }

            if ("1".equals(completeStatus)) {
               System.out.println("执行完成,通过阻塞方法！");
               SessionBean sessionBean = this.getLogForTaskMapping(foldername, infoProperty, stamp, sessionId);
               System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
               if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                  String command = "zip -j " + xml_folder_down_path + stamp + ".zip " + xml_folder_down_path + stamp + "." + fix;
                  CommandTool.command(command);
                  pogress.setProgressid(progressid);
                  pogress.setProgressState(true);
                  pogress.setProgresscontent("执行脱敏任务成功并且开始压缩.........请稍等");
                  pogress.setProgressValue(new Double((double)99.0F));
                  request.getSession().setAttribute("progress", pogress);
                  return true;
               }

               return false;
            }

            LogoutWebService.returnStatus(sessionId, infoProperty);
         }

         pogress.setProgressid(progressid);
         pogress.setProgressState(true);
         pogress.setProgresscontent("完成");
         pogress.setProgressValue(new Double((double)100.0F));
         request.getSession().setAttribute("progress", pogress);
         return true;
      }
   }

   public void droptable(String tableName, Connection tconn, String schemaName) {
      if (JdbcTool.isTableExisted(tconn, tableName + "_e1")) {
         JdbcTool.dropTable(tconn, schemaName, tableName + "_e1");
      }

      if (JdbcTool.isTableExisted(tconn, tableName + "_e2")) {
         JdbcTool.dropTable(tconn, schemaName, tableName + "_e2");
      }

      if (JdbcTool.isTableExisted(tconn, "ET_" + tableName)) {
         JdbcTool.dropTable(tconn, schemaName, "ET_" + tableName);
      }

      if (JdbcTool.isTableExisted(tconn, "WT_" + tableName)) {
         JdbcTool.dropTable(tconn, schemaName, "WT_" + tableName);
      }

      if (JdbcTool.isTableExisted(tconn, "UV_" + tableName)) {
         JdbcTool.dropTable(tconn, schemaName, "UV_" + tableName);
      }

      if (JdbcTool.isTableExisted(tconn, tableName + "_log")) {
         JdbcTool.dropTable(tconn, schemaName, tableName + "_log");
      }

   }

   public EncryptionMasking queryTaskByName(String taskname, String projectid) {
      List<EncryptionMasking> encryptionmaskinglist = this.encryptionmaskingDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("taskname", taskname), Restrictions.eq("projectid", projectid)});
      return encryptionmaskinglist != null && encryptionmaskinglist.size() > 0 ? (EncryptionMasking)encryptionmaskinglist.get(0) : null;
   }

   public List<DesensitizationMonitorInfo> queryMonitorInfo(String taskid) {
      List<DesensitizationMonitor> desensitizationMonitorList = this.desensitizationMonitorDao.queryAll(Order.desc("groupid"), new Criterion[]{Restrictions.eq("taskid", taskid)});
      BigInteger groupid = ((DesensitizationMonitor)desensitizationMonitorList.get(0)).getGroupid();
      List<DesensitizationMonitor> desensitizationMonitorList1 = this.desensitizationMonitorDao.queryAll(new Criterion[]{Restrictions.eq("groupid", groupid)});
      List<String> inlist = new ArrayList();

      for(DesensitizationMonitor desensitizationMonitor : desensitizationMonitorList1) {
         inlist.add(desensitizationMonitor.getId());
      }

      List<DesensitizationMonitorInfo> desensitizationMonitorInfoList = this.desensitizationMonitorInfoDao.queryAll(new Criterion[]{Restrictions.in("monitorid", inlist), Restrictions.in("widgettype", new Object[]{"源"})});
      return desensitizationMonitorInfoList;
   }

   public static String getIpAddress() {
      try {
         Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
         InetAddress ip = null;

         while(allNetInterfaces.hasMoreElements()) {
            NetworkInterface netInterface = (NetworkInterface)allNetInterfaces.nextElement();
            if (!netInterface.isLoopback() && !netInterface.isVirtual() && netInterface.isUp()) {
               Enumeration<InetAddress> addresses = netInterface.getInetAddresses();

               while(addresses.hasMoreElements()) {
                  ip = (InetAddress)addresses.nextElement();
                  if (ip != null && ip instanceof Inet4Address) {
                     return ip.getHostAddress();
                  }
               }
            }
         }
      } catch (Exception e) {
         System.err.println("IP地址获取失败" + e.toString());
      }

      return "";
   }

   public void addErrLog(String strs, String tasknamereal, String user) {
      int insertLogNum = strs.length() / 1800;
      int isremaining = strs.length() % 1800;
      insertLogNum += isremaining != 0 ? 1 : 0;

      for(int i = 0; i < insertLogNum; ++i) {
         TConsoleLog record = new TConsoleLog();
         int start = i * 1800;
         int end = (i + 1) * 1800;
         end = end > strs.length() ? strs.length() : end;
         record.setNote(strs.substring(start, end));
         record.setModule("新建脱敏任务+导入");
         record.setUser(user);
         record.setLogno(tasknamereal);
         record.setOperationtime(new Date());
         record.setFlag(i + "");
         this.insertLog(record);
      }

   }

   public String getTasknamereal(String taskid) {
      EncryptionMasking encryptionmasking = this.encryptionmaskingDao.getById(taskid);
      return encryptionmasking.getTasknamereal();
   }

   public DesensitizationMonitor getMoniterBytaskid(String taskid) {
      List<DesensitizationMonitor> desensitizationMonitorList = this.desensitizationMonitorDao.queryAll(Order.desc("executetime"), new Criterion[]{Restrictions.eq("taskid", taskid)});
      return desensitizationMonitorList.size() == 0 ? null : (DesensitizationMonitor)desensitizationMonitorList.get(0);
   }

   public List<ColumnInfoVO> queryColumnInfo(String structureid) {
      List<TCoreFileStructurecolumn> listFile = this.fileSystemService.queryFileStructureColumn(structureid);
      List<ColumnInfoVO> list = new ArrayList();

      for(TCoreFileStructurecolumn tCoreFileStructurecolumn : listFile) {
         ColumnInfoVO columnInfoVO = new ColumnInfoVO();
         columnInfoVO.setColumnname(tCoreFileStructurecolumn.getColumnname());
         columnInfoVO.setColumnsize(tCoreFileStructurecolumn.getColumnaccuracy());
         columnInfoVO.setTargettypename(tCoreFileStructurecolumn.getColumntype());
         columnInfoVO.setTypename(tCoreFileStructurecolumn.getColumntype());
         columnInfoVO.setDecimaldigits(tCoreFileStructurecolumn.getColumndecimal());
         list.add(columnInfoVO);
      }

      return list;
   }

   private void hasExcel(ExecuteParam executeParam, DesensitizationTable desensitizationTable, String delimit, String quotecharacter, String rowdelimiter, String codepage) {
      String quotecharacter1 = "";
      String rowdelimiter1 = "";
      if ("single".equals(quotecharacter)) {
         quotecharacter1 = "'";
      } else if ("double".equals(quotecharacter)) {
         quotecharacter1 = "\"";
      } else {
         quotecharacter1 = "";
      }

      if ("9".equals(rowdelimiter)) {
         rowdelimiter1 = "\t";
      } else if ("10".equals(rowdelimiter)) {
         rowdelimiter1 = "\n";
      } else if ("13".equals(rowdelimiter)) {
         rowdelimiter1 = "\r";
      }

      String sch1 = executeParam.getSourceFileDir() + "/" + desensitizationTable.getFilename();
      String sch = desensitizationTable.getFilename();
      TCoreDatasystem datasystem = executeParam.getSourceDataSystem();
      if (datasystem != null) {
         String dbtype = datasystem.getDbtype();
         switch (datasystem.getDbtype()) {
            case "FTP":
               sch = XmlTool.getFileValue(dbtype + "/localdir") + "s_" + sch.substring(0, sch.lastIndexOf(".")) + ".txt";
               sch1 = XmlTool.getFileValue(dbtype + "/localdir") + "s_" + desensitizationTable.getFilename();
               break;
            case "SFTP":
               sch = XmlTool.getFileValue(dbtype + "/localdir") + "s_" + sch.substring(0, sch.lastIndexOf(".")) + ".txt";
               sch1 = XmlTool.getFileValue(dbtype + "/localdir") + "s_" + desensitizationTable.getFilename();
               break;
            default:
               sch = executeParam.getSourceFileDir() + "/" + sch.substring(0, sch.lastIndexOf(".")) + ".txt";
         }
      }

      File targetFile = new File(sch1);
      if (targetFile.exists()) {
         try {
            String txt = ExcelTool.readExcel(sch1, 0, delimit, quotecharacter1, rowdelimiter1);
            TxtTool.exportTxt(txt, sch, codepage);
         } catch (InvalidFormatException | IOException | EncryptedDocumentException e1) {
            ((Exception)e1).printStackTrace();
         }
      }

   }

   public List<Map<String, Object>> selectTaskTaskstatus(String taskid, Long groupid) {
      new Properties();
      PreparedStatement preparedStatement = null;
      ResultSet resultSet = null;
      List<Map<String, Object>> desensitizationMonitorMapList = new ArrayList();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String sqlurl = props.get("jdbc.url").toString();
         String username = props.get("jdbc.user").toString();
         String password = props.get("jdbc.password").toString();
         String driver = props.get("jdbc.driver").toString();
         Connection connection = JdbcTool.getConnection(driver, sqlurl, username, password);
         String sql = "select flag,taskid,tasktype,runstatus  from desensitization_monitor where taskid = '" + taskid + "' and groupid= " + groupid;
         preparedStatement = connection.prepareStatement(sql);
         resultSet = preparedStatement.executeQuery();
         Map<String, Object> desensitizationMonitorMap = new HashMap();

         while(resultSet.next()) {
            Object flag = resultSet.getObject(1);
            Object taskidObjec = resultSet.getObject(2);
            Object tasktype = resultSet.getObject(3);
            Object runstatus = resultSet.getObject(4);
            desensitizationMonitorMap.put("flag", flag);
            desensitizationMonitorMap.put("taskidObjec", taskidObjec);
            desensitizationMonitorMap.put("tasktype", tasktype);
            desensitizationMonitorMap.put("runstatus", runstatus);
            desensitizationMonitorMapList.add(desensitizationMonitorMap);
         }

         resultSet.close();
         connection.close();
      } catch (IOException e) {
         e.printStackTrace();
      } catch (SQLException e) {
         e.printStackTrace();
      }

      return desensitizationMonitorMapList;
   }

   public HashMap<String, List<TCoreFieldSensitiveMemory>> getAllField(String version, String schema) {
      HashMap<String, List<TCoreFieldSensitiveMemory>> map = new HashMap();
      if (version != null && !"".equals(version)) {
         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         String filepath = "";
         String ver = version.split("/")[0];
         if ("AllVersion".equals(ver)) {
            File file = new File(props.getProperty("AllVersion"));
            if (file.listFiles() != null && file.listFiles().length > 0) {
               filepath = props.getProperty("AllVersion") + file.listFiles()[0].getName();
            }
         } else if ("ProjectVersion".equals(ver)) {
            File file = new File(props.getProperty("ProjectVersion") + version.split("/")[1]);
            if (file.listFiles() != null && file.listFiles().length > 0) {
               filepath = props.getProperty("ProjectVersion") + version.split("/")[1] + File.separator + file.listFiles()[0].getName();
            }
         } else if ("TaskVersion".equals(ver)) {
            filepath = props.getProperty("TaskVersion") + version.split("/")[1] + "/" + version.split("/")[2];
         }

         map = this.versionList(filepath, schema);
      }

      return map;
   }

   public HashMap<String, List<TCoreFieldSensitiveMemory>> versionList(String filepath, String schema) {
      HashMap<String, List<TCoreFieldSensitiveMemory>> map = new HashMap();
      if (!FileTool.isFileExit(filepath)) {
         return map;
      } else {
         InputStreamReader newRead = null;

         try {
            newRead = new InputStreamReader(new FileInputStream(filepath), "GBK");
         } catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
         } catch (FileNotFoundException e1) {
            e1.printStackTrace();
         }

         BufferedReader newBufferedReader = new BufferedReader(newRead);
         String newInformationLine = "";
         String[] str = null;

         try {
            while((newInformationLine = newBufferedReader.readLine()) != null) {
               str = newInformationLine.split(",", -1);
               String tableName = str[1];
               String schemaName = str[0];
               String columName = str[2];
               String regextypeName = str[6];
               String ruleid = str[5];
               if (schema.equals(schemaName)) {
                  List<TCoreFieldSensitiveMemory> listfiled = (List)map.get(tableName);
                  if (listfiled == null) {
                     listfiled = new ArrayList();
                  }

                  TCoreFieldSensitiveMemory tCoreFieldSensitiveMemory = new TCoreFieldSensitiveMemory();
                  tCoreFieldSensitiveMemory.setColumnname(columName);
                  tCoreFieldSensitiveMemory.setTablename(tableName);
                  tCoreFieldSensitiveMemory.setRegextype(regextypeName);
                  tCoreFieldSensitiveMemory.setRuie(regextypeName);
                  tCoreFieldSensitiveMemory.setRuleid(ruleid);
                  listfiled.add(tCoreFieldSensitiveMemory);
                  map.put(tableName, listfiled);
               }
            }
         } catch (IOException e) {
            e.printStackTrace();
         }

         return map;
      }
   }

   public void downFile(EncryptionMasking encryptionmasking, DesensitizationTable desensitizationTable, ExecuteParam executeParam) {
      String status = "1";
      String t_tableName = (encryptionmasking.getTableprefix() == null ? "" : encryptionmasking.getTableprefix()) + desensitizationTable.getT_tablename() + (encryptionmasking.getTablesuffix() == null ? "" : encryptionmasking.getTablesuffix());
      String s_tableName = desensitizationTable.getTablename();
      DesensitizationFile desensitizationFile = executeParam.getDesensitizationFile();
      TCoreDatasystem datasystem = executeParam.getSourceDataSystem();
      if (datasystem != null) {
         String dbtype = datasystem.getDbtype();
         String username = "";
         String password = "";
         String host = "";
         Integer port = 0;
         String localpath = "";
         String path = "";
         String filename = desensitizationTable.getFilename();
         switch (dbtype) {
            case "FTP":
               if ("".equals(filename) && desensitizationFile != null) {
                  filename = t_tableName + desensitizationFile.getSuffix();
               }

               username = datasystem.getUsername();
               password = datasystem.getPassword();
               host = datasystem.getDbip();
               port = Integer.parseInt(datasystem.getDbport());
               localpath = XmlTool.getFileValue(dbtype + "/localdir") + "s_" + filename;
               path = desensitizationTable.getFilepath();
               boolean flag = false;
               FtpTool.downFile(host, port, username, password, path, filename, localpath);
               System.out.println("ftp:下载");
               break;
            case "SFTP":
               if ("".equals(filename) && desensitizationFile != null) {
                  filename = t_tableName + desensitizationFile.getSuffix();
               }

               username = datasystem.getUsername();
               password = datasystem.getPassword();
               host = datasystem.getDbip();
               port = Integer.parseInt(datasystem.getDbport());
               path = desensitizationTable.getFilepath();
               localpath = XmlTool.getFileValue(dbtype + "/localdir") + "s_" + filename;
               SFTPUtil sftp = new SFTPUtil(username, password, host, port);
               ResultVO resultvo = SFTPUtil.login();
               if (resultvo.getResult()) {
                  try {
                     sftp.download(path, filename, localpath);
                  } catch (Exception e) {
                     e.printStackTrace();
                  }
               }

               sftp.logout();
         }
      }

   }

   public void uploadFile(EncryptionMasking encryptionmasking, DesensitizationTable desensitizationTable, DesensitizationFile desensitizationFile) throws IOException, SftpException {
      String[] typeSplit = encryptionmasking.getTasktype().split("to");
      String targetType = typeSplit[1];
      System.out.println("targetType:" + targetType);
      if ("FTP".equals(targetType) || "SFTP".equals(targetType)) {
         String t_tableName = (encryptionmasking.getTableprefix() == null ? "" : encryptionmasking.getTableprefix()) + desensitizationTable.getT_tablename() + (encryptionmasking.getTablesuffix() == null ? "" : encryptionmasking.getTablesuffix());
         System.out.println(">>>>>>>>>>>>>>>>>>>>上传类型为=" + encryptionmasking.getTasktype());
         String fileDir = XmlTool.getFileValue(targetType + "/localdir");
         System.out.println("fileDir=" + fileDir + "t_" + desensitizationTable.getTablename() + desensitizationFile.getSuffix());
         String t_filepath = fileDir + "t_" + desensitizationTable.getTablename() + desensitizationFile.getSuffix();
         String s_filepath = fileDir + "s_" + desensitizationTable.getFilename();
         String t_filepath_txt = fileDir + "t_" + desensitizationTable.getTablename() + ".txt";
         String s_filepath_txt = fileDir + "s_" + desensitizationTable.getFilename().substring(0, desensitizationTable.getFilename().lastIndexOf(".")) + ".txt";
         File file = new File(t_filepath);
         System.out.println("文件长度：" + file.length());
         String username = desensitizationFile.getUsername();
         String password = desensitizationFile.getUserpassword();
         String host = desensitizationFile.getIp();
         Integer port = Integer.parseInt(desensitizationFile.getPort());
         String filename = desensitizationTable.getFilename();
         if ("".equals(filename)) {
            filename = t_tableName + desensitizationFile.getSuffix();
         }

         if (desensitizationFile.getFiletype() == 2) {
            System.out.println("上传文件类型为SFTP");
            System.out.println("Filedir:" + desensitizationFile.getFiledir());
            System.out.println("Filename" + filename);
            SFTPUtil sftp = new SFTPUtil(username, password, host, port);
            SFTPUtil.login();
            InputStream is = new FileInputStream(file);
            filename = t_tableName + desensitizationFile.getSuffix();
            sftp.upload(desensitizationFile.getFiledir(), filename, is);
            is.close();
            sftp.logout();
         } else if (desensitizationFile.getFiletype() == 1) {
            System.out.println("上传文件类型为FTP");
            System.out.println("Filedir:" + desensitizationFile.getFiledir());
            System.out.println("Filename" + filename);
            filename = t_tableName + desensitizationFile.getSuffix();
            InputStream is = new FileInputStream(file);
            FtpTool.uploadFile(host, port, username, password, desensitizationFile.getFiledir(), filename, is);
            is.close();
         }

         FileTool.removeFile(s_filepath_txt);
         FileTool.removeFile(t_filepath_txt);
         FileTool.removeFile(s_filepath);
         FileTool.removeFile(t_filepath);
      }

   }

   public void iskeberos(TCoreDatasystem datasystem) {
      if ("HIVE".equals(datasystem.getDbtype()) && "on".equals(datasystem.getIskerberos())) {
         System.setProperty("java.security.krb5.conf", datasystem.getXmlpath() + "/krb5.conf");
      }

   }

   public Map<String, String> callBackAll(JSONObject param) {
      Map<String, String> map = new HashMap();
      String tasknamereal = param.getString("tasknamereal");
      String table = param.getString("table");
      String type = param.getString("type");
      new EncryptionMasking();
      EncryptionMasking encryptionmasking = (EncryptionMasking)this.encryptionmaskingDao.queryUnique(new Criterion[]{Restrictions.eq("tasknamereal", tasknamereal)});
      String taskId = encryptionmasking.getId();
      if ("0".equals(type)) {
         this.queryTableList(taskId);
         DesensitizationTable desensitizationTable = this.queryTableByTableName(taskId, table);
         DesensitizationFile desensitizationFile = this.queryDesensitizationfileBytaskid(taskId);

         try {
            if (".xlsx".equals(desensitizationFile.getSuffix()) || ".xls".equals(desensitizationFile.getSuffix())) {
               this.toExcelCase(encryptionmasking, desensitizationFile, desensitizationTable);
            }

            this.uploadFile(encryptionmasking, desensitizationTable, desensitizationFile);
         } catch (IOException e) {
            e.printStackTrace();
         } catch (SftpException e) {
            e.printStackTrace();
         }
      } else if ("1".equals(type)) {
      }

      return map;
   }

   public void excelToFile(EncryptionMasking encryptionmasking, DesensitizationTable desensitizationTable, ExecuteParam executeParam) {
      String[] typeSplit1 = encryptionmasking.getTasktype().split("to");
      String targetType1 = typeSplit1[0];
      String delimit = "";
      String quotecharacter = "";
      String rowdelimiter = "";
      String codepage = "";
      if (desensitizationTable.getFilename() != null && desensitizationTable.getFilename().contains(".xl")) {
         new TCoreFileStructurespliter();
         TCoreFileStructurespliter tCoreFileStructurespliter = (TCoreFileStructurespliter)this.tCoreFileStructurespliterDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", desensitizationTable.getFilestructureid())});
         TCoreFileStructure tCoreFileStructure = (TCoreFileStructure)this.tCoreFileStructureDao.queryUnique(new Criterion[]{Restrictions.eq("id", desensitizationTable.getFilestructureid())});
         delimit = tCoreFileStructurespliter.getDelimiters();
         quotecharacter = tCoreFileStructurespliter.getQuotecharacter();
         rowdelimiter = tCoreFileStructurespliter.getRowdelimiter();
         codepage = this.pageCode(Integer.parseInt(tCoreFileStructure.getCodepage()));
      }

      if (desensitizationTable.getFilename().contains(".xls") || desensitizationTable.getFilename().contains(".xlsx")) {
         this.hasExcel(executeParam, desensitizationTable, delimit, quotecharacter, rowdelimiter, codepage);
      }

   }

   public boolean toExcelCase(EncryptionMasking encryptionmasking, DesensitizationFile desensitizationFile, DesensitizationTable desensitizationTable) throws IOException {
      String[] typeSplit = encryptionmasking.getTasktype().split("to");
      String targetType = typeSplit[1];
      String sch1 = desensitizationFile.getFiledir() + "/" + desensitizationTable.getT_tablename() + ".txt";
      String path = desensitizationFile.getFiledir() + "/" + desensitizationTable.getT_tablename() + ".xls";
      if ("FTP".equals(targetType) || "SFTP".equals(targetType)) {
         String fileDir = XmlTool.getFileValue(targetType + "/localdir");
         sch1 = fileDir + "t_" + desensitizationTable.getTablename() + ".txt";
         path = fileDir + "t_" + desensitizationTable.getT_tablename() + ".xls";
      }

      int lineCount = 0;
      String deli = desensitizationFile.getDelimiters();
      String quot = desensitizationFile.getQuotecharacter();
      System.out.println(sch1);
      File fileTarget = new File(sch1);
      if (!fileTarget.exists()) {
         return false;
      } else {
         List<String> line = TxtTool.importTxt(sch1);
         if (line.isEmpty()) {
            return false;
         } else if ((desensitizationTable.getFilename() == null || !desensitizationTable.getFilename().contains(".xls") && !desensitizationTable.getFilename().contains(".xlsx")) && line.size() > 1048576) {
            return false;
         } else {
            try {
               LinkedBlockingQueue<HashMap<String, String>> queue = new LinkedBlockingQueue();
               String[] lineArr = null;
               String[] ss = null;
               if ("1".equalsIgnoreCase(quot)) {
                  ss = ((String)line.get(0)).split(Pattern.quote(deli) + "(?=([^']*'[^']*')*[^']*$)", -1);
               } else if ("2".equalsIgnoreCase(quot)) {
                  ss = ((String)line.get(0)).split(Pattern.quote(deli) + "(?=([^\"]*\"[^\"]*\")*[^\"]*$)", -1);
               } else {
                  ss = ((String)line.get(0)).split(Pattern.quote(deli), -1);
               }

               List<Integer> columnWidthList = new ArrayList();
               Map<String, String> titlevalue = new LinkedHashMap();
               int count = 0;

               for(int k = 0; k < ss.length; ++k) {
                  titlevalue.put("column" + k, "column" + k);
                  columnWidthList.add(6000);
               }

               for(int i = 0; i < line.size(); ++i) {
                  HashMap<String, String> hashmap = new HashMap();

                  for(int j = 0; j < ss.length; ++j) {
                     if (line.get(i) != null) {
                        if ("1".equalsIgnoreCase(quot)) {
                           lineArr = ((String)line.get(i)).split(Pattern.quote(deli) + "(?=([^']*'[^']*')*[^']*$)", -1);
                        } else if ("2".equalsIgnoreCase(quot)) {
                           lineArr = ((String)line.get(i)).split(Pattern.quote(deli) + "(?=([^\"]*\"[^\"]*\")*[^\"]*$)", -1);
                        } else {
                           lineArr = ((String)line.get(i)).split(Pattern.quote(deli), -1);
                        }

                        hashmap.put("column" + j, removeQuotation(lineArr[j], quot));
                     }
                  }

                  queue.put(hashmap);
               }

               ExcelTool.gettxtExcel(path, queue, titlevalue, columnWidthList, (List)null);
               FileTool.removeFile(sch1);
            } catch (Exception e) {
               e.printStackTrace();
            }

            return true;
         }
      }
   }

   public static String removeQuotation(String str, String quoteCharacter) {
      String reValue = null;
      if ((null == str || "".equals(str)) && "none".equalsIgnoreCase(quoteCharacter)) {
         return null;
      } else if (("1".equalsIgnoreCase(quoteCharacter) || "2".equalsIgnoreCase(quoteCharacter)) && !str.contains("'") && !str.contains("\"")) {
         if (!"".equals(str) && null != str) {
            return " ".equals(str) ? str : reValue;
         } else {
            return null;
         }
      } else if (("1".equalsIgnoreCase(quoteCharacter) || "2".equalsIgnoreCase(quoteCharacter)) && (str.contains("'") || str.contains("\""))) {
         reValue = str.substring(1, str.length() - 1);
         if (reValue.toString().matches("\".*")) {
            reValue = ",";
         } else if (reValue.toString().matches(".*\".*")) {
            reValue = reValue.toString().trim();
            reValue = reValue.toString().substring(0, reValue.toString().indexOf("\""));
         }

         return reValue;
      } else {
         return str;
      }
   }

   public List<TCoreSecretkey> selectSecretkey() {
      List<TCoreSecretkey> list = this.tCoreSecretkeyDao.queryAll();
      return list;
   }
}
