package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.TCoreEngineServerInfoDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngineServerInfo;
import com.chenyang.nse.bussiness.service.core.EngineServerInfoService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Repository
@EnableAsync
@Transactional
public class EngineServerInfoServiceImpl implements EngineServerInfoService {
   @Autowired
   private TCoreEngineServerInfoDao tCoreEngineServerInfoDao;

   public List<TCoreEngineServerInfo> queryTask(String servername, PageInfo pageInfo) {
      List<TCoreEngineServerInfo> list = this.tCoreEngineServerInfoDao.queryByPageInfo(pageInfo, Order.desc("updatetime"), new Criterion[]{Restrictions.like("servername", "%" + servername + "%"), Restrictions.eq("delflg", "0")});
      return list;
   }

   public void saveEngineServer(Map<String, String> map) {
      TCoreEngineServerInfo tCoreEngineServerInfo = new TCoreEngineServerInfo();
      String serverType = (String)map.get("configuration_type");
      if (serverType.equals("engine-server")) {
         String engineid = (String)map.get("engineid");
         if (!"".equals(engineid)) {
            tCoreEngineServerInfo.setId(engineid);
         }

         tCoreEngineServerInfo.setServername((String)map.get("servername"));
         tCoreEngineServerInfo.setIp((String)map.get("serverip"));
         tCoreEngineServerInfo.setUsername((String)map.get("username"));
         tCoreEngineServerInfo.setPwd((String)map.get("password"));
         tCoreEngineServerInfo.setIsrun((String)map.get("serverstatus"));
         tCoreEngineServerInfo.setRemarks((String)map.get("engine-note"));
         tCoreEngineServerInfo.setCreatetime(new Date());
         tCoreEngineServerInfo.setUpdatetime(new Date());
         tCoreEngineServerInfo.setDelflg("0");
         tCoreEngineServerInfo.setServerid((String)map.get("serverid"));
         this.tCoreEngineServerInfoDao.saveOrUpdate(tCoreEngineServerInfo);
      }

   }

   public TCoreEngineServerInfo queryServerByName(String servername) {
      List<TCoreEngineServerInfo> tCoreEngineServerInfoLst = this.tCoreEngineServerInfoDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("servername", servername), Restrictions.eq("delflg", "0")});
      return tCoreEngineServerInfoLst != null && tCoreEngineServerInfoLst.size() > 0 ? (TCoreEngineServerInfo)tCoreEngineServerInfoLst.get(0) : null;
   }

   public TCoreEngineServerInfo queryServerById(String serverid) {
      return (TCoreEngineServerInfo)this.tCoreEngineServerInfoDao.queryUnique(new Criterion[]{Restrictions.eq("id", serverid)});
   }

   public void updateEngineServer(Map<String, String> map) {
      if (null != map && map.containsKey("serverid") && StringUtils.isNotBlank((String)map.get("serverid"))) {
         TCoreEngineServerInfo updInfo = this.queryServerById((String)map.get("serverid"));
         updInfo.setServername((String)map.get("servername"));
         updInfo.setIp((String)map.get("ip"));
         updInfo.setUsername((String)map.get("username"));
         updInfo.setPwd((String)map.get("pwd"));
         updInfo.setIsrun((String)map.get("isrun"));
         updInfo.setRemarks((String)map.get("remarks"));
         updInfo.setUpdatetime(new Date());
         updInfo.setDelflg("0");
         this.tCoreEngineServerInfoDao.update(updInfo);
      }

   }

   public void updateEngineServer(TCoreEngineServerInfo updInfo) {
      if (null != updInfo) {
         this.tCoreEngineServerInfoDao.update(updInfo);
      }

   }
}
