package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.core.EngineDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreEngineDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreImporttaskDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingTaskDao;
import com.chenyang.nse.bussiness.dao.table.core.temporary.TCoreMonitorTemporaryDao;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.CONFIG;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.CONNECTIONREFERENCE;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.FOLDER;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.INSTANCE;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.MAPPING;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.MAPPLET;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.POWERMART;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.REPOSITORY;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.SESSION;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.SESSIONEXTENSION;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.SOURCE;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.TARGET;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.WORKFLOW;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.ModifyImportFile;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.InfoExecUtil;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.ToObjutil;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreImporttask;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTask;
import com.chenyang.nse.bussiness.entity.param.SaveExTaskParam;
import com.chenyang.nse.bussiness.service.core.ExportWorkflowService;
import com.chenyang.nse.bussiness.service.info.InfoService;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Service
@Transactional
public class ExportWorkflowServiceImpl implements ExportWorkflowService {
   @Autowired
   private TCoreImporttaskDao tCoreImporttaskDao;
   @Autowired
   private InfoService infoService;
   @Autowired
   private TCoreEngineDao tCoreEngineDao;
   @Autowired
   private EngineDao engineDao;
   @Autowired
   private TCoreMaskingTaskDao tCoreMaskingTaskDao;
   @Autowired
   private TCoreMonitorTemporaryDao tCoreMonitorTemporaryDao;

   public List<TCoreImporttask> queryTask(PageInfo pageInfo, List<String> flag) {
      long count = this.tCoreImporttaskDao.count(new Criterion[]{Restrictions.in("flag", flag)});
      pageInfo.setCount(count);
      List<TCoreImporttask> list = this.tCoreImporttaskDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{Restrictions.in("flag", flag)});
      return list;
   }

   public void add(TCoreImporttask texportTask) {
      texportTask.setCreatetime(new Date());
      texportTask.setFlag("20");
      this.tCoreImporttaskDao.save(texportTask);
   }

   public InfoProperty getInfoProperty(String engineid) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      return info;
   }

   public boolean taskExport(String taskid) {
      TCoreImporttask task = (TCoreImporttask)this.tCoreImporttaskDao.get(taskid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      boolean cre_fd = this.infoService.createFolderInEngine(task.getEngineid(), "exp_" + task.getTaskname() + "_" + task.getId());

      try {
         String con_file = ExportWorkflowServiceImpl.class.getResource("/").getPath().replaceAll("%20", " ") + "infofile/con_import.xml";
         File file = new File(con_file);
         ModifyImportFile mi = new ModifyImportFile();
         InputStream is = new FileInputStream(task.getFilepath());
         ToObjutil to = new ToObjutil();
         BufferedReader tBufferedReader = new BufferedReader(new InputStreamReader(is));
         int k = 0;
         StringBuffer tStringBuffer = new StringBuffer();
         new String("");

         String sTempOneLine;
         while((sTempOneLine = tBufferedReader.readLine()) != null) {
            ++k;
            if (k == 2) {
               tStringBuffer.append("");
            } else {
               tStringBuffer.append(sTempOneLine);
            }
         }

         Object obj = ToObjutil.unmarshalmo("com.chenyang.nse.bussiness.engine.infa.basic.xmlbean", tStringBuffer.toString());
         POWERMART powermart = (POWERMART)obj;
         REPOSITORY pre = (REPOSITORY)powermart.getREPOSITORY().get(0);
         FOLDER folder = (FOLDER)pre.getFOLDER().get(0);

         try {
            ModifyImportFile.updateConfigFileXML("TARGETFOLDERNAME", file, "exp_" + task.getTaskname() + "_" + task.getId());
            ModifyImportFile.updateConfigFileXML("SOURCEFOLDERNAME", file, folder.getNAME());
            ModifyImportFile.updateConfigFileXML("TARGETREPOSITORYNAME", file, info.getRepository());
            ModifyImportFile.updateConfigFileXML("SOURCEREPOSITORYNAME", file, pre.getNAME());
         } catch (Exception e1) {
            e1.printStackTrace();
            return false;
         }

         String text = InfoExecUtil.executImport(info.getPmrepexepath(), task.getFilepath(), file.toString(), info.getLogdir());
         if (text.contains("successfully")) {
            return true;
         } else {
            return false;
         }
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }
   }

   public boolean taskExecute(String taskid) {
      TCoreImporttask task = (TCoreImporttask)this.tCoreImporttaskDao.get(taskid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);

      try {
         InputStream is = new FileInputStream(task.getFilepath());
         ToObjutil to = new ToObjutil();
         BufferedReader tBufferedReader = new BufferedReader(new InputStreamReader(is));
         int k = 0;
         StringBuffer tStringBuffer = new StringBuffer();
         new String("");

         String sTempOneLine;
         while((sTempOneLine = tBufferedReader.readLine()) != null) {
            ++k;
            if (k == 2) {
               tStringBuffer.append("");
            } else {
               tStringBuffer.append(sTempOneLine);
            }
         }

         Object obj = ToObjutil.unmarshalmo("com.chenyang.nse.bussiness.engine.infa.basic.xmlbean", tStringBuffer.toString());
         POWERMART powermart = (POWERMART)obj;
         List<REPOSITORY> repositorListWf = powermart.getREPOSITORY();
         WORKFLOW exwork = new WORKFLOW();

         for(int i = 0; i < repositorListWf.size(); ++i) {
            REPOSITORY repositor = (REPOSITORY)repositorListWf.get(i);
            List<FOLDER> folderList = repositor.getFOLDER();

            for(int j = 0; j < folderList.size(); ++j) {
               FOLDER folder1 = (FOLDER)folderList.get(j);

               for(Object object1 : folder1.getFOLDERVERSIONOrCONFIGOrSCHEDULEROrTASKOrSESSIONOrWORKLETOrWORKFLOWOrSOURCEOrTARGETOrTRANSFORMATIONOrMAPPLETOrMAPPINGOrSHORTCUTOrEXPRMACRO()) {
                  if (object1.getClass().getName().equals("com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.WORKFLOW")) {
                     exwork = (WORKFLOW)object1;
                  }
               }
            }
         }

         String text = InfoExecUtil.executWorkflow(info.getPmcmdexepath(), "exp_" + task.getTaskname() + "_" + task.getId(), info.getInteservicename(), info.getDomainname(), info.getUsername(), info.getPassword(), exwork.getNAME());
         if (text.contains("successfully")) {
            task.setFlag("30");
            this.tCoreImporttaskDao.saveOrUpdate(task);
            return true;
         } else {
            return false;
         }
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }
   }

   public TCoreImporttask selectByPrimaryKey(String taskid) {
      return (TCoreImporttask)this.tCoreImporttaskDao.get(taskid);
   }

   public boolean uploadfile(String taskname, String engineid, String filepath, CommonsMultipartFile file) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      if (!file.isEmpty()) {
         FileTool.createFolder(info.getXmldir() + File.separator + taskname);
         String path = info.getXmldir() + File.separator + taskname + File.separator + filepath + ".xml";
         File destFile = new File(path);

         try {
            FileUtils.copyInputStreamToFile(file.getInputStream(), destFile);
         } catch (IOException e) {
            e.printStackTrace();
            return false;
         }
      }

      return true;
   }

   public String querySourceDbName(String taskid) {
      TCoreImporttask task = (TCoreImporttask)this.tCoreImporttaskDao.get(taskid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      String str = "";

      try {
         InputStream is = new FileInputStream(info.getXmldir() + File.separator + task.getTaskname() + File.separator + task.getFilepath() + ".xml");
         ToObjutil to = new ToObjutil();
         BufferedReader tBufferedReader = new BufferedReader(new InputStreamReader(is));
         int k = 0;
         StringBuffer tStringBuffer = new StringBuffer();
         new String("");

         String sTempOneLine;
         while((sTempOneLine = tBufferedReader.readLine()) != null) {
            ++k;
            if (k == 2) {
               tStringBuffer.append("");
            } else {
               tStringBuffer.append(sTempOneLine);
            }
         }

         Object obj = ToObjutil.unmarshalmo("com.chenyang.nse.bussiness.engine.infa.basic.xmlbean", tStringBuffer.toString());
         POWERMART powermart = (POWERMART)obj;
         List<REPOSITORY> repositorListWf = powermart.getREPOSITORY();
         WORKFLOW exwork = new WORKFLOW();

         for(int i = 0; i < repositorListWf.size(); ++i) {
            REPOSITORY repositor = (REPOSITORY)repositorListWf.get(i);
            List<FOLDER> folderList = repositor.getFOLDER();

            for(int j = 0; j < folderList.size(); ++j) {
               FOLDER folder1 = (FOLDER)folderList.get(j);

               for(Object object1 : folder1.getFOLDERVERSIONOrCONFIGOrSCHEDULEROrTASKOrSESSIONOrWORKLETOrWORKFLOWOrSOURCEOrTARGETOrTRANSFORMATIONOrMAPPLETOrMAPPINGOrSHORTCUTOrEXPRMACRO()) {
                  if (object1.getClass().getName().equals("com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.WORKFLOW")) {
                     exwork = (WORKFLOW)object1;
                  }
               }
            }
         }

         List<SESSIONEXTENSION> list = ((SESSION)exwork.getSESSION().get(0)).getSESSIONEXTENSION();
         if (list != null && list.size() > 0) {
            for(int i = 0; i < list.size(); ++i) {
               if ("Source Qualifier".equals(((SESSIONEXTENSION)list.get(i)).getTRANSFORMATIONTYPE())) {
                  str = ((CONNECTIONREFERENCE)((SESSIONEXTENSION)list.get(i)).getCONNECTIONREFERENCE().get(0)).getCONNECTIONNAME();
               }
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return str;
   }

   public String queryTargetDbName(String taskid) {
      TCoreImporttask task = (TCoreImporttask)this.tCoreImporttaskDao.get(taskid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      String str = "";

      try {
         InputStream is = new FileInputStream(info.getXmldir() + File.separator + task.getTaskname() + File.separator + task.getFilepath() + ".xml");
         ToObjutil to = new ToObjutil();
         BufferedReader tBufferedReader = new BufferedReader(new InputStreamReader(is));
         int k = 0;
         StringBuffer tStringBuffer = new StringBuffer();
         new String("");

         String sTempOneLine;
         while((sTempOneLine = tBufferedReader.readLine()) != null) {
            ++k;
            if (k == 2) {
               tStringBuffer.append("");
            } else {
               tStringBuffer.append(sTempOneLine);
            }
         }

         Object obj = ToObjutil.unmarshalmo("com.chenyang.nse.bussiness.engine.infa.basic.xmlbean", tStringBuffer.toString());
         POWERMART powermart = (POWERMART)obj;
         List<REPOSITORY> repositorListWf = powermart.getREPOSITORY();
         WORKFLOW exwork = new WORKFLOW();

         for(int i = 0; i < repositorListWf.size(); ++i) {
            REPOSITORY repositor = (REPOSITORY)repositorListWf.get(i);
            List<FOLDER> folderList = repositor.getFOLDER();

            for(int j = 0; j < folderList.size(); ++j) {
               FOLDER folder1 = (FOLDER)folderList.get(j);

               for(Object object1 : folder1.getFOLDERVERSIONOrCONFIGOrSCHEDULEROrTASKOrSESSIONOrWORKLETOrWORKFLOWOrSOURCEOrTARGETOrTRANSFORMATIONOrMAPPLETOrMAPPINGOrSHORTCUTOrEXPRMACRO()) {
                  if (object1.getClass().getName().equals("com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.WORKFLOW")) {
                     exwork = (WORKFLOW)object1;
                  }
               }
            }
         }

         List<SESSIONEXTENSION> list = ((SESSION)exwork.getSESSION().get(0)).getSESSIONEXTENSION();
         if (list != null && list.size() > 0) {
            for(int i = 0; i < list.size(); ++i) {
               if ("Relational Writer".equals(((SESSIONEXTENSION)list.get(i)).getNAME())) {
                  str = ((CONNECTIONREFERENCE)((SESSIONEXTENSION)list.get(i)).getCONNECTIONREFERENCE().get(0)).getCONNECTIONNAME();
               }
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return str;
   }

   public void savetask(SaveExTaskParam saveExTaskParam) {
      TCoreImporttask task = (TCoreImporttask)this.tCoreImporttaskDao.get(saveExTaskParam.getTaskid());
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(saveExTaskParam.getCbb_maskingengine());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      String str = "";

      try {
         InputStream is = new FileInputStream(info.getXmldir() + File.separator + task.getTaskname() + File.separator + task.getFilepath() + ".xml");
         ToObjutil to = new ToObjutil();
         BufferedReader tBufferedReader = new BufferedReader(new InputStreamReader(is));
         int k = 0;
         StringBuffer tStringBuffer = new StringBuffer();
         new String("");

         String sTempOneLine;
         while((sTempOneLine = tBufferedReader.readLine()) != null) {
            ++k;
            if (k == 2) {
               tStringBuffer.append("");
            } else {
               tStringBuffer.append(sTempOneLine);
            }
         }

         Object obj = ToObjutil.unmarshalmo("com.chenyang.nse.bussiness.engine.infa.basic.xmlbean", tStringBuffer.toString());
         POWERMART powermart = (POWERMART)obj;
         List<REPOSITORY> repositorListWf = powermart.getREPOSITORY();
         REPOSITORY pre = (REPOSITORY)powermart.getREPOSITORY().get(0);
         FOLDER folder = (FOLDER)pre.getFOLDER().get(0);
         POWERMART expower = new POWERMART();
         REPOSITORY expre = new REPOSITORY();
         FOLDER exfolder = new FOLDER();
         expower.setCREATIONDATE(powermart.getCREATIONDATE());
         expower.setREPOSITORYVERSION(powermart.getREPOSITORYVERSION());
         expre.setCODEPAGE(pre.getCODEPAGE());
         expre.setDATABASETYPE(pre.getDATABASETYPE());
         expre.setNAME(pre.getNAME());
         expre.setPARENTREPOSITORY(pre.getPARENTREPOSITORY());
         expre.setVERSION(pre.getVERSION());
         exfolder.setDESCRIPTION(folder.getDESCRIPTION());
         exfolder.setGROUP(folder.getGROUP());
         exfolder.setNAME(saveExTaskParam.getCbb_folder());
         exfolder.setOWNER(folder.getOWNER());
         exfolder.setPERMISSIONS(folder.getPERMISSIONS());
         exfolder.setSHARED(folder.getSHARED());
         exfolder.setUUID(folder.getUUID());
         new SOURCE();
         new MAPPING();
         new CONFIG();
         new WORKFLOW();

         for(int i = 0; i < repositorListWf.size(); ++i) {
            REPOSITORY repositor = (REPOSITORY)repositorListWf.get(i);
            List<FOLDER> folderList = repositor.getFOLDER();

            for(int j = 0; j < folderList.size(); ++j) {
               FOLDER folder1 = (FOLDER)folderList.get(j);

               for(Object object1 : folder1.getFOLDERVERSIONOrCONFIGOrSCHEDULEROrTASKOrSESSIONOrWORKLETOrWORKFLOWOrSOURCEOrTARGETOrTRANSFORMATIONOrMAPPLETOrMAPPINGOrSHORTCUTOrEXPRMACRO()) {
                  if (object1.getClass().getName().equals("com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.SOURCE")) {
                     SOURCE exsource = (SOURCE)object1;
                     if (saveExTaskParam.getLink_source() != null && !"".equals(saveExTaskParam.getLink_source())) {
                        exsource.setDBDNAME(saveExTaskParam.getLink_source());
                     }

                     exfolder.getFOLDERVERSIONOrCONFIGOrSCHEDULEROrTASKOrSESSIONOrWORKLETOrWORKFLOWOrSOURCEOrTARGETOrTRANSFORMATIONOrMAPPLETOrMAPPINGOrSHORTCUTOrEXPRMACRO().add(exsource);
                  }

                  if (object1.getClass().getName().equals("com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.TARGET")) {
                     exfolder.getFOLDERVERSIONOrCONFIGOrSCHEDULEROrTASKOrSESSIONOrWORKLETOrWORKFLOWOrSOURCEOrTARGETOrTRANSFORMATIONOrMAPPLETOrMAPPINGOrSHORTCUTOrEXPRMACRO().add((TARGET)object1);
                  }

                  if (object1.getClass().getName().equals("com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.MAPPING")) {
                     MAPPING mapping = (MAPPING)object1;
                     task.setMpname(mapping.getNAME());
                     if (saveExTaskParam.getLink_source() != null && !"".equals(saveExTaskParam.getLink_source())) {
                        List<INSTANCE> inlist = mapping.getINSTANCE();

                        for(int l = 0; l < inlist.size(); ++l) {
                           if ("Source Definition".equals(((INSTANCE)inlist.get(l)).getTRANSFORMATIONTYPE())) {
                              ((INSTANCE)inlist.get(l)).setDBDNAME(saveExTaskParam.getLink_source());
                              break;
                           }
                        }
                     }

                     exfolder.getFOLDERVERSIONOrCONFIGOrSCHEDULEROrTASKOrSESSIONOrWORKLETOrWORKFLOWOrSOURCEOrTARGETOrTRANSFORMATIONOrMAPPLETOrMAPPINGOrSHORTCUTOrEXPRMACRO().add(mapping);
                  }

                  if (object1.getClass().getName().equals("com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.MAPPLET")) {
                     exfolder.getFOLDERVERSIONOrCONFIGOrSCHEDULEROrTASKOrSESSIONOrWORKLETOrWORKFLOWOrSOURCEOrTARGETOrTRANSFORMATIONOrMAPPLETOrMAPPINGOrSHORTCUTOrEXPRMACRO().add((MAPPLET)object1);
                  }

                  if (object1.getClass().getName().equals("com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.CONFIG")) {
                     CONFIG config = (CONFIG)object1;
                     exfolder.getFOLDERVERSIONOrCONFIGOrSCHEDULEROrTASKOrSESSIONOrWORKLETOrWORKFLOWOrSOURCEOrTARGETOrTRANSFORMATIONOrMAPPLETOrMAPPINGOrSHORTCUTOrEXPRMACRO().add(config);
                  }

                  if (object1.getClass().getName().equals("com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.WORKFLOW")) {
                     WORKFLOW workflow = (WORKFLOW)object1;
                     task.setWfname(workflow.getNAME());
                     task.setSename(((SESSION)workflow.getSESSION().get(0)).getNAME());
                     List<SESSIONEXTENSION> selist = ((SESSION)workflow.getSESSION().get(0)).getSESSIONEXTENSION();
                     boolean flag = false;
                     boolean flag1 = false;

                     for(int l = 0; l < selist.size(); ++l) {
                        if (saveExTaskParam.getLink_target() != null && !"".equals(saveExTaskParam.getLink_target()) && "Relational Writer".equals(((SESSIONEXTENSION)selist.get(l)).getNAME())) {
                           ((CONNECTIONREFERENCE)((SESSIONEXTENSION)selist.get(l)).getCONNECTIONREFERENCE().get(0)).setCONNECTIONNAME(saveExTaskParam.getLink_target());
                           flag = true;
                           if (flag1) {
                              break;
                           }
                        } else if (saveExTaskParam.getLink_source() != null && !"".equals(saveExTaskParam.getLink_source()) && "Source Qualifier".equals(((SESSIONEXTENSION)selist.get(l)).getTRANSFORMATIONTYPE())) {
                           ((CONNECTIONREFERENCE)((SESSIONEXTENSION)selist.get(l)).getCONNECTIONREFERENCE().get(0)).setCONNECTIONNAME(saveExTaskParam.getLink_source());
                           flag1 = true;
                           if (flag) {
                              break;
                           }
                        }
                     }

                     exfolder.getFOLDERVERSIONOrCONFIGOrSCHEDULEROrTASKOrSESSIONOrWORKLETOrWORKFLOWOrSOURCEOrTARGETOrTRANSFORMATIONOrMAPPLETOrMAPPINGOrSHORTCUTOrEXPRMACRO().add(workflow);
                  }
               }
            }
         }

         expre.getFOLDER().add(exfolder);
         expower.getREPOSITORY().add(expre);
         List<Object> alllist = new ArrayList();
         alllist.add(expower);
         OutputStream f = null;
         OutputStream var40 = new FileOutputStream(info.getXmldir() + File.separator + task.getTaskname() + File.separator + task.getFilepath() + ".xml");
         ToObjutil.marshal("com.chenyang.nse.bussiness.engine.infa.basic.xmlbean", alllist, var40, "");
         TCoreMaskingTask record = new TCoreMaskingTask();
         if (saveExTaskParam.getCbb_folder() != null && !"".equals(saveExTaskParam.getCbb_folder())) {
            record.setFdname(saveExTaskParam.getCbb_folder());
         } else {
            record.setFdname(task.getTaskname());
            this.infoService.createFolderInEngine(saveExTaskParam.getCbb_maskingengine(), task.getTaskname());
         }

         record.setTaskname(task.getTaskname());
         record.setFlag("im-db");
         record.setEngineid(saveExTaskParam.getCbb_maskingengine());
         record.setCreatetime(new Date());
         this.tCoreMaskingTaskDao.save(record);
         boolean text = this.infoService.importimpMapping(record.getId());
         if (text) {
            task.setFlag("30");
            this.tCoreImporttaskDao.saveOrUpdate(task);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

   }
}
