package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.core.AssignmentNameDao;
import com.chenyang.nse.bussiness.dao.core.FieldReportFormDao;
import com.chenyang.nse.bussiness.dao.core.SearchFieldDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleSearchregexDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreComplianceDirectoryDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDataScopeDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreSensitiveLevelDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreAssignmentFieldDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreAssignmentNameDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreFieldDirectoryDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreFieldSensitiveDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreScopeDirectoryDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreScopeFieldDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreTableFieldDao;
import com.chenyang.nse.bussiness.entity.vo.datascope.FieldReportFormDetailVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.FieldReportFormTotalVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.FieldReportFormVO;
import com.chenyang.nse.bussiness.service.core.FieldReportFormService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FieldReportFormServiceImpl implements FieldReportFormService {
   @Autowired
   private AssignmentNameDao assignmentNameDao;
   @Autowired
   private SearchFieldDao searchFieldDao;
   @Autowired
   private FieldReportFormDao fieldReportFormDao;
   @Autowired
   private TCoreAssignmentFieldDao tCoreAssignmentFieldDao;
   @Autowired
   private TCoreAssignmentNameDao tCoreAssignmentNameDao;
   @Autowired
   private TCoreComplianceDirectoryDao tCoreComplianceDirectoryDao;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   private TCoreSensitiveLevelDao tCoreSensitiveLevelDao;
   @Autowired
   private TCoreDataScopeDao tCoreDataScopeDao;
   @Autowired
   private TCoreScopeFieldDao tCoreScopeFieldDao;
   @Autowired
   private TCoreFieldDirectoryDao tCoreFieldDirectoryDao;
   @Autowired
   private TCoreTableFieldDao tCoreTableFieldDao;
   @Autowired
   private TCoreFieldSensitiveDao tCoreFieldSensitiveDao;
   @Autowired
   private TConsoleSearchregexDao tConsoleSearchregexDao;
   @Autowired
   private RedisService redisService;
   @Autowired
   private TCoreScopeDirectoryDao tCoreScopeDirectoryDao;

   public List<FieldReportFormVO> getfieldreportform(Map<String, Object> datalist, List<String> choseTable) {
      StringBuilder tablearea = new StringBuilder("");
      String sql = "";
      List<FieldReportFormVO> vo = new ArrayList();
      String datasystemid = (String)datalist.get("dataall[datasystemname]");
      String schema = (String)datalist.get("dataall[tschemas]");
      String setuptype = (String)datalist.get("dataall[setuptype]");
      String version = (String)datalist.get("dataall[editionid]");
      String treetid = (String)datalist.get("dataall[treetid]");
      String open_level = (String)datalist.get("open_level");
      if (!choseTable.isEmpty()) {
         for(String str : choseTable) {
            tablearea.append("'" + str + "',");
         }

         tablearea.deleteCharAt(tablearea.length() - 1);
      }

      if ("0".equals(setuptype)) {
         sql = "SELECT a.scope_id as id, c.scope_name as datascopename ,b.dbservername as datasystemname,a.tschemas as tschemas,a.names as names,a.tablefield_id as fieldname FROM t_core_scope_field a,t_core_datasystem b,t_core_data_scope c WHERE 1=1 ";
         if (datasystemid != null && !"".equals(datasystemid)) {
            sql = sql + "AND a.datasystem_id = '" + datasystemid + "' ";
         }

         if (schema != null && !"".equals(schema)) {
            sql = sql + "AND a.tschemas = '" + schema + "' ";
         }

         if (!choseTable.isEmpty()) {
            sql = sql + "AND a.names IN (" + tablearea + ") ";
         }

         if (treetid != null && !"".equals(treetid)) {
            sql = sql + "AND a.scope_id = '" + treetid + "' ";
         }

         sql = sql + "AND a.scope_id = c.id AND a.edition_id = c.edition_id  AND a.datasystem_id = b.id AND a.edition_id = '" + version + "' ORDER BY c.create_date,b.createtime,a.tschemas,a.names,a.tablefield_id ";
         vo = this.fieldReportFormDao.getFieldReportFormSearch(sql);
      } else if ("1".equals(setuptype)) {
         sql = "SELECT a.scope_id as id, c.directory_name as datascopename ,b.dbservername as datasystemname,a.tschemas as tschemas,a.names as names,a.tablefield_id as fieldname FROM t_core_field_directory a,t_core_datasystem b,t_core_compliance_directory c WHERE 1=1 ";
         if (datasystemid != null && !"".equals(datasystemid)) {
            sql = sql + "AND a.datasystem_id = '" + datasystemid + "' ";
         }

         if (schema != null && !"".equals(schema)) {
            sql = sql + "AND a.tschemas = '" + schema + "' ";
         }

         if (!choseTable.isEmpty()) {
            sql = sql + "AND a.names IN (" + tablearea + ") ";
         }

         if (treetid != null && !"".equals(treetid)) {
            sql = sql + "AND a.scope_id = '" + treetid + "' ";
         }

         sql = sql + "AND a.scope_id = c.id   AND a.datasystem_id = b.id  ORDER BY c.create_date,b.createtime,a.tschemas,a.names,a.tablefield_id ";
         vo = this.fieldReportFormDao.getFieldReportFormSearch(sql);
      } else if ("2".equals(setuptype)) {
         sql = "SELECT a.scope_id as id, c.sensitive_name as datascopename ,b.dbservername as datasystemname,a.tschemas as tschemas,a.names as names,a.tablefield_id as fieldname FROM t_core_field_sensitive a,t_core_datasystem b,t_core_sensitive_level c WHERE 1=1 ";
         if (datasystemid != null && !"".equals(datasystemid)) {
            sql = sql + "AND a.datasystem_id = '" + datasystemid + "' ";
         }

         if (schema != null && !"".equals(schema)) {
            sql = sql + "AND a.tschemas = '" + schema + "' ";
         }

         if (!choseTable.isEmpty()) {
            sql = sql + "AND a.names IN (" + tablearea + ") ";
         }

         if (treetid != null && !"".equals(treetid)) {
            sql = sql + "AND a.scope_id = '" + treetid + "' ";
         }

         if (open_level != null && !"".equals(open_level)) {
            sql = sql + "AND c.open_level = '" + open_level + "' ";
         }

         sql = sql + "AND a.scope_id = c.id AND a.edition_id = c.edition_id  AND a.datasystem_id = b.id AND a.edition_id = '" + version + "' ORDER BY c.create_date,b.createtime,a.tschemas,a.names,a.tablefield_id ";
         vo = this.fieldReportFormDao.getFieldReportFormSearch(sql);
      }

      return vo;
   }

   public List<FieldReportFormVO> getfieldreportform(Map<String, Object> datalist, List<String> choseTable, String projectid) {
      StringBuilder tablearea = new StringBuilder("");
      String sql = "";
      List<FieldReportFormVO> vo = new ArrayList();
      String datasystemid = (String)datalist.get("dataall[datasystemname]");
      String schema = (String)datalist.get("dataall[tschemas]");
      String setuptype = (String)datalist.get("dataall[setuptype]");
      String version = (String)datalist.get("dataall[editionid]");
      String treetid = "";
      if (datalist.get("dataall[treetid]") != null) {
         treetid = datalist.get("dataall[treetid]").toString();
      }

      String open_level = (String)datalist.get("open_level");
      if (!choseTable.isEmpty()) {
         for(String str : choseTable) {
            tablearea.append("'" + str + "',");
         }

         tablearea.deleteCharAt(tablearea.length() - 1);
      }

      if ("0".equals(setuptype)) {
         sql = "SELECT a.scope_id as id, c.scope_name as datascopename ,b.dbservername as datasystemname,a.tschemas as tschemas,a.names as names,a.tablefield_id as fieldname FROM t_core_scope_field a,t_core_datasystem b,t_core_data_scope c WHERE a.projectid='" + projectid + "' ";
         if (datasystemid != null && !"".equals(datasystemid)) {
            sql = sql + "AND a.datasystem_id = '" + datasystemid + "' ";
         }

         if (schema != null && !"".equals(schema)) {
            sql = sql + "AND a.tschemas = '" + schema + "' ";
         }

         if (!choseTable.isEmpty()) {
            sql = sql + "AND a.names IN (" + tablearea + ") ";
         }

         if (treetid != null && !"".equals(treetid) && !treetid.equals("0")) {
            sql = sql + "AND a.scope_id = '" + treetid + "' ";
         }

         sql = sql + "AND a.scope_id = c.id AND a.edition_id = c.edition_id  AND a.datasystem_id = b.id AND a.edition_id = '" + version + "' ORDER BY c.create_date,b.createtime,a.tschemas,a.names,a.tablefield_id ";
         vo = this.fieldReportFormDao.getFieldReportFormSearch(sql);
      } else if ("1".equals(setuptype)) {
         sql = "SELECT a.scope_id as id, c.directory_name as datascopename ,b.dbservername as datasystemname,a.tschemas as tschemas,a.names as names,a.tablefield_id as fieldname FROM t_core_field_directory a,t_core_datasystem b,t_core_compliance_directory c WHERE a.projectid='" + projectid + "' ";
         if (datasystemid != null && !"".equals(datasystemid)) {
            sql = sql + "AND a.datasystem_id = '" + datasystemid + "' ";
         }

         if (schema != null && !"".equals(schema)) {
            sql = sql + "AND a.tschemas = '" + schema + "' ";
         }

         if (!choseTable.isEmpty()) {
            sql = sql + "AND a.names IN (" + tablearea + ") ";
         }

         if (treetid != null && !"".equals(treetid) && !treetid.equals("0")) {
            sql = sql + "AND a.scope_id = '" + treetid + "' ";
         }

         sql = sql + "AND a.scope_id = c.id   AND a.datasystem_id = b.id  ORDER BY c.create_date,b.createtime,a.tschemas,a.names,a.tablefield_id ";
         vo = this.fieldReportFormDao.getFieldReportFormSearch(sql);
      } else if ("2".equals(setuptype)) {
         sql = "SELECT a.scope_id as id, c.sensitive_name as datascopename ,b.dbservername as datasystemname,a.tschemas as tschemas,a.names as names,a.tablefield_id as fieldname FROM t_core_field_sensitive a,t_core_datasystem b,t_core_sensitive_level c WHERE a.projectid='" + projectid + "' ";
         if (datasystemid != null && !"".equals(datasystemid)) {
            sql = sql + "AND a.datasystem_id = '" + datasystemid + "' ";
         }

         if (schema != null && !"".equals(schema)) {
            sql = sql + "AND a.tschemas = '" + schema + "' ";
         }

         if (!choseTable.isEmpty()) {
            sql = sql + "AND a.names IN (" + tablearea + ") ";
         }

         if (treetid != null && !"".equals(treetid) && !treetid.equals("0")) {
            sql = sql + "AND a.scope_id = '" + treetid + "' ";
         }

         if (open_level != null && !"".equals(open_level)) {
            sql = sql + "AND c.open_level = '" + open_level + "' ";
         }

         sql = sql + "AND a.scope_id = c.id AND a.edition_id = c.edition_id  AND a.datasystem_id = b.id AND a.edition_id = '" + version + "' ORDER BY c.create_date,b.createtime,a.tschemas,a.names,a.tablefield_id ";
         vo = this.fieldReportFormDao.getFieldReportFormSearch(sql);
      }

      return vo;
   }

   public List<FieldReportFormTotalVO> getfieldreportformTotal(Map<String, Object> datalist, List<String> choseTable, PageInfo pageInfo) {
      StringBuilder tablearea = new StringBuilder("");
      String sql = "";
      new ArrayList();
      String treetid = (String)datalist.get("dataall[treetid]");
      String datasystemid = (String)datalist.get("dataall[datasystemname]");
      String schema = (String)datalist.get("dataall[tschemas]");
      String setuptype = (String)datalist.get("dataall[setuptype]");
      String version = (String)datalist.get("dataall[editionid]");
      String editiontext = (String)datalist.get("dataall[editiontext]");
      if (!choseTable.isEmpty()) {
         for(String str : choseTable) {
            tablearea.append("'" + str + "',");
         }

         tablearea.deleteCharAt(tablearea.length() - 1);
      }

      StringBuffer querySqlBuffer = new StringBuffer();
      querySqlBuffer.append(" SELECT a.id as id, count(DISTINCT(CONCAT(b.tablefield_id,b.names))) as fieldcnt,count(DISTINCT(b.names)) as tablecnt ");
      if ("0".equals(setuptype)) {
         querySqlBuffer.append(" ,count(DISTINCT(b.scope_id)) as scopecnt,count(DISTINCT(c.scope_id)) as levelcnt,count(DISTINCT(d.scope_id)) as directorycnt ");
         if (treetid != null && !"".equals(treetid)) {
            querySqlBuffer.append(" ,a.scope_name as scopename ");
         } else {
            querySqlBuffer.append(" ,'" + editiontext + "' as scopename ");
         }

         querySqlBuffer.append(" FROM t_core_data_scope a ");
         querySqlBuffer.append(" inner join t_core_scope_field b ON b.scope_id = a.id AND b.edition_id = a.edition_id ");
         querySqlBuffer.append(" left join t_core_field_sensitive c ON b.datasystem_id = c.datasystem_id AND b.tschemas = c.tschemas and  b.names = c.names and b.tablefield_id = c.tablefield_id ");
         querySqlBuffer.append(" left join t_core_field_directory d ON b.datasystem_id = d.datasystem_id AND b.tschemas = d.tschemas and  b.names = d.names and b.tablefield_id = d.tablefield_id ");
         querySqlBuffer.append(" WHERE 1=1 ");
         querySqlBuffer.append(" AND b.edition_id = '" + version + "' ");
      } else if ("1".equals(setuptype)) {
         querySqlBuffer.append(" ,count(DISTINCT(d.scope_id)) as scopecnt,count(DISTINCT(c.scope_id)) as levelcnt,count(DISTINCT(b.scope_id)) as directorycnt ");
         if (treetid != null && !"".equals(treetid)) {
            querySqlBuffer.append(" ,a.directory_name as scopename ");
         } else {
            querySqlBuffer.append(" ,'法律法规' as scopename ");
         }

         querySqlBuffer.append(" FROM t_core_compliance_directory a  ");
         querySqlBuffer.append(" inner join t_core_field_directory b ON b.scope_id = a.id ");
         querySqlBuffer.append(" left join t_core_field_sensitive c ON b.datasystem_id = c.datasystem_id AND b.tschemas = c.tschemas and  b.names = c.names and b.tablefield_id = c.tablefield_id ");
         querySqlBuffer.append(" left join t_core_scope_field d ON b.datasystem_id = d.datasystem_id AND b.tschemas = d.tschemas and  b.names = d.names and b.tablefield_id = d.tablefield_id ");
         querySqlBuffer.append(" WHERE 1=1 ");
      } else if ("2".equals(setuptype)) {
         querySqlBuffer.append(" ,count(DISTINCT(c.scope_id)) as scopecnt,count(DISTINCT(b.scope_id)) as levelcnt,count(DISTINCT(d.scope_id)) as directorycnt ");
         if (treetid != null && !"".equals(treetid)) {
            querySqlBuffer.append(" ,a.sensitive_name as scopename ");
         } else {
            querySqlBuffer.append(" ,'" + editiontext + "' as scopename ");
         }

         querySqlBuffer.append(" FROM t_core_sensitive_level a ");
         querySqlBuffer.append(" inner join t_core_field_sensitive b ON b.scope_id = a.id AND b.edition_id = a.edition_id  ");
         querySqlBuffer.append(" left join t_core_scope_field c ON b.datasystem_id = c.datasystem_id AND b.tschemas = c.tschemas and  b.names = c.names and b.tablefield_id = c.tablefield_id ");
         querySqlBuffer.append(" left join t_core_field_directory d ON b.datasystem_id = d.datasystem_id AND b.tschemas = d.tschemas and  b.names = d.names and b.tablefield_id = d.tablefield_id ");
         querySqlBuffer.append(" WHERE 1=1 ");
         querySqlBuffer.append(" AND b.edition_id = '" + version + "' ");
      }

      if (!choseTable.isEmpty()) {
         querySqlBuffer.append("AND b.names IN (" + tablearea + ") ");
      }

      if (schema != null && !"".equals(schema) && !"所有".equals(schema)) {
         querySqlBuffer.append("AND b.tschemas = '" + schema + "' ");
      }

      if (datasystemid != null && !"".equals(datasystemid)) {
         querySqlBuffer.append("AND b.datasystem_id = '" + datasystemid + "' ");
      }

      if (treetid != null && !"".equals(treetid)) {
         querySqlBuffer.append(" AND a.id = '" + treetid + "' ");
      }

      querySqlBuffer.append(" ORDER BY b.tschemas,b.names,b.tablefield_id ");
      System.out.println(">>>>>>querySqlBuffer is:" + querySqlBuffer.toString());
      List<FieldReportFormTotalVO> volist = this.fieldReportFormDao.getFieldReportFormTotalSearch(querySqlBuffer.toString());
      if (null != volist && volist.size() > 0 && StringUtils.isBlank(((FieldReportFormTotalVO)volist.get(0)).getScopename())) {
         ((FieldReportFormTotalVO)volist.get(0)).setScopename(editiontext);
      }

      return volist;
   }

   public List<FieldReportFormDetailVO> getfieldreportformDetail(Map<String, Object> datalist, List<String> choseTable, PageInfo pageInfo) {
      StringBuilder tablearea = new StringBuilder("");
      String sql = "";
      new ArrayList();
      String treetid = (String)datalist.get("dataall[treetid]");
      String datasystemid = (String)datalist.get("dataall[datasystemname]");
      String schema = (String)datalist.get("dataall[tschemas]");
      String setuptype = (String)datalist.get("dataall[setuptype]");
      String version = (String)datalist.get("dataall[editionid]");
      String editiontext = (String)datalist.get("dataall[editiontext]");
      String detailType = (String)datalist.get("dataall[detailType]");
      if (!choseTable.isEmpty()) {
         for(String str : choseTable) {
            tablearea.append("'" + str + "',");
         }

         tablearea.deleteCharAt(tablearea.length() - 1);
      }

      StringBuffer querySqlBuffer = new StringBuffer();
      querySqlBuffer.append(" SELECT ");
      if ("0".equals(setuptype)) {
         if ("1".equals(detailType)) {
            querySqlBuffer.append(" DISTINCT(CONCAT(b.names ,'#_#',b.tablefield_id)) as fieldcnt ");
         } else if ("2".equals(detailType)) {
            querySqlBuffer.append(" DISTINCT(b.names) as tablecnt ");
         } else if ("3".equals(detailType)) {
            querySqlBuffer.append(" DISTINCT(a.scope_name) as scopecnt ");
         } else if ("4".equals(detailType)) {
            querySqlBuffer.append(" DISTINCT(e.sensitive_name) as levelcnt ");
         } else if ("5".equals(detailType)) {
            querySqlBuffer.append(" DISTINCT(f.directory_name) as directorycnt ");
         }

         querySqlBuffer.append(" FROM t_core_data_scope a ");
         querySqlBuffer.append(" inner join t_core_scope_field b ON b.scope_id = a.id AND b.edition_id = a.edition_id ");
         querySqlBuffer.append(" left join t_core_field_sensitive c ON b.datasystem_id = c.datasystem_id AND b.tschemas = c.tschemas and  b.names = c.names and b.tablefield_id = c.tablefield_id ");
         querySqlBuffer.append(" left join t_core_field_directory d ON b.datasystem_id = d.datasystem_id AND b.tschemas = d.tschemas and  b.names = d.names and b.tablefield_id = d.tablefield_id ");
         querySqlBuffer.append(" left join t_core_sensitive_level e ON c.scope_id = e.id AND c.edition_id = e.edition_id  ");
         querySqlBuffer.append(" left join t_core_compliance_directory f ON d.scope_id = f.id ");
         querySqlBuffer.append(" WHERE 1=1 ");
         if ("1".equals(detailType)) {
            querySqlBuffer.append(" AND CONCAT(b.names ,'#_#',b.tablefield_id) IS NOT NULL ");
         } else if ("2".equals(detailType)) {
            querySqlBuffer.append(" AND (b.names) IS NOT NULL ");
         } else if ("3".equals(detailType)) {
            querySqlBuffer.append(" AND (a.scope_name)  IS NOT NULL ");
         } else if ("4".equals(detailType)) {
            querySqlBuffer.append(" AND (e.sensitive_name)  IS NOT NULL ");
         } else if ("5".equals(detailType)) {
            querySqlBuffer.append(" AND (f.directory_name)  IS NOT NULL ");
         }

         querySqlBuffer.append(" AND b.edition_id = '" + version + "' ");
      } else if ("1".equals(setuptype)) {
         if ("1".equals(detailType)) {
            querySqlBuffer.append(" DISTINCT(CONCAT(b.names ,'#_#',b.tablefield_id)) as fieldcnt ");
         } else if ("2".equals(detailType)) {
            querySqlBuffer.append(" DISTINCT(b.names) as tablecnt ");
         } else if ("3".equals(detailType)) {
            querySqlBuffer.append(" DISTINCT(f.scope_name) as scopecnt ");
         } else if ("4".equals(detailType)) {
            querySqlBuffer.append(" DISTINCT(e.sensitive_name) as levelcnt ");
         } else if ("5".equals(detailType)) {
            querySqlBuffer.append(" DISTINCT(a.directory_name) as directorycnt ");
         }

         querySqlBuffer.append(" FROM t_core_compliance_directory a  ");
         querySqlBuffer.append(" inner join t_core_field_directory b ON b.scope_id = a.id ");
         querySqlBuffer.append(" left join t_core_field_sensitive c ON b.datasystem_id = c.datasystem_id AND b.tschemas = c.tschemas and  b.names = c.names and b.tablefield_id = c.tablefield_id ");
         querySqlBuffer.append(" left join t_core_scope_field d ON b.datasystem_id = d.datasystem_id AND b.tschemas = d.tschemas and  b.names = d.names and b.tablefield_id = d.tablefield_id ");
         querySqlBuffer.append(" left join t_core_sensitive_level e ON c.scope_id = e.id AND c.edition_id = e.edition_id  ");
         querySqlBuffer.append(" left join t_core_data_scope f ON d.scope_id = f.id ");
         querySqlBuffer.append(" WHERE 1=1 ");
         if ("1".equals(detailType)) {
            querySqlBuffer.append(" AND CONCAT(b.names ,'#_#',b.tablefield_id) IS NOT NULL ");
         } else if ("2".equals(detailType)) {
            querySqlBuffer.append(" AND (b.names) IS NOT NULL ");
         } else if ("3".equals(detailType)) {
            querySqlBuffer.append(" AND (f.scope_name)  IS NOT NULL ");
         } else if ("4".equals(detailType)) {
            querySqlBuffer.append(" AND (e.sensitive_name)  IS NOT NULL ");
         } else if ("5".equals(detailType)) {
            querySqlBuffer.append(" AND (a.directory_name)  IS NOT NULL ");
         }
      } else if ("2".equals(setuptype)) {
         if ("1".equals(detailType)) {
            querySqlBuffer.append(" DISTINCT(CONCAT(b.names ,'#_#',b.tablefield_id)) as fieldcnt ");
         } else if ("2".equals(detailType)) {
            querySqlBuffer.append(" DISTINCT(b.names) as tablecnt ");
         } else if ("3".equals(detailType)) {
            querySqlBuffer.append(" DISTINCT(e.scope_name) as scopecnt ");
         } else if ("4".equals(detailType)) {
            querySqlBuffer.append(" DISTINCT(a.sensitive_name) as levelcnt ");
         } else if ("5".equals(detailType)) {
            querySqlBuffer.append(" DISTINCT(f.directory_name) as directorycnt ");
         }

         querySqlBuffer.append(" FROM t_core_sensitive_level a ");
         querySqlBuffer.append(" inner join t_core_field_sensitive b ON b.scope_id = a.id AND b.edition_id = a.edition_id  ");
         querySqlBuffer.append(" left join t_core_scope_field c ON b.datasystem_id = c.datasystem_id AND b.tschemas = c.tschemas and  b.names = c.names and b.tablefield_id = c.tablefield_id ");
         querySqlBuffer.append(" left join t_core_field_directory d ON b.datasystem_id = d.datasystem_id AND b.tschemas = d.tschemas and  b.names = d.names and b.tablefield_id = d.tablefield_id ");
         querySqlBuffer.append(" left join t_core_data_scope e ON c.scope_id = e.id AND c.edition_id = e.edition_id  ");
         querySqlBuffer.append(" left join t_core_compliance_directory f ON d.scope_id = f.id ");
         querySqlBuffer.append(" WHERE 1=1 ");
         if ("1".equals(detailType)) {
            querySqlBuffer.append(" AND CONCAT(b.names ,'#_#',b.tablefield_id) IS NOT NULL ");
         } else if ("2".equals(detailType)) {
            querySqlBuffer.append(" AND (b.names) IS NOT NULL ");
         } else if ("3".equals(detailType)) {
            querySqlBuffer.append(" AND (e.scope_name)  IS NOT NULL ");
         } else if ("4".equals(detailType)) {
            querySqlBuffer.append(" AND (a.sensitive_name)  IS NOT NULL ");
         } else if ("5".equals(detailType)) {
            querySqlBuffer.append(" AND (f.directory_name)  IS NOT NULL ");
         }

         querySqlBuffer.append(" AND b.edition_id = '" + version + "' ");
      }

      if (!choseTable.isEmpty()) {
         querySqlBuffer.append("AND b.names IN (" + tablearea + ") ");
      }

      if (schema != null && !"".equals(schema) && !"所有".equals(schema)) {
         querySqlBuffer.append("AND b.tschemas = '" + schema + "' ");
      }

      if (datasystemid != null && !"".equals(datasystemid)) {
         querySqlBuffer.append("AND b.datasystem_id = '" + datasystemid + "' ");
      }

      if (treetid != null && !"".equals(treetid)) {
         querySqlBuffer.append(" AND a.id = '" + treetid + "' ");
      }

      querySqlBuffer.append(" ORDER BY b.tschemas,b.names,b.tablefield_id ");
      System.out.println(">>>>>>querySqlBuffer is:" + querySqlBuffer.toString());
      List<FieldReportFormDetailVO> volist = this.fieldReportFormDao.getFieldReportFormDetailSearch(querySqlBuffer.toString());
      if ("1".equals(detailType) && null != volist && volist.size() > 0) {
         for(int i = 0; i < volist.size(); ++i) {
            ((FieldReportFormDetailVO)volist.get(i)).setTablecnt(((FieldReportFormDetailVO)volist.get(i)).getFieldcnt());
         }
      }

      return volist;
   }
}
