package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.differentdb.DesensitizationTargerTypeConversionDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.differentdb.DesensitizationTargerTypeConversion;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.service.core.JavaConversionService;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class JavaConversionServiceImpl implements JavaConversionService {
   @Autowired
   private DesensitizationTargerTypeConversionDao desensitizationTargerTypeConversionDao;

   public DataGridVO<DesensitizationTargerTypeConversion> getdataconversioninfo(String dbtype, PageInfo pageInfo) {
      List<DesensitizationTargerTypeConversion> list = this.desensitizationTargerTypeConversionDao.queryByPageInfo(pageInfo, new Criterion[]{Restrictions.eq("datasystemtype", dbtype)});
      return new DataGridVO<DesensitizationTargerTypeConversion>(pageInfo.getCount(), list);
   }

   public void saveinfo(DesensitizationTargerTypeConversion dbttypeConversion) {
      this.desensitizationTargerTypeConversionDao.save(dbttypeConversion);
   }

   public void updateinfo(DesensitizationTargerTypeConversion dbttypeConversion) {
      this.desensitizationTargerTypeConversionDao.update(dbttypeConversion);
   }

   public DesensitizationTargerTypeConversion queryDateById(String id) {
      return (DesensitizationTargerTypeConversion)this.desensitizationTargerTypeConversionDao.queryAll(new Criterion[]{Restrictions.eq("id", id)}).get(0);
   }

   public void deldatainfo(String id) {
      this.desensitizationTargerTypeConversionDao.removeById(id);
   }

   public String queryFiledTypeCount(String dbtype, String filedType) {
      List<DesensitizationTargerTypeConversion> queryAll = this.desensitizationTargerTypeConversionDao.queryAll(new Criterion[]{Restrictions.eq("datasystemtype", dbtype), Restrictions.eq("targertype", filedType)});
      return queryAll.size() > 0 ? "1" : "0";
   }
}
