package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.TXmlPropertiesDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TXmlProperties;
import com.chenyang.nse.bussiness.service.core.PropertiesEditService;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PropertiesEditServiceImpl implements PropertiesEditService {
   @Autowired
   private TXmlPropertiesDao tXmlPropertiesDao;

   public List<TXmlProperties> getPropertieseList(List<TXmlProperties> list, PageInfo pageInfo) {
      List<TXmlProperties> tableList = new ArrayList();
      new ArrayList();
      TXmlProperties ex = new TXmlProperties();
      List<TXmlProperties> obj = this.tXmlPropertiesDao.queryByPageInfo(pageInfo, Order.asc("Pkey"));
      if (!obj.isEmpty()) {
         label54:
         for(TXmlProperties objtx : obj) {
            if (!list.isEmpty()) {
               for(TXmlProperties tx : list) {
                  if (tx.getPkey().equals(objtx.getPkey())) {
                     for(TXmlProperties tl : tableList) {
                        if (tl.getPkey().equals(objtx.getPkey())) {
                           continue label54;
                        }
                     }

                     tableList.add(objtx);
                     continue label54;
                  }

                  ex = tx;
               }

               ex.setPxmlName("config");
               ex.setId(UUID.randomUUID().toString().replace("-", ""));
               this.tXmlPropertiesDao.save(ex);
               tableList.add(ex);
            }
         }
      } else {
         for(TXmlProperties tx : list) {
            tx.setId(UUID.randomUUID().toString().replace("-", ""));
            this.tXmlPropertiesDao.save(tx);
            tableList.add(tx);
         }
      }

      return tableList;
   }

   public List<TXmlProperties> queryPvalue(String Pvalue, List<TXmlProperties> list, PageInfo pageInfo) {
      List<TXmlProperties> tableList = new ArrayList();
      TXmlProperties ex = new TXmlProperties();
      boolean a = true;
      List<TXmlProperties> obj = this.tXmlPropertiesDao.queryByPageInfo(pageInfo, Order.asc("Pkey"), new Criterion[]{Restrictions.like("Pvalue", "%" + Pvalue + "%")});
      List<TXmlProperties> obj1 = this.tXmlPropertiesDao.queryByPageInfo(pageInfo, Order.asc("Pkey"));
      if (!obj1.isEmpty()) {
         label58:
         for(TXmlProperties objtx : obj) {
            if (!list.isEmpty()) {
               for(TXmlProperties tx : list) {
                  if (tx.getPkey().equals(objtx.getPkey())) {
                     tableList.add(objtx);
                     continue label58;
                  }

                  ex = tx;
               }

               if (a) {
                  for(TXmlProperties tl : tableList) {
                     if (ex.getPkey().equals(tl.getPkey())) {
                        a = false;
                     }
                  }

                  ex.setPxmlName("config");
                  ex.setId(UUID.randomUUID().toString().replace("-", ""));
                  this.tXmlPropertiesDao.save(ex);
                  tableList.add(ex);
               }
            }
         }
      } else {
         for(TXmlProperties tx : list) {
            tx.setPxmlName("config");
            tx.setId(UUID.randomUUID().toString().replace("-", ""));
            this.tXmlPropertiesDao.save(tx);
            tableList.add(tx);
         }
      }

      return tableList;
   }

   public void save(TXmlProperties tproperties) {
      tproperties.setPxmlName("config");
      tproperties.setId(UUID.randomUUID().toString().replace("-", ""));
      this.tXmlPropertiesDao.save(tproperties);
   }

   public void remove(String key) {
      this.tXmlPropertiesDao.remove(new Criterion[]{Restrictions.eq("Pkey", key)});
   }

   public TXmlProperties getPropertiese(String key) {
      TXmlProperties tx = (TXmlProperties)this.tXmlPropertiesDao.queryUnique(new Criterion[]{Restrictions.eq("Pkey", key)});
      return tx;
   }

   public List<TXmlProperties> queryPkey(String pkey, PageInfo pageInfo) {
      List<TXmlProperties> list = this.tXmlPropertiesDao.queryByPageInfo(pageInfo, Order.asc("Pkey"), new Criterion[]{Restrictions.like("pkey", "%" + pkey + "%"), Restrictions.eq("flag", "0")});
      return list;
   }

   public TXmlProperties queryTaskByPkey(String Pkey) {
      List<TXmlProperties> obj = this.tXmlPropertiesDao.queryAll(new Criterion[]{Restrictions.eq("Pkey", Pkey)});
      return obj != null && obj.size() > 0 ? (TXmlProperties)obj.get(0) : null;
   }
}
