package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreReleasecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreSensitivecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreSensitivegroupDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreSensitiverelationDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreSensitivesearchlogDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreSensitivetablelogDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivegroup;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitiverelation;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivesearchlog;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivetablelog;
import com.chenyang.nse.bussiness.entity.vo.Releasecolumn;
import com.chenyang.nse.bussiness.entity.vo.SenstiveColumnRelationVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.service.core.SensitiveColumnService;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SensitiveColumnServiceImpl implements SensitiveColumnService {
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   private TCoreSensitivecolumnDao tCoreSensitivecolumnDao;
   @Autowired
   private TCoreSensitiverelationDao tCoreSensitiverelationDao;
   @Autowired
   private TCoreSensitivegroupDao tCoreSensitivegroupDao;
   @Autowired
   private TCoreSensitivesearchlogDao tCoreSensitivesearchlogDao;
   @Autowired
   private TCoreSensitivetablelogDao tCoreSensitivetablelogDao;
   @Autowired
   private TCoreReleasecolumnDao tCoreReleasecolumnDao;

   public List<TCoreSensitivecolumn> queryAllSensitiveColumns() {
      return this.tCoreSensitivecolumnDao.queryAllSensitiveColumns();
   }

   public void remove(String sensitivecolumnid) {
      this.tCoreSensitivecolumnDao.removeById(sensitivecolumnid);
   }

   public void save(String groupId, String datasystemid, String schema, String tableName, List<TCoreSensitivecolumn> newRecords, Map<String, TCoreSensitivecolumn> newRecordMap) {
      int insertCount = 0;
      int updateCount = 0;

      for(TCoreSensitivecolumn newRecord : newRecords) {
         this.tCoreSensitivecolumnDao.save(newRecord);
         ++insertCount;
      }

   }

   public void saveChecked(List<TCoreSensitivecolumn> newRecords) {
      if (newRecords != null && newRecords.size() > 0) {
         Criterion cdatasourceid = Restrictions.eq("datasourceid", ((TCoreSensitivecolumn)newRecords.get(0)).getDatasourceid());
         Criterion cschema = Restrictions.eq("schema", ((TCoreSensitivecolumn)newRecords.get(0)).getTschema());
         Criterion ctablename = Restrictions.eq("tablename", ((TCoreSensitivecolumn)newRecords.get(0)).getTablename());
         this.tCoreSensitivecolumnDao.remove(new Criterion[]{cdatasourceid, cschema, ctablename});
         this.tCoreSensitivecolumnDao.getSession().flush();

         for(TCoreSensitivecolumn newRecord : newRecords) {
            newRecord.setId(StringTool.getTablePrimaryKey());
            this.tCoreSensitivecolumnDao.save(newRecord);
         }
      }

   }

   public List<TCoreSensitivecolumn> queryValidSensitiveColumns(PageInfo pageInfo) {
      return this.tCoreSensitivecolumnDao.queryValidSensitiveColumns(pageInfo);
   }

   public List<TCoreSensitivecolumn> queryAllSensitiveColumns(PageInfo pageInfo) {
      List<TCoreSensitivecolumn> list = this.tCoreSensitivecolumnDao.queryAllSensitiveColumns(pageInfo);
      return list;
   }

   public List<TCoreSensitivecolumn> queryValidSensitiveColumns() {
      List<TCoreSensitivecolumn> list = this.tCoreSensitivecolumnDao.queryAllSensitiveColumns();
      return list;
   }

   public List<TCoreSensitivecolumn> queryCheckedSensitiveColumns(String groupId) {
      return this.tCoreSensitivecolumnDao.queryCheckedSensitiveColumns(groupId);
   }

   public TCoreSensitivecolumn querySensitiveColumn(String groupId, String dataSourceId, String schema, String tableName, String columnName) {
      Criterion cgroupid = Restrictions.eq("groupid", groupId);
      Criterion cdatasourceid = Restrictions.eq("datasourceid", dataSourceId);
      Criterion cschema = Restrictions.eq("schema", schema);
      Criterion ctablename = Restrictions.eq("tablename", tableName);
      Criterion ccolumnname = Restrictions.eq("columnname", columnName);
      Criterion cflag = Restrictions.eq("flag", "1");
      List<TCoreSensitivecolumn> list = this.tCoreSensitivecolumnDao.queryAll(new Criterion[]{cgroupid, cdatasourceid, cschema, ctablename, ccolumnname, cflag});
      return list != null && list.size() > 0 ? (TCoreSensitivecolumn)list.get(0) : null;
   }

   public List<SenstiveColumnRelationVO> querySensitiveColumns(String groupId, String sensitiveColumnId, String regexType) {
      return this.tCoreSensitivecolumnDao.querySensitiveColumns(groupId, sensitiveColumnId, regexType);
   }

   public Boolean saveSensitiveRelation(String sourceColumnId, List<String> targetColumnIds, List<String> deletedColumnIds) {
      System.out.println("nnnnnnnnnnnnnn");
      System.out.println(sourceColumnId);
      System.out.println(targetColumnIds);
      System.out.println(deletedColumnIds);
      Criterion cssensitivecolumnid = Restrictions.eq("ssensitivecolumnid", sourceColumnId);
      Criterion ctsensitivecolumnid = Restrictions.eq("tsensitivecolumnid", sourceColumnId);
      this.tCoreSensitiverelationDao.remove(new Criterion[]{Restrictions.or(cssensitivecolumnid, ctsensitivecolumnid)});
      if (deletedColumnIds != null) {
         Criterion cssensitivecolumnids = Restrictions.in("ssensitivecolumnid", deletedColumnIds);
         Criterion ctsensitivecolumnids = Restrictions.in("tsensitivecolumnid", deletedColumnIds);
         this.tCoreSensitiverelationDao.remove(new Criterion[]{Restrictions.or(cssensitivecolumnids, ctsensitivecolumnids)});
      }

      this.tCoreSensitiverelationDao.getSession().flush();
      if (targetColumnIds != null && targetColumnIds.size() > 0) {
         Set<String> columnIds = new HashSet();
         columnIds.add(sourceColumnId);

         for(String targetColumnId : targetColumnIds) {
            columnIds.add(targetColumnId);
            Criterion cssensitivecolumnid2 = Restrictions.eq("ssensitivecolumnid", targetColumnId);
            List<TCoreSensitiverelation> tempList = this.tCoreSensitiverelationDao.queryAll(new Criterion[]{cssensitivecolumnid2});
            if (tempList != null) {
               for(TCoreSensitiverelation tempRelation : tempList) {
                  columnIds.add(tempRelation.getTsensitivecolumnid());
               }
            }
         }

         Criterion cssensitivecolumnids2 = Restrictions.in("ssensitivecolumnid", targetColumnIds);
         Criterion ctsensitivecolumnids2 = Restrictions.in("tsensitivecolumnid", targetColumnIds);
         this.tCoreSensitiverelationDao.remove(new Criterion[]{Restrictions.or(cssensitivecolumnids2, ctsensitivecolumnids2)});
         this.tCoreSensitiverelationDao.getSession().flush();

         for(String sourceSensitiveColumnId : columnIds) {
            for(String targetSensitiveColumnId : columnIds) {
               if (sourceSensitiveColumnId != targetSensitiveColumnId) {
                  TCoreSensitiverelation relation = new TCoreSensitiverelation();
                  relation.setSsensitivecolumnid(sourceSensitiveColumnId);
                  relation.setTsensitivecolumnid(targetSensitiveColumnId);
                  this.tCoreSensitiverelationDao.save(relation);
               }
            }
         }
      }

      return true;
   }

   public List<TCoreSensitiverelation> querySensitiveColumnRelations(String groupId) {
      return this.tCoreSensitivecolumnDao.querySensitiveColumnRelations(groupId);
   }

   public List<TCoreSensitivegroup> querySensitiveGroup() {
      return this.tCoreSensitivegroupDao.queryAll();
   }

   public String saveSensitiveGroup(String groupName) {
      Criterion cgroupname = Restrictions.eq("name", groupName);
      List<TCoreSensitivegroup> list = this.tCoreSensitivegroupDao.queryAll(new Criterion[]{cgroupname});
      if (list != null && list.size() > 0) {
         return ((TCoreSensitivegroup)list.get(0)).getId();
      } else {
         TCoreSensitivegroup group = new TCoreSensitivegroup();
         group.setTname(groupName);
         this.tCoreSensitivegroupDao.save(group);
         return group.getId();
      }
   }

   public void updSensitiveGroupByID(String groupId, String groupName) {
      Criterion criGroupId = Restrictions.eq("id", groupId);
      TCoreSensitivegroup tsg = (TCoreSensitivegroup)this.tCoreSensitivegroupDao.queryUnique(new Criterion[]{criGroupId});
      if (null != tsg) {
         tsg.setTname(groupName);
         this.tCoreSensitivegroupDao.update(tsg);
      }

   }

   public String getGroupNameByID(String groupId) {
      String gName = "";
      Criterion criGroupId = Restrictions.eq("id", groupId);
      TCoreSensitivegroup tsg = (TCoreSensitivegroup)this.tCoreSensitivegroupDao.queryUnique(new Criterion[]{criGroupId});
      if (null != tsg) {
         gName = tsg.getTname();
      }

      return gName;
   }

   public List<TCoreSensitivegroup> querySensitiveGroup(String dataSourceId, List<String> schemas) {
      return this.tCoreSensitivegroupDao.querySensitiveGroup(dataSourceId, schemas);
   }

   public List<TCoreSensitivecolumn> querySensitiveColumnsByGroupId(String groupId) {
      return this.tCoreSensitivecolumnDao.querySensitiveColumnsByGroupId(groupId);
   }

   public void saveSensitiveParamter(List<TCoreSensitivesearchlog> tcoreSensitivesearchlog, String groupId) {
      List<TCoreSensitivesearchlog> list = this.tCoreSensitivesearchlogDao.queryAll(new Criterion[]{Restrictions.eq("groupid", groupId)});
      this.tCoreSensitivesearchlogDao.remove(list);

      for(TCoreSensitivesearchlog log : tcoreSensitivesearchlog) {
         this.tCoreSensitivesearchlogDao.save(log);
      }

   }

   public List<TCoreSensitivesearchlog> querySensitivesearchlogByGroupId(String groupId) {
      List<TCoreSensitivesearchlog> list = this.tCoreSensitivesearchlogDao.queryAll(new Criterion[]{Restrictions.eq("groupid", groupId)});
      return list;
   }

   public Date getMaxDate(String datasystemid, String tablename, String schema) {
      return this.tCoreSensitivecolumnDao.getMaxDate(datasystemid, tablename, schema);
   }

   public List<TCoreSensitivecolumn> querySensitiveColumnsByGroupId(String groupId, Date createtime) {
      return this.tCoreSensitivecolumnDao.querySensitiveColumnsByGroupId(groupId, createtime);
   }

   public int updateflag(String groupid) {
      return this.tCoreSensitivecolumnDao.updateflag(groupid);
   }

   public List<TCoreSensitivegroup> queryAllSensitiveGroupPage(PageInfo pageInfo) {
      List<TCoreSensitivegroup> list = this.tCoreSensitivegroupDao.queryAllSensitiveGroupPage(pageInfo);
      return list;
   }

   public List<TCoreSensitivecolumn> queryAllSensitiveTimeByGroupid(String groupId) {
      List<TCoreSensitivecolumn> list = this.tCoreSensitivecolumnDao.getSensitiveColumnsTime(groupId);
      return list;
   }

   public int removeSensitivecolumn(String groupid) {
      int result = 1;
      this.tCoreSensitivecolumnDao.removeBygroupid(groupid);
      this.tCoreSensitivegroupDao.removeById(groupid);
      return 1;
   }

   public int removeSensitivecolumn(String groupid, String time) {
      int result = 1;
      this.tCoreSensitivecolumnDao.removeBygroupidByTime(groupid, time);
      return result;
   }

   public List<TCoreSensitivecolumn> queryAllSensitiveColumns(String groupid, String time) {
      return this.tCoreSensitivecolumnDao.queryAllSensitiveColumns(groupid, time);
   }

   public List<TCoreSensitivegroup> querySensitiveGroup(String dataSourceId) {
      return this.tCoreSensitivegroupDao.querySensitiveGroup(dataSourceId);
   }

   public List<TCoreSensitivecolumn> getSensitiveByIdBySchema(String datasystemid, String schema) {
      TCoreDatasystem tcoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(datasystemid);
      String type = tcoreDatasystem.getDbtype();
      if (type.equals(EdbType.MSSQLSERVER.toString())) {
         Date maxtime = this.getMaxDate(datasystemid, (String)null, (String)null);
         return this.tCoreSensitivecolumnDao.getSensitiveByIdBySchema(datasystemid, maxtime);
      } else {
         Date maxtime = this.getMaxDate(datasystemid, (String)null, schema);
         return this.tCoreSensitivecolumnDao.getSensitiveByIdBySchema(datasystemid, maxtime, schema);
      }
   }

   public List<TCoreSensitivecolumn> getSensitiveByStructureId(String datasystemid) {
      return this.tCoreSensitivecolumnDao.getSensitiveByStructureId(datasystemid);
   }

   public List<TCoreSensitivecolumn> getSensitiveByIdBySchema(String datasystemid, String schema, String table) {
      TCoreDatasystem tcoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(datasystemid);
      String type = tcoreDatasystem.getDbtype();
      Date date = this.getMaxDate(datasystemid, table, schema);
      return this.tCoreSensitivecolumnDao.getSensitiveByIdBySchema(datasystemid, date, schema, table);
   }

   public List<TCoreSensitivegroup> queryAllSensitiveGroup() {
      return this.tCoreSensitivegroupDao.queryAllSensitiveGroupOrderByUpdatetime();
   }

   public List<TCoreSensitivecolumn> querySensitiveColumnsByGroupIdByTable(String groupId, String table) {
      new ArrayList();
      List<TCoreSensitivecolumn> list = this.tCoreSensitivecolumnDao.queryAll(new Criterion[]{Restrictions.eq("groupid", groupId), Restrictions.eq("tablename", table), Restrictions.eq("flag", "1")});
      return list;
   }

   public List<TCoreSensitivecolumn> querySensitiveColumnsByGroupIdNew(String groupId) {
      long a = System.currentTimeMillis();
      List<TCoreSensitivecolumn> list = this.tCoreSensitivecolumnDao.querySensitiveColumnsByGroupIdNew(groupId);
      long b = System.currentTimeMillis();
      System.out.println(b - a);
      System.out.println(b - a);
      return list;
   }

   public List<TCoreSensitivecolumn> querySensitiveColumnsByGroupIdByTime(String groupId, Date createtime) {
      return this.tCoreSensitivecolumnDao.queryAll(new Criterion[]{Restrictions.eq("groupid", groupId), Restrictions.eq("createtime", createtime)});
   }

   public void savealltable(String groupId, String datasystemid, String schema, String tableName, List<TCoreSensitivetablelog> newRecords) {
      for(TCoreSensitivetablelog newRecord : newRecords) {
         this.tCoreSensitivetablelogDao.save(newRecord);
      }

   }

   public void delTCoreSensitivetablelog(String groupId) {
      this.tCoreSensitivetablelogDao.deletetablelog(groupId);
   }

   public List<TCoreSensitivetablelog> queryTCoreSensitivetablelog(String groupid, String state) {
      Criterion criterion = Restrictions.isNotEmpty("regextype");
      Criterion criterion1 = Restrictions.eq("groupid", groupid);
      return state.equals("1") ? this.tCoreSensitivetablelogDao.queryAll(new Criterion[]{criterion, criterion1}) : this.tCoreSensitivetablelogDao.queryAll(new Criterion[]{criterion1});
   }

   public List<Releasecolumn> queryTcoreReleasecolumn(List<String> schemas, String projectid, String table) {
      return this.tCoreReleasecolumnDao.queryTcoreReleasecolumn(schemas, projectid, table);
   }

   public void deleReleasecolumnByProductId(String productid, String table) {
      this.tCoreReleasecolumnDao.deleReleasecolumnByProductId(productid, table);
   }

   public void saveReleasecolumn(StringBuilder sql) {
      this.tCoreReleasecolumnDao.saveReleasecolumn(sql);
   }

   public void removeReleasecolumn(List<Releasecolumn> removeReleasecolumn, String table) {
      int count = removeReleasecolumn.size();
      StringBuilder sb = new StringBuilder();
      sb.append("delete from " + table + " where id in (");

      for(int i = 0; i < count; ++i) {
         sb.append("'");
         sb.append(((Releasecolumn)removeReleasecolumn.get(i)).getTid());
         sb.append("',");
         if (i != 0 && (i + 1) % 800 == 0) {
            this.tCoreReleasecolumnDao.removeReleasecolumn(sb.deleteCharAt(sb.length() - 1).append(")"));
            sb.setLength(0);
            sb.append("delete from " + table + " where id in (");
         }
      }

      if (count % 800 != 0) {
         this.tCoreReleasecolumnDao.removeReleasecolumn(sb.deleteCharAt(sb.length() - 1).append(")"));
         sb.setLength(0);
      }

   }
}
