package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.table.core.notice.SnmpTrapDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.notice.SnmpTrapInfomation;
import com.chenyang.nse.bussiness.service.core.SnmpTrapService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SnmpTrapServiceImpl implements SnmpTrapService {
   @Autowired
   private SnmpTrapDao snmpTrapDao;

   public SnmpTrapInfomation initSnmp(String id) {
      return (SnmpTrapInfomation)this.snmpTrapDao.queryUnique(new Criterion[]{Restrictions.eq("id", id)});
   }

   public void addSnmp(SnmpTrapInfomation snmpTrapInfomation) {
      String username = CommonUtils.loginUsername();
      if (StringUtils.isBlank(snmpTrapInfomation.getId())) {
         snmpTrapInfomation.setCreateuser(username);
         snmpTrapInfomation.setCreatetime(new Date());
         snmpTrapInfomation.setFlag("0");
         snmpTrapInfomation.setId(StringTool.getTablePrimaryKey());
         this.snmpTrapDao.save(snmpTrapInfomation);
      } else {
         SnmpTrapInfomation snmpInfo = (SnmpTrapInfomation)this.snmpTrapDao.queryUnique(new Criterion[]{Restrictions.eq("id", snmpTrapInfomation.getId())});
         BeanUtils.copyProperties(snmpTrapInfomation, snmpInfo);
         snmpTrapInfomation.setFlag("0");
         snmpInfo.setUpdateuser(username);
         snmpInfo.setUpdatetime(new Date());
         this.snmpTrapDao.saveOrUpdate(snmpInfo);
      }

   }

   public void remove(String id) {
      Criterion croleid = Restrictions.in("id", new Object[]{id});
      this.snmpTrapDao.remove(new Criterion[]{croleid});
   }

   public List<SnmpTrapInfomation> queryAll() {
      return this.snmpTrapDao.queryAll();
   }
}
