package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.systemparameter.TCoreSystemparameterDao;
import com.chenyang.nse.bussiness.dao.table.core.systemparameter.TCoreSystemparameterValueDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.systemparameter.TCoreSystemparameter;
import com.chenyang.nse.bussiness.entity.orm.table.core.systemparameter.TCoreSystemparameterValue;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.entity.vo.TreeGridVO;
import com.chenyang.nse.bussiness.service.core.SystemParameterService;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SystemParameterServiceImpl implements SystemParameterService {
   @Autowired
   private TCoreSystemparameterDao tCoreSystemparameterDao;
   @Autowired
   private TCoreSystemparameterValueDao tCoreSystemparameterValueDao;

   public List<Map<String, Object>> querySystemParameter(PageInfo pageInfo) {
      long count = this.tCoreSystemparameterDao.count();
      pageInfo.setCount(count);
      List<Map<String, Object>> list = this.tCoreSystemparameterDao.querySystemParameter(pageInfo);
      return list;
   }

   public List<TreeGridVO> queryDir(String parentid, String path) {
      List<TreeGridVO> tglist = new ArrayList();
      List<String> filelist = FileTool.getPathDir(path);
      int id = 0;

      for(String str : filelist) {
         TreeGridVO treeGridVO = new TreeGridVO();
         treeGridVO.setId(parentid + "-" + id);
         ++id;
         treeGridVO.setParentid(parentid);
         treeGridVO.setMenuname(str);
         treeGridVO.setState("closed");
         tglist.add(treeGridVO);
      }

      return tglist;
   }

   public void addSystemParameter(Map<String, String> map) {
      String systemparameterid = (String)map.get("systemparameterid");
      boolean isEdit = !systemparameterid.equals("");
      TCoreSystemparameter tCoreSystemparameter = new TCoreSystemparameter();
      if (isEdit) {
         tCoreSystemparameter.setId(systemparameterid);
      }

      tCoreSystemparameter.setParametername((String)map.get("parametername"));
      tCoreSystemparameter.setCreatetime(new Date());
      this.tCoreSystemparameterDao.saveOrUpdate(tCoreSystemparameter);
      if (isEdit) {
         this.tCoreSystemparameterValueDao.remove(new Criterion[]{Restrictions.eq("systemparameterid", systemparameterid)});
      }

      TCoreSystemparameterValue tCoreSystemparameterValue = new TCoreSystemparameterValue();
      tCoreSystemparameterValue.setSystemparameterid(tCoreSystemparameter.getId());
      tCoreSystemparameterValue.setPropertyid("1");
      tCoreSystemparameterValue.setPropertyvalue((String)map.get("systempath"));
      this.tCoreSystemparameterValueDao.save(tCoreSystemparameterValue);
   }

   public void removeSystemParameter(String id) {
      this.tCoreSystemparameterValueDao.remove(new Criterion[]{Restrictions.eq("systemparameterid", id)});
      this.tCoreSystemparameterDao.removeById(id);
   }

   public ResultVO repeatName(String parametername) {
      List<TCoreSystemparameter> list = this.tCoreSystemparameterDao.queryAll(new Criterion[]{Restrictions.eq("parametername", parametername)});
      return list.size() <= 0 ? new ResultVO("", false) : new ResultVO(((TCoreSystemparameter)list.get(0)).getId(), true);
   }
}
