package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.subset.TCoreSubsetFieldDao;
import com.chenyang.nse.bussiness.dao.table.core.subset.TCoreSubsetInfoDao;
import com.chenyang.nse.bussiness.dao.table.core.subset.TCoreSubsetRelationDao;
import com.chenyang.nse.bussiness.dao.table.core.subset.TCoreSubsetTableDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.subset.TCoreSubsetField;
import com.chenyang.nse.bussiness.entity.orm.table.core.subset.TCoreSubsetInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.subset.TCoreSubsetRelation;
import com.chenyang.nse.bussiness.entity.orm.table.core.subset.TCoreSubsetTable;
import com.chenyang.nse.bussiness.entity.vo.subset.SubsetInfoVo;
import com.chenyang.nse.bussiness.service.core.subsetmanagement.TCoreSubsetManagementService;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TCoreSubsetManagementServiceImpl implements TCoreSubsetManagementService {
   @Autowired
   TCoreSubsetInfoDao tCoreSubsetInfoDao;
   @Autowired
   TCoreSubsetTableDao tCoreSubsetTableDao;
   @Autowired
   TCoreSubsetFieldDao tCoreSubsetFieldDao;
   @Autowired
   TCoreSubsetRelationDao tCoreSubsetRelationDao;
   @Autowired
   TCoreDatasystemDao tCoreDatasystemDao;

   public List<SubsetInfoVo> querysubset() {
      List<SubsetInfoVo> SubsetInfoVoList = new ArrayList();

      for(TCoreSubsetInfo tCoreSubsetInfo : this.tCoreSubsetInfoDao.queryAll()) {
         String subid = tCoreSubsetInfo.getId();
         String subname = tCoreSubsetInfo.getSubname();

         for(TCoreSubsetTable tCoreSubsetTable : this.tCoreSubsetTableDao.queryAll(new Criterion[]{Restrictions.eq("subsetid", subid)})) {
            String tablename = tCoreSubsetTable.getTablename();
            String tableid = tCoreSubsetTable.getId();
            String schemaName = tCoreSubsetTable.getSchemaName();
            String systemID = tCoreSubsetTable.getSystemID();
            TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(systemID);
            String sysname = tCoreDatasystem.getSysname();

            for(TCoreSubsetField tCoreSubsetField : this.tCoreSubsetFieldDao.queryAll(new Criterion[]{Restrictions.eq("tableid", tableid)})) {
               String fieldname = tCoreSubsetField.getFieldname();
               String subsetfieldid = tCoreSubsetField.getId();
               String keytype = tCoreSubsetField.getKeytype();

               for(TCoreSubsetRelation tCoreSubsetRelation : this.tCoreSubsetRelationDao.queryAll(new Criterion[]{Restrictions.eq("fieldid", subsetfieldid)})) {
                  String relationtype = tCoreSubsetRelation.getRelationtype();
                  String startfiled = tCoreSubsetRelation.getStartfiled();
                  String endfiled = tCoreSubsetRelation.getEndfiled();
                  SubsetInfoVo subsetInfoVo = new SubsetInfoVo();
                  subsetInfoVo.setTabletid(tableid);
                  subsetInfoVo.setSubtid(subid);
                  subsetInfoVo.setSystemID(systemID);
                  subsetInfoVo.setSystemName(sysname);
                  subsetInfoVo.setSchemaName(schemaName);
                  subsetInfoVo.setSubname(subname);
                  subsetInfoVo.setTablename(tablename);
                  subsetInfoVo.setFieldname(fieldname);
                  subsetInfoVo.setKeytype(keytype);
                  subsetInfoVo.setRelationtype(relationtype);
                  subsetInfoVo.setStartfiled(startfiled);
                  subsetInfoVo.setEndfiled(endfiled);
                  SubsetInfoVoList.add(subsetInfoVo);
               }
            }
         }
      }

      return SubsetInfoVoList;
   }

   public String deletesubset(String subid) {
      this.tCoreSubsetInfoDao.removeById(subid);
      this.tCoreSubsetTableDao.remove(new Criterion[]{Restrictions.eq("subsetid", subid)});
      return "1";
   }

   public String savesubset(List<SubsetInfoVo> subsetlist) {
      for(SubsetInfoVo subsetInfoVo : subsetlist) {
         String subtid = subsetInfoVo.getSubtid();
         String tabletid = subsetInfoVo.getTabletid();
         if (subtid == null) {
            TCoreSubsetInfo tCoreSubsetInfo = new TCoreSubsetInfo();
            tCoreSubsetInfo.setSubname(subsetInfoVo.getSubname());
            this.tCoreSubsetInfoDao.save(tCoreSubsetInfo);
            subtid = tCoreSubsetInfo.getId();
         }

         if (tabletid == null) {
            TCoreSubsetTable tCoreSubsetTable = new TCoreSubsetTable();
            tCoreSubsetTable.setSchemaName(subsetInfoVo.getSchemaName());
            tCoreSubsetTable.setSubsetid(subtid);
            tCoreSubsetTable.setSystemID(subsetInfoVo.getSystemID());
            tCoreSubsetTable.setTablename(subsetInfoVo.getTablename());
            this.tCoreSubsetTableDao.save(tCoreSubsetTable);
         }
      }

      return "1";
   }

   public List<SubsetInfoVo> searchsubset(String subname, String schemaName, String systemName, String tablename) {
      List<SubsetInfoVo> SubsetInfoVoList = new ArrayList();
      if (subname != "") {
         for(TCoreSubsetInfo tCoreSubsetInfo : this.tCoreSubsetInfoDao.queryAll(new Criterion[]{Restrictions.like("subname", subname, MatchMode.ANYWHERE)})) {
            String subtid = tCoreSubsetInfo.getId();
            String ssubname = tCoreSubsetInfo.getSubname();
            if (schemaName != "" && systemName != "" && tablename != "") {
               for(TCoreDatasystem tCoreDatasystem : this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.like("sysname", systemName, MatchMode.ANYWHERE)})) {
                  String systemID = tCoreDatasystem.getId();

                  for(TCoreSubsetTable tCoreSubsetTable : this.tCoreSubsetTableDao.queryAll(new Criterion[]{Restrictions.like("schemaName", schemaName, MatchMode.ANYWHERE), Restrictions.like("tablename", tablename, MatchMode.ANYWHERE), Restrictions.like("systemID", systemID), Restrictions.eq("subsetid", subtid)})) {
                     SubsetInfoVo subsetInfoVo = new SubsetInfoVo();
                     String stablename = tCoreSubsetTable.getTablename();
                     String tableid = tCoreSubsetTable.getId();
                     String sschemaName = tCoreSubsetTable.getSchemaName();
                     String sysname = tCoreDatasystem.getSysname();
                     subsetInfoVo.setTabletid(tableid);
                     subsetInfoVo.setSubtid(subtid);
                     subsetInfoVo.setSystemID(systemID);
                     subsetInfoVo.setSystemName(sysname);
                     subsetInfoVo.setSchemaName(sschemaName);
                     subsetInfoVo.setSubname(ssubname);
                     subsetInfoVo.setTablename(stablename);
                     SubsetInfoVoList.add(subsetInfoVo);
                  }
               }
            }

            if (schemaName != "" && systemName == "" && tablename == "") {
               for(TCoreSubsetTable tCoreSubsetTable : this.tCoreSubsetTableDao.queryAll(new Criterion[]{Restrictions.like("schemaName", schemaName, MatchMode.ANYWHERE), Restrictions.eq("subsetid", subtid)})) {
                  SubsetInfoVo subsetInfoVo = new SubsetInfoVo();
                  String stablename = tCoreSubsetTable.getTablename();
                  String tableid = tCoreSubsetTable.getId();
                  String sschemaName = tCoreSubsetTable.getSchemaName();
                  String systemID = tCoreSubsetTable.getSystemID();
                  TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(systemID);
                  String sysname = tCoreDatasystem.getSysname();
                  subsetInfoVo.setTabletid(tableid);
                  subsetInfoVo.setSubtid(subtid);
                  subsetInfoVo.setSystemID(systemID);
                  subsetInfoVo.setSystemName(sysname);
                  subsetInfoVo.setSchemaName(sschemaName);
                  subsetInfoVo.setSubname(ssubname);
                  subsetInfoVo.setTablename(stablename);
                  SubsetInfoVoList.add(subsetInfoVo);
               }
            }

            if (schemaName == "" && systemName != "" && tablename == "") {
               for(TCoreDatasystem tCoreDatasystem : this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.like("sysname", systemName, MatchMode.ANYWHERE)})) {
                  String systemID = tCoreDatasystem.getId();
                  List<TCoreSubsetTable> queryAll = this.tCoreSubsetTableDao.queryAll(new Criterion[]{Restrictions.like("systemID", systemID), Restrictions.eq("subsetid", subtid)});
                  if (queryAll.size() > 0) {
                     for(TCoreSubsetTable tCoreSubsetTable : queryAll) {
                        SubsetInfoVo subsetInfoVo = new SubsetInfoVo();
                        String stablename = tCoreSubsetTable.getTablename();
                        String tableid = tCoreSubsetTable.getId();
                        String sschemaName = tCoreSubsetTable.getSchemaName();
                        String sysname = tCoreDatasystem.getSysname();
                        subsetInfoVo.setTabletid(tableid);
                        subsetInfoVo.setSubtid(subtid);
                        subsetInfoVo.setSystemID(systemID);
                        subsetInfoVo.setSystemName(sysname);
                        subsetInfoVo.setSchemaName(sschemaName);
                        subsetInfoVo.setSubname(ssubname);
                        subsetInfoVo.setTablename(stablename);
                        SubsetInfoVoList.add(subsetInfoVo);
                     }
                  }
               }
            }

            if (schemaName == "" && systemName == "" && tablename != "") {
               for(TCoreSubsetTable tCoreSubsetTable : this.tCoreSubsetTableDao.queryAll(new Criterion[]{Restrictions.like("tablename", tablename, MatchMode.ANYWHERE), Restrictions.eq("subsetid", subtid)})) {
                  SubsetInfoVo subsetInfoVo = new SubsetInfoVo();
                  String stablename = tCoreSubsetTable.getTablename();
                  String tableid = tCoreSubsetTable.getId();
                  String sschemaName = tCoreSubsetTable.getSchemaName();
                  String systemID = tCoreSubsetTable.getSystemID();
                  TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(systemID);
                  String sysname = tCoreDatasystem.getSysname();
                  subsetInfoVo.setTabletid(tableid);
                  subsetInfoVo.setSubtid(subtid);
                  subsetInfoVo.setSystemID(systemID);
                  subsetInfoVo.setSystemName(sysname);
                  subsetInfoVo.setSchemaName(sschemaName);
                  subsetInfoVo.setSubname(ssubname);
                  subsetInfoVo.setTablename(stablename);
                  SubsetInfoVoList.add(subsetInfoVo);
               }
            }

            if (schemaName != "" && systemName != "" && tablename == "") {
               for(TCoreDatasystem tCoreDatasystem : this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.like("sysname", systemName, MatchMode.ANYWHERE)})) {
                  String systemID = tCoreDatasystem.getId();

                  for(TCoreSubsetTable tCoreSubsetTable : this.tCoreSubsetTableDao.queryAll(new Criterion[]{Restrictions.like("schemaName", schemaName, MatchMode.ANYWHERE), Restrictions.like("systemID", systemID), Restrictions.eq("subsetid", subtid)})) {
                     SubsetInfoVo subsetInfoVo = new SubsetInfoVo();
                     String stablename = tCoreSubsetTable.getTablename();
                     String tableid = tCoreSubsetTable.getId();
                     String sschemaName = tCoreSubsetTable.getSchemaName();
                     String sysname = tCoreDatasystem.getSysname();
                     subsetInfoVo.setTabletid(tableid);
                     subsetInfoVo.setSubtid(subtid);
                     subsetInfoVo.setSystemID(systemID);
                     subsetInfoVo.setSystemName(sysname);
                     subsetInfoVo.setSchemaName(sschemaName);
                     subsetInfoVo.setSubname(ssubname);
                     subsetInfoVo.setTablename(stablename);
                     SubsetInfoVoList.add(subsetInfoVo);
                  }
               }
            }

            if (schemaName != "" && systemName == "" && tablename != "") {
               for(TCoreSubsetTable tCoreSubsetTable : this.tCoreSubsetTableDao.queryAll(new Criterion[]{Restrictions.like("schemaName", schemaName, MatchMode.ANYWHERE), Restrictions.like("tablename", tablename, MatchMode.ANYWHERE), Restrictions.eq("subsetid", subtid)})) {
                  SubsetInfoVo subsetInfoVo = new SubsetInfoVo();
                  String stablename = tCoreSubsetTable.getTablename();
                  String tableid = tCoreSubsetTable.getId();
                  String sschemaName = tCoreSubsetTable.getSchemaName();
                  String systemID = tCoreSubsetTable.getSystemID();
                  TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(systemID);
                  String sysname = tCoreDatasystem.getSysname();
                  subsetInfoVo.setTabletid(tableid);
                  subsetInfoVo.setSubtid(subtid);
                  subsetInfoVo.setSystemID(systemID);
                  subsetInfoVo.setSystemName(sysname);
                  subsetInfoVo.setSchemaName(sschemaName);
                  subsetInfoVo.setSubname(ssubname);
                  subsetInfoVo.setTablename(stablename);
                  SubsetInfoVoList.add(subsetInfoVo);
               }
            }

            if (schemaName == "" && systemName != "" && tablename != "") {
               for(TCoreDatasystem tCoreDatasystem : this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.like("sysname", systemName, MatchMode.ANYWHERE)})) {
                  String systemID = tCoreDatasystem.getId();

                  for(TCoreSubsetTable tCoreSubsetTable : this.tCoreSubsetTableDao.queryAll(new Criterion[]{Restrictions.like("systemID", systemID), Restrictions.like("tablename", tablename, MatchMode.ANYWHERE), Restrictions.eq("subsetid", subtid)})) {
                     SubsetInfoVo subsetInfoVo = new SubsetInfoVo();
                     String stablename = tCoreSubsetTable.getTablename();
                     String tableid = tCoreSubsetTable.getId();
                     String sschemaName = tCoreSubsetTable.getSchemaName();
                     String sysname = tCoreDatasystem.getSysname();
                     subsetInfoVo.setTabletid(tableid);
                     subsetInfoVo.setSubtid(subtid);
                     subsetInfoVo.setSystemID(systemID);
                     subsetInfoVo.setSystemName(sysname);
                     subsetInfoVo.setSchemaName(sschemaName);
                     subsetInfoVo.setSubname(ssubname);
                     subsetInfoVo.setTablename(stablename);
                     SubsetInfoVoList.add(subsetInfoVo);
                  }
               }
            }

            if (schemaName == "" && systemName == "" && tablename == "") {
               for(TCoreSubsetTable tCoreSubsetTable : this.tCoreSubsetTableDao.queryAll(new Criterion[]{Restrictions.eq("subsetid", subtid)})) {
                  SubsetInfoVo subsetInfoVo = new SubsetInfoVo();
                  String stablename = tCoreSubsetTable.getTablename();
                  String tableid = tCoreSubsetTable.getId();
                  String sschemaName = tCoreSubsetTable.getSchemaName();
                  String systemID = tCoreSubsetTable.getSystemID();
                  TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(systemID);
                  String sysname = tCoreDatasystem.getSysname();
                  subsetInfoVo.setTabletid(tableid);
                  subsetInfoVo.setSubtid(subtid);
                  subsetInfoVo.setSystemID(systemID);
                  subsetInfoVo.setSystemName(sysname);
                  subsetInfoVo.setSchemaName(sschemaName);
                  subsetInfoVo.setSubname(ssubname);
                  subsetInfoVo.setTablename(stablename);
                  SubsetInfoVoList.add(subsetInfoVo);
               }
            }
         }
      } else {
         for(TCoreSubsetInfo tCoreSubsetInfo : this.tCoreSubsetInfoDao.queryAll()) {
            String subtid = tCoreSubsetInfo.getId();
            String ssubname = tCoreSubsetInfo.getSubname();
            if (schemaName != "" && systemName != "" && tablename != "") {
               for(TCoreDatasystem tCoreDatasystem : this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.like("sysname", systemName, MatchMode.ANYWHERE)})) {
                  String systemID = tCoreDatasystem.getId();

                  for(TCoreSubsetTable tCoreSubsetTable : this.tCoreSubsetTableDao.queryAll(new Criterion[]{Restrictions.like("schemaName", schemaName, MatchMode.ANYWHERE), Restrictions.like("tablename", tablename, MatchMode.ANYWHERE), Restrictions.like("systemID", systemID), Restrictions.eq("subsetid", subtid)})) {
                     SubsetInfoVo subsetInfoVo = new SubsetInfoVo();
                     String stablename = tCoreSubsetTable.getTablename();
                     String tableid = tCoreSubsetTable.getId();
                     String sschemaName = tCoreSubsetTable.getSchemaName();
                     String sysname = tCoreDatasystem.getSysname();
                     subsetInfoVo.setTabletid(tableid);
                     subsetInfoVo.setSubtid(subtid);
                     subsetInfoVo.setSystemID(systemID);
                     subsetInfoVo.setSystemName(sysname);
                     subsetInfoVo.setSchemaName(sschemaName);
                     subsetInfoVo.setSubname(ssubname);
                     subsetInfoVo.setTablename(stablename);
                     SubsetInfoVoList.add(subsetInfoVo);
                  }
               }
            }

            if (schemaName != "" && systemName == "" && tablename == "") {
               for(TCoreSubsetTable tCoreSubsetTable : this.tCoreSubsetTableDao.queryAll(new Criterion[]{Restrictions.like("schemaName", schemaName, MatchMode.ANYWHERE), Restrictions.eq("subsetid", subtid)})) {
                  SubsetInfoVo subsetInfoVo = new SubsetInfoVo();
                  String stablename = tCoreSubsetTable.getTablename();
                  String tableid = tCoreSubsetTable.getId();
                  String sschemaName = tCoreSubsetTable.getSchemaName();
                  String systemID = tCoreSubsetTable.getSystemID();
                  TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(systemID);
                  String sysname = tCoreDatasystem.getSysname();
                  subsetInfoVo.setTabletid(tableid);
                  subsetInfoVo.setSubtid(subtid);
                  subsetInfoVo.setSystemID(systemID);
                  subsetInfoVo.setSystemName(sysname);
                  subsetInfoVo.setSchemaName(sschemaName);
                  subsetInfoVo.setSubname(ssubname);
                  subsetInfoVo.setTablename(stablename);
                  SubsetInfoVoList.add(subsetInfoVo);
               }
            }

            if (schemaName == "" && systemName != "" && tablename == "") {
               for(TCoreDatasystem tCoreDatasystem : this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.like("sysname", systemName, MatchMode.ANYWHERE)})) {
                  String systemID = tCoreDatasystem.getId();
                  List<TCoreSubsetTable> queryAll = this.tCoreSubsetTableDao.queryAll(new Criterion[]{Restrictions.like("systemID", systemID), Restrictions.eq("subsetid", subtid)});
                  if (queryAll.size() > 0) {
                     for(TCoreSubsetTable tCoreSubsetTable : queryAll) {
                        SubsetInfoVo subsetInfoVo = new SubsetInfoVo();
                        String stablename = tCoreSubsetTable.getTablename();
                        String tableid = tCoreSubsetTable.getId();
                        String sschemaName = tCoreSubsetTable.getSchemaName();
                        String sysname = tCoreDatasystem.getSysname();
                        subsetInfoVo.setTabletid(tableid);
                        subsetInfoVo.setSubtid(subtid);
                        subsetInfoVo.setSystemID(systemID);
                        subsetInfoVo.setSystemName(sysname);
                        subsetInfoVo.setSchemaName(sschemaName);
                        subsetInfoVo.setSubname(ssubname);
                        subsetInfoVo.setTablename(stablename);
                        SubsetInfoVoList.add(subsetInfoVo);
                     }
                  }
               }
            }

            if (schemaName == "" && systemName == "" && tablename != "") {
               for(TCoreSubsetTable tCoreSubsetTable : this.tCoreSubsetTableDao.queryAll(new Criterion[]{Restrictions.like("tablename", tablename, MatchMode.ANYWHERE), Restrictions.eq("subsetid", subtid)})) {
                  SubsetInfoVo subsetInfoVo = new SubsetInfoVo();
                  String stablename = tCoreSubsetTable.getTablename();
                  String tableid = tCoreSubsetTable.getId();
                  String sschemaName = tCoreSubsetTable.getSchemaName();
                  String systemID = tCoreSubsetTable.getSystemID();
                  TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(systemID);
                  String sysname = tCoreDatasystem.getSysname();
                  subsetInfoVo.setTabletid(tableid);
                  subsetInfoVo.setSubtid(subtid);
                  subsetInfoVo.setSystemID(systemID);
                  subsetInfoVo.setSystemName(sysname);
                  subsetInfoVo.setSchemaName(sschemaName);
                  subsetInfoVo.setSubname(ssubname);
                  subsetInfoVo.setTablename(stablename);
                  SubsetInfoVoList.add(subsetInfoVo);
               }
            }

            if (schemaName != "" && systemName != "" && tablename == "") {
               for(TCoreDatasystem tCoreDatasystem : this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.like("sysname", systemName, MatchMode.ANYWHERE)})) {
                  String systemID = tCoreDatasystem.getId();

                  for(TCoreSubsetTable tCoreSubsetTable : this.tCoreSubsetTableDao.queryAll(new Criterion[]{Restrictions.like("schemaName", schemaName, MatchMode.ANYWHERE), Restrictions.like("systemID", systemID), Restrictions.eq("subsetid", subtid)})) {
                     SubsetInfoVo subsetInfoVo = new SubsetInfoVo();
                     String stablename = tCoreSubsetTable.getTablename();
                     String tableid = tCoreSubsetTable.getId();
                     String sschemaName = tCoreSubsetTable.getSchemaName();
                     String sysname = tCoreDatasystem.getSysname();
                     subsetInfoVo.setTabletid(tableid);
                     subsetInfoVo.setSubtid(subtid);
                     subsetInfoVo.setSystemID(systemID);
                     subsetInfoVo.setSystemName(sysname);
                     subsetInfoVo.setSchemaName(sschemaName);
                     subsetInfoVo.setSubname(ssubname);
                     subsetInfoVo.setTablename(stablename);
                     SubsetInfoVoList.add(subsetInfoVo);
                  }
               }
            }

            if (schemaName != "" && systemName == "" && tablename != "") {
               for(TCoreSubsetTable tCoreSubsetTable : this.tCoreSubsetTableDao.queryAll(new Criterion[]{Restrictions.like("schemaName", schemaName, MatchMode.ANYWHERE), Restrictions.like("tablename", tablename, MatchMode.ANYWHERE), Restrictions.eq("subsetid", subtid)})) {
                  SubsetInfoVo subsetInfoVo = new SubsetInfoVo();
                  String stablename = tCoreSubsetTable.getTablename();
                  String tableid = tCoreSubsetTable.getId();
                  String sschemaName = tCoreSubsetTable.getSchemaName();
                  String systemID = tCoreSubsetTable.getSystemID();
                  TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(systemID);
                  String sysname = tCoreDatasystem.getSysname();
                  subsetInfoVo.setTabletid(tableid);
                  subsetInfoVo.setSubtid(subtid);
                  subsetInfoVo.setSystemID(systemID);
                  subsetInfoVo.setSystemName(sysname);
                  subsetInfoVo.setSchemaName(sschemaName);
                  subsetInfoVo.setSubname(ssubname);
                  subsetInfoVo.setTablename(stablename);
                  SubsetInfoVoList.add(subsetInfoVo);
               }
            }

            if (schemaName == "" && systemName != "" && tablename != "") {
               for(TCoreDatasystem tCoreDatasystem : this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.like("sysname", systemName, MatchMode.ANYWHERE)})) {
                  String systemID = tCoreDatasystem.getId();

                  for(TCoreSubsetTable tCoreSubsetTable : this.tCoreSubsetTableDao.queryAll(new Criterion[]{Restrictions.like("systemID", systemID), Restrictions.like("tablename", tablename, MatchMode.ANYWHERE), Restrictions.eq("subsetid", subtid)})) {
                     SubsetInfoVo subsetInfoVo = new SubsetInfoVo();
                     String stablename = tCoreSubsetTable.getTablename();
                     String tableid = tCoreSubsetTable.getId();
                     String sschemaName = tCoreSubsetTable.getSchemaName();
                     String sysname = tCoreDatasystem.getSysname();
                     subsetInfoVo.setTabletid(tableid);
                     subsetInfoVo.setSubtid(subtid);
                     subsetInfoVo.setSystemID(systemID);
                     subsetInfoVo.setSystemName(sysname);
                     subsetInfoVo.setSchemaName(sschemaName);
                     subsetInfoVo.setSubname(ssubname);
                     subsetInfoVo.setTablename(stablename);
                     SubsetInfoVoList.add(subsetInfoVo);
                  }
               }
            }

            if (schemaName == "" && systemName == "" && tablename == "") {
               for(TCoreSubsetTable tCoreSubsetTable : this.tCoreSubsetTableDao.queryAll(new Criterion[]{Restrictions.eq("subsetid", subtid)})) {
                  SubsetInfoVo subsetInfoVo = new SubsetInfoVo();
                  String stablename = tCoreSubsetTable.getTablename();
                  String tableid = tCoreSubsetTable.getId();
                  String sschemaName = tCoreSubsetTable.getSchemaName();
                  String systemID = tCoreSubsetTable.getSystemID();
                  TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(systemID);
                  String sysname = tCoreDatasystem.getSysname();
                  subsetInfoVo.setTabletid(tableid);
                  subsetInfoVo.setSubtid(subtid);
                  subsetInfoVo.setSystemID(systemID);
                  subsetInfoVo.setSystemName(sysname);
                  subsetInfoVo.setSchemaName(sschemaName);
                  subsetInfoVo.setSubname(ssubname);
                  subsetInfoVo.setTablename(stablename);
                  SubsetInfoVoList.add(subsetInfoVo);
               }
            }
         }
      }

      return SubsetInfoVoList;
   }
}
