package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreCategoryLevelLogDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreCategoryLevelLog;
import com.chenyang.nse.bussiness.service.core.ITcoreCatacoryLevelLogService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TcoreCatagoryLevelLogServiceImpl implements ITcoreCatacoryLevelLogService {
   @Autowired
   private TCoreCategoryLevelLogDao tCoreCategoryLevelLogDao;

   public void save(String projectid, String editionid, String datasystemid, String schemaname, String tablename, String columnname, String categoryid, String levelid, String operationtype, String bindtype, String createuser, String updateuser, Date createtime, Date updatetime) {
      TCoreCategoryLevelLog tCoreCategoryLevelLog = new TCoreCategoryLevelLog();
      tCoreCategoryLevelLog.setProjectid(projectid);
      tCoreCategoryLevelLog.setEditionid(editionid);
      tCoreCategoryLevelLog.setDatasystemid(datasystemid);
      tCoreCategoryLevelLog.setSchemaname(schemaname);
      tCoreCategoryLevelLog.setTablename(tablename);
      tCoreCategoryLevelLog.setColumnname(columnname);
      tCoreCategoryLevelLog.setCategoryid(categoryid);
      tCoreCategoryLevelLog.setLevelid(levelid);
      tCoreCategoryLevelLog.setOperationtype(operationtype);
      tCoreCategoryLevelLog.setBindtype(bindtype);
      tCoreCategoryLevelLog.setCreatetime(createtime);
      tCoreCategoryLevelLog.setUpdatetime(updatetime);
      tCoreCategoryLevelLog.setCreateuser(createuser);
      tCoreCategoryLevelLog.setUpdateuser(updateuser);
      this.tCoreCategoryLevelLogDao.save(tCoreCategoryLevelLog);
   }

   public void update(String id, String operationtype, String updateuser, Date updatetime) {
      TCoreCategoryLevelLog tCoreCategoryLevelLog = (TCoreCategoryLevelLog)this.tCoreCategoryLevelLogDao.get(id);
      tCoreCategoryLevelLog.setOperationtype(operationtype);
      tCoreCategoryLevelLog.setUpdateuser(updateuser);
      tCoreCategoryLevelLog.setUpdatetime(updatetime);
      this.tCoreCategoryLevelLogDao.update(tCoreCategoryLevelLog);
   }

   public List<TCoreCategoryLevelLog> queryAll(Map<String, Object> params) {
      PageInfo pageInfo = new PageInfo();
      List<Criterion> criterion = new ArrayList();
      if (params != null) {
         if (params.get("pageno") != null && params.get("pagesize") != null) {
            Integer page = (Integer)params.get("pageno");
            Integer rows = (Integer)params.get("pagesize");
            pageInfo.setPageno(page);
            pageInfo.setPagesize(rows);
         } else {
            pageInfo.setPageno(1);
            pageInfo.setPagesize(10);
         }
      } else {
         pageInfo.setPageno(1);
         pageInfo.setPagesize(10);
      }

      if (params != null && params.containsKey("username")) {
         criterion.add(Restrictions.eq("username", String.valueOf(params.get("username"))));
      }

      if (params != null && params.containsKey("bindtype")) {
         criterion.add(Restrictions.eq("bindtype", String.valueOf(params.get("bindtype"))));
      }

      if (params != null && params.containsKey("begintime")) {
         criterion.add(Restrictions.ge("createtime", String.valueOf(params.get("begintime"))));
      }

      if (params != null && params.containsKey("endtime")) {
         criterion.add(Restrictions.le("createtime", String.valueOf(params.get("endtime"))));
      }

      Criterion[] criteria = new Criterion[criterion.size()];
      criterion.toArray(criteria);
      List<TCoreCategoryLevelLog> categoryLevelLogList = this.tCoreCategoryLevelLogDao.queryByPageInfo(pageInfo, Order.desc("createtime"), criteria);
      return categoryLevelLogList;
   }
}
