package com.chenyang.nse.bussiness.service.core.impl.encryption;

import com.alibaba.druid.stat.TableStat;
import com.chenyang.nse.bussiness.bean.Column;
import com.chenyang.nse.bussiness.bean.DataBase;
import com.chenyang.nse.bussiness.bean.DataCache;
import com.chenyang.nse.bussiness.bean.Schema;
import com.chenyang.nse.bussiness.bean.Table;
import com.chenyang.nse.bussiness.ccoresdf.CcoreSDFUtil;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.core.TCoreFirstPageDataDao;
import com.chenyang.nse.bussiness.dao.core.key.TCoreKeyTypeManagementDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseButtonDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDataProjectDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreProjectDatasourceDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreSecretkeyDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.ColumnPrimaryKeyInfoDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.EncryptionConfigDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionTypeFieldDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreJiaMiJieMiJinDuDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreKafkaTopicSecretDao;
import com.chenyang.nse.bussiness.encryptor.service.impl.TCoreEncryptionServiceSdkImpl;
import com.chenyang.nse.bussiness.entity.db.ColumnInfo;
import com.chenyang.nse.bussiness.entity.db.IndexInfo;
import com.chenyang.nse.bussiness.entity.db.PrimaryKeyInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasourceSchema;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreSecretkey;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.ColumnPrimaryKeyInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryption;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryptionTypeField;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreJiaMiJieMiJinDu;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreKafkaTopicSecret;
import com.chenyang.nse.bussiness.entity.vo.DBTableVO;
import com.chenyang.nse.bussiness.entity.vo.RowSensitiveLevelReqVO;
import com.chenyang.nse.bussiness.entity.vo.TreeVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.DatasystemProjectdatasourceVO;
import com.chenyang.nse.bussiness.entity.vo.encyption.EncryptionConfigVO;
import com.chenyang.nse.bussiness.entity.vo.excel.ExcelEncryptionVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.kms.service.KmsService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.encryption.EncryptionConfigService;
import com.chenyang.nse.bussiness.service.core.strategy.MaksingAppDataRuleService;
import com.chenyang.nse.bussiness.thkms.service.ThKmsService;
import com.chenyang.nse.bussiness.tools.dataprocess.ApplicationContextProvider;
import com.chenyang.nse.bussiness.tools.es.EsUtil;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.jdbc.MongodbTool;
import com.chenyang.nse.bussiness.tools.jdbc.QueryBloodTool;
import com.chenyang.nse.bussiness.tools.sql.SqlParseUtil;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import com.mongodb.MongoClient;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.codec.Hex;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Service
public class EncryptionConfigServiceImpl implements EncryptionConfigService {
   @Autowired
   EncryptionConfigDao encryptionConfigDao;
   @Autowired
   TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   TCoreEncryptionTypeFieldDao tCoreEncryptionTypeFieldDao;
   @Autowired
   TCoreEncryptionDao tCoreEncryptionDao;
   @Autowired
   TCoreSecretkeyDao tCoreSecretkeyDao;
   @Autowired
   DataSystemService dataSystemService;
   @Autowired
   TCoreDataProjectDao tCoreDataProjectDao;
   @Autowired
   MaksingAppDataRuleService maksingAppDataRuleService;
   @Autowired
   ColumnPrimaryKeyInfoDao columnPrimaryKeyInfoDao;
   @Autowired(
      required = false
   )
   TCoreEncryptionServiceSdkImpl tCoreEncryptionServiceSdkImpl;
   @Autowired
   TBaseButtonDao tBaseButtonDao;
   @Autowired
   TCoreFirstPageDataDao tCoreFirstPageDataDao;
   @Autowired
   TCoreProjectDatasourceDao tCoreProjectDatasourceDao;
   @Autowired
   TCoreJiaMiJieMiJinDuDao tCoreJiaMiJieMiJinDuDao;
   @Autowired
   TCoreKafkaTopicSecretDao tCoreKafkaTopicSecretDao;
   @Autowired
   ThKmsService thKmsService;
   @Autowired
   KmsService kmsService;
   @Autowired
   TCoreKeyTypeManagementDao tCoreKeyTypeManagementDao;
   Connection connQueryOriginalList = null;
   Connection connGetAllColumnsByMap = null;
   TCoreDatasystem dataSystemTmp = null;
   String dataSourceTmp;
   private Properties properties = null;
   private String node = null;

   public EncryptionConfigVO decrypt(EncryptionConfigVO vo) throws Exception {
      EncryptionConfigVO retVO = new EncryptionConfigVO();
      String datasystem_id = vo.getDatasystem_id();
      String table_name = "";
      String schema = "";
      String sql = vo.getSql();
      retVO.setDatasystem_id(datasystem_id);
      retVO.setSchema(schema);
      retVO.setSql(sql);
      String primary = "";
      TCoreDatasystem datasystem = this.queryDataSystem(datasystem_id);
      String dbType = datasystem.getDbtype();
      Connection conn = JdbcTool.getConnection(datasystem);
      Collection<TableStat.Column> tablefieldList = SqlParseUtil.execute(dbType, sql);
      table_name = ((TableStat.Column)tablefieldList.iterator().next()).getTable();
      String schema1 = ((TableStat.Column)tablefieldList.iterator().next()).getTable();
      if (schema1.contains(".")) {
         String[] arr = schema1.split("\\.");
         schema = arr[0];
         retVO.setSchema(schema);
      } else {
         if (StringUtils.isEmpty(vo.getSchema())) {
            retVO.setErrMsg("没有schema");
            retVO.setSchema("");
            return retVO;
         }

         retVO.setSchema(vo.getSchema());
         schema = vo.getSchema();
      }

      if (table_name.contains(".")) {
         String[] arr = table_name.split("\\.");
         table_name = arr[1];
         retVO.setTable_name(table_name);
         vo.setTable_name(table_name);
      } else {
         sql = sql.replace(table_name, schema + "." + table_name);
         retVO.setTable_name(table_name);
         vo.setTable_name(table_name);
      }

      Set<String> fieldList = new HashSet();
      List<IndexInfo> indexInfo = null;
      if (!dbType.equals(EdbType.HIVE.getDbname())) {
         indexInfo = IndexInfo.getIndexInfoByConnection(conn, schema, table_name);
      }

      List<String> primarykey = null;
      List<String> var31 = PrimaryKeyInfo.getPrimaryKeyList(conn, schema.toUpperCase(), table_name.toUpperCase());
      if (ObjectUtils.isEmpty(var31) && !ObjectUtils.isEmpty(indexInfo)) {
         List<String> indexList = new ArrayList();
         indexInfo.forEach((index) -> indexList.add(index.getColumnname()));
         var31 = indexList;
         fieldList.addAll(indexList);
      }

      tablefieldList.stream().forEach((tablefield) -> {
         System.out.printf("%s", tablefield.getName());
         System.out.println("");
         fieldList.add(tablefield.getName());
      });
      List<ColumnInfo> allColumns;
      if ("GAUSS".equals(dbType)) {
         allColumns = JdbcTool.getAllColumnInfo(conn, schema.toUpperCase(), table_name);
      } else {
         allColumns = JdbcTool.getAllColumnInfo(conn, schema.toUpperCase(), table_name.toUpperCase());
      }

      if (dbType.equals("GREENPLUM")) {
         List<ColumnInfoVO> list = JdbcTool.getColumnInfoVO(conn, schema, table_name);
         allColumns = (List)list.stream().map((e) -> new ColumnInfo(e.getTablecat(), e.getTableschem(), e.getTablename(), e.getColumnname(), e.getDatatype(), e.getTypename(), e.getColumnsize(), e.getBufferlength(), e.getDecimaldigits(), e.getNumprecpadix(), e.getNullable(), e.getRemarks(), e.getColumndef(), e.getSqldatatype(), e.getSqldatetimesub(), e.getCharoctetlength(), e.getOrdinalposition(), e.getIsnullable(), e.getScopecatlog(), e.getScopeschema(), e.getScopetable(), e.getSourcedatatype(), e.getIsautoincrement())).collect(Collectors.toList());
      }

      List<ColumnInfo> filterColumnList = null;
      filterColumnList = this.getColumnInfos(fieldList, allColumns, filterColumnList);
      if (dbType.equals(EdbType.HIVE.getDbname())) {
         filterColumnList.stream().forEach((e) -> e.setColumnnamehive("mm." + e.getColumnname()));
      }

      retVO.setHead(fieldList);
      List<Map<String, Object>> rows = new ArrayList();
      if (!sql.contains("limit")) {
         if (datasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
            if (ObjectUtils.isEmpty(var31)) {
               sql = "SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (" + sql + " ) TT ) where RN> 0 AND RN <= 100 ";
            } else {
               sql = "SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (" + sql + " order by " + StringUtils.join((Collection)var31, ",") + " desc ) TT ) where RN> 0 AND RN <= 100 ";
            }
         } else if (datasystem.getDbtype().equals(EdbType.MYSQL.toString())) {
            if (ObjectUtils.isEmpty(var31)) {
               sql = "SELECT * FROM (" + sql + ") as table_temp_1_1_1_1 limit 0,100";
            } else {
               sql = "SELECT * FROM (" + sql + ") as table_temp_1_1_1_1 order by " + StringUtils.join((Collection)var31, ",") + " desc limit 0,100";
            }
         } else if (datasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
            if (ObjectUtils.isEmpty(var31)) {
               sql = " select * FROM (  select *, ROW_NUMBER() OVER(Order by " + (String)fieldList.iterator().next() + " desc ) AS RowId FROM (" + sql + ") as a ) as b where RowId between 0 and 100";
            } else {
               sql = " select * FROM (  select *, ROW_NUMBER() OVER(Order by " + StringUtils.join((Collection)var31, ",") + " desc ) AS RowId FROM (" + sql + ") as a ) as b where RowId between 0 and 100";
            }
         } else if (datasystem.getDbtype().equals("GREENPLUM")) {
            if (ObjectUtils.isEmpty(var31)) {
               sql = sql + " limit 0 OFFSET 100";
            } else {
               sql = sql + " order by " + StringUtils.join((Collection)var31, ",") + " desc limit 0 OFFSET 100";
            }
         } else if (datasystem.getDbtype().equals("HIVE")) {
            if (ObjectUtils.isEmpty(var31)) {
               sql = " select * from (select row_number() over (order by " + (String)fieldList.iterator().next() + "  desc) as rownum, " + sql.replaceFirst("select", "") + ") mm where mm.rownum between 0 and 100";
            } else {
               sql = " select * from (select row_number() over (order by " + StringUtils.join((Collection)var31, ",") + "  desc) as rownum, " + sql.replaceFirst("select", "") + ") mm where mm.rownum between 0 and 100";
            }
         } else if (datasystem.getDbtype().equals("POSTGRESQL")) {
            if (ObjectUtils.isEmpty(var31)) {
               sql = sql + " offset 0 limit 100";
            } else {
               sql = sql + " order by " + StringUtils.join((Collection)var31, ",") + " desc offset 0 limit 100";
            }
         } else if (datasystem.getDbtype().equals(EdbType.GBASE8S.toString())) {
            if (ObjectUtils.isEmpty(var31)) {
               sql = "SELECT * FROM (" + sql + ") as table_temp_1_1_1_1 limit 0,100";
            } else {
               sql = "SELECT * FROM (" + sql + ") as table_temp_1_1_1_1 order by " + StringUtils.join((Collection)var31, ",") + " desc limit 0,100";
            }
         } else if (datasystem.getDbtype().equals(EdbType.DM.toString())) {
            sql = "SELECT * FROM (" + sql + ") as table_temp_1_1_1_1 limit 0,100";
         } else {
            sql = sql + " limit 0,100";
         }
      }

      PreparedStatement statement = conn.prepareStatement(sql);
      ResultSet resultSet = statement.executeQuery();
      ResultSetMetaData metaData = resultSet.getMetaData();
      int columnnumber = metaData.getColumnCount();
      List<ColumnInfo> columnInfoList = new ArrayList();

      for(int ii = 0; ii < columnnumber; ++ii) {
         if (!"rn".equals(metaData.getColumnLabel(ii + 1).toLowerCase(Locale.ROOT)) || !dbType.equals("ORACLE")) {
            ColumnInfo columnInfo = new ColumnInfo();
            columnInfo.setColumnname(metaData.getColumnLabel(ii + 1).toLowerCase(Locale.ROOT));
            columnInfoList.add(columnInfo);
         }
      }

      while(resultSet.next()) {
         Map<String, Object> row = new HashMap();

         for(int j = 0; j < columnnumber; ++j) {
            String cname = metaData.getColumnLabel(j + 1);
            if (!"rn".equals(cname) || !dbType.equals("ORACLE")) {
               row.put(cname.toLowerCase(Locale.ROOT), resultSet.getString(cname));
            }
         }

         rows.add(row);
      }

      resultSet.close();
      statement.close();
      retVO.setData(rows);
      retVO.setFilterColumnList(columnInfoList);
      HashSet hs = new HashSet();
      columnInfoList.stream().forEach((c) -> hs.add(c.getColumnname()));
      retVO.setHead(hs);
      return retVO;
   }

   private TCoreDatasystem queryDataSystem(String datasystemid) {
      List<TCoreDatasystem> list = this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.eq("id", datasystemid)});
      return list != null && list.size() > 0 ? (TCoreDatasystem)list.get(0) : null;
   }

   private List<ColumnInfo> getColumnInfos(Set<String> fieldList, List<ColumnInfo> allColumns, List<ColumnInfo> filterColumnList) {
      if (fieldList.size() > 0) {
         if (fieldList.contains("*")) {
            fieldList.clear();
            allColumns.forEach((column) -> fieldList.add(column.getColumnname()));
         }

         filterColumnList = (List)allColumns.stream().filter((s) -> fieldList.stream().anyMatch((x) -> s.getColumnname().equalsIgnoreCase(x))).collect(Collectors.toList());
      }

      System.out.println(filterColumnList.size());
      return filterColumnList;
   }

   public void saveColumnType(List<String> parameter, List<String> dataEncryptionTypeTidList) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
      int count_tCoreFieldEncryptionType = 0;
      String typename = null;
      String columnsize = null;
      String datasystemid = (String)parameter.get(0);
      String field = (String)parameter.get(1);
      String table = (String)parameter.get(2);
      String schema = (String)parameter.get(3);
      String describe_info = (String)parameter.get(4);
      String flag = (String)parameter.get(5);
      String projectId = (String)parameter.get(6);
      String username = (String)parameter.get(7);
      String dataareaid = (String)parameter.get(8);
      String dataareaname = (String)parameter.get(9);
      String columnType = (String)parameter.get(10);
      String columnSize = (String)parameter.get(11);
      String note = null;
      if (parameter.size() >= 13) {
         note = (String)parameter.get(12);
      }

      String isLike = null;
      if (parameter.size() >= 14) {
         isLike = (String)parameter.get(13);
      }

      String keepfirst = null;
      if (parameter.size() >= 15) {
         keepfirst = (String)parameter.get(14);
      }

      String encdigit = null;
      if (parameter.size() >= 16) {
         encdigit = (String)parameter.get(15);
      }

      String realitycolumnsize = (String)parameter.get(16);
      String twoindex = (String)parameter.get(17);
      String originalColumnSize = "";
      TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", datasystemid)});
      if (!"MONGODB".equals(datasystem.getDbtype()) && !"ES".equals(datasystem.getDbtype()) && !"KAFKA".equals(datasystem.getDbtype())) {
         Connection co = JdbcTool.getConnection(datasystem);
         ResultSet resultSet = JdbcTool.getColumns(co, schema, table);

         try {
            while(resultSet.next()) {
               if (field.equals(resultSet.getString("COLUMN_NAME"))) {
                  if (!HibernateConfig.PEIZHIKUDBTYPE.equals("1") && !HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
                     if (HibernateConfig.PEIZHIKUDBTYPE.equals("0")) {
                        originalColumnSize = resultSet.getString("COLUMN_SIZE");
                     }
                  } else if (resultSet.getString("COLUMN_SIZE").equals("2147483647")) {
                     originalColumnSize = "255";
                  } else {
                     originalColumnSize = resultSet.getString("COLUMN_SIZE");
                  }
                  break;
               }
            }
         } catch (Exception e) {
            e.printStackTrace();
         } finally {
            if (co != null) {
               try {
                  co.close();
               } catch (SQLException e) {
                  e.printStackTrace();
               }
            }

            if (resultSet != null) {
               try {
                  resultSet.close();
               } catch (SQLException e) {
                  e.printStackTrace();
               }
            }

         }
      }

      StringBuilder sb_TCoreEncryptionTypeField = new StringBuilder();
      List<String> list_table_TCoreEncryptionTypeField = JdbcTool.sql_insert_q(new TCoreEncryptionTypeField());
      list_table_TCoreEncryptionTypeField.add("id");
      String sb_sql_table_TCoreEncryptionTypeField = JdbcTool.sql_insert_z(list_table_TCoreEncryptionTypeField, "T_CORE_ENCRYPTION_FIELD");
      sb_TCoreEncryptionTypeField.append(sb_sql_table_TCoreEncryptionTypeField);
      TCoreEncryptionTypeField tCoreEncryptionTypeField = (TCoreEncryptionTypeField)this.tCoreEncryptionTypeFieldDao.queryUnique(new Criterion[]{Restrictions.eq("datasystem_id", datasystemid), Restrictions.eq("tschemas", schema), Restrictions.eq("names", table), Restrictions.eq("table_field_id", field)});
      String originalrealitylength = "";
      if (null != tCoreEncryptionTypeField) {
         originalrealitylength = tCoreEncryptionTypeField.getRealitycolumnsize();
      }

      this.tCoreEncryptionTypeFieldDao.remove(new Criterion[]{Restrictions.eq("datasystem_id", datasystemid), Restrictions.eq("tschemas", schema), Restrictions.eq("names", table), Restrictions.eq("table_field_id", field)});
      TCoreEncryptionTypeField tcfs = new TCoreEncryptionTypeField();
      if (dataEncryptionTypeTidList != null) {
         for(String t : dataEncryptionTypeTidList) {
            ++count_tCoreFieldEncryptionType;
            tcfs.setId(UUID.randomUUID().toString().replace("-", ""));
            tcfs.setDatasystem_id(datasystemid);
            tcfs.setTschemas(schema);
            tcfs.setTable_field_id(field);
            tcfs.setNames(table);
            tcfs.setEncryption_secretkey_id(t);
            TCoreSecretkey secretKey = (TCoreSecretkey)this.tCoreSecretkeyDao.get(t);
            if (secretKey != null) {
               tcfs.setSecretkeyname(secretKey.getSecret_key_name());
               TCoreEncryption tCoreEncryption = (TCoreEncryption)this.tCoreEncryptionDao.get(secretKey.getEncryption_id());
               if (tCoreEncryption != null) {
                  tcfs.setEncryptiontypename(tCoreEncryption.getEncryption_name());
               }
            }

            if (StringUtils.isBlank(t)) {
               tcfs.setState("1");
            } else {
               tcfs.setState("0");
            }

            TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(datasystemid);
            if (tCoreDatasystem != null) {
               tcfs.setDatasystemname(tCoreDatasystem.getSysname());
            }

            tcfs.setDatasystemname(tCoreDatasystem.getSysname());
            tcfs.setCombination_id(table + "." + field);
            tcfs.setProjectid(projectId);
            tcfs.setCreatetime(new Date());
            tcfs.setUpdatetime(new Date());
            tcfs.setCreateuser(username);
            tcfs.setUpdateuser(username);
            tcfs.setDescribe_info(describe_info);
            if (datasystem.getDbtype().equals("KAFKA")) {
               flag = "5";
            }

            tcfs.setFlag(flag);
            tcfs.setDataareaid(dataareaid);
            tcfs.setDataareaname(dataareaname);
            tcfs.setColumn_type(columnType);
            if (!StringUtils.isBlank(columnSize) && !"0".equals(columnSize)) {
               tcfs.setColumn_size(columnSize);
            } else {
               tcfs.setColumn_size(originalColumnSize);
            }

            tcfs.setNote(note);
            tcfs.setIslike(isLike);
            tcfs.setKeepfirst(keepfirst);
            tcfs.setEncdigit(encdigit);
            tcfs.setRealitycolumnsize(realitycolumnsize);
            tcfs.setTwoindex(twoindex);
            sb_TCoreEncryptionTypeField.append(JdbcTool.sql_insert_h(tcfs, list_table_TCoreEncryptionTypeField));
         }
      }

      if (count_tCoreFieldEncryptionType != 0) {
         if (!HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
            this.tCoreEncryptionTypeFieldDao.saveTCoreEncryptionTypeField(sb_TCoreEncryptionTypeField.deleteCharAt(sb_TCoreEncryptionTypeField.length() - 1));
         } else {
            this.tCoreEncryptionTypeFieldDao.save(tcfs);
         }
      }

   }

   public void saveKafka(List<String> parameter) {
      int count_tCoreFieldEncryptionType = 0;
      String typename = null;
      String columnsize = null;
      String topic = (String)parameter.get(0);
      String fileid = (String)parameter.get(1);
      String projectid = (String)parameter.get(2);
      String dataSystemid = (String)parameter.get(3);
      String username = (String)parameter.get(4);
      String encryptionSecretKeyId = (String)parameter.get(5);
      StringBuilder sb_TCoreEncryptionTypeField = new StringBuilder();
      List<String> list_table_TCoreEncryptionTypeField = JdbcTool.sql_insert_q(new TCoreEncryptionTypeField());
      list_table_TCoreEncryptionTypeField.add("id");
      String sb_sql_table_TCoreEncryptionTypeField = JdbcTool.sql_insert_z(list_table_TCoreEncryptionTypeField, "T_CORE_ENCRYPTION_FIELD");
      sb_TCoreEncryptionTypeField.append(sb_sql_table_TCoreEncryptionTypeField);
      ++count_tCoreFieldEncryptionType;
      TCoreSecretkey secretKey = (TCoreSecretkey)this.tCoreSecretkeyDao.get(encryptionSecretKeyId);
      TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(dataSystemid);
      TCoreKafkaTopicSecret tCoreKafkaTopicSecret = new TCoreKafkaTopicSecret();
      tCoreKafkaTopicSecret.setId(UUID.randomUUID().toString());
      tCoreKafkaTopicSecret.setFilestructureid(fileid);
      tCoreKafkaTopicSecret.setDbtopic(topic);
      tCoreKafkaTopicSecret.setEncryptiontypename(secretKey.getEncryptionname());
      tCoreKafkaTopicSecret.setSecretkeyname(secretKey.getSecret_key_name());
      tCoreKafkaTopicSecret.setEncryption_secretkey_id(secretKey.getId());
      tCoreKafkaTopicSecret.setSecretkeyvalue(secretKey.getSectet_key_value());
      tCoreKafkaTopicSecret.setDatasystemid(dataSystemid);
      tCoreKafkaTopicSecret.setDbip(tCoreDatasystem.getDbip());
      tCoreKafkaTopicSecret.setDbport(tCoreDatasystem.getDbip());
      tCoreKafkaTopicSecret.setProjectid(projectid);
      tCoreKafkaTopicSecret.setCreatetime(new Date());
      tCoreKafkaTopicSecret.setUpdatetime(new Date());
      tCoreKafkaTopicSecret.setCreateuser(username);
      tCoreKafkaTopicSecret.setUpdateuser(username);
      if (count_tCoreFieldEncryptionType != 0) {
         this.tCoreKafkaTopicSecretDao.save(tCoreKafkaTopicSecret);
      }

   }

   @Transactional
   public List<ColumnInfoVO> queryOriginalList(EncryptionConfigVO vo) {
      String datasystem_id = vo.getDatasystem_id();
      String table_name = vo.getTable_name();
      String schema = vo.getSchema();
      String projectId = vo.getProjectId();
      TCoreDatasystem datasystem = this.queryDataSystem(datasystem_id);

      assert datasystem != null;

      List<ColumnInfoVO> allColumns = this.maksingAppDataRuleService.queryColumnInfo(datasystem_id, schema, table_name);
      ColumnPrimaryKeyInfo columnPrimaryKeyInfo = (ColumnPrimaryKeyInfo)this.columnPrimaryKeyInfoDao.queryUnique(new Criterion[]{Restrictions.eq("project_id", projectId), Restrictions.eq("datasystem_id", datasystem_id), Restrictions.eq("tschema", schema), Restrictions.eq("tname", table_name)});
      String dbtype = datasystem.getDbtype();
      if (columnPrimaryKeyInfo != null) {
         String primary_key_columns = columnPrimaryKeyInfo.getPrimary_key_columns();
         String[] fileds = primary_key_columns.split(",");

         for(ColumnInfoVO allColumn : allColumns) {
            for(String filed : fileds) {
               if (allColumn.getColumnname().equals(filed)) {
                  if (allColumn.getPrimarykey().equals("0") && !dbtype.equals("ORACLE")) {
                     allColumn.setIsManual("1");
                  }

                  allColumn.setPrimarykey("1");
               }
            }
         }
      }

      int allColumnsSize = allColumns.size();
      if (allColumnsSize > 0) {
         for(int i = 0; i < allColumnsSize; ++i) {
            if (null != ((ColumnInfoVO)allColumns.get(i)).getTableschem() && !"".equals(((ColumnInfoVO)allColumns.get(i)).getTableschem())) {
               ((ColumnInfoVO)allColumns.get(i)).setTablecat(((ColumnInfoVO)allColumns.get(i)).getTableschem());
            }
         }
      }

      String sql = null;
      if (dbtype.equals("MYSQL") || dbtype.equals("OCEANBASE") || dbtype.equals("MARIADB")) {
         sql = "select * from information_schema.columns where table_schema='" + schema + "' and table_name='" + table_name + "'";
      }

      if (dbtype.equals("ORACLE")) {
         sql = "select * from all_tab_columns where table_name = '" + table_name + "'";
      }

      if (dbtype.equals("KINGBASE")) {
         sql = "select data_type, is_nullable, column_name from information_schema.columns where table_schema='" + schema + "' and table_name='" + table_name + "'";
      }

      if (dbtype.equals("POSTGRESQL")) {
         sql = "select data_type, is_nullable, column_name from information_schema.columns where table_schema='" + schema + "' and table_name='" + table_name + "'";
      }

      if (dbtype.equals("GREENPLUM")) {
         sql = "select data_type, is_nullable, column_name from information_schema.columns where table_schema='" + schema + "' and table_name='" + table_name + "'";
      }

      if (dbtype.equals("DB2")) {
         sql = "select typename, nulls, colname from syscat.columns where tabschema='" + schema + "' and tabname='" + table_name + "'";
      }

      if (dbtype.equals("HIVE")) {
         sql = "DESC extended " + schema + "." + table_name;
      }

      try {
         if (sql != null) {
            if (Objects.isNull(this.dataSystemTmp) || !Objects.equals(this.dataSystemTmp, datasystem)) {
               this.dataSystemTmp = datasystem;
               if (Objects.nonNull(this.connQueryOriginalList)) {
                  this.connQueryOriginalList.close();
               }

               this.connQueryOriginalList = JdbcTool.getConnection(this.dataSystemTmp);
            }

            PreparedStatement pstmt = this.connQueryOriginalList.prepareStatement(sql);
            ResultSet rs = pstmt.executeQuery();
            if (dbtype.equals("MYSQL") || dbtype.equals("OCEANBASE") || dbtype.equals("MARIADB")) {
               while(rs.next()) {
                  if ("char".equals(rs.getString("DATA_TYPE")) || "varchar".equals(rs.getString("DATA_TYPE"))) {
                     String canbenull = rs.getString("IS_NULLABLE");
                     String cname = rs.getString("COLUMN_NAME");
                     if ("NO".equals(canbenull)) {
                        for(ColumnInfoVO c : allColumns) {
                           if (cname.equals(c.getColumnname())) {
                              c.setIscheckbox("1");
                           }
                        }
                     }
                  }
               }
            }

            if (dbtype.equals("ORACLE")) {
               int flag = 1;

               for(ColumnInfoVO allColumn : allColumns) {
                  if ("1".equals(allColumn.getPrimarykey())) {
                     flag = 0;
                  }
               }

               if (flag == 1) {
                  List<String> uniqueColumnList = new ArrayList();
                  String sql1 = "SELECT  * FROM dba_indexes WHERE TABLE_NAME = '" + table_name + "' AND uniqueness = 'UNIQUE'";
                  PreparedStatement sql1p = this.connQueryOriginalList.prepareStatement(sql1);
                  ResultSet rs1 = sql1p.executeQuery();
                  if (rs1.next()) {
                     String sql2 = "SELECT INDEX_NAME, COLUMN_NAME, COLUMN_POSITION\nFROM ALL_IND_COLUMNS\nWHERE TABLE_NAME = '" + table_name + "' AND INDEX_NAME = '" + rs1.getString("INDEX_NAME") + "'";
                     PreparedStatement sql2p = this.connQueryOriginalList.prepareStatement(sql2);
                     ResultSet rs2 = sql2p.executeQuery();

                     while(rs2.next()) {
                        uniqueColumnList.add(rs2.getString("COLUMN_NAME"));
                     }
                  }

                  String indexes = "";

                  for(String uniqueColumn : uniqueColumnList) {
                     indexes = indexes + "," + uniqueColumn;

                     for(ColumnInfoVO columnInfoVO : allColumns) {
                        if (uniqueColumn.equals(columnInfoVO.getColumnname())) {
                           columnInfoVO.setPrimarykey("1");
                           break;
                        }
                     }
                  }
               }
            }

            if (dbtype.equals("KINGBASE")) {
               while(rs.next()) {
                  if ("character varying".equals(rs.getString(1))) {
                     String canbenull = rs.getString(2);
                     String cname = rs.getString(3);
                     if ("NO".equals(canbenull)) {
                        for(ColumnInfoVO c : allColumns) {
                           if (cname.equals(c.getColumnname())) {
                              c.setIscheckbox("1");
                           }
                        }
                     }
                  }
               }
            }

            if (dbtype.equals("GREENPLUM")) {
               while(rs.next()) {
                  if ("\"char\"".equals(rs.getString("DATA_TYPE")) || "character varying".equals(rs.getString("DATA_TYPE"))) {
                     String canbenull = rs.getString("IS_NULLABLE");
                     String cname = rs.getString("COLUMN_NAME");
                     if ("NO".equals(canbenull)) {
                        for(ColumnInfoVO c : allColumns) {
                           if (cname.equals(c.getColumnname())) {
                              c.setIscheckbox("1");
                           }
                        }
                     }
                  }
               }
            }

            if (dbtype.equals("POSTGRESQL")) {
               while(rs.next()) {
                  if ("\"char\"".equals(rs.getString("DATA_TYPE")) || "character varying".equals(rs.getString("DATA_TYPE"))) {
                     String canbenull = rs.getString("IS_NULLABLE");
                     String cname = rs.getString("COLUMN_NAME");
                     if ("NO".equals(canbenull)) {
                        for(ColumnInfoVO c : allColumns) {
                           if (cname.equals(c.getColumnname())) {
                              c.setIscheckbox("1");
                           }
                        }
                     }
                  }
               }
            }

            if (dbtype.equals("DB2")) {
               while(rs.next()) {
                  if ("CHAR".equals(rs.getString("TYPENAME")) || "VARCHAR".equals(rs.getString("TYPENAME"))) {
                     String canbenull = rs.getString("NULLS");
                     String cname = rs.getString("COLNAME");
                     if ("N".equals(canbenull)) {
                        for(ColumnInfoVO c : allColumns) {
                           if (cname.equals(c.getColumnname())) {
                              c.setIscheckbox("1");
                           }
                        }
                     }
                  }
               }
            }

            if (dbtype.equalsIgnoreCase("HIVE") && allColumns != null) {
               int version = Integer.parseInt(datasystem.getVersion().substring(0, 1));
               if (version < 3) {
                  for(ColumnInfoVO allColumn : allColumns) {
                     allColumn.setIscheckbox("1");
                  }
               } else {
                  while(rs.next()) {
                     String category = rs.getString("col_name");
                     if (org.apache.commons.lang3.StringUtils.isNotBlank(category) && category.contains("Constraints")) {
                        String bucketColumn = rs.getString("data_type");
                        List<String> ukList = new ArrayList();
                        if (null != bucketColumn && !"".equals(bucketColumn)) {
                           ukList = this.getUnique(bucketColumn);
                        }

                        if (ukList.size() > 0) {
                           for(ColumnInfoVO allColumn : allColumns) {
                              if (ukList.contains(allColumn.getColumnname())) {
                                 allColumn.setIscheckbox("1");
                              }
                           }
                        }
                     }
                  }
               }
            }

            rs.close();
            pstmt.close();
         }

         if (dbtype.equals("HIVE_TDH")) {
            for(ColumnInfoVO c : allColumns) {
               if (c.getTypename().contains("CHAR") || c.getTypename().equals("STRING") || c.getTypename().equals("INT")) {
                  c.setIscheckbox("1");
               }
            }
         }

         if (allColumns.stream().filter((cx) -> "1".equals(cx.getIscheckbox())).count() == 0L) {
            allColumns.forEach((cx) -> {
               if (cx.getTypename().equalsIgnoreCase("int") || cx.getTypename().equalsIgnoreCase("char") || cx.getTypename().equalsIgnoreCase("\"char\"") || cx.getTypename().equalsIgnoreCase("varchar") || cx.getTypename().equalsIgnoreCase("varchar2") || cx.getTypename().equalsIgnoreCase("nvarchar2") || cx.getTypename().equalsIgnoreCase("string") || cx.getTypename().equalsIgnoreCase("serial") || cx.getTypename().equalsIgnoreCase("bigserial") || cx.getTypename().equalsIgnoreCase("number") || cx.getTypename().equalsIgnoreCase("character varying")) {
                  cx.setIscheckbox("1");
               }

            });
         }

         if (dbtype.equals("HIVE_TDH")) {
            allColumns.sort(Comparator.comparingInt((cx) -> Integer.parseInt(cx.getOrdinalposition())));
         } else {
            allColumns.sort(Comparator.comparing(ColumnInfo::getColumnname));
         }
      } catch (SQLException e) {
         e.printStackTrace();
      }

      return allColumns;
   }

   public HashMap queryBatchOriginalList(EncryptionConfigVO vo) {
      HashMap m = this.maksingAppDataRuleService.queryBatchColumnInfo(vo);
      return m;
   }

   public List<Map<String, String>> queryEncryptionList(EncryptionConfigVO vo) {
      List<Map<String, String>> relist = new ArrayList();
      String datasystem_id = vo.getDatasystem_id();
      String table_name = vo.getTable_name();
      String schema = vo.getSchema();

      for(TCoreEncryptionTypeField tc : this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("datasystem_id", datasystem_id), Restrictions.eq("tschemas", schema), Restrictions.eq("names", table_name)})) {
         if (!ObjectUtils.isEmpty(tc.getEncryption_secretkey_id())) {
            TCoreSecretkey secretKey = (TCoreSecretkey)this.tCoreSecretkeyDao.get(tc.getEncryption_secretkey_id());
            TCoreEncryption tCoreEncryption = (TCoreEncryption)this.tCoreEncryptionDao.get(secretKey.getEncryption_id());
            if (!ObjectUtils.isEmpty(tc.getFlag())) {
               Map<String, String> hashMap = new HashMap();
               hashMap.put("flag", tc.getFlag());
               hashMap.put("isLike", tc.getIslike());
               hashMap.put("isPrimaryKey", "");
               hashMap.put("fieldName", tc.getTable_field_id());
               hashMap.put("encryptionTypeName", ObjectUtils.isEmpty(tCoreEncryption.getEncryption_name()) ? "" : tCoreEncryption.getEncryption_name());
               hashMap.put("encryptionTypeValue", ObjectUtils.isEmpty(secretKey.getSecret_key_name()) ? "" : secretKey.getSecret_key_name());
               hashMap.put("secretKey", ObjectUtils.isEmpty(secretKey.getId()) ? "" : secretKey.getId());
               hashMap.put("describe_info", tc.getDescribe_info());
               hashMap.put("encryptionIdTrue", ObjectUtils.isEmpty(secretKey.getEncryption_id()) ? "" : secretKey.getEncryption_id());
               hashMap.put("encryptionId", ObjectUtils.isEmpty(tc.getId()) ? "" : tc.getId());
               hashMap.put("columnType", ObjectUtils.isEmpty(tc.getColumn_type()) ? "" : tc.getColumn_type());
               hashMap.put("columnSize", ObjectUtils.isEmpty(tc.getColumn_size()) ? "" : tc.getColumn_size());
               hashMap.put("keepfirst", ObjectUtils.isEmpty(tc.getKeepfirst()) ? "1" : tc.getKeepfirst());
               hashMap.put("encdigit", ObjectUtils.isEmpty(tc.getEncdigit()) ? "0" : tc.getEncdigit());
               hashMap.put("dataareaid", tc.getDataareaid());
               hashMap.put("dataareaname", tc.getDataareaname());
               relist.add(hashMap);
            }
         } else {
            Map<String, String> hashMap = new HashMap();
            hashMap.put("flag", "1".equals(tc.getFlag()) ? "1" : "0");
            hashMap.put("isPrimaryKey", "");
            hashMap.put("isLike", "0");
            hashMap.put("keepfirst", "1");
            hashMap.put("encdigit", "0");
            hashMap.put("fieldName", tc.getTable_field_id());
            hashMap.put("encryptionTypeName", "");
            hashMap.put("encryptionTypeValue", "");
            hashMap.put("secretKey", "");
            hashMap.put("describe_info", tc.getDescribe_info());
            hashMap.put("dataareaid", tc.getDataareaid());
            hashMap.put("dataareaname", tc.getDataareaname());
            this.tCoreEncryptionTypeFieldDao.update(tc);
            relist.add(hashMap);
         }
      }

      return relist;
   }

   public Map<String, Object> queryDatasystemInfo(String dataSystemId, String projectId) {
      Map<String, Object> result = new HashMap();
      int totalFiledCount = 0;
      int totalTableCount = 0;
      TCoreDataProject tCoreDataProject = (TCoreDataProject)this.tCoreDataProjectDao.get(projectId);
      result.put("projectName", tCoreDataProject.getProject());
      TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", dataSystemId)});
      result.put("datasystemName", datasystem.getSysname());
      result.put("dbType", datasystem.getDbtype());
      result.put("ip", datasystem.getDbip());
      result.put("port", datasystem.getDbport());
      List<TCoreDatasourceSchema> schemas = this.dataSystemService.querySchemas(projectId, dataSystemId);
      StringBuilder bb = new StringBuilder();
      if (null != schemas) {
         for(TCoreDatasourceSchema schema : schemas) {
            if (null != schema.getSchemaname()) {
               bb.append(schema.getSchemaname());
               bb.append(",");
            }
         }
      }

      if (null != bb) {
         result.put("schema", bb.toString().substring(0, bb.toString().lastIndexOf(44)));
      } else {
         result.put("schema", "");
      }

      List<TCoreDatasourceSchema> schemaList = this.dataSystemService.querySchemas(projectId, dataSystemId);
      Connection connection = JdbcTool.getConnection(datasystem);

      for(TCoreDatasourceSchema schema : schemaList) {
         totalFiledCount = (int)((double)totalFiledCount + QueryBloodTool.getColumnNum(datasystem, connection, schema.getSchemaname(), datasystem.getDbtype()));
         totalTableCount = (int)((double)totalTableCount + QueryBloodTool.getTabelNum(datasystem, connection, schema.getSchemaname(), datasystem.getDbtype()));
      }

      result.put("totalFiledNum", totalFiledCount);
      int encryptTableCount = 0;
      Object s = this.tCoreEncryptionTypeFieldDao.queryEncryptionTableNum(projectId, dataSystemId);
      if (s != null) {
         encryptTableCount = Integer.parseInt(s.toString());
      }

      result.put("encryptTableCount", encryptTableCount);
      result.put("unencryptTableCount", totalTableCount - encryptTableCount);
      int encryptFiledCount = 0;
      Object s1 = this.tCoreEncryptionTypeFieldDao.queryEncryptionColumnNum(projectId, dataSystemId);
      if (s1 != null) {
         encryptFiledCount = Integer.parseInt(s1.toString());
      }

      result.put("encryptFiledCount", encryptFiledCount);
      result.put("unencryptFiledCount", totalFiledCount - encryptFiledCount);
      return result;
   }

   public Map<String, Object> querytableInfo(String dataSystemId, String projectId, String schema, String tableName) {
      List<ColumnInfoVO> columnInfoVOS = this.maksingAppDataRuleService.queryColumnInfo(dataSystemId, schema, tableName);
      Map<String, Object> result = new HashMap();
      result.put("totalColumnCount", columnInfoVOS.size());
      TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(dataSystemId);
      if ("MONGODB".equals(datasystem.getDbtype())) {
         result.put("totalColumnCount", MongodbTool.getTableColumnCount(datasystem, schema, tableName));
      }

      int encryptColumnCount = 0;
      Object s = this.tCoreEncryptionTypeFieldDao.queryEncryptionColumnNum(projectId, dataSystemId, schema, tableName);
      if (s != null) {
         encryptColumnCount = Integer.parseInt(s.toString());
      }

      result.put("encryptColumnCount", encryptColumnCount);
      result.put("unencryptColumnCount", columnInfoVOS.size() - encryptColumnCount);
      List<TCoreEncryptionTypeField> list = this.tCoreEncryptionTypeFieldDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("names", tableName)});
      if (list.size() > 0) {
         TCoreEncryptionTypeField tCoreEncryptionTypeField = (TCoreEncryptionTypeField)list.get(0);
         result.put("operator", tCoreEncryptionTypeField.getCreateuser());
         result.put("operationTime", tCoreEncryptionTypeField.getCreatetime());
      } else {
         result.put("operator", null);
         result.put("operationTime", null);
      }

      return result;
   }

   public List<TCoreJiaMiJieMiJinDu> queryTCoreJiaMiDulist(PageInfo pageInfo, String projectId, String tableName, String state) {
      Criterion criterion2 = Restrictions.like("tableName", tableName, MatchMode.ANYWHERE).ignoreCase();
      Criterion criterion3 = Restrictions.like("state", state, MatchMode.ANYWHERE).ignoreCase();
      List<TCoreJiaMiJieMiJinDu> list = this.tCoreJiaMiJieMiJinDuDao.queryByPageInfo(pageInfo, Order.desc("startTime"), new Criterion[]{Restrictions.eq("projectId", projectId), criterion2, criterion3});
      return list;
   }

   public void saveStatus(String encryptionId, String replaceFlag) {
      TCoreEncryptionTypeField tCoreEncryptionTypeField = (TCoreEncryptionTypeField)this.tCoreEncryptionTypeFieldDao.queryUnique(new Criterion[]{Restrictions.eq("id", encryptionId)});
      tCoreEncryptionTypeField.setFlag(replaceFlag);
      this.tCoreEncryptionTypeFieldDao.update(tCoreEncryptionTypeField);
   }

   public boolean allEncrypted(String projectid) {
      List<TCoreEncryptionTypeField> list = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.ne("flag", "5"), Restrictions.eq("projectid", projectid)});
      list = (List)list.stream().filter((t) -> !ObjectUtils.isEmpty(t.getEncryption_secretkey_id())).filter((t) -> !ObjectUtils.isEmpty(t.getEncryptiontypename())).filter((t) -> !ObjectUtils.isEmpty(t.getSecretkeyname())).collect(Collectors.toList());
      return list == null || list.size() == 0;
   }

   public HashMap getProjectEncryptConfig(String projectid) {
      HashMap<String, List> map = new HashMap();
      List<TCoreEncryptionTypeField> tCoreEncryptionTypeFieldList = this.tCoreEncryptionTypeFieldDao.getExcel(projectid);
      List<TCoreEncryption> encryptionList = this.tCoreEncryptionDao.getProjectSecretKeys(projectid);
      List<TCoreSecretkey> secretkeyList = this.tCoreSecretkeyDao.getProjectSecretKeys(projectid);

      for(int i = 0; i < secretkeyList.size(); ++i) {
         TCoreSecretkey tCoreSecretkey = (TCoreSecretkey)secretkeyList.get(i);
         TCoreEncryptionServiceImpl tCoreEncryptionServiceImpl = (TCoreEncryptionServiceImpl)ApplicationContextProvider.getBean(TCoreEncryptionServiceImpl.class);
         String dataKey = tCoreEncryptionServiceImpl.getDecDataKey(tCoreSecretkey.getSectet_key_value());
         tCoreSecretkey.setSectet_key_value(dataKey);
      }

      List<Map<String, String>> mapList1 = new ArrayList();
      List<Map<String, String>> mapList2 = new ArrayList();
      List<Map<String, String>> mapList3 = new ArrayList();

      for(TCoreEncryption tCoreEncryption : encryptionList) {
         Map<String, String> map1 = new HashMap();
         map1.put("id", tCoreEncryption.getId());
         map1.put("createtime", tCoreEncryption.getCreatetime() == null ? null : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(tCoreEncryption.getCreatetime()));
         map1.put("createuser", tCoreEncryption.getCreateuser());
         map1.put("flag", tCoreEncryption.getFlag());
         map1.put("note", tCoreEncryption.getNote());
         map1.put("updatetime", tCoreEncryption.getUpdatetime() == null ? null : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(tCoreEncryption.getUpdatetime()));
         map1.put("updateuser", tCoreEncryption.getUpdateuser());
         map1.put("encryption_name", tCoreEncryption.getEncryption_name());
         map1.put("encryption_type", tCoreEncryption.getEncryption_type());
         mapList1.add(map1);
      }

      for(TCoreSecretkey tCoreSecretkey : secretkeyList) {
         Map<String, String> map2 = new HashMap();
         map2.put("id", tCoreSecretkey.getId());
         map2.put("createtime", tCoreSecretkey.getCreatetime() == null ? null : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(tCoreSecretkey.getCreatetime()));
         map2.put("createuser", tCoreSecretkey.getCreateuser());
         map2.put("flag", tCoreSecretkey.getFlag());
         map2.put("note", tCoreSecretkey.getNote());
         map2.put("updatetime", tCoreSecretkey.getUpdatetime() == null ? null : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(tCoreSecretkey.getUpdatetime()));
         map2.put("updateuser", tCoreSecretkey.getUpdateuser());
         map2.put("privatekey", tCoreSecretkey.getPrivatekey());
         map2.put("publickey", tCoreSecretkey.getPublickey());
         map2.put("encryption_id", tCoreSecretkey.getEncryption_id());
         map2.put("secret_key_name", tCoreSecretkey.getSecret_key_name());
         map2.put("sectet_key_value", tCoreSecretkey.getSectet_key_value());
         mapList2.add(map2);
      }

      for(TCoreEncryptionTypeField tCoreEncryptionTypeField : tCoreEncryptionTypeFieldList) {
         Map<String, String> map3 = new HashMap();
         map3.put("id", tCoreEncryptionTypeField.getId());
         map3.put("createtime", tCoreEncryptionTypeField.getCreatetime() == null ? null : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(tCoreEncryptionTypeField.getCreatetime()));
         map3.put("createuser", tCoreEncryptionTypeField.getCreateuser());
         map3.put("flag", tCoreEncryptionTypeField.getFlag());
         map3.put("note", tCoreEncryptionTypeField.getNote());
         map3.put("updatetime", tCoreEncryptionTypeField.getUpdatetime() == null ? null : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(tCoreEncryptionTypeField.getUpdatetime()));
         map3.put("updateuser", tCoreEncryptionTypeField.getUpdateuser());
         map3.put("column_size", tCoreEncryptionTypeField.getColumn_size());
         map3.put("combination_id", tCoreEncryptionTypeField.getCombination_id());
         map3.put("dataareaid", tCoreEncryptionTypeField.getDataareaid());
         map3.put("datasystem_id", tCoreEncryptionTypeField.getDatasystem_id());
         map3.put("describe_info", tCoreEncryptionTypeField.getDescribe_info());
         map3.put("encryption_secretkey_id", tCoreEncryptionTypeField.getEncryption_secretkey_id());
         map3.put("names", tCoreEncryptionTypeField.getNames());
         map3.put("projectid", tCoreEncryptionTypeField.getProjectid());
         map3.put("table_field_id", tCoreEncryptionTypeField.getTable_field_id());
         map3.put("tschemas", tCoreEncryptionTypeField.getTschemas());
         map3.put("dataareaname", tCoreEncryptionTypeField.getDataareaname());
         map3.put("state", tCoreEncryptionTypeField.getState());
         map3.put("column_type", tCoreEncryptionTypeField.getColumn_type());
         map3.put("datasystemname", tCoreEncryptionTypeField.getDatasystemname());
         map3.put("encryptiontypename", tCoreEncryptionTypeField.getEncryptiontypename());
         map3.put("secretkeyname", tCoreEncryptionTypeField.getSecretkeyname());
         map3.put("islike", tCoreEncryptionTypeField.getIslike());
         map3.put("keepfirst", tCoreEncryptionTypeField.getKeepfirst());
         map3.put("encdigit", tCoreEncryptionTypeField.getEncdigit());
         map3.put("realitycolumnsize", tCoreEncryptionTypeField.getRealitycolumnsize());
         map3.put("twoindex", tCoreEncryptionTypeField.getTwoindex());
         mapList3.add(map3);
      }

      map.put("field", mapList3);
      map.put("key", mapList2);
      map.put("enc", mapList1);
      return map;
   }

   public HashMap getProjectEncryptConfigTxt(String projectid) {
      HashMap<String, List> map = new HashMap();
      List<TCoreEncryptionTypeField> tCoreEncryptionTypeFieldList = this.tCoreEncryptionTypeFieldDao.getExcel(projectid);
      if (null != tCoreEncryptionTypeFieldList && tCoreEncryptionTypeFieldList.size() != 0) {
         List<TCoreEncryption> encryptionList = this.tCoreEncryptionDao.getProjectSecretKeys(projectid);
         List<TCoreSecretkey> secretkeyList = this.tCoreSecretkeyDao.getProjectSecretKeys(projectid);

         for(int i = 0; i < secretkeyList.size(); ++i) {
            TCoreSecretkey tCoreSecretkey = (TCoreSecretkey)secretkeyList.get(i);
            TCoreEncryptionServiceImpl tCoreEncryptionServiceImpl = (TCoreEncryptionServiceImpl)ApplicationContextProvider.getBean(TCoreEncryptionServiceImpl.class);
            String dataKey = tCoreEncryptionServiceImpl.getDecDataKey(tCoreSecretkey.getSectet_key_value());
            tCoreSecretkey.setSectet_key_value(dataKey);
         }

         List<String> encryptionListString = new ArrayList();

         for(TCoreEncryption e : encryptionList) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(e.getId() == null ? "" : e.getId()).append("#_#");
            stringBuffer.append(e.getCreatetime() == null ? "" : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(e.getCreatetime())).append("#_#");
            stringBuffer.append(e.getCreateuser() == null ? "" : e.getCreateuser()).append("#_#");
            stringBuffer.append(e.getFlag() == null ? "" : e.getFlag()).append("#_#");
            stringBuffer.append(e.getNote() == null ? "" : e.getNote()).append("#_#");
            stringBuffer.append(e.getUpdatetime() == null ? "" : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(e.getUpdatetime())).append("#_#");
            stringBuffer.append(e.getUpdateuser() == null ? "" : e.getUpdateuser()).append("#_#");
            stringBuffer.append(e.getEncryption_name() == null ? "" : e.getEncryption_name()).append("#_#");
            stringBuffer.append(e.getEncryption_type() == null ? "" : e.getEncryption_type());
            encryptionListString.add(stringBuffer.toString());
         }

         List<String> secretkeyListString = new ArrayList();

         for(TCoreSecretkey s : secretkeyList) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(s.getId() == null ? "" : s.getId()).append("#_#");
            stringBuffer.append(s.getCreatetime() == null ? "" : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(s.getCreatetime())).append("#_#");
            stringBuffer.append(s.getCreateuser() == null ? "" : s.getCreateuser()).append("#_#");
            stringBuffer.append(s.getFlag() == null ? "" : s.getFlag()).append("#_#");
            stringBuffer.append(s.getNote() == null ? "" : s.getNote()).append("#_#");
            stringBuffer.append(s.getUpdatetime() == null ? "" : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(s.getUpdatetime())).append("#_#");
            stringBuffer.append(s.getUpdateuser() == null ? "" : s.getUpdateuser()).append("#_#");
            stringBuffer.append(s.getPrivatekey() == null ? "" : s.getPrivatekey()).append("#_#");
            stringBuffer.append(s.getPublickey() == null ? "" : s.getPublickey()).append("#_#");
            stringBuffer.append(s.getEncryption_id() == null ? "" : s.getEncryption_id()).append("#_#");
            stringBuffer.append(s.getSecret_key_name() == null ? "" : s.getSecret_key_name()).append("#_#");
            stringBuffer.append(s.getSectet_key_value() == null ? "" : s.getSectet_key_value());
            secretkeyListString.add(stringBuffer.toString());
         }

         List<String> tCoreEncryptionTypeFieldListString = new ArrayList();

         for(TCoreEncryptionTypeField f : tCoreEncryptionTypeFieldList) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(f.getId() == null ? "" : f.getId()).append("#_#");
            stringBuffer.append(f.getCreatetime() == null ? "" : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(f.getCreatetime())).append("#_#");
            stringBuffer.append(f.getCreateuser() == null ? "" : f.getCreateuser()).append("#_#");
            stringBuffer.append(f.getFlag() == null ? "" : f.getFlag()).append("#_#");
            stringBuffer.append(f.getNote() == null ? "" : f.getNote()).append("#_#");
            stringBuffer.append(f.getUpdatetime() == null ? "" : (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(f.getUpdatetime())).append("#_#");
            stringBuffer.append(f.getUpdateuser() == null ? "" : f.getUpdateuser()).append("#_#");
            stringBuffer.append(f.getColumn_size() == null ? "" : f.getColumn_size()).append("#_#");
            stringBuffer.append(f.getCombination_id() == null ? "" : f.getCombination_id()).append("#_#");
            stringBuffer.append(f.getDataareaid() == null ? "" : f.getDataareaid()).append("#_#");
            stringBuffer.append(f.getDatasystem_id() == null ? "" : f.getDatasystem_id()).append("#_#");
            stringBuffer.append(f.getDescribe_info() == null ? "" : f.getDescribe_info()).append("#_#");
            stringBuffer.append(f.getEncryption_secretkey_id() == null ? "" : f.getEncryption_secretkey_id()).append("#_#");
            stringBuffer.append(f.getNames() == null ? "" : f.getNames()).append("#_#");
            stringBuffer.append(f.getProjectid() == null ? "" : f.getProjectid()).append("#_#");
            stringBuffer.append(f.getTable_field_id() == null ? "" : f.getTable_field_id()).append("#_#");
            stringBuffer.append(f.getTschemas() == null ? "" : f.getTschemas()).append("#_#");
            stringBuffer.append(f.getDataareaname() == null ? "" : f.getDataareaname()).append("#_#");
            stringBuffer.append(f.getState() == null ? "" : f.getState()).append("#_#");
            stringBuffer.append(f.getColumn_type() == null ? "" : f.getColumn_type()).append("#_#");
            stringBuffer.append(f.getDatasystemname() == null ? "" : f.getDatasystemname()).append("#_#");
            stringBuffer.append(f.getEncryptiontypename() == null ? "" : f.getEncryptiontypename()).append("#_#");
            stringBuffer.append(f.getSecretkeyname() == null ? "" : f.getSecretkeyname()).append("#_#");
            stringBuffer.append(f.getIslike() == null ? "" : f.getIslike()).append("#_#");
            stringBuffer.append(f.getKeepfirst() == null ? "" : f.getKeepfirst()).append("#_#");
            stringBuffer.append(f.getEncdigit() == null ? "" : f.getEncdigit()).append("#_#");
            stringBuffer.append(f.getRealitycolumnsize() == null ? "" : f.getRealitycolumnsize()).append("#_#");
            stringBuffer.append(f.getTwoindex() == null ? "" : f.getTwoindex()).append("#_#");
            stringBuffer.append(f.getId() == null ? "placeholder" : f.getId());
            tCoreEncryptionTypeFieldListString.add(stringBuffer.toString());
         }

         map.put("field", tCoreEncryptionTypeFieldListString);
         map.put("key", secretkeyListString);
         map.put("enc", encryptionListString);
         return map;
      } else {
         return map;
      }
   }

   public String queryCcoreSDFKey(String key) {
      try {
         if (null != key && !"".equals(key)) {
            try {
               byte[] endData = Hex.decode(key);
               return CcoreSDFUtil.getDecrypt(endData);
            } catch (Exception e) {
               e.printStackTrace();
            }
         }

         return "加密卡解密秘钥失败";
      } catch (Exception exception) {
         return "加密卡解密秘钥失败," + exception.toString();
      }
   }

   public void saveColumnPrimaryKey(ColumnPrimaryKeyInfo columnPrimaryKeyInfo) {
      List<ColumnPrimaryKeyInfo> columnPrimaryKeyInfoList = this.columnPrimaryKeyInfoDao.queryAll(new Criterion[]{Restrictions.eq("project_id", columnPrimaryKeyInfo.getProject_id()), Restrictions.eq("datasystem_id", columnPrimaryKeyInfo.getDatasystem_id()), Restrictions.eq("tschema", columnPrimaryKeyInfo.getTschema()), Restrictions.eq("tname", columnPrimaryKeyInfo.getTname())});
      int aa = columnPrimaryKeyInfoList.size();
      if (aa > 0) {
         for(int t = 0; t < aa; ++t) {
            this.columnPrimaryKeyInfoDao.remove(columnPrimaryKeyInfoList.get(t));
         }
      }

      Optional<DataBase> dataBase = null;
      List<DataBase> dataList = DataCache.dataList;
      Optional<Schema> schema = null;
      Optional<Table> table = null;
      Optional<Column> column = null;
      String[] pks = columnPrimaryKeyInfo.getPrimary_key_columns().split(",");
      dataBase = dataList.stream().filter((x) -> x.getDatasystemid().equals(columnPrimaryKeyInfo.getDatasystem_id())).findFirst();
      if (dataBase.isPresent()) {
         List<Schema> schemaList = ((DataBase)dataBase.get()).getSchemaList();
         schema = schemaList.stream().filter((s) -> columnPrimaryKeyInfo.getTschema().equals(s.getName())).findFirst();
         if (schema.isPresent()) {
            List<Table> tableList = ((Schema)schema.get()).getTableList();
            table = tableList.stream().filter((t) -> columnPrimaryKeyInfo.getTname().equals(t.getName())).findFirst();
            if (table.isPresent()) {
               List<Column> columnList = ((Table)table.get()).getColumnList();
               if (columnList != null && columnList.size() != 0) {
                  for(int i = 0; i < pks.length; ++i) {
                     String cname = pks[i];
                     column = columnList.stream().filter((c) -> cname.equals(c.getColumnName())).findFirst();
                     if (column.isPresent()) {
                        if ("0".equals(((Column)column.get()).getPrimarykey())) {
                           columnPrimaryKeyInfo.setFlag("1");
                        }
                        break;
                     }
                  }
               }
            }
         }
      }

      this.columnPrimaryKeyInfoDao.save(columnPrimaryKeyInfo);
   }

   @ResponseBody
   @RequestMapping({"/queryTables"})
   public Response<List<String>> queryTables(@RequestBody RowSensitiveLevelReqVO vo) {
      List<DBTableVO> list = this.dataSystemService.queryTablename(vo.getDataSystemId(), vo.getSchema());
      List<String> tables = (List)list.stream().map((e) -> new String(e.getTablename())).collect(Collectors.toList());
      Collections.sort(tables);
      return RespHelper.<List<String>>successResp(tables);
   }

   @Transactional
   public List<Map<String, Object>> getAllColumnsByMap(ExcelEncryptionVO param) throws SQLException {
      List<DBTableVO> tableList = param.getTableList();
      List<String> dataSourceIdList = param.getDataSourceIdList();
      List<Map<String, String>> schemalist = param.getSchemalist();
      if (!ObjectUtils.isEmpty(dataSourceIdList)) {
         if (!ObjectUtils.isEmpty(schemalist)) {
            for(String dataSource : dataSourceIdList) {
               if (Objects.isNull(this.dataSourceTmp) || !Objects.equals(this.dataSourceTmp, dataSource)) {
                  this.dataSourceTmp = dataSource;
                  if (Objects.nonNull(this.connGetAllColumnsByMap)) {
                     this.connGetAllColumnsByMap.close();
                  }

                  this.connGetAllColumnsByMap = this.dataSystemService.getConnectionByDataSystemId(this.dataSourceTmp);
               }

               if (!ObjectUtils.isEmpty(this.connGetAllColumnsByMap)) {
                  for(TCoreDatasourceSchema schema1 : this.dataSystemService.querySchemas(param.getProject().getId(), dataSource)) {
                     for(String tableName : JdbcTool.getAllTableName(this.connGetAllColumnsByMap, schema1.getSchemaname())) {
                        DBTableVO tableVO = new DBTableVO();
                        tableVO.setTablename(tableName);
                        tableVO.setSchema(schema1.getSchemaname());
                        tableVO.setDatasystemid(schema1.getOsdsid());
                        tableList.add(tableVO);
                     }
                  }
               }
            }

            for(Map<String, String> schema : schemalist) {
               if (!ObjectUtils.isEmpty(schema.get("datasystemid"))) {
                  String dataSourceId = (String)schema.get("datasystemid");
                  if (Objects.isNull(this.dataSourceTmp) || !Objects.equals(this.dataSourceTmp, dataSourceId)) {
                     this.dataSourceTmp = dataSourceId;
                     if (Objects.nonNull(this.connGetAllColumnsByMap)) {
                        this.connGetAllColumnsByMap.close();
                     }

                     this.connGetAllColumnsByMap = this.dataSystemService.getConnectionByDataSystemId(this.dataSourceTmp);
                  }

                  if (!ObjectUtils.isEmpty(this.connGetAllColumnsByMap)) {
                     for(String tableName : JdbcTool.getAllTableName(this.connGetAllColumnsByMap, (String)schema.get("schema"))) {
                        DBTableVO tableVO = new DBTableVO();
                        tableVO.setTablename(tableName);
                        tableVO.setSchema((String)schema.get("schema"));
                        tableVO.setDatasystemid((String)schema.get("datasystemid"));
                        tableList.add(tableVO);
                     }
                  }
               }
            }
         } else {
            for(String dataSource : dataSourceIdList) {
               TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(dataSource);
               if ("MONGODB".equals(datasystem.getDbtype())) {
                  for(TCoreDatasourceSchema schema : this.dataSystemService.querySchemas(param.getProject().getId(), dataSource)) {
                     try {
                        MongoClient connect = MongodbTool.connect(schema.getSchemaname(), datasystem.getUsername(), AesTool.decrypt(datasystem.getPassword(), "ghca"), datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()), true);

                        for(String t : MongodbTool.findAllTables(connect, schema.getSchemaname())) {
                           DBTableVO tableVO = new DBTableVO();
                           tableVO.setTablename(t);
                           tableVO.setSchema(schema.getSchemaname());
                           tableVO.setDatasystemid(schema.getOsdsid());
                           tableList.add(tableVO);
                        }
                     } catch (Exception e) {
                        e.printStackTrace();
                     }
                  }
               } else if ("ES".equals(datasystem.getDbtype())) {
                  List<TCoreDatasourceSchema> schemaList = this.dataSystemService.querySchemas(param.getProject().getId(), dataSource);
                  EsUtil esUtil = new EsUtil();

                  for(TCoreDatasourceSchema schema : schemaList) {
                     for(String t : esUtil.getESType(datasystem.getDbip(), datasystem.getDbport(), schema.getSchemaname())) {
                        DBTableVO tableVO = new DBTableVO();
                        tableVO.setTablename(t);
                        tableVO.setSchema(schema.getSchemaname());
                        tableVO.setDatasystemid(schema.getOsdsid());
                        tableList.add(tableVO);
                     }
                  }
               } else {
                  if (Objects.isNull(this.dataSourceTmp) || !Objects.equals(this.dataSourceTmp, dataSource)) {
                     this.dataSourceTmp = dataSource;
                     if (Objects.nonNull(this.connGetAllColumnsByMap)) {
                        this.connGetAllColumnsByMap.close();
                     }

                     this.connGetAllColumnsByMap = this.dataSystemService.getConnectionByDataSystemId(this.dataSourceTmp);
                  }

                  if (!ObjectUtils.isEmpty(this.connGetAllColumnsByMap)) {
                     for(TCoreDatasourceSchema schema : this.dataSystemService.querySchemas(param.getProject().getId(), dataSource)) {
                        for(String tableName : JdbcTool.getAllTableName(this.connGetAllColumnsByMap, schema.getSchemaname())) {
                           DBTableVO tableVO = new DBTableVO();
                           tableVO.setTablename(tableName);
                           tableVO.setSchema(schema.getSchemaname());
                           tableVO.setDatasystemid(schema.getOsdsid());
                           tableList.add(tableVO);
                        }
                     }
                  }
               }
            }
         }
      } else if (!ObjectUtils.isEmpty(schemalist)) {
         for(Map<String, String> schema : schemalist) {
            if (!ObjectUtils.isEmpty(schema.get("datasystemid"))) {
               String dataSourceId = (String)schema.get("datasystemid");
               if (Objects.isNull(this.dataSourceTmp) || !Objects.equals(this.dataSourceTmp, dataSourceId)) {
                  this.dataSourceTmp = dataSourceId;
                  if (Objects.nonNull(this.connGetAllColumnsByMap)) {
                     this.connGetAllColumnsByMap.close();
                  }

                  this.connGetAllColumnsByMap = this.dataSystemService.getConnectionByDataSystemId(this.dataSourceTmp);
               }

               if (!ObjectUtils.isEmpty(this.connGetAllColumnsByMap)) {
                  for(String tableName : JdbcTool.getAllTableName(this.connGetAllColumnsByMap, (String)schema.get("schema"))) {
                     DBTableVO tableVO = new DBTableVO();
                     tableVO.setTablename(tableName);
                     tableVO.setSchema((String)schema.get("schema"));
                     tableVO.setDatasystemid((String)schema.get("datasystemid"));
                     tableList.add(tableVO);
                  }
               }
            }
         }
      } else {
         tableList = param.getTableList();
      }

      TCoreDataProject project = param.getProject();
      String projectId = project.getId();
      tableList.sort(Comparator.comparing(DBTableVO::getDatasystemid));
      List<Map<String, Object>> mapList = new ArrayList();

      for(DBTableVO table : tableList) {
         EncryptionConfigVO encryptionConfigVO = new EncryptionConfigVO();
         encryptionConfigVO.setDatasystem_id(table.getDatasystemid());
         encryptionConfigVO.setTable_name(table.getTablename());
         encryptionConfigVO.setSchema(table.getSchema());
         encryptionConfigVO.setProjectId(projectId);
         List<ColumnInfoVO> columnInfoVOS = this.queryOriginalList(encryptionConfigVO);
         List<TCoreEncryptionTypeField> tCoreEncryptionTypes = this.tCoreEncryptionTypeFieldDao.getTCoreEncryptionTypeField(table.getTablename(), table.getSchema(), table.getDatasystemid());
         List<String> flagList = new ArrayList();
         Map<String, String> map1 = new HashMap();

         for(TCoreEncryptionTypeField t : tCoreEncryptionTypes) {
            if (!"0".equals(t.getFlag()) && !"7".equals(t.getFlag())) {
               flagList.add(t.getTable_field_id());
            }

            map1.put(t.getTable_field_id(), t.getDescribe_info());
         }

         for(int j = 0; j < columnInfoVOS.size(); ++j) {
            ColumnInfoVO columnInfoVO = (ColumnInfoVO)columnInfoVOS.get(j);
            if (!columnInfoVO.getColumnname().toLowerCase(Locale.ROOT).contains("_initial") && !columnInfoVO.getColumnname().toLowerCase(Locale.ROOT).contains("_cipher") && !columnInfoVO.getColumnname().toLowerCase(Locale.ROOT).contains("_copy")) {
               Map<String, Object> resultMap = new HashMap();
               resultMap.put("工程名", projectId);
               resultMap.put("数据源id", table.getDatasystemid());
               resultMap.put("数据源", ((TCoreDatasystem)this.tCoreDatasystemDao.get(table.getDatasystemid())).getSysname());
               resultMap.put("schema", table.getSchema());
               resultMap.put("表名", table.getTablename());
               resultMap.put("字段名", columnInfoVO.getColumnname());
               resultMap.put("字段类型", columnInfoVO.getTypename());
               resultMap.put("字段长度", columnInfoVO.getColumnsize());
               resultMap.put("注释", columnInfoVO.getRemarks());
               resultMap.put("描述", map1.get(columnInfoVO.getColumnname()));
               if (flagList.contains(columnInfoVO.getColumnname())) {
                  resultMap.put("状态", "已加密");
                  resultMap.put("加密类型", "已锁定");
                  resultMap.put("加密秘钥", "已锁定");
               } else {
                  resultMap.put("状态", "未加密");
                  resultMap.put("加密类型", "待定");
                  resultMap.put("加密秘钥", "待定");
               }

               mapList.add(resultMap);
            }
         }
      }

      return mapList;
   }

   public Map<String, List<String>> getKeyMap() {
      Map<String, List<String>> keyMap = new HashMap();

      for(TCoreEncryption tCoreEncryption : this.tCoreEncryptionDao.queryAll()) {
         String keyName = tCoreEncryption.getEncryption_name();
         List<TCoreSecretkey> secretKeys = this.tCoreSecretkeyDao.queryAll(new Criterion[]{Restrictions.eq("encryption_id", tCoreEncryption.getId())});
         List<String> secretKeyName = new ArrayList();
         if (!ObjectUtils.isEmpty(secretKeys)) {
            for(TCoreSecretkey tCoreSecretkey : secretKeys) {
               secretKeyName.add(tCoreSecretkey.getSecret_key_name());
            }

            keyMap.put(keyName, secretKeyName);
         }
      }

      return keyMap;
   }

   public List<TreeVO> getEncryptionTypeList() {
      List<TreeVO> result = new ArrayList();

      for(TCoreEncryption tCoreEncryption : this.tCoreEncryptionDao.queryAll()) {
         String keyName = tCoreEncryption.getEncryption_name();
         TreeVO treeVO = new TreeVO();
         treeVO.setId(tCoreEncryption.getId());
         treeVO.setText(keyName);
         List<TCoreSecretkey> secretKeys = this.tCoreSecretkeyDao.queryAll(new Criterion[]{Restrictions.eq("encryption_id", tCoreEncryption.getId())});
         if (ObjectUtils.isEmpty(secretKeys)) {
            treeVO.setChildren((List)null);
         } else {
            List<TreeVO> treeVOList = new ArrayList();

            for(TCoreSecretkey tCoreSecretkey : secretKeys) {
               TreeVO treeVO1 = new TreeVO();
               treeVO1.setId(tCoreSecretkey.getId());
               treeVO1.setText(tCoreSecretkey.getSecret_key_name());
               treeVO1.setChildren((List)null);
               treeVOList.add(treeVO1);
            }

            treeVO.setChildren(treeVOList);
         }

         result.add(treeVO);
      }

      return result;
   }

   public List<Map<String, Object>> getProjectChildren(String projectid) {
      List<Map<String, Object>> result = new ArrayList();

      for(DatasystemProjectdatasourceVO DatasystemProjectdatasourceVO : this.tCoreProjectDatasourceDao.queryDatasystemByProId(projectid)) {
         Map<String, Object> dataSystemTreeVO = new HashMap();
         String dataSystemId = DatasystemProjectdatasourceVO.getTid();
         dataSystemTreeVO.put("label", ((TCoreDatasystem)this.tCoreDatasystemDao.get(dataSystemId)).getSysname());
         List<TCoreDatasourceSchema> schemaList = this.tCoreFirstPageDataDao.querySchemasByProjectId(projectid, dataSystemId);
         List<Map<String, Object>> schemaTreeVOList = new ArrayList();

         for(TCoreDatasourceSchema schema : schemaList) {
            Map<String, Object> schemaTreeVO = new HashMap();
            schemaTreeVO.put("label", schema.getSchemaname());
            List<DBTableVO> tableList = this.dataSystemService.queryTablename(dataSystemId, schema.getSchemaname());
            List<Map<String, Object>> tableTreeVOList = new ArrayList();

            for(DBTableVO tableVO : tableList) {
               Map<String, Object> tableTreeVO = new HashMap();
               tableTreeVO.put("label", tableVO.getTablename());
               tableTreeVO.put("datasystemid", dataSystemId);
               tableTreeVO.put("schema", schema.getSchemaname());
               tableTreeVO.put("tablename", tableVO.getTablename());
               tableTreeVOList.add(tableTreeVO);
            }

            schemaTreeVO.put("children", tableTreeVOList);
            schemaTreeVOList.add(schemaTreeVO);
         }

         dataSystemTreeVO.put("children", schemaTreeVOList);
         result.add(dataSystemTreeVO);
      }

      return result;
   }

   private List<String> getUnique(String str) {
      List<String> res = new ArrayList();
      String uk = "";
      String getUk = "Column Name: (.*?), Key Sequence";
      Pattern pattern = Pattern.compile(getUk);
      Matcher matcher = pattern.matcher(str);

      try {
         while(matcher.find()) {
            uk = matcher.group(1);
            res.add(uk);
         }
      } catch (Exception var8) {
      }

      return res;
   }
}
