package com.chenyang.nse.bussiness.service.core.strategy;

import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.masking.app.MaksingAppDataRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.masking.relevance.MaksingJoinFieldInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.masking.relevance.MaksingJoinTableInfo;
import com.chenyang.nse.bussiness.entity.vo.encyption.EncryptionConfigVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface MaksingAppDataRuleService {
   List<Map<String, String>> querytables(String dataSystemid, List<String> schemas, List<String> tablenames, String tablefield);

   List<ColumnInfoVO> queryColumnInfo(String datasystemid, String schema, String tablename);

   HashMap queryBatchColumnInfo(EncryptionConfigVO vo);

   MaksingAppDataRule queryById(String strategyid);

   MaksingJoinTableInfo queryTableById(String id);

   List<MaksingJoinTableInfo> queryTableInfoById(String maskingid);

   List<MaksingJoinFieldInfo> queryFieldInfoById(String tableid);

   List<MaksingJoinFieldInfo> queryFieldInfoByDataareaid(String dataareaid);

   void saveRuleInfo(MaksingJoinTableInfo maksingJoinTableInfo);

   void saveFieldInfo(MaksingJoinFieldInfo maksingJoinFieldInfo);

   void removeStrategy(String strategyid);

   void removeRuleInfo(String maskingid);

   void removeFieldInfo(String maskingid);

   void saveRule(MaksingAppDataRule maksingAppDataRule);

   void updateRule(MaksingAppDataRule maksingAppDataRule);

   TCoreDatasystem queryDataSystemById(String id);

   void updateMaskingStatus(String id, String status);

   List<MaksingAppDataRule> getMaksingInfoByDataSystemById(String datasystemid);
}
