package com.chenyang.nse.bussiness.service.info.db;

import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleFastManage;
import com.chenyang.nse.bussiness.entity.redis.TCoreMaskingTaskTableInfo;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import com.power.xml.entity.ColumnInfo;
import com.power.xml.entity.Config;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class DM extends CommonMethod implements DatabaseTool {
   public static final String mysqlexportfilename = "mysqlexportfile";
   public static final String mysqlexportfilemark = "快速导出";
   public static final String mysqlloadname = "mysqlload";
   public static final String mysqlloadmark = "快速导入";
   public static final String[][] exporttype = new String[][]{{"normal", "正常导出", ""}, {"mysqlexportfile", "快速导出", ""}};
   public static final String[][] importtype = new String[][]{{"normal", "正常导入", "selected"}, {"mysqlload", "快速导入", ""}};

   public String ImportMethod() {
      StringBuffer targetradio = new StringBuffer();
      List<TConsoleFastManage> list = this.tConsoleFastManageDao.queryAll(new Criterion[]{Restrictions.eq("databasetype", this.getClass().getSimpleName())});
      if (!list.isEmpty()) {
         TConsoleFastManage tConsoleFastManage = (TConsoleFastManage)list.get(0);
         if (tConsoleFastManage.getFastimport() == 0) {
            targetradio.append(MessageFormat.format(this.targetradio(), "'normal'", "正常导出", "selected"));
         } else {
            targetradio.append("<select name='execution_type'>");

            for(String[] radio : importtype) {
               targetradio.append(MessageFormat.format(this.sourceradio(), "'" + radio[0] + "'", radio[1], radio[2]));
            }

            targetradio.append("</select>");
         }
      } else {
         targetradio.append("<select name='execution_type'>");

         for(String[] radio : importtype) {
            targetradio.append(MessageFormat.format(this.sourceradio(), "'" + radio[0] + "'", radio[1], radio[2]));
         }

         targetradio.append("</select>");
      }

      return targetradio.toString();
   }

   public String ExportMethod() {
      StringBuffer sourceradio = new StringBuffer();
      List<TConsoleFastManage> list = this.tConsoleFastManageDao.queryAll(new Criterion[]{Restrictions.eq("databasetype", this.getClass().getSimpleName())});
      if (!list.isEmpty()) {
         TConsoleFastManage tConsoleFastManage = (TConsoleFastManage)list.get(0);
         if (tConsoleFastManage.getFastexport() == 0) {
            sourceradio.append(MessageFormat.format(this.sourceradio(), "'normal'", "正常导出", "selected"));
         } else {
            sourceradio.append("<select name='execution_type' >");

            for(String[] radio : exporttype) {
               sourceradio.append(MessageFormat.format(this.sourceradio(), "'" + radio[0] + "'", radio[1], radio[2]));
            }

            sourceradio.append("</select>");
         }
      } else {
         sourceradio.append("<select name='execution_type' >");

         for(String[] radio : exporttype) {
            sourceradio.append(MessageFormat.format(this.sourceradio(), "'" + radio[0] + "'", radio[1], radio[2]));
         }

         sourceradio.append("</select>");
      }

      return sourceradio.toString();
   }

   public Map TargetParameter_normal() {
      Map<String, String> map = this.TargetParameter_fnormal();
      map.put("targetParameter", this.isrebuild() + this.isindex() + this.isprimary() + this.istrigger() + this.isfunction() + this.isconstraint() + this.isview());
      return map;
   }

   public Map TargetParameter_normal1() {
      Map<String, String> map = this.TargetParameter_fnormal();
      map.put("targetParameter", this.isrebuild() + this.isindex() + this.isprimary() + this.istrigger() + this.isfunction());
      return map;
   }

   public Map TargetParameter_notNormal() {
      Map<String, String> map = this.TargetParameter_fnotnormal();
      return map;
   }

   public List<StringBuffer> SynTriggersParam(Connection s_conn, Map map) {
      List<StringBuffer> listTriggers = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchema");
      String tableName = (String)map.get("tableName");
      String functionName = "";
      String sql = "show create trigger ";
      String sql_user = "show  triggers";

      try {
         ps = s_conn.prepareStatement(sql_user);
         rs = ps.executeQuery();

         while(rs.next()) {
            String tablename = rs.getString("Table");
            if (tableName.equals(tablename)) {
               functionName = rs.getString("Trigger");
               ps = s_conn.prepareStatement(sql + functionName);
               rs = ps.executeQuery();

               while(rs.next()) {
                  StringBuffer sb = new StringBuffer();
                  sb.append("CREATE ");
                  sb.append(rs.getString("SQL Original Statement").substring(rs.getString("SQL Original Statement").indexOf("TRIGGER")));
                  listTriggers.add(sb);
                  System.out.println(sb.toString());
               }
            }
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listTriggers;
   }

   public List<StringBuffer> SynFunctionParam(Connection s_conn, Map map) {
      List<StringBuffer> listFunction = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchemaName");
      String functionName = "";
      String sql = "show create function ";
      String sql_user = "show function  status where Db= '" + sourceSchemaName + "'";

      try {
         ps = s_conn.prepareStatement(sql_user);
         rs = ps.executeQuery();

         while(rs.next()) {
            functionName = rs.getString("Name");
            ps = s_conn.prepareStatement(sql + functionName);
            rs = ps.executeQuery();

            while(rs.next()) {
               StringBuffer sb = new StringBuffer();
               sb.append("CREATE ");
               sb.append(rs.getString("Create Function").substring(rs.getString("Create Function").indexOf("FUNCTION")));
               listFunction.add(sb);
               System.out.println(sb.toString());
            }
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listFunction;
   }

   public List<StringBuffer> SynProcedureParam(Connection s_conn, Map map) {
      List<StringBuffer> listProcedure = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchemaName");
      String functionName = "";
      String sql = "show create procedure ";
      String sql_user = "show procedure  status where Db= '" + sourceSchemaName + "'";

      try {
         ps = s_conn.prepareStatement(sql_user);
         rs = ps.executeQuery();

         while(rs.next()) {
            functionName = rs.getString("Name");
            ps = s_conn.prepareStatement(sql + functionName);
            rs = ps.executeQuery();

            while(rs.next()) {
               StringBuffer sb = new StringBuffer();
               sb.append("CREATE ");
               sb.append(rs.getString("Create Procedure").substring(rs.getString("Create Procedure").indexOf("PROCEDURE")));
               listProcedure.add(sb);
               System.out.println(sb.toString());
            }
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listProcedure;
   }

   public ColumnInfo getPwc_columnInfo_target(Map map) {
      ColumnInfo pwc_columnInfo_target = new ColumnInfo();
      TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo = (TCoreMaskingTaskTableInfo)map.get("tCoreMaskingTaskTableInfo");
      int type = (Integer)map.get("type");
      Map<String, String> data_by_source = (Map)map.get("data_by_source");
      Boolean issomedb = (Boolean)map.get("issomedb");
      Map<String, Map<String, String>> data_target_length = (Map)map.get("data_target_length");
      Map<String, Map<String, String>> data_target = (Map)map.get("data_target");
      Map<String, Map<String, String>> data_t_x_length = (Map)map.get("data_t_x_length");
      Map<String, String> data_rule = (Map)map.get("data_rule");
      String qualifierType = (String)map.get("qualifierType");
      Config pwc_config = (Config)map.get("pwc_config");
      String source = StringTool.delparentheses(tCoreMaskingTaskTableInfo.getSourceType().toLowerCase());
      String pwc_type = (String)data_by_source.get(source);
      String targetype = "";
      String targetlength = "";
      String targetscancale = "";
      String targetpwcsqlength = "";
      String targetpwcsqscale = "";
      String targetpwcdateformat = "";
      if (type == 0) {
         if (issomedb) {
            targetype = source;
            targetlength = (String)((Map)data_target_length.get(source)).get("sourcelength");
            targetscancale = (String)((Map)data_target_length.get(source)).get("sourcescancale");
            targetpwcsqlength = (String)((Map)data_target_length.get(source)).get("pwcsqlength");
            targetpwcsqscale = (String)((Map)data_target_length.get(source)).get("pwcsqscale");
            targetpwcdateformat = (String)((Map)data_target_length.get(source)).get("pwcdateformat");
         } else {
            targetype = ((String)((Map)data_target.get(pwc_type)).get("sourcefieldname")).toLowerCase();
            targetlength = (String)((Map)data_target_length.get(targetype)).get("sourcelength");
            targetscancale = (String)((Map)data_target_length.get(targetype)).get("sourcescancale");
            targetpwcsqlength = (String)((Map)data_target_length.get(targetype)).get("pwcsqlength");
            targetpwcsqscale = (String)((Map)data_target_length.get(targetype)).get("pwcsqscale");
            targetpwcdateformat = (String)((Map)data_target_length.get(targetype)).get("pwcdateformat");
         }
      } else {
         targetype = StringTool.delparentheses(tCoreMaskingTaskTableInfo.getTargetType().toLowerCase());
         String colType = tCoreMaskingTaskTableInfo.getTargetType();
         int colLength = Integer.parseInt(tCoreMaskingTaskTableInfo.getColumnLength().equals("") ? "0" : tCoreMaskingTaskTableInfo.getColumnLength());
         if (!"TEXT".equalsIgnoreCase(colType) || colLength <= 2000) {
            targetlength = (String)((Map)data_t_x_length.get(targetype + pwc_type)).get("sourcelength");
            targetscancale = (String)((Map)data_t_x_length.get(targetype + pwc_type)).get("sourcescancale");
            targetpwcsqlength = (String)((Map)data_t_x_length.get(targetype + pwc_type)).get("pwcsqlength");
            targetpwcsqscale = (String)((Map)data_t_x_length.get(targetype + pwc_type)).get("pwcsqscale");
            targetpwcdateformat = (String)((Map)data_t_x_length.get(targetype + pwc_type)).get("pwcdateformat");
         }
      }

      pwc_columnInfo_target.setColumnName(tCoreMaskingTaskTableInfo.getColumnName());
      if ("SYSDATE".equalsIgnoreCase(pwc_columnInfo_target.getColumnName())) {
         pwc_columnInfo_target.setColumnName(tCoreMaskingTaskTableInfo.getColumnName() + "1");
      }

      pwc_columnInfo_target.setDataType(StringTool.delparentheses(targetype.toUpperCase()));
      pwc_columnInfo_target.setKeyType(tCoreMaskingTaskTableInfo.getIsPrimaryKey().equals("1") ? 1 : (tCoreMaskingTaskTableInfo.getIsForeignKey() != null ? (tCoreMaskingTaskTableInfo.getIsForeignKey().equals("1") ? 2 : 0) : 0));
      pwc_columnInfo_target.setMaskingRule((String)data_rule.get(tCoreMaskingTaskTableInfo.getRegexRuleId()));
      pwc_columnInfo_target.setNullable(pwc_columnInfo_target.getKeyType() != 0 ? 1 : 0);
      pwc_columnInfo_target.setQualifierType(qualifierType.toLowerCase());
      pwc_columnInfo_target.setScale(targetscancale != null && !targetscancale.equals("") ? targetscancale : tCoreMaskingTaskTableInfo.getColumnPrecision());
      pwc_columnInfo_target.setPrecision(targetlength != null && !targetlength.equals("") ? targetlength : tCoreMaskingTaskTableInfo.getColumnLength());
      if (pwc_columnInfo_target.getPrecision() == null || "".equals(pwc_columnInfo_target.getPrecision())) {
         pwc_columnInfo_target.setPrecision(tCoreMaskingTaskTableInfo.getColumnLength());
      }

      if (targetpwcsqlength != null && !targetpwcsqlength.equals("")) {
         pwc_columnInfo_target.setSqprecision(targetpwcsqlength);
         pwc_columnInfo_target.setSqscale(targetpwcsqscale);
      }

      if (targetpwcdateformat != null && !targetpwcdateformat.equals("") && pwc_config.getWriteMode() == 1) {
         pwc_columnInfo_target.setDateTimeFormat(targetpwcdateformat);
      }

      return pwc_columnInfo_target;
   }

   public ColumnInfo getPwc_columnInfo_source(Map map) {
      ColumnInfo columnInfo = this.getPwc_columnInfo_source_all_base(map);
      return columnInfo;
   }

   public List<StringBuffer> SynViewParam(Connection s_conn, Map map) {
      List<StringBuffer> listProcedure = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;
      ResultSet rss = null;
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchema");
      String sql_user = "select * from information_schema.views t where t.table_schema ='" + sourceSchemaName + "'";

      try {
         ps = s_conn.prepareStatement(sql_user);
         rss = ps.executeQuery();

         while(rss.next()) {
            String sourceViewName = rss.getString("TABLE_NAME");
            String sql = "show create view " + sourceViewName;
            ps = s_conn.prepareStatement(sql);
            rs = ps.executeQuery();

            while(rs.next()) {
               StringBuffer sb = new StringBuffer();
               String string = rs.getString(2);
               String substring = string.substring(0, string.indexOf("VIEW") + 5);
               String substring1 = string.substring(string.indexOf("VIEW") + 5);
               string = substring + targetSchemaName + "." + substring1;
               sb.append(string);
               sb.append(";");
               listProcedure.add(sb);
            }
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listProcedure;
   }

   public String SynConstraintParam(Connection s_conn, Map map) {
      new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchemaName");
      String sql = "show create table  " + map.get("sourceSchemaName") + "." + map.get("tableName");
      String sql1 = "";

      try {
         ps = s_conn.prepareStatement(sql);

         for(rs = ps.executeQuery(); rs.next(); sql = rs.getString(2)) {
         }

         if (sql.indexOf("PARTITION") != -1 && sql.substring(0, sql.indexOf(".")).equals(map.get("sourceSchemaName"))) {
            sql1 = sql.substring(0, sql.toUpperCase().indexOf("USING INDEX PCTFREE")) + ")";
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return sql1;
   }

   public String SynPartition(Connection s_conn, Map map) {
      PreparedStatement ps = null;
      ResultSet rs = null;
      String sql = "show create table  " + map.get("sourceSchemaName") + "." + map.get("tableName");

      try {
         ps = s_conn.prepareStatement(sql);
         rs = ps.executeQuery();
         if (rs.next()) {
            new StringBuffer();
            sql = rs.getString(2);
            if (sql.indexOf("PARTITION") == -1) {
               sql = "false";
            } else {
               sql = sql.substring(sql.indexOf("PARTITION"), sql.length() - 3);
            }
         } else {
            sql = "false";
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return sql;
   }

   public Map TargetParameter_normalEM() {
      return null;
   }
}
