package com.chenyang.nse.bussiness.service.info.db;

import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleFastManage;
import com.power.xml.entity.ColumnInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class SYBASE_IQ extends CommonMethod implements DatabaseTool {
   public static final String sybaseloadname = "sybaseloadtable";
   public static final String sybaseloadmark = "快速导入";
   public static final String[][] exporttype = new String[][]{{"normal", "正常导出", "selected"}};
   public static final String[][] importtype = new String[][]{{"normal", "正常导入", "selected"}, {"sybaseloadtable", "快速导入", ""}};

   public String ImportMethod() {
      StringBuffer targetradio = new StringBuffer();
      List<TConsoleFastManage> list = this.tConsoleFastManageDao.queryAll(new Criterion[]{Restrictions.eq("databasetype", this.getClass().getSimpleName())});
      if (!list.isEmpty()) {
         TConsoleFastManage tConsoleFastManage = (TConsoleFastManage)list.get(0);
         if (tConsoleFastManage.getFastimport() == 0) {
            targetradio.append(MessageFormat.format(this.targetradio(), "'normal'", "正常导出", "selected"));
         } else {
            targetradio.append("<select name='execution_type' >");

            for(String[] radio : importtype) {
               targetradio.append(MessageFormat.format(this.sourceradio(), "'" + radio[0] + "'", radio[1], radio[2]));
            }

            targetradio.append("</select>");
         }
      } else {
         targetradio.append("<select name='execution_type' >");

         for(String[] radio : importtype) {
            targetradio.append(MessageFormat.format(this.sourceradio(), "'" + radio[0] + "'", radio[1], radio[2]));
         }

         targetradio.append("</select>");
      }

      return targetradio.toString();
   }

   public String ExportMethod() {
      StringBuffer sourceradio = new StringBuffer();
      sourceradio.append("<select name='execution_type' >");

      for(String[] radio : exporttype) {
         sourceradio.append(MessageFormat.format(this.sourceradio(), "'" + radio[0] + "'", radio[1], radio[2]));
      }

      sourceradio.append("</select>");
      return sourceradio.toString();
   }

   public Map TargetParameter_normal() {
      Map<String, String> map = this.TargetParameter_fnormal();
      map.put("targetParameter", this.isrebuild() + this.isindex() + this.isprimary() + this.istrigger() + this.isfunction());
      return map;
   }

   public Map TargetParameter_normal1() {
      Map<String, String> map = this.TargetParameter_fnormal();
      map.put("targetParameter", this.isrebuild() + this.isindex() + this.isprimary() + this.istrigger() + this.isfunction());
      return map;
   }

   public String loadscripttype() {
      return "<label><input style ='display:none;' name='loadscripttype' id='loadscripttype' value='loadscripttype'/></label>";
   }

   public Map TargetParameter_notNormal() {
      Map<String, String> map = new HashMap();
      map.put("targetParameter", this.isrebuild() + this.isindex() + this.isprimary());
      map.put("load_script_type", this.loadscripttype());
      return map;
   }

   public List<StringBuffer> SynTriggersParam(Connection s_conn, Map map) {
      List<StringBuffer> listTriggers = new ArrayList();
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchema");
      PreparedStatement ps = null;
      ResultSet rs = null;
      String sql = "  select syscomments.id,syscomments.text from syscomments,sysobjects,sysuserperm where  sysobjects.uid = sysuserperm.user_id and sysobjects.type='TR'   and syscomments.id= sysobjects.id  and sysuserperm.user_name = '" + sourceSchemaName + "'\tORDER by syscomments.id,syscomments.colid";
      HashMap<String, String> hashmap = new HashMap();

      try {
         ps = s_conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            String text = hashmap.get(rs.getString("id")) == null ? "" : (String)hashmap.get(rs.getString("id"));
            hashmap.put(rs.getString("id"), text + rs.getString("text"));
         }

         Iterator iter = hashmap.entrySet().iterator();

         while(iter.hasNext()) {
            StringBuffer sb = new StringBuffer();
            Map.Entry entry = (Map.Entry)iter.next();
            String sql_val = (String)entry.getValue();
            sb.append(sql_val.replaceAll(sourceSchemaName, targetSchemaName));
            listTriggers.add(sb);
            System.out.println(sb.toString());
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listTriggers;
   }

   public List<StringBuffer> SynFunctionParam(Connection s_conn, Map map) {
      List<StringBuffer> listTriggers = new ArrayList();
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchema");
      PreparedStatement ps = null;
      ResultSet rs = null;
      String sql = "  select syscomments.id,syscomments.text from syscomments,sysobjects,sysuserperm where  sysobjects.uid = sysuserperm.user_id and sysobjects.type='SF'   and syscomments.id= sysobjects.id  and sysuserperm.user_name = '" + sourceSchemaName + "'\tORDER by syscomments.id,syscomments.colid";
      HashMap<String, String> hashmap = new HashMap();

      try {
         ps = s_conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            String text = hashmap.get(rs.getString("id")) == null ? "" : (String)hashmap.get(rs.getString("id"));
            hashmap.put(rs.getString("id"), text + rs.getString("text"));
         }

         Iterator iter = hashmap.entrySet().iterator();

         while(iter.hasNext()) {
            StringBuffer sb = new StringBuffer();
            Map.Entry entry = (Map.Entry)iter.next();
            String sql_val = (String)entry.getValue();
            sb.append(sql_val.replaceAll(sourceSchemaName, targetSchemaName));
            listTriggers.add(sb);
            System.out.println(sb.toString());
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listTriggers;
   }

   public List<StringBuffer> SynProcedureParam(Connection s_conn, Map map) {
      List<StringBuffer> listTriggers = new ArrayList();
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchema");
      PreparedStatement ps = null;
      ResultSet rs = null;
      String sql = "  select syscomments.id,syscomments.text from syscomments,sysobjects,sysuserperm where  sysobjects.uid = sysuserperm.user_id and sysobjects.type='P'   and syscomments.id= sysobjects.id  and sysuserperm.user_name = '" + sourceSchemaName + "'\tORDER by syscomments.id,syscomments.colid";
      HashMap<String, String> hashmap = new HashMap();

      try {
         ps = s_conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            String text = hashmap.get(rs.getString("id")) == null ? "" : (String)hashmap.get(rs.getString("id"));
            hashmap.put(rs.getString("id"), text + rs.getString("text"));
         }

         Iterator iter = hashmap.entrySet().iterator();

         while(iter.hasNext()) {
            StringBuffer sb = new StringBuffer();
            Map.Entry entry = (Map.Entry)iter.next();
            String sql_val = (String)entry.getValue();
            sb.append(sql_val.replaceAll(sourceSchemaName, targetSchemaName));
            listTriggers.add(sb);
            System.out.println(sb.toString());
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listTriggers;
   }

   public ColumnInfo getPwc_columnInfo_target(Map map) {
      ColumnInfo columnInfo = this.getPwc_columnInfo_target_all_base(map);
      return columnInfo;
   }

   public ColumnInfo getPwc_columnInfo_source(Map map) {
      ColumnInfo columnInfo = this.getPwc_columnInfo_source_all_base(map);
      return columnInfo;
   }

   public List<StringBuffer> SynViewParam(Connection srcconn, Map map) {
      return null;
   }

   public String SynConstraintParam(Connection srcconn, Map map) {
      return null;
   }

   public String SynPartition(Connection s_conn, Map map) {
      return null;
   }

   public Map TargetParameter_normalEM() {
      return null;
   }
}
