package com.chenyang.nse.bussiness.service.info.tool;

import com.chenyang.nse.bussiness.dao.core.EngineDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemengineDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreEngineDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingDetailrecordDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingRuleinfoDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingTaskrecordDao;
import com.chenyang.nse.bussiness.dao.table.core.maskingself.TCoreMaskingselfFileDao;
import com.chenyang.nse.bussiness.dao.table.core.maskingself.TCoreMaskingselfFilecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.maskingself.TCoreMaskingselfTableDao;
import com.chenyang.nse.bussiness.dao.table.core.maskingself.TCoreMaskingselfTablecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.maskingself.TCoreMaskingselfTaskDao;
import com.chenyang.nse.bussiness.dao.table.core.temporary.TCoreMonitorTemporaryDao;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.DIServiceInfo;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.DataIntegrationInterface;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.DataIntegrationService;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.Fault;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.GetSessionStatisticsRequest;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.LoginRequest;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.SessionHeader;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.SessionStatistics;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.VoidRequest;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.WorkflowRequest;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.FOLDER;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.POWERMART;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.REPOSITORY;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.isomerdata.MakeIsomerUtil;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.maskdata.ParamBean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.CommonBean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.FlatFileBean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.MappingPramaBean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.MappletMakeDatabean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.ModifyImportFile;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.SourceBean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.TargetBean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.InfoExecUtil;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.ToObjutil;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystemengine;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingDetailrecord;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRuleinfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTaskrecord;
import com.chenyang.nse.bussiness.entity.orm.table.core.maskingself.TCoreMaskingselfFile;
import com.chenyang.nse.bussiness.entity.orm.table.core.maskingself.TCoreMaskingselfFilecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.maskingself.TCoreMaskingselfTable;
import com.chenyang.nse.bussiness.entity.orm.table.core.maskingself.TCoreMaskingselfTablecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.maskingself.TCoreMaskingselfTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.temporary.TCoreMonitorTemporary;
import com.chenyang.nse.bussiness.service.info.InfoSelfService;
import com.chenyang.nse.bussiness.service.info.impl.InfoServiceImpl;
import com.chenyang.nse.bussiness.tools.datatime.DateTimeTool;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.Holder;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@EnableAsync
@Transactional
public class InfoSelfToolImpl implements InfoSelfTool {
   private static Logger logger = LoggerFactory.getLogger(InfoSelfToolImpl.class);
   @Autowired
   private TCoreMaskingselfTaskDao tCoreMaskingselfTaskDao;
   @Autowired
   private TCoreMaskingselfTableDao tCoreMaskingselfTableDao;
   @Autowired
   private TCoreMaskingselfTablecolumnDao tCoreMaskingselfTablecolumnDao;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   private TCoreEngineDao tCoreEngineDao;
   @Autowired
   private EngineDao engineDao;
   @Autowired
   private TCoreMaskingselfFileDao tCoreMaskingselfFileDao;
   @Autowired
   private TCoreMaskingselfFilecolumnDao tCoreMaskingselfFilecolumnDao;
   @Autowired
   private TCoreDatasystemengineDao tCoreDatasystemengineDao;
   @Autowired
   private TCoreMaskingRuleinfoDao tCoreMaskingRuleinfoDao;
   @Autowired
   private TCoreMonitorTemporaryDao tCoreMonitorTemporaryDao;
   @Autowired
   private InfoTool infoTool;
   @Autowired
   private ToObjutil toObj;
   @Autowired
   private TCoreMaskingTaskrecordDao tCoreMaskingTaskrecordDao;
   @Autowired
   private TCoreMaskingDetailrecordDao tCoreMaskingDetailrecordDao;
   @Autowired
   private InfoSelfService infoSelfService;

   public boolean importMapping(String taskid, String filename) {
      TCoreMaskingselfTask task = (TCoreMaskingselfTask)this.tCoreMaskingselfTaskDao.get(taskid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      String con_file = InfoServiceImpl.class.getResource("/").getPath().replaceAll("%20", " ") + "infofile" + File.separator + "con_import.xml";
      File file = new File(con_file);
      ModifyImportFile mi = new ModifyImportFile();

      try {
         String path = engine.getXmldir() + File.separator + "masking_self" + File.separator + task.getTaskname() + File.separator + filename + ".xml";
         List<String> filelist = FileTool.getPathFile(path);
         InputStream is = new FileInputStream(path);
         BufferedReader tBufferedReader = new BufferedReader(new InputStreamReader(is));
         int k = 0;
         StringBuffer tStringBuffer = new StringBuffer();
         new String("");

         String sTempOneLine;
         while((sTempOneLine = tBufferedReader.readLine()) != null) {
            ++k;
            if (k == 2) {
               tStringBuffer.append("");
            } else {
               tStringBuffer.append(sTempOneLine);
            }
         }

         ToObjutil var10000 = this.toObj;
         Object obj = ToObjutil.unmarshalmo("com.chenyang.nse.bussiness.engine.infa.basic.xmlbean", tStringBuffer.toString());
         POWERMART powermart = (POWERMART)obj;
         REPOSITORY pre = (REPOSITORY)powermart.getREPOSITORY().get(0);
         FOLDER folder = (FOLDER)pre.getFOLDER().get(0);
         ModifyImportFile.updateConfigFileXML("TARGETFOLDERNAME", file, task.getFdname());
         ModifyImportFile.updateConfigFileXML("SOURCEFOLDERNAME", file, folder.getNAME());
         ModifyImportFile.updateConfigFileXML("TARGETREPOSITORYNAME", file, engine.getRepository());
         ModifyImportFile.updateConfigFileXML("SOURCEREPOSITORYNAME", file, pre.getNAME());
         System.out.println("++++++++start+++++++++++");
         InfoExecUtil.executImport(engine.getPmrepexepath(), path, file.toString(), engine.getXmldir() + File.separator + "log_file" + File.separator + "log.txt");
         System.out.println("++++++++end+++++++++++");
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }

      return Boolean.TRUE;
   }

   public TCoreDatasystemengine getDatasystemEngine(String datasystemid, String engineid) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      List<TCoreDatasystemengine> list = this.tCoreDatasystemengineDao.queryAll(new Criterion[]{Restrictions.eq("datasystemid", datasystemid), Restrictions.eq("engineid", engineid)});
      if (list != null && list.size() > 0) {
         return (TCoreDatasystemengine)list.get(0);
      } else {
         TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(datasystemid);
         TCoreDatasystemengine datasystemEngine = new TCoreDatasystemengine();
         datasystemEngine.setDatasystemid(datasystemid);
         datasystemEngine.setEngineid(engineid);
         datasystemEngine.setId(StringTool.getTablePrimaryKey());
         datasystemEngine.setDblinkname(datasystem.getSysname());
         this.tCoreDatasystemengineDao.save(datasystemEngine);
         datasystemEngine = (TCoreDatasystemengine)this.tCoreDatasystemengineDao.get(datasystemEngine.getId());

         try {
            if ("UTF-8".equals(datasystem.getPagecode())) {
               if (datasystem.getConnectmode().equals("0")) {
                  InfoExecUtil.createDb(engine.getPmrepexepath(), datasystem.getDbtype(), datasystem.getUsername(), "1".equals(datasystem.getFlag()) ? AesTool.decrypt(datasystem.getPassword(), "ghca") : datasystem.getPassword(), datasystem.getDblinkname(), datasystem.getDblinkname(), "UTF-8");
               } else {
                  InfoExecUtil.createDb(engine.getPmrepexepath(), "ODBC", datasystem.getUsername(), "1".equals(datasystem.getFlag()) ? AesTool.decrypt(datasystem.getPassword(), "ghca") : datasystem.getPassword(), datasystem.getDblinkname(), datasystem.getDblinkname(), "UTF-8");
               }
            } else if (datasystem.getConnectmode().equals("0")) {
               InfoExecUtil.createDb(engine.getPmrepexepath(), datasystem.getDbtype(), datasystem.getUsername(), "1".equals(datasystem.getFlag()) ? AesTool.decrypt(datasystem.getPassword(), "ghca") : datasystem.getPassword(), datasystem.getDblinkname(), datasystem.getDblinkname(), "MS936");
            } else {
               InfoExecUtil.createDb(engine.getPmrepexepath(), "ODBC", datasystem.getUsername(), "1".equals(datasystem.getFlag()) ? AesTool.decrypt(datasystem.getPassword(), "ghca") : datasystem.getPassword(), datasystem.getDblinkname(), datasystem.getDblinkname(), "MS936");
            }
         } catch (Exception e) {
            e.printStackTrace();
         }

         return datasystemEngine;
      }
   }

   public void executeTaskMasking(TCoreMaskingselfTask task, String name, String userid) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);

      try {
         InfoExecUtil.executWorkflow(engine.getPmcmdexepath(), task.getFdname(), engine.getInteservicename(), engine.getDomainname(), engine.getUsername(), engine.getPassword(), "wf_" + name);
      } catch (Exception e1) {
         e1.printStackTrace();
      }

      try {
         Thread.sleep(5000L);
      } catch (InterruptedException e) {
         e.printStackTrace();
      }

      this.infoTool.quartzself(task, engine, name, userid);
   }

   @Async
   public void execInsertTaskBtoF(TCoreMaskingselfTask task, String souName, String fileId, String userId) {
      try {
         Map<String, String> dataFtoB = this.generateInsertTaskFtoB(task, userId, fileId);
         dataFtoB.put("userId", userId);
         dataFtoB.put("startTime", DateTimeTool.getDateString(new Date()));
         String soName = (String)dataFtoB.get("soName");
         TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
         Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
         InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
         File file = new File(engine.getXmldir() + File.separator + "tempfile" + File.separator + soName + ".txt");
         FileOutputStream fos = new FileOutputStream(file);
         fos.close();
         String folderName = task.getFdname();
         String workflowName = "wf_" + souName;
         InfoExecUtil.executWorkflow(engine.getPmcmdexepath(), folderName, engine.getInteservicename(), engine.getDomainname(), engine.getUsername(), engine.getPassword(), workflowName);
         Thread.sleep(2000L);
         DataIntegrationInterface webService = (new DataIntegrationService()).getDataIntegration();
         LoginRequest loginRequest = new LoginRequest();
         loginRequest.setRepositoryDomainName(engine.getDomainname());
         loginRequest.setRepositoryName(engine.getRepository());
         loginRequest.setUserName(engine.getUsername());
         loginRequest.setPassword(engine.getPassword());
         String sessionId = webService.login(loginRequest, (Holder)null);
         SessionHeader sessionHeader = new SessionHeader();
         sessionHeader.setSessionId(sessionId);
         DIServiceInfo dIServiceInfo = new DIServiceInfo();
         dIServiceInfo.setDomainName(engine.getDomainname());
         dIServiceInfo.setServiceName(engine.getInteservicename());
         WorkflowRequest workflowRequest = new WorkflowRequest();
         workflowRequest.setDIServiceInfo(dIServiceInfo);
         workflowRequest.setFolderName(folderName);
         workflowRequest.setWorkflowName(workflowName);
         this.execInsertTaskFtoB(task, engine, dataFtoB, workflowRequest, sessionHeader);
      } catch (Exception e1) {
         e1.printStackTrace();
         logger.error("本库脱敏 - 插入模式 - 库to文件方法 - 错误");
      }

   }

   public Map<String, String> generateInsertTaskFtoB(TCoreMaskingselfTask task, String userid, String filesysid) throws Exception {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      TCoreMaskingselfFile tfile = (TCoreMaskingselfFile)this.tCoreMaskingselfFileDao.get(filesysid);
      TCoreMaskingselfTable tentity = (TCoreMaskingselfTable)this.tCoreMaskingselfTableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("mappingkey", tfile.getMappingkey()), Restrictions.eq("datadirection", "1")});
      TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(tentity.getDatasystemid());
      ParamBean par_bean = new ParamBean();
      SourceBean sou_bean = new SourceBean();
      TargetBean tar_bean = new TargetBean();
      FlatFileBean flatfile = new FlatFileBean();
      if ("utf-8".equalsIgnoreCase(datasystem.getPagecode())) {
         flatfile.setCodepage("UTF-8");
      } else if ("GBK".equalsIgnoreCase(datasystem.getPagecode())) {
         flatfile.setCodepage("ms936");
      }

      flatfile.setSkiprows("0");
      flatfile.setDelimited("YES");
      flatfile.setDelimiters("||");
      flatfile.setMultidelimitersasand("YES");
      flatfile.setQuote_character("DOUBLE");
      flatfile.setRowdelimiter("0");
      flatfile.setEscape_character("");
      flatfile.setKeepescapechar("NO");
      sou_bean.setFilebean(flatfile);
      List<MappletMakeDatabean> mapplet = new ArrayList();
      List<MappingPramaBean> paramList = null;
      sou_bean.setSo_ownname("");
      sou_bean.setBusinessname("");
      sou_bean.setDatabasetype("Flat File");
      sou_bean.setLinkname("");
      sou_bean.setDbdname("");
      sou_bean.setVersionnumber("1");
      sou_bean.setObjectversion("1");
      sou_bean.setDescripion("");
      sou_bean.setSourceownername("");
      sou_bean.setFileparam("1");
      TCoreDatasystem datatarget = (TCoreDatasystem)this.tCoreDatasystemDao.get(tentity.getDatasystemid());
      if ("MYSQL".equals(datatarget.getDbtype())) {
         tar_bean.setLinkname(datatarget.getDblinkname());
         tar_bean.setDbdname(datatarget.getDblinkname());
      } else if ("MSSQLSERVER".equals(datatarget.getDbtype())) {
         tar_bean.setLinkname(datatarget.getDblinkname());
         tar_bean.setDbdname(datatarget.getDblinkname());
      } else if ("INFORMIX".equals(datatarget.getDbtype())) {
         tar_bean.setLinkname(datatarget.getDblinkname());
         tar_bean.setDbdname(datatarget.getDblinkname());
      } else if ("SYBASE".equals(datatarget.getDbtype())) {
         tar_bean.setLinkname(datatarget.getDblinkname());
         tar_bean.setDbdname(datatarget.getDblinkname());
      } else {
         this.getDatasystemEngine(datatarget.getId(), task.getEngineid());
         tar_bean.setLinkname(datatarget.getDblinkname());
         tar_bean.setDbdname(datatarget.getDblinkname());
      }

      tar_bean.setTar_name(tentity.getTablename());
      tar_bean.setBusinessname("");
      tar_bean.setConstraint("");
      tar_bean.setDatabasetype(datatarget.getDbtype());
      tar_bean.setVersionnumber("1");
      tar_bean.setObjectversion("1");
      tar_bean.setDescripion("");
      tar_bean.setTargetownername(tentity.getDbschema());
      tar_bean.setInserttype("insert");
      tar_bean.setTranctype("YES");
      tar_bean.setConnectmode(datatarget.getConnectmode());
      List<TCoreMaskingselfFilecolumn> filecolumnlist = this.tCoreMaskingselfFilecolumnDao.queryAll(Order.asc("columnindex"), new Criterion[]{Restrictions.eq("fileid", tfile.getId())});
      CommonBean cb = new CommonBean();
      List<String> keytype = new ArrayList();
      List<String> nameList = new ArrayList();
      List<String> typeList = new ArrayList();
      List<String> lengthList = new ArrayList();
      List<String> precisionList = new ArrayList();
      List<String> scalelist = new ArrayList();
      List<String> formatlist = new ArrayList();
      CommonBean tcb = new CommonBean();
      List<String> tkeytype = new ArrayList();
      List<String> tnameList = new ArrayList();
      List<String> ttypeList = new ArrayList();
      List<String> tlengthList = new ArrayList();
      List<String> tprecisionList = new ArrayList();
      List<String> tscalelist = new ArrayList();
      List<String> judgelist = new ArrayList();

      for(TCoreMaskingselfFilecolumn ckj : filecolumnlist) {
         keytype.add("NOT A KEY");
         nameList.add(ckj.getColumnname());
         typeList.add(ckj.getColumntype());
         lengthList.add(ckj.getColumnaccuracy());
         scalelist.add(ckj.getColumndecimal());
         precisionList.add(ckj.getColumnaccuracy());
         if ("datetime".equalsIgnoreCase(ckj.getColumnname())) {
            formatlist.add("F  29 YYYY-MM-DD");
         } else {
            formatlist.add("");
         }

         cb.setKeytype(keytype);
         cb.setLengthList(lengthList);
         cb.setNameList(nameList);
         cb.setPrecisionList(precisionList);
         cb.setScalelist(scalelist);
         cb.setTypeList(typeList);
         cb.setDateformatlist(formatlist);
         sou_bean.setCb(cb);
         TCoreMaskingselfTablecolumn tablecolumn = (TCoreMaskingselfTablecolumn)this.tCoreMaskingselfTablecolumnDao.queryUnique(new Criterion[]{Restrictions.eq("mappingkey", ckj.getMappingkey()), Restrictions.eq("datadirection", "1"), Restrictions.eq("taskid", task.getId())});
         if ("1".equals(tablecolumn.getPrimarykey())) {
            tkeytype.add("PRIMARY KEY");
         } else {
            tkeytype.add("NOT A KEY");
         }

         tnameList.add(tablecolumn.getColumnname());
         ttypeList.add(tablecolumn.getColumntype());
         tlengthList.add(tablecolumn.getColumnlength());
         tscalelist.add(tablecolumn.getColumnscale());
         tprecisionList.add(tablecolumn.getColumnlength());
         judgelist.add(tablecolumn.getJudgenull());
         tcb.setKeytype(tkeytype);
         tcb.setLengthList(lengthList);
         tcb.setNameList(tnameList);
         tcb.setPrecisionList(tprecisionList);
         tcb.setScalelist(tscalelist);
         tcb.setTypeList(ttypeList);
         tcb.setJudgelist(judgelist);
         if (ckj.getRuleid() != null && !"".equals(ckj.getRuleid())) {
            TCoreMaskingRuleinfo rule = (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.queryUnique(new Criterion[]{Restrictions.eq("ruleid", ckj.getRuleid())});
            if (rule != null) {
               mapplet.add(new MappletMakeDatabean(ckj.getColumnname(), rule.getMappletname(), tablecolumn.getColumnname()));
            }
         }

         tar_bean.setCb(tcb);
      }

      par_bean.setTaskname(task.getTaskname());
      par_bean.setFoldername(task.getFdname());
      par_bean.setOwner("");
      par_bean.setGroup("");
      par_bean.setParam_path("");
      par_bean.setPower_repository_version("184.93");
      par_bean.setCodepage("UTF-8");
      par_bean.setRepository_version("184");
      sou_bean.setIsftp("0");
      sou_bean.setFilename("f_" + tentity.getTablename() + ".txt");
      sou_bean.setFilepath(info.getXmldir() + File.separator + "tempfile" + File.separator);
      sou_bean.setFiledirect("Direct");
      sou_bean.setSo_name("f_" + tentity.getTablename());
      TCoreDatasystem repdata = (TCoreDatasystem)this.tCoreDatasystemDao.get(info.getDatasystemid());
      if ("ORACLE".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Oracle");
      } else if ("DB2".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Db2");
      }

      par_bean.setShard("NOTSHARED");
      MakeIsomerUtil.isomerMasking(par_bean, info, sou_bean, tar_bean, mapplet, paramList, "self");
      this.importMapping(task.getId(), sou_bean.getSo_name());
      Map<String, String> reMap = new HashMap();
      reMap.put("soName", sou_bean.getSo_name());
      reMap.put("tarName", tar_bean.getTar_name());
      reMap.put("dataSystemId", tentity.getDatasystemid());
      reMap.put("schema", tentity.getDbschema());
      return reMap;
   }

   public void execInsertTaskFtoB(TCoreMaskingselfTask task, InfoProperty engine, Map<String, String> dataFtoB, WorkflowRequest workflowRequest, SessionHeader sessionHeader) {
      DataIntegrationInterface webService = null;

      try {
         webService = (new DataIntegrationService()).getDataIntegration();
         webService.waitTillWorkflowComplete(workflowRequest, sessionHeader);
      } catch (Fault var28) {
         System.out.println("本库脱敏 - 插入模式 - （库 -> 文件） - 执行等待webservice前完成");
      }

      String tarName = (String)dataFtoB.get("tarName");
      String userId = (String)dataFtoB.get("userId");
      String soName = (String)dataFtoB.get("soName");
      String folderName = workflowRequest.getFolderName();
      String workflowName = "wf_" + soName;
      String instanceName = "s_M_mp_" + soName;
      workflowRequest.setWorkflowName(workflowName);
      workflowRequest.setWorkflowRunInstanceName(instanceName);

      try {
         InfoExecUtil.executWorkflow(engine.getPmcmdexepath(), folderName, engine.getInteservicename(), engine.getDomainname(), engine.getUsername(), engine.getPassword(), workflowName);
         TCoreMonitorTemporary temporay = new TCoreMonitorTemporary();
         temporay.setCreatetime(new Date());
         temporay.setSourcename(tarName);
         temporay.setTargetname(tarName);
         temporay.setTaskid(task.getId());
         temporay.setType("本库脱敏");
         temporay.setWfname(soName);
         this.tCoreMonitorTemporaryDao.save(temporay);
         Thread.sleep(2000L);
         webService.waitTillWorkflowComplete(workflowRequest, sessionHeader);
      } catch (Fault var26) {
         System.out.println("本库脱敏 - 插入模式 - （文件 -> 库） - 执行等待webservice前完成");
      } catch (Exception e) {
         e.printStackTrace();
         logger.error("本库脱敏 - 插入模式 - 执行 文件到库 - 错误");
         this.logoutWebService(sessionHeader);
         return;
      }

      String startTime = (String)dataFtoB.get("startTime");

      try {
         GetSessionStatisticsRequest getSessionStatisticsRequest = new GetSessionStatisticsRequest();
         getSessionStatisticsRequest.setDIServiceInfo(workflowRequest.getDIServiceInfo());
         getSessionStatisticsRequest.setFolderName(folderName);
         getSessionStatisticsRequest.setWorkflowName(workflowName);
         getSessionStatisticsRequest.setTaskInstancePath(instanceName);
         SessionStatistics sessionStatistics = webService.getSessionStatistics(getSessionStatisticsRequest, sessionHeader);
         TCoreMaskingTaskrecord record = new TCoreMaskingTaskrecord();
         record.setTaketime(new Date());
         record.setTaskid(task.getId());
         record.setUserid(userId);
         record.setExeresult(String.valueOf(sessionStatistics.getTaskRunStatus()));
         this.tCoreMaskingTaskrecordDao.save(record);
         TCoreMaskingDetailrecord detail = new TCoreMaskingDetailrecord();
         detail.setSuccessrow(String.valueOf(sessionStatistics.getNumSrcSuccessRows()));
         detail.setFailurerow(String.valueOf(sessionStatistics.getNumSrcFailedRows()));
         detail.setTaskrecordid(record.getId());
         detail.setStarttime(startTime);
         detail.setEndtime(DateTimeTool.getDateString(new Date()));
         detail.setSourceid(tarName);
         detail.setTargetid(tarName);
         this.tCoreMaskingDetailrecordDao.save(detail);
      } catch (Fault e) {
         e.printStackTrace();
         logger.error("本库脱敏 - 插入模式 - webservice获取监控信息 - 错误");
      } finally {
         this.logoutWebService(sessionHeader);
      }

   }

   public void logoutWebService(SessionHeader sessionHeader) {
      try {
         DataIntegrationInterface webService = (new DataIntegrationService()).getDataIntegration();
         webService.logout(new VoidRequest(), sessionHeader);
      } catch (Fault e1) {
         e1.printStackTrace();
      }

   }
}
