package com.chenyang.nse.bussiness.service.key.impl;

import com.datech.DaToSHCA.DaToSHCA;
import com.datech.DaToSHCA.da_handle;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.core.key.TCoreKeyCcoreSdfParameterDao;
import com.chenyang.nse.bussiness.dao.core.key.TCoreKeyCloudSdkParameterDao;
import com.chenyang.nse.bussiness.dao.core.key.TCoreKeyDeAnParameterDao;
import com.chenyang.nse.bussiness.dao.core.key.TCoreKeyKmsParameterDao;
import com.chenyang.nse.bussiness.dao.core.key.TCoreKeyQuantumParameterDao;
import com.chenyang.nse.bussiness.dao.core.key.TCoreKeySdkParameterDao;
import com.chenyang.nse.bussiness.dao.core.key.TCoreKeyThKmsParameterDao;
import com.chenyang.nse.bussiness.dao.core.key.TCoreKeyTypeManagementDao;
import com.chenyang.nse.bussiness.encryptor.service.impl.TCoreEncryptionServiceSdkImpl;
import com.chenyang.nse.bussiness.entity.orm.table.core.key.TCoreKeyCcoreSdfParameter;
import com.chenyang.nse.bussiness.entity.orm.table.core.key.TCoreKeyCloudSdkParameter;
import com.chenyang.nse.bussiness.entity.orm.table.core.key.TCoreKeyDeAnParameter;
import com.chenyang.nse.bussiness.entity.orm.table.core.key.TCoreKeyKmsParameter;
import com.chenyang.nse.bussiness.entity.orm.table.core.key.TCoreKeyQuantumParameter;
import com.chenyang.nse.bussiness.entity.orm.table.core.key.TCoreKeySdkParameter;
import com.chenyang.nse.bussiness.entity.orm.table.core.key.TCoreKeyThKmsParameter;
import com.chenyang.nse.bussiness.entity.orm.table.core.key.TCoreKeyTypeManagement;
import com.chenyang.nse.bussiness.entity.vo.key.TCoreKeyTypeManagementVO;
import com.chenyang.nse.bussiness.kms.model.Kms;
import com.chenyang.nse.bussiness.kms.service.KmsService;
import com.chenyang.nse.bussiness.kms.service.SanWeiKmsService;
import com.chenyang.nse.bussiness.service.core.encryption.TCoreEncryptionService;
import com.chenyang.nse.bussiness.service.key.KeyManagerService;
import com.chenyang.nse.bussiness.thkms.service.ThKmsService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import kl.hsm.client.sdk.HsmSdk;
import org.apache.commons.lang3.StringUtils;
import org.apache.thrift.TException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KeyManagerServiceImpl implements KeyManagerService {
   private static final String ONE = "1";
   private static final String LOCAL_CODE = "1";
   private static final String SDK_CODE = "2";
   private static final String CLOUD_SDK_CODE = "3";
   private static final String C_CORE_SDF_CODE = "4";
   private static final String KMS_CODE = "5";
   private static final String TH_KMS_CODE = "6";
   private static final String DE_AN_CODE = "7";
   private static final String SAN_WEI_CODE = "8";
   private static final String QUANTUM_CODE = "9";
   private static String SCHEMA = "encryption";
   private static Properties props = null;
   private static final int LENGTH = 16;
   public static da_handle tmpHandle = new da_handle();
   public static DaToSHCA tmpTest = new DaToSHCA();
   @Autowired
   private TCoreKeyTypeManagementDao tCoreKeyTypeManagementDao;
   @Autowired
   private JdbcTemplate jdbcTemplate;
   @Autowired
   private TCoreKeyCcoreSdfParameterDao tCoreKeyCcoreSdfParameterDao;
   @Autowired
   private TCoreKeyCloudSdkParameterDao tCoreKeyCloudSdkParameterDao;
   @Autowired
   private TCoreKeyKmsParameterDao tCoreKeyKmsParameterDao;
   @Autowired
   private TCoreKeySdkParameterDao tCoreKeySdkParameterDao;
   @Autowired
   private TCoreKeyThKmsParameterDao tCoreKeyThKmsParameterDao;
   @Autowired
   private TCoreKeyDeAnParameterDao tCoreKeyDeAnParameterDao;
   @Autowired
   private TCoreKeyQuantumParameterDao tCoreKeyQuantumParameterDao;
   @Autowired
   Map<String, TCoreEncryptionService> tCoreEncryptionMap;
   @Autowired
   protected KmsService kmsService;
   @Autowired
   protected ThKmsService thKmsService;
   @Autowired
   protected SanWeiKmsService sanWeiKmsService;

   public List<TCoreKeyTypeManagementVO> queryTCoreKeyTypeManagementList() throws InvocationTargetException, IllegalAccessException {
      List<TCoreKeyTypeManagement> tCoreKeyTypeManagements = this.tCoreKeyTypeManagementDao.queryAll();
      return (List)tCoreKeyTypeManagements.stream().map((t) -> {
         TCoreKeyTypeManagementVO tCoreKeyTypeManagementVO = new TCoreKeyTypeManagementVO();
         BeanUtils.copyProperties(t, tCoreKeyTypeManagementVO);
         return tCoreKeyTypeManagementVO;
      }).collect(Collectors.toList());
   }

   public TCoreKeyTypeManagementVO queryTCoreKeyTypeManageUsed() {
      TCoreKeyTypeManagement tCoreKeyTypeManagement = (TCoreKeyTypeManagement)this.tCoreKeyTypeManagementDao.queryUnique(new Criterion[]{Restrictions.eq("isuse", "1")});
      TCoreKeyTypeManagementVO tCoreKeyTypeManagementVO = new TCoreKeyTypeManagementVO();
      if (Objects.isNull(tCoreKeyTypeManagement)) {
         return tCoreKeyTypeManagementVO;
      } else {
         BeanUtils.copyProperties(tCoreKeyTypeManagement, tCoreKeyTypeManagementVO);
         return tCoreKeyTypeManagementVO;
      }
   }

   public void batchUpdateIsUseStop() {
      this.jdbcTemplate.update("update " + SCHEMA + ".t_core_key_type_management set isuse = 0 ");
   }

   @Transactional(
      rollbackFor = {SQLException.class}
   )
   public void setIsUseStart(String typeId) {
      this.batchUpdateIsUseStop();
      this.jdbcTemplate.update("update " + SCHEMA + ".t_core_key_type_management set isuse = 1 WHERE typeid = ? ", new Object[]{typeId});
   }

   public boolean saveParameter(Map<String, Object> map) {
      String typeId = (String)map.get("typeid");
      String userName = CommonUtils.loginUsername();
      switch (typeId) {
         case "1":
         default:
            break;
         case "2":
            if (this.ObjectIsEmpty(map.get("hsmfiledir")) || this.ObjectIsEmpty(map.get("sdkpassword"))) {
               return false;
            }

            TCoreKeySdkParameter tCoreKeySdkParameter = (TCoreKeySdkParameter)ObjectTool.getObjectByMap(TCoreKeySdkParameter.class, map);
            if (StringUtils.isEmpty(tCoreKeySdkParameter.getId())) {
               tCoreKeySdkParameter.setId(StringTool.getTablePrimaryKey());
               tCoreKeySdkParameter.setCreateuser(userName);
               tCoreKeySdkParameter.setCreatetime(new Date());
               this.tCoreKeySdkParameterDao.save(tCoreKeySdkParameter);
            } else {
               tCoreKeySdkParameter.setUpdateuser(userName);
               tCoreKeySdkParameter.setUpdatetime(new Date());
               this.tCoreKeySdkParameterDao.update(tCoreKeySdkParameter);
            }
            break;
         case "3":
            if (this.ObjectIsEmpty(map.get("sdkkeyid")) || this.ObjectIsEmpty(map.get("sdkpassword")) || this.ObjectIsEmpty(map.get("hsmfiledir")) || this.ObjectIsEmpty(map.get("keystoredir")) || this.ObjectIsEmpty(map.get("truststoredir"))) {
               return false;
            }

            TCoreKeyCloudSdkParameter tCoreKeyCloudSdkParameter = (TCoreKeyCloudSdkParameter)ObjectTool.getObjectByMap(TCoreKeyCloudSdkParameter.class, map);
            if (StringUtils.isEmpty(tCoreKeyCloudSdkParameter.getId())) {
               tCoreKeyCloudSdkParameter.setId(StringTool.getTablePrimaryKey());
               tCoreKeyCloudSdkParameter.setCreateuser(userName);
               tCoreKeyCloudSdkParameter.setCreatetime(new Date());
               this.tCoreKeyCloudSdkParameterDao.save(tCoreKeyCloudSdkParameter);
            } else {
               tCoreKeyCloudSdkParameter.setUpdateuser(userName);
               tCoreKeyCloudSdkParameter.setUpdatetime(new Date());
               this.tCoreKeyCloudSdkParameterDao.update(tCoreKeyCloudSdkParameter);
            }
            break;
         case "4":
            if (this.ObjectIsEmpty(map.get("cphpwd")) || this.ObjectIsEmpty(map.get("ecccipherbits")) || this.ObjectIsEmpty(map.get("ecccipherx")) || this.ObjectIsEmpty(map.get("eccciphery")) || this.ObjectIsEmpty(map.get("ecccipherm")) || this.ObjectIsEmpty(map.get("ecccipherc")) || this.ObjectIsEmpty(map.get("ecccipherl"))) {
               return false;
            }

            TCoreKeyCcoreSdfParameter tCoreKeyCcoreSdfParameter = (TCoreKeyCcoreSdfParameter)ObjectTool.getObjectByMap(TCoreKeyCcoreSdfParameter.class, map);
            if (StringUtils.isEmpty(tCoreKeyCcoreSdfParameter.getId())) {
               tCoreKeyCcoreSdfParameter.setId(StringTool.getTablePrimaryKey());
               tCoreKeyCcoreSdfParameter.setCreateuser(userName);
               tCoreKeyCcoreSdfParameter.setCreatetime(new Date());
               this.tCoreKeyCcoreSdfParameterDao.save(tCoreKeyCcoreSdfParameter);
            } else {
               tCoreKeyCcoreSdfParameter.setUpdateuser(userName);
               tCoreKeyCcoreSdfParameter.setUpdatetime(new Date());
               this.tCoreKeyCcoreSdfParameterDao.update(tCoreKeyCcoreSdfParameter);
            }
            break;
         case "5":
            if (this.ObjectIsEmpty(map.get("credtid")) || this.ObjectIsEmpty(map.get("credaccesskey")) || this.ObjectIsEmpty(map.get("credsecretkey")) || this.ObjectIsEmpty(map.get("crediv")) || this.ObjectIsEmpty(map.get("credprotocol")) || this.ObjectIsEmpty(map.get("credhost")) || this.ObjectIsEmpty(map.get("credport")) || this.ObjectIsEmpty(map.get("keyid")) || this.ObjectIsEmpty(map.get("keyspec")) || this.ObjectIsEmpty(map.get("keyusage")) || this.ObjectIsEmpty(map.get("origin")) || this.ObjectIsEmpty(map.get("protectionlevel"))) {
               return false;
            }

            TCoreKeyKmsParameter tCoreKeyKmsParameter = (TCoreKeyKmsParameter)ObjectTool.getObjectByMap(TCoreKeyKmsParameter.class, map);
            if (StringUtils.isEmpty(tCoreKeyKmsParameter.getId())) {
               tCoreKeyKmsParameter.setId(StringTool.getTablePrimaryKey());
               tCoreKeyKmsParameter.setCreateuser(userName);
               tCoreKeyKmsParameter.setCreatetime(new Date());
               this.tCoreKeyKmsParameterDao.save(tCoreKeyKmsParameter);
            } else {
               tCoreKeyKmsParameter.setUpdateuser(userName);
               tCoreKeyKmsParameter.setUpdatetime(new Date());
               this.tCoreKeyKmsParameterDao.update(tCoreKeyKmsParameter);
            }
            break;
         case "6":
            if (this.ObjectIsEmpty(map.get("protocol")) || this.ObjectIsEmpty(map.get("thhost")) || this.ObjectIsEmpty(map.get("thport")) || this.ObjectIsEmpty(map.get("appid")) || this.ObjectIsEmpty(map.get("keyid")) || this.ObjectIsEmpty(map.get("keystoredir")) || this.ObjectIsEmpty(map.get("truststoredir")) || this.ObjectIsEmpty(map.get("requesttimeout")) || this.ObjectIsEmpty(map.get("connecttimeout")) || this.ObjectIsEmpty(map.get("sockettimeout"))) {
               return false;
            }

            TCoreKeyThKmsParameter tCoreKeyThKmsParameter = (TCoreKeyThKmsParameter)ObjectTool.getObjectByMap(TCoreKeyThKmsParameter.class, map);
            if (StringUtils.isEmpty(tCoreKeyThKmsParameter.getId())) {
               tCoreKeyThKmsParameter.setId(StringTool.getTablePrimaryKey());
               tCoreKeyThKmsParameter.setCreateuser(userName);
               tCoreKeyThKmsParameter.setCreatetime(new Date());
               this.tCoreKeyThKmsParameterDao.save(tCoreKeyThKmsParameter);
            } else {
               tCoreKeyThKmsParameter.setUpdateuser(userName);
               tCoreKeyThKmsParameter.setUpdatetime(new Date());
               this.tCoreKeyThKmsParameterDao.update(tCoreKeyThKmsParameter);
            }
            break;
         case "7":
            if (this.ObjectIsEmpty(map.get("ip")) || this.ObjectIsEmpty(map.get("port")) || this.ObjectIsEmpty(map.get("password")) || this.ObjectIsEmpty(map.get("salg")) || this.ObjectIsEmpty(map.get("keynum"))) {
               return false;
            }

            TCoreKeyDeAnParameter tCoreKeyDeAnParameter = (TCoreKeyDeAnParameter)ObjectTool.getObjectByMap(TCoreKeyDeAnParameter.class, map);
            if (StringUtils.isEmpty(tCoreKeyDeAnParameter.getId())) {
               tCoreKeyDeAnParameter.setId(StringTool.getTablePrimaryKey());
               tCoreKeyDeAnParameter.setCreateuser(userName);
               tCoreKeyDeAnParameter.setCreatetime(new Date());
               this.tCoreKeyDeAnParameterDao.save(tCoreKeyDeAnParameter);
            } else {
               tCoreKeyDeAnParameter.setUpdateuser(userName);
               tCoreKeyDeAnParameter.setUpdatetime(new Date());
               this.tCoreKeyDeAnParameterDao.update(tCoreKeyDeAnParameter);
            }
            break;
         case "9":
            if (this.ObjectIsEmpty(map.get("zdxlzjcedir"))) {
               return false;
            }

            TCoreKeyQuantumParameter tCoreKeyQuantumParameter = (TCoreKeyQuantumParameter)ObjectTool.getObjectByMap(TCoreKeyQuantumParameter.class, map);
            if (StringUtils.isEmpty(tCoreKeyQuantumParameter.getId())) {
               tCoreKeyQuantumParameter.setId(StringTool.getTablePrimaryKey());
               tCoreKeyQuantumParameter.setCreateuser(userName);
               tCoreKeyQuantumParameter.setCreatetime(new Date());
               this.tCoreKeyQuantumParameterDao.save(tCoreKeyQuantumParameter);
            } else {
               tCoreKeyQuantumParameter.setUpdateuser(userName);
               tCoreKeyQuantumParameter.setUpdatetime(new Date());
               this.tCoreKeyQuantumParameterDao.update(tCoreKeyQuantumParameter);
            }
      }

      return true;
   }

   public Map<String, String> createParam(String cphpwd) {
      return CcoreSdfParam.createParam(cphpwd);
   }

   public Map<String, String> showKeyParams(String typeId) {
      try {
         switch (typeId) {
            case "1":
               break;
            case "2":
               TCoreKeySdkParameter tCoreKeySdkParameter = (TCoreKeySdkParameter)this.tCoreKeySdkParameterDao.queryUnique(new Criterion[0]);
               if (Objects.isNull(tCoreKeySdkParameter)) {
                  return org.apache.commons.beanutils.BeanUtils.describe(new TCoreKeySdkParameter());
               }

               return org.apache.commons.beanutils.BeanUtils.describe(tCoreKeySdkParameter);
            case "3":
               TCoreKeyCloudSdkParameter tCoreKeyCloudSdkParameter = (TCoreKeyCloudSdkParameter)this.tCoreKeyCloudSdkParameterDao.queryUnique(new Criterion[0]);
               if (Objects.isNull(tCoreKeyCloudSdkParameter)) {
                  return org.apache.commons.beanutils.BeanUtils.describe(new TCoreKeyCloudSdkParameter());
               }

               return org.apache.commons.beanutils.BeanUtils.describe(tCoreKeyCloudSdkParameter);
            case "4":
               TCoreKeyCcoreSdfParameter tCoreKeyCcoreSdfParameter = (TCoreKeyCcoreSdfParameter)this.tCoreKeyCcoreSdfParameterDao.queryUnique(new Criterion[0]);
               if (Objects.isNull(tCoreKeyCcoreSdfParameter)) {
                  return org.apache.commons.beanutils.BeanUtils.describe(new TCoreKeyCcoreSdfParameter());
               }

               return org.apache.commons.beanutils.BeanUtils.describe(tCoreKeyCcoreSdfParameter);
            case "5":
               TCoreKeyKmsParameter tCoreKeyKmsParameter = (TCoreKeyKmsParameter)this.tCoreKeyKmsParameterDao.queryUnique(new Criterion[0]);
               if (Objects.isNull(tCoreKeyKmsParameter)) {
                  return org.apache.commons.beanutils.BeanUtils.describe(new TCoreKeyKmsParameter());
               }

               return org.apache.commons.beanutils.BeanUtils.describe(tCoreKeyKmsParameter);
            case "6":
               TCoreKeyThKmsParameter tCoreKeyThKmsParameter = (TCoreKeyThKmsParameter)this.tCoreKeyThKmsParameterDao.queryUnique(new Criterion[0]);
               if (Objects.isNull(tCoreKeyThKmsParameter)) {
                  return org.apache.commons.beanutils.BeanUtils.describe(new TCoreKeyThKmsParameter());
               }

               return org.apache.commons.beanutils.BeanUtils.describe(tCoreKeyThKmsParameter);
            case "7":
               TCoreKeyDeAnParameter tCoreKeyDeAnParameter = (TCoreKeyDeAnParameter)this.tCoreKeyDeAnParameterDao.queryUnique(new Criterion[0]);
               if (Objects.isNull(tCoreKeyDeAnParameter)) {
                  return org.apache.commons.beanutils.BeanUtils.describe(new TCoreKeyDeAnParameter());
               }

               return org.apache.commons.beanutils.BeanUtils.describe(tCoreKeyDeAnParameter);
            case "9":
               TCoreKeyQuantumParameter tCoreKeyQuantumParameter = (TCoreKeyQuantumParameter)this.tCoreKeyQuantumParameterDao.queryUnique(new Criterion[0]);
               if (Objects.isNull(tCoreKeyQuantumParameter)) {
                  return org.apache.commons.beanutils.BeanUtils.describe(new TCoreKeyQuantumParameter());
               }

               return org.apache.commons.beanutils.BeanUtils.describe(tCoreKeyQuantumParameter);
            default:
               new HashMap(0);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return new HashMap(0);
   }

   public boolean testCallKey(String typeId) throws TException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
      switch (typeId) {
         case "1":
            return true;
         case "2":
            return this.callSDK();
         case "3":
            return this.callCloudSDK();
         case "4":
            return this.callCcoreSDF();
         case "5":
            return this.callKMS();
         case "6":
            return this.callTHKMS();
         case "7":
            return this.callDeAn();
         case "8":
            return this.callSanWeiKMS();
         case "9":
            return this.callQuantumKMS();
         default:
            return false;
      }
   }

   private boolean callTHKMS() {
      try {
         String key = this.thKmsService.createKey();
         return !StringUtils.isEmpty(key);
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }
   }

   private boolean callDeAn() {
      try {
         Map<String, String> map = this.showKeyParams("7");
         boolean OpenFlag = tmpTest.DA_OpenHsmServer(tmpHandle, (String)map.get("ip"), Integer.parseInt((String)map.get("port")));
         if (OpenFlag) {
            tmpTest.DA_CloseHsmServer(tmpHandle);
         }

         return OpenFlag;
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }
   }

   private boolean callKMS() {
      Map<String, String> map = this.showKeyParams("5");
      if (StringUtils.isEmpty((CharSequence)map.get("credtid"))) {
         return false;
      } else {
         try {
            Kms.Credential.init((String)map.get("credtid"), (String)map.get("credaccesskey"), (String)map.get("credsecretkey"), (String)map.get("crediv"), (String)map.get("credprotocol"), (String)map.get("credhost"), Integer.parseInt((String)map.get("credport")));
            Kms.MasterKey.init((String)map.get("keyid"), (String)map.get("keyspec"), (String)map.get("keyusage"), (String)map.get("origin"), (String)map.get("protectionlevel"));
            String challengeCode = this.kmsService.obtainChallengeCode();
            this.kmsService.obtainAccessToken(challengeCode);
            return true;
         } catch (Exception e) {
            e.printStackTrace();
            return false;
         }
      }
   }

   private boolean callCcoreSDF() {
      return CcoreSdfParam.testCcoreSDF();
   }

   public boolean callSDK() {
      Map<String, String> map = this.showKeyParams("2");
      return this.callCommonSDK((String)map.get("hsmfiledir"));
   }

   public boolean callCommonSDK(String path) {
      if (StringUtils.isBlank(path)) {
         return false;
      } else {
         path = (path.endsWith(File.separator) ? path : path + File.separator) + "HsmConfig.properties";
         StringBuilder sb = new StringBuilder();
         SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
         sb.append(sdf.format(new Date()) + " INFO - 开始执行加密机建立会话获得会话ID校验: \r\n");
         HsmSdk sdk = new HsmSdk();
         Long sessionId = 0L;

         boolean var7;
         try {
            Map<String, String> paramMap = TCoreEncryptionServiceSdkImpl.getParamsFromFile(path);
            sdk.init((String)paramMap.get("ip"), Integer.parseInt((String)paramMap.get("port")), Boolean.parseBoolean((String)paramMap.get("ssl")), (String)paramMap.get("keyStore"), (String)paramMap.get("trustStore"), Integer.parseInt((String)paramMap.get("poolMax")));
            sessionId = sdk.openSession();
            if (null != sessionId && sessionId.toString().length() > 0) {
               sb.append(sdf.format(new Date()) + " INFO - 建立会话获得会话ID成功。\r\n");
            } else {
               sb.append(sdf.format(new Date()) + " ERR - 建立会话获得会话ID失败，会话ID为空\r\n");
            }

            var7 = true;
            return var7;
         } catch (Exception e) {
            sb.append(sdf.format(new Date()) + " ERR - 建立会话获得会话ID失败，异常为：");
            sb.append(e);
            sb.append("。\r\n");
            e.printStackTrace();
            var7 = false;
         } finally {
            if (sessionId > 0L) {
               try {
                  sdk.closeSession(sessionId);
               } catch (TException e) {
                  e.printStackTrace();
               }
            }

         }

         return var7;
      }
   }

   public boolean callCloudSDK() {
      Map<String, String> map = this.showKeyParams("3");
      return this.callCommonSDK((String)map.get("hsmfiledir"));
   }

   public boolean ObjectIsEmpty(Object o) {
      if (Objects.isNull(o)) {
         return true;
      } else {
         return StringUtils.isBlank(o.toString());
      }
   }

   private boolean callSanWeiKMS() {
      try {
         String dataKey = this.sanWeiKmsService.createRandomDataKey(16);
         return !StringUtils.isBlank(dataKey);
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }
   }

   private boolean callQuantumKMS() {
      try {
         String dataKey = ((TCoreEncryptionService)this.tCoreEncryptionMap.get("TCoreEncryptionServiceQuantumImpl")).getRandomValue("SM4_ECB");
         return !StringUtils.isBlank(dataKey);
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }
   }

   static {
      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String schemaTemp = props.getProperty("jdbc.dbname");
         if (!StringUtils.isEmpty(schemaTemp)) {
            SCHEMA = schemaTemp;
         }
      } catch (IOException e) {
         e.printStackTrace();
      }

   }
}
