package com.chenyang.nse.bussiness.thkms.model;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class ThKmsCert {
   private PrivateKey privateKey;
   private X509Certificate cert;
   private String certB64;
   private static boolean initFlag = false;
   private static ThKmsCert instance = null;

   private ThKmsCert(PrivateKey privateKey, X509Certificate cert, String certB64) {
      this.privateKey = privateKey;
      this.cert = cert;
      this.certB64 = certB64;
   }

   public PrivateKey getPrivateKey() {
      return this.privateKey;
   }

   public X509Certificate getCert() {
      return this.cert;
   }

   public String getCertB64() {
      return this.certB64;
   }

   public static synchronized void init(PrivateKey privateKey, X509Certificate cert, String certB64) {
      if (!initFlag) {
         instance = new ThKmsCert(privateKey, cert, certB64);
         initFlag = true;
      }
   }

   public static ThKmsCert getInstance() {
      return instance;
   }
}
