package com.chenyang.nse.bussiness.tools.dataprocess;

import ch.qos.logback.classic.Logger;
import com.ghca.fastjson.JSONObject;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionTypeFieldDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreJiaMiJieMiJinDuDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.ColumnPrimaryKeyInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryptionTypeField;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreJiaMiJieMiJinDu;
import com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.service.core.TdataProjectService;
import com.chenyang.nse.bussiness.service.core.encryption.EncryptionConfigService;
import com.chenyang.nse.bussiness.service.core.encryption.TCoreEncryptionService;
import com.chenyang.nse.bussiness.service.core.encryption.impl.TCoreEncryptionContext;
import com.chenyang.nse.bussiness.service.core.strategy.MaksingAppDataRuleService;
import com.chenyang.nse.bussiness.service.core.udf.UdfService;
import com.chenyang.nse.bussiness.tools.dataprocess.common.ColumnBatchInfo;
import com.chenyang.nse.bussiness.tools.dataprocess.common.CustomPolicy;
import com.chenyang.nse.bussiness.tools.dataprocess.common.RecordBatchInfo;
import com.chenyang.nse.bussiness.tools.encryption.EncProvider;
import com.chenyang.nse.bussiness.tools.encryption.EncUtils;
import com.chenyang.nse.bussiness.tools.encryption.SM4Util;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.logger.LoggerBuilder;
import com.chenyang.nse.bussiness.tools.propertyutil.PropertyGhcaUtil;
import com.chenyang.nse.bussiness.tools.strategy.StrategyData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.jdbc.core.JdbcTemplate;

public class NewLoadingBatchTask implements Runnable {
   private String copySuffix = "";
   private String initialSuffix = "";
   private String encryptionlabel = "";
   private String isLike = "";
   protected static final String COMPLETE = "5";
   protected static final String RUNNING = "-1";
   protected static final String FAIL = "4";
   private int jiamiTasktotalCounts = 0;
   private int jiamiTaskFinishCounts = 0;
   private int failCount = 0;
   private boolean isKeepReadData = true;
   private int startRow = 0;
   private int maxPackageCount = 100000;
   private String dataSystemId;
   private String projectId;
   private String tableName;
   private String columnName;
   private Logger encryptionlogger;
   private String columnType;
   private String columnSize;
   private Connection connection;
   private TCoreDatasystem tCoreDatasystem;
   private String schema;
   private JdbcTemplate jdbcTemplate;
   private String[] primaryKeys;
   private List<ColumnInfoVO> columnInfoList;
   private List<com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO> allColumnList;
   List<ColumnPrimaryKeyInfo> columnPrimaryKeyInfoList;
   HashSet<ColumnEncryption> columnSet = null;
   Properties props = new Properties();
   CountDownLatch countDownLatch;
   EncTaskStateContainer container;

   public NewLoadingBatchTask(String projectId, String dataSystemId, TCoreDatasystem tCoreDatasystem, String schema, String tableName, String[] primaryKeys, List<ColumnInfoVO> columnInfoList, CountDownLatch countDownLatch, List<ColumnPrimaryKeyInfo> columnPrimaryKeyInfoList, List<com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO> allColumnList) {
      this.copySuffix = PropertyGhcaUtil.copySuffix;
      this.initialSuffix = PropertyGhcaUtil.initialSuffix;
      this.encryptionlabel = PropertyGhcaUtil.encryptionlabel;
      this.isLike = PropertyGhcaUtil.encryptionlikeopen;
      this.projectId = projectId;
      this.dataSystemId = dataSystemId;
      this.tCoreDatasystem = tCoreDatasystem;
      this.schema = schema;
      this.tableName = tableName;
      this.columnInfoList = columnInfoList;
      this.primaryKeys = primaryKeys;
      this.connection = JdbcTool.getConnection(tCoreDatasystem);
      this.columnPrimaryKeyInfoList = columnPrimaryKeyInfoList;
      this.countDownLatch = countDownLatch;
      this.allColumnList = allColumnList;

      try {
         this.props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String loggerPath = System.getProperty("user.dir") + File.separator + "encryprocesslog" + File.separator + projectId + File.separator + dataSystemId;
      this.encryptionlogger = (new LoggerBuilder()).getLogger(loggerPath, schema + "." + tableName);
      this.jdbcTemplate = (JdbcTemplate)ApplicationContextProvider.getBean(JdbcTemplate.class);
      this.container = EncTaskTracker.instance().container();
      this.container.add(projectId, schema, tableName, columnInfoList);
      EncTaskTracker.instance().register(this.container);
   }

   public void run() {
      try {
         this.runTask();
      } finally {
         EncTaskTracker.instance().over(this.container.getTask());
      }

   }

   public void runTask() {
      this.countDownLatch.countDown();
      List<ColumnInfoVO> rollbackCols = new ArrayList();
      String loggerPath = System.getProperty("user.dir") + File.separator + "encryprocesslog" + File.separator + this.projectId + File.separator + this.dataSystemId;
      Logger encryptionlogger = (new LoggerBuilder()).getLogger(loggerPath, this.schema + "." + this.tableName);
      Thread.currentThread().setName("pool-" + this.tableName + "-thread");
      encryptionlogger.info("执行批量加密任务开始start>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
      encryptionlogger.info("执行批量加密任务开始start↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓");
      encryptionlogger.info("启动执行线程！！");
      TCoreJiaMiJieMiJinDuDao tCoreJiaMiJieMiJinDuDao = (TCoreJiaMiJieMiJinDuDao)ApplicationContextProvider.getBean(TCoreJiaMiJieMiJinDuDao.class);
      TCoreEncryptionService tCoreEncryptionService = (TCoreEncryptionService)ApplicationContextProvider.getBean(TCoreEncryptionContext.class);
      MaksingAppDataRuleService maksingAppDataRuleService = (MaksingAppDataRuleService)ApplicationContextProvider.getBean(MaksingAppDataRuleService.class);
      new HashMap();
      Boolean doresult = true;
      String copySuffix1 = this.copySuffix;
      String selectSQL = "";
      List<String> selectSqlList = new ArrayList();
      String updateSQL = "";
      List<String> updateSqlList = new ArrayList();
      String backupsSQL = "";
      List<String> backupsSqlList = new ArrayList();
      StringBuilder selectStrBuilder = new StringBuilder();
      Boolean isOracle = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
         isOracle = false;
      }

      Boolean isKingbase = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
         isKingbase = false;
      }

      Boolean isPostgres = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
         isPostgres = false;
      }

      Boolean isGreenplum = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
         isGreenplum = false;
      }

      Boolean isMssqlserver = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
         isMssqlserver = false;
      }

      Boolean isDM = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
         isDM = false;
      }

      Boolean isDB2 = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
         isDB2 = false;
      }

      Boolean isGBASE8S = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.GBASE8S.toString())) {
         isGBASE8S = false;
      }

      Boolean isGauss = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
         isGauss = false;
      }

      Boolean isHive = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString())) {
         isHive = false;
      }

      Boolean isHivetdh = true;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
         isHivetdh = false;
      }

      if (this.primaryKeys.length > 0) {
         for(int i = 0; i < this.primaryKeys.length; ++i) {
            if (isOracle) {
               selectStrBuilder.append("\"" + this.primaryKeys[i] + "\"");
            } else if (!isPostgres && !isGauss) {
               if (isGauss) {
                  selectStrBuilder.append("\"" + this.primaryKeys[i] + "\"");
               } else if (isGreenplum) {
                  selectStrBuilder.append("\"" + this.primaryKeys[i] + "\"");
               } else if (!isMssqlserver && !isHive && !isHivetdh) {
                  if (isDM) {
                     selectStrBuilder.append("\"" + this.primaryKeys[i] + "\"");
                  } else {
                     selectStrBuilder.append(this.primaryKeys[i]);
                  }
               } else {
                  selectStrBuilder.append(this.primaryKeys[i]);
               }
            } else {
               selectStrBuilder.append("\"" + this.primaryKeys[i] + "\"");
            }

            if (i != this.primaryKeys.length - 1) {
               selectStrBuilder.append(",");
            }
         }
      }

      if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
         String substring = selectStrBuilder.toString();
         String[] arr = substring.split(",");
         List list = new ArrayList();

         for(int i = 0; i < arr.length; ++i) {
            String s = arr[i].trim();
            if (!list.contains(s)) {
               list.add(s);
            }
         }

         substring = StringUtils.strip(list.toString(), "[]");
         selectStrBuilder.setLength(0);
         selectStrBuilder.append(substring);
      }

      StringBuilder updateStrBuilder = new StringBuilder();
      int count = 0;
      if (this.primaryKeys.length > 0) {
         updateSQL = updateSQL + " WHERE ";
         backupsSQL = backupsSQL + " WHERE ";

         for(int i = 0; i < this.primaryKeys.length; ++i) {
            if (isOracle) {
               updateSQL = updateSQL + "\"" + this.primaryKeys[i] + "\"=? ";
               backupsSQL = backupsSQL + "\"" + this.primaryKeys[i] + "\"=? ";
            } else if (isPostgres) {
               updateSQL = updateSQL + "\"" + this.primaryKeys[i] + "\"=? ";
               backupsSQL = backupsSQL + "\"" + this.primaryKeys[i] + "\"=? ";
            } else if (isGauss) {
               updateSQL = updateSQL + "\"" + this.primaryKeys[i] + "\"=? ";
               backupsSQL = backupsSQL + "\"" + this.primaryKeys[i] + "\"=? ";
            } else if (isGreenplum) {
               updateSQL = updateSQL + "\"" + this.primaryKeys[i] + "\"=? ";
               backupsSQL = backupsSQL + "\"" + this.primaryKeys[i] + "\"=? ";
            } else if (!isMssqlserver && !isHive && !isHivetdh) {
               if (isDM) {
                  updateSQL = updateSQL + "\"" + this.primaryKeys[i] + "\"=? ";
                  backupsSQL = backupsSQL + "\"" + this.primaryKeys[i] + "\"=? ";
               } else {
                  updateSQL = updateSQL + this.primaryKeys[i] + "=? ";
                  backupsSQL = backupsSQL + this.primaryKeys[i] + "=? ";
               }
            } else {
               updateSQL = updateSQL + this.primaryKeys[i] + "=? ";
               backupsSQL = backupsSQL + this.primaryKeys[i] + "=? ";
            }

            ++count;
            if (count < this.primaryKeys.length) {
               updateSQL = updateSQL + " AND ";
               backupsSQL = backupsSQL + " AND ";
            }
         }
      }

      String updateSql1 = updateSQL;
      String backupsSQL1 = backupsSQL;
      StringBuilder addColumnStrings = new StringBuilder();
      List<StringBuilder> addCopy = new ArrayList();
      List<String> sqlColumnList = new ArrayList();
      Set<String> columnMap = JdbcTool.getColumnMap(this.connection, this.schema, this.tableName);
      StringBuilder stringBuilderpsk = new StringBuilder();
      stringBuilderpsk.append(" order by ");
      if (this.primaryKeys.length > 0) {
         for(int i = 0; i < this.primaryKeys.length; ++i) {
            if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
               stringBuilderpsk.append("\"" + this.primaryKeys[i] + "\"").append(",");
            } else if (!this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
               if (this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                  stringBuilderpsk.append("\"" + this.primaryKeys[i] + "\"").append(",");
               } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                  stringBuilderpsk.append(this.primaryKeys[i]).append(",");
               } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString())) {
                  stringBuilderpsk.append(this.primaryKeys[i]).append(",");
               } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                  stringBuilderpsk.append(this.primaryKeys[i]).append(",");
               } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                  stringBuilderpsk.append("\"" + this.primaryKeys[i] + "\"").append(",");
               } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                  stringBuilderpsk.append("\"" + this.primaryKeys[i] + "\"").append(",");
               } else {
                  stringBuilderpsk.append(this.primaryKeys[i]).append(",");
               }
            } else {
               stringBuilderpsk.append("\"" + this.primaryKeys[i] + "\"").append(",");
            }
         }
      }

      stringBuilderpsk.deleteCharAt(stringBuilderpsk.length() - 1);
      String pks = stringBuilderpsk.toString() + " ";

      for(int i = 0; i < this.columnInfoList.size(); ++i) {
         this.columnName = ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName();
         this.columnType = ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnType();
         this.columnSize = ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnSize();
         tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, this.columnName, "-1");
         String columNamecopy = this.columnName + this.copySuffix;
         if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString()) || this.tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
            columNamecopy = "\"" + columNamecopy + "\"";
         }

         if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) || this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString()) || this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString()) || this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
            columNamecopy = "\"" + columNamecopy + "\"";
         }

         String primaryKeyFlag = "0";
         String primary_key_columns = "";
         String primary_key_col = "";

         for(com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO columnInfoVO : maksingAppDataRuleService.queryColumnInfo(this.dataSystemId, this.schema, this.tableName)) {
            if (columnInfoVO.getPrimarykey().equals("1")) {
               primary_key_columns = primary_key_columns + columnInfoVO.getColumnname() + ",";
               if ("DM".equals(this.tCoreDatasystem.getDbtype())) {
                  primary_key_col = primary_key_columns + columnInfoVO.getColumnname();
               } else {
                  primary_key_col = "\"" + primary_key_columns + columnInfoVO.getColumnname() + "\",";
               }
            }
         }

         if (!"".equals(primary_key_col) && primary_key_col.charAt(primary_key_col.length() - 1) == ',') {
            primary_key_col.substring(0, primary_key_col.length() - 1);
         }

         if (!"".equals(primary_key_columns)) {
            if (primary_key_columns.charAt(primary_key_columns.length() - 1) == ',') {
               primary_key_columns = primary_key_columns.substring(0, primary_key_columns.length() - 1);
            }

            String[] fileds = primary_key_columns.split(",");
            if (fileds.length > 0) {
               for(String filed11 : fileds) {
                  if (this.columnName.equals(filed11)) {
                     primaryKeyFlag = "1";
                  }
               }
            }
         }

         this.columnSize = EncUtils.strColumnSize(this.tCoreDatasystem.getDbtype(), this.columnType, this.columnSize, ((ColumnInfoVO)this.columnInfoList.get(i)).getIsLike(), primaryKeyFlag, ((ColumnInfoVO)this.columnInfoList.get(i)).getEncryptionType());
         String columnSizestr = "";
         if ("VARCHAR2".equalsIgnoreCase(this.columnType) || "varchar".equalsIgnoreCase(this.columnType) || "char".equalsIgnoreCase(this.columnType) || "nvarchar".equalsIgnoreCase(this.columnType) || "varcharbyte".equalsIgnoreCase(this.columnType)) {
            if (!"STRING".equals(((ColumnInfoVO)this.columnInfoList.get(i)).getColumnType().toUpperCase(Locale.ROOT))) {
               columnSizestr = "(" + ((ColumnInfoVO)this.columnInfoList.get(i)).getRealitycolumnsize() + ")";
            } else {
               columnSizestr = "";
            }
         }

         StringBuilder addColumnString = new StringBuilder();
         String copyColumn = this.columnName + this.copySuffix;
         if (!columnMap.contains(copyColumn) && !columnMap.contains(columNamecopy)) {
            if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
               addColumnString.append("alter table \"").append(this.schema).append("\".\"").append(this.tableName).append("\" ");
            } else {
               addColumnString.append("alter table ").append(this.schema).append(".").append(this.tableName);
            }

            if (isOracle) {
               addColumnStrings.append(columNamecopy).append(" ");
               addColumnString.append(" add ").append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr);
            } else if (isDM) {
               addColumnStrings.append(columNamecopy).append(" ");
               addColumnString.append(" add ").append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr);
            } else if (!isPostgres && !isGauss) {
               if (isGreenplum) {
                  addColumnStrings.append(columNamecopy).append(",");
                  addColumnString.append(" add ").append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr);
               } else if (isMssqlserver) {
                  addColumnStrings.append(columNamecopy).append(",");
                  addColumnString.append(" add ").append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr);
               } else if (isDB2) {
                  addColumnStrings.append(columNamecopy).append(",");
                  addColumnString.append(" ADD COLUMN ").append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr);
               } else {
                  addColumnStrings.append(columNamecopy).append(",");
                  addColumnString.append(" add ").append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr);
               }
            } else {
               addColumnStrings.append(columNamecopy).append(",");
               addColumnString.append(" add ").append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr);
            }
         }

         addCopy.add(addColumnString);
         if (!this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
            sqlColumnList.add(selectStrBuilder.toString() + "," + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName());
         } else {
            String substring = selectStrBuilder.toString() + ",\"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\"";
            String[] arr1 = substring.split(",");
            List list = new ArrayList();

            for(int n = 0; n < arr1.length; ++n) {
               String s = arr1[n].trim();
               if (!list.contains(s)) {
                  list.add(s);
               }
            }

            substring = StringUtils.strip(list.toString(), "[]");
            sqlColumnList.add(substring);
         }

         StringBuilder whereStringBuilder = new StringBuilder();
         whereStringBuilder.append(" where ");
         if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
            whereStringBuilder.append(" \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" NOT LIKE '%" + this.encryptionlabel + "%' and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " is not null and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " != ' '");
         } else if (!this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
            if (this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
               whereStringBuilder.append(" \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" NOT LIKE '%" + this.encryptionlabel + "%' and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " is not null and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " != ''");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
               whereStringBuilder.append(" " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " NOT LIKE '%" + this.encryptionlabel + "%' and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " is not null and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " != ''");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString())) {
               whereStringBuilder.append(" " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " NOT LIKE '%" + this.encryptionlabel + "%' and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " is not null and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " != ''");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
               whereStringBuilder.append(" " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " NOT LIKE '%" + this.encryptionlabel + "%' and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " is not null and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " != ' '");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
               whereStringBuilder.append(" " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " NOT LIKE '%" + this.encryptionlabel + "%' and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " is not null and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " != ''");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
               whereStringBuilder.append(" \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" NOT LIKE '%" + this.encryptionlabel + "%' and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " is not null and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " != ' '");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
               whereStringBuilder.append(" \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" NOT LIKE '%" + this.encryptionlabel + "%' and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " is not null ");
            } else if ("BLOB".equals(((ColumnInfoVO)this.columnInfoList.get(i)).getColumnType())) {
               whereStringBuilder.append(" 1=1 ");
            } else {
               whereStringBuilder.append(" " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " NOT LIKE '%" + this.encryptionlabel + "%' and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " is not null and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " != ''");
            }
         } else {
            whereStringBuilder.append(" \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" NOT LIKE '%" + this.encryptionlabel + "%' and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " is not null ");
         }

         String where = whereStringBuilder.toString();
         if (isOracle) {
            selectSqlList.add("SELECT " + selectStrBuilder.toString() + ", " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " FROM \"" + this.schema + "\".\"" + this.tableName + "\"");
         } else if (!isPostgres && !isGauss) {
            if (isGreenplum) {
               selectSqlList.add("SELECT " + selectStrBuilder.toString() + ", \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" FROM \"" + this.schema + "\".\"" + this.tableName + "\"");
            } else if (isMssqlserver) {
               selectSqlList.add("SELECT " + selectStrBuilder.toString() + ", " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " FROM " + this.schema + "." + this.tableName);
            } else if (!isHive && !isHivetdh) {
               if (isDB2) {
                  selectSqlList.add("SELECT " + selectStrBuilder.toString() + ", " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " FROM " + this.schema + "." + this.tableName);
               } else if (!isDM) {
                  if (isDB2) {
                     selectSqlList.add("SELECT " + selectStrBuilder.toString() + ", " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " FROM \"" + this.schema + "\".\"" + this.tableName + "\"");
                  } else if (isKingbase) {
                     selectSqlList.add("SELECT " + selectStrBuilder.toString() + ", \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" FROM \"" + this.schema + "\".\"" + this.tableName + "\"");
                  } else if (isGBASE8S) {
                     selectSqlList.add("SELECT " + selectStrBuilder.toString() + ", " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " FROM " + this.schema + ":" + this.tableName);
                  } else {
                     selectSqlList.add("SELECT " + selectStrBuilder.toString() + ", `" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "` FROM " + this.schema + "." + this.tableName);
                  }
               } else {
                  String substring = selectStrBuilder.toString() + ",\"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\"";
                  String[] arr1 = substring.split(",");
                  List list = new ArrayList();

                  for(int n = 0; n < arr1.length; ++n) {
                     String s = arr1[n].trim();
                     if (!list.contains(s)) {
                        list.add(s);
                     }
                  }

                  substring = StringUtils.strip(list.toString(), "[]");
                  selectSqlList.add("SELECT " + substring + " FROM \"" + this.schema + "\".\"" + this.tableName + "\"");
               }
            } else {
               selectSqlList.add("SELECT " + selectStrBuilder.toString() + ", " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " FROM " + this.schema + "." + this.tableName);
            }
         } else {
            selectSqlList.add("SELECT " + selectStrBuilder.toString() + ", \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" FROM \"" + this.schema + "\".\"" + this.tableName + "\"");
         }

         updateStrBuilder.append(columNamecopy).append("=?,");
         if (isOracle) {
            updateSqlList.add("UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" =? " + updateSql1);
            backupsSqlList.add("UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + this.copySuffix + "\" = \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" " + backupsSQL1);
         } else if (!isPostgres && !isGauss) {
            if (isGreenplum) {
               updateSqlList.add("UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" =? " + updateSql1);
               backupsSqlList.add("UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + this.copySuffix + "\" = \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" " + backupsSQL1);
            } else if (isMssqlserver) {
               updateSqlList.add("UPDATE " + this.schema + "." + this.tableName + " SET " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " =? " + updateSql1);
               backupsSqlList.add("UPDATE " + this.schema + "." + this.tableName + " SET " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + this.copySuffix + " = " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + backupsSQL1);
            } else if (!isHive && !isHivetdh) {
               if (isDB2) {
                  updateSqlList.add("UPDATE " + "\"" + this.schema + "\"" + "." + "\"" + this.tableName + "\"" + " SET \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" =? " + updateSql1);
                  backupsSqlList.add("UPDATE " + "\"" + this.schema + "\"" + "." + "\"" + this.tableName + "\"" + " SET \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + this.copySuffix + "\" = " + "\"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" " + backupsSQL1);
               } else if (isDM) {
                  updateSqlList.add("UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" =? " + updateSql1);
                  backupsSqlList.add("UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + this.copySuffix + "\" = \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" " + backupsSQL1);
               } else {
                  updateSqlList.add("UPDATE " + this.schema + "." + this.tableName + " SET " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " =? " + updateSql1);
                  backupsSqlList.add("UPDATE " + this.schema + "." + this.tableName + " SET " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + this.copySuffix + " = " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + backupsSQL1);
               }
            } else {
               updateSqlList.add("UPDATE " + this.schema + "." + this.tableName + " SET " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " =? " + updateSql1);
               backupsSqlList.add("UPDATE " + this.schema + "." + this.tableName + " SET " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + this.copySuffix + " = " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + backupsSQL1);
            }
         } else {
            updateSqlList.add("UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" =? " + updateSql1);
            backupsSqlList.add("UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + this.copySuffix + "\" = \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" " + backupsSQL1);
         }
      }

      List<TCoreJiaMiJieMiJinDu> tCoreJiaList = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinD(this.dataSystemId, this.projectId, this.schema, this.tableName);
      int cpppppp = tCoreJiaList.size();
      if (cpppppp == 0) {
         TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJinDu = new TCoreJiaMiJieMiJinDu();
         tCoreJiaMiJieMiJinDu.setProjectid(this.projectId);
         tCoreJiaMiJieMiJinDu.setDatasystemid(this.dataSystemId);
         tCoreJiaMiJieMiJinDu.setSchemahh(this.schema);
         tCoreJiaMiJieMiJinDu.setTablename(this.tableName);
         tCoreJiaMiJieMiJinDu.setFlag("0");
         tCoreJiaMiJieMiJinDuDao.save(tCoreJiaMiJieMiJinDu);
      }

      TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJin = new TCoreJiaMiJieMiJinDu();
      List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieMiJinList = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinD(this.dataSystemId, this.projectId, this.schema, this.tableName);
      if (null != tCoreJiaMiJieMiJinList && tCoreJiaMiJieMiJinList.size() > 0) {
         for(int npp = 0; npp < tCoreJiaMiJieMiJinList.size(); ++npp) {
            tCoreJiaMiJieMiJin = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(npp);
         }
      }

      if (null != tCoreJiaMiJieMiJin) {
         tCoreJiaMiJieMiJin.setTotalcounts(this.jiamiTasktotalCounts);
         tCoreJiaMiJieMiJin.setStarttime(new Date());
         tCoreJiaMiJieMiJin.setFlag("0");
         tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);
      }

      Statement commStmt = null;
      ResultSet rs = null;
      ResultSet rsCount = null;
      PreparedStatement updataCopyPstmt = null;
      PreparedStatement backupsCopyPstmt = null;
      Connection selcon = null;
      int curBacthCount = 0;

      try {
         this.connection.setAutoCommit(false);
         Statement stmtCount = null;

         try {
            stmtCount = this.connection.createStatement();
            String selectCountTable = "";
            if (isOracle) {
               selectCountTable = "select count(1) as \"table_rows\" from \"" + this.schema + "\".\"" + this.tableName + "\"";
            } else if (isPostgres) {
               selectCountTable = "select count(1) as \"table_rows\" from \"" + this.schema + "\".\"" + this.tableName + "\"";
            } else if (isGauss) {
               selectCountTable = "select count(1) as \"table_rows\" from \"" + this.schema + "\".\"" + this.tableName + "\"";
            } else if (isGreenplum) {
               selectCountTable = "select count(1) as \"table_rows\" from \"" + this.schema + "\".\"" + this.tableName + "\"";
            } else if (isMssqlserver) {
               selectCountTable = "select count(1) as table_rows from " + this.schema + "." + this.tableName;
            } else if (!isHive && !isHivetdh) {
               if (isDM) {
                  selectCountTable = "select count(1) as \"table_rows\" from \"" + this.schema + "\".\"" + this.tableName + "\"";
               } else {
                  selectCountTable = "select count(1) as table_rows from " + this.schema + "." + this.tableName;
               }
            } else {
               selectCountTable = "select count(1) as table_rows from " + this.schema + "." + this.tableName;
            }

            for(rsCount = stmtCount.executeQuery(selectCountTable); rsCount.next(); this.jiamiTasktotalCounts = rsCount.getInt("table_rows")) {
            }

            if (null != tCoreJiaMiJieMiJin) {
               tCoreJiaMiJieMiJin.setTotalcounts(this.jiamiTasktotalCounts);
               tCoreJiaMiJieMiJin.setStarttime(new Date());
               tCoreJiaMiJieMiJin.setFlag("0");
               tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);
            }
         } catch (Exception e) {
            e.printStackTrace();
         } finally {
            if (rsCount != null) {
               try {
                  stmtCount.close();
               } catch (SQLException e) {
                  e.printStackTrace();
               }
            }

            if (stmtCount != null) {
               try {
                  stmtCount.close();
               } catch (SQLException e) {
                  e.printStackTrace();
               }
            }

            stmtCount.close();
         }

         for(int i = 0; i < this.columnInfoList.size(); ++i) {
            this.jiamiTaskFinishCounts = 0;
            curBacthCount = 0;
            ColumnInfoVO colInfo = (ColumnInfoVO)this.columnInfoList.get(i);

            try {
               boolean encFlag = false;
               this.isKeepReadData = true;
               this.startRow = 0;
               this.columnName = ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName();
               tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, this.columnName, "-1");
               boolean isupk = false;
               if (this.columnPrimaryKeyInfoList != null && this.columnPrimaryKeyInfoList.size() > 0 && "1".equals(((ColumnPrimaryKeyInfo)this.columnPrimaryKeyInfoList.get(0)).getFlag())) {
                  List pklist = Arrays.asList(this.primaryKeys);
                  if (pklist.contains(this.columnName)) {
                     isupk = true;
                  }
               }

               try {
                  if (isOracle) {
                     this.addTableField(this.connection, "\"" + this.schema + "\"", "\"" + this.tableName + "\"", addColumnStrings, (StringBuilder)addCopy.get(i), encryptionlogger, isupk, (ColumnInfoVO)this.columnInfoList.get(i));
                  } else if (isPostgres) {
                     this.addTableField(this.connection, "\"" + this.schema + "\"", "\"" + this.tableName + "\"", addColumnStrings, (StringBuilder)addCopy.get(i), encryptionlogger, isupk, (ColumnInfoVO)this.columnInfoList.get(i));
                  } else if (isGauss) {
                     this.addTableField(this.connection, "\"" + this.schema + "\"", "\"" + this.tableName + "\"", addColumnStrings, (StringBuilder)addCopy.get(i), encryptionlogger, isupk, (ColumnInfoVO)this.columnInfoList.get(i));
                  } else if (isGreenplum) {
                     this.addTableField(this.connection, "\"" + this.schema + "\"", "\"" + this.tableName + "\"", addColumnStrings, (StringBuilder)addCopy.get(i), encryptionlogger, isupk, (ColumnInfoVO)this.columnInfoList.get(i));
                  } else if (isMssqlserver) {
                     this.addTableField(this.connection, this.schema, this.tableName, addColumnStrings, (StringBuilder)addCopy.get(i), encryptionlogger, false, (ColumnInfoVO)this.columnInfoList.get(i));
                  } else if (isHivetdh) {
                     this.addTableField(this.connection, this.schema, this.tableName, addColumnStrings, (StringBuilder)addCopy.get(i), encryptionlogger, false, (ColumnInfoVO)this.columnInfoList.get(i));
                  } else if (isDM) {
                     this.addTableField(this.connection, "\"" + this.schema + "\"", "\"" + this.tableName + "\"", addColumnStrings, (StringBuilder)addCopy.get(i), encryptionlogger, isupk, (ColumnInfoVO)this.columnInfoList.get(i));
                  } else {
                     this.addTableField(this.connection, this.schema, this.tableName, addColumnStrings, (StringBuilder)addCopy.get(i), encryptionlogger, isupk, (ColumnInfoVO)this.columnInfoList.get(i));
                  }
               } catch (SQLException e) {
                  this.updateFieldFlag(((ColumnInfoVO)this.columnInfoList.get(i)).getTcoreencryptionfieldId(), "4");
                  encryptionlogger.error(e.getMessage());
                  continue;
               }

               try {
                  com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO pkey = null;
                  if (this.primaryKeys.length > 0) {
                     pkey = new com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO();
                     pkey.setColumnname(this.primaryKeys[0]);
                  }
               } catch (Exception throwables) {
                  encryptionlogger.error("备份原列数据失败：" + throwables.getMessage());
                  this.updateFieldFlag(((ColumnInfoVO)this.columnInfoList.get(i)).getTcoreencryptionfieldId(), "4");
                  continue;
               }

               try {
                  if (!"STRING".equals(((ColumnInfoVO)this.columnInfoList.get(i)).getColumnType().toUpperCase(Locale.ROOT))) {
                     EncryptProcessUtil.addColumnLength(this.connection, encryptionlogger, (ColumnInfoVO)this.columnInfoList.get(i), this.tCoreDatasystem, this.schema, this.tableName, this.allColumnList);
                  }
               } catch (SQLException throwables) {
                  encryptionlogger.error("扩展原列长度失败：" + throwables.getMessage());
                  this.updateFieldFlag(((ColumnInfoVO)this.columnInfoList.get(i)).getTcoreencryptionfieldId(), "4");
                  continue;
               }

               Boolean bh = false;
               Map<String, String> mt = new HashMap();
               encryptionlogger.info("正常信息获取表字段信息");

               try {
                  commStmt = this.connection.createStatement();
                  rs = JdbcTool.getColumns(this.connection, this.schema, this.tableName);
                  ResultSetMetaData rsMetadata = rs.getMetaData();
                  int countMT = rsMetadata.getColumnCount();

                  for(int i1 = 1; i1 < countMT + 1; ++i1) {
                     String columnNameCol = rsMetadata.getColumnLabel(i1);
                     String columnTypeCol = rsMetadata.getColumnTypeName(i1);
                     if (!mt.containsKey(columnNameCol)) {
                        mt.put(columnNameCol, columnTypeCol);
                     }
                  }

                  if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) || this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
                     bh = true;
                  }
               } catch (Exception w) {
                  encryptionlogger.info("异常信息" + w.getMessage());
                  continue;
               }

               encryptionlogger.info("正常信息开始查询加密数据");
               int batchMaxCount = 10000;
               if ("OCEANBASE".equals(this.tCoreDatasystem.getDbtype())) {
                  int oceanbasecount = 3;

                  try {
                     Properties properties = PropertiesLoaderUtils.loadAllProperties("config.properties");
                     String property = properties.getProperty("oceanbasecount");
                     if (property != null && property.length() > 0) {
                        oceanbasecount = Integer.valueOf(property.trim());
                     }
                  } catch (Exception e) {
                     for(ColumnInfoVO columnInfoVO : this.columnInfoList) {
                        tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnInfoVO.getColumnName(), "4");
                     }

                     e.printStackTrace();
                  }

                  batchMaxCount = oceanbasecount;
               } else {
                  try {
                     Properties properties = PropertiesLoaderUtils.loadAllProperties("config.properties");
                     String property = properties.getProperty("encbatchcount");
                     if (property != null && property.length() > 0) {
                        batchMaxCount = Integer.valueOf(property.trim());
                     }
                  } catch (Exception e) {
                     for(ColumnInfoVO columnInfoVO : this.columnInfoList) {
                        tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnInfoVO.getColumnName(), "4");
                     }

                     e.printStackTrace();
                  }
               }

               PreparedStatement preparedStatementSelect = null;
               ResultSet resultSet = null;

               label6305:
               while(true) {
                  try {
                     String sql1 = (String)sqlColumnList.get(i);
                     String sql2 = (String)selectSqlList.get(i);
                     String sqlPaging = null;
                     if (isDB2) {
                        sqlPaging = "SELECT " + sql1 + " FROM ( select row_number() over() as RN ,TT.* FROM  (" + sql2 + " ) TT ) ";
                     } else if (!isOracle && !isDM) {
                        if (!isPostgres && !this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                           if (EdbType.GREENPLUM.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
                              sqlPaging = sql2;
                           } else if (!EdbType.MYSQL.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.KINGBASE.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.MARIADB.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.OCEANBASE.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.HIVE.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.HIVE_TDH.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
                              if (EdbType.MSSQLSERVER.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
                                 sqlPaging = sql2;
                              }
                           } else {
                              sqlPaging = sql2;
                           }
                        } else {
                           sqlPaging = sql2;
                        }
                     } else {
                        sqlPaging = "SELECT " + sql1 + " FROM ( select ROWNUM RN ,TT.* FROM  (" + sql2 + " ) TT ) ";
                     }

                     if (!this.tCoreDatasystem.getDbtype().equals("HIVE")) {
                        this.connection.setAutoCommit(false);
                     }

                     encryptionlogger.info("read data sql : {}", sqlPaging);
                     if (EdbType.MSSQLSERVER.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
                        preparedStatementSelect = this.connection.prepareStatement(sqlPaging, 1004, 1007);
                     } else {
                        preparedStatementSelect = this.connection.prepareStatement(sqlPaging, 1003, 1007);
                     }

                     preparedStatementSelect.setFetchSize(batchMaxCount);
                     resultSet = preparedStatementSelect.executeQuery();
                     int curBatchCount = 0;
                     int totalBatchCount = 0;
                     encryptionlogger.info("data loop");
                     ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue(1), Executors.defaultThreadFactory(), new CustomPolicy());
                     List<RecordBatchInfo> recordBatchInfoList = new ArrayList(10000);

                     while(resultSet.next()) {
                        List<ColumnBatchInfo> columnBatchInfoList = new ArrayList(this.columnInfoList.size());
                        List<String> primaryKeyList = new ArrayList(this.primaryKeys.length);
                        RecordBatchInfo recordBatchInfo = new RecordBatchInfo();
                        recordBatchInfo.setColumnBatchInfoList(columnBatchInfoList);
                        recordBatchInfo.setPrimaryKeyList(primaryKeyList);
                        recordBatchInfoList.add(recordBatchInfo);

                        for(int j = 0; j < this.columnInfoList.size(); ++j) {
                           ColumnBatchInfo columnBatchInfo = new ColumnBatchInfo();
                           columnBatchInfo.setSecretKey(((ColumnInfoVO)this.columnInfoList.get(j)).getSecretKey());
                           if ("BLOB".equals(((ColumnInfoVO)this.columnInfoList.get(j)).getColumnType())) {
                              columnBatchInfo.setIsBlob(true);
                              Blob blob = resultSet.getBlob(((ColumnInfoVO)this.columnInfoList.get(j)).getColumnName());
                              columnBatchInfo.setBlob(blob);
                           } else {
                              columnBatchInfo.setIsBlob(false);
                              String value = resultSet.getString(((ColumnInfoVO)this.columnInfoList.get(j)).getColumnName());
                              String encryptionType = ((ColumnInfoVO)this.columnInfoList.get(j)).getEncryptionType();
                              String isLike = ((ColumnInfoVO)this.columnInfoList.get(j)).getIsLike();
                              if (!"MYSQL".equals(this.tCoreDatasystem.getDbtype()) && !"MARIADB".equals(this.tCoreDatasystem.getDbtype()) && (((ColumnInfoVO)this.columnInfoList.get(j)).getColumnType().equalsIgnoreCase("char") || ((ColumnInfoVO)this.columnInfoList.get(j)).getColumnType().equalsIgnoreCase("bpchar") || ((ColumnInfoVO)this.columnInfoList.get(j)).getColumnType().equalsIgnoreCase("nchar")) && StringUtils.isNotEmpty(value)) {
                                 value = value.trim();
                              }

                              String keepfirst = ((ColumnInfoVO)this.columnInfoList.get(j)).getKeepfirst();
                              String encdigit = ((ColumnInfoVO)this.columnInfoList.get(j)).getEncdigit();
                              String twoindex = ((ColumnInfoVO)this.columnInfoList.get(j)).getTwoindex();
                              columnBatchInfo.setEncryptionType(encryptionType);
                              columnBatchInfo.setValue(value);
                              columnBatchInfo.setIsLike(isLike);
                              columnBatchInfo.setKeepFirst(keepfirst);
                              columnBatchInfo.setEncDigit(encdigit);
                              columnBatchInfo.setTwoIndex(twoindex);
                           }

                           columnBatchInfoList.add(columnBatchInfo);
                        }

                        for(int j = 0; j < this.primaryKeys.length; ++j) {
                           primaryKeyList.add(resultSet.getString(this.primaryKeys[j]));
                        }

                        ++curBatchCount;
                        if (curBatchCount == batchMaxCount) {
                           String finalUpdateSQL = (String)updateSqlList.get(i);
                           String finalBackupsSQL = (String)backupsSqlList.get(i);
                           List<RecordBatchInfo> finalRecordBatchInfoList = recordBatchInfoList;
                           int finalBatchMaxCount = batchMaxCount;
                           executor.submit(() -> {
                              try {
                                 this.process(finalUpdateSQL, finalBackupsSQL, finalRecordBatchInfoList, finalBatchMaxCount);
                              } finally {
                                 finalRecordBatchInfoList.clear();
                                 if (finalRecordBatchInfoList instanceof ArrayList) {
                                    ((ArrayList) finalRecordBatchInfoList).trimToSize();
                                 }

                              }

                           });
                           recordBatchInfoList = new ArrayList(10000);
                           curBatchCount = 0;
                        }
                     }

                     if (curBatchCount > 0) {
                        String finalUpdateSQL = (String)updateSqlList.get(i);
                        String finalBackupsSQL = (String)backupsSqlList.get(i);
                        List<RecordBatchInfo> finalRecordBatchInfoList1 = recordBatchInfoList;
                        int finalBatchMaxCount1 = batchMaxCount;
                        executor.submit(() -> {
                           try {
                              this.process(finalUpdateSQL, finalBackupsSQL, finalRecordBatchInfoList1, finalBatchMaxCount1);
                           } finally {
                              finalRecordBatchInfoList1.clear();
                              if (finalRecordBatchInfoList1 instanceof ArrayList) {
                                 ((ArrayList) finalRecordBatchInfoList1).trimToSize();
                              }

                           }

                        });
                     }

                     executor.shutdown();
                     if (executor.awaitTermination(30L, TimeUnit.MINUTES)) {
                        System.out.println("全部完成");
                     } else {
                        executor.shutdownNow();
                        System.out.println("未全部完成，强制停止");
                     }
                     break;
                  } catch (Throwable e) {
                     if (!(e instanceof SQLRecoverableException)) {
                        encryptionlogger.error("loading task error", e);
                        Iterator var399 = this.columnInfoList.iterator();

                        while(true) {
                           if (!var399.hasNext()) {
                              break label6305;
                           }

                           ColumnInfoVO columnInfoVO = (ColumnInfoVO)var399.next();
                           tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnInfoVO.getColumnName(), "4");
                        }
                     }

                     encryptionlogger.info("db reconnection!");
                     this.connection = JdbcTool.getConnection(this.tCoreDatasystem);
                  } finally {
                     try {
                        if (null != resultSet) {
                           resultSet.close();
                        }

                        if (null != preparedStatementSelect) {
                           preparedStatementSelect.close();
                        }

                        if (null != this.connection) {
                           this.connection.close();
                        }
                     } catch (Exception e) {
                        e.printStackTrace();
                     }

                  }
               }

               encryptionlogger.info("data loop done");

               for(ColumnInfoVO columnInfoVO : this.columnInfoList) {
                  String check = this.checkEncryption(this.tCoreDatasystem, columnInfoVO, encryptionlogger);
                  if (!"ok".equals(check)) {
                     encryptionlogger.error("正常信息：字段" + columnInfoVO.getColumnName() + "加密校验失败");
                     tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnInfoVO.getColumnName(), "4");
                  } else {
                     encryptionlogger.info("正常信息：字段" + columnInfoVO.getColumnName() + "加密校验成功");
                     String columnName = columnInfoVO.getColumnName();
                     tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnName, "5");

                     try {
                        TCoreEncryptionTypeFieldDao fieldDao = (TCoreEncryptionTypeFieldDao)ApplicationContextProvider.getBean(TCoreEncryptionTypeFieldDao.class);
                        TCoreEncryptionTypeField field = (TCoreEncryptionTypeField)fieldDao.queryUnique(new Criterion[]{Restrictions.eq("id", columnInfoVO.getTcoreencryptionfieldId())});
                        Date date = new Date();
                        field.setCreatetime(date);
                        fieldDao.update(field);
                     } catch (Exception var310) {
                     }
                  }
               }
            } finally {
               this.container.over(colInfo.getColumnName());
            }
         }
      } catch (Exception e) {
         encryptionlogger.error(e.getMessage(), e);
         encryptionlogger.info("加密失败");
         encryptionlogger.warn("提交到" + this.jiamiTaskFinishCounts + "行，执行异常!");
         tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, this.columnName, "4");

         try {
            this.connection.rollback();
         } catch (SQLException ex) {
            ex.printStackTrace();
         }

         TCoreJiaMiJieMiJinDu tCoreJiaMiJie = new TCoreJiaMiJieMiJinDu();
         List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieList = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinD(this.dataSystemId, this.projectId, this.schema, this.tableName);
         int cpplll = tCoreJiaMiJieList.size();
         if (cpplll > 0) {
            for(int npplll = 0; npplll < cpplll; ++npplll) {
               tCoreJiaMiJie = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieList.get(npplll);
            }
         }

         tCoreJiaMiJie.setState("-1");
         this.failCount += curBacthCount;
         tCoreJiaMiJie.setFailcounts(this.failCount);
         tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJie);
      } finally {
         if (this.connection != null) {
            try {
               this.checkDB2Patch(this.tCoreDatasystem, this.connection);
               this.connection.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

         if (selcon != null) {
            try {
               this.checkDB2Patch(this.tCoreDatasystem, selcon);
               selcon.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

         if (commStmt != null) {
            try {
               commStmt.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

         if (rs != null) {
            try {
               rs.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

         if (rsCount != null) {
            try {
               rsCount.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

         if (backupsCopyPstmt != null) {
            try {
               backupsCopyPstmt.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

         if (updataCopyPstmt != null) {
            try {
               updataCopyPstmt.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

      }

      try {
         TdataProjectService tdataProjectService = (TdataProjectService)ApplicationContextProvider.getBean(TdataProjectService.class);
         EncryptionConfigService encryptionConfigService = (EncryptionConfigService)ApplicationContextProvider.getBean(EncryptionConfigService.class);
         TCoreEncryptionTypeFieldDao tCoreEncryptionTypeFieldDao = (TCoreEncryptionTypeFieldDao)ApplicationContextProvider.getBean(TCoreEncryptionTypeFieldDao.class);
         StrategyData strategyData = (StrategyData)ApplicationContextProvider.getBean(StrategyData.class);
         UdfService udfService = new UdfService(tdataProjectService, encryptionConfigService, tCoreEncryptionTypeFieldDao, strategyData);
         udfService.loadingColumnParamFinish(this.projectId, this.dataSystemId, this.schema, this.tableName);
      } catch (Exception e) {
         System.out.println(e.getMessage());
      }

      if (rollbackCols.size() > 0) {
         try {
            Connection rollbackConn = JdbcTool.getConnection(this.tCoreDatasystem);
            Throwable var370 = null;

            try {
               this.rollbackColumns(rollbackConn, rollbackCols, this.copySuffix, (List)null, (List)null, (List)null, this.tCoreDatasystem);
            } catch (Throwable var304) {
               var370 = var304;
               throw var304;
            } finally {
               if (rollbackConn != null) {
                  if (var370 != null) {
                     try {
                        rollbackConn.close();
                     } catch (Throwable var303) {
                        var370.addSuppressed(var303);
                     }
                  } else {
                     rollbackConn.close();
                  }
               }

            }
         } catch (Exception e) {
            encryptionlogger.error("加密替换回滚失败:" + e.getMessage());
         }
      }

   }

   private void checkDB2Patch(TCoreDatasystem tCoreDatasystem, Connection connection) throws SQLException {
      String code = EdbType.getEdbTypeByDbname(tCoreDatasystem.getDbtype()).getDbcode();
      if (code.equals(EdbType.DB2.toString())) {
         connection.commit();
      }

   }

   private void process(String finalUpdateSQL, String finalBackupsSQL, List<RecordBatchInfo> finalRecordBatchInfo, int bacthMaxCount) {
      if (finalRecordBatchInfo.size() < bacthMaxCount) {
         this.encryptionlogger.info("执行不满足分页的加密");
      }

      Connection connection = null;
      PreparedStatement pstmt = null;
      PreparedStatement pstmt_backups = null;

      try {
         connection = JdbcTool.getConnection(this.tCoreDatasystem);
         if (!this.tCoreDatasystem.getDbtype().equals("HIVE")) {
            connection.setAutoCommit(false);
         }

         pstmt = connection.prepareStatement(finalUpdateSQL);
         pstmt_backups = connection.prepareStatement(finalBackupsSQL);

         for(RecordBatchInfo recordBatchInfoTemp : finalRecordBatchInfo) {
            List<ColumnBatchInfo> columnBatchInfoListTemp = recordBatchInfoTemp.getColumnBatchInfoList();

            for(int i = 0; i < columnBatchInfoListTemp.size(); ++i) {
               ColumnBatchInfo columnBatchInfo = (ColumnBatchInfo)columnBatchInfoListTemp.get(i);
               if (columnBatchInfo.getIsBlob()) {
                  byte[] x = blobToBytes(columnBatchInfo.getBlob());
                  byte x1 = x[0];
                  byte x2 = x[1];
                  if (x1 != -1 && x2 != -1) {
                     boolean where = false;
                     byte[] s = SM4Util.encryptEcbBlob(columnBatchInfo.getSecretKey(), x, (String[])null);
                     byte[] prefixBytes = new byte[]{-1, -1};
                     byte[] newArray = new byte[prefixBytes.length + s.length];
                     System.arraycopy(prefixBytes, 0, newArray, 0, prefixBytes.length);
                     System.arraycopy(s, 0, newArray, prefixBytes.length, s.length);
                     pstmt.setBlob(i + 1, new ByteArrayInputStream(newArray));
                  }
               } else {
                  String value = this.doEncryptionMethod(columnBatchInfo.getEncryptionType(), columnBatchInfo.getSecretKey(), columnBatchInfo.getValue(), columnBatchInfo.getIsLike(), columnBatchInfo.getKeepFirst(), columnBatchInfo.getEncDigit(), columnBatchInfo.getTwoIndex());
                  if ("JSON".equals(((ColumnInfoVO)this.columnInfoList.get(i)).getColumnType())) {
                     if (StringUtils.isNotBlank(value)) {
                        String jsonkey = this.props.getProperty("jsonkey");
                        pstmt.setString(i + 1, "{\"" + jsonkey + "\":\"" + value + "\"}");
                     } else {
                        pstmt.setString(i + 1, value);
                     }
                  } else {
                     pstmt.setString(i + 1, value);
                  }
               }
            }

            List<String> primaryKeyListTemp = recordBatchInfoTemp.getPrimaryKeyList();

            for(int i = 0; i < primaryKeyListTemp.size(); ++i) {
               if (!this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                  String cname = this.primaryKeys[i];
                  com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO columnInfoVO = (com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO)this.allColumnList.stream().filter((c) -> c.getColumnname().equals(cname)).findFirst().get();
                  if (!this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                     pstmt.setString(this.columnInfoList.size() + i + 1, (String)primaryKeyListTemp.get(i));
                     pstmt_backups.setString(i + 1, (String)primaryKeyListTemp.get(i));
                  } else if (columnInfoVO.getTypename().toLowerCase(Locale.ROOT).contains("int")) {
                     pstmt.setLong(this.columnInfoList.size() + i + 1, Long.parseLong((String)primaryKeyListTemp.get(i)));
                     pstmt_backups.setLong(i + 1, Long.parseLong((String)primaryKeyListTemp.get(i)));
                  } else {
                     pstmt.setString(this.columnInfoList.size() + i + 1, (String)primaryKeyListTemp.get(i));
                     pstmt_backups.setString(i + 1, (String)primaryKeyListTemp.get(i));
                  }
               } else {
                  String cname = this.primaryKeys[i];
                  com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO columnInfoVO = (com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO)this.allColumnList.stream().filter((c) -> c.getColumnname().equals(cname)).findFirst().get();
                  if (!columnInfoVO.getTypename().toLowerCase(Locale.ROOT).contains("int") && !columnInfoVO.getTypename().toLowerCase(Locale.ROOT).equals("serial") && !columnInfoVO.getTypename().toLowerCase(Locale.ROOT).equals("bigserial")) {
                     pstmt.setString(this.columnInfoList.size() + i + 1, (String)primaryKeyListTemp.get(i));
                     pstmt_backups.setString(i + 1, (String)primaryKeyListTemp.get(i));
                  } else {
                     pstmt.setLong(this.columnInfoList.size() + i + 1, Long.parseLong((String)primaryKeyListTemp.get(i)));
                     pstmt_backups.setLong(i + 1, Long.parseLong((String)primaryKeyListTemp.get(i)));
                  }
               }
            }

            if (this.tCoreDatasystem.getDbtype().equals("HIVE")) {
               pstmt.executeUpdate();
            } else {
               pstmt_backups.addBatch();
               pstmt.addBatch();
            }
         }

         pstmt_backups.executeBatch();
         pstmt_backups.clearBatch();
         pstmt.executeBatch();
         pstmt.clearBatch();
         connection.commit();
         this.encryptionlogger.info("加密完成条数为：{}", finalRecordBatchInfo.size());
      } catch (Throwable e) {
         this.encryptionlogger.error("process error 1", e);
         System.out.println(Thread.currentThread().getName() + "-" + e.getMessage());

         try {
            connection.rollback();
         } catch (SQLException ex) {
            this.encryptionlogger.error("process error 2", ex);
            ex.printStackTrace();
         }
      } finally {
         try {
            if (null != pstmt) {
               pstmt.close();
            }

            if (null != pstmt_backups) {
               pstmt_backups.close();
            }

            if (null != connection) {
               connection.close();
            }
         } catch (Throwable e) {
            System.out.println(Thread.currentThread().getName() + "-" + e.getMessage());
         }

         finalRecordBatchInfo.clear();
      }

   }

   private String doEncryptionMethod(String encryptionType, String secretKey, String value, String isLike, String keepfirst, String encdigit, String twoindex) throws Exception {
      if (null != encryptionType && !"".equals(encryptionType)) {
         value = EncProvider.encryptEcb(encryptionType, secretKey, value, isLike, keepfirst, encdigit, twoindex);
      }

      return value;
   }

   private String checkEncryption(TCoreDatasystem tCoreDatasystem, ColumnInfoVO columnInfoVO, Logger encryptionlogger) {
      encryptionlogger.info("正常信息：开始校验");
      ResultSet rsCount = null;
      int checkNum = Integer.valueOf(this.props.getProperty("checkNum"));
      int sumNum = 0;
      TCoreEncryptionService tCoreEncryptionService = (TCoreEncryptionService)ApplicationContextProvider.getBean(TCoreEncryptionContext.class);

      try {
         Connection conn = JdbcTool.getConnection(tCoreDatasystem);
         Throwable var9 = null;

         try {
            Statement stmt = conn.createStatement();
            Throwable var11 = null;

            try {
               Set<String> columnMap = JdbcTool.getColumnMap(conn, this.schema, this.tableName);
               Boolean bb;
               if (!columnMap.contains(columnInfoVO.getColumnName() + this.copySuffix)) {
                  return "ok";
               }

               encryptionlogger.info("正常信息：校验连接创建成功");
               bb = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                  bb = false;
               }

               Boolean bbb = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                  bbb = false;
               }

               Boolean isgreenplum = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                  isgreenplum = false;
               }

               Boolean SQBoolean = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                  SQBoolean = false;
               }

               Boolean DMBoolean = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                  DMBoolean = false;
               }

               Boolean isHivetdh = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                  isHivetdh = false;
               }

               Boolean isDB2 = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
                  isDB2 = false;
               }

               Boolean isKingbase = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                  isKingbase = false;
               }

               encryptionlogger.info("正常信息：加密非空校验开始");
               int iCLimitCount = 0;
               ResultSet rsC = null;
               String columnName = columnInfoVO.getColumnName();

               Blob columnNameN = null;
               try {
                  if (bb) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + this.schema + "\".\"" + this.tableName + "\" WHERE \"" + columnName + this.copySuffix + "\" IS NOT NULL AND \"" + columnName + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                  } else if (bbb) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + this.schema + "." + this.tableName + " WHERE \"" + columnName + this.copySuffix + "\" IS NOT NULL AND (" + columnName + " IS NULL ) offset " + iCLimitCount + " limit " + checkNum + " )t");
                  } else if (isgreenplum) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + this.schema + "." + this.tableName + " WHERE \"" + columnName + this.copySuffix + "\" IS NOT NULL AND (" + columnName + " IS NULL ) offset " + iCLimitCount + " limit " + checkNum + " )t");
                  } else if (isHivetdh) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM " + this.schema + "." + this.tableName + " WHERE " + columnName + this.copySuffix + " IS NOT NULL AND " + columnName + " IS NULL  limit " + iCLimitCount + " , " + checkNum);
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + this.schema + "." + this.tableName + " WHERE \"" + columnName + this.copySuffix + "\" IS NOT NULL AND (" + columnName + " IS NULL ) offset " + iCLimitCount + " limit " + checkNum + " )t");
                  } else if (SQBoolean) {
                     rsC = stmt.executeQuery(" select  count(1) AS num FROM (  select *, ROW_NUMBER() OVER(Order by " + columnName + " desc ) AS RowId FROM " + this.schema + "." + this.tableName + ") as a  where " + columnName + this.copySuffix + " IS NOT NULL AND " + columnName + " IS NULL and RowId between " + iCLimitCount + " and " + checkNum);
                  } else if (DMBoolean) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + this.schema + "\".\"" + this.tableName + "\" WHERE \"" + columnName + this.copySuffix + "\" IS NOT NULL AND \"" + columnName + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                  } else if (isDB2) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM " + this.schema + "." + this.tableName + " WHERE \"" + columnName + this.copySuffix + "\" IS NOT NULL AND (\"" + columnName + "\" IS NULL  ) limit " + iCLimitCount + " ," + checkNum + "");
                  } else if (isKingbase) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + this.schema + "." + this.tableName + " WHERE length(" + columnName + this.copySuffix + ") > 0 AND length(" + columnName + ") = 0 limit " + iCLimitCount + "," + checkNum + " )t");
                  } else {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM `" + this.schema + "`." + this.tableName + " WHERE " + columnName + this.copySuffix + " IS NOT NULL AND (" + columnName + " IS NULL ) limit " + iCLimitCount + "," + checkNum + " )t");
                  }

                  int num;
                  for(num = 0; rsC.next(); num = rsC.getInt("num")) {
                  }

                  if (num > 0) {
                     StringBuilder mg = new StringBuilder();
                     mg.append("数据源：");
                     mg.append(this.schema);
                     mg.append("表：");
                     mg.append(this.tableName);
                     mg.append("列：");
                     mg.append(columnName);
                     mg.append("加密后的数据为空，加密失败，准备回滚。");
                     encryptionlogger.info("异常信息：加密非空校验：加密后的数据为空，加密失败，准备回滚。");
                     return mg.toString();
                  }

                  encryptionlogger.info("正常信息：加密非空校验通过");
               } catch (Exception e) {
                  e.printStackTrace();
               } finally {
                  if (rsC != null) {
                     try {
                        rsC.close();
                     } catch (SQLException e) {
                        e.printStackTrace();
                     }
                  }

               }

               encryptionlogger.info("正常信息：解密校验开始");
               ResultSet rs1 = null;

               try {
                  if (bb) {
                     rs1 = stmt.executeQuery("select nn.\"" + columnName + "\",nn.\"" + columnName + this.copySuffix + "\" from (select t.\"" + columnName + "\",t.\"" + columnName + this.copySuffix + "\",rownum rn from \"" + this.schema + "\".\"" + this.tableName + "\" t) nn where nn.rn>=" + iCLimitCount + "and nn.rn<" + checkNum);
                  } else if (bbb) {
                     rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + this.copySuffix + "\" from \"" + this.schema + "\".\"" + this.tableName + "\" OFFSET " + iCLimitCount + " LIMIT " + checkNum);
                  } else if (isgreenplum) {
                     rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + this.copySuffix + "\" from \"" + this.schema + "\".\"" + this.tableName + "\" OFFSET " + iCLimitCount + " LIMIT " + checkNum);
                  } else if (isHivetdh) {
                     rs1 = stmt.executeQuery("select " + columnName + "," + columnName + this.copySuffix + " from " + this.schema + "." + this.tableName + " LIMIT " + iCLimitCount + " , " + checkNum);
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                     rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + this.copySuffix + "\" from \"" + this.schema + "\".\"" + this.tableName + "\" LIMIT " + checkNum + " OFFSET " + iCLimitCount);
                  } else if (SQBoolean) {
                     rs1 = stmt.executeQuery("SELECT " + columnName + "," + columnName + this.copySuffix + ", 0 AS _NAV_ORDER_F_ FROM " + this.schema + "." + this.tableName + " ORDER BY _NAV_ORDER_F_ OFFSET " + iCLimitCount + " ROWS FETCH NEXT " + checkNum + " ROWS ONLY");
                  } else if (DMBoolean) {
                     rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + this.copySuffix + "\" from \"" + this.schema + "\".\"" + this.tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                  } else if (isDB2) {
                     rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + this.copySuffix + "\" from \"" + this.schema + "\".\"" + this.tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                  } else if (isKingbase) {
                     String kingbaseSql = "select \"" + columnName + "\",\"" + columnName + this.copySuffix + "\" from \"" + this.schema + "\".\"" + this.tableName + "\"";
                     if (this.primaryKeys.length > 0) {
                        kingbaseSql = kingbaseSql + " order by " + this.primaryKeys[0].toString() + " ";
                     }

                     kingbaseSql = kingbaseSql + " LIMIT " + iCLimitCount + "," + checkNum;
                     rs1 = stmt.executeQuery(kingbaseSql);
                  } else {
                     rs1 = stmt.executeQuery(this.checkColumn(this.schema, this.tableName, columnName, columnName + this.copySuffix, iCLimitCount, checkNum));
                  }

                  while(rs1.next()) {
                     if ("BLOB".equals(columnInfoVO.getColumnType())) {
                        Blob copy = rs1.getBlob(columnName);
                        if (copy != null) {
                           columnNameN = rs1.getBlob(columnName + this.copySuffix);
                           String secretKeyId = columnInfoVO.getSecretKeyId();
                           Map<String, String> encryptionInfo = tCoreEncryptionService.queryEncryptionInfo(secretKeyId);
                           if (null != encryptionInfo.get("encryptionType") && !"".equals(encryptionInfo.get("encryptionType")) && columnNameN != null) {
                              if ("BLOB".equals(columnInfoVO.getColumnType())) {
                                 byte[] bytes = copy.getBytes(1L, 2);
                                 if (bytes[0] != -1 || bytes[1] != -1) {
                                    StringBuilder mg111 = new StringBuilder();
                                    mg111.append("数据源：");
                                    mg111.append(this.schema);
                                    mg111.append("表：");
                                    mg111.append(this.tableName);
                                    mg111.append("列：");
                                    mg111.append(columnName);
                                    mg111.append("加密后的数据解密后与元数据不一致，准备回滚。");
                                    encryptionlogger.info("异常信息：加密后的数据解密后与元数据不一致，准备回滚。");
                                    return mg111.toString();
                                 }
                              }

                              Boolean isEq = true;
                              if ("BLOB".equals(columnInfoVO.getColumnType())) {
                                 Blob blob1 = rs1.getBlob(columnName);
                                 Blob blobN = rs1.getBlob(columnName + this.copySuffix);
                                 byte[] x = blobToBytes(blob1);
                                 byte[] x1 = SM4Util.decryptEcbBlob((String)encryptionInfo.get("secretkey"), x, (String[])null);
                                 byte[] x2 = blobToBytes(blobN);
                                 isEq = Arrays.equals(x2, x1);
                              }

                              if (!isEq) {
                                 StringBuilder mg111 = new StringBuilder();
                                 mg111.append("数据源：");
                                 mg111.append(this.schema);
                                 mg111.append("表：");
                                 mg111.append(this.tableName);
                                 mg111.append("列：");
                                 mg111.append(columnName);
                                 mg111.append("加密后的数据解密后与元数据不一致，准备回滚。");
                                 encryptionlogger.info("异常信息：加密后的数据解密后与元数据不一致，准备回滚。");
                                 return mg111.toString();
                              }
                           }
                        }
                     } else {
                        String copy = rs1.getString(columnName);
                        if (StringUtils.isNotEmpty(copy)) {
                           if ("JSON".equals(columnInfoVO.getColumnType())) {
                              String columnNameNew = this.props.getProperty("jsonkey");
                              JSONObject jsonObject = JSONObject.parseObject(copy);
                              copy = jsonObject.getString(columnNameNew);
                           }

                           String columnNameNew1 = rs1.getString(columnName + this.copySuffix);
                           String secretKeyId = columnInfoVO.getSecretKeyId();
                           Map<String, String> encryptionInfo = tCoreEncryptionService.queryEncryptionInfo(secretKeyId);
                           if (null != encryptionInfo.get("encryptionType") && !"".equals(encryptionInfo.get("encryptionType")) && !StringUtils.isBlank(columnNameNew1)) {
                              if (!copy.contains(this.props.getProperty("encryption.label"))) {
                                 StringBuilder mg111 = new StringBuilder();
                                 mg111.append("数据源：");
                                 mg111.append(this.schema);
                                 mg111.append("表：");
                                 mg111.append(this.tableName);
                                 mg111.append("列：");
                                 mg111.append(columnName);
                                 mg111.append("加密后的数据解密后与元数据不一致，准备回滚。");
                                 encryptionlogger.info("异常信息：加密后的数据解密后与元数据不一致，准备回滚。");
                                 return mg111.toString();
                              }

                              Boolean isEq = EncUtils.compareStringEq(columnNameNew1, EncProvider.decryptEcb((String)encryptionInfo.get("encryptionType"), (String)encryptionInfo.get("secretkey"), copy, columnInfoVO.getIsLike(), columnInfoVO.getKeepfirst(), columnInfoVO.getEncdigit(), columnInfoVO.getTwoindex()));
                              if (!isEq) {
                                 StringBuilder mg111 = new StringBuilder();
                                 mg111.append("数据源：");
                                 mg111.append(this.schema);
                                 mg111.append("表：");
                                 mg111.append(this.tableName);
                                 mg111.append("列：");
                                 mg111.append(columnName);
                                 mg111.append("加密后的数据解密后与元数据不一致，准备回滚。");
                                 encryptionlogger.info("异常信息：加密后的数据解密后与元数据不一致，准备回滚。");
                                 return mg111.toString();
                              }
                           }
                        }
                     }
                  }

                  encryptionlogger.info("正常信息：解密校验通过");
               } catch (Exception e) {
                  e.printStackTrace();
                  encryptionlogger.info("结束校验");
                  return "e1";
               } finally {
                  if (rs1 != null) {
                     try {
                        rs1.close();
                     } catch (SQLException e) {
                        e.printStackTrace();
                     }
                  }

               }
            } catch (Throwable var155) {
               var11 = var155;
               throw var155;
            } finally {
               if (stmt != null) {
                  if (var11 != null) {
                     try {
                        stmt.close();
                     } catch (Throwable var148) {
                        var11.addSuppressed(var148);
                     }
                  } else {
                     stmt.close();
                  }
               }

            }
         } catch (Throwable var157) {
            var9 = var157;
            throw var157;
         } finally {
            if (conn != null) {
               if (var9 != null) {
                  try {
                     conn.close();
                  } catch (Throwable var147) {
                     var9.addSuppressed(var147);
                  }
               } else {
                  conn.close();
               }
            }

         }
      } catch (Exception e) {
         e.printStackTrace();
         encryptionlogger.info("正常信息：校验结束");
         return "e2";
      }

      encryptionlogger.info("正常信息：校验结束");
      return "ok";
   }

   private String checkCopy(String schema, String tableName, String columnName, String checkColumnName) {
      String sql = String.format("SELECT COUNT(1) AS num FROM %s.%s WHERE %s <> NULL AND (%s = NULL or %s = '')", schema, tableName, columnName, checkColumnName, checkColumnName);
      return sql;
   }

   private String checkColumn(String schema, String tableName, String columnName, String checkColumnName, int iCLimitCount, int limitCount) {
      String sql = String.format("SELECT %s,%s FROM %s.%s limit %s,%s", columnName, checkColumnName, schema, tableName, iCLimitCount, limitCount);
      return sql;
   }

   private String delCopyColumn(String schema, String tableName, String columnName) {
      String sql = String.format("ALTER TABLE %s.%s DROP COLUMN %s", schema, tableName, columnName);
      return sql;
   }

   private String columnSizeSql(String schema, String tableName, String columnName) {
      String sql = String.format("SELECT %s FROM %s.%s WHERE 1=2", columnName, schema, tableName);
      return sql;
   }

   private String alterColumnToInitialSqlProject(String schema, String tableName, String columnName, String columnType, String columnSize, String initialSuffix, boolean isupk) {
      String sql = "";
      if (isupk) {
         sql = String.format("ALTER TABLE %s.%s CHANGE COLUMN %s %s %s%s not null", schema, tableName, columnName, columnName + initialSuffix, columnType, columnSize);
      } else {
         sql = String.format("ALTER TABLE %s.%s CHANGE COLUMN %s %s %s%s", schema, tableName, columnName, columnName + initialSuffix, columnType, columnSize);
      }

      return sql;
   }

   private String alterInitialToColumnSqlProject(String schema, String tableName, String columnName, String columnType, String columnSize, String initialSuffix) {
      String sql = String.format("ALTER TABLE %s.%s CHANGE COLUMN %s %s %s%s", schema, tableName, columnName + initialSuffix, columnName, columnType, columnSize);
      return sql;
   }

   private String alterCopyToColumnSqlProject(String schema, String tableName, String columnName, String columnType, String columnSize, String copySuffix, boolean isupk) {
      String sql = "";
      if (isupk) {
         sql = String.format("ALTER TABLE %s.%s CHANGE COLUMN %s %s %s%s not null", schema, tableName, columnName + copySuffix, columnName, columnType, columnSize);
      } else {
         sql = String.format("ALTER TABLE %s.%s CHANGE COLUMN %s %s %s%s", schema, tableName, columnName + copySuffix, columnName, columnType, columnSize);
      }

      return sql;
   }

   private int updateFieldFlag(String id, String flag) {
      int num = this.jdbcTemplate.update("UPDATE t_core_encryption_field SET flag = ? WHERE id = ?", new Object[]{flag, id});
      return num;
   }

   private void addTableField(Connection con, String schema, String tableName, StringBuilder addColumnStrings, StringBuilder addColumnString, Logger encryptionlogger, boolean isupk, ColumnInfoVO columnInfoVO) throws SQLException {
      if (null != addColumnString && addColumnStrings.length() > 0) {
         if ("HIVE_TDH".equals(this.tCoreDatasystem.getDbtype())) {
            Set<String> columnMap = JdbcTool.getColumnMap(this.connection, schema, tableName);
            String cinitial = columnInfoVO.getColumnName() + PropertyGhcaUtil.initialSuffix;
            String sql = "";
            int max = 0;

            try {
               Properties properties = PropertiesLoaderUtils.loadAllProperties("config.properties");
               String property = properties.getProperty("encryption.field.max");
               if (property != null && property.length() > 0) {
                  max = Integer.valueOf(property.trim());
               }
            } catch (Exception e) {
               e.printStackTrace();
            }

            String hiveColumnSize = columnInfoVO.getColumnSize();
            if (max > 0 && Integer.parseInt(hiveColumnSize) >= max) {
               hiveColumnSize = String.valueOf(max);
            } else {
               hiveColumnSize = EncUtils.strColumnSize(this.tCoreDatasystem.getDbtype(), columnInfoVO.getColumnType(), columnInfoVO.getColumnSize(), columnInfoVO.getIsLike(), "0", columnInfoVO.getEncryptionType());
            }

            if (!"STRING".equals(columnInfoVO.getColumnType().toUpperCase(Locale.ROOT))) {
               hiveColumnSize = "(" + hiveColumnSize + ")";
            } else {
               hiveColumnSize = "";
            }

            if (columnMap.contains(cinitial)) {
               sql = "ALTER TABLE " + schema + "." + tableName + "  change " + columnInfoVO.getColumnName() + PropertyGhcaUtil.initialSuffix + " " + columnInfoVO.getColumnName() + PropertyGhcaUtil.copySuffix + " " + columnInfoVO.getColumnType() + hiveColumnSize;
            } else {
               sql = "alter table " + schema + "." + tableName + "  add columns(" + columnInfoVO.getColumnName() + PropertyGhcaUtil.copySuffix + " " + columnInfoVO.getColumnType() + hiveColumnSize + ")";
            }

            if (null != addColumnStrings) {
               encryptionlogger.info("新增加密列：" + addColumnStrings + "  sql语句：" + sql);
            }

            PreparedStatement preStatement = con.prepareStatement(sql);
            preStatement.executeUpdate();
            preStatement.close();
         } else {
            String sql = addColumnString.toString();
            if (isupk) {
               sql = sql + " not null";
            }

            if (null != addColumnStrings) {
               encryptionlogger.info("新增加密列：" + addColumnStrings + "  sql语句：" + sql);
            }

            if ("DB2".equals(this.tCoreDatasystem.getDbtype())) {
               CallableStatement cs = con.prepareCall("call SYSPROC.ADMIN_CMD('reorg table " + schema + "." + tableName + "')");
               cs.execute();
               cs.close();
            }

            PreparedStatement preStatement = con.prepareStatement(sql);
            preStatement.executeUpdate();
            preStatement.close();
            if ("DB2".equals(this.tCoreDatasystem.getDbtype())) {
               CallableStatement cs = con.prepareCall("call SYSPROC.ADMIN_CMD('reorg table " + schema + "." + tableName + "')");
               cs.execute();
               cs.close();
            }
         }
      }

   }

   public void deleteCopyColumn(ColumnInfoVO columnInfoVo, String copySuffix, Statement stmt, Logger encryptionlogger) {
      this.updateFieldFlag(columnInfoVo.getTcoreencryptionfieldId(), "4");
      String rollback;
      if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
         rollback = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\" DROP (\"" + this.columnName + copySuffix + "\")";
      } else if (!this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
         if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
            rollback = this.delCopyColumn(this.schema, this.tableName, this.columnName + copySuffix);
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
            rollback = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\" DROP COLUMN \"" + this.columnName + copySuffix + "\"";
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MYSQL.toString())) {
            rollback = this.delCopyColumn(this.schema, this.tableName, this.columnName + copySuffix);
         } else {
            rollback = this.delCopyColumn(this.schema, this.tableName, this.columnName + copySuffix);
         }
      } else {
         rollback = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\" DROP COLUMN \"" + this.columnName + copySuffix + "\"";
      }

      encryptionlogger.info("加密出错，删除加密列：" + columnInfoVo.getColumnName() + copySuffix);

      try {
         stmt.executeUpdate(rollback);
      } catch (SQLException var7) {
         encryptionlogger.info("删除加密列：" + columnInfoVo.getColumnName() + copySuffix + " 失败， sql语句：" + rollback);
      }

   }

   public void updateInitalColumn(ColumnInfoVO columnInfoVo, String initialSuffix, Statement stmt, Logger encryptionlogger) {
      String columnSizestr = "";
      if (this.tCoreDatasystem.getDbtype().equals(EdbType.MYSQL.toString())) {
         columnSizestr = "(" + columnInfoVo.getColumnSize() + ")";
      }

      this.updateFieldFlag(columnInfoVo.getTcoreencryptionfieldId(), "4");
      String rollback;
      if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
         rollback = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\"  RENAME COLUMN \"" + this.columnName + initialSuffix + "\" TO \"" + this.columnName + "\"";
      } else if (!this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString())) {
         if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
            rollback = "EXEC sp_rename '[" + this.schema + "].[" + this.tableName + "].[" + this.columnName + initialSuffix + "]', '" + this.columnName + "', 'COLUMN'";
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
            rollback = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\"  alter column \"" + this.columnName + initialSuffix + "\" rename to \"" + this.columnName + "\"";
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MYSQL.toString())) {
            rollback = this.alterInitialToColumnSqlProject(this.schema, this.tableName, this.columnName, this.columnType, columnSizestr, initialSuffix);
         } else {
            rollback = this.alterInitialToColumnSqlProject(this.schema, this.tableName, this.columnName, this.columnType, columnSizestr, initialSuffix);
         }
      } else {
         rollback = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\"  RENAME COLUMN \"" + this.columnName + initialSuffix + "\" TO \"" + this.columnName + "\"";
      }

      encryptionlogger.info("加密替换出错，initial列回滚：" + columnInfoVo.getColumnName());

      try {
         stmt.executeUpdate(rollback);
      } catch (SQLException throwables) {
         throwables.printStackTrace();
         encryptionlogger.info("initial列回滚：" + columnInfoVo.getColumnName() + " 失败， sql语句：" + rollback);
         encryptionlogger.info("initial列回滚失败错误：" + throwables.getMessage());
      }

   }

   private boolean isCanKeepRead(ResultSet rs) throws SQLException {
      try {
         boolean isCan = true;
         if (!"HIVE".equals(this.tCoreDatasystem.getDbtype()) && !"HIVE_TDH".equals(this.tCoreDatasystem.getDbtype())) {
            rs.last();
            if (rs.getRow() <= 0) {
               isCan = false;
            }

            rs.beforeFirst();
            System.out.println("isCanKeepRead方法:" + isCan);
            return isCan;
         } else {
            return true;
         }
      } catch (Exception e) {
         System.out.println("isCanKeepRead方法" + e.getMessage());
         throw new SQLException(e);
      }
   }

   private static byte[] blobToBytes(Blob blob) throws Exception {
      try {
         InputStream inputStream = blob.getBinaryStream();
         Throwable var2 = null;

         byte[] var7;
         try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Throwable var4 = null;

            try {
               byte[] buffer = new byte[4096];
               int bytesRead = -1;

               while((bytesRead = inputStream.read(buffer)) != -1) {
                  outputStream.write(buffer, 0, bytesRead);
               }

               var7 = outputStream.toByteArray();
            } catch (Throwable var32) {
               var4 = var32;
               throw var32;
            } finally {
               if (outputStream != null) {
                  if (var4 != null) {
                     try {
                        outputStream.close();
                     } catch (Throwable var31) {
                        var4.addSuppressed(var31);
                     }
                  } else {
                     outputStream.close();
                  }
               }

            }
         } catch (Throwable var34) {
            var2 = var34;
            throw var34;
         } finally {
            if (inputStream != null) {
               if (var2 != null) {
                  try {
                     inputStream.close();
                  } catch (Throwable var30) {
                     var2.addSuppressed(var30);
                  }
               } else {
                  inputStream.close();
               }
            }

         }

         return var7;
      } catch (Exception e) {
         e.printStackTrace();
         throw new Exception("444");
      }
   }

   public String getSqlPaging(String sql1, String sql2) {
      String sqlPaging111 = null;
      if (EdbType.DB2.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
         sqlPaging111 = "SELECT " + sql1 + " FROM ( select row_number() over() as RN ,TT.* FROM  (" + sql2 + " ) TT ) where RN>" + 1 + " AND RN <= " + 10;
      } else if (!EdbType.ORACLE.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.DM.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
         if (!EdbType.POSTGRESQL.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSSDB.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
            if (EdbType.GREENPLUM.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
               sqlPaging111 = sql2 + " limit " + 1 + " OFFSET " + 10;
            } else if (EdbType.MYSQL.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) || EdbType.KINGBASE.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) || EdbType.MARIADB.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
               sqlPaging111 = sql2 + " limit " + 1 + "," + 10;
            }
         } else {
            sqlPaging111 = sql2 + " offset " + 1 + " limit " + 10;
         }
      } else {
         sqlPaging111 = "SELECT " + sql1 + " FROM ( select ROWNUM RN ,TT.* FROM  (" + sql2 + " ) TT ) where RN>" + 1 + " AND RN <= " + 10;
      }

      return sqlPaging111;
   }

   private void rollbackColumns(Connection conn, List<ColumnInfoVO> allColumns, String suffix, List<String> colSizes, List<String> pkFlags, List<String> pkCols, TCoreDatasystem tCoreDatasystem) {
      if (allColumns != null && allColumns.size() != 0) {
         Set<String> colSet = JdbcTool.getColumnMap(conn, this.schema, this.tableName);

         for(int i = 0; i < allColumns.size(); ++i) {
            try {
               ColumnInfoVO column = (ColumnInfoVO)allColumns.get(i);
               JdbcTool.rollbackReplaceColumn(conn, colSet, this.schema, this.tableName, column.getColumnName(), column.getColumnName() + suffix, column.getColumnType(), colSizes == null ? null : (String)colSizes.get(i), pkFlags == null ? null : (String)pkFlags.get(i), pkCols == null ? null : (String)pkCols.get(i), column.getColumnName(), tCoreDatasystem);
            } catch (Exception ex) {
               ex.printStackTrace();
            }
         }

      }
   }
}
