package com.chenyang.nse.bussiness.tools.dataprocess.hive;

import java.util.ArrayList;
import java.util.List;

public enum HiveEncDecType {
   jdbc,
   webHdfs;

   public String getTypeName() {
      return this.name().toLowerCase();
   }

   public static List<String> getHiveEncDecTypeNames() {
      List<String> names = new ArrayList();
      names.add(jdbc.name().toLowerCase());
      names.add(webHdfs.name().toLowerCase());
      return names;
   }

   public static HiveEncDecType fromName(String name) {
      if (name != null && name.length() != 0) {
         switch (name.toUpperCase()) {
            case "JDBC":
               return jdbc;
            case "WEBHDFS":
               return webHdfs;
            default:
               return null;
         }
      } else {
         return null;
      }
   }
}
