package com.chenyang.nse.bussiness.tools.dataprocess.hive;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.io.IOUtils;

public class TdhHiveTool {
   public static List<HashMap<String, String>> getHdfsList(String kerberosPath, String user, String rootPath, String hdfsPath) throws RemoteException, IOException {
      List<HashMap<String, String>> listmap = new ArrayList();
      Configuration configuration = new Configuration();
      configuration.addResource(new Path(kerberosPath + "/core-site.xml"));
      configuration.addResource(new Path(kerberosPath + "/hdfs-site.xml"));
      configuration.set("fs.hdfs.impl", DistributedFileSystem.class.getName());

      try {
         FileSystem fileSystem = FileSystem.get(new URI(rootPath), configuration);
         FileStatus[] files = fileSystem.listStatus(new Path(hdfsPath));
         HashMap<String, String> maps = new HashMap();
         maps.put("path", "");
         maps.put("name", "..");
         maps.put("length", "");
         maps.put("replication", "");
         maps.put("blocksize", "");
         maps.put("owner", "");
         maps.put("modification_time", "");
         maps.put("access_time", "");
         maps.put("group", "");
         maps.put("permission", "");
         maps.put("isDirectory", "true");
         listmap.add(maps);

         for(FileStatus file1 : files) {
            HashMap<String, String> map = new HashMap();
            map.put("path", file1.getPath().toString());
            map.put("name", file1.getPath().getName());
            map.put("length", String.valueOf(file1.getLen()));
            map.put("replication", Integer.toString(file1.getReplication()));
            map.put("blocksize", String.valueOf(file1.getBlockSize()));
            map.put("owner", file1.getOwner());
            Date date = new Date(file1.getModificationTime());
            String modification_time = DateFormatUtils.format(date, "yyyy-MM-dd HH:mm:ss");
            map.put("modification_time", modification_time);
            Date date1 = new Date(file1.getAccessTime());
            String access_time = DateFormatUtils.format(date1, "yyyy-MM-dd HH:mm:ss");
            map.put("access_time", access_time);
            map.put("group", file1.getGroup());
            map.put("permission", file1.getPermission().toString());
            map.put("isDirectory", file1.isDirectory() + "");
            map.put("user", user);
            listmap.add(map);
         }
      } catch (URISyntaxException | IOException e) {
         ((Exception)e).printStackTrace();
      }

      return listmap;
   }

   public static synchronized void readHdfsToPipe(String xmlPath, List<String> hdfs_filepathlist, String rootPath, String tdhHdfsPath, String hdfsPath) throws IOException {
      Configuration configuration = new Configuration();
      configuration.addResource(new Path(xmlPath + "/core-site.xml"));
      configuration.addResource(new Path(xmlPath + "/hdfs-site.xml"));
      configuration.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
      FSDataInputStream in = null;
      FileOutputStream fos = null;
      FileSystem fs = null;

      try {
         fs = FileSystem.get(new URI(rootPath), configuration);
         File file = new File(hdfsPath);
         fos = new FileOutputStream(file);

         for(String hdfs_filepath : hdfs_filepathlist) {
            hdfs_filepath = hdfs_filepath.replaceFirst(tdhHdfsPath, rootPath);
            in = fs.open(new Path(hdfs_filepath));
            IOUtils.copyBytes(in, fos, configuration, false);
         }
      } catch (URISyntaxException | IOException e) {
         ((Exception)e).printStackTrace();
      } finally {
         if (in != null) {
            IOUtils.closeStream(in);
         }

         if (fos != null) {
            IOUtils.closeStream(fos);
         }

         if (fs != null) {
            fs.close();
         }

      }

   }
}
