package com.chenyang.nse.bussiness.tools.dmp;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.tools.command.CommandTool;
import com.chenyang.nse.bussiness.tools.datatime.DateTime1Tool;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class DmpTool_0702BAK {
   public static final int arraySize = 1000;

   private List<String> show(List<String> createTableSql, String filePath) {
      List<String> jlList = new ArrayList();

      try {
         int d = 0;
         String tablename = ((String)createTableSql.get(d)).split("\"")[1];
         FileOutputStream os = new FileOutputStream("C:\\Users\\Administrator\\Desktop\\脱敏平台相关支援\\9、DMP文件解析20190619\\other\\table\\" + tablename + ".txt");
         Writer writer = new OutputStreamWriter(os);
         BufferedWriter bufferedWriter = new BufferedWriter(writer);
         File f = new File(filePath);
         int len = (int)f.length();
         byte[] buf = new byte[len];
         FileInputStream fis = new FileInputStream(f);
         fis.read(buf);
         int i = 0;
         StringBuffer sb = new StringBuffer();
         int count00 = 0;
         boolean issys = false;
         String lastbuf16 = "";

         while(i < len) {
            for(int j = 0; j < 16; ++j) {
               String buf16 = toHex(buf[i]);
               if (!issys) {
                  if (count00 == 5) {
                     if (!buf16.equals("00")) {
                        issys = true;
                     } else {
                        count00 = -1;
                     }
                  }

                  if (buf16.equals("00")) {
                     ++count00;
                  } else {
                     count00 = 0;
                  }
               }

               if (i >= buf.length) {
                  break;
               }

               if (issys) {
                  if (buf16.equals("00") && lastbuf16.equals("00")) {
                     String createsql = (String)createTableSql.get(d);
                     List<String> colTypeList = regularSqlType(createsql);
                     StringBuffer writebuf = parsing1(colTypeList, sb.toString().substring(0, sb.length() - 2), ",");
                     bufferedWriter.write(writebuf.toString());
                     sb = new StringBuffer();
                  } else if (buf16.equals("FF") && lastbuf16.equals("FF")) {
                     issys = false;
                     ++d;
                     if (d < createTableSql.size()) {
                        tablename = ((String)createTableSql.get(d)).split("\"")[1];
                        os = new FileOutputStream("C:\\Users\\Administrator\\Desktop\\脱敏平台相关支援\\9、DMP文件解析20190619\\other\\table\\" + tablename + ".txt");
                        Writer var26 = new OutputStreamWriter(os);
                        bufferedWriter = new BufferedWriter(var26);
                     }

                     sb = new StringBuffer();
                  } else {
                     sb.append(buf16);
                  }
               }

               lastbuf16 = buf16;
               ++i;
            }
         }

         bufferedWriter.flush();
         bufferedWriter.close();
      } catch (Exception e) {
         e.printStackTrace();
      }

      return jlList;
   }

   public static StringBuffer parsing1(List<String> colTypeList, String content, String split) {
      StringBuffer sb = new StringBuffer();

      try {
         String[] content_sz = new String[content.length() / 2];

         for(int j = 0; j < content.length(); j += 2) {
            content_sz[j / 2] = content.substring(j, j + 2);
         }

         int content_length = content_sz.length;
         int point = 0;

         for(int colIndex = 0; point < content_length; ++point) {
            if (content_sz[point].equals("00")) {
               String content16 = "";
               int zd_length = binary16_10(content_sz[point - 1]);
               ++point;

               for(int j = point; j < point + zd_length; ++j) {
                  content16 = content16 + content_sz[j];
               }

               String colType = (String)colTypeList.get(colIndex);
               sb.append("\"");
               if (colType.equals("VARCHAR2")) {
                  sb.append(stringToGbk(content16));
               } else if (colType.equals("CHAR")) {
                  sb.append(stringToGbk(content16));
               } else if (colType.equals("NUMBER")) {
                  sb.append(numberParsing(content16));
               } else if (colType.equals("DATE")) {
                  sb.append(dateParsing(content16));
               }

               sb.append("\"");
               sb.append(split);
               point += zd_length - 1;
               ++colIndex;
            }

            if (content_sz[point].equals("FF") && content_sz[point - 1].equals("FE")) {
               sb.append(split);
               ++point;
               ++colIndex;
            }
         }

         sb.append("\r\n");
      } catch (Exception e) {
         e.printStackTrace();
      }

      return sb;
   }

   public static int binary16_10(String str) {
      return Integer.parseInt(str, 16);
   }

   public static String stringToGbk(String string) {
      String result = "";

      try {
         byte[] bytes = new byte[string.length() / 2];

         for(int i = 0; i < bytes.length; ++i) {
            byte high = Byte.parseByte(string.substring(i * 2, i * 2 + 1), 16);
            byte low = Byte.parseByte(string.substring(i * 2 + 1, i * 2 + 2), 16);
            bytes[i] = (byte)(high << 4 | low);
         }

         result = new String(bytes, "gbk");
      } catch (UnsupportedEncodingException e) {
         e.printStackTrace();
      }

      return result;
   }

   public static String dateParsing(String content16) {
      String datefmt = "yyyy-MM-dd HH:mm:ss";
      Calendar calendar = Calendar.getInstance();
      int[] date = new int[6];
      String reStr = "";

      for(int i = 0; i < content16.length(); i += 2) {
         int sz = binary16_10(content16.substring(i, i + 2));
         if (i == 0 || i == 2) {
            sz -= 100;
         }

         reStr = reStr + String.format("%02d", sz);
         if (i != 0) {
            date[i / 2 - 1] = Integer.parseInt(reStr);
            reStr = "";
         }
      }

      calendar.set(date[0], date[1] - 1, date[2], date[3] - 1, date[4] - 1, date[5] - 1);
      SimpleDateFormat sdf = new SimpleDateFormat(datefmt);
      String dateStr = sdf.format(calendar.getTime());
      return dateStr;
   }

   public static List<String> regularSqlType(String msg) {
      List<String> regTypeList = new ArrayList();
      Pattern p = Pattern.compile("( VARCHAR2| CHAR| NUMBER| DATE)");
      Matcher m = p.matcher(msg);

      while(m.find()) {
         String khcontent = m.group().substring(1, m.group().length());
         regTypeList.add(khcontent);
      }

      return regTypeList;
   }

   public static String numberParsing(String content16) {
      int ws = binary16_10(content16.substring(0, 2)) - 192;
      String reInt = "";
      if (ws > 0) {
         if (!content16.substring(0, 1).equals("C")) {
            System.out.println("NUMBER正数报错：可能已串位！" + content16);
         } else {
            while(content16.length() - 2 != ws * 2) {
               content16 = content16 + "01";
            }

            for(int i = 2; i < content16.length(); i += 2) {
               int sz = binary16_10(content16.substring(i, i + 2)) - 1;
               if (i != 2) {
                  reInt = reInt + String.format("%02d", sz);
               } else {
                  reInt = reInt + sz;
               }
            }
         }
      } else if (content16.equals("80")) {
         reInt = "0";
      } else if (content16.equals("30")) {
         reInt = "";
      } else {
         content16 = content16.substring(0, content16.length() - 2);
         if (content16.substring(0, 1).equals("3")) {
            for(int var6 = 63 - binary16_10(content16.substring(0, 2)); content16.length() - 2 != var6 * 2; content16 = content16 + "65") {
            }

            for(int i = 2; i < content16.length(); i += 2) {
               int sz = 101 - binary16_10(content16.substring(i, i + 2));
               if (i != 2) {
                  reInt = reInt + String.format("%02d", sz);
               } else {
                  reInt = reInt + sz;
               }
            }

            reInt = "-" + reInt;
         } else {
            System.out.println("NUMBER负数报错：可能已串位！" + content16);
         }
      }

      return reInt;
   }

   public static List<String> createTableSql(String dmpFilePath) {
      Date startDate = new Date();
      List<String> createTableSqlList = new ArrayList();
      List<String> insertTableSql = new ArrayList();
      List<String> uniqueTableSql = new ArrayList();
      List<String> synonTableSql = new ArrayList();
      List<String> viewTableSql = new ArrayList();

      try {
         FileInputStream is = new FileInputStream(dmpFilePath);
         Reader reader = new InputStreamReader(is);
         BufferedReader bufferedReader = new BufferedReader(reader);
         String line = "";
         int lineNum = 0;

         while((line = bufferedReader.readLine()) != null) {
            ++lineNum;
            line = new String(line.getBytes("ISO-8859-1"), "GBK");
            if (line.length() > 12) {
               String top12 = line.substring(0, 12);
               if (top12.equals("CREATE TABLE")) {
                  createTableSqlList.add(lineNum + line);
               } else if (top12.equals("INSERT INTO ")) {
                  insertTableSql.add(line);
               } else if (top12.equals("CREATE UNIQU")) {
                  uniqueTableSql.add(line);
               } else if (top12.equals("CREATE SYNON")) {
                  synonTableSql.add(line);
               } else if (top12.equals("CREATE VIEW ")) {
                  viewTableSql.add(line);
               }
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      Date endDate = new Date();
      long useTime = DateTime1Tool.dateBetween(startDate, endDate);
      System.out.println(">>>>>>>>>>>>>>createTableSql useTime:" + useTime + "毫秒");
      return createTableSqlList;
   }

   public static List<String> getAllTableNameList(String dmpFilePath) {
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String dmppath = props.getProperty("dmp_file_path");
      dmpFilePath = dmppath + dmpFilePath;
      List<String> createTableSqlList = createTableSql(dmpFilePath);
      List<String> tableNameList = new ArrayList();

      for(int i = 0; i < createTableSqlList.size(); ++i) {
         String createTableSqlStr = (String)createTableSqlList.get(i);
         int tableNameStartIndex = createTableSqlStr.indexOf("TABLE") + 5;
         int tableNameEndIndex = createTableSqlStr.indexOf("(");
         String tableNameBuf = createTableSqlStr.substring(tableNameStartIndex, tableNameEndIndex);
         tableNameBuf = tableNameBuf.trim();
         String tName = tableNameBuf.replaceAll("\"", "");
         tableNameList.add(tName);
      }

      return tableNameList;
   }

   public static List<String> getTypeNameListByTableName(String dmpFilePath, String tablename) {
      if (StringUtils.isBlank(tablename)) {
         return null;
      } else {
         List<String> typeNameLst = new ArrayList();
         List<String> createTableSqlList = createTableSql(dmpFilePath);

         for(int i = 0; i < createTableSqlList.size(); ++i) {
            String createTableSqlStr = (String)createTableSqlList.get(i);
            int tableNameStartIndex = createTableSqlStr.indexOf("TABLE") + 5;
            int tableNameEndIndex = createTableSqlStr.indexOf("(");
            String tableNameBuf = createTableSqlStr.substring(tableNameStartIndex, tableNameEndIndex);
            tableNameBuf = tableNameBuf.trim();
            String tName = tableNameBuf.replaceAll("\"", "");
            if (tablename.equalsIgnoreCase(tName)) {
               int colInfoStartIndex = createTableSqlStr.indexOf("(") + 1;
               int colInfoEndIndex = createTableSqlStr.indexOf(")  PCTFREE");
               String colInfosBuf = createTableSqlStr.substring(colInfoStartIndex, colInfoEndIndex);
               colInfosBuf = colInfosBuf.trim();
               String[] colInfoArr = colInfosBuf.split(", \"");

               for(int j = 0; j < colInfoArr.length; ++j) {
                  String colInfoBuf = colInfoArr[j];
                  colInfoBuf = colInfoBuf.trim();
                  String[] colInfoBufArr = colInfoBuf.split("\" ");
                  String columnname = colInfoBufArr[0];
                  columnname = columnname.replaceAll("\"", "");
                  String colTypeBuf = colInfoBufArr[1];
                  String typename = colTypeBuf;
                  int colTypeEndIndex = colTypeBuf.indexOf("(");
                  if (colTypeEndIndex > 0) {
                     typename = colTypeBuf.substring(0, colTypeEndIndex);
                  }

                  typeNameLst.add(typename);
               }
            }
         }

         return typeNameLst;
      }
   }

   public static List<ColumnInfoVO> getColListByTableName(String dmpFilePath, String tablename) {
      if (StringUtils.isBlank(tablename)) {
         return null;
      } else {
         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         String dmppath = props.getProperty("dmp_file_path");
         dmpFilePath = dmppath + dmpFilePath;
         List<ColumnInfoVO> columnInfoLst = new ArrayList();
         List<String> createTableSqlList = createTableSql(dmpFilePath);

         for(int i = 0; i < createTableSqlList.size(); ++i) {
            String createTableSqlStr = (String)createTableSqlList.get(i);
            int tableNameStartIndex = createTableSqlStr.indexOf("TABLE") + 5;
            int tableNameEndIndex = createTableSqlStr.indexOf("(");
            String tableNameBuf = createTableSqlStr.substring(tableNameStartIndex, tableNameEndIndex);
            tableNameBuf = tableNameBuf.trim();
            String tName = tableNameBuf.replaceAll("\"", "");
            if (tablename.equalsIgnoreCase(tName)) {
               int colInfoStartIndex = createTableSqlStr.indexOf("(") + 1;
               int colInfoEndIndex = createTableSqlStr.indexOf(")  PCTFREE");
               String colInfosBuf = createTableSqlStr.substring(colInfoStartIndex, colInfoEndIndex);
               colInfosBuf = colInfosBuf.trim();
               String[] colInfoArr = colInfosBuf.split(", \"");

               for(int j = 0; j < colInfoArr.length; ++j) {
                  ColumnInfoVO columnInfo = new ColumnInfoVO();
                  String colInfoBuf = colInfoArr[j];
                  colInfoBuf = colInfoBuf.trim();
                  String[] colInfoBufArr = colInfoBuf.split("\" ");
                  String columnname = colInfoBufArr[0];
                  columnname = columnname.replaceAll("\"", "");
                  String colTypeBuf = colInfoBufArr[1];
                  String typename = colTypeBuf;
                  String columnsize = "";
                  String decimaldigits = null;
                  int colTypeEndIndex = colTypeBuf.indexOf("(");
                  if (colTypeEndIndex > 0) {
                     typename = colTypeBuf.substring(0, colTypeEndIndex);
                     int digitsEndIndex = colTypeBuf.indexOf(")");
                     String precisionStr = colTypeBuf.substring(colTypeEndIndex + 1, digitsEndIndex);
                     String[] precisionArr = precisionStr.split(",");
                     columnsize = precisionArr[0].trim();
                     if ("*".equalsIgnoreCase(columnsize) && "NUMBER".equalsIgnoreCase(typename)) {
                        columnsize = "38";
                     }

                     if (precisionArr.length > 1) {
                        decimaldigits = precisionArr[1].trim();
                     }
                  }

                  if ("date".equalsIgnoreCase(typename)) {
                     columnsize = "7";
                  }

                  columnInfo.setTablename(tablename);
                  columnInfo.setColumnname(columnname);
                  columnInfo.setTypename(typename);
                  columnInfo.setColumnsize(columnsize == null ? "" : columnsize);
                  columnInfo.setDecimaldigits(decimaldigits == null ? "" : decimaldigits);
                  columnInfo.setMaskingruleid("");
                  columnInfo.setMaskingrulename("");
                  columnInfo.setRegextype("");
                  columnInfo.setTargettypename("");
                  columnInfo.setRemarks("");
                  columnInfoLst.add(columnInfo);
               }
            }
         }

         return columnInfoLst;
      }
   }

   public static void prasingDataByTableName(String dmpFileName, String taskname, String tablename) {
      if (null != tablename) {
         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         String dmppath = props.getProperty("dmp_file_path");
         dmpFileName = dmppath + dmpFileName;
         String tablenameHexStr = tableName2HexStr(tablename);

         try {
            String createTableSql = "";
            List<String> createTableSqlLst = createTableSql(dmpFileName);

            for(int i = 0; i < createTableSqlLst.size(); ++i) {
               String createTableSqlStr = (String)createTableSqlLst.get(i);
               if (StringUtils.isNotBlank(createTableSqlStr) && createTableSqlStr.contains(tablename)) {
                  ;
               }
            }

            String path = props.getProperty("dmp_exp_table_file_path");
            String pipeFilePath = path + taskname + "/";
            FileTool.createFolder(pipeFilePath);
            String pipeFileName = tablename + ".pipe";
            String rmPipeFileCmd = "rm -f " + pipeFilePath + pipeFileName;
            String mkrPipeFileCmd = "mkfifo " + pipeFilePath + pipeFileName;
            CommandTool.command(rmPipeFileCmd);
            CommandTool.command(mkrPipeFileCmd);
            CommandTool.command("chmod -R 777 " + pipeFilePath + pipeFileName);
            FileOutputStream os = new FileOutputStream(pipeFilePath + pipeFileName);
            Writer writer = new OutputStreamWriter(os, "utf-8");
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            File f = new File(dmpFileName);
            int len = (int)f.length();
            byte[] btyebufArr = new byte[1000];
            StreamFileReader fis = new StreamFileReader(dmpFileName, 1000);
            StringBuffer sb = new StringBuffer();
            int count00 = 0;
            boolean issys = false;
            String lastbuf16 = "";
            int i = 0;
            fis.read();
            btyebufArr = fis.getArray();
            int btyebufArrLen = 0;
            String finishFlg = "0";
            String createTableStartMark = "0";
            StringBuffer createTableStartMarkStrBuf = new StringBuffer();
            int createTableStartMarkLen = 14;
            int createTableStartMarkIndex = 0;
            String tableNameStartFlg = "0";
            StringBuffer createTableNameStrBuf = new StringBuffer();
            String createTableStartFlg = "0";
            String isMatchTable = "0";

            while(i < len) {
               for(int j = 0; j < 16; ++j) {
                  if (i >= len) {
                     return;
                  }

                  if (btyebufArrLen >= 1000) {
                     fis.read();
                     btyebufArr = fis.getArray();
                     btyebufArrLen = 0;
                  }

                  String buf16 = toHex(btyebufArr[btyebufArrLen]);
                  if ("0".equals(createTableStartFlg)) {
                     if ("43".equals(buf16)) {
                        createTableStartMark = "1";
                        createTableStartMarkIndex = 0;
                        createTableStartMarkStrBuf = new StringBuffer();
                     }

                     if ("1".equals(createTableStartMark)) {
                        createTableStartMarkStrBuf.append(buf16);
                        ++createTableStartMarkIndex;
                        if (createTableStartMarkIndex >= createTableStartMarkLen && "435245415445205441424C452022".equalsIgnoreCase(createTableStartMarkStrBuf.toString())) {
                           createTableStartMark = "0";
                           tableNameStartFlg = "1";
                           createTableStartFlg = "1";
                        }
                     }
                  } else if ("1".equals(createTableStartFlg) && !"1".equals(isMatchTable)) {
                     if ("1".equals(tableNameStartFlg)) {
                        if ("22".equals(buf16)) {
                           tableNameStartFlg = "0";
                        } else {
                           createTableNameStrBuf.append(buf16);
                        }
                     } else if ("0".equals(tableNameStartFlg)) {
                        if (!tablenameHexStr.equals(createTableNameStrBuf.toString())) {
                           createTableStartFlg = "0";
                        } else {
                           isMatchTable = "1";
                        }

                        createTableNameStrBuf = new StringBuffer();
                     }
                  }

                  if ("1".equals(isMatchTable)) {
                     if (!issys) {
                        if (count00 == 5) {
                           if (!buf16.equals("00")) {
                              issys = true;
                           } else {
                              count00 = -1;
                           }
                        }

                        if (buf16.equals("00")) {
                           ++count00;
                        } else {
                           count00 = 0;
                        }
                     }

                     if (issys) {
                        if (buf16.equals("00") && lastbuf16.equals("00")) {
                           List<String> colTypeList = getTypeNameListByTableName(dmpFileName, tablename);
                           StringBuffer writebuf = parsing1(colTypeList, sb.toString().substring(0, sb.length() - 2), ",");
                           bufferedWriter.write(writebuf.toString());
                           sb = new StringBuffer();
                        } else if (buf16.equals("FF") && lastbuf16.equals("FF")) {
                           finishFlg = "1";
                        } else {
                           sb.append(buf16);
                        }
                     }
                  }

                  lastbuf16 = buf16;
                  ++i;
                  ++btyebufArrLen;
                  if ("1".equals(finishFlg)) {
                     bufferedWriter.flush();
                     bufferedWriter.close();
                     return;
                  }
               }
            }
         } catch (Exception e) {
            e.printStackTrace();
         }

      }
   }

   public static void main(String[] args) {
      new DmpTool();
      String dmpFilePath = "C:\\Users\\Administrator\\Desktop\\脱敏平台相关支援\\9、DMP文件解析20190619\\other\\test222.dmp";
      long starttime = (new Date()).getTime();
      String tablename = "DMP_TEST4";
      tablename = tablename.toUpperCase();
      dmpFilePath = "test4.dmp";
      prasingDataByTableNameByRowNum(dmpFilePath, "190701140327_dmptest555", tablename, 2);
      long endtime = (new Date()).getTime();
      System.out.println("总耗时:" + (endtime - starttime) + "毫秒");
   }

   public static String tableName2HexStr(String tablename) {
      byte[] tablenameByteArr = tablename.getBytes();
      StringBuffer tableNameHexBuf = new StringBuffer();

      for(int i = 0; i < tablenameByteArr.length; ++i) {
         byte tablenameByte = tablenameByteArr[i];
         String tablenameHexStr = toHex(tablenameByte);
         tableNameHexBuf.append(tablenameHexStr);
      }

      return tableNameHexBuf.toString();
   }

   private static String toHex(byte b) {
      int i = b & 255;
      String s = "";
      if (null != Integer.toHexString(i)) {
         s = Integer.toHexString(i).toUpperCase();
         if (s.length() == 1) {
            s = '0' + s;
         }
      } else {
         System.out.println("btye is:" + b + ":toHex 方法：十进制数转换为十六进制字符串时返回了NULL!");
      }

      return s;
   }

   public static List<Object[]> prasingDataByTableNameByRowNum(String dmpFileName, String taskname, String tablename, int maxCnt) {
      if (null == tablename) {
         return null;
      } else {
         List<Object[]> reDataLst = new ArrayList();
         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         String dmppath = props.getProperty("dmp_file_path");
         dmpFileName = dmppath + dmpFileName;
         String tablenameHexStr = tableName2HexStr(tablename);

         try {
            String createTableSql = "";
            List<String> createTableSqlLst = createTableSql(dmpFileName);

            for(int i = 0; i < createTableSqlLst.size(); ++i) {
               String createTableSqlStr = (String)createTableSqlLst.get(i);
               if (StringUtils.isNotBlank(createTableSqlStr) && createTableSqlStr.contains(tablename)) {
                  ;
               }
            }

            String path = props.getProperty("dmp_exp_table_file_path");
            String pipeFilePath = path + taskname + "/";
            FileTool.createFolder(pipeFilePath);
            String pipeFileName = tablename + ".pipe";
            String rmPipeFileCmd = "rm -f " + pipeFilePath + pipeFileName;
            String mkrPipeFileCmd = "mkfifo " + pipeFilePath + pipeFileName;
            CommandTool.command(rmPipeFileCmd);
            CommandTool.command(mkrPipeFileCmd);
            CommandTool.command("chmod -R 777 " + pipeFilePath + pipeFileName);
            FileOutputStream os = new FileOutputStream(pipeFilePath + pipeFileName);
            Writer writer = new OutputStreamWriter(os, "utf-8");
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            File f = new File(dmpFileName);
            int len = (int)f.length();
            byte[] btyebufArr = new byte[1000];
            StreamFileReader fis = new StreamFileReader(dmpFileName, 1000);
            StringBuffer sb = new StringBuffer();
            int count00 = 0;
            boolean issys = false;
            String lastbuf16 = "";
            int i = 0;
            fis.read();
            btyebufArr = fis.getArray();
            int btyebufArrLen = 0;
            String finishFlg = "0";
            String createTableStartMark = "0";
            StringBuffer createTableStartMarkStrBuf = new StringBuffer();
            int createTableStartMarkLen = 14;
            int createTableStartMarkIndex = 0;
            String tableNameStartFlg = "0";
            StringBuffer createTableNameStrBuf = new StringBuffer();
            String createTableStartFlg = "0";
            String isMatchTable = "0";

            while(i < len) {
               for(int j = 0; j < 16; ++j) {
                  if (i >= len) {
                     return reDataLst;
                  }

                  if (btyebufArrLen >= 1000) {
                     fis.read();
                     btyebufArr = fis.getArray();
                     btyebufArrLen = 0;
                  }

                  String buf16 = toHex(btyebufArr[btyebufArrLen]);
                  if ("0".equals(createTableStartFlg)) {
                     if ("43".equals(buf16)) {
                        createTableStartMark = "1";
                        createTableStartMarkIndex = 0;
                        createTableStartMarkStrBuf = new StringBuffer();
                     }

                     if ("1".equals(createTableStartMark)) {
                        createTableStartMarkStrBuf.append(buf16);
                        ++createTableStartMarkIndex;
                        if (createTableStartMarkIndex >= createTableStartMarkLen && "435245415445205441424C452022".equalsIgnoreCase(createTableStartMarkStrBuf.toString())) {
                           createTableStartMark = "0";
                           tableNameStartFlg = "1";
                           createTableStartFlg = "1";
                        }
                     }
                  } else if ("1".equals(createTableStartFlg) && !"1".equals(isMatchTable)) {
                     if ("1".equals(tableNameStartFlg)) {
                        if ("22".equals(buf16)) {
                           tableNameStartFlg = "0";
                        } else {
                           createTableNameStrBuf.append(buf16);
                        }
                     } else if ("0".equals(tableNameStartFlg)) {
                        if (!tablenameHexStr.equals(createTableNameStrBuf.toString())) {
                           createTableStartFlg = "0";
                        } else {
                           isMatchTable = "1";
                        }

                        createTableNameStrBuf = new StringBuffer();
                     }
                  }

                  if ("1".equals(isMatchTable)) {
                     if (!issys) {
                        if (count00 == 5) {
                           if (!buf16.equals("00")) {
                              issys = true;
                           } else {
                              count00 = -1;
                           }
                        }

                        if (buf16.equals("00")) {
                           ++count00;
                        } else {
                           count00 = 0;
                        }
                     }

                     if (issys) {
                        if (buf16.equals("00") && lastbuf16.equals("00")) {
                           List<String> colTypeList = getTypeNameListByTableName(dmpFileName, tablename);
                           StringBuffer writebuf = parsing1(colTypeList, sb.toString().substring(0, sb.length() - 2), ",");
                           if (maxCnt <= 0) {
                              finishFlg = "1";
                           }

                           if (null != writebuf && writebuf.length() > 0 && !"1".equals(finishFlg)) {
                              String writebufStr = writebuf.toString();
                              String[] writebufStrArr = writebufStr.split(",");
                              reDataLst.add(writebufStrArr);
                           }

                           --maxCnt;
                           sb = new StringBuffer();
                        } else if (buf16.equals("FF") && lastbuf16.equals("FF")) {
                           finishFlg = "1";
                        } else {
                           sb.append(buf16);
                        }
                     }
                  }

                  lastbuf16 = buf16;
                  ++i;
                  ++btyebufArrLen;
                  if ("1".equals(finishFlg)) {
                     bufferedWriter.flush();
                     bufferedWriter.close();
                     return reDataLst;
                  }
               }
            }
         } catch (Exception e) {
            e.printStackTrace();
         }

         return reDataLst;
      }
   }
}
