package com.chenyang.nse.bussiness.tools.encryption.sm4fpe;

import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.regex.Pattern;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM4FPEName extends SM4FPEBase {
   static ArrayList<SM4FPEEntity> nameEntities = new ArrayList();
   static ArrayList firstnameChars;
   static char[] lastnameChars;
   static String[] lastnameDuplicateStr;
   static ArrayList otherChinese;
   static HashMap firstnameCharsMap;
   static HashMap lastnameCharsMap;
   static HashMap lastnameDuplicateStrMap;
   static HashMap otherChineseMap;
   private static Pattern allChinesePattern;

   public String encryptEcb(String hexKey, String a) throws Exception {
      String out = this.encrypt(hexKey, a, nameEntities);
      return out;
   }

   public String decryptEcb(String hexKey, String input) throws Exception {
      String out = this.decrypt(hexKey, input, nameEntities);
      return out;
   }

   public static boolean isPersonName(String name) {
      boolean result = false;
      int length = name.length();
      if (length >= 2 && length <= 50) {
         if (null == allChinesePattern) {
            allChinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
         }

         if (allChinesePattern.matcher(name).matches()) {
            char[] tmp = name.toCharArray();
            int i = 1;
            if (((SM4FPEEntity)nameEntities.get(0)).getCharsMap().get(name.substring(0, 2)) == null) {
               if (((SM4FPEEntity)nameEntities.get(1)).getCharsMap().get(tmp[0]) == null) {
                  return result;
               }

               i = 1;
            } else {
               i = 2;
            }

            while(i < tmp.length) {
               if (((SM4FPEEntity)nameEntities.get(1)).getCharsMap().get(tmp[i]) == null && ((SM4FPEEntity)nameEntities.get(2)).getCharsMap().get(tmp[i]) == null && ((SM4FPEEntity)nameEntities.get(3)).getCharsMap().get(tmp[i]) == null) {
                  return result;
               }

               ++i;
            }

            result = true;
         }
      }

      return result;
   }

   String generateInputRandom(String input) {
      Random random = new Random();
      input = input + ((SM4FPEEntity)nameEntities.get(1)).getList().get(random.nextInt(((SM4FPEEntity)nameEntities.get(1)).getList().size()));
      input = input + ((SM4FPEEntity)nameEntities.get(2)).getList().get(random.nextInt(((SM4FPEEntity)nameEntities.get(2)).getList().size()));
      input = input + ((SM4FPEEntity)nameEntities.get(2)).getList().get(random.nextInt(((SM4FPEEntity)nameEntities.get(2)).getList().size()));
      return input;
   }

   public static boolean check(String input) {
      return isPersonName(input);
   }

   public static ArrayList<SM4FPEEntity> getSm4FPEEntities() {
      return nameEntities;
   }

   static {
      Security.addProvider(new BouncyCastleProvider());
      lastnameDuplicateStr = new String[0];
      lastnameChars = readCharFile("lastname_usual.txt", "UTF-8");
      firstnameChars = excludeChars(toArrayList(chineseChars), lastnameChars);
      otherChinese = excludeChars(otherChineseChars, lastnameChars);
      firstnameCharsMap = new HashMap();

      for(int i = 0; i < firstnameChars.size(); ++i) {
         firstnameCharsMap.put(firstnameChars.get(i), i);
      }

      lastnameCharsMap = new HashMap();

      for(int i = 0; i < lastnameChars.length; ++i) {
         lastnameCharsMap.put(lastnameChars[i], i);
      }

      lastnameDuplicateStrMap = new HashMap();

      for(int i = 0; i < lastnameDuplicateStr.length; ++i) {
         lastnameDuplicateStrMap.put(lastnameDuplicateStr[i], i);
      }

      otherChineseMap = new HashMap();

      for(int i = 0; i < otherChinese.size(); ++i) {
         otherChineseMap.put(otherChinese.get(i), i);
      }

      try {
         nameEntities.add(new SM4FPEEntity(0, toArrayList(lastnameDuplicateStr), lastnameDuplicateStrMap, MatchType.ONCE));
         nameEntities.add(new SM4FPEEntity(1, toArrayList(lastnameChars), lastnameCharsMap));
         nameEntities.add(new SM4FPEEntity(2, firstnameChars, firstnameCharsMap));
         nameEntities.add(new SM4FPEEntity(3, otherChinese, otherChineseMap));
         checkDuplicate(nameEntities);
      } catch (RuntimeException e) {
         throw e;
      }
   }
}
