package com.chenyang.nse.bussiness.tools.es;

import cn.hutool.core.util.ObjectUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetJSONValueUtils {
   public static final Log LOG = LogFactory.getLog(GetJSONValueUtils.class);

   public static void main(String[] args) {
      Set<String> jsonKeySet = new HashSet();
      String jsonStr = "{\"name\":\"suo\",\"pserson\":[{\"first\":\"li\",\"lastname\":{\"iiiii\":{\"faku\":\"100\"}}},{\"first\":\"li2\",\"last\":\"suo2\",\"age\":12}]}";

      Set<String> sortSet = new TreeSet<>((o1, o2) -> o1.compareTo(o2));

      try {
         System.out.println(jsonKeySet.toString());
         sortSet.addAll(jsonKeySet);
         System.out.println(sortSet.toString());
      } catch (Exception e) {
         e.printStackTrace();
      }

      for(String k : sortSet) {
         System.out.println(k);
      }

   }

   public static int IsJsonArrayOrJsonObject(Object obj) {
      try {
         JSONObject nextLayerJsonObject = (JSONObject)obj;
         return 1;
      } catch (Exception var4) {
         try {
            JSONArray nextLayerJsonArray = (JSONArray)obj;
            return 2;
         } catch (Exception var3) {
            return 0;
         }
      }
   }

   public static String getJsonValueByKeyIgnoreCase(Set<String> jsonkeySet, String key, JSONObject currentJsonObject) throws Exception {
      String jsonValue = "";

      for(String jsonkey : jsonkeySet) {
         if (key.equalsIgnoreCase(jsonkey)) {
            jsonValue = currentJsonObject.getString(jsonkey);
            break;
         }
      }

      return jsonValue;
   }

   public static String getJsonOriginalKey(Set<String> jsonkeySet, String key) throws Exception {
      String originalKey = "";

      for(String jsonkey : jsonkeySet) {
         if (key.equalsIgnoreCase(jsonkey)) {
            originalKey = jsonkey;
            break;
         }
      }

      if ("".equals(originalKey)) {
         originalKey = key;
      }

      return originalKey;
   }

   public static Map<String, ArrayList> getJsonKeyArray(Map<String, ArrayList> jsonKeyMap, String jsonStr, String parentKey) throws Exception {
      JSONObject jsonObject = JSONObject.fromObject(jsonStr);

      for(Object keyObj : jsonObject.keySet()) {
         String key = keyObj.toString();
         Object jsonValueObj = jsonObject.get(key);
         int flag = IsJsonArrayOrJsonObject(jsonValueObj);
         if (flag == 1) {
            if (!"".equals(parentKey)) {
               if (parentKey.endsWith(".")) {
                  key = parentKey + key + ".";
               } else {
                  key = parentKey + "." + key + ".";
               }
            }

            JSONObject nextLayerJsonObject = (JSONObject)jsonValueObj;
            getJsonKeyArray(jsonKeyMap, nextLayerJsonObject.toString(), key);
         } else if (flag != 2) {
            if (!"".equals(parentKey)) {
               if (parentKey.endsWith(".")) {
                  key = parentKey + key;
               } else {
                  key = parentKey + "." + key;
               }
            }

            if (StringUtils.isBlank(parentKey)) {
               if (ObjectUtil.isNull(jsonKeyMap.get(key))) {
                  jsonKeyMap.put(key, new ArrayList());
               }

               ((ArrayList)jsonKeyMap.get(key)).add(jsonValueObj);
            } else {
               if (ObjectUtil.isNull(jsonKeyMap.get(key))) {
                  jsonKeyMap.put(key, new ArrayList());
               }

               ((ArrayList)jsonKeyMap.get(key)).add(jsonValueObj);
            }
         } else {
            if ("".equals(parentKey)) {
               key = key + ".";
            }

            JSONArray nextLayerJsonArray = (JSONArray)jsonValueObj;

            for(int i = 0; i < nextLayerJsonArray.size(); ++i) {
               try {
                  JSONObject nextLayerJsonObject = (JSONObject)nextLayerJsonArray.get(i);
                  getJsonKeyArray(jsonKeyMap, nextLayerJsonObject.toString(), key);
               } catch (Exception var12) {
                  if (!"".equals(parentKey)) {
                     if (parentKey.endsWith(".")) {
                        key = parentKey + key;
                     } else {
                        key = parentKey + "." + key;
                     }
                  }

                  if (ObjectUtil.isNull(jsonKeyMap.get(key))) {
                     jsonKeyMap.put(key, new ArrayList());
                  }

                  ((ArrayList)jsonKeyMap.get(key)).add(nextLayerJsonArray.toString());
                  break;
               }
            }
         }
      }

      return jsonKeyMap;
   }
}
