package com.chenyang.nse.bussiness.tools.ha;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Properties;

public class TcpClient {
   private String ip;
   private int port;

   public TcpClient(String ip, int port) {
      this.ip = ip;
      this.port = port;
   }

   public String uploadFile(String path, String flg) {
      DataInputStream fileInput = null;
      DataOutputStream output = null;
      DataInputStream socketInput = null;
      int bufferSize = 8192;
      byte[] buf = new byte[bufferSize];
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String waitTime = props.getProperty("ha_tcp_wait_time");
      String conStatus = "0";
      Socket socket = new Socket();

      try {
         SocketAddress address = new InetSocketAddress(this.ip, this.port);
         socket.connect(address, new Integer(waitTime));
         File file = new File(path);
         output = new DataOutputStream(socket.getOutputStream());
         output.writeUTF(flg);
         output.flush();
         output.writeUTF(file.getParentFile().getPath() + "#" + file.getName());
         output.flush();
         output.writeLong(file.length());
         output.flush();
         socketInput = new DataInputStream(socket.getInputStream());
         fileInput = new DataInputStream(new FileInputStream(path));
         int readSize = 0;

         while(true) {
            if (fileInput != null) {
               readSize = fileInput.read(buf);
            }

            if (readSize == -1) {
               System.out.println("上传文件" + path + "完成");
               output.flush();
            }

            System.out.println("读取要上传文件的大小readSize：" + readSize);
            output.write(buf, 0, readSize);
         }
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         try {
            String soureFileMd5Str = MD5Utils.getFileMD5String(new File(path));
            System.out.println(">>>>>>>>>soureFileMd5Str is " + soureFileMd5Str);
            String tarFileMd5Str = "";

            String ackStr;
            do {
               ackStr = socketInput.readUTF();
               System.out.println(">>>>>>>>>ackStr is " + ackStr);
            } while(!"0".equals(ackStr) && !"1".equals(ackStr));

            System.out.println(">>>>>>>>>TCP server return is " + ackStr);
            if ("1".equals(ackStr)) {
               conStatus = "1";
               System.out.println(">>>path:" + path + "传输完成且文件完整！");
            } else {
               conStatus = "0";
               System.out.println(">>>path:" + path + "传输完成但文件不完整！");
            }
         } catch (Exception var162) {
         } finally {
            if (null != fileInput) {
               try {
                  fileInput.close();
               } catch (IOException e) {
                  e.printStackTrace();
               }
            }

            if (null != output) {
               try {
                  output.close();
               } catch (IOException e) {
                  e.printStackTrace();
               }
            }

            if (null != socket) {
               try {
                  socket.close();
               } catch (IOException e) {
                  e.printStackTrace();
               }
            }

            if (null != socketInput) {
               try {
                  socketInput.close();
               } catch (IOException e) {
                  e.printStackTrace();
               }
            }

            System.out.println("文件传输完成");
         }

         return conStatus;
      }
   }

   public static void main(String[] args) {
      TcpClient client = new TcpClient("192.168.2.100", 8888);
      client.uploadFile("D:/200607224827_dbf2fileTest11/onecoltest1.xml", "0");
      client.uploadFile("D:/200607224827_dbf2fileTest11/sbdz.xml", "0");
      client.uploadFile("D:/200607224827_dbf2fileTest11/sjsdz.xml", "0");
   }
}
