package com.chenyang.nse.bussiness.tools.http;

import com.chenyang.nse.bussiness.jar.util.JarSocketCallback;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class ClientUtil {
   public static ExecutorService executorService = Executors.newFixedThreadPool(10);

   public static String doClient(String url, String json) {
      String result = "调用" + url + "接口结束！";
      (new Thread(() -> {
         System.out.println("doclienturl:" + url);
         doPost(url, json);
      })).start();
      return result;
   }

   public static CloseableHttpClient buildHttpClient() {
      CloseableHttpClient client = null;
      HttpClientBuilder build = HttpClientBuilder.create();
      client = build.build();
      return SkipHttpsUtil.wrapClient();
   }

   public static String doPost(String url, String json) {
      CloseableHttpClient httpClient = buildHttpClient();
      HttpPost httpPost = new HttpPost(url);
      String result = null;

      try {
         httpPost.setHeader("content-type", "application/json;charset=UTF-8");
         StringEntity se = new StringEntity(json, "utf-8");
         httpPost.setEntity(se);
         HttpResponse response = httpClient.execute(httpPost);
         HttpEntity entity = response.getEntity();
         if (entity != null) {
            result = EntityUtils.toString(entity, "UTF-8");
         }
      } catch (ClientProtocolException e) {
         e.printStackTrace();
      } catch (UnsupportedEncodingException e) {
         e.printStackTrace();
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         try {
            httpClient.close();
         } catch (IOException e) {
            e.printStackTrace();
         }

      }

      return result;
   }

   public static String doPost(String url, String json, JarSocketCallback callback) {
      CloseableHttpClient httpClient = buildHttpClient();
      HttpPost httpPost = new HttpPost(url);
      String result = null;

      try {
         httpPost.setHeader("content-type", "application/json;charset=UTF-8");
         StringEntity se = new StringEntity(json, "utf-8");
         httpPost.setEntity(se);
         HttpResponse response = httpClient.execute(httpPost);
         HttpEntity entity = response.getEntity();
         if (entity != null) {
            result = EntityUtils.toString(entity, "UTF-8");
         }

         callback.isSucc();
      } catch (ClientProtocolException e) {
         e.printStackTrace();
      } catch (UnsupportedEncodingException e) {
         e.printStackTrace();
      } catch (Exception e) {
         e.printStackTrace();
         callback.isFail();
      } finally {
         try {
            httpClient.close();
         } catch (IOException e) {
            e.printStackTrace();
         }

      }

      return result;
   }

   public static void main(String[] args) {
      String url = "http://192.168.2.88:8182/initconfigfile/loadconfig";
   }
}
