package com.chenyang.nse.bussiness.tools.jdbc;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreConfig;
import com.chenyang.nse.bussiness.tools.command.CommandTool;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class SqlServerBcpTableTool {
   public static void createBcpScript(Map<String, String> map, TCoreConfig tcoreConfig) {
      try {
         new Properties();
         Properties e = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String errorLog = e.get("bcp_table_sqlserver_error_log").toString();
         if (tcoreConfig != null) {
            String loadTableColSplit = tcoreConfig.getTargetdelimiter();
            if (loadTableColSplit == null || loadTableColSplit.equals("")) {
               loadTableColSplit = XmlTool.getFileValue("MSSQLSERVER/db-targetdelimiter");
            }

            FileTool.createFolder(errorLog);
            String bcpSh = "#!/bin/sh \n/opt/mssql-tools/bin/bcp " + (String)map.get("database") + "." + (String)map.get("dbschema") + "." + (String)map.get("tablename") + " in " + File.separator + "data" + File.separator + "infa_sqlserver" + File.separator + "target" + File.separator + (String)map.get("taskname") + File.separator + (String)map.get("tablename") + ".txt -c -t \"" + loadTableColSplit + "\" -e " + errorLog + "error_out_" + (String)map.get("tablename") + ".log -S " + (String)map.get("ip") + " -U " + (String)map.get("user") + " -P " + (String)map.get("pwd");
            CommandTool.command("chmod 777 " + (String)map.get("path"));
            FileTool.clearFileContent((String)map.get("path"));
            FileTool.writeContentToFile((String)map.get("path"), bcpSh);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public static void createBcpExportScript(Map<String, Object> map) {
      try {
         new Properties();
         Properties e = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String loadTableColSplit = e.get("bcp_table_sqlserver_col_split").toString();
         String errorLog = e.get("bcp_table_sqlserver_error_log").toString();
         FileTool.createFolder(errorLog);
         String bcpSh = "#!/bin/sh \n/opt/mssql-tools/bin/bcp \"SELECT ";
         List<Map<String, String>> columns = (List)map.get("columns");

         for(int i = 0; i < columns.size(); ++i) {
            Map<String, String> columnField = (Map)columns.get(i);
            String columnName = (String)columnField.get("name");
            String columnType = (String)columnField.get("type");
            if (!columnType.equals("date") && !columnType.equals("datetime")) {
               bcpSh = bcpSh + "[" + columnName + "]";
            } else {
               bcpSh = bcpSh + "CONVERT(varchar," + columnName + ",120) as " + columnName;
            }

            if (i != columns.size() - 1) {
               bcpSh = bcpSh + ",";
            }
         }

         String txtPath = File.separator + "data" + File.separator + "infa_sqlserver" + File.separator + "source" + File.separator + map.get("taskname") + File.separator;
         bcpSh = bcpSh + " FROM [" + map.get("database") + "]." + map.get("dbschema") + ".[" + map.get("tablename") + "]\" queryout " + txtPath + map.get("tablename") + ".txt -c -t \"" + loadTableColSplit + "\" -S " + map.get("ip") + " -U " + map.get("user") + " -P " + map.get("pwd");
         FileTool.clearFileContent((String)map.get("path"));
         FileTool.writeContentToFile((String)map.get("path"), bcpSh);
         CommandTool.command("chmod 777 " + map.get("path"));
         CommandTool.command("mkdir " + txtPath);
      } catch (Exception e) {
         e.printStackTrace();
      }

   }
}
