package com.chenyang.nse.bussiness.tools.jdbc;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.tools.command.CommandTool;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class SybaseIQLoadTableTool {
   public static void executeLoadTable(Map<String, String> map) {
      System.out.println("----------------WriteLoadTable Start----------------");

      try {
         new Properties();
         Properties e = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String loadTableColSplit = e.get("load_table_col_split").toString();
         String loadTableRowSplit = e.get("load_table_col_split").toString();
         String escapes = e.get("escapes").toString();
         String quotes = "OFF";
         String notify = e.get("notify").toString();
         String message_log = e.get("message_log").toString();
         String row_log = e.get("row_log").toString();
         String with_checkpoint = e.get("with_checkpoint").toString();
         StringBuffer str = new StringBuffer();
         str.append("#!/bin/sh \n");
         str.append("dbisql -c \"uid=" + (String)map.get("user") + ";pwd=" + (String)map.get("pwd") + ";\" -host " + (String)map.get("ip") + " -port " + (String)map.get("port") + " -onerror exit -nogui ");
         str.append("\"set temporary option ESCAPE_CHARACTER='ON';set temporary option CONVERSION_ERROR='OFF';set temporary option public.STRING_RTRUNCATION='OFF';Load table " + (String)map.get("schema") + "." + (String)map.get("table") + " (");
         String lm = (String)map.get("lm");
         String[] lmArray = lm.split(",");
         String quotecode = "0";
         System.out.println("----------SybaseIQ 脚本版本：xml=" + quotecode + ",prop=" + quotes);

         for(int i = 0; i < lmArray.length; ++i) {
            String name = lmArray[i].split("\\|")[0];
            String type = lmArray[i].split("\\|")[1];
            String comma = "";
            String split = "";
            if (i == lmArray.length - 1) {
               split = loadTableRowSplit;
               comma = "";
            } else {
               split = loadTableColSplit;
               comma = ",";
            }

            String quote = "";
            if (quotecode.equals("1")) {
               quote = "'";
            } else if (quotecode.equals("2")) {
               quote = "\\\"";
            }

            if ("date".equalsIgnoreCase(type)) {
               str.append(name + " DATE('" + quote + "MM/DD/YYYY" + quote + "') null('02/22/2050') ,FILLER('" + split + "') " + comma);
            } else if ("datetime".equalsIgnoreCase(type)) {
               str.append(name + " DATETIME('" + quote + "MM/DD/YYYY HH:nn:ss" + quote + "') null('02/22/2050 12:00:00') ,FILLER('" + split + "') " + comma);
            } else if ("time".equalsIgnoreCase(type)) {
               str.append(name + " DATETIME('" + quote + "HH:nn:ss" + quote + "') null('04:24:35') ,FILLER('" + split + "') " + comma);
            } else if ("timestamp".equalsIgnoreCase(type)) {
               str.append(name + " DATETIME('" + quote + "MM/DD/YYYY HH:nn:ss" + quote + "') null('02/22/2050 12:00:00') ,FILLER('" + split + "') " + comma);
            } else {
               str.append(name + " '" + split + "' " + comma);
            }
         }

         str.append(") ");
         List<String> ls = getLoalhostIP();
         String append = "USING CLIENT FILE ";

         for(String s : ls) {
            if (((String)map.get("ip")).equals(s)) {
               append = "FROM ";
               break;
            }
         }

         str.append(append);
         str.append("'$1' ");
         str.append("row delimited by '\\x23\\x21\\x0A' ");
         str.append("ESCAPES " + escapes + " ");
         str.append("QUOTES " + quotes + " ");
         str.append("NOTIFY " + notify + " ");
         str.append("WITH CHECKPOINT " + with_checkpoint + ";COMMIT; \" ");
         FileTool.clearFileContent((String)map.get("path"));
         FileTool.writeContentToFile((String)map.get("path"), str.toString());
         CommandTool.command("chmod 777 " + (String)map.get("path"));
         System.out.println("-----------------WriteLoadTable End-----------------");
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public static void executeLoadTableOB(Map<String, String> map) {
      System.out.println("----------------WriteLoadTable Start----------------");

      try {
         new Properties();
         Properties e = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String loadTableColSplit = e.get("load_table_col_split").toString();
         String loadTableRowSplit = e.get("load_table_col_split").toString();
         String escapes = e.get("escapes").toString();
         String quotes = "OFF";
         String notify = e.get("notify").toString();
         String message_log = e.get("message_log").toString();
         String row_log = e.get("row_log").toString();
         String with_checkpoint = e.get("with_checkpoint").toString();
         StringBuffer str = new StringBuffer();
         str.append("#!/bin/sh \n");
         str.append("dbisql -c \"uid=" + (String)map.get("user") + ";pwd=" + (String)map.get("pwd") + ";\" -host " + (String)map.get("ip") + " -port " + (String)map.get("port") + " -onerror exit -nogui ");
         str.append("\"set temporary option ESCAPE_CHARACTER='ON';set temporary option CONVERSION_ERROR='OFF';set temporary option public.STRING_RTRUNCATION='OFF';Load table " + (String)map.get("schema") + "." + (String)map.get("table") + " (");
         String lm = (String)map.get("lm");
         String[] lmArray = lm.split(",");
         String quotecode = "0";
         System.out.println("----------SybaseIQ 脚本版本：xml=" + quotecode + ",prop=" + quotes);

         for(int i = 0; i < lmArray.length; ++i) {
            String name = lmArray[i].split("\\|")[0];
            String type = lmArray[i].split("\\|")[1];
            String comma = "";
            String split = "";
            if (i == lmArray.length - 1) {
               split = loadTableRowSplit;
               comma = "";
            } else {
               split = loadTableColSplit;
               comma = ",";
            }

            String quote = "";
            if (quotecode.equals("1")) {
               quote = "'";
            } else if (quotecode.equals("2")) {
               quote = "\\\"";
            }

            if ("date".equalsIgnoreCase(type)) {
               str.append(name + " DATE('" + quote + "YYYY-MM-DD" + quote + "') null('2050-02-22') ,FILLER('" + split + "') " + comma);
            } else if ("datetime".equalsIgnoreCase(type)) {
               str.append(name + " DATETIME('" + quote + "YYYY-MM-DD HH:nn:ss" + quote + "') null('2050-02-22 12:00:00') ,FILLER('" + split + "') " + comma);
            } else if ("time".equalsIgnoreCase(type)) {
               str.append(name + " DATETIME('" + quote + "HH:nn:ss" + quote + "') null('04:24:35') ,FILLER('" + split + "') " + comma);
            } else if ("timestamp".equalsIgnoreCase(type)) {
               str.append(name + " DATETIME('" + quote + "YYYY-MM-DD HH:nn:ss" + quote + "') null('2050-02-22 12:00:00') ,FILLER('" + split + "') " + comma);
            } else {
               str.append(name + " '" + split + "' " + comma);
            }
         }

         str.append(") ");
         List<String> ls = getLoalhostIP();
         String append = "USING CLIENT FILE ";

         for(String s : ls) {
            if (((String)map.get("ip")).equals(s)) {
               append = "FROM ";
               break;
            }
         }

         str.append(append);
         str.append("'$1' ");
         str.append("row delimited by '\\x23\\x21\\x0A' ");
         str.append("ESCAPES " + escapes + " ");
         str.append("QUOTES " + quotes + " ");
         str.append("NOTIFY " + notify + " ");
         str.append("WITH CHECKPOINT " + with_checkpoint + ";COMMIT; \" ");
         FileTool.clearFileContent((String)map.get("path"));
         FileTool.writeContentToFile((String)map.get("path"), str.toString());
         CommandTool.command("chmod 777 " + (String)map.get("path"));
         System.out.println("-----------------WriteLoadTable End-----------------");
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public static List<String> getLoalhostIP() {
      List<String> ls = new ArrayList();

      try {
         Enumeration<?> enumeration = NetworkInterface.getNetworkInterfaces();
         InetAddress ip = null;

         while(enumeration.hasMoreElements()) {
            NetworkInterface netInterface = (NetworkInterface)enumeration.nextElement();
            Enumeration<?> addresses = netInterface.getInetAddresses();

            while(addresses.hasMoreElements()) {
               ip = (InetAddress)addresses.nextElement();
               ls.add(ip.getHostName());
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return ls;
   }
}
