package com.chenyang.nse.bussiness.tools.jdbc;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.tools.command.CommandTool;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class TeradataLoadTableTool {
   public static boolean executeLoadTable(Map<String, String> map) {
      System.out.println("----------------WriteLoadTable Start----------------");
      String schema = (String)map.get("schema");
      String table = (String)map.get("table");
      String ip = (String)map.get("ip");
      String port = (String)map.get("port");
      String user = (String)map.get("user");
      String pwd = (String)map.get("pwd");
      String define = (String)map.get("define");
      String path = (String)map.get("path");
      String driver = (String)map.get("driver");
      String url = (String)map.get("url");
      boolean is_create = true;

      try {
         new Properties();
         Properties e = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String loadTableColSplit = e.get("load_table_teradata_col_split").toString();
         String sessions = e.get("load_table_teradata_sessions").toString();
         String errlimit = e.get("load_table_teradata_errlimit").toString();
         String errlogtable1 = e.get("load_table_teradata_errlogtable1").toString();
         String errlogtable2 = e.get("load_table_teradata_errlogtable2").toString();
         String checkpoint = e.get("load_table_teradata_checkpoint").toString();
         String fastload_character = e.get("fastload_character").toString();
         StringBuffer str = new StringBuffer();
         str.append("sessions " + sessions + ";");
         str.append("\nerrlimit " + errlimit + ";");
         str.append("\nlogon " + ip + ":" + port + "/" + user + "," + pwd + ";");
         str.append("\nset record vartext \"" + loadTableColSplit + "\";");
         str.append("\ndelete from " + schema + "." + table + ";");
         str.append("\ndefine " + define + " file=" + path + "tar_" + table + ".pipe;");
         str.append("\nbegin loading " + schema + "." + table + " errorfiles " + schema + "." + table + "_" + errlogtable1 + ", " + schema + "." + table + "_" + errlogtable2 + " checkpoint  " + checkpoint + ";");
         str.append("\ninsert into " + schema + "." + table + ".*;");
         str.append("\nend loading;");
         str.append("\nlogoff;");
         FileTool.createFile((String)map.get("path") + table + ".fl");
         FileTool.clearFileContent((String)map.get("path") + table + ".fl");
         FileTool.writeContentToFile((String)map.get("path") + table + ".fl", str.toString());
         setSHfile((String)map.get("path"), table, fastload_character);
         CommandTool.command("chmod 777 -R " + (String)map.get("path"));
         System.out.println("chmod 777 -R " + (String)map.get("path"));
         String create_sql = (String)map.get("create_sql");
         System.out.println("-----------------WriteLoadTable End-----------------");
         Connection tconn = JdbcTool.getConnection(driver, url, user, pwd);
         JdbcTool.dropTable(tconn, schema, table);
         JdbcTool.dropTable(tconn, schema, table + "_" + errlogtable1);
         JdbcTool.dropTable(tconn, schema, table + "_" + errlogtable2);

         try {
            tconn.createStatement().execute(create_sql);
            tconn.close();
         } catch (SQLException e2) {
            e2.printStackTrace();
            is_create = false;
         } finally {
            ;
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      if (((String)map.get("in_type")).equals("2")) {
         CommandTool.command((String)map.get("path") + table + ".sh");
      }

      System.out.println("is_create:" + is_create);
      return is_create;
   }

   public static boolean createfastLoadTableSh(Map<String, String> map) {
      System.out.println("----------------WriteLoadTable Start----------------");
      String schema = (String)map.get("schema");
      String table = (String)map.get("table");
      String ip = (String)map.get("ip");
      String port = (String)map.get("port");
      String user = (String)map.get("user");
      String pwd = (String)map.get("pwd");
      String define = (String)map.get("define");
      String path = (String)map.get("path");
      String driver = (String)map.get("driver");
      String url = (String)map.get("url");
      boolean is_create = true;

      try {
         new Properties();
         Properties e = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String loadTableColSplit = e.get("load_table_teradata_col_split").toString();
         String sessions = e.get("load_table_teradata_sessions").toString();
         String errlimit = e.get("load_table_teradata_errlimit").toString();
         String errlogtable1 = e.get("load_table_teradata_errlogtable1").toString();
         String errlogtable2 = e.get("load_table_teradata_errlogtable2").toString();
         String checkpoint = e.get("load_table_teradata_checkpoint").toString();
         String fastload_character = e.get("fastload_character").toString();
         StringBuffer str = new StringBuffer();
         str.append("sessions " + sessions + ";");
         str.append("\nerrlimit " + errlimit + ";");
         str.append("\nlogon " + ip + ":" + port + "/" + user + "," + pwd + ";");
         str.append("\nset record vartext \"" + loadTableColSplit + "\";");
         str.append("\ndelete from " + schema + "." + table + ";");
         str.append("\ndefine " + define + " file=" + path + table + ".pipe;");
         str.append("\nbegin loading " + schema + "." + table + " errorfiles " + schema + "." + table + "_" + errlogtable1 + ", " + schema + "." + table + "_" + errlogtable2 + " checkpoint  " + checkpoint + ";");
         str.append("\ninsert into " + schema + "." + table + ".*;");
         str.append("\nend loading;");
         str.append("\nlogoff;");
         FileTool.createFile((String)map.get("path") + table + ".fl");
         FileTool.clearFileContent((String)map.get("path") + table + ".fl");
         FileTool.writeContentToFile((String)map.get("path") + table + ".fl", str.toString());
         setSHfile((String)map.get("path"), table, fastload_character, "fastload", "fl");
         CommandTool.command("chmod 777 -R " + (String)map.get("path"));
         System.out.println("chmod 777 -R " + (String)map.get("path"));
         String create_sql = (String)map.get("create_sql");
         System.out.println("-----------------WriteLoadTable End-----------------");
         Connection tconn = JdbcTool.getConnection(driver, url, user, pwd);
         if (JdbcTool.isTableExisted(tconn, table)) {
            JdbcTool.dropTable(tconn, schema, table);
         }

         if (JdbcTool.isTableExisted(tconn, table + "_" + errlogtable1)) {
            JdbcTool.dropTable(tconn, schema, table + "_" + errlogtable1);
         }

         if (JdbcTool.isTableExisted(tconn, table + "_" + errlogtable2)) {
            JdbcTool.dropTable(tconn, schema, table + "_" + errlogtable2);
         }

         try {
            tconn.createStatement().execute(create_sql);
            tconn.close();
         } catch (SQLException e2) {
            e2.printStackTrace();
            is_create = false;
         } finally {
            ;
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      if (((String)map.get("in_type")).equals("2")) {
         CommandTool.command((String)map.get("path") + table + ".sh");
      }

      System.out.println("is_create:" + is_create);
      return is_create;
   }

   public static boolean createmultiLoadTableSh(Map<String, String> map) {
      System.out.println("----------------WriteLoadTable Start----------------");
      String schema = (String)map.get("schema");
      String table = (String)map.get("table");
      String ip = (String)map.get("ip");
      String port = (String)map.get("port");
      String user = (String)map.get("user");
      String pwd = (String)map.get("pwd");
      String define = (String)map.get("define");
      String sql = (String)map.get("sql");
      String path = (String)map.get("path");
      String driver = (String)map.get("driver");
      String url = (String)map.get("url");
      boolean is_create = true;

      try {
         new Properties();
         Properties e = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String loadTableColSplit = e.get("load_table_teradata_col_split").toString();
         String sessions = e.get("load_table_teradata_sessions").toString();
         String errlimit = e.get("load_table_teradata_errlimit").toString();
         String errlogtable1 = e.get("load_table_teradata_errlogtable1").toString();
         String errlogtable2 = e.get("load_table_teradata_errlogtable2").toString();
         String checkpoint = e.get("load_table_teradata_checkpoint").toString();
         String fastload_character = e.get("fastload_character").toString();
         StringBuffer str = new StringBuffer();
         str.append(".LOGTABLE " + schema + "." + table + "_log;");
         str.append("\n.LOGON " + ip + ":" + port + "/" + user + "," + pwd + ";");
         str.append("\n.BEGIN MLOAD TABLES " + schema + "." + table + "; ");
         str.append("\n.LAYOUT " + table + ";");
         str.append("\n" + define);
         str.append("\n.DML label " + table + "; ");
         str.append("\ninsert into " + schema + "." + table + sql);
         str.append("\n .IMPORT INFILE  " + path + table + ".pipe");
         str.append("\n  FORMAT VARTEXT '" + loadTableColSplit + "'");
         str.append("\n  LAYOUT " + table);
         str.append("\n  APPLY " + table + ";");
         str.append("\n  .END MLOAD;");
         str.append("\n  .LOGOFF;;");
         FileTool.createFile((String)map.get("path") + table + ".ml");
         FileTool.clearFileContent((String)map.get("path") + table + ".ml");
         FileTool.writeContentToFile((String)map.get("path") + table + ".ml", str.toString());
         setSHfile((String)map.get("path"), table, fastload_character, "mload", "ml");
         CommandTool.command("chmod 777 -R " + (String)map.get("path"));
         System.out.println("chmod 777 -R " + (String)map.get("path"));
         String create_sql = (String)map.get("create_sql");
         System.out.println("-----------------WriteLoadTable End-----------------");
         Connection tconn = JdbcTool.getConnection(driver, url, user, pwd);
         if (JdbcTool.isTableExisted(tconn, table)) {
            JdbcTool.dropTable(tconn, schema, table);
         }

         if (JdbcTool.isTableExisted(tconn, table + "_" + errlogtable1)) {
            JdbcTool.dropTable(tconn, schema, table + "_" + errlogtable1);
         }

         if (JdbcTool.isTableExisted(tconn, table + "_" + errlogtable2)) {
            JdbcTool.dropTable(tconn, schema, table + "_" + errlogtable2);
         }

         try {
            tconn.createStatement().execute(create_sql);
            tconn.close();
         } catch (SQLException e2) {
            e2.printStackTrace();
            is_create = false;
         } finally {
            ;
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      if (((String)map.get("in_type")).equals("2")) {
         CommandTool.command((String)map.get("path") + table + ".sh");
      }

      System.out.println("is_create:" + is_create);
      return is_create;
   }

   public static void setSHfile(String path, String table, String fastload_character) {
      FileTool.createFile(path + "/" + table + ".sh");
      FileTool.clearFileContent(path + "/" + table + ".sh");
      FileTool.writeContentToFile(path + "/" + table + ".sh", "fastload < " + path + "/" + table + ".fl -c " + fastload_character + " > " + path + "/" + table + ".log");
   }

   public static void setSHfile(String path, String table, String fastload_character, String type, String sufix) {
      FileTool.createFile(path + "/" + table + ".sh");
      FileTool.clearFileContent(path + "/" + table + ".sh");
      FileTool.writeContentToFile(path + "/" + table + ".sh", type + " < " + path + "/" + table + "." + sufix + " -c " + fastload_character + " > " + path + "/" + table + "_" + sufix + ".log");
   }

   public static String getcolumNumber(String columtype, String columnumber) {
      if ("timestamp".equalsIgnoreCase(columtype) || "time".equalsIgnoreCase(columtype) || "date".equalsIgnoreCase(columtype)) {
         columnumber = "50";
      }

      if (!"".equals(columnumber) && Integer.parseInt(columnumber) > 64000) {
         columnumber = "1000";
      }

      if ("decimal".equalsIgnoreCase(columtype) && "".equals(columnumber)) {
         columnumber = "50";
      }

      if ("varchar".equalsIgnoreCase(columtype) && "0".equals(columnumber)) {
         columnumber = "255";
      }

      return columnumber;
   }

   public static List<String> getLoalhostIP() {
      List<String> ls = new ArrayList();

      try {
         Enumeration<?> enumeration = NetworkInterface.getNetworkInterfaces();
         InetAddress ip = null;

         while(enumeration.hasMoreElements()) {
            NetworkInterface netInterface = (NetworkInterface)enumeration.nextElement();
            Enumeration<?> addresses = netInterface.getInetAddresses();

            while(addresses.hasMoreElements()) {
               ip = (InetAddress)addresses.nextElement();
               ls.add(ip.getHostName());
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return ls;
   }

   public static void main(String[] args) {
      CommandTool.command("mkfifo /data/infa_teradata/test2.pipe");
      StringBuffer str = new StringBuffer();
      str.append("1,LZQ\n");
      str.append("2,王业明");
      FileTool.writeContentToFile("test2.pipe", str.toString());
      Map<String, String> loadmap = new HashMap();
      loadmap.put("user", "testuser2");
      loadmap.put("pwd", "testuser2");
      loadmap.put("ip", "192.168.2.204");
      loadmap.put("port", "1433");
      loadmap.put("table", "test2");
      loadmap.put("schema", "testuser2");
      loadmap.put("path", "/data/infa_teradata/test2.fl");
      executeLoadTable(loadmap);
   }
}
