package com.chenyang.nse.bussiness.tools.logger;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.util.OptionHelper;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class LoggerBuilder {
   private static final Map<String, Logger> container = new HashMap();

   public Logger getLogger(String path, String name) {
      Logger logger = (Logger)container.get(name);
      if (logger != null) {
         return logger;
      } else {
         synchronized(LoggerBuilder.class) {
            logger = (Logger)container.get(name);
            if (logger != null) {
               return logger;
            } else {
               logger = build(name, path);
               container.put(name, logger);
               return logger;
            }
         }
      }
   }

   private static Logger build(String name, String path) {
      DateFormat format = DateFormat.getDateInstance(2, Locale.SIMPLIFIED_CHINESE);
      LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
      Logger logger = context.getLogger("FILE-" + name);
      logger.setAdditive(false);
      FileAppender appender = new FileAppender();
      appender.setContext(context);
      appender.setName("FILE-" + name);
      appender.setFile(OptionHelper.substVars(path + "/" + name + ".log", context));
      appender.setAppend(true);
      appender.setPrudent(false);
      PatternLayoutEncoder encoder = new PatternLayoutEncoder();
      encoder.setContext(context);
      encoder.setPattern("%d %p (%t\\)- %m%n");
      encoder.start();
      PatternLayoutEncoder encoder1 = new PatternLayoutEncoder();
      encoder1.setContext(context);
      encoder1.setPattern("%d %p (%t\\)- %m%n");
      encoder1.start();
      appender.setEncoder(encoder);
      appender.start();
      ConsoleAppender consoleAppender = new ConsoleAppender();
      consoleAppender.setContext(context);
      consoleAppender.setEncoder(encoder1);
      consoleAppender.start();
      logger.addAppender(consoleAppender);
      logger.addAppender(appender);
      return logger;
   }
}
