package com.chenyang.nse.bussiness.tools.system;

import com.chenyang.nse.bussiness.tools.command.CommandTool;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class SysState {
   public static void main(String[] args) throws Exception {
   }

   public static Map<String, String> cpu() {
      Map<String, String> map = new HashMap();

      try {
         Sigar sigar = new Sigar();
         CpuPerc[] cpuList = null;
         double useAll = (double)0.0F;
         CpuInfo[] infos = sigar.getCpuInfoList();
         CpuInfo infoss = infos[0];
         cpuList = sigar.getCpuPercList();
         Runtime rt = Runtime.getRuntime();
         String processCnt = null;
         String threadCnt = null;
         BufferedReader in = null;
         double referenceSpeed = (double)infoss.getMhz();

         for(int i = 0; i < infos.length; ++i) {
            CpuInfo var10000 = infos[i];
            useAll += cpuList[i].getUser() + cpuList[i].getSys();
         }

         processCnt = CommandTool.commandRtn1("ps -ef | wc -l");
         String path = (new FileTool()).getClassRoot() + File.separator + "ScriptCommand" + File.separator + "SelectThread.sh";
         String os = System.getProperty("os.name");

         try {
            if (!os.toLowerCase().startsWith("win")) {
               CommandTool.command1("chmod -R 777 " + path);
               String commandRtn3 = CommandTool.commandRtn3(path);
               String threads = "";
               threads = commandRtn3.substring(commandRtn3.indexOf("Threads:") + 8, commandRtn3.indexOf("total"));
               threadCnt = threads.trim();
            }
         } catch (Exception var17) {
         }

         map.put("threadCnt", threadCnt);
         map.put("processCnt", processCnt);
         String cpuinfo = CpuPerc.format(useAll / (double)infos.length);
         map.put("cpuinfo", cpuinfo);
         String referenceSpeeds = String.format("%.2f", referenceSpeed / (double)1000.0F) + " GHz";
         map.put("referenceSpeeds", referenceSpeeds);
      } catch (Exception var18) {
      }

      return map;
   }

   public static Map<String, String> memory() throws SigarException {
      Map<String, String> map = new HashMap();
      Sigar sigar = new Sigar();
      double memTotal = (double)sigar.getMem().getTotal();
      double memRam = (double)sigar.getMem().getRam();
      double memUsed = (double)sigar.getMem().getActualUsed();
      double memFree = (double)sigar.getMem().getActualFree();
      double memUsedPerc = sigar.getMem().getUsedPercent();
      String memory = String.format("%.0f", memTotal / (double)1024.0F / (double)1024.0F / (double)1024.0F) + " GB";
      String memRamStr = String.format("%.1f", memRam / (double)1024.0F) + " GB";
      String memused = String.format("%.2f", memUsed / (double)1024.0F / (double)1024.0F / (double)1024.0F) + " GB";
      String memFrees = String.format("%.2f", memFree / (double)1024.0F / (double)1024.0F / (double)1024.0F) + " GB";
      String memoryUsage = String.format("%.2f", memUsedPerc) + " %";
      map.put("memory", memory);
      map.put("memRamStr", memRamStr);
      map.put("memused", memused);
      map.put("memFrees", memFrees);
      map.put("memoryUsage", memoryUsage);
      return map;
   }

   public static Map<String, String> net() throws SigarException, InterruptedException {
      Map<String, String> map = new HashMap();
      Sigar sigar = new Sigar();
      String ip = "";

      try {
         Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();

         while(en.hasMoreElements()) {
            NetworkInterface intf = (NetworkInterface)en.nextElement();
            String name = intf.getName();
            if (!name.contains("docker") && !name.contains("lo")) {
               Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();

               while(enumIpAddr.hasMoreElements()) {
                  InetAddress inetAddress = (InetAddress)enumIpAddr.nextElement();
                  if (!inetAddress.isLoopbackAddress()) {
                     String ipaddress = inetAddress.getHostAddress().toString();
                     if (!ipaddress.contains("::") && !ipaddress.contains("0:0:") && !ipaddress.contains("fe80")) {
                        ip = ipaddress;
                     }
                  }
               }
            }
         }
      } catch (SocketException ex) {
         ip = "127.0.0.1";
         ex.printStackTrace();
      }

      String[] netInterfaceList = sigar.getNetInterfaceList();
      double rxBytes = (double)0.0F;
      double txBytes = (double)0.0F;

      for(int i = 0; i < netInterfaceList.length; ++i) {
         String netInterface = netInterfaceList[i];
         NetInterfaceConfig netInterfaceConfig = sigar.getNetInterfaceConfig(netInterface);
         if (netInterfaceConfig.getAddress().equals(ip)) {
            double start = (double)System.currentTimeMillis();
            NetInterfaceStat statStart = sigar.getNetInterfaceStat(netInterface);
            double rxBytesStart = (double)statStart.getRxBytes();
            double txBytesStart = (double)statStart.getTxBytes();
            Thread.sleep(1000L);
            double end = (double)System.currentTimeMillis();
            NetInterfaceStat statEnd = sigar.getNetInterfaceStat(netInterface);
            double rxBytesEnd = (double)statEnd.getRxBytes();
            double txBytesEnd = (double)statEnd.getTxBytes();
            rxBytes = (rxBytesEnd - rxBytesStart) * (double)8.0F / (end - start) * (double)1000.0F / (double)1024.0F;
            txBytes = (txBytesEnd - txBytesStart) * (double)8.0F / (end - start) * (double)1000.0F / (double)1024.0F;
            break;
         }
      }

      String rxBytess;
      if (rxBytes > (double)1024.0F) {
         rxBytess = String.format("%.1f", rxBytes / (double)1024.0F) + " Mbps";
      } else {
         rxBytess = String.format("%.0f", rxBytes) + " Kbps";
      }

      String txBytess;
      if (txBytes > (double)1024.0F) {
         txBytess = String.format("%.1f", txBytes / (double)1024.0F) + " Mbps";
      } else {
         txBytess = String.format("%.0f", txBytes) + " Kbps";
      }

      map.put("rxBytess", rxBytess);
      map.put("txBytess", txBytess);
      return map;
   }

   public static Map<String, String> disk() throws InterruptedException, SigarException {
      Map<String, String> map = new HashMap();
      Sigar sigar = new Sigar();
      FileSystemUsage sfileSystemUsage = null;
      FileSystemUsage efileSystemUsage = null;
      List<FileSystem> list = Arrays.asList(sigar.getFileSystemList());
      String diskName = "";
      double total = (double)0.0F;
      double usePercent = (double)0.0F;
      double startreads = (double)0.0F;
      double startwrites = (double)0.0F;
      double endreads = (double)0.0F;
      double endwrites = (double)0.0F;
      double reads = (double)0.0F;
      double writes = (double)0.0F;
      long start = System.currentTimeMillis();

      for(int i = 0; i < list.size(); ++i) {
         diskName = diskName + list.get(i);

         try {
            sfileSystemUsage = sigar.getFileSystemUsage(String.valueOf(list.get(i)));
         } catch (SigarException var50) {
            continue;
         }

         total += (double)sfileSystemUsage.getTotal();
         usePercent += sfileSystemUsage.getUsePercent();
         startreads += (double)sfileSystemUsage.getDiskReads();
         startwrites += (double)sfileSystemUsage.getDiskWrites();
      }

      Thread.sleep(1000L);
      long end = System.currentTimeMillis();

      for(int i = 0; i < list.size(); ++i) {
         try {
            efileSystemUsage = sigar.getFileSystemUsage(String.valueOf(list.get(i)));
         } catch (SigarException var49) {
            continue;
         }

         endreads += (double)efileSystemUsage.getDiskReads();
         endwrites += (double)efileSystemUsage.getDiskWrites();
      }

      reads = (endreads - startreads) * (double)8.0F / (double)(end - start) * (double)1000.0F;
      writes = (endwrites - startwrites) * (double)8.0F / (double)(end - start) * (double)1000.0F;
      String readss = String.format("%.1f", reads) + " KB/s";
      String writess = String.format("%.1f", writes) + " KB/s";
      String totals = "";
      if (total / (double)1024.0F / (double)1024.0F / (double)1024.0F > (double)1.0F) {
         totals = String.format("%.1f", total / (double)1024.0F / (double)1024.0F / (double)1024.0F) + " TB";
      } else if (total / (double)1024.0F / (double)1024.0F > (double)1.0F) {
         totals = String.format("%.1f", total / (double)1024.0F / (double)1024.0F) + " GB";
      } else if (total / (double)1024.0F > (double)1.0F) {
         totals = String.format("%.1f", total / (double)1024.0F) + " MB";
      } else if (total <= (double)1.0F) {
         totals = String.format("%.1f", total) + " KB";
      }

      double totalHD = (double)0.0F;
      double usedHD = (double)0.0F;
      double precent = (double)0.0F;
      Runtime rt = Runtime.getRuntime();
      double activityTime = (double)0.0F;
      BufferedReader in = null;
      BufferedReader in1 = null;

      try {
         Process p = rt.exec("df -hl");
         in = new BufferedReader(new InputStreamReader(p.getInputStream()));
         String str = null;
         String[] strArray = null;

         while((str = in.readLine()) != null) {
            int m = 0;
            strArray = str.split(" ");

            for(String tmp : strArray) {
               if (tmp.trim().length() != 0) {
                  ++m;
                  if (tmp.indexOf("G") != -1) {
                     if (m == 2 && !tmp.equals("") && !tmp.equals("0")) {
                        totalHD += Double.parseDouble(tmp.substring(0, tmp.length() - 1)) * (double)1024.0F;
                     }

                     if (m == 3 && !tmp.equals("none") && !tmp.equals("0")) {
                        usedHD += Double.parseDouble(tmp.substring(0, tmp.length() - 1)) * (double)1024.0F;
                     }
                  }

                  if (tmp.indexOf("M") != -1) {
                     if (m == 2 && !tmp.equals("") && !tmp.equals("0")) {
                        totalHD += Double.parseDouble(tmp.substring(0, tmp.length() - 1));
                     }

                     if (m == 3 && !tmp.equals("none") && !tmp.equals("0")) {
                        usedHD += Double.parseDouble(tmp.substring(0, tmp.length() - 1));
                     }
                  }
               }
            }
         }

         precent = usedHD / totalHD * (double)100.0F;
         BigDecimal b1 = new BigDecimal(precent);
         precent = b1.setScale(2, 4).doubleValue();
         Process exec = rt.exec("iostat -x ");
         in1 = new BufferedReader(new InputStreamReader(exec.getInputStream()));
         String str1 = null;
         int x = 0;

         while((str1 = in1.readLine()) != null) {
            if (x != 0) {
               String var72 = str1.substring(str1.length() - 4, str1.length());
               str1 = var72.trim();
               activityTime += Double.valueOf(str1);
            }

            if (str1.indexOf("Device") != -1) {
               ++x;
            }
         }
      } catch (Exception var48) {
      }

      String usePercents = String.format("%.2f", precent) + " %";
      totals = String.format("%.2f", totalHD / (double)1024.0F) + "G";
      map.put("totals", totals);
      map.put("usePercents", usePercents);
      map.put("readss", readss);
      map.put("writess", writess);
      map.put("activityTime", String.format("%.2f", activityTime));
      return map;
   }
}
