package com.chenyang.nse.bussiness.tools.xml;

import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.XmlInfoVo;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.product.ConnectivityOracle;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.product.DmainsInfa;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.product.DomainOptions;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.product.FailureMapping;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.product.GridInfo;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.product.InvalidMapping;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.product.MetaInfo;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.product.Monitoring;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.product.NodeMetaData;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.product.NodeOptions;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.product.PowerCenterIntegrationService;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.product.PowerCenterRepositoryService;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.product.PwxConnectivity;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.product.ServiceType;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.product.SqlResults;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.product.TableInfo;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.product.TomcatVariable;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.product.WSHubService;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.product.XmlProductInfo;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.product.logEvent;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.system.EnvironmentVariable;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.system.FileSystem;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.system.MyEntityResolver;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.system.OSPatches;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.system.SwapInfo;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.system.UserLimit;
import com.chenyang.nse.bussiness.tools.xml.xmlclass.system.XmlSystemInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.xpath.DefaultXPath;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHeight;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSignedTwipsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGrid;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGridCol;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTextScale;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTrPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVerticalJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHeightRule;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHint;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STLineSpacingRule;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STStyleType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle.Factory;

public class ParsingXML {
   public static void main(String[] args) {
      String configp = args[0];
      String substring = configp.substring(0, 7);
      if (!"config=".equals(substring)) {
         System.out.println("The correct parameter format is:(config=Configuration file path)");
      } else {
         String i = configp.split("=")[1];
         XWPFDocument xdoc = new XWPFDocument();

         try {
            File file = new File(i.trim());
            if (!file.exists()) {
               System.out.println("Configuration file does not exist!! Please confirm the file path");
               return;
            }

            BufferedReader input = new BufferedReader(new FileReader(file));
            Map<String, String> props = new HashMap();

            String text;
            while((text = input.readLine()) != null) {
               if (!"".equals(text)) {
                  String[] split = text.split("=");
                  props.put(split[0].trim(), split[1].trim());
               }
            }

            String saveWordPath = (String)props.get("saveWordPath");
            String rep_db_IP = (String)props.get("rep_db_IP");
            String rep_db_port = (String)props.get("rep_db_port");
            String rep_db_service_name = (String)props.get("rep_db_service_name");
            String rep_database_type = (String)props.get("rep_database_type");
            String rep_user_password = (String)props.get("rep_user_password");
            String rep_user = (String)props.get("rep_user");
            String csmfile = (String)props.get("csmfile");
            String startdate = (String)props.get("startdate");
            String enddate = (String)props.get("enddate");
            String licensedir = (String)props.get("licensedir");
            ResultVO resultVO = LicenseKeyTool.verifyproperties(licensedir);
            if (resultVO.getResult()) {
               createTable(xdoc, rep_db_IP, rep_db_port, rep_db_service_name, rep_database_type, rep_user_password, rep_user, csmfile, startdate, enddate);
               saveDocument(xdoc, saveWordPath);
            } else {
               System.out.println(resultVO.getMessage());
            }
         } catch (Exception e) {
            e.printStackTrace();
         }

      }
   }

   public static XmlInfoVo xmlInfoParsing(String xmlFileName) throws IOException {
      XmlInfoVo xmlInfoVo = new XmlInfoVo();
      List<MetaInfo> metaInfoList = new ArrayList();
      List<XmlSystemInfo> xmlSystemInfoList = new ArrayList();
      List<FileSystem> fileSystemList = new ArrayList();
      List<EnvironmentVariable> environmentVariableList = new ArrayList();
      List<UserLimit> userLimitList = new ArrayList();
      List<SwapInfo> swapInfoList = new ArrayList();
      List<OSPatches> osPatchesList = new ArrayList();
      List<XmlProductInfo> xmlProductInfoList = new ArrayList();
      List<TomcatVariable> tomcatVariableList = new ArrayList();
      List<DmainsInfa> dmainsInfaList = new ArrayList();
      List<NodeMetaData> nodeMetaDataList = new ArrayList();
      List<DomainOptions> domainOptionsList = new ArrayList();
      List<NodeOptions> nodeOptionsList = new ArrayList();
      List<Monitoring> monitoringList = new ArrayList();
      List<PowerCenterIntegrationService> powerCenterIntegrationServiceList = new ArrayList();
      List<PowerCenterRepositoryService> powerCenterRepositoryServiceList = new ArrayList();
      List<WSHubService> wSHubServiceList = new ArrayList();
      List<ConnectivityOracle> connectivityOracleList = new ArrayList();
      PwxConnectivity pwxConnectivity = new PwxConnectivity();
      List<PwxConnectivity> pwxConnectivityList = new ArrayList();
      List<ServiceType> serviceTypeList = new ArrayList();
      List<GridInfo> gridInfoList = new ArrayList();
      List<logEvent> logEventList = new ArrayList();

      try {
         File f = new File(xmlFileName);
         SAXReader reader = new SAXReader();
         reader.setEntityResolver(new MyEntityResolver());
         Document doc = reader.read(f);
         Element root = doc.getRootElement();
         Element metaInfo = root.element("meta");
         Element metainfo = metaInfo.element("metainfo");
         Element domain = metainfo.element("domain");
         String domainame = domain.attributeValue("name");
         MetaInfo meta = new MetaInfo();
         meta.setName("Domain Name");
         meta.setValue(domainame);
         metaInfoList.add(meta);
         Element csmruntime = metainfo.element("csmruntime");
         String rundatetime = csmruntime.attributeValue("rundatetime");
         meta = new MetaInfo();
         meta.setName("检查时间");
         meta.setValue(rundatetime);
         metaInfoList.add(meta);
         Element product = metainfo.element("product");
         String productversions = product.attributeValue("version");
         meta = new MetaInfo();
         meta.setName("PowerCenter版本");
         meta.setValue(productversions);
         metaInfoList.add(meta);
         Element system = metainfo.element("system");
         String os = system.attributeValue("os");
         meta = new MetaInfo();
         meta.setName("操作系统");
         meta.setValue(os);
         metaInfoList.add(meta);
         Element systemInfo = root.element("system");
         String osname = systemInfo.elementText("osname");
         XmlSystemInfo xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("ostype");
         xmlSystemInfo.setValue(osname);
         xmlSystemInfoList.add(xmlSystemInfo);
         String hostname = systemInfo.elementText("hostname");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("hostname");
         xmlSystemInfo.setValue(hostname);
         xmlSystemInfoList.add(xmlSystemInfo);
         String release = systemInfo.elementText("release");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("release");
         xmlSystemInfo.setValue(release);
         xmlSystemInfoList.add(xmlSystemInfo);
         String version = systemInfo.elementText("version");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("version");
         xmlSystemInfo.setValue(version);
         xmlSystemInfoList.add(xmlSystemInfo);
         String machine = systemInfo.elementText("machine");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("machine");
         xmlSystemInfo.setValue(machine);
         xmlSystemInfoList.add(xmlSystemInfo);
         String bitmode = systemInfo.elementText("bitmode");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("bitmode");
         xmlSystemInfo.setValue(bitmode);
         xmlSystemInfoList.add(xmlSystemInfo);
         String numberofcpu = systemInfo.elementText("numberofcpu");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("numberofcpu");
         xmlSystemInfo.setValue(numberofcpu);
         xmlSystemInfoList.add(xmlSystemInfo);
         String cpuspeed = systemInfo.elementText("cpuspeed");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("cpuspeed");
         xmlSystemInfo.setValue(cpuspeed);
         xmlSystemInfoList.add(xmlSystemInfo);
         String cpucores = systemInfo.elementText("cpucores");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("cpucores");
         xmlSystemInfo.setValue(cpucores);
         xmlSystemInfoList.add(xmlSystemInfo);
         String umask = systemInfo.elementText("umask");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("umask");
         xmlSystemInfo.setValue(umask);
         xmlSystemInfoList.add(xmlSystemInfo);
         String timezone = systemInfo.elementText("timezone");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("timezone");
         xmlSystemInfo.setValue(timezone);
         xmlSystemInfoList.add(xmlSystemInfo);
         String nsswitch = systemInfo.elementText("nsswitch");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("nsswitch");
         xmlSystemInfo.setValue(nsswitch);
         xmlSystemInfoList.add(xmlSystemInfo);
         String virtualization = systemInfo.elementText("virtualization");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("virtualization");
         xmlSystemInfo.setValue(virtualization);
         xmlSystemInfoList.add(xmlSystemInfo);
         String glibc = systemInfo.elementText("glibc");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("glibc version");
         xmlSystemInfo.setValue(glibc);
         xmlSystemInfoList.add(xmlSystemInfo);
         String rmail = systemInfo.elementText("rmail");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("rmail");
         xmlSystemInfo.setValue(rmail);
         xmlSystemInfoList.add(xmlSystemInfo);
         String maxfilesperproc = systemInfo.elementText("maxfilesperproc");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("maxfilesperproc");
         xmlSystemInfo.setValue(maxfilesperproc);
         xmlSystemInfoList.add(xmlSystemInfo);
         String maxthreadsperproc = systemInfo.elementText("maxthreadsperproc");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("maxthreadsperproc");
         xmlSystemInfo.setValue(maxthreadsperproc);
         xmlSystemInfoList.add(xmlSystemInfo);
         String mempagesize = systemInfo.elementText("mempagesize");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("mempagesize");
         xmlSystemInfo.setValue(mempagesize);
         xmlSystemInfoList.add(xmlSystemInfo);
         String physicalmemory = systemInfo.elementText("physicalmemory");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("physicalmemory");
         xmlSystemInfo.setValue(physicalmemory);
         xmlSystemInfoList.add(xmlSystemInfo);
         String freePhysicalMemory = systemInfo.elementText("freePhysicalMemory");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("freePhysicalMemory");
         xmlSystemInfo.setValue(freePhysicalMemory);
         xmlSystemInfoList.add(xmlSystemInfo);
         String corefile_pattern = systemInfo.elementText("corefile_pattern");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("corefile_pattern");
         xmlSystemInfo.setValue(corefile_pattern);
         xmlSystemInfoList.add(xmlSystemInfo);
         String debuggerinfo = systemInfo.elementText("debuggerinfo");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("debuggerinfo");
         xmlSystemInfo.setValue(debuggerinfo);
         xmlSystemInfoList.add(xmlSystemInfo);
         String cpuspeed_dump = systemInfo.elementText("cpuspeed_dump");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("cpuspeed_dump");
         xmlSystemInfo.setValue(cpuspeed_dump);
         xmlSystemInfoList.add(xmlSystemInfo);
         String domainname = systemInfo.elementText("domainname");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("domainname");
         xmlSystemInfo.setValue(domainname);
         xmlSystemInfoList.add(xmlSystemInfo);
         String teradata = systemInfo.elementText("teradata");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("teradata");
         xmlSystemInfo.setValue(teradata);
         xmlSystemInfoList.add(xmlSystemInfo);
         String ddVersion = systemInfo.elementText("ddVersion");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("ddVersion");
         xmlSystemInfo.setValue(ddVersion);
         xmlSystemInfoList.add(xmlSystemInfo);
         String processor = systemInfo.elementText("processor");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("processor");
         xmlSystemInfo.setValue(processor);
         xmlSystemInfoList.add(xmlSystemInfo);
         String proc = systemInfo.elementText("proc");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("proc");
         xmlSystemInfo.setValue(proc);
         xmlSystemInfoList.add(xmlSystemInfo);
         String bindprocessor = systemInfo.elementText("bindprocessor");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("bindprocessor");
         xmlSystemInfo.setValue(bindprocessor);
         xmlSystemInfoList.add(xmlSystemInfo);
         String lparstat = systemInfo.elementText("lparstat");
         xmlSystemInfo = new XmlSystemInfo();
         xmlSystemInfo.setName("lparstat");
         xmlSystemInfo.setValue(lparstat);
         xmlSystemInfoList.add(xmlSystemInfo);
         Element filesystem = systemInfo.element("filesystem");
         List<Element> fileList = filesystem.elements("file");

         for(int i = 0; i < fileList.size(); ++i) {
            FileSystem fileSystem = new FileSystem();
            Element file = (Element)fileList.get(i);
            String total = file.attributeValue("total");
            String percentage = file.attributeValue("percentage");
            String used = file.attributeValue("used");
            String free = file.attributeValue("free");
            String mount = file.attributeValue("mount");
            String home = file.attributeValue("home");
            fileSystem.setFree(free);
            fileSystem.setHome(home);
            fileSystem.setMount(mount);
            fileSystem.setPercentage(percentage);
            fileSystem.setTotal(total);
            fileSystem.setUsed(used);
            fileSystemList.add(fileSystem);
         }

         Element environment = systemInfo.element("environment");
         List<Element> variableList = environment.elements("variable");

         for(int i = 0; i < variableList.size(); ++i) {
            EnvironmentVariable environmentVariable = new EnvironmentVariable();
            Element variable = (Element)variableList.get(i);
            String name = variable.attributeValue("name");
            String value = variable.attributeValue("value");
            environmentVariable.setName(name);
            environmentVariable.setValue(value);
            environmentVariableList.add(environmentVariable);
         }

         Element userlimit = systemInfo.element("userlimit");
         List<Element> ulimitList = userlimit.elements("ulimit");

         for(int i = 0; i < ulimitList.size(); ++i) {
            UserLimit userLimit = new UserLimit();
            Element ulimit = (Element)ulimitList.get(i);
            String name = ulimit.attributeValue("name");
            String hard = ulimit.attributeValue("hard");
            String soft = ulimit.attributeValue("soft");
            userLimit.setName(name);
            userLimit.setHard(hard);
            userLimit.setSoft(soft);
            userLimitList.add(userLimit);
         }

         Element swapinfo = systemInfo.element("swapinfo");
         List<Element> swapList = swapinfo.elements("swap");

         for(int i = 0; i < swapList.size(); ++i) {
            SwapInfo swapInfo = new SwapInfo();
            Element swap = (Element)swapList.get(i);
            String used = swap.attributeValue("used");
            String free = swap.attributeValue("free");
            swapInfo.setFree(free);
            swapInfo.setUsed(used);
            swapInfoList.add(swapInfo);
         }

         Element ospatches = systemInfo.element("ospatches");
         if (ospatches != null) {
            List<Element> patchList = ospatches.elements("patch");

            for(int i = 0; i < patchList.size(); ++i) {
               OSPatches osPatches = new OSPatches();
               Element patch = (Element)patchList.get(i);
               String name = patch.attributeValue("name");
               osPatches.setName(name);
               osPatchesList.add(osPatches);
            }
         }

         Element productInfo = root.element("product");
         String productversion = productInfo.elementText("version");
         XmlProductInfo xmlProductInfo = new XmlProductInfo();
         xmlProductInfo.setName("Product Version");
         xmlProductInfo.setValue(productversion);
         xmlProductInfoList.add(xmlProductInfo);
         String javaversion = productInfo.elementText("java_info");
         xmlProductInfo = new XmlProductInfo();
         xmlProductInfo.setName("Java Version");
         xmlProductInfo.setValue(javaversion);
         xmlProductInfoList.add(xmlProductInfo);
         Element tomcat_envvarsinfo = productInfo.element("tomcat_envvars");
         List<Element> tomcat_variableList = tomcat_envvarsinfo.elements("tomcat_variable");

         for(int i = 0; i < tomcat_variableList.size(); ++i) {
            TomcatVariable tomcatVariable = new TomcatVariable();
            Element tomcat_variable = (Element)tomcat_variableList.get(i);
            String name = tomcat_variable.attributeValue("name");
            String value = tomcat_variable.attributeValue("value");
            tomcatVariable.setName(name);
            tomcatVariable.setValue(value);
            tomcatVariableList.add(tomcatVariable);
            if ("LD_LIBRARY_PATH".equals(name)) {
               pwxConnectivity.setName(name);
               pwxConnectivity.setValue(value);
               pwxConnectivityList.add(pwxConnectivity);
            }
         }

         Element domainsinfa = productInfo.element("domainsinfa");
         Element Portals = domainsinfa.element("Portals");
         Element vector = Portals.element("vector");
         DmainsInfa dmainsInfa = new DmainsInfa();
         String domainName = vector.elementText("domainName");
         dmainsInfa.setName("Domain Name");
         dmainsInfa.setValue(domainName);
         dmainsInfaList.add(dmainsInfa);
         List<Element> addressarr = vector.elements("address");

         for(int i = 0; i < addressarr.size(); ++i) {
            String host = ((Element)addressarr.get(i)).elementText("host");
            dmainsInfa = new DmainsInfa();
            dmainsInfa.setName("Host");
            dmainsInfa.setValue(host);
            dmainsInfaList.add(dmainsInfa);
            String port = ((Element)addressarr.get(i)).elementText("port");
            dmainsInfa = new DmainsInfa();
            dmainsInfa.setName("Port");
            dmainsInfa.setValue(port);
            dmainsInfaList.add(dmainsInfa);
         }

         Element listUsers = productInfo.element("listUsers");
         String userCount = listUsers.attributeValue("count");
         dmainsInfa = new DmainsInfa();
         dmainsInfa.setName("User Count");
         dmainsInfa.setValue(userCount);
         dmainsInfaList.add(dmainsInfa);
         Element listServices = productInfo.element("listServices");
         String serviceCount = listServices.attributeValue("count");
         dmainsInfa = new DmainsInfa();
         dmainsInfa.setName("Service Count");
         dmainsInfa.setValue(serviceCount);
         dmainsInfaList.add(dmainsInfa);
         Element lastDayErrorLogs = productInfo.element("lastDayErrorLogs");
         if (lastDayErrorLogs != null) {
            Element log = lastDayErrorLogs.element("log");
            List<Element> logEventsList = log.elements("logEvent");

            for(int i = 0; i < logEventsList.size(); ++i) {
               logEvent logEvent = new logEvent();
               String serviceType = ((Element)logEventsList.get(i)).attributeValue("serviceType");
               String severity = ((Element)logEventsList.get(i)).attributeValue("severity");
               String stacktrace = ((Element)logEventsList.get(i)).attributeValue("stacktrace");
               String service = ((Element)logEventsList.get(i)).attributeValue("service");
               String context = ((Element)logEventsList.get(i)).attributeValue("context");
               String messageCode = ((Element)logEventsList.get(i)).attributeValue("messageCode");
               String pid = ((Element)logEventsList.get(i)).attributeValue("pid");
               String message = ((Element)logEventsList.get(i)).attributeValue("message");
               String user = ((Element)logEventsList.get(i)).attributeValue("user");
               String clientNode = ((Element)logEventsList.get(i)).attributeValue("clientNode");
               String threadName = ((Element)logEventsList.get(i)).attributeValue("threadName");
               String timestamp = ((Element)logEventsList.get(i)).attributeValue("timestamp");
               logEvent.setServiceType(serviceType);
               logEvent.setSeverity(severity);
               logEvent.setStacktrace(stacktrace);
               logEvent.setService(service);
               logEvent.setContext(context);
               logEvent.setMessageCode(messageCode);
               logEvent.setPid(pid);
               logEvent.setMessage(message);
               logEvent.setUser(user);
               logEvent.setClientNode(clientNode);
               logEvent.setThreadName(threadName);
               logEvent.setTimestamp(timestamp);
               logEventList.add(logEvent);
            }

            Set<logEvent> userSet = new HashSet(logEventList);
            logEventList = new ArrayList(userSet);
         }

         Element nodemetadata = productInfo.element("nodemetadata");
         Element domainserviceGatewayNodeConfig = getResultByNodeNameForNameSpace(doc, "domainservice:GatewayNodeConfig", "domainservice", "http://com.informatica.isp.metadata.domainservice/2");
         String ndomainName = domainserviceGatewayNodeConfig.attributeValue("domainName");
         String nodeName = domainserviceGatewayNodeConfig.attributeValue("nodeName");
         String adminconsolePort = domainserviceGatewayNodeConfig.attributeValue("adminconsolePort");
         String adminconsoleShutdownPort = domainserviceGatewayNodeConfig.attributeValue("adminconsoleShutdownPort");
         Element address = domainserviceGatewayNodeConfig.element("address");
         String port = address.attributeValue("port");
         String httpPort = address.attributeValue("httpPort");
         String host = address.attributeValue("host");
         Element domainserviceDBConnectivity = getResultByNodeNameForNameSpace(doc, "domainservice:DBConnectivity", "domainservice", "http://com.informatica.isp.metadata.domainservice/2");
         String dbType = domainserviceDBConnectivity.attributeValue("dbType");
         String dbUsername = domainserviceDBConnectivity.attributeValue("dbUsername");
         String dbPort = domainserviceDBConnectivity.attributeValue("dbPort");
         Element portals = domainserviceGatewayNodeConfig.element("portals");
         List<Element> NodeRefList = portals.elements("NodeRef");
         NodeMetaData nodeMetaData = new NodeMetaData();
         nodeMetaData.setName("Domain Name");
         nodeMetaData.setValue(ndomainName);
         nodeMetaDataList.add(nodeMetaData);
         nodeMetaData = new NodeMetaData();
         nodeMetaData.setName("Node Name");
         nodeMetaData.setValue(nodeName);
         nodeMetaDataList.add(nodeMetaData);
         nodeMetaData = new NodeMetaData();
         nodeMetaData.setName("Adminconsole Port");
         nodeMetaData.setValue(adminconsolePort);
         nodeMetaDataList.add(nodeMetaData);
         nodeMetaData = new NodeMetaData();
         nodeMetaData.setName("Adminconsole Shutdown Port");
         nodeMetaData.setValue(adminconsoleShutdownPort);
         nodeMetaDataList.add(nodeMetaData);
         nodeMetaData = new NodeMetaData();
         nodeMetaData.setName("Host");
         nodeMetaData.setValue(host);
         nodeMetaDataList.add(nodeMetaData);
         nodeMetaData = new NodeMetaData();
         nodeMetaData.setName("Http Port");
         nodeMetaData.setValue(httpPort);
         nodeMetaDataList.add(nodeMetaData);
         nodeMetaData = new NodeMetaData();
         nodeMetaData.setName("Port");
         nodeMetaData.setValue(port);
         nodeMetaDataList.add(nodeMetaData);
         nodeMetaData = new NodeMetaData();
         nodeMetaData.setName("Database Type");
         nodeMetaData.setValue(dbType);
         nodeMetaDataList.add(nodeMetaData);
         nodeMetaData = new NodeMetaData();
         nodeMetaData.setName("Db Username");
         nodeMetaData.setValue(dbUsername);
         nodeMetaDataList.add(nodeMetaData);
         nodeMetaData = new NodeMetaData();
         nodeMetaData.setName("Db Port");
         nodeMetaData.setValue(dbPort);
         nodeMetaDataList.add(nodeMetaData);

         for(int i = 0; i < NodeRefList.size(); ++i) {
            String names = ((Element)NodeRefList.get(i)).attributeValue("nodeName");
            nodeMetaData = new NodeMetaData();
            nodeMetaData.setName("Gateway NodeName");
            nodeMetaData.setValue(names);
            nodeMetaDataList.add(nodeMetaData);
         }

         Element DomainMeta = productInfo.element("DomainMeta");
         List<Element> OptionGroupList = DomainMeta.elements("OptionGroup");

         for(int i = 0; i < OptionGroupList.size(); ++i) {
            String name = ((Element)OptionGroupList.get(i)).attributeValue("name");
            if ("DomainOptions".endsWith(name)) {
               List<Element> Options = ((Element)OptionGroupList.get(i)).elements("Option");

               for(int j = 0; j < Options.size(); ++j) {
                  DomainOptions domainOptions = new DomainOptions();
                  String names = ((Element)Options.get(j)).attributeValue("name");
                  String value = ((Element)Options.get(j)).attributeValue("value");
                  domainOptions.setName(names);
                  domainOptions.setValue(value);
                  domainOptionsList.add(domainOptions);
               }
            }
         }

         Element NodeOptions = DomainMeta.element("NodeOptions");
         List<Element> NodeList = NodeOptions.elements("Node");

         for(int i = 0; i < NodeList.size(); ++i) {
            NodeOptions nodeOptions = new NodeOptions();
            String name = ((Element)NodeList.get(i)).attributeValue("name");
            nodeOptions.setName("nodename");
            nodeOptions.setValue(name);
            nodeOptionsList.add(nodeOptions);
            List<Element> OptionGroup = ((Element)NodeList.get(i)).elements("OptionGroup");

            for(int j = 0; j < OptionGroup.size(); ++j) {
               List<Element> Option = ((Element)OptionGroup.get(j)).elements("Option");

               for(int k = 0; k < Option.size(); ++k) {
                  String names = ((Element)Option.get(k)).attributeValue("name");
                  String value = ((Element)Option.get(k)).attributeValue("value");
                  nodeOptions = new NodeOptions();
                  nodeOptions.setName(names);
                  nodeOptions.setValue(value);
                  nodeOptionsList.add(nodeOptions);
               }
            }
         }

         Element GridInfo = DomainMeta.element("GridInfo");
         Element Grid = GridInfo.element("Grid");
         String namess = Grid.attributeValue("name");
         GridInfo gridInfo = new GridInfo();
         gridInfo.setName("Grid Name");
         gridInfo.setValue(namess);
         gridInfoList.add(gridInfo);
         List<Element> Nodess = Grid.elements("Node");

         for(int i = 0; i < Nodess.size(); ++i) {
            gridInfo = new GridInfo();
            String name = ((Element)Nodess.get(i)).attributeValue("name");
            gridInfo.setName("NodeName");
            gridInfo.setValue(name);
            gridInfoList.add(gridInfo);
         }

         Element listMonitoringOptions = productInfo.element("listMonitoringOptions");
         List<Element> listMonitoringOptions_info = listMonitoringOptions.elements("listMonitoringOptions_info");

         for(int i = 0; i < listMonitoringOptions_info.size(); ++i) {
            Monitoring monitoring = new Monitoring();
            String names = ((Element)listMonitoringOptions_info.get(i)).attributeValue("name");
            String value = ((Element)listMonitoringOptions_info.get(i)).attributeValue("value");
            monitoring.setName(names);
            monitoring.setValue(value);
            monitoringList.add(monitoring);
         }

         List<Element> serviceList = DomainMeta.elements("Service");

         for(int i = 0; i < serviceList.size(); ++i) {
            String type = ((Element)serviceList.get(i)).attributeValue("type");
            String name = ((Element)serviceList.get(i)).attributeValue("name");
            ServiceType serviceType = new ServiceType();
            if ("PowerCenterIntegrationService".equals(type)) {
               List<Element> ServiceProcessList = ((Element)serviceList.get(i)).elements("ServiceProcess");

               for(int j = 0; j < ServiceProcessList.size(); ++j) {
                  Element Nodes = ((Element)ServiceProcessList.get(j)).element("Node");
                  String names = Nodes.attributeValue("name");
                  PowerCenterIntegrationService powerCenterIntegrationService = new PowerCenterIntegrationService();
                  powerCenterIntegrationService.setName("Node Name");
                  powerCenterIntegrationService.setValue(names);
                  powerCenterIntegrationServiceList.add(powerCenterIntegrationService);
                  Element OptionGroup = ((Element)ServiceProcessList.get(j)).element("OptionGroup");
                  List<Element> OptionList = OptionGroup.elements("Option");

                  for(int k = 0; k < OptionList.size(); ++k) {
                     String namek = ((Element)OptionList.get(k)).attributeValue("name");
                     String valuek = ((Element)OptionList.get(k)).attributeValue("value");
                     powerCenterIntegrationService = new PowerCenterIntegrationService();
                     powerCenterIntegrationService.setName(namek);
                     powerCenterIntegrationService.setValue(valuek);
                     powerCenterIntegrationServiceList.add(powerCenterIntegrationService);
                  }
               }

               serviceType.setName(name);
               serviceType.setValue(type);
               serviceTypeList.add(serviceType);
               Element OptionGroup = ((Element)serviceList.get(i)).element("OptionGroup");
               List<Element> Option = OptionGroup.elements("Option");

               for(int j = 0; j < Option.size(); ++j) {
                  PowerCenterIntegrationService powerCenterIntegrationService = new PowerCenterIntegrationService();
                  String names = ((Element)Option.get(j)).attributeValue("name");
                  String value = ((Element)Option.get(j)).attributeValue("value");
                  powerCenterIntegrationService.setName(names);
                  powerCenterIntegrationService.setValue(value);
                  powerCenterIntegrationServiceList.add(powerCenterIntegrationService);
               }
            }

            if ("PowerCenterRepositoryService".equals(type)) {
               List<Element> ServiceProcessList = ((Element)serviceList.get(i)).elements("ServiceProcess");

               for(int j = 0; j < ServiceProcessList.size(); ++j) {
                  Element Nodes = ((Element)ServiceProcessList.get(j)).element("Node");
                  String names = Nodes.attributeValue("name");
                  PowerCenterRepositoryService powerCenterRepositoryService = new PowerCenterRepositoryService();
                  powerCenterRepositoryService.setName("Node Name");
                  powerCenterRepositoryService.setValue(names);
                  powerCenterRepositoryServiceList.add(powerCenterRepositoryService);
                  Element OptionGroup = ((Element)ServiceProcessList.get(j)).element("OptionGroup");
                  List<Element> OptionList = OptionGroup.elements("Option");

                  for(int k = 0; k < OptionList.size(); ++k) {
                     String namek = ((Element)OptionList.get(k)).attributeValue("name");
                     String valuek = ((Element)OptionList.get(k)).attributeValue("value");
                     powerCenterRepositoryService = new PowerCenterRepositoryService();
                     powerCenterRepositoryService.setName(namek);
                     powerCenterRepositoryService.setValue(valuek);
                     powerCenterRepositoryServiceList.add(powerCenterRepositoryService);
                  }
               }

               serviceType.setName(name);
               serviceType.setValue(type);
               serviceTypeList.add(serviceType);
               Element OptionGroup = ((Element)serviceList.get(i)).element("OptionGroup");
               List<Element> Option = OptionGroup.elements("Option");

               for(int j = 0; j < Option.size(); ++j) {
                  PowerCenterRepositoryService powerCenterRepositoryService = new PowerCenterRepositoryService();
                  String names = ((Element)Option.get(j)).attributeValue("name");
                  String value = ((Element)Option.get(j)).attributeValue("value");
                  powerCenterRepositoryService.setName(names);
                  powerCenterRepositoryService.setValue(value);
                  powerCenterRepositoryServiceList.add(powerCenterRepositoryService);
               }
            }

            if ("WSHubService".equals(type)) {
               List<Element> ServiceProcessList = ((Element)serviceList.get(i)).elements("ServiceProcess");

               for(int j = 0; j < ServiceProcessList.size(); ++j) {
                  Element Nodes = ((Element)ServiceProcessList.get(j)).element("Node");
                  String names = Nodes.attributeValue("name");
                  WSHubService wSHubService = new WSHubService();
                  wSHubService.setName("Node Name");
                  wSHubService.setValue(names);
                  wSHubServiceList.add(wSHubService);
                  Element OptionGroup = ((Element)ServiceProcessList.get(j)).element("OptionGroup");
                  if (OptionGroup != null) {
                     List<Element> OptionList = OptionGroup.elements("Option");

                     for(int k = 0; k < OptionList.size(); ++k) {
                        String namek = ((Element)OptionList.get(k)).attributeValue("name");
                        String valuek = ((Element)OptionList.get(k)).attributeValue("value");
                        wSHubService = new WSHubService();
                        wSHubService.setName(namek);
                        wSHubService.setValue(valuek);
                        wSHubServiceList.add(wSHubService);
                     }
                  }
               }

               serviceType.setName(name);
               serviceType.setValue(type);
               serviceTypeList.add(serviceType);
               Element OptionGroup = ((Element)serviceList.get(i)).element("OptionGroup");
               List<Element> Option = OptionGroup.elements("Option");

               for(int j = 0; j < Option.size(); ++j) {
                  WSHubService wSHubService = new WSHubService();
                  String names = ((Element)Option.get(j)).attributeValue("name");
                  String value = ((Element)Option.get(j)).attributeValue("value");
                  wSHubService.setName(names);
                  wSHubService.setValue(value);
                  wSHubServiceList.add(wSHubService);
               }
            }
         }

         String OracleDbVersion = productInfo.elementText("OracleDbVersion");
         ConnectivityOracle ConnectivityOracle1 = new ConnectivityOracle();
         ConnectivityOracle1.setName("OracleDbVersion");
         ConnectivityOracle1.setValue(OracleDbVersion);
         connectivityOracleList.add(ConnectivityOracle1);
         Element oracleserver = productInfo.element("oracleserver");
         Element homevar = oracleserver.element("homevar");
         String homeVariable = homevar.attributeValue("name");
         ConnectivityOracle1 = new ConnectivityOracle();
         ConnectivityOracle1.setName("home Variable");
         ConnectivityOracle1.setValue(homeVariable);
         connectivityOracleList.add(ConnectivityOracle1);
         String setinenv = homevar.attributeValue("setinenv");
         ConnectivityOracle1 = new ConnectivityOracle();
         ConnectivityOracle1.setName("set in env");
         ConnectivityOracle1.setValue(setinenv);
         connectivityOracleList.add(ConnectivityOracle1);
         String value = homevar.attributeValue("value");
         ConnectivityOracle1 = new ConnectivityOracle();
         ConnectivityOracle1.setName("value");
         ConnectivityOracle1.setValue(value);
         connectivityOracleList.add(ConnectivityOracle1);
         Element exedir = oracleserver.element("exedir");
         String Exedirectory = exedir.attributeValue("name");
         ConnectivityOracle1 = new ConnectivityOracle();
         ConnectivityOracle1.setName("Exe directory");
         ConnectivityOracle1.setValue(Exedirectory);
         connectivityOracleList.add(ConnectivityOracle1);
         String found = exedir.attributeValue("found");
         ConnectivityOracle1 = new ConnectivityOracle();
         ConnectivityOracle1.setName("found");
         ConnectivityOracle1.setValue(found);
         connectivityOracleList.add(ConnectivityOracle1);
         String matchhome = exedir.attributeValue("matchhome");
         ConnectivityOracle1 = new ConnectivityOracle();
         ConnectivityOracle1.setName("match home");
         ConnectivityOracle1.setValue(matchhome);
         connectivityOracleList.add(ConnectivityOracle1);
         Element bin = oracleserver.element("bin");
         String directory = bin.attributeValue("directory");
         ConnectivityOracle1 = new ConnectivityOracle();
         ConnectivityOracle1.setName("Bin Directory");
         ConnectivityOracle1.setValue(directory);
         connectivityOracleList.add(ConnectivityOracle1);
         String exists = bin.attributeValue("exists");
         ConnectivityOracle1 = new ConnectivityOracle();
         ConnectivityOracle1.setName("exists");
         ConnectivityOracle1.setValue(exists);
         connectivityOracleList.add(ConnectivityOracle1);
         String setinenv1 = bin.attributeValue("setinenv");
         ConnectivityOracle1 = new ConnectivityOracle();
         ConnectivityOracle1.setName("set in env");
         ConnectivityOracle1.setValue(setinenv1);
         connectivityOracleList.add(ConnectivityOracle1);
         Element lib = oracleserver.element("lib");
         String directory2 = lib.attributeValue("directory");
         ConnectivityOracle1 = new ConnectivityOracle();
         ConnectivityOracle1.setName("Lib Directory");
         ConnectivityOracle1.setValue(directory2);
         connectivityOracleList.add(ConnectivityOracle1);
         String exists1 = lib.attributeValue("exists");
         ConnectivityOracle1 = new ConnectivityOracle();
         ConnectivityOracle1.setName("exists");
         ConnectivityOracle1.setValue(exists1);
         connectivityOracleList.add(ConnectivityOracle1);
         String setinenv2 = lib.attributeValue("setinenv");
         ConnectivityOracle1 = new ConnectivityOracle();
         ConnectivityOracle1.setName("set in env");
         ConnectivityOracle1.setValue(setinenv2);
         connectivityOracleList.add(ConnectivityOracle1);
         Element lib32 = oracleserver.element("lib32");
         String directory3 = lib32.attributeValue("directory");
         ConnectivityOracle1 = new ConnectivityOracle();
         ConnectivityOracle1.setName("Lib Directory");
         ConnectivityOracle1.setValue(directory3);
         connectivityOracleList.add(ConnectivityOracle1);
         String exists2 = lib32.attributeValue("exists");
         ConnectivityOracle1 = new ConnectivityOracle();
         ConnectivityOracle1.setName("exists");
         ConnectivityOracle1.setValue(exists2);
         connectivityOracleList.add(ConnectivityOracle1);
         String setinenv3 = lib32.attributeValue("setinenv");
         ConnectivityOracle1 = new ConnectivityOracle();
         ConnectivityOracle1.setName("set in env");
         ConnectivityOracle1.setValue(setinenv3);
         connectivityOracleList.add(ConnectivityOracle1);
         xmlInfoVo.setConnectivityOracleList(connectivityOracleList);
         xmlInfoVo.setDmainsInfaList(dmainsInfaList);
         xmlInfoVo.setDomainOptionsList(domainOptionsList);
         xmlInfoVo.setEnvironmentVariableList(environmentVariableList);
         xmlInfoVo.setFileSystemList(fileSystemList);
         xmlInfoVo.setMonitoringList(monitoringList);
         xmlInfoVo.setNodeMetaDataList(nodeMetaDataList);
         xmlInfoVo.setNodeOptionsList(nodeOptionsList);
         xmlInfoVo.setOsPatchesList(osPatchesList);
         xmlInfoVo.setPowerCenterIntegrationServiceList(powerCenterIntegrationServiceList);
         xmlInfoVo.setPowerCenterRepositoryServiceList(powerCenterRepositoryServiceList);
         xmlInfoVo.setPwxConnectivityList(pwxConnectivityList);
         xmlInfoVo.setSwapInfoList(swapInfoList);
         xmlInfoVo.setTomcatVariableList(tomcatVariableList);
         xmlInfoVo.setUserLimitList(userLimitList);
         xmlInfoVo.setwSHubServiceList(wSHubServiceList);
         xmlInfoVo.setXmlProductInfoList(xmlProductInfoList);
         xmlInfoVo.setXmlSystemInfoList(xmlSystemInfoList);
         xmlInfoVo.setMetaInfoList(metaInfoList);
         xmlInfoVo.setServiceTypeList(serviceTypeList);
         xmlInfoVo.setGridInfoList(gridInfoList);
         xmlInfoVo.setLogEventList(logEventList);
      } catch (DocumentException e) {
         e.printStackTrace();
      }

      return xmlInfoVo;
   }

   public static String getResultByNodeNameForNameSpace(String xmlResult, String nodeName, String nameSpaceName, String nameSpaceUrl) throws DocumentException {
      Document doc = DocumentHelper.parseText(xmlResult);
      DefaultXPath xPath = new DefaultXPath("//" + nodeName);
      xPath.setNamespaceURIs(Collections.singletonMap(nameSpaceName, nameSpaceUrl));
      List list = xPath.selectNodes(doc);
      if (!list.isEmpty() && list.size() > 0) {
         Element node = (Element)list.get(0);
         return node.getText();
      } else {
         return "";
      }
   }

   public static Element getResultByNodeNameForNameSpace(Document doc, String nodeName, String nameSpaceName, String nameSpaceUrl) throws DocumentException {
      DefaultXPath xPath = new DefaultXPath("//" + nodeName);
      xPath.setNamespaceURIs(Collections.singletonMap(nameSpaceName, nameSpaceUrl));
      List list = xPath.selectNodes(doc);
      Element node = (Element)list.get(0);
      return node;
   }

   public static void createTable(XWPFDocument xdoc, String rep_db_IP, String rep_db_port, String rep_db_service_name, String rep_database_type, String rep_user_password, String rep_user, String csmfile, String startdate, String enddate) throws Exception {
      List<InvalidMapping> invalidMappinglist = null;
      List<FailureMapping> failureMappinglist = null;
      List<SqlResults> sqlResultslist = null;
      if (!"null".equals(rep_user) && !"NULL".equals(rep_user)) {
         String url = "jdbc:" + rep_database_type + ":thin:@" + rep_db_IP + ":" + rep_db_port + ":" + rep_db_service_name + "";
         Map<String, List> oracleConnect = OracleConnect(url, rep_user_password, rep_user, startdate, enddate);
         invalidMappinglist = (List)oracleConnect.get("invalidMapping");
         failureMappinglist = (List)oracleConnect.get("failureMapping");
         sqlResultslist = (List)oracleConnect.get("sqlResultslist");
      }

      XmlInfoVo xmlInfoParsing = xmlInfoParsing(csmfile);
      List<XmlSystemInfo> xmlSystemInfoList = xmlInfoParsing.getXmlSystemInfoList();
      List<FileSystem> fileSystemList = xmlInfoParsing.getFileSystemList();
      List<SwapInfo> swapInfoList = xmlInfoParsing.getSwapInfoList();
      List<OSPatches> osPatchesList = xmlInfoParsing.getOsPatchesList();
      List<UserLimit> userLimitList = xmlInfoParsing.getUserLimitList();
      List<EnvironmentVariable> environmentVariableList = xmlInfoParsing.getEnvironmentVariableList();
      List<XmlProductInfo> xmlProductInfoList = xmlInfoParsing.getXmlProductInfoList();
      List<TomcatVariable> tomcatVariableList = xmlInfoParsing.getTomcatVariableList();
      List<DmainsInfa> dmainsInfaList = xmlInfoParsing.getDmainsInfaList();
      List<NodeMetaData> nodeMetaDataList = xmlInfoParsing.getNodeMetaDataList();
      List<DomainOptions> domainOptionsList = xmlInfoParsing.getDomainOptionsList();
      List<NodeOptions> nodeOptionsList = xmlInfoParsing.getNodeOptionsList();
      List<Monitoring> monitoringList = xmlInfoParsing.getMonitoringList();
      List<PowerCenterIntegrationService> powerCenterIntegrationServiceList = xmlInfoParsing.getPowerCenterIntegrationServiceList();
      List<PowerCenterRepositoryService> powerCenterRepositoryServiceList = xmlInfoParsing.getPowerCenterRepositoryServiceList();
      List<WSHubService> wSHubServiceList = xmlInfoParsing.getwSHubServiceList();
      List<ConnectivityOracle> connectivityOracleList = xmlInfoParsing.getConnectivityOracleList();
      List<PwxConnectivity> pwxConnectivityList = xmlInfoParsing.getPwxConnectivityList();
      List<MetaInfo> metaInfoList = xmlInfoParsing.getMetaInfoList();
      List<ServiceType> serviceTypeList = xmlInfoParsing.getServiceTypeList();
      List<GridInfo> gridInfoList = xmlInfoParsing.getGridInfoList();
      List<logEvent> logEventList = xmlInfoParsing.getLogEventList();
      if (metaInfoList.size() > 0) {
         int count = metaInfoList.size();
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "汇总", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{1504, 1504, 1504, 1504, 1504, 1504};
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            String name = ((MetaInfo)metaInfoList.get(j)).getName();
            String value = ((MetaInfo)metaInfoList.get(j)).getValue();
            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (i == 0) {
                  setParagraphRunFontInfo(p, pRun, name, "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
               } else {
                  setParagraphRunFontInfo(p, pRun, value, "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
               }
            }

            ++index;
         }
      }

      if (xmlSystemInfoList.size() > 0) {
         int count = 15;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 1", 1);
         p.setStyle("标题 1");
         setParagraphRunFontInfo(p, pRun, "1.Configuration", "宋体", "Times New Roman", "30", true, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 2", 2);
         p.setStyle("标题 2");
         setParagraphRunFontInfo(p, pRun, "1.1. System", "宋体", "Times New Roman", "30", true, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.1.1. General Information", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{1504, 1504, 1504, 1504, 1504, 1504};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            String name = ((XmlSystemInfo)xmlSystemInfoList.get(j)).getName();
            String value = ((XmlSystemInfo)xmlSystemInfoList.get(j)).getValue();
            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.BOTTOM);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (i == 0) {
                  setParagraphRunFontInfo(p, pRun, name, "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
               } else {
                  setParagraphRunFontInfo(p, pRun, value, "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
               }
            }

            ++index;
         }
      }

      if (xmlSystemInfoList.size() > 0) {
         int count = 3;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.1.2.Kernel Parameter", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{1504, 1504, 1504, 1504, 1504, 1504};
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            String name = ((XmlSystemInfo)xmlSystemInfoList.get(j + 15)).getName();
            String value = ((XmlSystemInfo)xmlSystemInfoList.get(j + 15)).getValue();
            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (i == 0) {
                  setParagraphRunFontInfo(p, pRun, name, "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
               } else {
                  setParagraphRunFontInfo(p, pRun, value, "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
               }
            }

            ++index;
         }
      }

      if (fileSystemList.size() > 0) {
         int count = fileSystemList.size() + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.1.3.\tFile System Statistics", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 6);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{10, 50, 50, 50, 50, 50};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 6; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Mount Point");
               s.add("Home");
               s.add("Total Space");
               s.add("Free Space");
               s.add("Used Space");
               s.add("Used Percentage");
            } else {
               String mount = ((FileSystem)fileSystemList.get(j - 1)).getMount();
               String home = ((FileSystem)fileSystemList.get(j - 1)).getHome();
               String total = ((FileSystem)fileSystemList.get(j - 1)).getTotal();
               String free = ((FileSystem)fileSystemList.get(j - 1)).getFree();
               String used = ((FileSystem)fileSystemList.get(j - 1)).getUsed();
               String percentage = ((FileSystem)fileSystemList.get(j - 1)).getPercentage();
               s.add(mount);
               s.add(home);
               s.add(total);
               s.add(free);
               s.add(used);
               s.add(percentage);
            }

            row = table.getRow(index);

            for(int i = 0; i < 6; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               setTableGridCol(table, COLUMN_WIDTHS);
               String string = getStringByEnter(11, ((String)s.get(i)).trim());
               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, string, "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               } else {
                  NumberFormat nf = NumberFormat.getPercentInstance();
                  Number m = nf.parse((String)s.get(5));
                  double dd = m.doubleValue();
                  double aa = 0.8;
                  if (dd > 0.8) {
                     setParagraphRunFontInfo(p, pRun, string, "宋体", "Times New Roman", "21", false, false, false, true, "FF0000", (STShd.Enum)null, -1, -1, -1);
                  } else {
                     setParagraphRunFontInfo(p, pRun, string, "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
                  }
               }
            }

            ++index;
         }

         setTableGridCol(table, COLUMN_WIDTHS);
      }

      if (xmlSystemInfoList.size() > 0) {
         int count = 2 + swapInfoList.size() * 2;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.1.4.Memory", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{1504, 1504, 1504, 1504, 1504, 1504};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j < 2) {
               String name = ((XmlSystemInfo)xmlSystemInfoList.get(j + 18)).getName();
               String value = ((XmlSystemInfo)xmlSystemInfoList.get(j + 18)).getValue();
               s.add(name);
               s.add(value);
            } else if (j == 3) {
               String free = ((SwapInfo)swapInfoList.get(0)).getFree();
               String name = "free swap";
               s.add(name);
               s.add(free);
            } else {
               String used = ((SwapInfo)swapInfoList.get(0)).getUsed();
               String name = "used swap";
               s.add(name);
               s.add(used);
            }

            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
            }

            ++index;
         }
      }

      if (xmlSystemInfoList.size() > 0) {
         int count = 3;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.1.5.CPU Information", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{1504, 1504, 1504, 1504, 1504, 1504};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            String name = ((XmlSystemInfo)xmlSystemInfoList.get(j + 6)).getName();
            String value = ((XmlSystemInfo)xmlSystemInfoList.get(j + 6)).getValue();
            s.add(name);
            s.add(value);
            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
            }

            ++index;
         }
      }

      if (osPatchesList.size() > 0) {
         int count = osPatchesList.size() + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.1.6.OS Patches", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 1);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{10, 50, 50, 50, 50, 50};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 1; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Name");
            } else {
               String name = ((OSPatches)osPatchesList.get(j - 1)).getName();
               s.add(name);
            }

            row = table.getRow(index);

            for(int i = 0; i < 1; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }
      }

      if (xmlSystemInfoList.size() > 0) {
         int count = 2;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.1.7.Network", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 1);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{10, 50, 50, 50, 50, 50};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 1; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Network");
            } else {
               s.add("No Data");
            }

            row = table.getRow(index);

            for(int i = 0; i < 1; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }
      }

      if (xmlSystemInfoList.size() > 0) {
         int count = 2;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.1.8.Core File Pattern", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 1);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{1504, 1504, 1504, 1504, 1504, 1504};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 1; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Core File");
            } else {
               String value = ((XmlSystemInfo)xmlSystemInfoList.get(j + 19)).getValue();
               s.add(value);
            }

            row = table.getRow(index);

            for(int i = 0; i < 1; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
               } else {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
               }
            }

            ++index;
         }
      }

      if (userLimitList.size() > 0) {
         int count = userLimitList.size() + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.1.9.User Limit", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 3);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{10, 50, 50, 50, 50, 50};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 3; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Name");
               s.add("Soft");
               s.add("Hard");
            } else {
               String Name = ((UserLimit)userLimitList.get(j - 1)).getName();
               String Soft = ((UserLimit)userLimitList.get(j - 1)).getSoft();
               String Hard = ((UserLimit)userLimitList.get(j - 1)).getHard();
               s.add(Name);
               s.add(Soft);
               s.add(Hard);
            }

            row = table.getRow(index);

            for(int i = 0; i < 3; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }

         setTableGridCol(table, COLUMN_WIDTHS);
      }

      if (xmlSystemInfoList.size() > 0) {
         int count = 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.1.10.Debugger Information", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{1504, 1504, 1504, 1504, 1504, 1504};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            String name = ((XmlSystemInfo)xmlSystemInfoList.get(j + 21)).getName();
            name = "Debugger";
            String value = ((XmlSystemInfo)xmlSystemInfoList.get(j + 21)).getValue();
            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (i == 0) {
                  setParagraphRunFontInfo(p, pRun, name, "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
               } else {
                  setParagraphRunFontInfo(p, pRun, value, "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
               }
            }

            ++index;
         }
      }

      if (environmentVariableList.size() > 0) {
         int count = environmentVariableList.size() + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.1.11.Environment Variables", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{10, 50, 50, 50, 50, 50};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Name");
               s.add("Value");
            } else {
               String Name = ((EnvironmentVariable)environmentVariableList.get(j - 1)).getName();
               String Value = ((EnvironmentVariable)environmentVariableList.get(j - 1)).getValue();
               s.add(Name);
               s.add(Value);
            }

            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               String string = getStringByEnter(50, (String)s.get(i));
               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, string, "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, string, "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }

         setTableGridCol(table, COLUMN_WIDTHS);
      }

      if (environmentVariableList.size() > 0) {
         String pathValue = "";

         for(EnvironmentVariable environmentVariable : environmentVariableList) {
            if ("PATH".equals(environmentVariable.getName())) {
               pathValue = environmentVariable.getValue();
            }
         }

         String[] split = pathValue.split(":");
         int count = split.length + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.1.12.Path", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 1);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{10, 50, 50, 50, 50, 50};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 1; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Value");
            } else {
               String Value = split[j - 1];
               s.add(Value);
            }

            row = table.getRow(index);

            for(int i = 0; i < 1; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }

         setTableGridCol(table, COLUMN_WIDTHS);
      }

      if (environmentVariableList.size() > 0) {
         String pathValue = "";

         for(EnvironmentVariable environmentVariable : environmentVariableList) {
            if ("LD_LIBRARY_PATH".equals(environmentVariable.getName())) {
               pathValue = environmentVariable.getValue();
            }
         }

         String[] split = pathValue.split(":");
         int count = split.length + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.1.13.Library Path", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 1);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{10, 50, 50, 50, 50, 50};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 1; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Value");
            } else {
               String Value = split[j - 1];
               s.add(Value);
            }

            row = table.getRow(index);

            for(int i = 0; i < 1; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }

         setTableGridCol(table, COLUMN_WIDTHS);
      }

      if (xmlProductInfoList.size() > 0) {
         int count = xmlProductInfoList.size() + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 2", 2);
         p.setStyle("标题 2");
         setParagraphRunFontInfo(p, pRun, "1.2.Informatica检查", "宋体", "Times New Roman", "30", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.2.1.General Information", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{1504, 1504, 1504, 1504, 1504, 1504};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Name");
               s.add("Value");
            } else {
               String Name = ((XmlProductInfo)xmlProductInfoList.get(j - 1)).getName();
               String Value = ((XmlProductInfo)xmlProductInfoList.get(j - 1)).getValue();
               s.add(Name);
               s.add(Value);
            }

            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }
      }

      if (tomcatVariableList.size() > 0) {
         int count = tomcatVariableList.size() + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.2.2\tTomcat Startup Environment variables", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{1504, 1504, 1504, 1504, 1504, 1504};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Name");
               s.add("Value");
            } else {
               String Name = ((TomcatVariable)tomcatVariableList.get(j - 1)).getName();
               String Value = ((TomcatVariable)tomcatVariableList.get(j - 1)).getValue();
               s.add(Name);
               s.add(Value);
            }

            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               String string = getStringByEnter(50, (String)s.get(i));
               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, string, "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, string, "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }
      }

      if (dmainsInfaList.size() > 0) {
         int count = dmainsInfaList.size() + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.2.3.Domain Information", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{1504, 1504, 1504, 1504, 1504, 1504};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Name");
               s.add("Value");
            } else {
               String Name = ((DmainsInfa)dmainsInfaList.get(j - 1)).getName();
               String Value = ((DmainsInfa)dmainsInfaList.get(j - 1)).getValue();
               s.add(Name);
               s.add(Value);
            }

            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }
      }

      if (nodeMetaDataList.size() > 0) {
         int count = nodeMetaDataList.size() + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.2.4.NodeMetaData", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{1504, 1504, 1504, 1504, 1504, 1504};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Name");
               s.add("Value");
            } else {
               String Name = ((NodeMetaData)nodeMetaDataList.get(j - 1)).getName();
               String Value = ((NodeMetaData)nodeMetaDataList.get(j - 1)).getValue();
               s.add(Name);
               s.add(Value);
            }

            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }
      }

      if (domainOptionsList.size() > 0) {
         int count = domainOptionsList.size() + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.2.5.DomainOptions", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{1504, 1504, 1504, 1504, 1504, 1504};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Name");
               s.add("Value");
            } else {
               String Name = ((DomainOptions)domainOptionsList.get(j - 1)).getName();
               String Value = ((DomainOptions)domainOptionsList.get(j - 1)).getValue();
               s.add(Name);
               s.add(Value);
            }

            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }
      }

      if (nodeOptionsList.size() > 0) {
         int count = nodeOptionsList.size() + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.2.6.NodeOptions", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{1504, 1504, 1504, 1504, 1504, 1504};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Name");
               s.add("Value");
            } else {
               String Name = ((NodeOptions)nodeOptionsList.get(j - 1)).getName();
               String Value = ((NodeOptions)nodeOptionsList.get(j - 1)).getValue();
               s.add(Name);
               s.add(Value);
            }

            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }
      }

      if (gridInfoList.size() > 0) {
         int count = gridInfoList.size() + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.2.7.Grid信息", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{1504, 1504, 1504, 1504, 1504, 1504};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Name");
               s.add("Value");
            } else {
               String Name = ((GridInfo)gridInfoList.get(j - 1)).getName();
               String Value = ((GridInfo)gridInfoList.get(j - 1)).getValue();
               s.add(Name);
               s.add(Value);
            }

            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }
      }

      if (monitoringList.size() > 0) {
         int count = monitoringList.size() + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.2.8.Monitoring", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{1504, 1504, 1504, 1504, 1504, 1504};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Name");
               s.add("Value");
            } else {
               String Name = ((Monitoring)monitoringList.get(j - 1)).getName();
               String Value = ((Monitoring)monitoringList.get(j - 1)).getValue();
               s.add(Name);
               s.add(Value);
            }

            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }
      }

      if (powerCenterIntegrationServiceList.size() > 0) {
         int count = powerCenterIntegrationServiceList.size() + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         String servicename = "";

         for(ServiceType serviceType : serviceTypeList) {
            String value = serviceType.getValue();
            if ("PowerCenterIntegrationService".equals(value)) {
               servicename = serviceType.getName();
            }
         }

         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.2.9." + servicename + " (PowerCenterIntegrationService)", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{10, 50, 50, 50, 50, 50};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         row = table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Name");
               s.add("Value");
            } else {
               String name = ((PowerCenterIntegrationService)powerCenterIntegrationServiceList.get(j - 1)).getName();
               String value = ((PowerCenterIntegrationService)powerCenterIntegrationServiceList.get(j - 1)).getValue();
               s.add(name);
               s.add(value);
            }

            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
         }

         setTableGridCol(table, COLUMN_WIDTHS);
      }

      if (powerCenterRepositoryServiceList.size() > 0) {
         int count = powerCenterRepositoryServiceList.size() + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         String servicename = "";

         for(ServiceType serviceType : serviceTypeList) {
            String value = serviceType.getValue();
            if ("PowerCenterRepositoryService".equals(value)) {
               servicename = serviceType.getName();
            }
         }

         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.2.10.\t" + servicename + " (PowerCenterRepositoryService)", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{10, 50, 50, 50, 50, 50};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         row = table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Name");
               s.add("Value");
            } else {
               String name = ((PowerCenterRepositoryService)powerCenterRepositoryServiceList.get(j - 1)).getName();
               String value = ((PowerCenterRepositoryService)powerCenterRepositoryServiceList.get(j - 1)).getValue();
               s.add(name);
               s.add(value);
            }

            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
         }

         setTableGridCol(table, COLUMN_WIDTHS);
      }

      if (wSHubServiceList.size() > 0) {
         int count = wSHubServiceList.size() + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         String servicename = "";

         for(ServiceType serviceType : serviceTypeList) {
            String value = serviceType.getValue();
            if ("WSHubService".equals(value)) {
               servicename = serviceType.getName();
            }
         }

         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.2.11.\t" + servicename + " (WSHubService)", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{10, 50, 50, 50, 50, 50};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         row = table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Name");
               s.add("Value");
            } else {
               String name = ((WSHubService)wSHubServiceList.get(j - 1)).getName();
               String value = ((WSHubService)wSHubServiceList.get(j - 1)).getValue();
               s.add(name);
               s.add(value);
            }

            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
         }

         setTableGridCol(table, COLUMN_WIDTHS);
      }

      if (connectivityOracleList.size() > 0) {
         int count = connectivityOracleList.size();
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.2.12.\tConnectivity", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{1504, 1504, 1504, 1504, 1504, 1504};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            String name = ((ConnectivityOracle)connectivityOracleList.get(j)).getName();
            String value = ((ConnectivityOracle)connectivityOracleList.get(j)).getValue();
            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               if (i == 0) {
                  setParagraphRunFontInfo(p, pRun, name, "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
               } else {
                  setParagraphRunFontInfo(p, pRun, value, "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
               }
            }

            ++index;
         }
      }

      if (pwxConnectivityList.size() > 0) {
         int count = pwxConnectivityList.size() + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.2.13.\tPWX Connectivity", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{10, 50, 50, 50, 50, 50};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);

         for(int i = 0; i < 2; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setParagraphRunFontInfo(p, pRun, "", "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 0);
         }

         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Name");
               s.add("Value");
            } else {
               String name = ((PwxConnectivity)pwxConnectivityList.get(j - 1)).getName();
               String value = ((PwxConnectivity)pwxConnectivityList.get(j - 1)).getValue();
               s.add(name);
               s.add(value);
            }

            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               String string = getStringByEnter(50, (String)s.get(i));
               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, string, "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, string, "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }
      }

      if (logEventList.size() > 0) {
         int count = logEventList.size() + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.2.14.\tLastDayErrorLogs", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 5);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{10, 50, 50, 50, 50, 50};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("Stacktrace");
               s.add("Service");
               s.add("MessageCode");
               s.add("Message");
               s.add("Timestamp");
            } else {
               String Stacktrace = ((logEvent)logEventList.get(j - 1)).getStacktrace();
               String Service = ((logEvent)logEventList.get(j - 1)).getService();
               String MessageCode = ((logEvent)logEventList.get(j - 1)).getMessageCode();
               String Message = ((logEvent)logEventList.get(j - 1)).getMessage();
               String Timestamp = ((logEvent)logEventList.get(j - 1)).getTimestamp();
               s.add(Stacktrace);
               s.add(Service);
               s.add(MessageCode);
               s.add(Message);
               s.add(Timestamp);
            }

            row = table.getRow(index);

            for(int i = 0; i < 5; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               setTableGridCol(table, COLUMN_WIDTHS);
               String string = "";
               if (i == 0) {
                  string = getStringByEnter(60, ((String)s.get(i)).trim());
               } else if (i == 2) {
                  string = getStringByEnter(6, ((String)s.get(i)).trim());
               } else if (i == 3) {
                  string = getStringByEnter(25, ((String)s.get(i)).trim());
               } else {
                  string = getStringByEnter(6, ((String)s.get(i)).trim());
               }

               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, string, "宋体", "Times New Roman", "21", true, false, false, true, "FF0000", (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, string, "宋体", "Times New Roman", "18", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }
      }

      if (invalidMappinglist != null && invalidMappinglist.size() > 0) {
         int count = invalidMappinglist.size() + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 2", 2);
         p.setStyle("标题 2");
         setParagraphRunFontInfo(p, pRun, "1.3. Mapping", "宋体", "Times New Roman", "30", true, false, false, false, (String)null, (STShd.Enum)null, 0, 6, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.3.1.\tInvalidMapping", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 3);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{10, 50, 50, 50, 50, 50};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("SUBJECT_AREA");
               s.add("PARENT_MAPPING_NAME");
               s.add("PARENT_MAPPING_IS_VALID");
            } else {
               String Subject_area = ((InvalidMapping)invalidMappinglist.get(j - 1)).getSubject_area();
               String Parent_mapping_name = ((InvalidMapping)invalidMappinglist.get(j - 1)).getParent_mapping_name();
               String Parent_mapping_is_valid = ((InvalidMapping)invalidMappinglist.get(j - 1)).getParent_mapping_is_valid();
               s.add(Subject_area);
               s.add(Parent_mapping_name);
               s.add(Parent_mapping_is_valid);
            }

            row = table.getRow(index);

            for(int i = 0; i < 3; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               setTableGridCol(table, COLUMN_WIDTHS);
               String string = "";
               if (i == 1) {
                  string = getStringByEnter(50, ((String)s.get(i)).trim());
               } else {
                  string = getStringByEnter(17, ((String)s.get(i)).trim());
               }

               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, string, "宋体", "Times New Roman", "21", true, false, false, true, "FF0000", (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, string, "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }
      }

      if (failureMappinglist != null && failureMappinglist.size() > 0) {
         int count = failureMappinglist.size() + 1;
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.3.2.\tFailureMapping", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 6);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{10, 50, 50, 50, 50, 50};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            if (j == 0) {
               s.add("SUBJECT_AREA");
               s.add("WORKFLOW_NAME");
               s.add("SESSION_NAME");
               s.add("FIRST_ERROR_CODE");
               s.add("FAILED_ROWS");
               s.add("FIRST_ERROR_MSG");
            } else {
               String Subject_area = ((FailureMapping)failureMappinglist.get(j - 1)).getSubject_area();
               String Workflow_name = ((FailureMapping)failureMappinglist.get(j - 1)).getWorkflow_name();
               String Session_name = ((FailureMapping)failureMappinglist.get(j - 1)).getSession_name();
               String First_error_code = ((FailureMapping)failureMappinglist.get(j - 1)).getFirst_error_code();
               String Failed_rows = ((FailureMapping)failureMappinglist.get(j - 1)).getFailed_rows();
               String First_error_msg = ((FailureMapping)failureMappinglist.get(j - 1)).getFirst_error_msg();
               s.add(Subject_area);
               s.add(Workflow_name);
               s.add(Session_name);
               s.add(First_error_code);
               s.add(Failed_rows);
               s.add(First_error_msg);
            }

            row = table.getRow(index);

            for(int i = 0; i < 6; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               setTableGridCol(table, COLUMN_WIDTHS);
               String string = "";
               if (i == 5) {
                  string = getStringByEnter(35, ((String)s.get(i)).trim());
               } else {
                  string = getStringByEnter(6, ((String)s.get(i)).trim());
               }

               if (j == 0) {
                  setParagraphRunFontInfo(p, pRun, string, "宋体", "Times New Roman", "21", true, false, false, true, "FF0000", (STShd.Enum)null, -1, -1, -1);
               } else {
                  setParagraphRunFontInfo(p, pRun, string, "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
               }
            }

            ++index;
         }
      }

      if (sqlResultslist != null && sqlResultslist.size() > 0) {
         int count = sqlResultslist.size();
         XWPFParagraph p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
         setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
         XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
         addCustomHeadingStyle(xdoc, "标题 3", 3);
         p.setStyle("标题 3");
         setParagraphRunFontInfo(p, pRun, "1.3.3.Session日志表的大小", "宋体", "Times New Roman", "25", true, false, false, false, (String)null, (STShd.Enum)null, 0, 0, 90);
         p = xdoc.createParagraph();
         setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
         setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 2);
         setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
         setTableWidthAndHAlign(table, "9024", STJc.CENTER);
         setTableCellMargin(table, 0, 108, 0, 108);
         int[] COLUMN_WIDTHS = new int[]{10, 50, 50, 50, 50, 50};
         setTableGridCol(table, COLUMN_WIDTHS);
         XWPFTableRow row = table.getRow(0);
         XWPFTableCell cell = row.getCell(0);
         setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
         p = getCellFirstParagraph(cell);
         pRun = getOrAddParagraphFirstRun(p, false, false);
         int index = 0;
         table.getRow(index);

         for(int j = 0; j < count; ++j) {
            List<String> s = new ArrayList();
            String name = ((SqlResults)sqlResultslist.get(j)).getName();
            String value = ((SqlResults)sqlResultslist.get(j)).getValue();
            s.add(name);
            s.add(value);
            row = table.getRow(index);

            for(int i = 0; i < 2; ++i) {
               cell = row.getCell(i);
               setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
               p = getCellFirstParagraph(cell);
               pRun = getOrAddParagraphFirstRun(p, false, false);
               setParagraphRunFontInfo(p, pRun, (String)s.get(i), "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
            }

            ++index;
         }
      }

      List<TableInfo> tableInfoList = new ArrayList();
      TableInfo tableInfo = new TableInfo();
      tableInfo.setId("1");
      tableInfo.setName("OPB_SESS_TASK_LOG");
      tableInfo.setSql("delete from  OPB_SESS_TASK_LOG a where a.workflow_run_id in (select b.workflow_run_id from   OPB_WFLOW_RUN b where b.start_time between to_date('20200610','yyyymmdd') and to_date('20200620','yyyymmdd'))");
      tableInfoList.add(tableInfo);
      tableInfo = new TableInfo();
      tableInfo.setId("2");
      tableInfo.setName("OPB_TASK_INST_RUN");
      tableInfo.setSql("delete from OPB_TASK_INST_RUN where start_time between to_date('填写日期','yyyymmdd') and to_date('','yyyymmdd')");
      tableInfoList.add(tableInfo);
      tableInfo = new TableInfo();
      tableInfo.setId("3");
      tableInfo.setName("OPB_WFLOW_RUN");
      tableInfo.setSql("delete from  OPB_WFLOW_RUN where start_time between to_date('填写日期','yyyymmdd') and to_date('','yyyymmdd')");
      tableInfoList.add(tableInfo);
      tableInfo = new TableInfo();
      tableInfo.setId("4");
      tableInfo.setName("OPB_SWIDGINST_LOG");
      tableInfo.setSql("Delete fom OPB_SWIDGINST_LOG where start_time between to_date('填写日期','yyyymmdd') and to_date('','yyyymmdd')");
      tableInfoList.add(tableInfo);
      int count = 5;
      XWPFParagraph p = xdoc.createParagraph();
      setParagraphSpacingInfo(p, true, "0", "80", (String)null, (String)null, true, "500", STLineSpacingRule.EXACT);
      setParagraphAlignInfo(p, ParagraphAlignment.CENTER, ParagraphAlignment.CENTER);
      XWPFRun pRun = getOrAddParagraphFirstRun(p, false, false);
      setParagraphRunFontInfo(p, pRun, "运行如下语句，请在服务人员协助下进行。", "宋体", "Times New Roman", "25", true, false, false, true, "FF0000", (STShd.Enum)null, 0, 0, 90);
      p = xdoc.createParagraph();
      setParagraphSpacingInfo(p, true, "0", "0", "0", "0", true, "240", STLineSpacingRule.AUTO);
      setParagraphAlignInfo(p, ParagraphAlignment.LEFT, ParagraphAlignment.CENTER);
      pRun = getOrAddParagraphFirstRun(p, false, false);
      XWPFTable table = xdoc.createTable(count == 1 ? 1 : count, 3);
      setTableBorders(table, STBorder.SINGLE, "4", "auto", "0");
      setTableWidthAndHAlign(table, "9024", STJc.CENTER);
      setTableCellMargin(table, 0, 108, 0, 108);
      int[] COLUMN_WIDTHS = new int[]{1504, 1504, 1504, 1504, 1504, 1504};
      XWPFTableRow row = table.getRow(0);
      XWPFTableCell cell = row.getCell(0);
      setCellShdStyle(cell, true, "FFFFFF", (STShd.Enum)null);
      p = getCellFirstParagraph(cell);
      pRun = getOrAddParagraphFirstRun(p, false, false);
      int index = 0;
      table.getRow(index);

      for(int j = 0; j < count; ++j) {
         List<String> s = new ArrayList();
         if (j == 0) {
            s.add("序号");
            s.add("表");
            s.add("删除语句");
         } else {
            String id = ((TableInfo)tableInfoList.get(j - 1)).getId();
            String name = ((TableInfo)tableInfoList.get(j - 1)).getName();
            String sql = ((TableInfo)tableInfoList.get(j - 1)).getSql();
            s.add(id);
            s.add(name);
            s.add(sql);
         }

         row = table.getRow(index);

         for(int i = 0; i < 3; ++i) {
            cell = row.getCell(i);
            setCellWidthAndVAlign(cell, String.valueOf(COLUMN_WIDTHS[0]), STTblWidth.DXA, STVerticalJc.TOP);
            p = getCellFirstParagraph(cell);
            pRun = getOrAddParagraphFirstRun(p, false, false);
            setTableGridCol(table, COLUMN_WIDTHS);
            String string = "";
            if (i == 2) {
               string = getStringByEnter(100, ((String)s.get(i)).trim());
            } else if (i == 0) {
               string = getStringByEnter(6, ((String)s.get(i)).trim());
            } else {
               string = getStringByEnter(20, ((String)s.get(i)).trim());
            }

            if (j == 0) {
               setParagraphRunFontInfo(p, pRun, string, "宋体", "Times New Roman", "21", true, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
            } else {
               setParagraphRunFontInfo(p, pRun, string, "宋体", "Times New Roman", "21", false, false, false, false, (String)null, (STShd.Enum)null, -1, -1, -1);
            }
         }

         ++index;
      }

      System.out.println("word_create_success");
   }

   public static void setTableBorders(XWPFTable table, STBorder.Enum borderType, String size, String color, String space) {
      CTTblPr tblPr = getTableCTTblPr(table);
      CTTblBorders borders = tblPr.isSetTblBorders() ? tblPr.getTblBorders() : tblPr.addNewTblBorders();
      CTBorder hBorder = borders.isSetInsideH() ? borders.getInsideH() : borders.addNewInsideH();
      hBorder.setVal(borderType);
      hBorder.setSz(new BigInteger(size));
      hBorder.setColor(color);
      hBorder.setSpace(new BigInteger(space));
      CTBorder vBorder = borders.isSetInsideV() ? borders.getInsideV() : borders.addNewInsideV();
      vBorder.setVal(borderType);
      vBorder.setSz(new BigInteger(size));
      vBorder.setColor(color);
      vBorder.setSpace(new BigInteger(space));
      CTBorder lBorder = borders.isSetLeft() ? borders.getLeft() : borders.addNewLeft();
      lBorder.setVal(borderType);
      lBorder.setSz(new BigInteger(size));
      lBorder.setColor(color);
      lBorder.setSpace(new BigInteger(space));
      CTBorder rBorder = borders.isSetRight() ? borders.getRight() : borders.addNewRight();
      rBorder.setVal(borderType);
      rBorder.setSz(new BigInteger(size));
      rBorder.setColor(color);
      rBorder.setSpace(new BigInteger(space));
      CTBorder tBorder = borders.isSetTop() ? borders.getTop() : borders.addNewTop();
      tBorder.setVal(borderType);
      tBorder.setSz(new BigInteger(size));
      tBorder.setColor(color);
      tBorder.setSpace(new BigInteger(space));
      CTBorder bBorder = borders.isSetBottom() ? borders.getBottom() : borders.addNewBottom();
      bBorder.setVal(borderType);
      bBorder.setSz(new BigInteger(size));
      bBorder.setColor(color);
      bBorder.setSpace(new BigInteger(space));
   }

   public static CTTblPr getTableCTTblPr(XWPFTable table) {
      CTTbl ttbl = table.getCTTbl();
      CTTblPr tblPr = ttbl.getTblPr() == null ? ttbl.addNewTblPr() : ttbl.getTblPr();
      return tblPr;
   }

   public static void setTableWidthAndHAlign(XWPFTable table, String width, STJc.Enum enumValue) {
      CTTblPr tblPr = getTableCTTblPr(table);
      CTTblWidth tblWidth = tblPr.isSetTblW() ? tblPr.getTblW() : tblPr.addNewTblW();
      if (enumValue != null) {
         CTJc cTJc = tblPr.addNewJc();
         cTJc.setVal(enumValue);
      }

      tblWidth.setW(new BigInteger(width));
      tblWidth.setType(STTblWidth.DXA);
   }

   public static void setTableCellMargin(XWPFTable table, int top, int left, int bottom, int right) {
      table.setCellMargins(top, left, bottom, right);
   }

   public static void setTableGridCol(XWPFTable table, int[] colWidths) {
      CTTbl ttbl = table.getCTTbl();
      CTTblGrid tblGrid = ttbl.getTblGrid() != null ? ttbl.getTblGrid() : ttbl.addNewTblGrid();
      int j = 0;

      for(int len = colWidths.length; j < len; ++j) {
         CTTblGridCol gridCol = tblGrid.addNewGridCol();
         gridCol.setW(new BigInteger(String.valueOf(colWidths[j])));
      }

   }

   public static void setRowHeight(XWPFTableRow row, String hight, STHeightRule.Enum heigthEnum) {
      CTTrPr trPr = getRowCTTrPr(row);
      CTHeight trHeight = trPr.addNewTrHeight();
      trHeight.setVal(new BigInteger(hight));
      if (heigthEnum != null) {
         trHeight.setHRule(heigthEnum);
      }

   }

   public static void setCellShdStyle(XWPFTableCell cell, boolean isShd, String shdColor, STShd.Enum shdStyle) {
      CTTcPr tcPr = getCellCTTcPr(cell);
      if (isShd) {
         CTShd shd = tcPr.isSetShd() ? tcPr.getShd() : tcPr.addNewShd();
         if (shdStyle != null) {
            shd.setVal(shdStyle);
         }

         if (shdColor != null) {
            shd.setColor(shdColor);
            shd.setFill(shdColor);
         }
      }

   }

   public static CTTrPr getRowCTTrPr(XWPFTableRow row) {
      CTRow ctRow = row.getCtRow();
      CTTrPr trPr = ctRow.isSetTrPr() ? ctRow.getTrPr() : ctRow.addNewTrPr();
      return trPr;
   }

   public static CTTcPr getCellCTTcPr(XWPFTableCell cell) {
      CTTc cttc = cell.getCTTc();
      CTTcPr tcPr = cttc.isSetTcPr() ? cttc.getTcPr() : cttc.addNewTcPr();
      return tcPr;
   }

   public static void setParagraphSpacingInfo(XWPFParagraph p, boolean isSpace, String before, String after, String beforeLines, String afterLines, boolean isLine, String line, STLineSpacingRule.Enum lineValue) {
      CTPPr pPPr = getParagraphCTPPr(p);
      CTSpacing pSpacing = pPPr.getSpacing() != null ? pPPr.getSpacing() : pPPr.addNewSpacing();
      if (isSpace) {
         if (before != null) {
            pSpacing.setBefore(new BigInteger(before));
         }

         if (after != null) {
            pSpacing.setAfter(new BigInteger(after));
         }

         if (beforeLines != null) {
            pSpacing.setBeforeLines(new BigInteger(beforeLines));
         }

         if (afterLines != null) {
            pSpacing.setAfterLines(new BigInteger(afterLines));
         }
      }

      if (isLine) {
         if (line != null) {
            pSpacing.setLine(new BigInteger(line));
         }

         if (lineValue != null) {
            pSpacing.setLineRule(lineValue);
         }
      }

   }

   public static CTPPr getParagraphCTPPr(XWPFParagraph p) {
      CTPPr pPPr = null;
      if (p.getCTP() != null) {
         if (p.getCTP().getPPr() != null) {
            pPPr = p.getCTP().getPPr();
         } else {
            pPPr = p.getCTP().addNewPPr();
         }
      }

      return pPPr;
   }

   public static void setParagraphAlignInfo(XWPFParagraph p, ParagraphAlignment pAlign, ParagraphAlignment valign) {
      if (pAlign != null) {
         p.setAlignment(pAlign);
      }

      if (valign != null) {
         p.setAlignment(valign);
      }

   }

   public static XWPFRun getOrAddParagraphFirstRun(XWPFParagraph p, boolean isInsert, boolean isNewLine) {
      XWPFRun pRun = null;
      if (isInsert) {
         pRun = p.createRun();
      } else if (p.getRuns() != null && p.getRuns().size() > 0) {
         pRun = (XWPFRun)p.getRuns().get(0);
      } else {
         pRun = p.createRun();
      }

      if (isNewLine) {
         pRun.addBreak();
      }

      return pRun;
   }

   public static XWPFParagraph getCellFirstParagraph(XWPFTableCell cell) {
      XWPFParagraph p;
      if (cell.getParagraphs() != null && cell.getParagraphs().size() > 0) {
         p = (XWPFParagraph)cell.getParagraphs().get(0);
      } else {
         p = cell.addParagraph();
      }

      return p;
   }

   public static void setCellWidthAndVAlign(XWPFTableCell cell, String width, STTblWidth.Enum typeEnum, STVerticalJc.Enum vAlign) {
      CTTcPr tcPr = getCellCTTcPr(cell);
      CTTblWidth tcw = tcPr.isSetTcW() ? tcPr.getTcW() : tcPr.addNewTcW();
      if (width != null) {
         tcw.setW(new BigInteger(width));
      }

      if (typeEnum != null) {
         tcw.setType(typeEnum);
      }

      if (vAlign != null) {
         CTVerticalJc vJc = tcPr.isSetVAlign() ? tcPr.getVAlign() : tcPr.addNewVAlign();
         vJc.setVal(vAlign);
      }

   }

   public static void setParagraphRunFontInfo(XWPFParagraph p, XWPFRun pRun, String content, String cnFontFamily, String enFontFamily, String fontSize, boolean isBlod, boolean isItalic, boolean isStrike, boolean isShd, String shdColor, STShd.Enum shdStyle, int position, int spacingValue, int indent) {
      CTRPr pRpr = getRunCTRPr(p, pRun);
      if (StringUtils.isNotBlank(content)) {
         if (content.contains("\n")) {
            String[] lines = content.split("\n");
            pRun.setText(lines[0], 0);

            for(int i = 1; i < lines.length; ++i) {
               pRun.addBreak();
               pRun.setText(lines[i]);
            }
         } else {
            pRun.setText(content, 0);
         }
      }

      CTFonts fonts = pRpr.isSetRFonts() ? pRpr.getRFonts() : pRpr.addNewRFonts();
      if (StringUtils.isNotBlank(enFontFamily)) {
         fonts.setAscii(enFontFamily);
         fonts.setHAnsi(enFontFamily);
      }

      if (StringUtils.isNotBlank(cnFontFamily)) {
         fonts.setEastAsia(cnFontFamily);
         fonts.setHint(STHint.EAST_ASIA);
      }

      CTHpsMeasure sz = pRpr.isSetSz() ? pRpr.getSz() : pRpr.addNewSz();
      sz.setVal(new BigInteger(fontSize));
      CTHpsMeasure szCs = pRpr.isSetSzCs() ? pRpr.getSzCs() : pRpr.addNewSzCs();
      szCs.setVal(new BigInteger(fontSize));
      if (isBlod) {
         pRun.setBold(isBlod);
      }

      if (isItalic) {
         pRun.setItalic(isItalic);
      }

      if (isStrike) {
         pRun.setStrike(isStrike);
      }

      if (isShd) {
         CTShd shd = pRpr.isSetShd() ? pRpr.getShd() : pRpr.addNewShd();
         if (shdStyle != null) {
            shd.setVal(shdStyle);
         }

         if (shdColor != null) {
            shd.setColor(shdColor);
            shd.setFill(shdColor);
         }
      }

      if (position != 0) {
         pRun.setTextPosition(position);
      }

      if (spacingValue > 0) {
         CTSignedTwipsMeasure ctSTwipsMeasure = pRpr.isSetSpacing() ? pRpr.getSpacing() : pRpr.addNewSpacing();
         ctSTwipsMeasure.setVal(new BigInteger(String.valueOf(spacingValue)));
      }

      if (indent > 0) {
         CTTextScale paramCTTextScale = pRpr.isSetW() ? pRpr.getW() : pRpr.addNewW();
         paramCTTextScale.setVal(indent);
      }

      p.setAlignment(ParagraphAlignment.LEFT);
   }

   public void mergeCellsHorizontal(XWPFTable table, int row, int fromCell, int toCell) {
      for(int cellIndex = fromCell; cellIndex <= toCell; ++cellIndex) {
         XWPFTableCell cell = table.getRow(row).getCell(cellIndex);
         if (cellIndex == fromCell) {
            getCellCTTcPr(cell).addNewHMerge().setVal(STMerge.RESTART);
         } else {
            getCellCTTcPr(cell).addNewHMerge().setVal(STMerge.CONTINUE);
         }
      }

   }

   public static CTRPr getRunCTRPr(XWPFParagraph p, XWPFRun pRun) {
      CTRPr pRpr = null;
      if (pRun.getCTR() != null) {
         pRpr = pRun.getCTR().getRPr();
         if (pRpr == null) {
            pRpr = pRun.getCTR().addNewRPr();
         }
      } else {
         pRpr = p.getCTP().addNewR().addNewRPr();
      }

      return pRpr;
   }

   public static void saveDocument(XWPFDocument document, String savePath) throws Exception {
      File testFile = new File(savePath);
      if (!testFile.exists()) {
         testFile.createNewFile();
      }

      FileOutputStream fos = new FileOutputStream(savePath);
      document.write(fos);
      fos.close();
   }

   private static Map<String, List> OracleConnect(String url, String passwd, String user, String startdate, String enddate) throws ClassNotFoundException, SQLException {
      String driver = "oracle.jdbc.driver.OracleDriver";
      Class.forName(driver);
      Connection conn = DriverManager.getConnection(url, user, passwd);
      PreparedStatement ps = null;
      PreparedStatement pss = null;
      PreparedStatement psss = null;
      PreparedStatement pssss = null;
      PreparedStatement psssss = null;
      PreparedStatement pssssss = null;
      ResultSet rs = null;
      ResultSet rss = null;
      ResultSet rsss = null;
      ResultSet rssss = null;
      ResultSet rsssss = null;
      ResultSet rssssss = null;
      String invalidmappingcount = "SELECT  SUBJECT_AREA, PARENT_MAPPING_NAME,parent_mapping_is_valid FROM REP_ALL_MAPPINGS where parent_mapping_is_valid=0";
      String failurecount = "select subject_area,workflow_name,session_name, first_error_code,failed_rows,a.first_error_msg from rep_sess_log a where failed_rows<>0 or first_error_code<>0 and actual_start between to_date('" + startdate + "','yyyymmdd') and to_date('" + enddate + "','yyyymmdd')";
      String opb_task_inst_run = "select count(*) from OPB_TASK_INST_RUN";
      String opb_sess_task_log = "select count(*) from OPB_SESS_TASK_LOG";
      String opb_wflow_run = "select count(*) from OPB_WFLOW_RUN";
      String opb_swidginst_log = "select count(*) from OPB_SWIDGINST_LOG";
      psss = conn.prepareStatement(opb_task_inst_run);
      pssss = conn.prepareStatement(opb_sess_task_log);
      psssss = conn.prepareStatement(opb_wflow_run);
      pssssss = conn.prepareStatement(opb_swidginst_log);
      rsss = psss.executeQuery();
      rssss = pssss.executeQuery();
      rsssss = psssss.executeQuery();
      rssssss = pssssss.executeQuery();
      ps = conn.prepareStatement(invalidmappingcount);
      pss = conn.prepareStatement(failurecount);
      rs = ps.executeQuery();
      rss = pss.executeQuery();
      List<InvalidMapping> invalidMappinglist = new ArrayList();
      List<FailureMapping> failureMappinglist = new ArrayList();
      List<SqlResults> sqlResultslist = new ArrayList();
      Map<String, List> map = new HashMap();

      while(rs.next()) {
         InvalidMapping invalidMapping = new InvalidMapping();
         invalidMapping.setSubject_area(rs.getString("SUBJECT_AREA"));
         invalidMapping.setParent_mapping_name(rs.getString("PARENT_MAPPING_NAME"));
         invalidMapping.setParent_mapping_is_valid(rs.getString("PARENT_MAPPING_IS_VALID"));
         invalidMappinglist.add(invalidMapping);
      }

      map.put("invalidMapping", invalidMappinglist);

      while(rss.next()) {
         FailureMapping failureMapping = new FailureMapping();
         failureMapping.setSubject_area(rss.getString("SUBJECT_AREA"));
         failureMapping.setWorkflow_name(rss.getString("WORKFLOW_NAME"));
         failureMapping.setSession_name(rss.getString("SESSION_NAME"));
         failureMapping.setFirst_error_code(rss.getString("FIRST_ERROR_CODE"));
         failureMapping.setFailed_rows(rss.getString("FAILED_ROWS"));
         failureMapping.setFirst_error_msg(rss.getString("FIRST_ERROR_MSG"));
         failureMappinglist.add(failureMapping);
      }

      map.put("failureMapping", failureMappinglist);
      if (rsss.next()) {
         SqlResults sqlResults = new SqlResults();
         String string = rsss.getString(1);
         sqlResults.setName("OPB_TASK_INST_RUN");
         sqlResults.setValue(string);
         sqlResultslist.add(sqlResults);
      }

      if (rssss.next()) {
         SqlResults sqlResults = new SqlResults();
         String string = rssss.getString(1);
         sqlResults.setName("OPB_SESS_TASK_LOG");
         sqlResults.setValue(string);
         sqlResultslist.add(sqlResults);
      }

      if (rsssss.next()) {
         SqlResults sqlResults = new SqlResults();
         String string = rsssss.getString(1);
         sqlResults.setName("OPB_WFLOW_RUN");
         sqlResults.setValue(string);
         sqlResultslist.add(sqlResults);
      }

      if (rssssss.next()) {
         SqlResults sqlResults = new SqlResults();
         String string = rssssss.getString(1);
         sqlResults.setName("OPB_SWIDGINST_LOG");
         sqlResults.setValue(string);
         sqlResultslist.add(sqlResults);
      }

      map.put("sqlResultslist", sqlResultslist);
      ps.close();
      pss.close();
      psss.close();
      pssss.close();
      psssss.close();
      pssssss.close();
      conn.close();
      return map;
   }

   private static void addCustomHeadingStyle(XWPFDocument docxDocument, String strStyleId, int headingLevel) {
      CTStyle ctStyle = Factory.newInstance();
      ctStyle.setStyleId(strStyleId);
      CTString styleName = CTString.Factory.newInstance();
      styleName.setVal(strStyleId);
      ctStyle.setName(styleName);
      CTDecimalNumber indentNumber = CTDecimalNumber.Factory.newInstance();
      indentNumber.setVal(BigInteger.valueOf((long)headingLevel));
      ctStyle.setUiPriority(indentNumber);
      CTOnOff onoffnull = CTOnOff.Factory.newInstance();
      ctStyle.setUnhideWhenUsed(onoffnull);
      ctStyle.setQFormat(onoffnull);
      CTPPr ppr = CTPPr.Factory.newInstance();
      ppr.setOutlineLvl(indentNumber);
      ctStyle.setPPr(ppr);
      XWPFStyle style = new XWPFStyle(ctStyle);
      XWPFStyles styles = docxDocument.createStyles();
      style.setType(STStyleType.PARAGRAPH);
      styles.addStyle(style);
   }

   public static String getStringByEnter(int length, String string) throws Exception {
      for(int i = 1; i <= string.length(); ++i) {
         if (string.substring(0, i).getBytes("GBK").length > length) {
            return string.substring(0, i - 1) + "\n" + getStringByEnter(length, string.substring(i - 1));
         }
      }

      return string;
   }
}
