package com.chenyang.nse.bussiness.tools.xml;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.entity.vo.mappletxml.MappletxmlVO;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class PowerXml {
   public static int generatePowerXml(MappletxmlVO mappletxmlVO) {
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String path = props.getProperty("xml_mapplet_file_path");
      path = path + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + ".xml";
      int result = DomUtils.generateXML(path, "xmlmapplet.xml");
      if (result == 0) {
         System.out.println("生成目标XML文件异常");
         return 0;
      } else {
         File file = new File(path);
         SAXReader reader = new SAXReader();
         reader.setEntityResolver(new IgnoreDTDEntityResolver());

         Document doc;
         try {
            doc = reader.read(file);
         } catch (DocumentException e) {
            e.printStackTrace();
            System.out.println("读取xml文件时，转换Document时出错");
            return -1;
         }

         Date currentTime = new Date();
         SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
         String dateString = formatter.format(currentTime);
         String uuid = UUID.randomUUID().toString();
         Map<String, String> editMap = new HashMap();
         editMap.put("POWERMART--CREATION_DATE", dateString);
         editMap.put("POWERMART/REPOSITORY--NAME", "PWC_SVC");
         editMap.put("POWERMART/REPOSITORY/FOLDER--UUID", uuid);
         editMap.put("POWERMART/REPOSITORY/FOLDER--NAME", "cs_mapplet");
         doc = DomUtils.editSpecialElement(doc, editMap);
         MappletXml mappletXml = new MappletXmlImpl();

         try {
            doc = mappletXml.generateMapplet(mappletxmlVO, doc);
         } catch (Exception var15) {
            System.out.println("获取脱敏规则文件时异常");
            return -2;
         }

         try {
            DomUtils.writeXml(doc, path);
            return 1;
         } catch (Exception var14) {
            System.out.println("生成xml写入文件异常");
            return -3;
         }
      }
   }
}
