package com.chenyang.nse.bussiness.tools.xml;

import com.chenyang.nse.bussiness.tools.net.SFTPUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.net.ftp.FTPClient;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ReadAllXmlTool {
   private static String s = "";

   public static void main(String[] args) throws IOException {
      ReadAllXmlTool xml = new ReadAllXmlTool();
      String path = "D:\\lixin\\pom.xml";
      Map<String, List<String>> map = new HashMap();
      xmlToStr(path, map);
      System.out.println("end");
   }

   public static Map<String, List<String>> xmlToStr(String filePath, Map<String, List<String>> map) {
      map.clear();
      String path = filePath;
      Document document = null;

      try {
         document = read(path);
      } catch (MalformedURLException e) {
         e.printStackTrace();
      } catch (DocumentException e) {
         e.printStackTrace();
      }

      Element root = getRootElement(document);
      if (root == null) {
         System.out.print("没有获取到root节点");
         return null;
      } else {
         String encString = document.getXMLEncoding();
         getIterator(root, 0, map);
         return map;
      }
   }

   public static Map<String, List<String>> xmlToStrSFTP(SFTPUtil sftp, String filePath, Map<String, List<String>> map) throws Exception {
      map.clear();
      String path = filePath;
      Document document = null;

      try {
         document = readSFTP(sftp, path);
      } catch (MalformedURLException e) {
         e.printStackTrace();
      } catch (DocumentException e) {
         e.printStackTrace();
      }

      Element root = getRootElement(document);
      if (root == null) {
         System.out.print("没有获取到root节点");
         return null;
      } else {
         String encString = document.getXMLEncoding();
         getIterator(root, 0, map);
         return map;
      }
   }

   public static Map<String, List<String>> xmlToStrFTP(FTPClient ftp, String filePath, Map<String, List<String>> map) throws Exception {
      map.clear();
      String path = filePath;
      Document document = null;

      try {
         document = readFTP(ftp, path);
      } catch (MalformedURLException e) {
         e.printStackTrace();
      } catch (DocumentException e) {
         e.printStackTrace();
      }

      Element root = getRootElement(document);
      if (root == null) {
         System.out.print("没有获取到root节点");
         return map;
      } else {
         String encString = document.getXMLEncoding();
         getIterator(root, 0, map);
         return map;
      }
   }

   private static void getIterator(Element element, int lvl, Map<String, List<String>> map) {
      ++lvl;
      Iterator i = element.elementIterator();

      while(i.hasNext()) {
         Element e = (Element)i.next();
         getIterator(e, lvl, map);
         if (!"".equals(e.getText().trim().replaceAll("\r|\n|\t", ""))) {
            s = e.getText().trim().replaceAll("\r|\n|\t", "");
            if (map.containsKey(e.getName())) {
               ((List)map.get(e.getName())).add(s);
            } else {
               List<String> l = new ArrayList();
               l.add(s);
               map.put(e.getName(), l);
            }
         }
      }

   }

   private static String attText(Element element) {
      String str = " ";

      for(int i = 0; i < element.attributeCount(); ++i) {
         Attribute attribute = element.attribute(i);
         str = str + attribute.getName() + "=\"" + attribute.getValue() + "\" ";
         String var4 = attribute.getText();
      }

      return str;
   }

   private static String elementText(Element element, String text, int lvl) {
      String str = "";

      for(int i = 0; i < lvl; ++i) {
         str = str + "    ";
      }

      str = str + "<" + element.getName();
      if (text != null && text != "") {
         str = str + text;
      }

      int count = element.nodeCount();
      return count == 0 ? str + ">" : str + ">\n";
   }

   public static Document read(String file) throws MalformedURLException, DocumentException {
      SAXReader reader = new SAXReader();
      Document document = reader.read(new File(file));
      return document;
   }

   public static Document readSFTP(SFTPUtil sftp, String file) throws Exception {
      SAXReader reader = new SAXReader();
      InputStream is = sftp.getDataInputStream(file);
      Document document = reader.read(is);
      if (is != null) {
         is.close();
      }

      return document;
   }

   public static Document readFTP(FTPClient ftp, String file) throws Exception {
      SAXReader reader = new SAXReader();
      InputStream is = ftp.retrieveFileStream(file);
      Document document = reader.read(is);
      if (is != null) {
         is.close();
         ftp.completePendingCommand();
      }

      return document;
   }

   public static Element getRootElement(Document document) {
      return document.getRootElement();
   }
}
