package com.chenyang.nse.bussiness.tools.xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class TxtTool {
   public static void exportTxt(String text, String address, String codepage) {
      File file = new File(address);

      try {
         if (!file.exists()) {
            file.createNewFile();
         }

         OutputStreamWriter fw = new OutputStreamWriter(new FileOutputStream(file, true), codepage);
         BufferedWriter bw = new BufferedWriter(fw);
         bw.write(text);
         bw.flush();
         bw.close();
         fw.close();
      } catch (IOException var7) {
      }

   }

   public static String genAttachmentFileName(String cnName, String defaultName) {
      try {
         cnName = new String(cnName.getBytes("gb2312"), "ISO8859-1");
      } catch (Exception var3) {
         cnName = defaultName;
      }

      return cnName;
   }

   public static List<String> importTxt(String address) throws IOException {
      File file = new File(address);
      InputStreamReader read = new InputStreamReader(new FileInputStream(file), "utf-8");
      BufferedReader bufferedReader = new BufferedReader(read);
      String line = "";
      List<String> list = new ArrayList();

      while((line = bufferedReader.readLine()) != null) {
         list.add(line);
      }

      read.close();
      bufferedReader.close();
      System.out.println("target txt file size is " + list.size());
      return list;
   }
}
