package com.chenyang.nse.bussiness.tools.xml;

import com.chenyang.nse.bussiness.tools.DataSourceTools;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.springframework.core.io.ClassPathResource;

public class XmlTool {
   public static void javaToXml(Object obj, String path) {
      try {
         FileWriter writer = new FileWriter(path);
         Marshaller marshaller = new Marshaller(writer);
         marshaller.setEncoding("UTF-8");
         marshaller.marshal(obj);
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public static Object xmlToJava(String path, Class c) {
      Object obj = null;

      try {
         FileReader reader = new FileReader(path);
         obj = Unmarshaller.unmarshal(c, reader);
      } catch (Exception e) {
         System.err.println(e.getMessage());
         e.printStackTrace(System.err);
      }

      return obj;
   }

   public static String getSql(String xml, String sqlid) {
      try {
         String path = "sql/" + xml + ".xml";
         ClassPathResource classPathResource = new ClassPathResource(path);
         InputStream input = classPathResource.getInputStream();
         SAXReader reader = new SAXReader();
         Document document = reader.read(input);
         Node node = document.selectSingleNode("//select[@id='" + sqlid + "']");
         String sql = node.getText();
         sql = DataSourceTools.dealSqlFormat(sql);
         return sql;
      } catch (DocumentException e) {
         e.printStackTrace();
      } catch (IOException e) {
         e.printStackTrace();
      }

      return null;
   }

   public static String getSql(String xml, String sqlid, String subNodeName) {
      try {
         String path = "sql/" + xml + ".xml";
         ClassPathResource classPathResource = new ClassPathResource(path);
         InputStream input = classPathResource.getInputStream();
         SAXReader reader = new SAXReader();
         Document document = reader.read(input);
         Node node = document.selectSingleNode("//select[@id='" + sqlid + "']/" + subNodeName);
         String sql = node.getText();
         return sql;
      } catch (DocumentException e) {
         e.printStackTrace();
      } catch (IOException e) {
         e.printStackTrace();
      }

      return null;
   }

   public static String getValue(String xml_node) {
      String str = null;

      try {
         SAXReader reader = new SAXReader();
         Element root = reader.read(XmlTool.class.getClassLoader().getResourceAsStream("hive.xml")).getDocument().getRootElement();
         List<Node> list = root.selectNodes(xml_node);
         str = ((Element)list.get(0)).getTextTrim().toString();
      } catch (DocumentException e) {
         e.printStackTrace();
      }

      return str;
   }

   public static String getFileValue(String xml_node) {
      String str = null;

      try {
         SAXReader reader = new SAXReader();
         Element root = reader.read(XmlTool.class.getClassLoader().getResourceAsStream("filebase.xml")).getDocument().getRootElement();
         List<Node> list = root.selectNodes(xml_node);
         str = ((Element)list.get(0)).getTextTrim().toString();
      } catch (DocumentException e) {
         e.printStackTrace();
      }

      return str;
   }

   public static void main(String[] args) {
      getXmlFile();
   }

   public static Map<String, Map<String, String>> getXmlFile() {
      Map<String, Map<String, String>> fileList = new HashMap();

      try {
         SAXReader reader = new SAXReader();
         Document document = reader.read(XmlTool.class.getClassLoader().getResourceAsStream("filebase.xml"));
         Element root = document.getRootElement();
         Iterator<Element> it = root.elementIterator();

         while(it.hasNext()) {
            Element e = (Element)it.next();
            Map<String, String> fileValue = new HashMap();

            for(Element element : e.elements()) {
               fileValue.put(element.getName(), element.getText());
            }

            fileList.put(e.getName(), fileValue);
         }
      } catch (DocumentException e) {
         e.printStackTrace();
      }

      return fileList;
   }
}
