package com.chenyang.nse.bussiness.webtools.entity.db;

import com.chenyang.nse.bussiness.webtools.enumeration.EdbType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;

public class DbInfo {
   private String databaseProductName;
   private String databaseProductVersion;
   private String driverVersion;
   private String typeInfo;

   public DbInfo() {
   }

   public DbInfo(String databaseProductName, String databaseProductVersion, String driverVersion, String typeInfo) {
      this.databaseProductName = databaseProductName;
      this.databaseProductVersion = databaseProductVersion;
      this.driverVersion = driverVersion;
      this.typeInfo = typeInfo;
   }

   public String getDatabaseProductName() {
      return this.databaseProductName;
   }

   public void setDatabaseProductName(String databaseProductName) {
      this.databaseProductName = databaseProductName;
   }

   public String getDatabaseProductVersion() {
      return this.databaseProductVersion;
   }

   public void setDatabaseProductVersion(String databaseProductVersion) {
      this.databaseProductVersion = databaseProductVersion;
   }

   public String getDriverVersion() {
      return this.driverVersion;
   }

   public void setDriverVersion(String driverVersion) {
      this.driverVersion = driverVersion;
   }

   public String getTypeInfo() {
      return this.typeInfo;
   }

   public void setTypeInfo(String typeInfo) {
      this.typeInfo = typeInfo;
   }

   public String toString() {
      return "DbInfo [databaseProductName=" + this.databaseProductName + ", databaseProductVersion=" + this.databaseProductVersion + ", driverVersion=" + this.driverVersion + ", typeInfo=" + this.typeInfo + "]";
   }

   public static DbInfo getDbInfoByConnection(Connection conn) {
      DbInfo dbinfo = null;
      if (conn == null) {
         return dbinfo;
      } else {
         DatabaseMetaData dbmd = null;
         ResultSet rs = null;

         try {
            dbmd = conn.getMetaData();
            rs = dbmd.getTypeInfo();
            String type = null;
            String url = dbmd.getURL();
            if (StringUtils.isNotBlank(url) && url.contains("jdbc:oceanbase")) {
               dbinfo = new DbInfo("OCEANBASE", dbmd.getDatabaseProductVersion(), dbmd.getDriverVersion(), type);
            } else {
               dbinfo = new DbInfo(dbmd.getDatabaseProductName(), dbmd.getDatabaseProductVersion(), dbmd.getDriverVersion(), type);
            }
         } catch (SQLException e) {
            e.printStackTrace();
         } finally {
            try {
               if (rs != null) {
                  rs.close();
               }
            } catch (SQLException e) {
               e.printStackTrace();
            }

         }

         return dbinfo;
      }
   }

   public static EdbType getEdbTypeByConnection(Connection conn) {
      DatabaseMetaData metaData = null;
      String dbtype = "";

      try {
         metaData = conn.getMetaData();
         dbtype = metaData.getDatabaseProductName();
      } catch (SQLException e) {
         throw new RuntimeException(e);
      }

      if (dbtype.replaceAll(" ", "").toUpperCase().contains("SQLSERVER")) {
         return EdbType.MSSQLSERVER;
      } else if (!dbtype.toUpperCase().equals("ASE") && !dbtype.replaceAll(" ", "").equalsIgnoreCase("AdaptiveServerEnterprise")) {
         if (dbtype.toUpperCase().contains("HIVE")) {
            return EdbType.HIVE;
         } else if (dbtype.equalsIgnoreCase("POSTGRESQL")) {
            return EdbType.GREENPLUM;
         } else if (dbtype.equalsIgnoreCase("HDB")) {
            return EdbType.HANA;
         } else {
            for(String item : EdbType.getDbTypeList()) {
               if (dbtype.toUpperCase().contains(item)) {
                  return EdbType.getEdbTypeByDbcode(item);
               }
            }

            return null;
         }
      } else {
         return EdbType.SYBASE;
      }
   }
}
