package com.chenyang.nse.bussiness.webtools.entity.db;

import com.chenyang.nse.bussiness.enumeration.EdbType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PrimaryKeyInfo {
   private String tablecat;
   private String tableschem;
   private String tablename;
   private String columnname;
   private String keyseq;
   private String pkname;

   public PrimaryKeyInfo() {
   }

   public PrimaryKeyInfo(String tablecat, String tableschem, String tablename, String columnname, String keyseq, String pkname) {
      this.tablecat = tablecat;
      this.tableschem = tableschem;
      this.tablename = tablename;
      this.columnname = columnname;
      this.keyseq = keyseq;
      this.pkname = pkname;
   }

   public String getTablecat() {
      return this.tablecat;
   }

   public void setTablecat(String tablecat) {
      this.tablecat = tablecat;
   }

   public String getTableschem() {
      return this.tableschem;
   }

   public void setTableschem(String tableschem) {
      this.tableschem = tableschem;
   }

   public String getTablename() {
      return this.tablename;
   }

   public void setTablename(String tablename) {
      this.tablename = tablename;
   }

   public String getColumnname() {
      return this.columnname;
   }

   public void setColumnname(String columnname) {
      this.columnname = columnname;
   }

   public String getKeyseq() {
      return this.keyseq;
   }

   public void setKeyseq(String keyseq) {
      this.keyseq = keyseq;
   }

   public String getPkname() {
      return this.pkname;
   }

   public void setPkname(String pkname) {
      this.pkname = pkname;
   }

   public String toString() {
      return "PrimaryKeyInfo [tablecat=" + this.tablecat + ", tableschem=" + this.tableschem + ", tablename=" + this.tablename + ", columnname=" + this.columnname + ", keyseq=" + this.keyseq + ", pkname=" + this.pkname + "]";
   }

   public static List<com.chenyang.nse.bussiness.entity.db.PrimaryKeyInfo> getPrimaryKeyInfoByConnection(Connection conn, String schema, String table) {
      List<com.chenyang.nse.bussiness.entity.db.PrimaryKeyInfo> list = null;
      if (null == conn) {
         return list;
      } else {
         list = new ArrayList();
         DatabaseMetaData meta = null;
         ResultSet rs = null;
         PreparedStatement ps = null;

         try {
            meta = conn.getMetaData();
            EdbType dbtype = com.chenyang.nse.bussiness.entity.db.DbInfo.getEdbTypeByConnection(conn);
            if (dbtype.getDbcode().equals(EdbType.OCEANBASE.getDbcode())) {
               String querySql = "Select  * from all_constraints con,all_cons_columns col where con.constraint_name=col.constraint_name and con.constraint_type='P' and col.table_name='" + table.toUpperCase() + "' and con.owner = '" + schema.toUpperCase() + "'";
               ps = conn.prepareStatement(querySql);
               rs = ps.executeQuery();

               while(rs.next()) {
                  String tableschem = rs.getString("OWNER");
                  String tablename = rs.getString("TABLE_NAME");
                  String columnname = rs.getString("COLUMN_NAME");
                  String keyseq = rs.getString("INDEX_NAME");
                  String pkname = rs.getString("CONSTRAINT_NAME");
                  com.chenyang.nse.bussiness.entity.db.PrimaryKeyInfo temp = new com.chenyang.nse.bussiness.entity.db.PrimaryKeyInfo((String)null, tableschem, tablename, columnname, keyseq, pkname);
                  list.add(temp);
               }
            } else if (dbtype.getDbcode().equals(EdbType.MYSQL.getDbcode())) {
               conn.prepareStatement("use " + schema).execute();
               ResultSet ids = meta.getPrimaryKeys(schema, "", table);

               while(ids != null && ids.next()) {
                  String col = ids.getString("COLUMN_NAME");
                  String key = ids.getString("PK_NAME");
                  com.chenyang.nse.bussiness.entity.db.PrimaryKeyInfo temp = new com.chenyang.nse.bussiness.entity.db.PrimaryKeyInfo((String)null, schema, table, col, (String)null, key);
                  list.add(temp);
               }
            } else {
               rs = meta.getPrimaryKeys((String)null, schema, table);

               while(rs.next()) {
                  String tablecat = rs.getString("TABLE_CAT");
                  String tableschem = rs.getString("TABLE_SCHEM");
                  String tablename = rs.getString("TABLE_NAME");
                  String columnname = rs.getString("COLUMN_NAME");
                  String keyseq = rs.getString("KEY_SEQ");
                  String pkname = rs.getString("PK_NAME");
                  com.chenyang.nse.bussiness.entity.db.PrimaryKeyInfo temp = new com.chenyang.nse.bussiness.entity.db.PrimaryKeyInfo(tablecat, tableschem, tablename, columnname, keyseq, pkname);
                  list.add(temp);
               }
            }
         } catch (SQLException e) {
            e.printStackTrace();
         } finally {
            try {
               if (rs != null) {
                  rs.close();
               }

               if (ps != null) {
                  ps.close();
               }
            } catch (SQLException e) {
               e.printStackTrace();
            }

         }

         return list;
      }
   }

   public static List<String> getPrimaryKeyList(Connection conn, String schema, String table) {
      List<String> list = null;
      List<com.chenyang.nse.bussiness.entity.db.PrimaryKeyInfo> primaryKeyInfo = getPrimaryKeyInfoByConnection(conn, schema, table);
      if (primaryKeyInfo != null && primaryKeyInfo.size() > 0) {
         list = new ArrayList();

         for(com.chenyang.nse.bussiness.entity.db.PrimaryKeyInfo item : primaryKeyInfo) {
            list.add(item.getColumnname());
         }
      }

      return list;
   }
}
