package com.chenyang.nse.bussiness.webtools.json;

public class Response<T> {
   String code = "";
   String msg = "";
   int totalCount;
   boolean flag;
   T data;

   public int getTotalCount() {
      return this.totalCount;
   }

   public void setTotalCount(int totalCount) {
      this.totalCount = totalCount;
   }

   public Response() {
   }

   public Response(String code, String description) {
      this.code = code;
      this.msg = description;
   }

   public Response(String code, String description, T payload) {
      this.code = code;
      this.msg = description;
      this.data = payload;
   }

   public Response(boolean flag, String code, String description) {
      this.flag = flag;
      this.code = code;
      this.msg = description;
   }

   public Response(boolean flag, String code, String description, T payload) {
      this.flag = flag;
      this.code = code;
      this.msg = description;
      this.data = payload;
   }

   public String getCode() {
      return this.code;
   }

   public String getMsg() {
      return this.msg;
   }

   public T getData() {
      return this.data;
   }

   public void setCode(final String code) {
      this.code = code;
   }

   public void setMsg(final String msg) {
      this.msg = msg;
   }

   public void setData(final T data) {
      this.data = data;
   }

   public boolean equals(final Object o) {
      if (o == this) {
         return true;
      } else if (!(o instanceof Response)) {
         return false;
      } else {
         Response<?> other = (Response)o;
         if (!other.canEqual(this)) {
            return false;
         } else if (this.getCode() != other.getCode()) {
            return false;
         } else {
            Object this$msg = this.getMsg();
            Object other$msg = other.getMsg();
            if (this$msg == null) {
               if (other$msg != null) {
                  return false;
               }
            } else if (!this$msg.equals(other$msg)) {
               return false;
            }

            Object this$data = this.getData();
            Object other$data = other.getData();
            if (this$data == null) {
               if (other$data != null) {
                  return false;
               }
            } else if (!this$data.equals(other$data)) {
               return false;
            }

            return true;
         }
      }
   }

   protected boolean canEqual(final Object other) {
      return other instanceof Response;
   }

   public void setFlag(boolean flag) {
      this.flag = flag;
   }

   public boolean getFlag() {
      return this.flag;
   }

   public String toString() {
      return "Response(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
   }
}
