package com.chenyang.nse.bussiness.ccoresdf;


import com.chenyang.nse.bussiness.ccore.CcoreSDF;
import com.chenyang.nse.bussiness.service.key.impl.KeyManagerServiceImpl;
import com.chenyang.nse.bussiness.tools.spring.SpringUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import org.apache.shiro.codec.Hex;

public class CcoreSDFUtil {
   static int COMPUTE_ID = 257;
   static byte[] pucIV = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 49, 50, 51, 52, 53, 54, 55, 56};
   public static CcoreSDF.ECCCipher eccCipher = getECCCipher();
   static String password;

   public static byte[] getPucRandom(int len) {
      Session session = null;

      byte[] pucRandom;
      try {
         session = openCCore();
         if (session.success) {
            pucRandom = new byte[len];
            long ret = 0L;
            ret = CcoreSDF.GenerateRandom(session.phSessionHandle[0], (long)len, pucRandom);
            if (ret != 0L) {
               System.out.printf("GenerateRandom error ret = 0x%08x ", ret);
               byte[] var11 = longToBytes(ret);
               return var11;
            }

            byte[] var5 = pucRandom;
            return var5;
         }

         pucRandom = null;
      } finally {
         closeCCore(session);
      }

      return pucRandom;
   }

   public static String getEncrypt(byte[] pucRandom) {
      Session session = null;

      Object pucEncData;
      try {
         session = openCCore();
         if (session.success) {
            byte[] pucEncData1 = new byte[pucRandom.length];
            long[] puiEncDataLength = new long[1];
            long phKeyHandleOne = getPhKeyHandle(session, eccCipher);
            CcoreSDF.Encrypt(session.phSessionHandle[0], phKeyHandleOne, (long)COMPUTE_ID, pucIV, pucRandom, (long)pucRandom.length, pucEncData1, puiEncDataLength);
            CcoreSDF.DestroyKey(session.phSessionHandle[0], phKeyHandleOne);
            String var6 = Hex.encodeToString(pucEncData1);
            return var6;
         }

         pucEncData = null;
      } finally {
         closeCCore(session);
      }

      return (String)pucEncData;
   }

   public static String getDecrypt(byte[] pucEncData) {
      Session session = null;

      Object pucData;
      try {
         session = openCCore();
         if (session.success) {
            byte[] pucDataNew = new byte[pucEncData.length];
            long[] puiDataLength = new long[1];
            long phKeyHandleOne = getPhKeyHandle(session, eccCipher);
            CcoreSDF.Decrypt(session.phSessionHandle[0], phKeyHandleOne, (long)COMPUTE_ID, pucIV, pucEncData, (long)pucEncData.length, pucDataNew, puiDataLength);
            CcoreSDF.DestroyKey(session.phSessionHandle[0], phKeyHandleOne);
            String var6 = Hex.encodeToString(pucDataNew);
            return var6;
         }

         pucData = null;
      } finally {
         closeCCore(session);
      }

      return (String)pucData;
   }

   private static byte[] longToBytes(long x) {
      ByteBuffer buffer = ByteBuffer.allocate(8);
      buffer.putLong(x);
      return buffer.array();
   }

   private static Map<String, String> getParams() {
      return ((KeyManagerServiceImpl)SpringUtil.getBean(KeyManagerServiceImpl.class)).showKeyParams("4");
   }

   private static CcoreSDF.ECCCipher getECCCipher() {
      CcoreSDF.ECCCipher eccCipher = new CcoreSDF.ECCCipher();
      Map<String, String> props = getParams();
      String x = (String)props.get("ecccipherx");
      String y = (String)props.get("eccciphery");
      String M = (String)props.get("ecccipherm");
      String C = (String)props.get("ecccipherc");
      String L = (String)props.get("ecccipherl");
      eccCipher.x = stringReplaceByte(x.replaceAll(" ", "").split(","));
      eccCipher.y = stringReplaceByte(y.replaceAll(" ", "").split(","));
      eccCipher.M = stringReplaceByte(M.replaceAll(" ", "").split(","));
      eccCipher.C = stringReplaceByte(C.replaceAll(" ", "").split(","));
      eccCipher.L = Long.parseLong(L);
      password = (String)props.get("cphpwd");
      return eccCipher;
   }

   static Session openCCore() {
      long ret = 0L;
      Session session = new Session();
      ret = CcoreSDF.OpenDevice(session.phDeviceHandle);
      if (ret != 0L) {
         System.out.printf("OpenDevice error ret = 0x%08x ", ret);
         return session;
      } else {
         ret = CcoreSDF.OpenSession(session.phDeviceHandle[0], session.phSessionHandle);
         if (ret != 0L) {
            System.out.printf("OpenSession error ret = 0x%08x ", ret);
            return session;
         } else {
            session.success = true;
            return session;
         }
      }
   }

   static Boolean closeCCore(Session session) {
      if (session == null) {
         return false;
      } else {
         CcoreSDF.CloseSession(session.phSessionHandle[0]);
         CcoreSDF.CloseDevice(session.phDeviceHandle[0]);
         return true;
      }
   }

   private static byte[] stringReplaceByte(String[] strings) {
      int length = strings.length;
      byte[] bytes = new byte[strings.length];

      for(int i = 0; i < length; ++i) {
         int a = Integer.parseInt(strings[i]);
         bytes[i] = (byte)a;
      }

      return bytes;
   }

   private static long getPhKeyHandle(Session session, CcoreSDF.ECCCipher pucKeyCPECC) {
      long[] phKeyHandle = new long[1];
      long ret = CcoreSDF.GetPrivateKeyAccessRight(session.phSessionHandle[0], 1L, password, (long)password.length());
      if (ret != 0L) {
         System.out.printf("eeGetPrivateKeyAccessRight error ret = 0x%08x ", ret);
         return ret;
      } else {
         ret = CcoreSDF.ImportKeyWithISK_ECC(session.phSessionHandle[0], 1L, pucKeyCPECC, phKeyHandle);
         if (ret != 0L) {
            System.out.printf("ImportKeyWithISK_ECC error ret = 0x%08x ", ret);
            return ret;
         } else {
            return phKeyHandle[0];
         }
      }
   }

   public static void main(String[] args) {
      long ret = 0L;
      CcoreSDF.ECCCipher pucKeyCPECC = new CcoreSDF.ECCCipher();
      pucKeyCPECC.C = new byte[128];
      long[] phKeyHandle = new long[1];
      Session session = openCCore();
      ret = CcoreSDF.GenerateKeyWithIPK_ECC(session.phSessionHandle[0], 1L, 128L, pucKeyCPECC, phKeyHandle);
      if (ret != 0L) {
         System.out.printf("GenerateKeyWithIPK_ECC error ret = 0x%08x ", ret);
      } else {
         System.out.println(" GenerateKeyWithIPK_ECC pucKeyCPECC.x:");
         System.out.printf(Arrays.toString(pucKeyCPECC.x));
         System.out.println("\n\n");
         System.out.println("\n GenerateKeyWithIPK_ECC pucKeyCPECC.y:");
         System.out.printf(Arrays.toString(pucKeyCPECC.y));
         System.out.println("\n\n");
         System.out.println(" GenerateKeyWithIPK_ECC pucKeyCPECC.M:");
         System.out.printf(Arrays.toString(pucKeyCPECC.M));
         System.out.println("\n\n");
         System.out.printf("\n GenerateKeyWithIPK_ECC pucKeyCPECC.L:%d\n", pucKeyCPECC.L);
         System.out.println("\n\n");
         System.out.println("\n GenerateKeyWithIPK_ECC pucKeyCPECC.C:");
         System.out.printf(Arrays.toString(pucKeyCPECC.C));
      }
   }

   static class Session {
      long[] phDeviceHandle = new long[1];
      long[] phSessionHandle = new long[1];
      Boolean success = false;
   }
}
