package com.chenyang.nse.bussiness.controller.restfulapi;

import com.chenyang.nse.bussiness.entity.orm.table.core.api.ApiInfoLog;
import com.chenyang.nse.bussiness.service.core.api.ApiInfoLogService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/apiinfolog"})
public class ApiInfoLogController {
   @Autowired
   private ApiInfoLogService apiInfoLogService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/api/apiinfolog";
   }

   @RequestMapping({"/query"})
   @ResponseBody
   public List<ApiInfoLog> query(String username, String apitype, String calldatetime, HttpServletRequest request, HttpServletResponse response, Model model) {
      Map<String, String> condMap = new HashMap();
      condMap.put("username", username);
      condMap.put("apitype", apitype);
      condMap.put("calldatetime", calldatetime);
      List<ApiInfoLog> list = this.apiInfoLogService.queryInfoByConditon(condMap);
      return list;
   }
}
