package com.chenyang.nse.bussiness.engine.infa.powercenter961.subsetdata;

import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.FLATFILE;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.TABLEATTRIBUTE;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.TARGET;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.TARGETFIELD;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.TargetBean;
import java.util.ArrayList;
import java.util.List;

public class ChildMappletTargetUtil {
   public List<TARGET> getChildTarget(List<TargetBean> tb) {
      List<TARGET> tar_list = new ArrayList();
      if (tb != null && tb.size() > 0) {
         for(int i = 0; i < tb.size(); ++i) {
            TARGET target = new TARGET();
            target.setBUSINESSNAME("");
            target.setCONSTRAINT("");
            if ("MSSQLSERVER".equalsIgnoreCase(((TargetBean)tb.get(i)).getDatabasetype())) {
               target.setDATABASETYPE("Microsoft SQL Server");
            } else {
               target.setDATABASETYPE(((TargetBean)tb.get(i)).getDatabasetype());
            }

            target.setDESCRIPTION("");
            target.setNAME(((TargetBean)tb.get(i)).getTar_name());
            target.setOBJECTVERSION("1");
            target.setTABLEOPTIONS("");
            target.setVERSIONNUMBER("1");

            for(TARGETFIELD targetfield : getConvertTableInfoToTARGETFIELD(((TargetBean)tb.get(i)).getCb().getKeytype(), ((TargetBean)tb.get(i)).getCb().getNameList(), ((TargetBean)tb.get(i)).getCb().getTypeList(), ((TargetBean)tb.get(i)).getCb().getLengthList(), ((TargetBean)tb.get(i)).getCb().getScalelist(), ((TargetBean)tb.get(i)).getCb().getPrecisionList(), ((TargetBean)tb.get(i)).getDatabasetype())) {
               target.getTARGETFIELD().add(targetfield);
            }

            tar_list.add(target);
         }
      }

      return tar_list;
   }

   public static List<TARGETFIELD> getConvertTableInfoToTARGETFIELD(List<String> keytype, List<String> nameList, List<String> typeList, List<String> lengthList, List<String> scalelist, List<String> precisionlist, String dbtype) {
      List targetFieldList = new ArrayList();
      String[] targetFieldInfoStr = null;
      if ("DB2".equalsIgnoreCase(dbtype)) {
         for(int i = 0; i < nameList.size(); ++i) {
            TARGETFIELD targetfield = new TARGETFIELD();
            targetfield.setBUSINESSNAME("");
            if ("blob".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("4000");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("Byte");
            } else if ("boolean".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("5");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("SmallInt");
            } else if ("byte".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("4000");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("Byte");
            } else if ("varchar".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("Varchar");
            } else if ("char".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("Char");
            } else if ("clob".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4000");
               targetfield.setDATATYPE("Text");
            } else if ("date".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("10");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("Date");
            } else if ("datetime".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("25");
               targetfield.setSCALE("5");
               targetfield.setDATATYPE("Datetime year to fraction(5)");
            } else if ("float".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("15");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("Float");
            } else if ("int8".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("19");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("Int8");
            } else if ("int".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("10");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("Integer");
            } else if ("money".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("16");
               targetfield.setSCALE("2");
               targetfield.setDATATYPE("Money");
            } else if ("nchar".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("char");
            } else if ("nvarchar".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("NVarchar");
            } else if ("lvarchar".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("varchar");
            } else if ("serial".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("10");
               targetfield.setDATATYPE("Serial");
            } else if ("serial8".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("19");
               targetfield.setDATATYPE("Int8");
            } else if ("smallfloat".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("7");
               targetfield.setDATATYPE("SmallFloat");
            } else if ("smallint".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("5");
               targetfield.setDATATYPE("SmallInt");
            } else if ("decimal".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("Decimal");
            } else if ("INTEGER".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("integer");
            } else {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE((String)typeList.get(i));
            }

            targetfield.setDESCRIPTION("");
            targetfield.setFIELDNUMBER("" + (i + 1));
            targetfield.setKEYTYPE((String)keytype.get(i));
            targetfield.setNAME((String)nameList.get(i));
            if ("PRIMARY KEY".equals(keytype.get(i))) {
               targetfield.setNULLABLE("NOTNULL");
            } else {
               targetfield.setNULLABLE("NULL");
            }

            targetfield.setPICTURETEXT("");
            targetFieldList.add(targetfield);
         }
      } else if ("ORACLE".equalsIgnoreCase(dbtype)) {
         for(int i = 0; i < nameList.size(); ++i) {
            TARGETFIELD targetfield = new TARGETFIELD();
            targetfield.setBUSINESSNAME("");
            if ("VARCHAR2".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION((String)lengthList.get(i));
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("varchar2");
            } else if ("NUMBER".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("15");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("number");
            } else if ("DATE".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("19");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("date");
            } else if ("CLOB".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4000");
               targetfield.setDATATYPE("clob");
            } else if ("BLOB".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4000");
               targetfield.setDATATYPE("blob");
            } else if ("BFILE".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4000");
               targetfield.setDATATYPE("long raw");
            } else if ("BINARY_DOUBLE".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("15");
               targetfield.setDATATYPE("number");
            } else if ("BINARY_FLOAT".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("15");
               targetfield.setDATATYPE("number");
            } else if ("CHAR".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("1");
               targetfield.setDATATYPE("char");
            } else if ("number(p,s)".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("38");
               targetfield.setDATATYPE("number(p,s)");
            } else if ("number(p,s)".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("38");
               targetfield.setDATATYPE("number(p,s)");
            } else if ("INTERVAL DAY(2) TO SECOND(6)".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("0");
               targetfield.setDATATYPE("varchar2");
            } else if ("INTERVAL YEAR(2) TO MONTH".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("0");
               targetfield.setDATATYPE("varchar2");
            } else if ("LONG".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4000");
               targetfield.setDATATYPE("long");
            } else if ("NCHAR".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("1");
               targetfield.setDATATYPE("varchar2");
            } else if ("NVARCHAR2".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("20");
               targetfield.setDATATYPE("varchar2");
            } else if ("NCLOB".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("0");
               targetfield.setDATATYPE("varchar2");
            } else if ("RAW".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("20");
               targetfield.setDATATYPE("raw");
            } else if ("ROWID".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("0");
               targetfield.setDATATYPE("varchar2");
            } else if ("TIMESTAMP(6)".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("6");
               targetfield.setPRECISION("26");
               targetfield.setDATATYPE("timestamp");
            } else if ("UROWID".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("0");
               targetfield.setDATATYPE("varchar2");
            } else {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE((String)typeList.get(i));
            }

            targetfield.setDESCRIPTION("");
            targetfield.setFIELDNUMBER("" + (i + 1));
            targetfield.setKEYTYPE((String)keytype.get(i));
            targetfield.setNAME((String)nameList.get(i));
            if ("PRIMARY KEY".equals(keytype.get(i))) {
               targetfield.setNULLABLE("NOTNULL");
            } else {
               targetfield.setNULLABLE("NULL");
            }

            targetfield.setPICTURETEXT("");
            targetFieldList.add(targetfield);
         }
      } else if ("MSSQLSERVER".equalsIgnoreCase(dbtype)) {
         for(int i = 0; i < nameList.size(); ++i) {
            TARGETFIELD targetfield = new TARGETFIELD();
            targetfield.setBUSINESSNAME("");
            if ("bigint".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("19");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("bigint");
            } else if ("binary".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("binary");
            } else if ("bit".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("1");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("bit");
            } else if ("char".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("char");
            } else if ("date".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("3");
               targetfield.setPRECISION("23");
               targetfield.setDATATYPE("datetime");
            } else if ("datetime".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("3");
               targetfield.setPRECISION("23");
               targetfield.setDATATYPE("datetime");
            } else if ("datetime2".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("27");
               targetfield.setSCALE("7");
               targetfield.setDATATYPE("datetime2");
            } else if ("datetimeoffset".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("34");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("nvarchar");
            } else if ("decimal".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("decimal");
            } else if ("real".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("7");
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setDATATYPE("real");
            } else if ("geography".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("varchar");
            } else if ("geometry".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("varchar");
            } else if ("hierarchyid".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("892");
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("varchar");
            } else if ("image".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4000");
               targetfield.setDATATYPE("image");
            } else if ("int".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("10");
               targetfield.setDATATYPE("int");
            } else if ("money".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("4");
               targetfield.setPRECISION("19");
               targetfield.setDATATYPE("money");
            } else if ("nchar".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("nchar");
            } else if ("ntext".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("104857600");
               targetfield.setDATATYPE("ntext");
            } else if ("numeric".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("numeric");
            } else if ("nvarchar".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("nvarchar");
            } else if ("smalldatetime".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION("19");
               targetfield.setDATATYPE("smalldatetime");
            } else if ("smallint".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION("5");
               targetfield.setDATATYPE("smallint");
            } else if ("smallmoney".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("4");
               targetfield.setPRECISION("10");
               targetfield.setDATATYPE("smallmoney");
            } else if ("sql_variant".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("4");
               targetfield.setPRECISION("8000");
               targetfield.setDATATYPE("varchar");
            } else if ("sysname".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("128");
               targetfield.setDATATYPE("nvarchar");
            } else if ("text".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4000");
               targetfield.setDATATYPE("text");
            } else if ("time".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("23");
               targetfield.setDATATYPE("datetime");
            } else if ("timestamp".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("8");
               targetfield.setDATATYPE("timestamp");
            } else if ("tinyint".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("3");
               targetfield.setDATATYPE("tinyint");
            } else if ("uniqueidentifier".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("38");
               targetfield.setDATATYPE("varchar");
            } else if ("varbinary".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("varchar");
            } else if ("varchar".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("varchar");
            } else {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE((String)typeList.get(i));
            }

            targetfield.setDESCRIPTION("");
            targetfield.setFIELDNUMBER("" + (i + 1));
            targetfield.setKEYTYPE((String)keytype.get(i));
            targetfield.setNAME((String)nameList.get(i));
            if ("PRIMARY KEY".equals(keytype.get(i))) {
               targetfield.setNULLABLE("NOTNULL");
            } else {
               targetfield.setNULLABLE("NULL");
            }

            targetfield.setPICTURETEXT("");
            targetFieldList.add(targetfield);
         }
      } else if ("INFORMIX".equalsIgnoreCase(dbtype)) {
         for(int i = 0; i < nameList.size(); ++i) {
            TARGETFIELD targetfield = new TARGETFIELD();
            targetfield.setBUSINESSNAME("");
            if ("blob".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("4000");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("Byte");
            } else if ("boolean".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("5");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("SmallInt");
            } else if ("byte".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("4000");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("Byte");
            } else if ("varchar".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("Varchar");
            } else if ("char".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("Char");
            } else if ("clob".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4000");
               targetfield.setDATATYPE("Text");
            } else if ("date".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("19");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("Date");
            } else if ("datetime".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("25");
               targetfield.setSCALE("5");
               targetfield.setDATATYPE("Datetime year to fraction(5)");
            } else if ("float".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("15");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("Float");
            } else if ("int8".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("19");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("Int8");
            } else if ("int".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("10");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("Integer");
            } else if ("money".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("16");
               targetfield.setSCALE("2");
               targetfield.setDATATYPE("Money");
            } else if ("nchar".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("char");
            } else if ("nvarchar".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("NVarchar");
            } else if ("lvarchar".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("varchar");
            } else if ("serial".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("10");
               targetfield.setDATATYPE("Serial");
            } else if ("serial8".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("19");
               targetfield.setDATATYPE("Int8");
            } else if ("smallfloat".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("7");
               targetfield.setDATATYPE("SmallFloat");
            } else if ("smallint".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("5");
               targetfield.setDATATYPE("SmallInt");
            } else if ("decimal".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("Decimal");
            } else {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE((String)typeList.get(i));
            }

            targetfield.setDESCRIPTION("");
            targetfield.setFIELDNUMBER("" + (i + 1));
            targetfield.setKEYTYPE((String)keytype.get(i));
            targetfield.setNAME((String)nameList.get(i));
            if ("PRIMARY KEY".equals(keytype.get(i))) {
               targetfield.setNULLABLE("NOTNULL");
            } else {
               targetfield.setNULLABLE("NULL");
            }

            targetfield.setPICTURETEXT("");
            targetFieldList.add(targetfield);
         }
      } else if ("MYSQL".equalsIgnoreCase(dbtype)) {
         for(int i = 0; i < nameList.size(); ++i) {
            TARGETFIELD targetfield = new TARGETFIELD();
            targetfield.setBUSINESSNAME("");
            if ("TINYINT".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("3");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("tinyint");
            } else if ("SMALLINT".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("5");
               targetfield.setDATATYPE("smallint");
            } else if ("MEDIUMINT".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("integer");
            } else if ("INT".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("integer");
            } else if ("BIGINT".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("bigint");
            } else if ("BIT".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("1");
               targetfield.setDATATYPE("bit");
            } else if ("DOUBLE".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("double");
            } else if ("FLOAT".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("real");
            } else if ("DECIMAL".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("decimal");
            } else if ("CHAR".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("255");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("nchar");
            } else if ("VARCHAR".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("nvarchar");
            } else if ("DATE".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("10");
               targetfield.setDATATYPE("date");
            } else if ("TIME".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("8");
               targetfield.setDATATYPE("time");
            } else if ("YEAR".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("5");
               targetfield.setDATATYPE("smallint");
            } else if ("TIMESTAMP".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("9");
               targetfield.setPRECISION("29");
               targetfield.setDATATYPE("timestamp");
            } else if ("DATETIME".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("9");
               targetfield.setPRECISION("29");
               targetfield.setDATATYPE("timestamp");
            } else if ("TINYBLOB".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("255");
               targetfield.setDATATYPE("longvarbinary");
            } else if ("BLOB".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("65535");
               targetfield.setDATATYPE("longvarbinary");
            } else if ("MEDIUMBLOB".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("16777215");
               targetfield.setDATATYPE("longvarbinary");
            } else if ("LONGBLOB".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4294967295");
               targetfield.setDATATYPE("longvarbinary");
            } else if ("TINYTEXT".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("255");
               targetfield.setDATATYPE("ntext");
            } else if ("TEXT".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("65535");
               targetfield.setDATATYPE("ntext");
            } else if ("MEDIUMTEXT".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("16777215");
               targetfield.setDATATYPE("ntext");
            } else if ("LONGTEXT".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4294967295");
               targetfield.setDATATYPE("ntext");
            } else if ("ENUM".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("nchar");
            } else if ("SET".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("nchar");
            } else if ("BINARY".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("255");
               targetfield.setDATATYPE("binary");
            } else if ("VARBINARY".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("255");
               targetfield.setDATATYPE("varbinary");
            } else if ("POINT".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4294967294");
               targetfield.setDATATYPE("longvarbinary");
            } else if ("LINESTRING".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4294967294");
               targetfield.setDATATYPE("longvarbinary");
            } else if ("POLYGON".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4294967294");
               targetfield.setDATATYPE("longvarbinary");
            } else if ("GEOMETRY".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4294967294");
               targetfield.setDATATYPE("longvarbinary");
            } else if ("MULTIPOINT".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4294967294");
               targetfield.setDATATYPE("longvarbinary");
            } else if ("MULTILINESTRING".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4294967294");
               targetfield.setDATATYPE("longvarbinary");
            } else if ("MULTIPOLYGON".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4294967294");
               targetfield.setDATATYPE("longvarbinary");
            } else if ("GEOMETRYCOLLECTION".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4294967294");
               targetfield.setDATATYPE("longvarbinary");
            } else {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE((String)typeList.get(i));
            }

            targetfield.setDESCRIPTION("");
            targetfield.setFIELDNUMBER("" + (i + 1));
            targetfield.setKEYTYPE((String)keytype.get(i));
            targetfield.setNAME((String)nameList.get(i));
            if ("PRIMARY KEY".equals(keytype.get(i))) {
               targetfield.setNULLABLE("NOTNULL");
            } else {
               targetfield.setNULLABLE("NULL");
            }

            targetfield.setPICTURETEXT("");
            targetFieldList.add(targetfield);
         }
      } else if ("SYBASE".equalsIgnoreCase(dbtype)) {
         for(int i = 0; i < nameList.size(); ++i) {
            TARGETFIELD targetfield = new TARGETFIELD();
            targetfield.setBUSINESSNAME("");
            if ("bigint".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("19");
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("bigint");
            } else if ("binary".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("binary");
            } else if ("bit".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("bit");
            } else if ("char".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("char");
            } else if ("date".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("23");
               targetfield.setSCALE("3");
               targetfield.setDATATYPE("datetime");
            } else if ("datetime".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("23");
               targetfield.setSCALE("3");
               targetfield.setDATATYPE("datetime");
            } else if ("decimal".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setDATATYPE("decimal");
            } else if ("float".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setDATATYPE("float");
            } else if ("image".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4000");
               targetfield.setDATATYPE("decimal");
            } else if ("longsysname".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setDATATYPE("varchar");
            } else if ("sysname".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("100");
               targetfield.setDATATYPE("varchar");
            } else if ("int".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setDATATYPE("int");
            } else if ("varchar".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setSCALE("0");
               targetfield.setDATATYPE("varchar");
            } else if ("money".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("4");
               targetfield.setPRECISION("19");
               targetfield.setDATATYPE("money");
            } else if ("nchar".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setDATATYPE("nchar");
            } else if ("nvarchar".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setDATATYPE("nvarchar");
            } else if ("real".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("7");
               targetfield.setDATATYPE("real");
            } else if ("smalldatetime".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("19");
               targetfield.setDATATYPE("smalldatetime");
            } else if ("smallint".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("5");
               targetfield.setDATATYPE("smallint");
            } else if ("smallmoney".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("4");
               targetfield.setPRECISION("10");
               targetfield.setDATATYPE("smallmoney");
            } else if ("text".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4000");
               targetfield.setDATATYPE("text");
            } else if ("time".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("3");
               targetfield.setPRECISION("23");
               targetfield.setDATATYPE("datetime");
            } else if ("timestamp".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setDATATYPE("varbinary");
            } else if ("tinyint".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setDATATYPE("tinyint");
            } else if ("unichar".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("200");
               targetfield.setDATATYPE("nchar");
            } else if ("unitext".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("4000");
               targetfield.setDATATYPE("nvarchar");
            } else if ("univarchar".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("200");
               targetfield.setDATATYPE("nvarchar");
            } else if ("unsigned bigint".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setDATATYPE("bigint");
            } else if ("unsigned int".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE("int");
            } else if ("unsigned smallint".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setSCALE("0");
               targetfield.setPRECISION("5");
               targetfield.setDATATYPE("smallint");
            } else {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
               targetfield.setDATATYPE((String)precisionlist.get(i));
            }

            targetfield.setDESCRIPTION("");
            targetfield.setFIELDNUMBER("" + (i + 1));
            targetfield.setKEYTYPE((String)keytype.get(i));
            targetfield.setNAME((String)nameList.get(i));
            if ("PRIMARY KEY".equals(keytype.get(i))) {
               targetfield.setNULLABLE("NOTNULL");
            } else {
               targetfield.setNULLABLE("NULL");
            }

            targetfield.setPICTURETEXT("");
            targetFieldList.add(targetfield);
         }
      }

      return targetFieldList;
   }

   public List<TARGET> getTargetOther(List<TargetBean> tb) {
      List<TARGET> tar_list = new ArrayList();
      if (tb != null && tb.size() > 0) {
         for(int i = 0; i < tb.size(); ++i) {
            TARGET target = new TARGET();
            target.setBUSINESSNAME("");
            target.setCONSTRAINT("");
            target.setDATABASETYPE("Flat File");
            target.setDESCRIPTION("");
            target.setNAME("target_tab_candidate" + i);
            target.setOBJECTVERSION("1");
            target.setTABLEOPTIONS("");
            target.setVERSIONNUMBER("1");
            FLATFILE flatfile = new FLATFILE();
            flatfile.setCODEPAGE("MS1252");
            flatfile.setCONSECDELIMITERSASONE("NO");
            flatfile.setDELIMITED("YES");
            flatfile.setDELIMITERS(",");
            flatfile.setESCAPECHARACTER("");
            flatfile.setKEEPESCAPECHAR("NO");
            flatfile.setLINESEQUENTIAL("NO");
            flatfile.setMULTIDELIMITERSASAND("NO");
            flatfile.setNULLCHARTYPE("ASCII");
            flatfile.setNULLCHARACTER("*");
            flatfile.setPADBYTES("1");
            flatfile.setQUOTECHARACTER("NONE");
            flatfile.setREPEATABLE("NO");
            flatfile.setROWDELIMITER("0");
            flatfile.setSHIFTSENSITIVEDATA("NO");
            flatfile.setSKIPROWS("0");
            flatfile.setSTRIPTRAILINGBLANKS("NO");
            target.setFLATFILE(flatfile);

            for(int j = 0; j < ((TargetBean)tb.get(i)).getCb().getKeytype().size(); ++j) {
               if (((String)((TargetBean)tb.get(i)).getCb().getKeytype().get(j)).equals("PRIMARY KEY")) {
                  TARGETFIELD tf = new TARGETFIELD();
                  tf.setBUSINESSNAME("");
                  if (((String)((TargetBean)tb.get(i)).getCb().getTypeList().get(j)).equals("number(p,s)")) {
                     tf.setDATATYPE("int");
                  } else {
                     tf.setDATATYPE("string");
                  }

                  tf.setDESCRIPTION("");
                  tf.setFIELDNUMBER("1");
                  tf.setKEYTYPE("NOT A KEY");
                  tf.setNAME((String)((TargetBean)tb.get(i)).getCb().getNameList().get(j) + "_tar");
                  tf.setNULLABLE("NULL");
                  tf.setPICTURETEXT("");
                  tf.setPRECISION((String)((TargetBean)tb.get(i)).getCb().getLengthList().get(j));
                  tf.setSCALE((String)((TargetBean)tb.get(i)).getCb().getScalelist().get(j));
                  target.getTARGETFIELD().add(tf);
               }
            }

            String[] attributeStr = new String[]{"Datetime Format@A  19 mm/dd/yyyy hh24:mi:ss", "Thousand Separator@None", "Decimal Separator@.", "Line Endings@System default"};
            String[] tmpAttr = null;
            TABLEATTRIBUTE[] attribute = new TABLEATTRIBUTE[attributeStr.length];

            for(int k = 0; k < attributeStr.length; ++k) {
               tmpAttr = attributeStr[k].split("@");
               attribute[k] = new TABLEATTRIBUTE();
               attribute[k].setNAME(tmpAttr[0]);
               if (tmpAttr.length > 1) {
                  attribute[k].setVALUE(tmpAttr[1]);
               } else {
                  attribute[k].setVALUE("");
               }

               target.getTABLEATTRIBUTE().add(attribute[k]);
            }

            tar_list.add(target);
         }
      }

      return tar_list;
   }

   public TARGET getFixTarget(List<String> typelist, List<String> datatypelist, List<String> namelist, List<String> lengthlist, List<String> sclaelist) {
      TARGET target = new TARGET();
      target.setBUSINESSNAME("");
      target.setCONSTRAINT("");
      target.setDATABASETYPE("Flat File");
      target.setDESCRIPTION("");
      target.setNAME("tab_candidate");
      target.setOBJECTVERSION("1");
      target.setTABLEOPTIONS("");
      target.setVERSIONNUMBER("1");
      FLATFILE flatfile = new FLATFILE();
      flatfile.setCODEPAGE("MS1252");
      flatfile.setCONSECDELIMITERSASONE("NO");
      flatfile.setDELIMITED("YES");
      flatfile.setDELIMITERS(",");
      flatfile.setESCAPECHARACTER("");
      flatfile.setKEEPESCAPECHAR("NO");
      flatfile.setLINESEQUENTIAL("NO");
      flatfile.setMULTIDELIMITERSASAND("NO");
      flatfile.setNULLCHARTYPE("ASCII");
      flatfile.setNULLCHARACTER("*");
      flatfile.setPADBYTES("1");
      flatfile.setQUOTECHARACTER("NONE");
      flatfile.setREPEATABLE("NO");
      flatfile.setROWDELIMITER("0");
      flatfile.setSHIFTSENSITIVEDATA("NO");
      flatfile.setSKIPROWS("0");
      flatfile.setSTRIPTRAILINGBLANKS("NO");
      target.setFLATFILE(flatfile);
      if (typelist != null && typelist.size() > 0) {
         for(int i = 0; i < typelist.size(); ++i) {
            TARGETFIELD tf = new TARGETFIELD();
            tf.setBUSINESSNAME("");
            tf.setDATATYPE((String)datatypelist.get(i));
            tf.setDESCRIPTION("");
            tf.setFIELDNUMBER("1");
            tf.setKEYTYPE("NOT A KEY");
            tf.setNAME("ID1");
            tf.setNULLABLE("NULL");
            tf.setPICTURETEXT("");
            tf.setPRECISION((String)lengthlist.get(i));
            tf.setSCALE((String)sclaelist.get(i));
            target.getTARGETFIELD().add(tf);
         }
      }

      String[] attributeStr = new String[]{"Datetime Format@A  19 mm/dd/yyyy hh24:mi:ss", "Thousand Separator@None", "Decimal Separator@.", "Line Endings@System default"};
      String[] tmpAttr = null;
      TABLEATTRIBUTE[] attribute = new TABLEATTRIBUTE[attributeStr.length];

      for(int i = 0; i < attributeStr.length; ++i) {
         tmpAttr = attributeStr[i].split("@");
         attribute[i] = new TABLEATTRIBUTE();
         attribute[i].setNAME(tmpAttr[0]);
         if (tmpAttr.length > 1) {
            attribute[i].setVALUE(tmpAttr[1]);
         } else {
            attribute[i].setVALUE("");
         }

         target.getTABLEATTRIBUTE().add(attribute[i]);
      }

      return target;
   }
}
