package com.chenyang.nse.bussiness.tools.login;

import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUser;
import com.chenyang.nse.bussiness.tools.msg.PropertiesClassLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class CommonUtils {
   private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
   private static Logger logger = LoggerFactory.getLogger(PropertiesClassLoader.class);

   public static String getIpAddr(HttpServletRequest request) {
      String ip = request.getHeader("x-forwarded-for");
      if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
         ip = request.getHeader("Proxy-Client-IP");
      }

      if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
         ip = request.getHeader("WL-Proxy-Client-IP");
      }

      if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
         ip = request.getRemoteAddr();
      }

      if (ip.equals("0:0:0:0:0:0:0:1")) {
         ip = "本地";
      }

      return ip;
   }

   public static String getLocalMac(String ipAddress) throws SocketException, UnknownHostException {
      String str = "";
      String macAddress = "";
      String LOOPBACK_ADDRESS = "127.0.0.1";
      if ("127.0.0.1".equals(ipAddress)) {
         InetAddress inetAddress = InetAddress.getLocalHost();
         byte[] mac = NetworkInterface.getByInetAddress(inetAddress).getHardwareAddress();
         StringBuilder sb = new StringBuilder();

         for(int i = 0; i < mac.length; ++i) {
            if (i != 0) {
               sb.append("-");
            }

            String s = Integer.toHexString(mac[i] & 255);
            sb.append(s.length() == 1 ? 0 + s : s);
         }

         macAddress = sb.toString().trim().toUpperCase();
      } else {
         Process p = null;
         InputStreamReader ir = null;
         BufferedReader br = null;

         try {
            System.out.println(ipAddress);
            p = Runtime.getRuntime().exec("nbtstat -A " + ipAddress);
            System.out.println("===process==" + p);
            ir = new InputStreamReader(p.getInputStream());
            br = new BufferedReader(ir);

            while((str = br.readLine()) != null) {
               if (str.indexOf("MAC") > 1) {
                  String var20 = str.substring(str.indexOf("MAC") + 9, str.length());
                  macAddress = var20.trim();
                  System.out.println("macAddress:" + macAddress);
                  break;
               }
            }
         } catch (IOException var17) {
         } finally {
            try {
               if (p != null) {
                  p.destroy();
               }

               if (br != null) {
                  br.close();
               }

               if (ir != null) {
                  ir.close();
               }
            } catch (IOException e) {
               e.printStackTrace();
            }

         }
      }

      return macAddress;
   }

   public static TBaseUser loginUser() {
      TBaseUser user = new TBaseUser();
      user.setId("1");

      try {
         HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
         Object userObj = request.getSession().getAttribute("loginUser");
         if (userObj != null && userObj instanceof LoginUser) {
            user = ((LoginUser)userObj).getTsysUser();
         }
      } catch (Exception e) {
         logger.info("登录用户获取失败", e.getMessage());
      }

      return user;
   }

   public static String loginUsername() {
      String username = null;

      try {
         HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
         Object userObj = request.getSession().getAttribute("loginUser");
         if (userObj != null && userObj instanceof LoginUser) {
            username = ((LoginUser)userObj).getTsysUser().getUsername();
         } else {
            username = "admin";
         }
      } catch (Exception e) {
         logger.info("登录用户获取失败", e.getMessage());
      }

      return username;
   }
}
