package com.chenyang.nse.bussiness.controller.core;

import cn.hutool.core.bean.BeanUtil;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDataScope;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitiveLevel;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreCategoryLevelLog;
import com.chenyang.nse.bussiness.entity.vo.TCoreCatagoryLevelLogVO;
import com.chenyang.nse.bussiness.service.core.DataScopeService;
import com.chenyang.nse.bussiness.service.core.ITcoreCatacoryLevelLogService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/catagorylevellog"})
public class CatagoryLevelLogController {
   @Autowired
   private DataScopeService dataScopeService;
   @Autowired
   private ITcoreCatacoryLevelLogService tcoreCatacoryLevelLogService;

   @ResponseBody
   @RequestMapping({"/getlevellog"})
   public Response<List<TCoreCatagoryLevelLogVO>> getlevellog(@RequestBody Map<String, Object> params) {
      List<TCoreCatagoryLevelLogVO> result = new ArrayList();
      List<TCoreCategoryLevelLog> tCoreCategoryLevelLogs = this.tcoreCatacoryLevelLogService.queryAll(params);
      tCoreCategoryLevelLogs.forEach((item) -> {
         TCoreCatagoryLevelLogVO vo = new TCoreCatagoryLevelLogVO();
         BeanUtil.copyProperties(item, vo, new String[0]);
         String categoryids = vo.getCategoryid();
         if (StringUtils.isNotBlank(categoryids)) {
            String[] split = categoryids.split(",");
            List<TCoreDataScope> tCoreDataScopeList = new ArrayList();

            for(int i = 0; i < split.length; ++i) {
               TCoreDataScope tCoreDataScope = new TCoreDataScope();
               String scope_id = split[i];
               Map<String, String> scopenamemap = this.dataScopeService.queryScopeById(scope_id);
               tCoreDataScope.setScope_id(scope_id);
               tCoreDataScope.setScope_name((String)scopenamemap.get("scope_name"));
               tCoreDataScopeList.add(tCoreDataScope);
            }

            vo.setTCoreDataScopeList(tCoreDataScopeList);
         }

         if (StringUtils.isNotBlank(vo.getLevelid())) {
            TCoreSensitiveLevel tCoreSensitiveLevel = new TCoreSensitiveLevel();
            tCoreSensitiveLevel.setSensitive_id(vo.getLevelid());
            Map<String, String> scopenamemap = this.dataScopeService.queryScopelevelById(vo.getLevelid());
            tCoreSensitiveLevel.setSensitive_name((String)scopenamemap.get("sensitive_name"));
            vo.setTCoreSensitiveLevel(tCoreSensitiveLevel);
         }

         result.add(vo);
      });
      return RespHelper.<List<TCoreCatagoryLevelLogVO>>successResp(result);
   }
}
