package com.chenyang.nse.bussiness.service.core;

import com.chenyang.nse.bussiness.entity.orm.table.core.rule.app.AppDataRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.rule.conditions.ApplicationConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.rule.conditions.DateConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.rule.conditions.DbuserConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.rule.conditions.IpConditions;
import java.util.List;

public interface AppDataRuleService {
   void saveAppRuleInfo(AppDataRule appDataRule, String id);

   void saveIpConditionsInfo(IpConditions ipConditions);

   void saveApplicationConditionsInfo(ApplicationConditions applicationConditions);

   void saveDbuserConditionsInfo(DbuserConditions dbuserConditions);

   void saveDateConditionsInfo(DateConditions dateConditions);

   AppDataRule getAppRuleInfoById(String id);

   List<IpConditions> getIpConditionsInfoByRuleId(String ruleid);

   List<ApplicationConditions> getApplicationConditionsInfoByRuleId(String ruleid);

   List<DbuserConditions> getDbuserConditionsInfoByRuleId(String ruleid);

   List<DateConditions> getDateConditionsInfoByRuleId(String ruleid);

   void delAppRuleInfoById(String id);

   void delIpConditionsInfoByRuleId(String ruleid);

   void delApplicationConditionsInfoByRuleId(String ruleid);

   void delDbuserConditionsInfoByRuleId(String ruleid);

   void delDateConditionsInfoByRuleId(String ruleid);

   List<AppDataRule> queryAll();

   List<AppDataRule> queryRuleBygroup(String dataareaid, String dbtype);
}
