package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.commmon.ApplicationConstants;
import com.chenyang.nse.bussiness.dao.core.EngineDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreEngineDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreImporttaskDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreMaskingtaskDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingTableDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingTablecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreSyncKeyindexDao;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.LoginWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.LogoutWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.MultiGetSessionLogWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.MultiGetSessionStatisticsWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.MultiGetSessionTimeWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.MultiGetWorkflowLogWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.SessionBean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.InfoExecUtil;
import com.chenyang.nse.bussiness.entity.db.IndexInfo;
import com.chenyang.nse.bussiness.entity.db.PrimaryKeyInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreImporttask;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTable;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTablecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreSyncKeyindex;
import com.chenyang.nse.bussiness.entity.orm.table.core.maskingself.TCoreMaskingselfTask;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.enumeration.EmaskingDirection;
import com.chenyang.nse.bussiness.service.core.AllwaysMonitorService;
import com.chenyang.nse.bussiness.service.core.MaskingTaskService;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AllwaysMonitorServiceImpl implements AllwaysMonitorService {
   @Autowired
   private TCoreMaskingtaskDao tCoreMaskingtaskDao;
   @Autowired
   private TCoreEngineDao tCoreEngineDao;
   @Autowired
   private EngineDao engineDao;
   @Autowired
   private MaskingTaskService maskingTaskService;
   @Autowired
   private TCoreImporttaskDao tCoreImporttaskDao;
   @Autowired
   private TCoreMaskingTableDao tCoreMaskingTableDao;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   private TCoreMaskingTablecolumnDao tCoreMaskingTablecolumnDao;
   @Autowired
   private TCoreSyncKeyindexDao tCoreSyncKeyindexDao;

   public SessionBean getLog(String taskid) {
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingtaskDao.get(taskid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      SessionBean se = new SessionBean();
      return se;
   }

   public SessionBean getTime(String taskid) {
      return null;
   }

   public SessionBean getLogForImpMapping(TCoreMaskingTask task, InfoProperty engine, TCoreImporttask timptask) {
      SessionBean se = new SessionBean();

      try {
         String sessionID = LoginWebService.returnStatus(engine);
         se = MultiGetSessionStatisticsWebService.returnStatus(sessionID, engine.getDomainname(), engine.getInteservicename(), timptask.getWfname(), timptask.getMpname(), timptask.getSename(), task.getFdname());
         se.setTask_name(task.getTaskname());
         SessionBean sb1 = MultiGetSessionTimeWebService.returnStatus(sessionID, engine.getDomainname(), engine.getInteservicename(), timptask.getWfname(), timptask.getMpname(), timptask.getSename(), task.getFdname());
         se.setStart_time(sb1.getStart_time());
         se.setEnd_time(sb1.getEnd_time());
         LogoutWebService.returnStatus(sessionID, engine);
      } catch (Exception var7) {
         se.setStatus("SUCCEED");
      }

      return se;
   }

   public SessionBean getLogForTaskMapping(TCoreMaskingTask task, InfoProperty engine, String name) {
      SessionBean se = new SessionBean();

      try {
         String sessionID = LoginWebService.returnStatus(engine);
         se = MultiGetSessionStatisticsWebService.returnStatus(sessionID, engine, "wf_" + name, "mp_" + name, task.getFdname());
         SessionBean sb1 = MultiGetSessionTimeWebService.returnStatus(sessionID, engine, "wf_" + name, "mp_" + name, task.getFdname());
         se.setStart_time(sb1.getStart_time());
         se.setEnd_time(sb1.getEnd_time());
         LogoutWebService.returnStatus(sessionID, engine);
      } catch (Exception var7) {
         se.setStatus("SUCCEED");
      }

      return se;
   }

   public SessionBean getSessionLog(TCoreMaskingTask task, String wfname, InfoProperty engine) {
      SessionBean se = new SessionBean();

      try {
         String sessionID = LoginWebService.returnStatus(engine);
         String selog = MultiGetSessionLogWebService.returnStatus(sessionID, engine, "wf_" + wfname, "mp_" + wfname, task.getFdname());
         se.setSe_log(selog);
         LogoutWebService.returnStatus(sessionID, engine);
      } catch (Exception var7) {
         se.setStatus("SUCCEED");
      }

      return se;
   }

   public SessionBean getRunid(TCoreMaskingTask task, InfoProperty engine, String name) {
      SessionBean se = new SessionBean();

      try {
         String sessionID = LoginWebService.returnStatus(engine);
         se = MultiGetSessionStatisticsWebService.returnStatus(sessionID, engine, "wf_" + name, "mp_" + name, task.getFdname());
         LogoutWebService.returnStatus(sessionID, engine);
      } catch (Exception var6) {
         se.setStatus("SUCCEED");
      }

      return se;
   }

   public SessionBean getLogForSelfTaskMapping(TCoreMaskingselfTask task, InfoProperty engine, String name) {
      SessionBean se = new SessionBean();

      try {
         String sessionID = LoginWebService.returnStatus(engine);
         se = MultiGetSessionStatisticsWebService.returnStatus(sessionID, engine, "wf_" + name, "mp_" + name, task.getFdname());
         String selog = MultiGetSessionLogWebService.returnStatus(sessionID, engine, "wf_" + name, "mp_" + name, task.getFdname());
         se.setSe_log(selog);
         String wflog = MultiGetWorkflowLogWebService.returnStatus(sessionID, engine, "wf_" + name, "mp_" + name, task.getFdname(), se.getWf_run_id());
         se.setWf_log(wflog);
         SessionBean sb1 = MultiGetSessionTimeWebService.returnStatus(sessionID, engine, "wf_" + name, "mp_" + name, task.getFdname());
         se.setStart_time(sb1.getStart_time());
         se.setEnd_time(sb1.getEnd_time());
         LogoutWebService.returnStatus(sessionID, engine);
      } catch (Exception var9) {
         se.setStatus("SUCCEED");
      }

      return se;
   }

   public boolean stopwork(String taskid, String wfname) {
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingtaskDao.get(taskid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);

      try {
         InfoExecUtil.executStopWorkflow(ApplicationConstants.pmcmd_path, engine.getInteservicename(), engine.getUsername(), engine.getPassword(), task.getFdname(), wfname);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return true;
   }

   public boolean recoverywork(String taskid, String wfname) {
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingtaskDao.get(taskid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);

      try {
         InfoExecUtil.executStopWorkflow(ApplicationConstants.pmcmd_path, engine.getInteservicename(), engine.getUsername(), engine.getPassword(), task.getFdname(), wfname);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return true;
   }

   public TCoreImporttask getImpTask(TCoreMaskingTask task) {
      new TCoreImporttask();
      TCoreImporttask imptask = (TCoreImporttask)this.tCoreImporttaskDao.queryUnique(new Criterion[]{Restrictions.eq("taskname", task.getTaskname())});
      return imptask;
   }

   public Connection getConnectionByDataSystemId(String datasystemid) {
      TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(datasystemid);
      String dbcode = datasystem.getDbtype();
      String ip = datasystem.getDbip();
      String port = datasystem.getDbport();
      String servername = datasystem.getDbservername();
      String server = datasystem.getServername();
      String url = "";
      switch (datasystem.getDbtype()) {
         case "INFORMIX":
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername, server);
            break;
         default:
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername);
      }

      String username = datasystem.getUsername();
      String password = AesTool.decrypt(datasystem.getPassword(), "ghca");
      String driver = EdbType.getEdbTypeByDbcode(dbcode).getDbdriver();
      Connection conn = JdbcTool.getConnection(driver, url, username, password);
      return conn;
   }

   public List<Map<String, String>> getSyncPrimary(String taskid, String sourcename, String targetname) {
      List<Map<String, String>> list = new ArrayList();
      List<TCoreMaskingTable> slist = this.tCoreMaskingTableDao.queryAll(new Criterion[]{Restrictions.eq("datadirection", EmaskingDirection.DATA_SOURCE.getFlag()), Restrictions.eq("taskid", taskid), Restrictions.eq("tablename", sourcename)});
      if (slist.isEmpty()) {
         return null;
      } else {
         List<TCoreMaskingTablecolumn> sclist = this.tCoreMaskingTablecolumnDao.queryAll(new Criterion[]{Restrictions.eq("tableid", ((TCoreMaskingTable)slist.get(0)).getId())});
         Connection sconn = this.getConnectionByDataSystemId(((TCoreMaskingTable)slist.get(0)).getDatasystemid());
         List<String> sprimarykey = PrimaryKeyInfo.getPrimaryKeyList(sconn, ((TCoreMaskingTable)slist.get(0)).getDbschema(), ((TCoreMaskingTable)slist.get(0)).getTablename());
         JdbcTool.closeConnection(sconn);
         if (sprimarykey != null && !sprimarykey.isEmpty()) {
            List<Map<String, String>> splist = new ArrayList();

            for(String str : sprimarykey) {
               for(TCoreMaskingTablecolumn t : sclist) {
                  if (str.equals(t.getColumnname())) {
                     Map<String, String> smap = new HashMap();
                     smap.put("columnname", str);
                     smap.put("mappingkey", t.getMappingkey());
                     splist.add(smap);
                     break;
                  }
               }
            }

            List<TCoreMaskingTable> tlist = this.tCoreMaskingTableDao.queryAll(new Criterion[]{Restrictions.eq("datadirection", EmaskingDirection.DATA_TARGET.getFlag()), Restrictions.eq("taskid", taskid), Restrictions.eq("tablename", targetname)});
            Connection tconn = this.getConnectionByDataSystemId(((TCoreMaskingTable)tlist.get(0)).getDatasystemid());
            List<String> tprimarykey = PrimaryKeyInfo.getPrimaryKeyList(tconn, ((TCoreMaskingTable)tlist.get(0)).getDbschema(), ((TCoreMaskingTable)tlist.get(0)).getTablename());
            JdbcTool.closeConnection(tconn);
            if (tprimarykey != null && !tprimarykey.isEmpty()) {
               for(Map<String, String> item : splist) {
                  Map<String, String> map = new HashMap();
                  List<TCoreMaskingTablecolumn> tclist = this.tCoreMaskingTablecolumnDao.queryAll(new Criterion[]{Restrictions.eq("mappingkey", item.get("mappingkey"))});
                  Boolean b = tprimarykey.contains(((TCoreMaskingTablecolumn)tclist.get(0)).getColumnname());
                  map.put("name", item.get("columnname"));
                  map.put("state", b.toString());
                  list.add(map);
               }

               return list;
            } else {
               for(String str : sprimarykey) {
                  Map<String, String> map = new HashMap();
                  map.put("name", str);
                  map.put("state", "false");
                  list.add(map);
               }

               return list;
            }
         } else {
            return null;
         }
      }
   }

   public List<Map<String, String>> getSyncIndex(String taskid, String sourcename, String targetname) {
      List<Map<String, String>> list = new ArrayList();
      List<TCoreMaskingTable> slist = this.tCoreMaskingTableDao.queryAll(new Criterion[]{Restrictions.eq("datadirection", EmaskingDirection.DATA_SOURCE.getFlag()), Restrictions.eq("taskid", taskid), Restrictions.eq("tablename", sourcename)});
      if (slist.isEmpty()) {
         return null;
      } else {
         List<TCoreMaskingTablecolumn> sclist = this.tCoreMaskingTablecolumnDao.queryAll(new Criterion[]{Restrictions.eq("tableid", ((TCoreMaskingTable)slist.get(0)).getId())});
         Connection sconn = this.getConnectionByDataSystemId(((TCoreMaskingTable)slist.get(0)).getDatasystemid());
         List<String> sindex = IndexInfo.getIndexInfoList(sconn, ((TCoreMaskingTable)slist.get(0)).getDbschema(), ((TCoreMaskingTable)slist.get(0)).getTablename());
         JdbcTool.closeConnection(sconn);
         if (sindex != null && !sindex.isEmpty()) {
            List<Map<String, String>> splist = new ArrayList();

            for(String str : sindex) {
               for(TCoreMaskingTablecolumn t : sclist) {
                  if (str.equals(t.getColumnname())) {
                     Map<String, String> smap = new HashMap();
                     smap.put("columnname", str);
                     smap.put("mappingkey", t.getMappingkey());
                     splist.add(smap);
                     break;
                  }
               }
            }

            List<TCoreMaskingTable> tlist = this.tCoreMaskingTableDao.queryAll(new Criterion[]{Restrictions.eq("datadirection", EmaskingDirection.DATA_TARGET.getFlag()), Restrictions.eq("taskid", taskid), Restrictions.eq("tablename", targetname)});
            Connection tconn = this.getConnectionByDataSystemId(((TCoreMaskingTable)tlist.get(0)).getDatasystemid());
            List<String> tindex = IndexInfo.getIndexInfoList(tconn, ((TCoreMaskingTable)tlist.get(0)).getDbschema(), ((TCoreMaskingTable)tlist.get(0)).getTablename());
            JdbcTool.closeConnection(tconn);
            if (tindex != null && !tindex.isEmpty()) {
               for(Map<String, String> item : splist) {
                  Map<String, String> map = new HashMap();
                  List<TCoreMaskingTablecolumn> tclist = this.tCoreMaskingTablecolumnDao.queryAll(new Criterion[]{Restrictions.eq("mappingkey", item.get("mappingkey"))});
                  Boolean b = tindex.contains(((TCoreMaskingTablecolumn)tclist.get(0)).getColumnname());
                  map.put("name", item.get("columnname"));
                  map.put("state", b.toString());
                  list.add(map);
               }

               return list;
            } else {
               for(String str : sindex) {
                  Map<String, String> map = new HashMap();
                  map.put("name", str);
                  map.put("state", "false");
                  list.add(map);
               }

               return list;
            }
         } else {
            return null;
         }
      }
   }

   public TCoreSyncKeyindex getSyncKeyIndex(String taskid, String sourcename) {
      TCoreSyncKeyindex tCoreSyncKeyindex = (TCoreSyncKeyindex)this.tCoreSyncKeyindexDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("tasktableid", sourcename)});
      return tCoreSyncKeyindex;
   }
}
